// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-simulator-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/disasm-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define __ masm.
#define BUF_SIZE (4096)

#ifdef VIXL_INCLUDE_SIMULATOR_AARCH32
// Run tests with the simulator.

#define SETUP() MacroAssembler masm(BUF_SIZE)

#define START() masm.GetBuffer()->Reset()

#define END() \
  __ Hlt(0);  \
  __ FinalizeCode();

// TODO: Run the tests in the simulator.
#define RUN()

#else  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32.

#define SETUP()                  \
  MacroAssembler masm(BUF_SIZE); \
  UseScratchRegisterScope harness_scratch;

#define START()                 \
  harness_scratch.Open(&masm);  \
  harness_scratch.ExcludeAll(); \
  masm.GetBuffer()->Reset();    \
  __ Push(r4);                  \
  __ Push(r5);                  \
  __ Push(r6);                  \
  __ Push(r7);                  \
  __ Push(r8);                  \
  __ Push(r9);                  \
  __ Push(r10);                 \
  __ Push(r11);                 \
  __ Push(lr);                  \
  harness_scratch.Include(ip);

#define END()                  \
  harness_scratch.Exclude(ip); \
  __ Pop(lr);                  \
  __ Pop(r11);                 \
  __ Pop(r10);                 \
  __ Pop(r9);                  \
  __ Pop(r8);                  \
  __ Pop(r7);                  \
  __ Pop(r6);                  \
  __ Pop(r5);                  \
  __ Pop(r4);                  \
  __ Bx(lr);                   \
  __ FinalizeCode();           \
  harness_scratch.Close();

#define RUN()                                                 \
  {                                                           \
    int pcs_offset = masm.IsUsingT32() ? 1 : 0;               \
    masm.GetBuffer()->SetExecutable();                        \
    ExecuteMemory(masm.GetBuffer()->GetStartAddress<byte*>(), \
                  masm.GetSizeOfCodeGenerated(),              \
                  pcs_offset);                                \
    masm.GetBuffer()->SetWritable();                          \
  }

#endif  // ifdef VIXL_INCLUDE_SIMULATOR_AARCH32

namespace vixl {
namespace aarch32 {

// List of instruction encodings:
#define FOREACH_INSTRUCTION(M) \
  M(Ldr)                       \
  M(Ldrb)                      \
  M(Str)                       \
  M(Strb)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` and
// `Inputs` have various layouts across generated tests so they absolutely
// cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Sign sign;
  int32_t offset;
  AddrMode addr_mode;
};

// Input data to feed to the instruction.
struct Inputs {
  uint32_t apsr;
  uint32_t rd;
  uint32_t memop[2];
};

// This structure contains all input data needed to test one specific encoding.
// It used to generate a loop over an instruction.
struct TestLoopData {
  // The `operands` fields represents the values to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
  // Array of values to be fed to the instruction.
  size_t input_size;
  const Inputs* inputs;
};

static const Inputs kCondition[] = {{NFlag, 0xabababab, {0, 0x77777777}},
                                    {ZFlag, 0xabababab, {0, 0x77777777}},
                                    {CFlag, 0xabababab, {0, 0x77777777}},
                                    {VFlag, 0xabababab, {0, 0x77777777}},
                                    {NZFlag, 0xabababab, {0, 0x77777777}},
                                    {NCFlag, 0xabababab, {0, 0x77777777}},
                                    {NVFlag, 0xabababab, {0, 0x77777777}},
                                    {ZCFlag, 0xabababab, {0, 0x77777777}},
                                    {ZVFlag, 0xabababab, {0, 0x77777777}},
                                    {CVFlag, 0xabababab, {0, 0x77777777}},
                                    {NZCFlag, 0xabababab, {0, 0x77777777}},
                                    {NZVFlag, 0xabababab, {0, 0x77777777}},
                                    {NCVFlag, 0xabababab, {0, 0x77777777}},
                                    {ZCVFlag, 0xabababab, {0, 0x77777777}},
                                    {NZCVFlag, 0xabababab, {0, 0x77777777}}};

static const Inputs kPositiveOffset[] = {{NoFlag, 0x00000000, {0, 0x0badbeef}},
                                         {NoFlag, 0x00000020, {0, 0x0badbeef}},
                                         {NoFlag, 0x00000020, {0, 0x55555555}},
                                         {NoFlag, 0x33333333, {0, 0x0badbeef}},
                                         {NoFlag, 0x00000002, {0, 0x0cabba9e}},
                                         {NoFlag, 0x7fffffff, {0, 0x0cabba9e}},
                                         {NoFlag, 0xcccccccc, {0, 0x77777777}},
                                         {NoFlag, 0x7ffffffd, {0, 0x55555555}},
                                         {NoFlag, 0xffffff83, {0, 0x77777777}},
                                         {NoFlag, 0xaaaaaaaa, {0, 0x77777777}}};

static const Inputs kNegativeOffset[] = {{NoFlag, 0xcccccccc, {0, 0x0badbeef}},
                                         {NoFlag, 0x0000007f, {0, 0x0cabba9e}},
                                         {NoFlag, 0x00007ffe, {0, 0x55555555}},
                                         {NoFlag, 0xffffffff, {0, 0x0cabba9e}},
                                         {NoFlag, 0x00007ffd, {0, 0x77777777}},
                                         {NoFlag, 0x0000007d, {0, 0x0badbeef}},
                                         {NoFlag, 0xffff8001, {0, 0x0cabba9e}},
                                         {NoFlag, 0xaaaaaaaa, {0, 0x55555555}},
                                         {NoFlag, 0x55555555, {0, 0x0badbeef}},
                                         {NoFlag, 0xffffff82, {0, 0x77777777}}};

static const Inputs kPositivePostIndex[] =
    {{NoFlag, 0xffff8003, {0, 0x77777777}},
     {NoFlag, 0xfffffffd, {0, 0x55555555}},
     {NoFlag, 0xffffff83, {0, 0x0cabba9e}},
     {NoFlag, 0x7ffffffd, {0, 0x0badbeef}},
     {NoFlag, 0xcccccccc, {0, 0x55555555}},
     {NoFlag, 0x00007ffd, {0, 0x55555555}},
     {NoFlag, 0x00007fff, {0, 0x0badbeef}},
     {NoFlag, 0x00000020, {0, 0x77777777}},
     {NoFlag, 0x80000000, {0, 0x0cabba9e}},
     {NoFlag, 0x80000001, {0, 0x0badbeef}}};

static const Inputs kNegativePostIndex[] =
    {{NoFlag, 0x80000001, {0, 0x77777777}},
     {NoFlag, 0x7ffffffe, {0, 0x0badbeef}},
     {NoFlag, 0x0000007d, {0, 0x0badbeef}},
     {NoFlag, 0x0000007d, {0, 0x77777777}},
     {NoFlag, 0xcccccccc, {0, 0x77777777}},
     {NoFlag, 0xffff8003, {0, 0x77777777}},
     {NoFlag, 0x00000001, {0, 0x77777777}},
     {NoFlag, 0xffff8003, {0, 0x0badbeef}},
     {NoFlag, 0xffff8000, {0, 0x0badbeef}},
     {NoFlag, 0xffffff80, {0, 0x0badbeef}}};

static const Inputs kPositivePreIndex[] =
    {{NoFlag, 0xffff8003, {0, 0x55555555}},
     {NoFlag, 0x7ffffffd, {0, 0x55555555}},
     {NoFlag, 0x33333333, {0, 0x77777777}},
     {NoFlag, 0xcccccccc, {0, 0x0cabba9e}},
     {NoFlag, 0xffffffff, {0, 0x0cabba9e}},
     {NoFlag, 0x33333333, {0, 0x55555555}},
     {NoFlag, 0xffffff82, {0, 0x77777777}},
     {NoFlag, 0x55555555, {0, 0x0cabba9e}},
     {NoFlag, 0xfffffffe, {0, 0x77777777}},
     {NoFlag, 0x0000007e, {0, 0x0cabba9e}}};

static const Inputs kNegativePreIndex[] =
    {{NoFlag, 0x00007ffd, {0, 0x0badbeef}},
     {NoFlag, 0xffffffff, {0, 0x77777777}},
     {NoFlag, 0x00000002, {0, 0x0cabba9e}},
     {NoFlag, 0xfffffffd, {0, 0x0cabba9e}},
     {NoFlag, 0x7ffffffd, {0, 0x77777777}},
     {NoFlag, 0xffffffff, {0, 0x55555555}},
     {NoFlag, 0x00007ffe, {0, 0x77777777}},
     {NoFlag, 0xffffff82, {0, 0x0cabba9e}},
     {NoFlag, 0x0000007e, {0, 0x55555555}},
     {NoFlag, 0x7ffffffe, {0, 0x77777777}}};


// A loop will be generated for each element of this array.
const TestLoopData kTests[] =
    {{{eq, r0, r1, plus, 0, Offset},
      "eq r0 r1 plus 0 Offset",
      "Condition_eq_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ne, r0, r1, plus, 0, Offset},
      "ne r0 r1 plus 0 Offset",
      "Condition_ne_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cs, r0, r1, plus, 0, Offset},
      "cs r0 r1 plus 0 Offset",
      "Condition_cs_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{cc, r0, r1, plus, 0, Offset},
      "cc r0 r1 plus 0 Offset",
      "Condition_cc_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{mi, r0, r1, plus, 0, Offset},
      "mi r0 r1 plus 0 Offset",
      "Condition_mi_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{pl, r0, r1, plus, 0, Offset},
      "pl r0 r1 plus 0 Offset",
      "Condition_pl_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vs, r0, r1, plus, 0, Offset},
      "vs r0 r1 plus 0 Offset",
      "Condition_vs_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{vc, r0, r1, plus, 0, Offset},
      "vc r0 r1 plus 0 Offset",
      "Condition_vc_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{hi, r0, r1, plus, 0, Offset},
      "hi r0 r1 plus 0 Offset",
      "Condition_hi_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ls, r0, r1, plus, 0, Offset},
      "ls r0 r1 plus 0 Offset",
      "Condition_ls_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{ge, r0, r1, plus, 0, Offset},
      "ge r0 r1 plus 0 Offset",
      "Condition_ge_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{lt, r0, r1, plus, 0, Offset},
      "lt r0 r1 plus 0 Offset",
      "Condition_lt_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{gt, r0, r1, plus, 0, Offset},
      "gt r0 r1 plus 0 Offset",
      "Condition_gt_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{le, r0, r1, plus, 0, Offset},
      "le r0 r1 plus 0 Offset",
      "Condition_le_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r0, r1, plus, 0, Offset},
      "al r0 r1 plus 0 Offset",
      "Condition_al_r0_r1_plus_0_Offset",
      ARRAY_SIZE(kCondition),
      kCondition},
     {{al, r0, r6, plus, 2582, Offset},
      "al r0 r6 plus 2582 Offset",
      "PositiveOffset_al_r0_r6_plus_2582_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r5, plus, 0, Offset},
      "al r2 r5 plus 0 Offset",
      "PositiveOffset_al_r2_r5_plus_0_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r1, plus, 3989, Offset},
      "al r2 r1 plus 3989 Offset",
      "PositiveOffset_al_r2_r1_plus_3989_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r10, plus, 1892, Offset},
      "al r6 r10 plus 1892 Offset",
      "PositiveOffset_al_r6_r10_plus_1892_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r12, plus, 1677, Offset},
      "al r1 r12 plus 1677 Offset",
      "PositiveOffset_al_r1_r12_plus_1677_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r4, plus, 3015, Offset},
      "al r9 r4 plus 3015 Offset",
      "PositiveOffset_al_r9_r4_plus_3015_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r4, plus, 1231, Offset},
      "al r11 r4 plus 1231 Offset",
      "PositiveOffset_al_r11_r4_plus_1231_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r10, plus, 523, Offset},
      "al r7 r10 plus 523 Offset",
      "PositiveOffset_al_r7_r10_plus_523_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r9, plus, 1485, Offset},
      "al r10 r9 plus 1485 Offset",
      "PositiveOffset_al_r10_r9_plus_1485_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r0, plus, 1924, Offset},
      "al r11 r0 plus 1924 Offset",
      "PositiveOffset_al_r11_r0_plus_1924_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r2, plus, 670, Offset},
      "al r9 r2 plus 670 Offset",
      "PositiveOffset_al_r9_r2_plus_670_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r7, plus, 3417, Offset},
      "al r2 r7 plus 3417 Offset",
      "PositiveOffset_al_r2_r7_plus_3417_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r5, plus, 470, Offset},
      "al r1 r5 plus 470 Offset",
      "PositiveOffset_al_r1_r5_plus_470_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r11, plus, 1660, Offset},
      "al r5 r11 plus 1660 Offset",
      "PositiveOffset_al_r5_r11_plus_1660_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r6, plus, 3978, Offset},
      "al r8 r6 plus 3978 Offset",
      "PositiveOffset_al_r8_r6_plus_3978_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r3, plus, 3739, Offset},
      "al r4 r3 plus 3739 Offset",
      "PositiveOffset_al_r4_r3_plus_3739_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r4, plus, 3787, Offset},
      "al r14 r4 plus 3787 Offset",
      "PositiveOffset_al_r14_r4_plus_3787_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r0, plus, 732, Offset},
      "al r12 r0 plus 732 Offset",
      "PositiveOffset_al_r12_r0_plus_732_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r14, plus, 3625, Offset},
      "al r10 r14 plus 3625 Offset",
      "PositiveOffset_al_r10_r14_plus_3625_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r1, plus, 2451, Offset},
      "al r3 r1 plus 2451 Offset",
      "PositiveOffset_al_r3_r1_plus_2451_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r6, plus, 1241, Offset},
      "al r0 r6 plus 1241 Offset",
      "PositiveOffset_al_r0_r6_plus_1241_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r4, plus, 2040, Offset},
      "al r5 r4 plus 2040 Offset",
      "PositiveOffset_al_r5_r4_plus_2040_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r12, plus, 251, Offset},
      "al r9 r12 plus 251 Offset",
      "PositiveOffset_al_r9_r12_plus_251_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r14, plus, 3765, Offset},
      "al r11 r14 plus 3765 Offset",
      "PositiveOffset_al_r11_r14_plus_3765_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r0, plus, 3028, Offset},
      "al r6 r0 plus 3028 Offset",
      "PositiveOffset_al_r6_r0_plus_3028_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r7, plus, 1872, Offset},
      "al r14 r7 plus 1872 Offset",
      "PositiveOffset_al_r14_r7_plus_1872_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r11, plus, 3450, Offset},
      "al r0 r11 plus 3450 Offset",
      "PositiveOffset_al_r0_r11_plus_3450_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r7, plus, 3717, Offset},
      "al r12 r7 plus 3717 Offset",
      "PositiveOffset_al_r12_r7_plus_3717_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r3, plus, 2011, Offset},
      "al r9 r3 plus 2011 Offset",
      "PositiveOffset_al_r9_r3_plus_2011_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r6, plus, 1399, Offset},
      "al r1 r6 plus 1399 Offset",
      "PositiveOffset_al_r1_r6_plus_1399_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r6, plus, 2546, Offset},
      "al r3 r6 plus 2546 Offset",
      "PositiveOffset_al_r3_r6_plus_2546_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r2, plus, 850, Offset},
      "al r1 r2 plus 850 Offset",
      "PositiveOffset_al_r1_r2_plus_850_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r10, plus, 371, Offset},
      "al r4 r10 plus 371 Offset",
      "PositiveOffset_al_r4_r10_plus_371_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r10, plus, 2240, Offset},
      "al r5 r10 plus 2240 Offset",
      "PositiveOffset_al_r5_r10_plus_2240_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r9, plus, 712, Offset},
      "al r5 r9 plus 712 Offset",
      "PositiveOffset_al_r5_r9_plus_712_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r7, plus, 2025, Offset},
      "al r14 r7 plus 2025 Offset",
      "PositiveOffset_al_r14_r7_plus_2025_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r3, plus, 595, Offset},
      "al r0 r3 plus 595 Offset",
      "PositiveOffset_al_r0_r3_plus_595_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r3, plus, 1459, Offset},
      "al r14 r3 plus 1459 Offset",
      "PositiveOffset_al_r14_r3_plus_1459_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r7, plus, 582, Offset},
      "al r12 r7 plus 582 Offset",
      "PositiveOffset_al_r12_r7_plus_582_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r10, plus, 3282, Offset},
      "al r7 r10 plus 3282 Offset",
      "PositiveOffset_al_r7_r10_plus_3282_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r3, plus, 674, Offset},
      "al r14 r3 plus 674 Offset",
      "PositiveOffset_al_r14_r3_plus_674_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r1, plus, 72, Offset},
      "al r10 r1 plus 72 Offset",
      "PositiveOffset_al_r10_r1_plus_72_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r7, plus, 3702, Offset},
      "al r1 r7 plus 3702 Offset",
      "PositiveOffset_al_r1_r7_plus_3702_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r5, plus, 932, Offset},
      "al r3 r5 plus 932 Offset",
      "PositiveOffset_al_r3_r5_plus_932_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r9, plus, 233, Offset},
      "al r0 r9 plus 233 Offset",
      "PositiveOffset_al_r0_r9_plus_233_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r5, plus, 523, Offset},
      "al r0 r5 plus 523 Offset",
      "PositiveOffset_al_r0_r5_plus_523_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r14, r9, plus, 844, Offset},
      "al r14 r9 plus 844 Offset",
      "PositiveOffset_al_r14_r9_plus_844_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r5, plus, 1459, Offset},
      "al r6 r5 plus 1459 Offset",
      "PositiveOffset_al_r6_r5_plus_1459_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r14, plus, 3384, Offset},
      "al r10 r14 plus 3384 Offset",
      "PositiveOffset_al_r10_r14_plus_3384_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r12, plus, 2345, Offset},
      "al r4 r12 plus 2345 Offset",
      "PositiveOffset_al_r4_r12_plus_2345_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r9, plus, 1642, Offset},
      "al r11 r9 plus 1642 Offset",
      "PositiveOffset_al_r11_r9_plus_1642_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r7, plus, 2901, Offset},
      "al r3 r7 plus 2901 Offset",
      "PositiveOffset_al_r3_r7_plus_2901_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r3, plus, 1934, Offset},
      "al r4 r3 plus 1934 Offset",
      "PositiveOffset_al_r4_r3_plus_1934_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r4, plus, 3952, Offset},
      "al r8 r4 plus 3952 Offset",
      "PositiveOffset_al_r8_r4_plus_3952_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r0, plus, 2710, Offset},
      "al r5 r0 plus 2710 Offset",
      "PositiveOffset_al_r5_r0_plus_2710_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r2, plus, 270, Offset},
      "al r12 r2 plus 270 Offset",
      "PositiveOffset_al_r12_r2_plus_270_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r2, plus, 132, Offset},
      "al r9 r2 plus 132 Offset",
      "PositiveOffset_al_r9_r2_plus_132_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r5, plus, 19, Offset},
      "al r11 r5 plus 19 Offset",
      "PositiveOffset_al_r11_r5_plus_19_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r14, plus, 1848, Offset},
      "al r7 r14 plus 1848 Offset",
      "PositiveOffset_al_r7_r14_plus_1848_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r10, plus, 977, Offset},
      "al r6 r10 plus 977 Offset",
      "PositiveOffset_al_r6_r10_plus_977_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r8, plus, 3239, Offset},
      "al r10 r8 plus 3239 Offset",
      "PositiveOffset_al_r10_r8_plus_3239_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r0, plus, 1295, Offset},
      "al r7 r0 plus 1295 Offset",
      "PositiveOffset_al_r7_r0_plus_1295_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r5, plus, 517, Offset},
      "al r9 r5 plus 517 Offset",
      "PositiveOffset_al_r9_r5_plus_517_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r8, plus, 3071, Offset},
      "al r12 r8 plus 3071 Offset",
      "PositiveOffset_al_r12_r8_plus_3071_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r6, plus, 3194, Offset},
      "al r5 r6 plus 3194 Offset",
      "PositiveOffset_al_r5_r6_plus_3194_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r10, r2, plus, 198, Offset},
      "al r10 r2 plus 198 Offset",
      "PositiveOffset_al_r10_r2_plus_198_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r3, plus, 565, Offset},
      "al r8 r3 plus 565 Offset",
      "PositiveOffset_al_r8_r3_plus_565_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r0, plus, 3399, Offset},
      "al r7 r0 plus 3399 Offset",
      "PositiveOffset_al_r7_r0_plus_3399_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r1, plus, 1916, Offset},
      "al r7 r1 plus 1916 Offset",
      "PositiveOffset_al_r7_r1_plus_1916_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r9, plus, 263, Offset},
      "al r3 r9 plus 263 Offset",
      "PositiveOffset_al_r3_r9_plus_263_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r1, plus, 3772, Offset},
      "al r3 r1 plus 3772 Offset",
      "PositiveOffset_al_r3_r1_plus_3772_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r2, plus, 2906, Offset},
      "al r9 r2 plus 2906 Offset",
      "PositiveOffset_al_r9_r2_plus_2906_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r0, plus, 2451, Offset},
      "al r12 r0 plus 2451 Offset",
      "PositiveOffset_al_r12_r0_plus_2451_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r0, plus, 689, Offset},
      "al r8 r0 plus 689 Offset",
      "PositiveOffset_al_r8_r0_plus_689_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r9, plus, 3063, Offset},
      "al r0 r9 plus 3063 Offset",
      "PositiveOffset_al_r0_r9_plus_3063_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r4, plus, 932, Offset},
      "al r3 r4 plus 932 Offset",
      "PositiveOffset_al_r3_r4_plus_932_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r10, plus, 704, Offset},
      "al r12 r10 plus 704 Offset",
      "PositiveOffset_al_r12_r10_plus_704_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r4, plus, 2374, Offset},
      "al r8 r4 plus 2374 Offset",
      "PositiveOffset_al_r8_r4_plus_2374_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r12, r9, plus, 2345, Offset},
      "al r12 r9 plus 2345 Offset",
      "PositiveOffset_al_r12_r9_plus_2345_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r1, plus, 2651, Offset},
      "al r6 r1 plus 2651 Offset",
      "PositiveOffset_al_r6_r1_plus_2651_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r3, plus, 998, Offset},
      "al r0 r3 plus 998 Offset",
      "PositiveOffset_al_r0_r3_plus_998_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r11, plus, 679, Offset},
      "al r8 r11 plus 679 Offset",
      "PositiveOffset_al_r8_r11_plus_679_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r1, plus, 2945, Offset},
      "al r5 r1 plus 2945 Offset",
      "PositiveOffset_al_r5_r1_plus_2945_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r9, plus, 3439, Offset},
      "al r2 r9 plus 3439 Offset",
      "PositiveOffset_al_r2_r9_plus_3439_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r8, r10, plus, 3636, Offset},
      "al r8 r10 plus 3636 Offset",
      "PositiveOffset_al_r8_r10_plus_3636_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r12, plus, 3986, Offset},
      "al r11 r12 plus 3986 Offset",
      "PositiveOffset_al_r11_r12_plus_3986_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r6, r8, plus, 2240, Offset},
      "al r6 r8 plus 2240 Offset",
      "PositiveOffset_al_r6_r8_plus_2240_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r8, plus, 1961, Offset},
      "al r11 r8 plus 1961 Offset",
      "PositiveOffset_al_r11_r8_plus_1961_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r5, r6, plus, 1536, Offset},
      "al r5 r6 plus 1536 Offset",
      "PositiveOffset_al_r5_r6_plus_1536_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r12, plus, 1759, Offset},
      "al r0 r12 plus 1759 Offset",
      "PositiveOffset_al_r0_r12_plus_1759_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r1, plus, 1266, Offset},
      "al r7 r1 plus 1266 Offset",
      "PositiveOffset_al_r7_r1_plus_1266_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r4, plus, 1017, Offset},
      "al r1 r4 plus 1017 Offset",
      "PositiveOffset_al_r1_r4_plus_1017_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r9, r3, plus, 2224, Offset},
      "al r9 r3 plus 2224 Offset",
      "PositiveOffset_al_r9_r3_plus_2224_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r2, r9, plus, 3078, Offset},
      "al r2 r9 plus 3078 Offset",
      "PositiveOffset_al_r2_r9_plus_3078_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r7, r2, plus, 2690, Offset},
      "al r7 r2 plus 2690 Offset",
      "PositiveOffset_al_r7_r2_plus_2690_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r3, r0, plus, 3078, Offset},
      "al r3 r0 plus 3078 Offset",
      "PositiveOffset_al_r3_r0_plus_3078_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r4, r12, plus, 1017, Offset},
      "al r4 r12 plus 1017 Offset",
      "PositiveOffset_al_r4_r12_plus_1017_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r5, plus, 3787, Offset},
      "al r0 r5 plus 3787 Offset",
      "PositiveOffset_al_r0_r5_plus_3787_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r0, r10, plus, 342, Offset},
      "al r0 r10 plus 342 Offset",
      "PositiveOffset_al_r0_r10_plus_342_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r1, r2, plus, 1097, Offset},
      "al r1 r2 plus 1097 Offset",
      "PositiveOffset_al_r1_r2_plus_1097_Offset",
      ARRAY_SIZE(kPositiveOffset),
      kPositiveOffset},
     {{al, r11, r8, minus, 4065, Offset},
      "al r11 r8 minus 4065 Offset",
      "NegativeOffset_al_r11_r8_minus_4065_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r5, minus, 1459, Offset},
      "al r4 r5 minus 1459 Offset",
      "NegativeOffset_al_r4_r5_minus_1459_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r3, minus, 1867, Offset},
      "al r5 r3 minus 1867 Offset",
      "NegativeOffset_al_r5_r3_minus_1867_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r9, minus, 1537, Offset},
      "al r11 r9 minus 1537 Offset",
      "NegativeOffset_al_r11_r9_minus_1537_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r8, minus, 421, Offset},
      "al r4 r8 minus 421 Offset",
      "NegativeOffset_al_r4_r8_minus_421_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r12, minus, 3625, Offset},
      "al r2 r12 minus 3625 Offset",
      "NegativeOffset_al_r2_r12_minus_3625_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r1, minus, 1536, Offset},
      "al r14 r1 minus 1536 Offset",
      "NegativeOffset_al_r14_r1_minus_1536_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r12, minus, 3397, Offset},
      "al r10 r12 minus 3397 Offset",
      "NegativeOffset_al_r10_r12_minus_3397_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r2, minus, 3450, Offset},
      "al r7 r2 minus 3450 Offset",
      "NegativeOffset_al_r7_r2_minus_3450_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r14, minus, 1551, Offset},
      "al r10 r14 minus 1551 Offset",
      "NegativeOffset_al_r10_r14_minus_1551_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r5, minus, 3625, Offset},
      "al r11 r5 minus 3625 Offset",
      "NegativeOffset_al_r11_r5_minus_3625_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r11, minus, 3633, Offset},
      "al r9 r11 minus 3633 Offset",
      "NegativeOffset_al_r9_r11_minus_3633_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r6, minus, 2490, Offset},
      "al r9 r6 minus 2490 Offset",
      "NegativeOffset_al_r9_r6_minus_2490_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r12, minus, 3003, Offset},
      "al r14 r12 minus 3003 Offset",
      "NegativeOffset_al_r14_r12_minus_3003_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r10, minus, 1848, Offset},
      "al r8 r10 minus 1848 Offset",
      "NegativeOffset_al_r8_r10_minus_1848_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r6, minus, 342, Offset},
      "al r9 r6 minus 342 Offset",
      "NegativeOffset_al_r9_r6_minus_342_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r2, minus, 3254, Offset},
      "al r5 r2 minus 3254 Offset",
      "NegativeOffset_al_r5_r2_minus_3254_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r5, minus, 2233, Offset},
      "al r0 r5 minus 2233 Offset",
      "NegativeOffset_al_r0_r5_minus_2233_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r1, minus, 3608, Offset},
      "al r2 r1 minus 3608 Offset",
      "NegativeOffset_al_r2_r1_minus_3608_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r5, minus, 624, Offset},
      "al r7 r5 minus 624 Offset",
      "NegativeOffset_al_r7_r5_minus_624_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r5, minus, 3774, Offset},
      "al r11 r5 minus 3774 Offset",
      "NegativeOffset_al_r11_r5_minus_3774_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r6, minus, 2427, Offset},
      "al r3 r6 minus 2427 Offset",
      "NegativeOffset_al_r3_r6_minus_2427_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r8, minus, 322, Offset},
      "al r7 r8 minus 322 Offset",
      "NegativeOffset_al_r7_r8_minus_322_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r8, minus, 3626, Offset},
      "al r5 r8 minus 3626 Offset",
      "NegativeOffset_al_r5_r8_minus_3626_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r11, minus, 1867, Offset},
      "al r3 r11 minus 1867 Offset",
      "NegativeOffset_al_r3_r11_minus_1867_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r12, minus, 2864, Offset},
      "al r14 r12 minus 2864 Offset",
      "NegativeOffset_al_r14_r12_minus_2864_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r9, minus, 4018, Offset},
      "al r5 r9 minus 4018 Offset",
      "NegativeOffset_al_r5_r9_minus_4018_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r2, minus, 1231, Offset},
      "al r3 r2 minus 1231 Offset",
      "NegativeOffset_al_r3_r2_minus_1231_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r3, minus, 601, Offset},
      "al r2 r3 minus 601 Offset",
      "NegativeOffset_al_r2_r3_minus_601_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r2, minus, 263, Offset},
      "al r0 r2 minus 263 Offset",
      "NegativeOffset_al_r0_r2_minus_263_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r8, minus, 1234, Offset},
      "al r5 r8 minus 1234 Offset",
      "NegativeOffset_al_r5_r8_minus_1234_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r10, minus, 2311, Offset},
      "al r3 r10 minus 2311 Offset",
      "NegativeOffset_al_r3_r10_minus_2311_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r1, minus, 3714, Offset},
      "al r5 r1 minus 3714 Offset",
      "NegativeOffset_al_r5_r1_minus_3714_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r1, minus, 1479, Offset},
      "al r5 r1 minus 1479 Offset",
      "NegativeOffset_al_r5_r1_minus_1479_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r12, minus, 213, Offset},
      "al r1 r12 minus 213 Offset",
      "NegativeOffset_al_r1_r12_minus_213_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r9, minus, 3071, Offset},
      "al r0 r9 minus 3071 Offset",
      "NegativeOffset_al_r0_r9_minus_3071_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r12, minus, 2, Offset},
      "al r9 r12 minus 2 Offset",
      "NegativeOffset_al_r9_r12_minus_2_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r3, minus, 831, Offset},
      "al r11 r3 minus 831 Offset",
      "NegativeOffset_al_r11_r3_minus_831_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r0, minus, 3443, Offset},
      "al r11 r0 minus 3443 Offset",
      "NegativeOffset_al_r11_r0_minus_3443_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r7, minus, 3256, Offset},
      "al r9 r7 minus 3256 Offset",
      "NegativeOffset_al_r9_r7_minus_3256_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r9, minus, 1372, Offset},
      "al r8 r9 minus 1372 Offset",
      "NegativeOffset_al_r8_r9_minus_1372_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r7, minus, 1665, Offset},
      "al r0 r7 minus 1665 Offset",
      "NegativeOffset_al_r0_r7_minus_1665_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r0, minus, 3325, Offset},
      "al r7 r0 minus 3325 Offset",
      "NegativeOffset_al_r7_r0_minus_3325_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r5, minus, 132, Offset},
      "al r4 r5 minus 132 Offset",
      "NegativeOffset_al_r4_r5_minus_132_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r10, minus, 828, Offset},
      "al r3 r10 minus 828 Offset",
      "NegativeOffset_al_r3_r10_minus_828_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r12, minus, 3002, Offset},
      "al r9 r12 minus 3002 Offset",
      "NegativeOffset_al_r9_r12_minus_3002_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r9, minus, 371, Offset},
      "al r7 r9 minus 371 Offset",
      "NegativeOffset_al_r7_r9_minus_371_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r14, minus, 2326, Offset},
      "al r5 r14 minus 2326 Offset",
      "NegativeOffset_al_r5_r14_minus_2326_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r7, minus, 811, Offset},
      "al r8 r7 minus 811 Offset",
      "NegativeOffset_al_r8_r7_minus_811_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r11, minus, 2946, Offset},
      "al r2 r11 minus 2946 Offset",
      "NegativeOffset_al_r2_r11_minus_2946_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r12, minus, 216, Offset},
      "al r11 r12 minus 216 Offset",
      "NegativeOffset_al_r11_r12_minus_216_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r12, minus, 2651, Offset},
      "al r4 r12 minus 2651 Offset",
      "NegativeOffset_al_r4_r12_minus_2651_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r5, minus, 2072, Offset},
      "al r14 r5 minus 2072 Offset",
      "NegativeOffset_al_r14_r5_minus_2072_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r4, minus, 2690, Offset},
      "al r12 r4 minus 2690 Offset",
      "NegativeOffset_al_r12_r4_minus_2690_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r9, minus, 3041, Offset},
      "al r0 r9 minus 3041 Offset",
      "NegativeOffset_al_r0_r9_minus_3041_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r6, minus, 732, Offset},
      "al r8 r6 minus 732 Offset",
      "NegativeOffset_al_r8_r6_minus_732_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r4, minus, 1567, Offset},
      "al r7 r4 minus 1567 Offset",
      "NegativeOffset_al_r7_r4_minus_1567_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r9, minus, 2036, Offset},
      "al r0 r9 minus 2036 Offset",
      "NegativeOffset_al_r0_r9_minus_2036_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r9, minus, 618, Offset},
      "al r7 r9 minus 618 Offset",
      "NegativeOffset_al_r7_r9_minus_618_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, 1437, Offset},
      "al r4 r10 minus 1437 Offset",
      "NegativeOffset_al_r4_r10_minus_1437_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r9, minus, 3105, Offset},
      "al r4 r9 minus 3105 Offset",
      "NegativeOffset_al_r4_r9_minus_3105_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r6, minus, 1116, Offset},
      "al r5 r6 minus 1116 Offset",
      "NegativeOffset_al_r5_r6_minus_1116_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r0, minus, 2892, Offset},
      "al r2 r0 minus 2892 Offset",
      "NegativeOffset_al_r2_r0_minus_2892_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r8, minus, 3069, Offset},
      "al r1 r8 minus 3069 Offset",
      "NegativeOffset_al_r1_r8_minus_3069_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r2, minus, 1498, Offset},
      "al r3 r2 minus 1498 Offset",
      "NegativeOffset_al_r3_r2_minus_1498_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r9, minus, 1999, Offset},
      "al r5 r9 minus 1999 Offset",
      "NegativeOffset_al_r5_r9_minus_1999_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r6, minus, 2588, Offset},
      "al r5 r6 minus 2588 Offset",
      "NegativeOffset_al_r5_r6_minus_2588_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r12, minus, 2792, Offset},
      "al r5 r12 minus 2792 Offset",
      "NegativeOffset_al_r5_r12_minus_2792_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r10, minus, 251, Offset},
      "al r7 r10 minus 251 Offset",
      "NegativeOffset_al_r7_r10_minus_251_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r8, minus, 3696, Offset},
      "al r6 r8 minus 3696 Offset",
      "NegativeOffset_al_r6_r8_minus_3696_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r6, minus, 3856, Offset},
      "al r7 r6 minus 3856 Offset",
      "NegativeOffset_al_r7_r6_minus_3856_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r6, minus, 233, Offset},
      "al r9 r6 minus 233 Offset",
      "NegativeOffset_al_r9_r6_minus_233_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r5, minus, 3366, Offset},
      "al r6 r5 minus 3366 Offset",
      "NegativeOffset_al_r6_r5_minus_3366_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r3, minus, 2359, Offset},
      "al r8 r3 minus 2359 Offset",
      "NegativeOffset_al_r8_r3_minus_2359_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r9, minus, 2866, Offset},
      "al r4 r9 minus 2866 Offset",
      "NegativeOffset_al_r4_r9_minus_2866_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r6, r3, minus, 2381, Offset},
      "al r6 r3 minus 2381 Offset",
      "NegativeOffset_al_r6_r3_minus_2381_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r3, minus, 3221, Offset},
      "al r5 r3 minus 3221 Offset",
      "NegativeOffset_al_r5_r3_minus_3221_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r10, r8, minus, 2036, Offset},
      "al r10 r8 minus 2036 Offset",
      "NegativeOffset_al_r10_r8_minus_2036_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r0, minus, 2591, Offset},
      "al r4 r0 minus 2591 Offset",
      "NegativeOffset_al_r4_r0_minus_2591_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, 2040, Offset},
      "al r4 r10 minus 2040 Offset",
      "NegativeOffset_al_r4_r10_minus_2040_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r7, minus, 2929, Offset},
      "al r9 r7 minus 2929 Offset",
      "NegativeOffset_al_r9_r7_minus_2929_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r14, minus, 1867, Offset},
      "al r1 r14 minus 1867 Offset",
      "NegativeOffset_al_r1_r14_minus_1867_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r0, minus, 2945, Offset},
      "al r9 r0 minus 2945 Offset",
      "NegativeOffset_al_r9_r0_minus_2945_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r3, minus, 2403, Offset},
      "al r14 r3 minus 2403 Offset",
      "NegativeOffset_al_r14_r3_minus_2403_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r8, minus, 1999, Offset},
      "al r12 r8 minus 1999 Offset",
      "NegativeOffset_al_r12_r8_minus_1999_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r5, minus, 3994, Offset},
      "al r9 r5 minus 3994 Offset",
      "NegativeOffset_al_r9_r5_minus_3994_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r3, minus, 2180, Offset},
      "al r14 r3 minus 2180 Offset",
      "NegativeOffset_al_r14_r3_minus_2180_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r5, minus, 3914, Offset},
      "al r1 r5 minus 3914 Offset",
      "NegativeOffset_al_r1_r5_minus_3914_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r10, minus, 3079, Offset},
      "al r4 r10 minus 3079 Offset",
      "NegativeOffset_al_r4_r10_minus_3079_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r8, r14, minus, 3266, Offset},
      "al r8 r14 minus 3266 Offset",
      "NegativeOffset_al_r8_r14_minus_3266_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r4, r11, minus, 1732, Offset},
      "al r4 r11 minus 1732 Offset",
      "NegativeOffset_al_r4_r11_minus_1732_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r11, r5, minus, 806, Offset},
      "al r11 r5 minus 806 Offset",
      "NegativeOffset_al_r11_r5_minus_806_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r9, r7, minus, 3039, Offset},
      "al r9 r7 minus 3039 Offset",
      "NegativeOffset_al_r9_r7_minus_3039_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r12, r9, minus, 2453, Offset},
      "al r12 r9 minus 2453 Offset",
      "NegativeOffset_al_r12_r9_minus_2453_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r0, r7, minus, 3626, Offset},
      "al r0 r7 minus 3626 Offset",
      "NegativeOffset_al_r0_r7_minus_3626_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r3, r11, minus, 1981, Offset},
      "al r3 r11 minus 1981 Offset",
      "NegativeOffset_al_r3_r11_minus_1981_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r2, r8, minus, 3082, Offset},
      "al r2 r8 minus 3082 Offset",
      "NegativeOffset_al_r2_r8_minus_3082_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r1, r11, minus, 3608, Offset},
      "al r1 r11 minus 3608 Offset",
      "NegativeOffset_al_r1_r11_minus_3608_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r5, r11, minus, 3391, Offset},
      "al r5 r11 minus 3391 Offset",
      "NegativeOffset_al_r5_r11_minus_3391_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r7, r12, minus, 872, Offset},
      "al r7 r12 minus 872 Offset",
      "NegativeOffset_al_r7_r12_minus_872_Offset",
      ARRAY_SIZE(kNegativeOffset),
      kNegativeOffset},
     {{al, r14, r11, plus, 1506, PostIndex},
      "al r14 r11 plus 1506 PostIndex",
      "PositivePostIndex_al_r14_r11_plus_1506_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r14, plus, 3399, PostIndex},
      "al r7 r14 plus 3399 PostIndex",
      "PositivePostIndex_al_r7_r14_plus_3399_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r6, plus, 2588, PostIndex},
      "al r11 r6 plus 2588 PostIndex",
      "PositivePostIndex_al_r11_r6_plus_2588_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r9, plus, 2906, PostIndex},
      "al r4 r9 plus 2906 PostIndex",
      "PositivePostIndex_al_r4_r9_plus_2906_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r8, plus, 1916, PostIndex},
      "al r4 r8 plus 1916 PostIndex",
      "PositivePostIndex_al_r4_r8_plus_1916_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r0, plus, 1835, PostIndex},
      "al r6 r0 plus 1835 PostIndex",
      "PositivePostIndex_al_r6_r0_plus_1835_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r14, plus, 2984, PostIndex},
      "al r1 r14 plus 2984 PostIndex",
      "PositivePostIndex_al_r1_r14_plus_2984_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r12, plus, 3994, PostIndex},
      "al r9 r12 plus 3994 PostIndex",
      "PositivePostIndex_al_r9_r12_plus_3994_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r5, plus, 766, PostIndex},
      "al r10 r5 plus 766 PostIndex",
      "PositivePostIndex_al_r10_r5_plus_766_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r9, plus, 188, PostIndex},
      "al r5 r9 plus 188 PostIndex",
      "PositivePostIndex_al_r5_r9_plus_188_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r14, plus, 479, PostIndex},
      "al r11 r14 plus 479 PostIndex",
      "PositivePostIndex_al_r11_r14_plus_479_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r14, plus, 2797, PostIndex},
      "al r6 r14 plus 2797 PostIndex",
      "PositivePostIndex_al_r6_r14_plus_2797_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r8, plus, 3170, PostIndex},
      "al r5 r8 plus 3170 PostIndex",
      "PositivePostIndex_al_r5_r8_plus_3170_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r2, plus, 663, PostIndex},
      "al r0 r2 plus 663 PostIndex",
      "PositivePostIndex_al_r0_r2_plus_663_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r0, plus, 1097, PostIndex},
      "al r14 r0 plus 1097 PostIndex",
      "PositivePostIndex_al_r14_r0_plus_1097_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r7, plus, 3481, PostIndex},
      "al r0 r7 plus 3481 PostIndex",
      "PositivePostIndex_al_r0_r7_plus_3481_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r2, plus, 2183, PostIndex},
      "al r5 r2 plus 2183 PostIndex",
      "PositivePostIndex_al_r5_r2_plus_2183_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r4, plus, 1948, PostIndex},
      "al r7 r4 plus 1948 PostIndex",
      "PositivePostIndex_al_r7_r4_plus_1948_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r12, plus, 2047, PostIndex},
      "al r3 r12 plus 2047 PostIndex",
      "PositivePostIndex_al_r3_r12_plus_2047_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r0, plus, 2451, PostIndex},
      "al r4 r0 plus 2451 PostIndex",
      "PositivePostIndex_al_r4_r0_plus_2451_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r4, plus, 3057, PostIndex},
      "al r1 r4 plus 3057 PostIndex",
      "PositivePostIndex_al_r1_r4_plus_3057_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r9, plus, 3308, PostIndex},
      "al r6 r9 plus 3308 PostIndex",
      "PositivePostIndex_al_r6_r9_plus_3308_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r14, plus, 2677, PostIndex},
      "al r0 r14 plus 2677 PostIndex",
      "PositivePostIndex_al_r0_r14_plus_2677_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r1, plus, 1601, PostIndex},
      "al r3 r1 plus 1601 PostIndex",
      "PositivePostIndex_al_r3_r1_plus_1601_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r1, plus, 662, PostIndex},
      "al r2 r1 plus 662 PostIndex",
      "PositivePostIndex_al_r2_r1_plus_662_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r2, plus, 1485, PostIndex},
      "al r3 r2 plus 1485 PostIndex",
      "PositivePostIndex_al_r3_r2_plus_1485_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r3, plus, 3413, PostIndex},
      "al r7 r3 plus 3413 PostIndex",
      "PositivePostIndex_al_r7_r3_plus_3413_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r4, plus, 2175, PostIndex},
      "al r9 r4 plus 2175 PostIndex",
      "PositivePostIndex_al_r9_r4_plus_2175_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r2, plus, 3517, PostIndex},
      "al r1 r2 plus 3517 PostIndex",
      "PositivePostIndex_al_r1_r2_plus_3517_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r6, plus, 2535, PostIndex},
      "al r8 r6 plus 2535 PostIndex",
      "PositivePostIndex_al_r8_r6_plus_2535_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r2, plus, 2982, PostIndex},
      "al r12 r2 plus 2982 PostIndex",
      "PositivePostIndex_al_r12_r2_plus_2982_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, 1867, PostIndex},
      "al r0 r5 plus 1867 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_1867_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r1, plus, 3209, PostIndex},
      "al r11 r1 plus 3209 PostIndex",
      "PositivePostIndex_al_r11_r1_plus_3209_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r10, plus, 977, PostIndex},
      "al r6 r10 plus 977 PostIndex",
      "PositivePostIndex_al_r6_r10_plus_977_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, 3239, PostIndex},
      "al r0 r5 plus 3239 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_3239_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r0, plus, 1808, PostIndex},
      "al r7 r0 plus 1808 PostIndex",
      "PositivePostIndex_al_r7_r0_plus_1808_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r7, plus, 3787, PostIndex},
      "al r6 r7 plus 3787 PostIndex",
      "PositivePostIndex_al_r6_r7_plus_3787_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r7, plus, 678, PostIndex},
      "al r4 r7 plus 678 PostIndex",
      "PositivePostIndex_al_r4_r7_plus_678_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r9, plus, 4090, PostIndex},
      "al r7 r9 plus 4090 PostIndex",
      "PositivePostIndex_al_r7_r9_plus_4090_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r2, plus, 1438, PostIndex},
      "al r0 r2 plus 1438 PostIndex",
      "PositivePostIndex_al_r0_r2_plus_1438_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r5, plus, 3195, PostIndex},
      "al r2 r5 plus 3195 PostIndex",
      "PositivePostIndex_al_r2_r5_plus_3195_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r2, plus, 1922, PostIndex},
      "al r8 r2 plus 1922 PostIndex",
      "PositivePostIndex_al_r8_r2_plus_1922_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r1, plus, 4095, PostIndex},
      "al r8 r1 plus 4095 PostIndex",
      "PositivePostIndex_al_r8_r1_plus_4095_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r9, plus, 1261, PostIndex},
      "al r1 r9 plus 1261 PostIndex",
      "PositivePostIndex_al_r1_r9_plus_1261_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r11, plus, 2718, PostIndex},
      "al r12 r11 plus 2718 PostIndex",
      "PositivePostIndex_al_r12_r11_plus_2718_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r0, plus, 132, PostIndex},
      "al r9 r0 plus 132 PostIndex",
      "PositivePostIndex_al_r9_r0_plus_132_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r5, plus, 1601, PostIndex},
      "al r11 r5 plus 1601 PostIndex",
      "PositivePostIndex_al_r11_r5_plus_1601_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r4, plus, 19, PostIndex},
      "al r14 r4 plus 19 PostIndex",
      "PositivePostIndex_al_r14_r4_plus_19_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r0, plus, 386, PostIndex},
      "al r6 r0 plus 386 PostIndex",
      "PositivePostIndex_al_r6_r0_plus_386_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r2, plus, 672, PostIndex},
      "al r14 r2 plus 672 PostIndex",
      "PositivePostIndex_al_r14_r2_plus_672_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r10, plus, 3626, PostIndex},
      "al r1 r10 plus 3626 PostIndex",
      "PositivePostIndex_al_r1_r10_plus_3626_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r14, plus, 2813, PostIndex},
      "al r9 r14 plus 2813 PostIndex",
      "PositivePostIndex_al_r9_r14_plus_2813_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r3, plus, 2091, PostIndex},
      "al r9 r3 plus 2091 PostIndex",
      "PositivePostIndex_al_r9_r3_plus_2091_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r3, plus, 932, PostIndex},
      "al r5 r3 plus 932 PostIndex",
      "PositivePostIndex_al_r5_r3_plus_932_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r8, plus, 970, PostIndex},
      "al r0 r8 plus 970 PostIndex",
      "PositivePostIndex_al_r0_r8_plus_970_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, 3610, PostIndex},
      "al r0 r5 plus 3610 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_3610_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r5, plus, 2180, PostIndex},
      "al r1 r5 plus 2180 PostIndex",
      "PositivePostIndex_al_r1_r5_plus_2180_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r6, plus, 3397, PostIndex},
      "al r9 r6 plus 3397 PostIndex",
      "PositivePostIndex_al_r9_r6_plus_3397_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r8, plus, 3063, PostIndex},
      "al r14 r8 plus 3063 PostIndex",
      "PositivePostIndex_al_r14_r8_plus_3063_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r3, plus, 3028, PostIndex},
      "al r10 r3 plus 3028 PostIndex",
      "PositivePostIndex_al_r10_r3_plus_3028_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r4, plus, 1099, PostIndex},
      "al r7 r4 plus 1099 PostIndex",
      "PositivePostIndex_al_r7_r4_plus_1099_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r5, plus, 2175, PostIndex},
      "al r2 r5 plus 2175 PostIndex",
      "PositivePostIndex_al_r2_r5_plus_2175_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r12, plus, 3221, PostIndex},
      "al r8 r12 plus 3221 PostIndex",
      "PositivePostIndex_al_r8_r12_plus_3221_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r1, plus, 2475, PostIndex},
      "al r4 r1 plus 2475 PostIndex",
      "PositivePostIndex_al_r4_r1_plus_2475_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r11, plus, 1009, PostIndex},
      "al r9 r11 plus 1009 PostIndex",
      "PositivePostIndex_al_r9_r11_plus_1009_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r1, plus, 1526, PostIndex},
      "al r9 r1 plus 1526 PostIndex",
      "PositivePostIndex_al_r9_r1_plus_1526_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r11, plus, 282, PostIndex},
      "al r2 r11 plus 282 PostIndex",
      "PositivePostIndex_al_r2_r11_plus_282_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r11, plus, 3583, PostIndex},
      "al r10 r11 plus 3583 PostIndex",
      "PositivePostIndex_al_r10_r11_plus_3583_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r6, plus, 3209, PostIndex},
      "al r11 r6 plus 3209 PostIndex",
      "PositivePostIndex_al_r11_r6_plus_3209_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r7, r8, plus, 1736, PostIndex},
      "al r7 r8 plus 1736 PostIndex",
      "PositivePostIndex_al_r7_r8_plus_1736_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r8, plus, 1542, PostIndex},
      "al r3 r8 plus 1542 PostIndex",
      "PositivePostIndex_al_r3_r8_plus_1542_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r4, plus, 180, PostIndex},
      "al r14 r4 plus 180 PostIndex",
      "PositivePostIndex_al_r14_r4_plus_180_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r5, plus, 3076, PostIndex},
      "al r1 r5 plus 3076 PostIndex",
      "PositivePostIndex_al_r1_r5_plus_3076_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r2, plus, 2541, PostIndex},
      "al r8 r2 plus 2541 PostIndex",
      "PositivePostIndex_al_r8_r2_plus_2541_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r2, plus, 2946, PostIndex},
      "al r4 r2 plus 2946 PostIndex",
      "PositivePostIndex_al_r4_r2_plus_2946_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r6, plus, 3743, PostIndex},
      "al r1 r6 plus 3743 PostIndex",
      "PositivePostIndex_al_r1_r6_plus_3743_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r8, plus, 3907, PostIndex},
      "al r2 r8 plus 3907 PostIndex",
      "PositivePostIndex_al_r2_r8_plus_3907_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r3, r9, plus, 791, PostIndex},
      "al r3 r9 plus 791 PostIndex",
      "PositivePostIndex_al_r3_r9_plus_791_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r5, plus, 3636, PostIndex},
      "al r12 r5 plus 3636 PostIndex",
      "PositivePostIndex_al_r12_r5_plus_3636_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r12, plus, 2545, PostIndex},
      "al r0 r12 plus 2545 PostIndex",
      "PositivePostIndex_al_r0_r12_plus_2545_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r5, plus, 3450, PostIndex},
      "al r12 r5 plus 3450 PostIndex",
      "PositivePostIndex_al_r12_r5_plus_3450_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r1, r5, plus, 1712, PostIndex},
      "al r1 r5 plus 1712 PostIndex",
      "PositivePostIndex_al_r1_r5_plus_1712_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r6, r11, plus, 2665, PostIndex},
      "al r6 r11 plus 2665 PostIndex",
      "PositivePostIndex_al_r6_r11_plus_2665_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r8, plus, 3450, PostIndex},
      "al r10 r8 plus 3450 PostIndex",
      "PositivePostIndex_al_r10_r8_plus_3450_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r9, plus, 386, PostIndex},
      "al r8 r9 plus 386 PostIndex",
      "PositivePostIndex_al_r8_r9_plus_386_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r0, plus, 2462, PostIndex},
      "al r12 r0 plus 2462 PostIndex",
      "PositivePostIndex_al_r12_r0_plus_2462_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r4, r1, plus, 3313, PostIndex},
      "al r4 r1 plus 3313 PostIndex",
      "PositivePostIndex_al_r4_r1_plus_3313_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r1, plus, 4093, PostIndex},
      "al r5 r1 plus 4093 PostIndex",
      "PositivePostIndex_al_r5_r1_plus_4093_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r6, plus, 3287, PostIndex},
      "al r5 r6 plus 3287 PostIndex",
      "PositivePostIndex_al_r5_r6_plus_3287_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r2, r14, plus, 48, PostIndex},
      "al r2 r14 plus 48 PostIndex",
      "PositivePostIndex_al_r2_r14_plus_48_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r0, plus, 484, PostIndex},
      "al r12 r0 plus 484 PostIndex",
      "PositivePostIndex_al_r12_r0_plus_484_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r9, plus, 1505, PostIndex},
      "al r10 r9 plus 1505 PostIndex",
      "PositivePostIndex_al_r10_r9_plus_1505_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r12, r11, plus, 2464, PostIndex},
      "al r12 r11 plus 2464 PostIndex",
      "PositivePostIndex_al_r12_r11_plus_2464_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r0, r5, plus, 4076, PostIndex},
      "al r0 r5 plus 4076 PostIndex",
      "PositivePostIndex_al_r0_r5_plus_4076_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r12, plus, 2326, PostIndex},
      "al r8 r12 plus 2326 PostIndex",
      "PositivePostIndex_al_r8_r12_plus_2326_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r9, r7, plus, 2025, PostIndex},
      "al r9 r7 plus 2025 PostIndex",
      "PositivePostIndex_al_r9_r7_plus_2025_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r14, r3, plus, 831, PostIndex},
      "al r14 r3 plus 831 PostIndex",
      "PositivePostIndex_al_r14_r3_plus_831_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r8, r2, plus, 136, PostIndex},
      "al r8 r2 plus 136 PostIndex",
      "PositivePostIndex_al_r8_r2_plus_136_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r11, r4, plus, 774, PostIndex},
      "al r11 r4 plus 774 PostIndex",
      "PositivePostIndex_al_r11_r4_plus_774_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r5, r10, plus, 2395, PostIndex},
      "al r5 r10 plus 2395 PostIndex",
      "PositivePostIndex_al_r5_r10_plus_2395_PostIndex",
      ARRAY_SIZE(kPositivePostIndex),
      kPositivePostIndex},
     {{al, r10, r1, minus, 2642, PostIndex},
      "al r10 r1 minus 2642 PostIndex",
      "NegativePostIndex_al_r10_r1_minus_2642_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r6, minus, 4093, PostIndex},
      "al r8 r6 minus 4093 PostIndex",
      "NegativePostIndex_al_r8_r6_minus_4093_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r11, minus, 3162, PostIndex},
      "al r2 r11 minus 3162 PostIndex",
      "NegativePostIndex_al_r2_r11_minus_3162_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r8, minus, 2311, PostIndex},
      "al r2 r8 minus 2311 PostIndex",
      "NegativePostIndex_al_r2_r8_minus_2311_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r5, minus, 806, PostIndex},
      "al r11 r5 minus 806 PostIndex",
      "NegativePostIndex_al_r11_r5_minus_806_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r11, minus, 2628, PostIndex},
      "al r14 r11 minus 2628 PostIndex",
      "NegativePostIndex_al_r14_r11_minus_2628_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r10, minus, 672, PostIndex},
      "al r0 r10 minus 672 PostIndex",
      "NegativePostIndex_al_r0_r10_minus_672_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r4, minus, 2619, PostIndex},
      "al r12 r4 minus 2619 PostIndex",
      "NegativePostIndex_al_r12_r4_minus_2619_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r8, minus, 1035, PostIndex},
      "al r11 r8 minus 1035 PostIndex",
      "NegativePostIndex_al_r11_r8_minus_1035_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r7, minus, 3771, PostIndex},
      "al r9 r7 minus 3771 PostIndex",
      "NegativePostIndex_al_r9_r7_minus_3771_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r10, minus, 1372, PostIndex},
      "al r0 r10 minus 1372 PostIndex",
      "NegativePostIndex_al_r0_r10_minus_1372_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r4, minus, 4065, PostIndex},
      "al r9 r4 minus 4065 PostIndex",
      "NegativePostIndex_al_r9_r4_minus_4065_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r5, minus, 3344, PostIndex},
      "al r10 r5 minus 3344 PostIndex",
      "NegativePostIndex_al_r10_r5_minus_3344_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r11, minus, 2726, PostIndex},
      "al r9 r11 minus 2726 PostIndex",
      "NegativePostIndex_al_r9_r11_minus_2726_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r11, minus, 3282, PostIndex},
      "al r2 r11 minus 3282 PostIndex",
      "NegativePostIndex_al_r2_r11_minus_3282_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r0, minus, 1231, PostIndex},
      "al r8 r0 minus 1231 PostIndex",
      "NegativePostIndex_al_r8_r0_minus_1231_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r8, minus, 2490, PostIndex},
      "al r12 r8 minus 2490 PostIndex",
      "NegativePostIndex_al_r12_r8_minus_2490_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r14, minus, 2963, PostIndex},
      "al r3 r14 minus 2963 PostIndex",
      "NegativePostIndex_al_r3_r14_minus_2963_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r5, minus, 3069, PostIndex},
      "al r10 r5 minus 3069 PostIndex",
      "NegativePostIndex_al_r10_r5_minus_3069_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r6, minus, 3743, PostIndex},
      "al r5 r6 minus 3743 PostIndex",
      "NegativePostIndex_al_r5_r6_minus_3743_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r0, minus, 1175, PostIndex},
      "al r10 r0 minus 1175 PostIndex",
      "NegativePostIndex_al_r10_r0_minus_1175_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r0, minus, 479, PostIndex},
      "al r14 r0 minus 479 PostIndex",
      "NegativePostIndex_al_r14_r0_minus_479_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r1, minus, 2464, PostIndex},
      "al r2 r1 minus 2464 PostIndex",
      "NegativePostIndex_al_r2_r1_minus_2464_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r6, minus, 1171, PostIndex},
      "al r7 r6 minus 1171 PostIndex",
      "NegativePostIndex_al_r7_r6_minus_1171_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r2, minus, 871, PostIndex},
      "al r14 r2 minus 871 PostIndex",
      "NegativePostIndex_al_r14_r2_minus_871_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r10, minus, 1687, PostIndex},
      "al r9 r10 minus 1687 PostIndex",
      "NegativePostIndex_al_r9_r10_minus_1687_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r1, minus, 1527, PostIndex},
      "al r3 r1 minus 1527 PostIndex",
      "NegativePostIndex_al_r3_r1_minus_1527_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r7, minus, 2365, PostIndex},
      "al r6 r7 minus 2365 PostIndex",
      "NegativePostIndex_al_r6_r7_minus_2365_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r12, minus, 2619, PostIndex},
      "al r7 r12 minus 2619 PostIndex",
      "NegativePostIndex_al_r7_r12_minus_2619_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r7, minus, 1695, PostIndex},
      "al r14 r7 minus 1695 PostIndex",
      "NegativePostIndex_al_r14_r7_minus_1695_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r8, minus, 3949, PostIndex},
      "al r3 r8 minus 3949 PostIndex",
      "NegativePostIndex_al_r3_r8_minus_3949_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r8, minus, 1359, PostIndex},
      "al r4 r8 minus 1359 PostIndex",
      "NegativePostIndex_al_r4_r8_minus_1359_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r6, minus, 3117, PostIndex},
      "al r10 r6 minus 3117 PostIndex",
      "NegativePostIndex_al_r10_r6_minus_3117_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r12, minus, 831, PostIndex},
      "al r7 r12 minus 831 PostIndex",
      "NegativePostIndex_al_r7_r12_minus_831_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r7, minus, 1537, PostIndex},
      "al r0 r7 minus 1537 PostIndex",
      "NegativePostIndex_al_r0_r7_minus_1537_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r11, minus, 1948, PostIndex},
      "al r1 r11 minus 1948 PostIndex",
      "NegativePostIndex_al_r1_r11_minus_1948_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r12, minus, 362, PostIndex},
      "al r8 r12 minus 362 PostIndex",
      "NegativePostIndex_al_r8_r12_minus_362_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r0, minus, 3583, PostIndex},
      "al r3 r0 minus 3583 PostIndex",
      "NegativePostIndex_al_r3_r0_minus_3583_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r3, minus, 2794, PostIndex},
      "al r10 r3 minus 2794 PostIndex",
      "NegativePostIndex_al_r10_r3_minus_2794_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r3, minus, 53, PostIndex},
      "al r10 r3 minus 53 PostIndex",
      "NegativePostIndex_al_r10_r3_minus_53_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r8, minus, 2026, PostIndex},
      "al r9 r8 minus 2026 PostIndex",
      "NegativePostIndex_al_r9_r8_minus_2026_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r11, minus, 3472, PostIndex},
      "al r14 r11 minus 3472 PostIndex",
      "NegativePostIndex_al_r14_r11_minus_3472_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r8, minus, 200, PostIndex},
      "al r5 r8 minus 200 PostIndex",
      "NegativePostIndex_al_r5_r8_minus_200_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r11, minus, 398, PostIndex},
      "al r9 r11 minus 398 PostIndex",
      "NegativePostIndex_al_r9_r11_minus_398_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r1, minus, 4091, PostIndex},
      "al r7 r1 minus 4091 PostIndex",
      "NegativePostIndex_al_r7_r1_minus_4091_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r7, minus, 601, PostIndex},
      "al r9 r7 minus 601 PostIndex",
      "NegativePostIndex_al_r9_r7_minus_601_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r0, minus, 2849, PostIndex},
      "al r14 r0 minus 2849 PostIndex",
      "NegativePostIndex_al_r14_r0_minus_2849_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r3, minus, 1323, PostIndex},
      "al r1 r3 minus 1323 PostIndex",
      "NegativePostIndex_al_r1_r3_minus_1323_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r9, minus, 969, PostIndex},
      "al r11 r9 minus 969 PostIndex",
      "NegativePostIndex_al_r11_r9_minus_969_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r14, minus, 2628, PostIndex},
      "al r1 r14 minus 2628 PostIndex",
      "NegativePostIndex_al_r1_r14_minus_2628_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r10, r1, minus, 251, PostIndex},
      "al r10 r1 minus 251 PostIndex",
      "NegativePostIndex_al_r10_r1_minus_251_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r2, minus, 1266, PostIndex},
      "al r1 r2 minus 1266 PostIndex",
      "NegativePostIndex_al_r1_r2_minus_1266_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r7, minus, 2588, PostIndex},
      "al r0 r7 minus 2588 PostIndex",
      "NegativePostIndex_al_r0_r7_minus_2588_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r10, minus, 2669, PostIndex},
      "al r7 r10 minus 2669 PostIndex",
      "NegativePostIndex_al_r7_r10_minus_2669_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r11, minus, 2023, PostIndex},
      "al r14 r11 minus 2023 PostIndex",
      "NegativePostIndex_al_r14_r11_minus_2023_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r1, minus, 3610, PostIndex},
      "al r4 r1 minus 3610 PostIndex",
      "NegativePostIndex_al_r4_r1_minus_3610_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r9, minus, 624, PostIndex},
      "al r2 r9 minus 624 PostIndex",
      "NegativePostIndex_al_r2_r9_minus_624_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r8, minus, 1610, PostIndex},
      "al r12 r8 minus 1610 PostIndex",
      "NegativePostIndex_al_r12_r8_minus_1610_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r11, minus, 3136, PostIndex},
      "al r4 r11 minus 3136 PostIndex",
      "NegativePostIndex_al_r4_r11_minus_3136_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r7, minus, 3949, PostIndex},
      "al r2 r7 minus 3949 PostIndex",
      "NegativePostIndex_al_r2_r7_minus_3949_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r0, minus, 1635, PostIndex},
      "al r7 r0 minus 1635 PostIndex",
      "NegativePostIndex_al_r7_r0_minus_1635_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r2, minus, 3008, PostIndex},
      "al r4 r2 minus 3008 PostIndex",
      "NegativePostIndex_al_r4_r2_minus_3008_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r3, minus, 3566, PostIndex},
      "al r6 r3 minus 3566 PostIndex",
      "NegativePostIndex_al_r6_r3_minus_3566_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r8, minus, 3774, PostIndex},
      "al r12 r8 minus 3774 PostIndex",
      "NegativePostIndex_al_r12_r8_minus_3774_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r10, minus, 3978, PostIndex},
      "al r14 r10 minus 3978 PostIndex",
      "NegativePostIndex_al_r14_r10_minus_3978_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r6, minus, 2358, PostIndex},
      "al r2 r6 minus 2358 PostIndex",
      "NegativePostIndex_al_r2_r6_minus_2358_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r9, minus, 2650, PostIndex},
      "al r14 r9 minus 2650 PostIndex",
      "NegativePostIndex_al_r14_r9_minus_2650_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r14, minus, 2365, PostIndex},
      "al r4 r14 minus 2365 PostIndex",
      "NegativePostIndex_al_r4_r14_minus_2365_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r2, minus, 496, PostIndex},
      "al r14 r2 minus 496 PostIndex",
      "NegativePostIndex_al_r14_r2_minus_496_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r0, minus, 2124, PostIndex},
      "al r9 r0 minus 2124 PostIndex",
      "NegativePostIndex_al_r9_r0_minus_2124_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r2, minus, 3366, PostIndex},
      "al r4 r2 minus 3366 PostIndex",
      "NegativePostIndex_al_r4_r2_minus_3366_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r2, minus, 2866, PostIndex},
      "al r1 r2 minus 2866 PostIndex",
      "NegativePostIndex_al_r1_r2_minus_2866_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r4, minus, 3003, PostIndex},
      "al r8 r4 minus 3003 PostIndex",
      "NegativePostIndex_al_r8_r4_minus_3003_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r3, minus, 1234, PostIndex},
      "al r9 r3 minus 1234 PostIndex",
      "NegativePostIndex_al_r9_r3_minus_1234_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r8, minus, 2290, PostIndex},
      "al r1 r8 minus 2290 PostIndex",
      "NegativePostIndex_al_r1_r8_minus_2290_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r2, minus, 3811, PostIndex},
      "al r8 r2 minus 3811 PostIndex",
      "NegativePostIndex_al_r8_r2_minus_3811_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r4, r9, minus, 429, PostIndex},
      "al r4 r9 minus 429 PostIndex",
      "NegativePostIndex_al_r4_r9_minus_429_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r1, minus, 2025, PostIndex},
      "al r6 r1 minus 2025 PostIndex",
      "NegativePostIndex_al_r6_r1_minus_2025_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r7, minus, 3517, PostIndex},
      "al r11 r7 minus 3517 PostIndex",
      "NegativePostIndex_al_r11_r7_minus_3517_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r7, r4, minus, 251, PostIndex},
      "al r7 r4 minus 251 PostIndex",
      "NegativePostIndex_al_r7_r4_minus_251_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r12, minus, 1635, PostIndex},
      "al r1 r12 minus 1635 PostIndex",
      "NegativePostIndex_al_r1_r12_minus_1635_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r7, minus, 3685, PostIndex},
      "al r6 r7 minus 3685 PostIndex",
      "NegativePostIndex_al_r6_r7_minus_3685_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r9, r11, minus, 1981, PostIndex},
      "al r9 r11 minus 1981 PostIndex",
      "NegativePostIndex_al_r9_r11_minus_1981_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r2, minus, 180, PostIndex},
      "al r6 r2 minus 180 PostIndex",
      "NegativePostIndex_al_r6_r2_minus_180_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r6, minus, 2490, PostIndex},
      "al r12 r6 minus 2490 PostIndex",
      "NegativePostIndex_al_r12_r6_minus_2490_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r1, r3, minus, 3994, PostIndex},
      "al r1 r3 minus 3994 PostIndex",
      "NegativePostIndex_al_r1_r3_minus_3994_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r2, minus, 3094, PostIndex},
      "al r3 r2 minus 3094 PostIndex",
      "NegativePostIndex_al_r3_r2_minus_3094_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r7, minus, 1377, PostIndex},
      "al r2 r7 minus 1377 PostIndex",
      "NegativePostIndex_al_r2_r7_minus_1377_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r11, minus, 2098, PostIndex},
      "al r12 r11 minus 2098 PostIndex",
      "NegativePostIndex_al_r12_r11_minus_2098_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r0, r3, minus, 2462, PostIndex},
      "al r0 r3 minus 2462 PostIndex",
      "NegativePostIndex_al_r0_r3_minus_2462_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r6, r3, minus, 3659, PostIndex},
      "al r6 r3 minus 3659 PostIndex",
      "NegativePostIndex_al_r6_r3_minus_3659_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r1, minus, 2139, PostIndex},
      "al r5 r1 minus 2139 PostIndex",
      "NegativePostIndex_al_r5_r1_minus_2139_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r11, r1, minus, 1934, PostIndex},
      "al r11 r1 minus 1934 PostIndex",
      "NegativePostIndex_al_r11_r1_minus_1934_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r11, minus, 1961, PostIndex},
      "al r8 r11 minus 1961 PostIndex",
      "NegativePostIndex_al_r8_r11_minus_1961_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r3, r8, minus, 2535, PostIndex},
      "al r3 r8 minus 2535 PostIndex",
      "NegativePostIndex_al_r3_r8_minus_2535_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r12, r7, minus, 3688, PostIndex},
      "al r12 r7 minus 3688 PostIndex",
      "NegativePostIndex_al_r12_r7_minus_3688_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r1, minus, 513, PostIndex},
      "al r8 r1 minus 513 PostIndex",
      "NegativePostIndex_al_r8_r1_minus_513_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r8, r2, minus, 213, PostIndex},
      "al r8 r2 minus 213 PostIndex",
      "NegativePostIndex_al_r8_r2_minus_213_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r2, r5, minus, 670, PostIndex},
      "al r2 r5 minus 670 PostIndex",
      "NegativePostIndex_al_r2_r5_minus_670_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r5, r6, minus, 3986, PostIndex},
      "al r5 r6 minus 3986 PostIndex",
      "NegativePostIndex_al_r5_r6_minus_3986_PostIndex",
      ARRAY_SIZE(kNegativePostIndex),
      kNegativePostIndex},
     {{al, r14, r12, plus, 2982, PreIndex},
      "al r14 r12 plus 2982 PreIndex",
      "PositivePreIndex_al_r14_r12_plus_2982_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r11, plus, 1241, PreIndex},
      "al r7 r11 plus 1241 PreIndex",
      "PositivePreIndex_al_r7_r11_plus_1241_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r5, plus, 2677, PreIndex},
      "al r6 r5 plus 2677 PreIndex",
      "PositivePreIndex_al_r6_r5_plus_2677_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r12, plus, 2403, PreIndex},
      "al r11 r12 plus 2403 PreIndex",
      "PositivePreIndex_al_r11_r12_plus_2403_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r5, plus, 1274, PreIndex},
      "al r6 r5 plus 1274 PreIndex",
      "PositivePreIndex_al_r6_r5_plus_1274_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r7, plus, 2208, PreIndex},
      "al r6 r7 plus 2208 PreIndex",
      "PositivePreIndex_al_r6_r7_plus_2208_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r10, plus, 3583, PreIndex},
      "al r7 r10 plus 3583 PreIndex",
      "PositivePreIndex_al_r7_r10_plus_3583_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r5, plus, 3975, PreIndex},
      "al r7 r5 plus 3975 PreIndex",
      "PositivePreIndex_al_r7_r5_plus_3975_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r9, plus, 2326, PreIndex},
      "al r3 r9 plus 2326 PreIndex",
      "PositivePreIndex_al_r3_r9_plus_2326_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r7, plus, 2098, PreIndex},
      "al r8 r7 plus 2098 PreIndex",
      "PositivePreIndex_al_r8_r7_plus_2098_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r11, plus, 3015, PreIndex},
      "al r5 r11 plus 3015 PreIndex",
      "PositivePreIndex_al_r5_r11_plus_3015_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r12, plus, 719, PreIndex},
      "al r1 r12 plus 719 PreIndex",
      "PositivePreIndex_al_r1_r12_plus_719_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r1, plus, 3413, PreIndex},
      "al r14 r1 plus 3413 PreIndex",
      "PositivePreIndex_al_r14_r1_plus_3413_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r0, plus, 3949, PreIndex},
      "al r10 r0 plus 3949 PreIndex",
      "PositivePreIndex_al_r10_r0_plus_3949_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r4, plus, 3088, PreIndex},
      "al r12 r4 plus 3088 PreIndex",
      "PositivePreIndex_al_r12_r4_plus_3088_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r3, plus, 2690, PreIndex},
      "al r6 r3 plus 2690 PreIndex",
      "PositivePreIndex_al_r6_r3_plus_2690_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r6, plus, 3384, PreIndex},
      "al r9 r6 plus 3384 PreIndex",
      "PositivePreIndex_al_r9_r6_plus_3384_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r7, plus, 3636, PreIndex},
      "al r2 r7 plus 3636 PreIndex",
      "PositivePreIndex_al_r2_r7_plus_3636_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r1, plus, 1390, PreIndex},
      "al r10 r1 plus 1390 PreIndex",
      "PositivePreIndex_al_r10_r1_plus_1390_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r8, plus, 2546, PreIndex},
      "al r2 r8 plus 2546 PreIndex",
      "PositivePreIndex_al_r2_r8_plus_2546_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r14, plus, 2619, PreIndex},
      "al r2 r14 plus 2619 PreIndex",
      "PositivePreIndex_al_r2_r14_plus_2619_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r12, plus, 2591, PreIndex},
      "al r0 r12 plus 2591 PreIndex",
      "PositivePreIndex_al_r0_r12_plus_2591_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r7, plus, 3287, PreIndex},
      "al r11 r7 plus 3287 PreIndex",
      "PositivePreIndex_al_r11_r7_plus_3287_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r0, plus, 3638, PreIndex},
      "al r12 r0 plus 3638 PreIndex",
      "PositivePreIndex_al_r12_r0_plus_3638_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r2, plus, 2944, PreIndex},
      "al r4 r2 plus 2944 PreIndex",
      "PositivePreIndex_al_r4_r2_plus_2944_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r3, plus, 2290, PreIndex},
      "al r12 r3 plus 2290 PreIndex",
      "PositivePreIndex_al_r12_r3_plus_2290_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r7, plus, 1567, PreIndex},
      "al r9 r7 plus 1567 PreIndex",
      "PositivePreIndex_al_r9_r7_plus_1567_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r14, plus, 3994, PreIndex},
      "al r2 r14 plus 3994 PreIndex",
      "PositivePreIndex_al_r2_r14_plus_3994_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r11, plus, 3504, PreIndex},
      "al r9 r11 plus 3504 PreIndex",
      "PositivePreIndex_al_r9_r11_plus_3504_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r10, plus, 3564, PreIndex},
      "al r8 r10 plus 3564 PreIndex",
      "PositivePreIndex_al_r8_r10_plus_3564_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r3, plus, 872, PreIndex},
      "al r11 r3 plus 872 PreIndex",
      "PositivePreIndex_al_r11_r3_plus_872_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r7, plus, 3685, PreIndex},
      "al r6 r7 plus 3685 PreIndex",
      "PositivePreIndex_al_r6_r7_plus_3685_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r0, plus, 2532, PreIndex},
      "al r8 r0 plus 2532 PreIndex",
      "PositivePreIndex_al_r8_r0_plus_2532_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r4, plus, 57, PreIndex},
      "al r11 r4 plus 57 PreIndex",
      "PositivePreIndex_al_r11_r4_plus_57_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r1, plus, 3343, PreIndex},
      "al r12 r1 plus 3343 PreIndex",
      "PositivePreIndex_al_r12_r1_plus_3343_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r10, plus, 459, PreIndex},
      "al r11 r10 plus 459 PreIndex",
      "PositivePreIndex_al_r11_r10_plus_459_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r6, plus, 3867, PreIndex},
      "al r2 r6 plus 3867 PreIndex",
      "PositivePreIndex_al_r2_r6_plus_3867_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r12, plus, 1035, PreIndex},
      "al r11 r12 plus 1035 PreIndex",
      "PositivePreIndex_al_r11_r12_plus_1035_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r10, plus, 3597, PreIndex},
      "al r6 r10 plus 3597 PreIndex",
      "PositivePreIndex_al_r6_r10_plus_3597_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r2, plus, 2281, PreIndex},
      "al r14 r2 plus 2281 PreIndex",
      "PositivePreIndex_al_r14_r2_plus_2281_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r10, plus, 2901, PreIndex},
      "al r3 r10 plus 2901 PreIndex",
      "PositivePreIndex_al_r3_r10_plus_2901_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r14, plus, 2052, PreIndex},
      "al r4 r14 plus 2052 PreIndex",
      "PositivePreIndex_al_r4_r14_plus_2052_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r6, plus, 4091, PreIndex},
      "al r4 r6 plus 4091 PreIndex",
      "PositivePreIndex_al_r4_r6_plus_4091_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r12, plus, 871, PreIndex},
      "al r4 r12 plus 871 PreIndex",
      "PositivePreIndex_al_r4_r12_plus_871_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r2, plus, 1860, PreIndex},
      "al r9 r2 plus 1860 PreIndex",
      "PositivePreIndex_al_r9_r2_plus_1860_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r0, plus, 2345, PreIndex},
      "al r11 r0 plus 2345 PreIndex",
      "PositivePreIndex_al_r11_r0_plus_2345_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r12, plus, 1601, PreIndex},
      "al r4 r12 plus 1601 PreIndex",
      "PositivePreIndex_al_r4_r12_plus_1601_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r5, plus, 2240, PreIndex},
      "al r7 r5 plus 2240 PreIndex",
      "PositivePreIndex_al_r7_r5_plus_2240_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r14, plus, 1542, PreIndex},
      "al r10 r14 plus 1542 PreIndex",
      "PositivePreIndex_al_r10_r14_plus_1542_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r12, plus, 1246, PreIndex},
      "al r8 r12 plus 1246 PreIndex",
      "PositivePreIndex_al_r8_r12_plus_1246_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r10, plus, 770, PreIndex},
      "al r0 r10 plus 770 PreIndex",
      "PositivePreIndex_al_r0_r10_plus_770_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r8, plus, 3076, PreIndex},
      "al r5 r8 plus 3076 PreIndex",
      "PositivePreIndex_al_r5_r8_plus_3076_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r10, plus, 3572, PreIndex},
      "al r3 r10 plus 3572 PreIndex",
      "PositivePreIndex_al_r3_r10_plus_3572_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r8, plus, 2, PreIndex},
      "al r11 r8 plus 2 PreIndex",
      "PositivePreIndex_al_r11_r8_plus_2_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r1, plus, 670, PreIndex},
      "al r12 r1 plus 670 PreIndex",
      "PositivePreIndex_al_r12_r1_plus_670_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r4, plus, 251, PreIndex},
      "al r6 r4 plus 251 PreIndex",
      "PositivePreIndex_al_r6_r4_plus_251_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r2, plus, 2532, PreIndex},
      "al r10 r2 plus 2532 PreIndex",
      "PositivePreIndex_al_r10_r2_plus_2532_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r14, plus, 2906, PreIndex},
      "al r4 r14 plus 2906 PreIndex",
      "PositivePreIndex_al_r4_r14_plus_2906_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r5, plus, 2864, PreIndex},
      "al r3 r5 plus 2864 PreIndex",
      "PositivePreIndex_al_r3_r5_plus_2864_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r7, plus, 53, PreIndex},
      "al r9 r7 plus 53 PreIndex",
      "PositivePreIndex_al_r9_r7_plus_53_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r0, r12, plus, 2462, PreIndex},
      "al r0 r12 plus 2462 PreIndex",
      "PositivePreIndex_al_r0_r12_plus_2462_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r1, plus, 2183, PreIndex},
      "al r3 r1 plus 2183 PreIndex",
      "PositivePreIndex_al_r3_r1_plus_2183_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r14, plus, 3774, PreIndex},
      "al r4 r14 plus 3774 PreIndex",
      "PositivePreIndex_al_r4_r14_plus_3774_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r0, plus, 3994, PreIndex},
      "al r8 r0 plus 3994 PreIndex",
      "PositivePreIndex_al_r8_r0_plus_3994_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r5, plus, 3039, PreIndex},
      "al r1 r5 plus 3039 PreIndex",
      "PositivePreIndex_al_r1_r5_plus_3039_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r12, plus, 3425, PreIndex},
      "al r3 r12 plus 3425 PreIndex",
      "PositivePreIndex_al_r3_r12_plus_3425_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r9, plus, 4046, PreIndex},
      "al r14 r9 plus 4046 PreIndex",
      "PositivePreIndex_al_r14_r9_plus_4046_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r11, plus, 2451, PreIndex},
      "al r10 r11 plus 2451 PreIndex",
      "PositivePreIndex_al_r10_r11_plus_2451_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r9, plus, 3063, PreIndex},
      "al r6 r9 plus 3063 PreIndex",
      "PositivePreIndex_al_r6_r9_plus_3063_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r1, plus, 3865, PreIndex},
      "al r3 r1 plus 3865 PreIndex",
      "PositivePreIndex_al_r3_r1_plus_3865_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r4, plus, 1537, PreIndex},
      "al r14 r4 plus 1537 PreIndex",
      "PositivePreIndex_al_r14_r4_plus_1537_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r6, plus, 3413, PreIndex},
      "al r9 r6 plus 3413 PreIndex",
      "PositivePreIndex_al_r9_r6_plus_3413_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r1, plus, 2403, PreIndex},
      "al r2 r1 plus 2403 PreIndex",
      "PositivePreIndex_al_r2_r1_plus_2403_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r14, r4, plus, 2224, PreIndex},
      "al r14 r4 plus 2224 PreIndex",
      "PositivePreIndex_al_r14_r4_plus_2224_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r5, plus, 3743, PreIndex},
      "al r4 r5 plus 3743 PreIndex",
      "PositivePreIndex_al_r4_r5_plus_3743_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r1, plus, 1475, PreIndex},
      "al r6 r1 plus 1475 PreIndex",
      "PositivePreIndex_al_r6_r1_plus_1475_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r8, plus, 132, PreIndex},
      "al r10 r8 plus 132 PreIndex",
      "PositivePreIndex_al_r10_r8_plus_132_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r10, plus, 1459, PreIndex},
      "al r6 r10 plus 1459 PreIndex",
      "PositivePreIndex_al_r6_r10_plus_1459_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r8, plus, 2254, PreIndex},
      "al r12 r8 plus 2254 PreIndex",
      "PositivePreIndex_al_r12_r8_plus_2254_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r0, plus, 3079, PreIndex},
      "al r4 r0 plus 3079 PreIndex",
      "PositivePreIndex_al_r4_r0_plus_3079_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r14, plus, 3717, PreIndex},
      "al r9 r14 plus 3717 PreIndex",
      "PositivePreIndex_al_r9_r14_plus_3717_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r10, plus, 2490, PreIndex},
      "al r2 r10 plus 2490 PreIndex",
      "PositivePreIndex_al_r2_r10_plus_2490_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r8, plus, 210, PreIndex},
      "al r2 r8 plus 210 PreIndex",
      "PositivePreIndex_al_r2_r8_plus_210_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r5, r2, plus, 2559, PreIndex},
      "al r5 r2 plus 2559 PreIndex",
      "PositivePreIndex_al_r5_r2_plus_2559_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r11, plus, 2326, PreIndex},
      "al r4 r11 plus 2326 PreIndex",
      "PositivePreIndex_al_r4_r11_plus_2326_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r1, plus, 4093, PreIndex},
      "al r7 r1 plus 4093 PreIndex",
      "PositivePreIndex_al_r7_r1_plus_4093_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r1, plus, 663, PreIndex},
      "al r8 r1 plus 663 PreIndex",
      "PositivePreIndex_al_r8_r1_plus_663_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r9, r3, plus, 1551, PreIndex},
      "al r9 r3 plus 1551 PreIndex",
      "PositivePreIndex_al_r9_r3_plus_1551_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r3, r14, plus, 1556, PreIndex},
      "al r3 r14 plus 1556 PreIndex",
      "PositivePreIndex_al_r3_r14_plus_1556_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r6, r9, plus, 1359, PreIndex},
      "al r6 r9 plus 1359 PreIndex",
      "PositivePreIndex_al_r6_r9_plus_1359_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r2, r7, plus, 3438, PreIndex},
      "al r2 r7 plus 3438 PreIndex",
      "PositivePreIndex_al_r2_r7_plus_3438_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r7, r5, plus, 1526, PreIndex},
      "al r7 r5 plus 1526 PreIndex",
      "PositivePreIndex_al_r7_r5_plus_1526_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r7, plus, 57, PreIndex},
      "al r12 r7 plus 57 PreIndex",
      "PositivePreIndex_al_r12_r7_plus_57_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r12, r0, plus, 3138, PreIndex},
      "al r12 r0 plus 3138 PreIndex",
      "PositivePreIndex_al_r12_r0_plus_3138_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r11, plus, 672, PreIndex},
      "al r4 r11 plus 672 PreIndex",
      "PositivePreIndex_al_r4_r11_plus_672_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r10, r14, plus, 689, PreIndex},
      "al r10 r14 plus 689 PreIndex",
      "PositivePreIndex_al_r10_r14_plus_689_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r1, r8, plus, 3572, PreIndex},
      "al r1 r8 plus 3572 PreIndex",
      "PositivePreIndex_al_r1_r8_plus_3572_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r8, r6, plus, 3405, PreIndex},
      "al r8 r6 plus 3405 PreIndex",
      "PositivePreIndex_al_r8_r6_plus_3405_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r0, plus, 1845, PreIndex},
      "al r11 r0 plus 1845 PreIndex",
      "PositivePreIndex_al_r11_r0_plus_1845_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r11, r3, plus, 791, PreIndex},
      "al r11 r3 plus 791 PreIndex",
      "PositivePreIndex_al_r11_r3_plus_791_PreIndex",
      ARRAY_SIZE(kPositivePreIndex),
      kPositivePreIndex},
     {{al, r4, r11, minus, 479, PreIndex},
      "al r4 r11 minus 479 PreIndex",
      "NegativePreIndex_al_r4_r11_minus_479_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r10, minus, 3603, PreIndex},
      "al r1 r10 minus 3603 PreIndex",
      "NegativePreIndex_al_r1_r10_minus_3603_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r9, minus, 704, PreIndex},
      "al r7 r9 minus 704 PreIndex",
      "NegativePreIndex_al_r7_r9_minus_704_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r1, minus, 1017, PreIndex},
      "al r5 r1 minus 1017 PreIndex",
      "NegativePreIndex_al_r5_r1_minus_1017_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r5, minus, 1712, PreIndex},
      "al r3 r5 minus 1712 PreIndex",
      "NegativePreIndex_al_r3_r5_minus_1712_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r2, minus, 2046, PreIndex},
      "al r8 r2 minus 2046 PreIndex",
      "NegativePreIndex_al_r8_r2_minus_2046_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r5, minus, 1999, PreIndex},
      "al r14 r5 minus 1999 PreIndex",
      "NegativePreIndex_al_r14_r5_minus_1999_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r4, minus, 2849, PreIndex},
      "al r5 r4 minus 2849 PreIndex",
      "NegativePreIndex_al_r5_r4_minus_2849_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r14, minus, 263, PreIndex},
      "al r9 r14 minus 263 PreIndex",
      "NegativePreIndex_al_r9_r14_minus_263_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r1, minus, 517, PreIndex},
      "al r7 r1 minus 517 PreIndex",
      "NegativePreIndex_al_r7_r1_minus_517_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r10, minus, 1961, PreIndex},
      "al r14 r10 minus 1961 PreIndex",
      "NegativePreIndex_al_r14_r10_minus_1961_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r14, minus, 1295, PreIndex},
      "al r7 r14 minus 1295 PreIndex",
      "NegativePreIndex_al_r7_r14_minus_1295_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r8, minus, 213, PreIndex},
      "al r1 r8 minus 213 PreIndex",
      "NegativePreIndex_al_r1_r8_minus_213_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r9, minus, 2866, PreIndex},
      "al r10 r9 minus 2866 PreIndex",
      "NegativePreIndex_al_r10_r9_minus_2866_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r6, minus, 1823, PreIndex},
      "al r14 r6 minus 1823 PreIndex",
      "NegativePreIndex_al_r14_r6_minus_1823_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r14, minus, 2395, PreIndex},
      "al r1 r14 minus 2395 PreIndex",
      "NegativePreIndex_al_r1_r14_minus_2395_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r6, minus, 2044, PreIndex},
      "al r1 r6 minus 2044 PreIndex",
      "NegativePreIndex_al_r1_r6_minus_2044_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r5, minus, 3963, PreIndex},
      "al r3 r5 minus 3963 PreIndex",
      "NegativePreIndex_al_r3_r5_minus_3963_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r8, minus, 3989, PreIndex},
      "al r7 r8 minus 3989 PreIndex",
      "NegativePreIndex_al_r7_r8_minus_3989_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r0, minus, 3975, PreIndex},
      "al r2 r0 minus 3975 PreIndex",
      "NegativePreIndex_al_r2_r0_minus_3975_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r10, minus, 481, PreIndex},
      "al r0 r10 minus 481 PreIndex",
      "NegativePreIndex_al_r0_r10_minus_481_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r11, minus, 3696, PreIndex},
      "al r1 r11 minus 3696 PreIndex",
      "NegativePreIndex_al_r1_r11_minus_3696_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r9, minus, 371, PreIndex},
      "al r12 r9 minus 371 PreIndex",
      "NegativePreIndex_al_r12_r9_minus_371_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r9, minus, 2464, PreIndex},
      "al r3 r9 minus 2464 PreIndex",
      "NegativePreIndex_al_r3_r9_minus_2464_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r0, minus, 1168, PreIndex},
      "al r3 r0 minus 1168 PreIndex",
      "NegativePreIndex_al_r3_r0_minus_1168_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r0, minus, 1066, PreIndex},
      "al r10 r0 minus 1066 PreIndex",
      "NegativePreIndex_al_r10_r0_minus_1066_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r1, minus, 1651, PreIndex},
      "al r9 r1 minus 1651 PreIndex",
      "NegativePreIndex_al_r9_r1_minus_1651_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r0, minus, 3821, PreIndex},
      "al r5 r0 minus 3821 PreIndex",
      "NegativePreIndex_al_r5_r0_minus_3821_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r6, minus, 2052, PreIndex},
      "al r1 r6 minus 2052 PreIndex",
      "NegativePreIndex_al_r1_r6_minus_2052_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r12, minus, 490, PreIndex},
      "al r4 r12 minus 490 PreIndex",
      "NegativePreIndex_al_r4_r12_minus_490_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r3, minus, 1922, PreIndex},
      "al r5 r3 minus 1922 PreIndex",
      "NegativePreIndex_al_r5_r3_minus_1922_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r5, minus, 875, PreIndex},
      "al r14 r5 minus 875 PreIndex",
      "NegativePreIndex_al_r14_r5_minus_875_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r2, minus, 2183, PreIndex},
      "al r10 r2 minus 2183 PreIndex",
      "NegativePreIndex_al_r10_r2_minus_2183_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r4, minus, 1961, PreIndex},
      "al r9 r4 minus 1961 PreIndex",
      "NegativePreIndex_al_r9_r4_minus_1961_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r5, minus, 3413, PreIndex},
      "al r3 r5 minus 3413 PreIndex",
      "NegativePreIndex_al_r3_r5_minus_3413_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r14, minus, 2016, PreIndex},
      "al r4 r14 minus 2016 PreIndex",
      "NegativePreIndex_al_r4_r14_minus_2016_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r3, minus, 484, PreIndex},
      "al r0 r3 minus 484 PreIndex",
      "NegativePreIndex_al_r0_r3_minus_484_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r14, minus, 322, PreIndex},
      "al r11 r14 minus 322 PreIndex",
      "NegativePreIndex_al_r11_r14_minus_322_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r5, minus, 2139, PreIndex},
      "al r0 r5 minus 2139 PreIndex",
      "NegativePreIndex_al_r0_r5_minus_2139_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r14, minus, 2976, PreIndex},
      "al r9 r14 minus 2976 PreIndex",
      "NegativePreIndex_al_r9_r14_minus_2976_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r0, minus, 2839, PreIndex},
      "al r10 r0 minus 2839 PreIndex",
      "NegativePreIndex_al_r10_r0_minus_2839_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r2, minus, 2541, PreIndex},
      "al r4 r2 minus 2541 PreIndex",
      "NegativePreIndex_al_r4_r2_minus_2541_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r0, minus, 3907, PreIndex},
      "al r7 r0 minus 3907 PreIndex",
      "NegativePreIndex_al_r7_r0_minus_3907_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r14, minus, 3449, PreIndex},
      "al r5 r14 minus 3449 PreIndex",
      "NegativePreIndex_al_r5_r14_minus_3449_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r14, minus, 2069, PreIndex},
      "al r8 r14 minus 2069 PreIndex",
      "NegativePreIndex_al_r8_r14_minus_2069_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r6, minus, 3570, PreIndex},
      "al r5 r6 minus 3570 PreIndex",
      "NegativePreIndex_al_r5_r6_minus_3570_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r4, minus, 811, PreIndex},
      "al r11 r4 minus 811 PreIndex",
      "NegativePreIndex_al_r11_r4_minus_811_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r8, minus, 1867, PreIndex},
      "al r5 r8 minus 1867 PreIndex",
      "NegativePreIndex_al_r5_r8_minus_1867_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r7, minus, 3978, PreIndex},
      "al r8 r7 minus 3978 PreIndex",
      "NegativePreIndex_al_r8_r7_minus_3978_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r11, minus, 3438, PreIndex},
      "al r6 r11 minus 3438 PreIndex",
      "NegativePreIndex_al_r6_r11_minus_3438_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r0, minus, 669, PreIndex},
      "al r9 r0 minus 669 PreIndex",
      "NegativePreIndex_al_r9_r0_minus_669_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r7, minus, 1916, PreIndex},
      "al r2 r7 minus 1916 PreIndex",
      "NegativePreIndex_al_r2_r7_minus_1916_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r6, minus, 3949, PreIndex},
      "al r12 r6 minus 3949 PreIndex",
      "NegativePreIndex_al_r12_r6_minus_3949_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r14, minus, 496, PreIndex},
      "al r2 r14 minus 496 PreIndex",
      "NegativePreIndex_al_r2_r14_minus_496_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r9, minus, 3914, PreIndex},
      "al r2 r9 minus 3914 PreIndex",
      "NegativePreIndex_al_r2_r9_minus_3914_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r2, minus, 1377, PreIndex},
      "al r11 r2 minus 1377 PreIndex",
      "NegativePreIndex_al_r11_r2_minus_1377_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r7, minus, 3007, PreIndex},
      "al r8 r7 minus 3007 PreIndex",
      "NegativePreIndex_al_r8_r7_minus_3007_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r1, minus, 496, PreIndex},
      "al r9 r1 minus 496 PreIndex",
      "NegativePreIndex_al_r9_r1_minus_496_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r7, minus, 138, PreIndex},
      "al r11 r7 minus 138 PreIndex",
      "NegativePreIndex_al_r11_r7_minus_138_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r3, minus, 732, PreIndex},
      "al r0 r3 minus 732 PreIndex",
      "NegativePreIndex_al_r0_r3_minus_732_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r14, minus, 1635, PreIndex},
      "al r9 r14 minus 1635 PreIndex",
      "NegativePreIndex_al_r9_r14_minus_1635_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r0, minus, 2119, PreIndex},
      "al r3 r0 minus 2119 PreIndex",
      "NegativePreIndex_al_r3_r0_minus_2119_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r14, minus, 1585, PreIndex},
      "al r3 r14 minus 1585 PreIndex",
      "NegativePreIndex_al_r3_r14_minus_1585_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r11, minus, 831, PreIndex},
      "al r8 r11 minus 831 PreIndex",
      "NegativePreIndex_al_r8_r11_minus_831_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r3, minus, 470, PreIndex},
      "al r11 r3 minus 470 PreIndex",
      "NegativePreIndex_al_r11_r3_minus_470_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r12, r6, minus, 47, PreIndex},
      "al r12 r6 minus 47 PreIndex",
      "NegativePreIndex_al_r12_r6_minus_47_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r1, r2, minus, 1542, PreIndex},
      "al r1 r2 minus 1542 PreIndex",
      "NegativePreIndex_al_r1_r2_minus_1542_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r7, minus, 2442, PreIndex},
      "al r11 r7 minus 2442 PreIndex",
      "NegativePreIndex_al_r11_r7_minus_2442_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r10, minus, 1896, PreIndex},
      "al r7 r10 minus 1896 PreIndex",
      "NegativePreIndex_al_r7_r10_minus_1896_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r6, minus, 3504, PreIndex},
      "al r14 r6 minus 3504 PreIndex",
      "NegativePreIndex_al_r14_r6_minus_3504_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r5, minus, 1872, PreIndex},
      "al r11 r5 minus 1872 PreIndex",
      "NegativePreIndex_al_r11_r5_minus_1872_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r11, minus, 386, PreIndex},
      "al r14 r11 minus 386 PreIndex",
      "NegativePreIndex_al_r14_r11_minus_386_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r12, minus, 2483, PreIndex},
      "al r3 r12 minus 2483 PreIndex",
      "NegativePreIndex_al_r3_r12_minus_2483_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r6, r2, minus, 2052, PreIndex},
      "al r6 r2 minus 2052 PreIndex",
      "NegativePreIndex_al_r6_r2_minus_2052_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r10, minus, 1399, PreIndex},
      "al r4 r10 minus 1399 PreIndex",
      "NegativePreIndex_al_r4_r10_minus_1399_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r5, minus, 1027, PreIndex},
      "al r3 r5 minus 1027 PreIndex",
      "NegativePreIndex_al_r3_r5_minus_1027_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r14, minus, 2627, PreIndex},
      "al r10 r14 minus 2627 PreIndex",
      "NegativePreIndex_al_r10_r14_minus_2627_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r9, minus, 2728, PreIndex},
      "al r3 r9 minus 2728 PreIndex",
      "NegativePreIndex_al_r3_r9_minus_2728_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r8, minus, 2475, PreIndex},
      "al r14 r8 minus 2475 PreIndex",
      "NegativePreIndex_al_r14_r8_minus_2475_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r5, minus, 510, PreIndex},
      "al r14 r5 minus 510 PreIndex",
      "NegativePreIndex_al_r14_r5_minus_510_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r3, minus, 2311, PreIndex},
      "al r14 r3 minus 2311 PreIndex",
      "NegativePreIndex_al_r14_r3_minus_2311_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r12, minus, 2792, PreIndex},
      "al r7 r12 minus 2792 PreIndex",
      "NegativePreIndex_al_r7_r12_minus_2792_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r14, minus, 1655, PreIndex},
      "al r4 r14 minus 1655 PreIndex",
      "NegativePreIndex_al_r4_r14_minus_1655_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r10, r5, minus, 3282, PreIndex},
      "al r10 r5 minus 3282 PreIndex",
      "NegativePreIndex_al_r10_r5_minus_3282_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r11, r7, minus, 3472, PreIndex},
      "al r11 r7 minus 3472 PreIndex",
      "NegativePreIndex_al_r11_r7_minus_3472_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r1, minus, 3266, PreIndex},
      "al r14 r1 minus 3266 PreIndex",
      "NegativePreIndex_al_r14_r1_minus_3266_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r1, minus, 3256, PreIndex},
      "al r5 r1 minus 3256 PreIndex",
      "NegativePreIndex_al_r5_r1_minus_3256_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r7, r11, minus, 4, PreIndex},
      "al r7 r11 minus 4 PreIndex",
      "NegativePreIndex_al_r7_r11_minus_4_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r9, r3, minus, 1695, PreIndex},
      "al r9 r3 minus 1695 PreIndex",
      "NegativePreIndex_al_r9_r3_minus_1695_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r1, minus, 2326, PreIndex},
      "al r8 r1 minus 2326 PreIndex",
      "NegativePreIndex_al_r8_r1_minus_2326_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r14, minus, 1651, PreIndex},
      "al r2 r14 minus 1651 PreIndex",
      "NegativePreIndex_al_r2_r14_minus_1651_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r3, r1, minus, 955, PreIndex},
      "al r3 r1 minus 955 PreIndex",
      "NegativePreIndex_al_r3_r1_minus_955_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r0, r9, minus, 3443, PreIndex},
      "al r0 r9 minus 3443 PreIndex",
      "NegativePreIndex_al_r0_r9_minus_3443_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r10, minus, 1017, PreIndex},
      "al r14 r10 minus 1017 PreIndex",
      "NegativePreIndex_al_r14_r10_minus_1017_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r3, minus, 2703, PreIndex},
      "al r4 r3 minus 2703 PreIndex",
      "NegativePreIndex_al_r4_r3_minus_2703_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r8, r10, minus, 831, PreIndex},
      "al r8 r10 minus 831 PreIndex",
      "NegativePreIndex_al_r8_r10_minus_831_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r5, r6, minus, 3194, PreIndex},
      "al r5 r6 minus 3194 PreIndex",
      "NegativePreIndex_al_r5_r6_minus_3194_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r2, r3, minus, 3607, PreIndex},
      "al r2 r3 minus 3607 PreIndex",
      "NegativePreIndex_al_r2_r3_minus_3607_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r14, r7, minus, 2119, PreIndex},
      "al r14 r7 minus 2119 PreIndex",
      "NegativePreIndex_al_r14_r7_minus_2119_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex},
     {{al, r4, r3, minus, 2559, PreIndex},
      "al r4 r3 minus 2559 PreIndex",
      "NegativePreIndex_al_r4_r3_minus_2559_PreIndex",
      ARRAY_SIZE(kNegativePreIndex),
      kNegativePreIndex}};

// We record all inputs to the instructions as outputs. This way, we also check
// that what shouldn't change didn't change.
struct TestResult {
  size_t output_size;
  const Inputs* outputs;
};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/simulator-cond-rd-memop-immediate-8192-ldr-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-immediate-8192-ldrb-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-immediate-8192-str-a32.h"
#include "aarch32/traces/simulator-cond-rd-memop-immediate-8192-strb-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const MemOperand& memop);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  SETUP();
  masm.UseA32();
  START();

  // Data to compare to `reference`.
  TestResult* results[ARRAY_SIZE(kTests)];

  // Test cases for memory bound instructions may allocate a buffer and save its
  // address in this array.
  byte* scratch_memory_buffers[ARRAY_SIZE(kTests)];

  // Generate a loop for each element in `kTests`. Each loop tests one specific
  // instruction.
  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Allocate results on the heap for this test.
    results[i] = new TestResult;
    results[i]->outputs = new Inputs[kTests[i].input_size];
    results[i]->output_size = kTests[i].input_size;

    size_t input_stride = sizeof(kTests[i].inputs[0]) * kTests[i].input_size;
    VIXL_ASSERT(IsUint32(input_stride));

    scratch_memory_buffers[i] = NULL;

    Label loop;
    UseScratchRegisterScope scratch_registers(&masm);
    // Include all registers from r0 ro r12.
    scratch_registers.Include(RegisterList(0x1fff));

    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Sign sign = kTests[i].operands.sign;
    int32_t offset = kTests[i].operands.offset;
    AddrMode addr_mode = kTests[i].operands.addr_mode;
    MemOperand memop(rn, sign, offset, addr_mode);
    scratch_registers.Exclude(rd);
    scratch_registers.Exclude(rn);

    // Allocate reserved registers for our own use.
    Register input_ptr = scratch_registers.Acquire();
    Register input_end = scratch_registers.Acquire();
    Register result_ptr = scratch_registers.Acquire();

    // Initialize `input_ptr` to the first element and `input_end` the address
    // after the array.
    __ Mov(input_ptr, Operand::From(kTests[i].inputs));
    __ Add(input_end, input_ptr, static_cast<uint32_t>(input_stride));
    __ Mov(result_ptr, Operand::From(results[i]->outputs));
    __ Bind(&loop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      Register saved_q_bit = temp_registers.Acquire();
      // Save the `Q` bit flag.
      __ Mrs(saved_q_bit, APSR);
      __ And(saved_q_bit, saved_q_bit, QFlag);
      // Set the `NZCV` and `Q` flags together.
      __ Ldr(nzcv_bits, MemOperand(input_ptr, offsetof(Inputs, apsr)));
      __ Orr(nzcv_bits, nzcv_bits, saved_q_bit);
      __ Msr(APSR_nzcvq, nzcv_bits);
    }
    __ Ldr(rd, MemOperand(input_ptr, offsetof(Inputs, rd)));
    // Allocate 4 bytes for the instruction to work with.
    scratch_memory_buffers[i] = new byte[4];
    {
      UseScratchRegisterScope temp_registers(&masm);

      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Write the expected data into the scratch buffer.
      __ Mov(base_register, Operand::From(scratch_memory_buffers[i]));
      __ Ldr(memop_tmp, MemOperand(input_ptr, offsetof(Inputs, memop) + 4));
      __ Str(memop_tmp, MemOperand(base_register));

      // Compute the address to put into the base register so that the
      // `MemOperand` points to the right location.
      // TODO: Support more kinds of `MemOperand`.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Sub(base_register, base_register, memop_tmp);
          } else {
            __ Add(base_register, base_register, memop_tmp);
          }
        }
      }
    }


    (masm.*instruction)(cond, rd, memop);

    {
      UseScratchRegisterScope temp_registers(&masm);
      Register nzcv_bits = temp_registers.Acquire();
      __ Mrs(nzcv_bits, APSR);
      // Only record the NZCV bits.
      __ And(nzcv_bits, nzcv_bits, NZCVFlag);
      __ Str(nzcv_bits, MemOperand(result_ptr, offsetof(Inputs, apsr)));
    }
    __ Str(rd, MemOperand(result_ptr, offsetof(Inputs, rd)));
    {
      UseScratchRegisterScope temp_registers(&masm);
      Register memop_tmp = temp_registers.Acquire();
      Register base_register = memop.GetBaseRegister();

      // Compute the address of the scratch buffer by from the base register. If
      // the instruction has updated the base register, we will be able to
      // record it.
      if (!memop.IsPostIndex()) {
        if (memop.IsImmediate()) {
          if (memop.GetSign().IsPlus()) {
            __ Mov(memop_tmp, memop.GetOffsetImmediate());
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Mov(memop_tmp, -memop.GetOffsetImmediate());
            __ Sub(base_register, base_register, memop_tmp);
          }
        } else if (memop.IsShiftedRegister()) {
          __ Mov(memop_tmp,
                 Operand(memop.GetOffsetRegister(),
                         memop.GetShift(),
                         memop.GetShiftAmount()));
          if (memop.GetSign().IsPlus()) {
            __ Add(base_register, base_register, memop_tmp);
          } else {
            __ Sub(base_register, base_register, memop_tmp);
          }
        }
      }

      // Record the value of the base register, as an offset from the scratch
      // buffer's address.
      __ Mov(memop_tmp, Operand::From(scratch_memory_buffers[i]));
      __ Sub(base_register, base_register, memop_tmp);
      __ Str(base_register, MemOperand(result_ptr, offsetof(Inputs, memop)));

      // Record the 32 bit word from memory.
      __ Ldr(memop_tmp, MemOperand(memop_tmp));
      __ Str(memop_tmp, MemOperand(result_ptr, offsetof(Inputs, memop) + 4));
    }


    // Advance the result pointer.
    __ Add(result_ptr, result_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    // Loop back until `input_ptr` is lower than `input_base`.
    __ Add(input_ptr, input_ptr, Operand::From(sizeof(kTests[i].inputs[0])));
    __ Cmp(input_ptr, input_end);
    __ B(ne, &loop);
  }

  END();

  RUN();

  if (Test::generate_test_trace()) {
    // Print the results.
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("const Inputs kOutputs_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (size_t j = 0; j < results[i]->output_size; j++) {
        printf("  { ");
        printf("0x%08" PRIx32, results[i]->outputs[j].apsr);
        printf(", ");
        printf("0x%08" PRIx32, results[i]->outputs[j].rd);
        printf(", ");
        printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
               results[i]->outputs[j].memop[0],
               results[i]->outputs[j].memop[1]);
        printf(" },\n");
      }
      printf("};\n");
    }
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kOutputs_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kOutputs_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else if (kCheckSimulatorTestResults) {
    // Check the results.
    unsigned total_error_count = 0;
    for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
      bool instruction_has_errors = false;
      for (size_t j = 0; j < kTests[i].input_size; j++) {
        uint32_t apsr = results[i]->outputs[j].apsr;
        uint32_t rd = results[i]->outputs[j].rd;
        uint32_t memop[2] = {results[i]->outputs[j].memop[0],
                             results[i]->outputs[j].memop[1]};

        uint32_t apsr_input = kTests[i].inputs[j].apsr;
        uint32_t rd_input = kTests[i].inputs[j].rd;
        uint32_t memop_input[2] = {kTests[i].inputs[j].memop[0],
                                   kTests[i].inputs[j].memop[1]};

        uint32_t apsr_ref = reference[i].outputs[j].apsr;
        uint32_t rd_ref = reference[i].outputs[j].rd;
        uint32_t memop_ref[2] = {results[i]->outputs[j].memop[0],
                                 results[i]->outputs[j].memop[1]};


        if (((apsr != apsr_ref) || (rd != rd_ref) ||
             ((memop[0] != memop_ref[0]) && (memop[1] != memop_ref[1]))) &&
            (++total_error_count <= kErrorReportLimit)) {
          // Print the instruction once even if it triggered multiple failures.
          if (!instruction_has_errors) {
            printf("Error(s) when testing \"%s %s\":\n",
                   mnemonic,
                   kTests[i].operands_description);
            instruction_has_errors = true;
          }
          // Print subsequent errors.
          printf("  Input:    ");
          printf("0x%08" PRIx32, apsr_input);
          printf(", ");
          printf("0x%08" PRIx32, rd_input);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_input[0],
                 memop_input[1]);
          printf("\n");
          printf("  Expected: ");
          printf("0x%08" PRIx32, apsr_ref);
          printf(", ");
          printf("0x%08" PRIx32, rd_ref);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}",
                 memop_ref[0],
                 memop_ref[1]);
          printf("\n");
          printf("  Found:    ");
          printf("0x%08" PRIx32, apsr);
          printf(", ");
          printf("0x%08" PRIx32, rd);
          printf(", ");
          printf("{0x%08" PRIx32 ", 0x%08" PRIx32 "}", memop[0], memop[1]);
          printf("\n\n");
        }
      }
    }

    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    VIXL_CHECK(total_error_count == 0);
  } else {
    VIXL_WARNING("Assembled the code, but did not run anything.\n");
  }

  for (size_t i = 0; i < ARRAY_SIZE(kTests); i++) {
    delete[] results[i]->outputs;
    delete results[i];
    delete[] scratch_memory_buffers[i];
  }
}

// Instantiate tests for each instruction in the list.
// TODO: Remove this limitation by having a sandboxing mechanism.
#if defined(VIXL_HOST_POINTER_32)
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_SIMULATOR_COND_RD_MEMOP_IMMEDIATE_8192_" #mnemonic "_A32",   \
      &Test_##mnemonic);
#else
#define TEST(mnemonic)                                                    \
  void Test_##mnemonic() {                                                \
    VIXL_WARNING("This test can only run on a 32-bit host.\n");           \
    USE(TestHelper);                                                      \
  }                                                                       \
  Test test_##mnemonic(                                                   \
      "AARCH32_SIMULATOR_COND_RD_MEMOP_IMMEDIATE_8192_" #mnemonic "_A32", \
      &Test_##mnemonic);
#endif

FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
