-- Database Schema for MS SQL Server

--
-- Table structure for attr_types
--

CREATE TABLE {attr_types} (
  attr_id int IDENTITY NOT NULL,
  type_id int NOT NULL default '0',
  attr_name nvarchar(40) COLLATE Latin1_General_BIN NOT NULL default '',
  attr_def ntext NOT NULL,
  PRIMARY KEY (attr_id)
);
----
CREATE INDEX {attr_types}_type_idx ON {attr_types}(type_id);
----

--
-- Table structure for attr_values
--

CREATE TABLE {attr_values} (
  issue_id int NOT NULL default '0',
  attr_id int NOT NULL default '0',
  attr_value nvarchar(80) NOT NULL default '',
  PRIMARY KEY (issue_id, attr_id)
);
----

--
-- Table structure for changes
--

CREATE TABLE {changes} (
  change_id int NOT NULL default '0',
  issue_id int NOT NULL default '0',
  attr_id int NOT NULL default '0',
  value_old nvarchar(80) NOT NULL default '',
  value_new nvarchar(80) NOT NULL default '',
  PRIMARY KEY (change_id)
);
----
CREATE INDEX {changes}_issue_idx ON {changes}(issue_id);
----

--
-- Table structure for comments
--

CREATE TABLE {comments} (
  comment_id int NOT NULL default '0',
  issue_id int NOT NULL default '0',
  comment_text ntext NOT NULL,
  PRIMARY KEY (comment_id)
);
----
CREATE INDEX {comments}_issue_idx ON {comments}(issue_id);
----

--
-- Table structure for files
--

CREATE TABLE {files} (
  file_id int NOT NULL default '0',
  issue_id int NOT NULL default '0',
  file_name nvarchar(40) NOT NULL default '',
  file_size int NOT NULL default '0',
  file_data image,
  file_descr nvarchar(80) NOT NULL default '',
  file_storage tinyint NOT NULL default '0',
  PRIMARY KEY (file_id)
);
----
CREATE INDEX {files}_issue_idx ON {files}(issue_id);
----

--
-- Table structure for folders
--

CREATE TABLE {folders} (
  folder_id int IDENTITY NOT NULL,
  project_id int NOT NULL default '0',
  type_id int NOT NULL default '0',
  folder_name nvarchar(40) COLLATE Latin1_General_BIN NOT NULL default '',
  stamp_id int NOT NULL default '0',
  PRIMARY KEY (folder_id)
);
----
CREATE INDEX {folders}_project_idx ON {folders}(project_id);
----

--
-- Table structure for issue_types
--

CREATE TABLE {issue_types} (
  type_id int IDENTITY NOT NULL,
  type_name nvarchar(40) COLLATE Latin1_General_BIN NOT NULL default '',
  PRIMARY KEY (type_id)
);
----

--
-- Table structure for issues
--

CREATE TABLE {issues} (
  issue_id int NOT NULL default '0',
  folder_id int NOT NULL default '0',
  issue_name nvarchar(80) NOT NULL default '',
  stamp_id int NOT NULL default '0',
  PRIMARY KEY (issue_id)
);
----
CREATE INDEX {issues}_folder_idx ON {issues}(folder_id);
----

--
-- Table structure for projects
--

CREATE TABLE {projects} (
  project_id int IDENTITY NOT NULL,
  project_name nvarchar(40) COLLATE Latin1_General_BIN NOT NULL default '',
  PRIMARY KEY (project_id)
);
----

--
-- Table structure for rights
--

CREATE TABLE {rights} (
  project_id int NOT NULL default '0',
  user_id int NOT NULL default '0',
  project_access tinyint NOT NULL default '0',
  PRIMARY KEY (project_id, user_id)
);
----
CREATE INDEX {rights}_user_idx ON {rights}(user_id);
----

--
-- Table structure for server
--

CREATE TABLE {server} (
  server_name nvarchar(40) NOT NULL default '',
  server_uuid char(36) NOT NULL default '',
  db_version varchar(20) NOT NULL default '',
  last_cron int
);
----

--
-- Table structure for stamps
--

CREATE TABLE {stamps} (
  stamp_id int IDENTITY NOT NULL,
  user_id int NOT NULL default '0',
  stamp_time int NOT NULL default '0',
  PRIMARY KEY (stamp_id)
);
----

--
-- Table structure for users
--

CREATE TABLE {users} (
  user_id int IDENTITY NOT NULL,
  user_login nvarchar(40) COLLATE Latin1_General_BIN NOT NULL default '',
  user_name nvarchar(40) COLLATE Latin1_General_BIN NOT NULL default '',
  user_passwd char(32) NOT NULL default '',
  user_access tinyint NOT NULL default '0',
  PRIMARY KEY (user_id),
  UNIQUE (user_login)
);
----

-- [0.8.4-beta1]

--
-- Table structure for notify_folders
--

CREATE TABLE {notify_folders} (
  user_id int NOT NULL default '0',
  folder_id int NOT NULL default '0',
  stamp_id int NOT NULL default '0',
  PRIMARY KEY (user_id, folder_id)
);
----

--
-- Table structure for notify_isues
--

CREATE TABLE {notify_issues} (
  user_id int NOT NULL default '0',
  issue_id int NOT NULL default '0',
  stamp_id int NOT NULL default '0',
  PRIMARY KEY (user_id, issue_id)
);
----

--
-- Table structure for notify_users
--

CREATE TABLE {notify_users} (
  user_id int NOT NULL default '0',
  last_sent int NOT NULL default '0',
  last_status int NOT NULL default '0',
  PRIMARY KEY (user_id)
);
----

--
-- Table structure for preferences
--

CREATE TABLE {preferences} (
  user_id int NOT NULL default '0',
  pref_key nvarchar(40) COLLATE Latin1_General_BIN NOT NULL default '',
  pref_value ntext NOT NULL,
  PRIMARY KEY (user_id, pref_key)
);
----
