/*
 * Copyright (C) 2000-2007 the xine project
 *
 * This file is part of xine, a free video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * 
 * Xine plugin for Mozilla/Firefox 
 *      written by Claudio Ciccani <klan@users.sf.net>
 *      
 */

#ifndef __XINE_PLAYLIST_H__
#define __XINE_PLAYLIST_H__

#include <stdlib.h>
#include <string.h>

/**** Playlist implementation ****/

typedef struct playlist_entry_s {
  struct playlist_entry_s *next;
  struct playlist_entry_s *prev;
  
  int                      id;

  char                    *mrl;

  int                      start; /* start time in ms */
} playlist_entry_t;


static inline playlist_entry_t* playlist_insert (playlist_entry_t **list, 
                                                 const char        *mrl,
                                                 int                start) {
  playlist_entry_t *entry;
  
  entry = calloc (1, sizeof(playlist_entry_t));
  if (!entry)
    return NULL;
  
  entry->mrl = strdup (mrl);
  entry->start = start;
  
  if (*list) {
    playlist_entry_t *base = *list;
    playlist_entry_t *last = base->prev;
    
    last->next = entry;
    base->prev = entry;
    entry->prev = last;
    entry->id = last->id + 1;
  } 
  else {
    *list = entry;
    entry->prev = entry;
  }
  
  return entry;
}

static inline void playlist_remove (playlist_entry_t **list, 
                                    playlist_entry_t  *entry) {
  playlist_entry_t *next, *prev;
  
  next = entry->next;
  prev = entry->prev;
  
  if (next)
    next->prev = prev;
  else
    (*list)->prev = prev;
    
  if (entry == *list)
    *list = next;
  else
    prev->next = next;
    
  free (entry->mrl);
  free (entry);
}

static inline void playlist_free (playlist_entry_t **list) {
  playlist_entry_t *entry, *next;
  
  for (entry = *list; entry;) {
    next = entry->next;
    free (entry->mrl);
    free (entry);
    entry = next;
  }
  
  *list = NULL;
}

/**** Playlist loading ****/

/* Playlist file type */
enum {
  XINE_PLT_NONE = 0,
  XINE_PLT_M3U,
  XINE_PLT_RAM,
  XINE_PLT_PLS,
  XINE_PLT_ASX,
  XINE_PLT_SMI,
  XINE_PLT_XSPF,
  XINE_PLT_QTL
};

/* Detect playlist file type. */
int playlist_type (const char *mimetype, const char *filename);

/* Load MRLs from playlist file (returns number of MRLs loaded). */
int playlist_load (int type, const char *filename, playlist_entry_t **list);


#endif
