#!/usr/bin/env python3
# encoding: utf-8
"""
ScriptParser.py

Created by Graham Dennis on 2007-12-29.

Copyright (c) 2007-2012, Graham Dennis

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""

## Subclasses for parsing specific scripts types should
## override the following functions:
##
### canParseXMLDocument
### -- return whether the subclass can parse the document
### parseXMLDocument
### --- return the top-level SimulationElement after parsing
###     the script.

class ScriptParser(object):
    def canParseXMLDocument(self, xmlDocument):
        return False
    
    def parseXMLDocument(self, xmlDocument, globalNameSpace):
        return None
    
    def applyAttributeDictionaryToObject(self, attrDict, obj):
        for attrName, attrValue in attrDict.items():
            setattr(obj, attrName, attrValue)
    

