#!/usr/bin/env python

# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

from __future__ import print_function

import json
import os
import sys

sys.path.append(os.path.dirname(__file__))

import usecounters

AUTOGENERATED_WARNING_COMMENT = (
    "/* THIS FILE IS AUTOGENERATED BY gen-usecounters.py - DO NOT EDIT */"
)


def generate_list(f, counters):
    def print_optional_macro_declare(name):
        print(
            """
#ifndef %(name)s
#define %(name)s(interface_, name_) // nothing
#define DEFINED_%(name)s
#endif
"""
            % {"name": name},
            file=f,
        )

    def print_optional_macro_undeclare(name):
        print(
            """
#ifdef DEFINED_%(name)s
#undef DEFINED_%(name)s
#undef %(name)s
#endif
"""
            % {"name": name},
            file=f,
        )

    print(AUTOGENERATED_WARNING_COMMENT, file=f)

    print_optional_macro_declare("USE_COUNTER_DOM_METHOD")
    print_optional_macro_declare("USE_COUNTER_DOM_ATTRIBUTE")
    print_optional_macro_declare("USE_COUNTER_CUSTOM")

    for counter in counters:
        if counter["type"] == "method":
            print(
                "USE_COUNTER_DOM_METHOD(%s, %s)"
                % (counter["interface_name"], counter["method_name"]),
                file=f,
            )
        elif counter["type"] == "attribute":
            print(
                "USE_COUNTER_DOM_ATTRIBUTE(%s, %s)"
                % (counter["interface_name"], counter["attribute_name"]),
                file=f,
            )
        elif counter["type"] == "custom":
            desc = counter["desc"].replace("\\", r"\\").replace('"', r"\"")
            print('USE_COUNTER_CUSTOM(%s, "%s")' % (counter["name"], desc), file=f)

    print_optional_macro_undeclare("USE_COUNTER_DOM_METHOD")
    print_optional_macro_undeclare("USE_COUNTER_DOM_ATTRIBUTE")
    print_optional_macro_undeclare("USE_COUNTER_CUSTOM")


def use_counter_list(output_header, conf_filename):
    counters = usecounters.read_conf(conf_filename)
    generate_list(output_header, counters)
