package logic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AgreementType enumerates the values for agreement type.
type AgreementType string

const (
	// AS2 specifies the as2 state for agreement type.
	AS2 AgreementType = "AS2"
	// Edifact specifies the edifact state for agreement type.
	Edifact AgreementType = "Edifact"
	// NotSpecified specifies the not specified state for agreement type.
	NotSpecified AgreementType = "NotSpecified"
	// X12 specifies the x12 state for agreement type.
	X12 AgreementType = "X12"
)

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday specifies the friday state for day of week.
	Friday DayOfWeek = "Friday"
	// Monday specifies the monday state for day of week.
	Monday DayOfWeek = "Monday"
	// Saturday specifies the saturday state for day of week.
	Saturday DayOfWeek = "Saturday"
	// Sunday specifies the sunday state for day of week.
	Sunday DayOfWeek = "Sunday"
	// Thursday specifies the thursday state for day of week.
	Thursday DayOfWeek = "Thursday"
	// Tuesday specifies the tuesday state for day of week.
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday specifies the wednesday state for day of week.
	Wednesday DayOfWeek = "Wednesday"
)

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday specifies the days of week friday state for days of
	// week.
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday specifies the days of week monday state for days of
	// week.
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday specifies the days of week saturday state for days of
	// week.
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday specifies the days of week sunday state for days of
	// week.
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday specifies the days of week thursday state for days of
	// week.
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday specifies the days of week tuesday state for days of
	// week.
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday specifies the days of week wednesday state for days
	// of week.
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// EdifactCharacterSet enumerates the values for edifact character set.
type EdifactCharacterSet string

const (
	// EdifactCharacterSetKECA specifies the edifact character set keca state
	// for edifact character set.
	EdifactCharacterSetKECA EdifactCharacterSet = "KECA"
	// EdifactCharacterSetNotSpecified specifies the edifact character set not
	// specified state for edifact character set.
	EdifactCharacterSetNotSpecified EdifactCharacterSet = "NotSpecified"
	// EdifactCharacterSetUNOA specifies the edifact character set unoa state
	// for edifact character set.
	EdifactCharacterSetUNOA EdifactCharacterSet = "UNOA"
	// EdifactCharacterSetUNOB specifies the edifact character set unob state
	// for edifact character set.
	EdifactCharacterSetUNOB EdifactCharacterSet = "UNOB"
	// EdifactCharacterSetUNOC specifies the edifact character set unoc state
	// for edifact character set.
	EdifactCharacterSetUNOC EdifactCharacterSet = "UNOC"
	// EdifactCharacterSetUNOD specifies the edifact character set unod state
	// for edifact character set.
	EdifactCharacterSetUNOD EdifactCharacterSet = "UNOD"
	// EdifactCharacterSetUNOE specifies the edifact character set unoe state
	// for edifact character set.
	EdifactCharacterSetUNOE EdifactCharacterSet = "UNOE"
	// EdifactCharacterSetUNOF specifies the edifact character set unof state
	// for edifact character set.
	EdifactCharacterSetUNOF EdifactCharacterSet = "UNOF"
	// EdifactCharacterSetUNOG specifies the edifact character set unog state
	// for edifact character set.
	EdifactCharacterSetUNOG EdifactCharacterSet = "UNOG"
	// EdifactCharacterSetUNOH specifies the edifact character set unoh state
	// for edifact character set.
	EdifactCharacterSetUNOH EdifactCharacterSet = "UNOH"
	// EdifactCharacterSetUNOI specifies the edifact character set unoi state
	// for edifact character set.
	EdifactCharacterSetUNOI EdifactCharacterSet = "UNOI"
	// EdifactCharacterSetUNOJ specifies the edifact character set unoj state
	// for edifact character set.
	EdifactCharacterSetUNOJ EdifactCharacterSet = "UNOJ"
	// EdifactCharacterSetUNOK specifies the edifact character set unok state
	// for edifact character set.
	EdifactCharacterSetUNOK EdifactCharacterSet = "UNOK"
	// EdifactCharacterSetUNOX specifies the edifact character set unox state
	// for edifact character set.
	EdifactCharacterSetUNOX EdifactCharacterSet = "UNOX"
	// EdifactCharacterSetUNOY specifies the edifact character set unoy state
	// for edifact character set.
	EdifactCharacterSetUNOY EdifactCharacterSet = "UNOY"
)

// EdifactDecimalIndicator enumerates the values for edifact decimal indicator.
type EdifactDecimalIndicator string

const (
	// EdifactDecimalIndicatorComma specifies the edifact decimal indicator
	// comma state for edifact decimal indicator.
	EdifactDecimalIndicatorComma EdifactDecimalIndicator = "Comma"
	// EdifactDecimalIndicatorDecimal specifies the edifact decimal indicator
	// decimal state for edifact decimal indicator.
	EdifactDecimalIndicatorDecimal EdifactDecimalIndicator = "Decimal"
	// EdifactDecimalIndicatorNotSpecified specifies the edifact decimal
	// indicator not specified state for edifact decimal indicator.
	EdifactDecimalIndicatorNotSpecified EdifactDecimalIndicator = "NotSpecified"
)

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES128 specifies the encryption algorithm aes128
	// state for encryption algorithm.
	EncryptionAlgorithmAES128 EncryptionAlgorithm = "AES128"
	// EncryptionAlgorithmAES192 specifies the encryption algorithm aes192
	// state for encryption algorithm.
	EncryptionAlgorithmAES192 EncryptionAlgorithm = "AES192"
	// EncryptionAlgorithmAES256 specifies the encryption algorithm aes256
	// state for encryption algorithm.
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmDES3 specifies the encryption algorithm des3 state
	// for encryption algorithm.
	EncryptionAlgorithmDES3 EncryptionAlgorithm = "DES3"
	// EncryptionAlgorithmNone specifies the encryption algorithm none state
	// for encryption algorithm.
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmNotSpecified specifies the encryption algorithm not
	// specified state for encryption algorithm.
	EncryptionAlgorithmNotSpecified EncryptionAlgorithm = "NotSpecified"
	// EncryptionAlgorithmRC2 specifies the encryption algorithm rc2 state for
	// encryption algorithm.
	EncryptionAlgorithmRC2 EncryptionAlgorithm = "RC2"
)

// HashingAlgorithm enumerates the values for hashing algorithm.
type HashingAlgorithm string

const (
	// HashingAlgorithmMD5 specifies the hashing algorithm md5 state for
	// hashing algorithm.
	HashingAlgorithmMD5 HashingAlgorithm = "MD5"
	// HashingAlgorithmNone specifies the hashing algorithm none state for
	// hashing algorithm.
	HashingAlgorithmNone HashingAlgorithm = "None"
	// HashingAlgorithmNotSpecified specifies the hashing algorithm not
	// specified state for hashing algorithm.
	HashingAlgorithmNotSpecified HashingAlgorithm = "NotSpecified"
	// HashingAlgorithmSHA1 specifies the hashing algorithm sha1 state for
	// hashing algorithm.
	HashingAlgorithmSHA1 HashingAlgorithm = "SHA1"
	// HashingAlgorithmSHA2256 specifies the hashing algorithm sha2256 state
	// for hashing algorithm.
	HashingAlgorithmSHA2256 HashingAlgorithm = "SHA2256"
	// HashingAlgorithmSHA2384 specifies the hashing algorithm sha2384 state
	// for hashing algorithm.
	HashingAlgorithmSHA2384 HashingAlgorithm = "SHA2384"
	// HashingAlgorithmSHA2512 specifies the hashing algorithm sha2512 state
	// for hashing algorithm.
	HashingAlgorithmSHA2512 HashingAlgorithm = "SHA2512"
)

// IntegrationAccountSkuName enumerates the values for integration account sku
// name.
type IntegrationAccountSkuName string

const (
	// IntegrationAccountSkuNameFree specifies the integration account sku name
	// free state for integration account sku name.
	IntegrationAccountSkuNameFree IntegrationAccountSkuName = "Free"
	// IntegrationAccountSkuNameNotSpecified specifies the integration account
	// sku name not specified state for integration account sku name.
	IntegrationAccountSkuNameNotSpecified IntegrationAccountSkuName = "NotSpecified"
	// IntegrationAccountSkuNameStandard specifies the integration account sku
	// name standard state for integration account sku name.
	IntegrationAccountSkuNameStandard IntegrationAccountSkuName = "Standard"
)

// KeyType enumerates the values for key type.
type KeyType string

const (
	// KeyTypeNotSpecified specifies the key type not specified state for key
	// type.
	KeyTypeNotSpecified KeyType = "NotSpecified"
	// KeyTypePrimary specifies the key type primary state for key type.
	KeyTypePrimary KeyType = "Primary"
	// KeyTypeSecondary specifies the key type secondary state for key type.
	KeyTypeSecondary KeyType = "Secondary"
)

// MapType enumerates the values for map type.
type MapType string

const (
	// MapTypeNotSpecified specifies the map type not specified state for map
	// type.
	MapTypeNotSpecified MapType = "NotSpecified"
	// MapTypeXslt specifies the map type xslt state for map type.
	MapTypeXslt MapType = "Xslt"
)

// MessageFilterType enumerates the values for message filter type.
type MessageFilterType string

const (
	// MessageFilterTypeExclude specifies the message filter type exclude state
	// for message filter type.
	MessageFilterTypeExclude MessageFilterType = "Exclude"
	// MessageFilterTypeInclude specifies the message filter type include state
	// for message filter type.
	MessageFilterTypeInclude MessageFilterType = "Include"
	// MessageFilterTypeNotSpecified specifies the message filter type not
	// specified state for message filter type.
	MessageFilterTypeNotSpecified MessageFilterType = "NotSpecified"
)

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray specifies the parameter type array state for
	// parameter type.
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBool specifies the parameter type bool state for parameter
	// type.
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeFloat specifies the parameter type float state for
	// parameter type.
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt specifies the parameter type int state for parameter
	// type.
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeNotSpecified specifies the parameter type not specified
	// state for parameter type.
	ParameterTypeNotSpecified ParameterType = "NotSpecified"
	// ParameterTypeObject specifies the parameter type object state for
	// parameter type.
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeSecureObject specifies the parameter type secure object
	// state for parameter type.
	ParameterTypeSecureObject ParameterType = "SecureObject"
	// ParameterTypeSecureString specifies the parameter type secure string
	// state for parameter type.
	ParameterTypeSecureString ParameterType = "SecureString"
	// ParameterTypeString specifies the parameter type string state for
	// parameter type.
	ParameterTypeString ParameterType = "String"
)

// PartnerType enumerates the values for partner type.
type PartnerType string

const (
	// PartnerTypeB2B specifies the partner type b2b state for partner type.
	PartnerTypeB2B PartnerType = "B2B"
	// PartnerTypeNotSpecified specifies the partner type not specified state
	// for partner type.
	PartnerTypeNotSpecified PartnerType = "NotSpecified"
)

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// RecurrenceFrequencyDay specifies the recurrence frequency day state for
	// recurrence frequency.
	RecurrenceFrequencyDay RecurrenceFrequency = "Day"
	// RecurrenceFrequencyHour specifies the recurrence frequency hour state
	// for recurrence frequency.
	RecurrenceFrequencyHour RecurrenceFrequency = "Hour"
	// RecurrenceFrequencyMinute specifies the recurrence frequency minute
	// state for recurrence frequency.
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	// RecurrenceFrequencyMonth specifies the recurrence frequency month state
	// for recurrence frequency.
	RecurrenceFrequencyMonth RecurrenceFrequency = "Month"
	// RecurrenceFrequencyNotSpecified specifies the recurrence frequency not
	// specified state for recurrence frequency.
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = "NotSpecified"
	// RecurrenceFrequencySecond specifies the recurrence frequency second
	// state for recurrence frequency.
	RecurrenceFrequencySecond RecurrenceFrequency = "Second"
	// RecurrenceFrequencyWeek specifies the recurrence frequency week state
	// for recurrence frequency.
	RecurrenceFrequencyWeek RecurrenceFrequency = "Week"
	// RecurrenceFrequencyYear specifies the recurrence frequency year state
	// for recurrence frequency.
	RecurrenceFrequencyYear RecurrenceFrequency = "Year"
)

// SchemaType enumerates the values for schema type.
type SchemaType string

const (
	// SchemaTypeNotSpecified specifies the schema type not specified state for
	// schema type.
	SchemaTypeNotSpecified SchemaType = "NotSpecified"
	// SchemaTypeXML specifies the schema type xml state for schema type.
	SchemaTypeXML SchemaType = "Xml"
)

// SegmentTerminatorSuffix enumerates the values for segment terminator suffix.
type SegmentTerminatorSuffix string

const (
	// SegmentTerminatorSuffixCR specifies the segment terminator suffix cr
	// state for segment terminator suffix.
	SegmentTerminatorSuffixCR SegmentTerminatorSuffix = "CR"
	// SegmentTerminatorSuffixCRLF specifies the segment terminator suffix crlf
	// state for segment terminator suffix.
	SegmentTerminatorSuffixCRLF SegmentTerminatorSuffix = "CRLF"
	// SegmentTerminatorSuffixLF specifies the segment terminator suffix lf
	// state for segment terminator suffix.
	SegmentTerminatorSuffixLF SegmentTerminatorSuffix = "LF"
	// SegmentTerminatorSuffixNone specifies the segment terminator suffix none
	// state for segment terminator suffix.
	SegmentTerminatorSuffixNone SegmentTerminatorSuffix = "None"
	// SegmentTerminatorSuffixNotSpecified specifies the segment terminator
	// suffix not specified state for segment terminator suffix.
	SegmentTerminatorSuffixNotSpecified SegmentTerminatorSuffix = "NotSpecified"
)

// SigningAlgorithm enumerates the values for signing algorithm.
type SigningAlgorithm string

const (
	// SigningAlgorithmDefault specifies the signing algorithm default state
	// for signing algorithm.
	SigningAlgorithmDefault SigningAlgorithm = "Default"
	// SigningAlgorithmNotSpecified specifies the signing algorithm not
	// specified state for signing algorithm.
	SigningAlgorithmNotSpecified SigningAlgorithm = "NotSpecified"
	// SigningAlgorithmSHA1 specifies the signing algorithm sha1 state for
	// signing algorithm.
	SigningAlgorithmSHA1 SigningAlgorithm = "SHA1"
	// SigningAlgorithmSHA2256 specifies the signing algorithm sha2256 state
	// for signing algorithm.
	SigningAlgorithmSHA2256 SigningAlgorithm = "SHA2256"
	// SigningAlgorithmSHA2384 specifies the signing algorithm sha2384 state
	// for signing algorithm.
	SigningAlgorithmSHA2384 SigningAlgorithm = "SHA2384"
	// SigningAlgorithmSHA2512 specifies the signing algorithm sha2512 state
	// for signing algorithm.
	SigningAlgorithmSHA2512 SigningAlgorithm = "SHA2512"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic specifies the sku name basic state for sku name.
	SkuNameBasic SkuName = "Basic"
	// SkuNameFree specifies the sku name free state for sku name.
	SkuNameFree SkuName = "Free"
	// SkuNameNotSpecified specifies the sku name not specified state for sku
	// name.
	SkuNameNotSpecified SkuName = "NotSpecified"
	// SkuNamePremium specifies the sku name premium state for sku name.
	SkuNamePremium SkuName = "Premium"
	// SkuNameShared specifies the sku name shared state for sku name.
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard specifies the sku name standard state for sku name.
	SkuNameStandard SkuName = "Standard"
)

// TrailingSeparatorPolicy enumerates the values for trailing separator policy.
type TrailingSeparatorPolicy string

const (
	// TrailingSeparatorPolicyMandatory specifies the trailing separator policy
	// mandatory state for trailing separator policy.
	TrailingSeparatorPolicyMandatory TrailingSeparatorPolicy = "Mandatory"
	// TrailingSeparatorPolicyNotAllowed specifies the trailing separator
	// policy not allowed state for trailing separator policy.
	TrailingSeparatorPolicyNotAllowed TrailingSeparatorPolicy = "NotAllowed"
	// TrailingSeparatorPolicyNotSpecified specifies the trailing separator
	// policy not specified state for trailing separator policy.
	TrailingSeparatorPolicyNotSpecified TrailingSeparatorPolicy = "NotSpecified"
	// TrailingSeparatorPolicyOptional specifies the trailing separator policy
	// optional state for trailing separator policy.
	TrailingSeparatorPolicyOptional TrailingSeparatorPolicy = "Optional"
)

// UsageIndicator enumerates the values for usage indicator.
type UsageIndicator string

const (
	// UsageIndicatorInformation specifies the usage indicator information
	// state for usage indicator.
	UsageIndicatorInformation UsageIndicator = "Information"
	// UsageIndicatorNotSpecified specifies the usage indicator not specified
	// state for usage indicator.
	UsageIndicatorNotSpecified UsageIndicator = "NotSpecified"
	// UsageIndicatorProduction specifies the usage indicator production state
	// for usage indicator.
	UsageIndicatorProduction UsageIndicator = "Production"
	// UsageIndicatorTest specifies the usage indicator test state for usage
	// indicator.
	UsageIndicatorTest UsageIndicator = "Test"
)

// WorkflowProvisioningState enumerates the values for workflow provisioning
// state.
type WorkflowProvisioningState string

const (
	// WorkflowProvisioningStateAccepted specifies the workflow provisioning
	// state accepted state for workflow provisioning state.
	WorkflowProvisioningStateAccepted WorkflowProvisioningState = "Accepted"
	// WorkflowProvisioningStateCanceled specifies the workflow provisioning
	// state canceled state for workflow provisioning state.
	WorkflowProvisioningStateCanceled WorkflowProvisioningState = "Canceled"
	// WorkflowProvisioningStateCompleted specifies the workflow provisioning
	// state completed state for workflow provisioning state.
	WorkflowProvisioningStateCompleted WorkflowProvisioningState = "Completed"
	// WorkflowProvisioningStateCreated specifies the workflow provisioning
	// state created state for workflow provisioning state.
	WorkflowProvisioningStateCreated WorkflowProvisioningState = "Created"
	// WorkflowProvisioningStateCreating specifies the workflow provisioning
	// state creating state for workflow provisioning state.
	WorkflowProvisioningStateCreating WorkflowProvisioningState = "Creating"
	// WorkflowProvisioningStateDeleted specifies the workflow provisioning
	// state deleted state for workflow provisioning state.
	WorkflowProvisioningStateDeleted WorkflowProvisioningState = "Deleted"
	// WorkflowProvisioningStateDeleting specifies the workflow provisioning
	// state deleting state for workflow provisioning state.
	WorkflowProvisioningStateDeleting WorkflowProvisioningState = "Deleting"
	// WorkflowProvisioningStateFailed specifies the workflow provisioning
	// state failed state for workflow provisioning state.
	WorkflowProvisioningStateFailed WorkflowProvisioningState = "Failed"
	// WorkflowProvisioningStateMoving specifies the workflow provisioning
	// state moving state for workflow provisioning state.
	WorkflowProvisioningStateMoving WorkflowProvisioningState = "Moving"
	// WorkflowProvisioningStateNotSpecified specifies the workflow
	// provisioning state not specified state for workflow provisioning state.
	WorkflowProvisioningStateNotSpecified WorkflowProvisioningState = "NotSpecified"
	// WorkflowProvisioningStateReady specifies the workflow provisioning state
	// ready state for workflow provisioning state.
	WorkflowProvisioningStateReady WorkflowProvisioningState = "Ready"
	// WorkflowProvisioningStateRegistered specifies the workflow provisioning
	// state registered state for workflow provisioning state.
	WorkflowProvisioningStateRegistered WorkflowProvisioningState = "Registered"
	// WorkflowProvisioningStateRegistering specifies the workflow provisioning
	// state registering state for workflow provisioning state.
	WorkflowProvisioningStateRegistering WorkflowProvisioningState = "Registering"
	// WorkflowProvisioningStateRunning specifies the workflow provisioning
	// state running state for workflow provisioning state.
	WorkflowProvisioningStateRunning WorkflowProvisioningState = "Running"
	// WorkflowProvisioningStateSucceeded specifies the workflow provisioning
	// state succeeded state for workflow provisioning state.
	WorkflowProvisioningStateSucceeded WorkflowProvisioningState = "Succeeded"
	// WorkflowProvisioningStateUnregistered specifies the workflow
	// provisioning state unregistered state for workflow provisioning state.
	WorkflowProvisioningStateUnregistered WorkflowProvisioningState = "Unregistered"
	// WorkflowProvisioningStateUnregistering specifies the workflow
	// provisioning state unregistering state for workflow provisioning state.
	WorkflowProvisioningStateUnregistering WorkflowProvisioningState = "Unregistering"
	// WorkflowProvisioningStateUpdating specifies the workflow provisioning
	// state updating state for workflow provisioning state.
	WorkflowProvisioningStateUpdating WorkflowProvisioningState = "Updating"
)

// WorkflowState enumerates the values for workflow state.
type WorkflowState string

const (
	// WorkflowStateCompleted specifies the workflow state completed state for
	// workflow state.
	WorkflowStateCompleted WorkflowState = "Completed"
	// WorkflowStateDeleted specifies the workflow state deleted state for
	// workflow state.
	WorkflowStateDeleted WorkflowState = "Deleted"
	// WorkflowStateDisabled specifies the workflow state disabled state for
	// workflow state.
	WorkflowStateDisabled WorkflowState = "Disabled"
	// WorkflowStateEnabled specifies the workflow state enabled state for
	// workflow state.
	WorkflowStateEnabled WorkflowState = "Enabled"
	// WorkflowStateNotSpecified specifies the workflow state not specified
	// state for workflow state.
	WorkflowStateNotSpecified WorkflowState = "NotSpecified"
	// WorkflowStateSuspended specifies the workflow state suspended state for
	// workflow state.
	WorkflowStateSuspended WorkflowState = "Suspended"
)

// WorkflowStatus enumerates the values for workflow status.
type WorkflowStatus string

const (
	// WorkflowStatusAborted specifies the workflow status aborted state for
	// workflow status.
	WorkflowStatusAborted WorkflowStatus = "Aborted"
	// WorkflowStatusCancelled specifies the workflow status cancelled state
	// for workflow status.
	WorkflowStatusCancelled WorkflowStatus = "Cancelled"
	// WorkflowStatusFailed specifies the workflow status failed state for
	// workflow status.
	WorkflowStatusFailed WorkflowStatus = "Failed"
	// WorkflowStatusFaulted specifies the workflow status faulted state for
	// workflow status.
	WorkflowStatusFaulted WorkflowStatus = "Faulted"
	// WorkflowStatusIgnored specifies the workflow status ignored state for
	// workflow status.
	WorkflowStatusIgnored WorkflowStatus = "Ignored"
	// WorkflowStatusNotSpecified specifies the workflow status not specified
	// state for workflow status.
	WorkflowStatusNotSpecified WorkflowStatus = "NotSpecified"
	// WorkflowStatusPaused specifies the workflow status paused state for
	// workflow status.
	WorkflowStatusPaused WorkflowStatus = "Paused"
	// WorkflowStatusRunning specifies the workflow status running state for
	// workflow status.
	WorkflowStatusRunning WorkflowStatus = "Running"
	// WorkflowStatusSkipped specifies the workflow status skipped state for
	// workflow status.
	WorkflowStatusSkipped WorkflowStatus = "Skipped"
	// WorkflowStatusSucceeded specifies the workflow status succeeded state
	// for workflow status.
	WorkflowStatusSucceeded WorkflowStatus = "Succeeded"
	// WorkflowStatusSuspended specifies the workflow status suspended state
	// for workflow status.
	WorkflowStatusSuspended WorkflowStatus = "Suspended"
	// WorkflowStatusTimedOut specifies the workflow status timed out state for
	// workflow status.
	WorkflowStatusTimedOut WorkflowStatus = "TimedOut"
	// WorkflowStatusWaiting specifies the workflow status waiting state for
	// workflow status.
	WorkflowStatusWaiting WorkflowStatus = "Waiting"
)

// WorkflowTriggerProvisioningState enumerates the values for workflow trigger
// provisioning state.
type WorkflowTriggerProvisioningState string

const (
	// WorkflowTriggerProvisioningStateAccepted specifies the workflow trigger
	// provisioning state accepted state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateAccepted WorkflowTriggerProvisioningState = "Accepted"
	// WorkflowTriggerProvisioningStateCanceled specifies the workflow trigger
	// provisioning state canceled state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateCanceled WorkflowTriggerProvisioningState = "Canceled"
	// WorkflowTriggerProvisioningStateCompleted specifies the workflow trigger
	// provisioning state completed state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateCompleted WorkflowTriggerProvisioningState = "Completed"
	// WorkflowTriggerProvisioningStateCreated specifies the workflow trigger
	// provisioning state created state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateCreated WorkflowTriggerProvisioningState = "Created"
	// WorkflowTriggerProvisioningStateCreating specifies the workflow trigger
	// provisioning state creating state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateCreating WorkflowTriggerProvisioningState = "Creating"
	// WorkflowTriggerProvisioningStateDeleted specifies the workflow trigger
	// provisioning state deleted state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateDeleted WorkflowTriggerProvisioningState = "Deleted"
	// WorkflowTriggerProvisioningStateDeleting specifies the workflow trigger
	// provisioning state deleting state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateDeleting WorkflowTriggerProvisioningState = "Deleting"
	// WorkflowTriggerProvisioningStateFailed specifies the workflow trigger
	// provisioning state failed state for workflow trigger provisioning state.
	WorkflowTriggerProvisioningStateFailed WorkflowTriggerProvisioningState = "Failed"
	// WorkflowTriggerProvisioningStateMoving specifies the workflow trigger
	// provisioning state moving state for workflow trigger provisioning state.
	WorkflowTriggerProvisioningStateMoving WorkflowTriggerProvisioningState = "Moving"
	// WorkflowTriggerProvisioningStateNotSpecified specifies the workflow
	// trigger provisioning state not specified state for workflow trigger
	// provisioning state.
	WorkflowTriggerProvisioningStateNotSpecified WorkflowTriggerProvisioningState = "NotSpecified"
	// WorkflowTriggerProvisioningStateReady specifies the workflow trigger
	// provisioning state ready state for workflow trigger provisioning state.
	WorkflowTriggerProvisioningStateReady WorkflowTriggerProvisioningState = "Ready"
	// WorkflowTriggerProvisioningStateRegistered specifies the workflow
	// trigger provisioning state registered state for workflow trigger
	// provisioning state.
	WorkflowTriggerProvisioningStateRegistered WorkflowTriggerProvisioningState = "Registered"
	// WorkflowTriggerProvisioningStateRegistering specifies the workflow
	// trigger provisioning state registering state for workflow trigger
	// provisioning state.
	WorkflowTriggerProvisioningStateRegistering WorkflowTriggerProvisioningState = "Registering"
	// WorkflowTriggerProvisioningStateRunning specifies the workflow trigger
	// provisioning state running state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateRunning WorkflowTriggerProvisioningState = "Running"
	// WorkflowTriggerProvisioningStateSucceeded specifies the workflow trigger
	// provisioning state succeeded state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateSucceeded WorkflowTriggerProvisioningState = "Succeeded"
	// WorkflowTriggerProvisioningStateUnregistered specifies the workflow
	// trigger provisioning state unregistered state for workflow trigger
	// provisioning state.
	WorkflowTriggerProvisioningStateUnregistered WorkflowTriggerProvisioningState = "Unregistered"
	// WorkflowTriggerProvisioningStateUnregistering specifies the workflow
	// trigger provisioning state unregistering state for workflow trigger
	// provisioning state.
	WorkflowTriggerProvisioningStateUnregistering WorkflowTriggerProvisioningState = "Unregistering"
	// WorkflowTriggerProvisioningStateUpdating specifies the workflow trigger
	// provisioning state updating state for workflow trigger provisioning
	// state.
	WorkflowTriggerProvisioningStateUpdating WorkflowTriggerProvisioningState = "Updating"
)

// X12CharacterSet enumerates the values for x12 character set.
type X12CharacterSet string

const (
	// X12CharacterSetBasic specifies the x12 character set basic state for x12
	// character set.
	X12CharacterSetBasic X12CharacterSet = "Basic"
	// X12CharacterSetExtended specifies the x12 character set extended state
	// for x12 character set.
	X12CharacterSetExtended X12CharacterSet = "Extended"
	// X12CharacterSetNotSpecified specifies the x12 character set not
	// specified state for x12 character set.
	X12CharacterSetNotSpecified X12CharacterSet = "NotSpecified"
	// X12CharacterSetUTF8 specifies the x12 character set utf8 state for x12
	// character set.
	X12CharacterSetUTF8 X12CharacterSet = "UTF8"
)

// X12DateFormat enumerates the values for x12 date format.
type X12DateFormat string

const (
	// X12DateFormatCCYYMMDD specifies the x12 date format ccyymmdd state for
	// x12 date format.
	X12DateFormatCCYYMMDD X12DateFormat = "CCYYMMDD"
	// X12DateFormatNotSpecified specifies the x12 date format not specified
	// state for x12 date format.
	X12DateFormatNotSpecified X12DateFormat = "NotSpecified"
	// X12DateFormatYYMMDD specifies the x12 date format yymmdd state for x12
	// date format.
	X12DateFormatYYMMDD X12DateFormat = "YYMMDD"
)

// X12TimeFormat enumerates the values for x12 time format.
type X12TimeFormat string

const (
	// X12TimeFormatHHMM specifies the x12 time format hhmm state for x12 time
	// format.
	X12TimeFormatHHMM X12TimeFormat = "HHMM"
	// X12TimeFormatHHMMSS specifies the x12 time format hhmmss state for x12
	// time format.
	X12TimeFormatHHMMSS X12TimeFormat = "HHMMSS"
	// X12TimeFormatHHMMSSd specifies the x12 time format hhmms sd state for
	// x12 time format.
	X12TimeFormatHHMMSSd X12TimeFormat = "HHMMSSd"
	// X12TimeFormatHHMMSSdd specifies the x12 time format hhmms sdd state for
	// x12 time format.
	X12TimeFormatHHMMSSdd X12TimeFormat = "HHMMSSdd"
	// X12TimeFormatNotSpecified specifies the x12 time format not specified
	// state for x12 time format.
	X12TimeFormatNotSpecified X12TimeFormat = "NotSpecified"
)

// AgreementContent is the integration account agreement content.
type AgreementContent struct {
	AS2     *AS2AgreementContent     `json:"aS2,omitempty"`
	X12     *X12AgreementContent     `json:"x12,omitempty"`
	Edifact *EdifactAgreementContent `json:"edifact,omitempty"`
}

// AS2AcknowledgementConnectionSettings is the AS2 agreement acknowledegment
// connection settings.
type AS2AcknowledgementConnectionSettings struct {
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`
	KeepHTTPConnectionAlive       *bool `json:"keepHttpConnectionAlive,omitempty"`
	UnfoldHTTPHeaders             *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2AgreementContent is the integration account AS2 agreement content.
type AS2AgreementContent struct {
	ReceiveAgreement *AS2OneWayAgreement `json:"receiveAgreement,omitempty"`
	SendAgreement    *AS2OneWayAgreement `json:"sendAgreement,omitempty"`
}

// AS2EnvelopeSettings is the AS2 agreement envelope settings.
type AS2EnvelopeSettings struct {
	MessageContentType                      *string `json:"messageContentType,omitempty"`
	TransmitFileNameInMimeHeader            *bool   `json:"transmitFileNameInMimeHeader,omitempty"`
	FileNameTemplate                        *string `json:"fileNameTemplate,omitempty"`
	SuspendMessageOnFileNameGenerationError *bool   `json:"suspendMessageOnFileNameGenerationError,omitempty"`
	AutogenerateFileName                    *bool   `json:"autogenerateFileName,omitempty"`
}

// AS2ErrorSettings is the AS2 agreement error settings.
type AS2ErrorSettings struct {
	SuspendDuplicateMessage *bool `json:"suspendDuplicateMessage,omitempty"`
	ResendIfMdnNotReceived  *bool `json:"resendIfMdnNotReceived,omitempty"`
}

// AS2MdnSettings is the AS2 agreement mdn settings.
type AS2MdnSettings struct {
	NeedMdn                    *bool            `json:"needMdn,omitempty"`
	SignMdn                    *bool            `json:"signMdn,omitempty"`
	SendMdnAsynchronously      *bool            `json:"sendMdnAsynchronously,omitempty"`
	ReceiptDeliveryURL         *string          `json:"receiptDeliveryUrl,omitempty"`
	DispositionNotificationTo  *string          `json:"dispositionNotificationTo,omitempty"`
	SignOutboundMdnIfOptional  *bool            `json:"signOutboundMdnIfOptional,omitempty"`
	MdnText                    *string          `json:"mdnText,omitempty"`
	SendInboundMdnToMessageBox *bool            `json:"sendInboundMdnToMessageBox,omitempty"`
	MicHashingAlgorithm        HashingAlgorithm `json:"micHashingAlgorithm,omitempty"`
}

// AS2MessageConnectionSettings is the AS2 agreement message connection
// settings.
type AS2MessageConnectionSettings struct {
	IgnoreCertificateNameMismatch *bool `json:"ignoreCertificateNameMismatch,omitempty"`
	SupportHTTPStatusCodeContinue *bool `json:"supportHttpStatusCodeContinue,omitempty"`
	KeepHTTPConnectionAlive       *bool `json:"keepHttpConnectionAlive,omitempty"`
	UnfoldHTTPHeaders             *bool `json:"unfoldHttpHeaders,omitempty"`
}

// AS2OneWayAgreement is the integration account AS2 oneway agreement.
type AS2OneWayAgreement struct {
	SenderBusinessIdentity   *BusinessIdentity    `json:"senderBusinessIdentity,omitempty"`
	ReceiverBusinessIdentity *BusinessIdentity    `json:"receiverBusinessIdentity,omitempty"`
	ProtocolSettings         *AS2ProtocolSettings `json:"protocolSettings,omitempty"`
}

// AS2ProtocolSettings is the AS2 agreement protocol settings.
type AS2ProtocolSettings struct {
	MessageConnectionSettings         *AS2MessageConnectionSettings         `json:"messageConnectionSettings,omitempty"`
	AcknowledgementConnectionSettings *AS2AcknowledgementConnectionSettings `json:"acknowledgementConnectionSettings,omitempty"`
	MdnSettings                       *AS2MdnSettings                       `json:"mdnSettings,omitempty"`
	SecuritySettings                  *AS2SecuritySettings                  `json:"securitySettings,omitempty"`
	ValidationSettings                *AS2ValidationSettings                `json:"validationSettings,omitempty"`
	EnvelopeSettings                  *AS2EnvelopeSettings                  `json:"envelopeSettings,omitempty"`
	ErrorSettings                     *AS2ErrorSettings                     `json:"errorSettings,omitempty"`
}

// AS2SecuritySettings is the AS2 agreement security settings.
type AS2SecuritySettings struct {
	OverrideGroupSigningCertificate     *bool   `json:"overrideGroupSigningCertificate,omitempty"`
	SigningCertificateName              *string `json:"signingCertificateName,omitempty"`
	EncryptionCertificateName           *string `json:"encryptionCertificateName,omitempty"`
	EnableNrrForInboundEncodedMessages  *bool   `json:"enableNrrForInboundEncodedMessages,omitempty"`
	EnableNrrForInboundDecodedMessages  *bool   `json:"enableNrrForInboundDecodedMessages,omitempty"`
	EnableNrrForOutboundMdn             *bool   `json:"enableNrrForOutboundMdn,omitempty"`
	EnableNrrForOutboundEncodedMessages *bool   `json:"enableNrrForOutboundEncodedMessages,omitempty"`
	EnableNrrForOutboundDecodedMessages *bool   `json:"enableNrrForOutboundDecodedMessages,omitempty"`
	EnableNrrForInboundMdn              *bool   `json:"enableNrrForInboundMdn,omitempty"`
	Sha2AlgorithmFormat                 *string `json:"sha2AlgorithmFormat,omitempty"`
}

// AS2ValidationSettings is the AS2 agreement validation settings.
type AS2ValidationSettings struct {
	OverrideMessageProperties               *bool               `json:"overrideMessageProperties,omitempty"`
	EncryptMessage                          *bool               `json:"encryptMessage,omitempty"`
	SignMessage                             *bool               `json:"signMessage,omitempty"`
	CompressMessage                         *bool               `json:"compressMessage,omitempty"`
	CheckDuplicateMessage                   *bool               `json:"checkDuplicateMessage,omitempty"`
	InterchangeDuplicatesValidityDays       *int32              `json:"interchangeDuplicatesValidityDays,omitempty"`
	CheckCertificateRevocationListOnSend    *bool               `json:"checkCertificateRevocationListOnSend,omitempty"`
	CheckCertificateRevocationListOnReceive *bool               `json:"checkCertificateRevocationListOnReceive,omitempty"`
	EncryptionAlgorithm                     EncryptionAlgorithm `json:"encryptionAlgorithm,omitempty"`
	SigningAlgorithm                        SigningAlgorithm    `json:"signingAlgorithm,omitempty"`
}

// B2BPartnerContent is the B2B partner content.
type B2BPartnerContent struct {
	BusinessIdentities *[]BusinessIdentity `json:"businessIdentities,omitempty"`
}

// BusinessIdentity is the integration account partner's business identity.
type BusinessIdentity struct {
	Qualifier *string `json:"qualifier,omitempty"`
	Value     *string `json:"value,omitempty"`
}

// CallbackURL is the callback url.
type CallbackURL struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// ContentHash is the content hash.
type ContentHash struct {
	Algorithm *string `json:"algorithm,omitempty"`
	Value     *string `json:"value,omitempty"`
}

// ContentLink is the content link.
type ContentLink struct {
	URI            *string                 `json:"uri,omitempty"`
	ContentVersion *string                 `json:"contentVersion,omitempty"`
	ContentSize    *int64                  `json:"contentSize,omitempty"`
	ContentHash    *ContentHash            `json:"contentHash,omitempty"`
	Metadata       *map[string]interface{} `json:"metadata,omitempty"`
}

// Correlation is the correlation property.
type Correlation struct {
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
}

// EdifactAcknowledgementSettings is the Edifact agreement acknowledgement
// settings.
type EdifactAcknowledgementSettings struct {
	NeedTechnicalAcknowledgement           *bool   `json:"needTechnicalAcknowledgement,omitempty"`
	BatchTechnicalAcknowledgements         *bool   `json:"batchTechnicalAcknowledgements,omitempty"`
	NeedFunctionalAcknowledgement          *bool   `json:"needFunctionalAcknowledgement,omitempty"`
	BatchFunctionalAcknowledgements        *bool   `json:"batchFunctionalAcknowledgements,omitempty"`
	NeedLoopForValidMessages               *bool   `json:"needLoopForValidMessages,omitempty"`
	SendSynchronousAcknowledgement         *bool   `json:"sendSynchronousAcknowledgement,omitempty"`
	AcknowledgementControlNumberPrefix     *string `json:"acknowledgementControlNumberPrefix,omitempty"`
	AcknowledgementControlNumberSuffix     *string `json:"acknowledgementControlNumberSuffix,omitempty"`
	AcknowledgementControlNumberLowerBound *int32  `json:"acknowledgementControlNumberLowerBound,omitempty"`
	AcknowledgementControlNumberUpperBound *int32  `json:"acknowledgementControlNumberUpperBound,omitempty"`
	RolloverAcknowledgementControlNumber   *bool   `json:"rolloverAcknowledgementControlNumber,omitempty"`
}

// EdifactAgreementContent is the Edifact agreement content.
type EdifactAgreementContent struct {
	ReceiveAgreement *EdifactOneWayAgreement `json:"receiveAgreement,omitempty"`
	SendAgreement    *EdifactOneWayAgreement `json:"sendAgreement,omitempty"`
}

// EdifactDelimiterOverride is the Edifact delimiter override settings.
type EdifactDelimiterOverride struct {
	MessageID                      *string                 `json:"messageId,omitempty"`
	MessageVersion                 *string                 `json:"messageVersion,omitempty"`
	MessageRelease                 *string                 `json:"messageRelease,omitempty"`
	DataElementSeparator           *int32                  `json:"dataElementSeparator,omitempty"`
	ComponentSeparator             *int32                  `json:"componentSeparator,omitempty"`
	SegmentTerminator              *int32                  `json:"segmentTerminator,omitempty"`
	RepetitionSeparator            *int32                  `json:"repetitionSeparator,omitempty"`
	SegmentTerminatorSuffix        SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
	DecimalPointIndicator          EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`
	ReleaseIndicator               *int32                  `json:"releaseIndicator,omitempty"`
	MessageAssociationAssignedCode *string                 `json:"messageAssociationAssignedCode,omitempty"`
	TargetNamespace                *string                 `json:"targetNamespace,omitempty"`
}

// EdifactEnvelopeOverride is the Edifact enevlope override settings.
type EdifactEnvelopeOverride struct {
	MessageID                      *string `json:"messageId,omitempty"`
	MessageVersion                 *string `json:"messageVersion,omitempty"`
	MessageRelease                 *string `json:"messageRelease,omitempty"`
	MessageAssociationAssignedCode *string `json:"messageAssociationAssignedCode,omitempty"`
	TargetNamespace                *string `json:"targetNamespace,omitempty"`
	FunctionalGroupID              *string `json:"functionalGroupId,omitempty"`
	SenderApplicationQualifier     *string `json:"senderApplicationQualifier,omitempty"`
	SenderApplicationID            *string `json:"senderApplicationId,omitempty"`
	ReceiverApplicationQualifier   *string `json:"receiverApplicationQualifier,omitempty"`
	ReceiverApplicationID          *string `json:"receiverApplicationId,omitempty"`
	ControllingAgencyCode          *string `json:"controllingAgencyCode,omitempty"`
	GroupHeaderMessageVersion      *string `json:"groupHeaderMessageVersion,omitempty"`
	GroupHeaderMessageRelease      *string `json:"groupHeaderMessageRelease,omitempty"`
	AssociationAssignedCode        *string `json:"associationAssignedCode,omitempty"`
	ApplicationPassword            *string `json:"applicationPassword,omitempty"`
}

// EdifactEnvelopeSettings is the Edifact agreement envelope settings.
type EdifactEnvelopeSettings struct {
	GroupAssociationAssignedCode                 *string `json:"groupAssociationAssignedCode,omitempty"`
	CommunicationAgreementID                     *string `json:"communicationAgreementId,omitempty"`
	ApplyDelimiterStringAdvice                   *bool   `json:"applyDelimiterStringAdvice,omitempty"`
	CreateGroupingSegments                       *bool   `json:"createGroupingSegments,omitempty"`
	EnableDefaultGroupHeaders                    *bool   `json:"enableDefaultGroupHeaders,omitempty"`
	RecipientReferencePasswordValue              *string `json:"recipientReferencePasswordValue,omitempty"`
	RecipientReferencePasswordQualifier          *string `json:"recipientReferencePasswordQualifier,omitempty"`
	ApplicationReferenceID                       *string `json:"applicationReferenceId,omitempty"`
	ProcessingPriorityCode                       *string `json:"processingPriorityCode,omitempty"`
	InterchangeControlNumberLowerBound           *int64  `json:"interchangeControlNumberLowerBound,omitempty"`
	InterchangeControlNumberUpperBound           *int64  `json:"interchangeControlNumberUpperBound,omitempty"`
	RolloverInterchangeControlNumber             *bool   `json:"rolloverInterchangeControlNumber,omitempty"`
	InterchangeControlNumberPrefix               *string `json:"interchangeControlNumberPrefix,omitempty"`
	InterchangeControlNumberSuffix               *string `json:"interchangeControlNumberSuffix,omitempty"`
	SenderReverseRoutingAddress                  *string `json:"senderReverseRoutingAddress,omitempty"`
	ReceiverReverseRoutingAddress                *string `json:"receiverReverseRoutingAddress,omitempty"`
	FunctionalGroupID                            *string `json:"functionalGroupId,omitempty"`
	GroupControllingAgencyCode                   *string `json:"groupControllingAgencyCode,omitempty"`
	GroupMessageVersion                          *string `json:"groupMessageVersion,omitempty"`
	GroupMessageRelease                          *string `json:"groupMessageRelease,omitempty"`
	GroupControlNumberLowerBound                 *int64  `json:"groupControlNumberLowerBound,omitempty"`
	GroupControlNumberUpperBound                 *int64  `json:"groupControlNumberUpperBound,omitempty"`
	RolloverGroupControlNumber                   *bool   `json:"rolloverGroupControlNumber,omitempty"`
	GroupControlNumberPrefix                     *string `json:"groupControlNumberPrefix,omitempty"`
	GroupControlNumberSuffix                     *string `json:"groupControlNumberSuffix,omitempty"`
	GroupApplicationReceiverQualifier            *string `json:"groupApplicationReceiverQualifier,omitempty"`
	GroupApplicationReceiverID                   *string `json:"groupApplicationReceiverId,omitempty"`
	GroupApplicationSenderQualifier              *string `json:"groupApplicationSenderQualifier,omitempty"`
	GroupApplicationSenderID                     *string `json:"groupApplicationSenderId,omitempty"`
	GroupApplicationPassword                     *string `json:"groupApplicationPassword,omitempty"`
	OverwriteExistingTransactionSetControlNumber *bool   `json:"overwriteExistingTransactionSetControlNumber,omitempty"`
	TransactionSetControlNumberPrefix            *string `json:"transactionSetControlNumberPrefix,omitempty"`
	TransactionSetControlNumberSuffix            *string `json:"transactionSetControlNumberSuffix,omitempty"`
	TransactionSetControlNumberLowerBound        *int64  `json:"transactionSetControlNumberLowerBound,omitempty"`
	TransactionSetControlNumberUpperBound        *int64  `json:"transactionSetControlNumberUpperBound,omitempty"`
	RolloverTransactionSetControlNumber          *bool   `json:"rolloverTransactionSetControlNumber,omitempty"`
	IsTestInterchange                            *bool   `json:"isTestInterchange,omitempty"`
	SenderInternalIdentification                 *string `json:"senderInternalIdentification,omitempty"`
	SenderInternalSubIdentification              *string `json:"senderInternalSubIdentification,omitempty"`
	ReceiverInternalIdentification               *string `json:"receiverInternalIdentification,omitempty"`
	ReceiverInternalSubIdentification            *string `json:"receiverInternalSubIdentification,omitempty"`
}

// EdifactFramingSettings is the Edifact agreement framing settings.
type EdifactFramingSettings struct {
	ServiceCodeListDirectoryVersion *string                 `json:"serviceCodeListDirectoryVersion,omitempty"`
	CharacterEncoding               *string                 `json:"characterEncoding,omitempty"`
	ProtocolVersion                 *int32                  `json:"protocolVersion,omitempty"`
	DataElementSeparator            *int32                  `json:"dataElementSeparator,omitempty"`
	ComponentSeparator              *int32                  `json:"componentSeparator,omitempty"`
	SegmentTerminator               *int32                  `json:"segmentTerminator,omitempty"`
	ReleaseIndicator                *int32                  `json:"releaseIndicator,omitempty"`
	RepetitionSeparator             *int32                  `json:"repetitionSeparator,omitempty"`
	CharacterSet                    EdifactCharacterSet     `json:"characterSet,omitempty"`
	DecimalPointIndicator           EdifactDecimalIndicator `json:"decimalPointIndicator,omitempty"`
	SegmentTerminatorSuffix         SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// EdifactMessageFilter is the Edifact message filter for odata query.
type EdifactMessageFilter struct {
	MessageFilterType MessageFilterType `json:"messageFilterType,omitempty"`
}

// EdifactMessageIdentifier is the Edifact message identifier.
type EdifactMessageIdentifier struct {
	MessageID *string `json:"messageId,omitempty"`
}

// EdifactOneWayAgreement is the Edifact one way agreement.
type EdifactOneWayAgreement struct {
	SenderBusinessIdentity   *BusinessIdentity        `json:"senderBusinessIdentity,omitempty"`
	ReceiverBusinessIdentity *BusinessIdentity        `json:"receiverBusinessIdentity,omitempty"`
	ProtocolSettings         *EdifactProtocolSettings `json:"protocolSettings,omitempty"`
}

// EdifactProcessingSettings is the Edifact agreement protocol settings.
type EdifactProcessingSettings struct {
	MaskSecurityInfo                        *bool `json:"maskSecurityInfo,omitempty"`
	PreserveInterchange                     *bool `json:"preserveInterchange,omitempty"`
	SuspendInterchangeOnError               *bool `json:"suspendInterchangeOnError,omitempty"`
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`
	UseDotAsDecimalSeparator                *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// EdifactProtocolSettings is the Edifact agreement protocol settings.
type EdifactProtocolSettings struct {
	ValidationSettings        *EdifactValidationSettings      `json:"validationSettings,omitempty"`
	FramingSettings           *EdifactFramingSettings         `json:"framingSettings,omitempty"`
	EnvelopeSettings          *EdifactEnvelopeSettings        `json:"envelopeSettings,omitempty"`
	AcknowledgementSettings   *EdifactAcknowledgementSettings `json:"acknowledgementSettings,omitempty"`
	MessageFilter             *EdifactMessageFilter           `json:"messageFilter,omitempty"`
	ProcessingSettings        *EdifactProcessingSettings      `json:"processingSettings,omitempty"`
	EnvelopeOverrides         *[]EdifactEnvelopeOverride      `json:"envelopeOverrides,omitempty"`
	MessageFilterList         *[]EdifactMessageIdentifier     `json:"messageFilterList,omitempty"`
	SchemaReferences          *[]EdifactSchemaReference       `json:"schemaReferences,omitempty"`
	ValidationOverrides       *[]EdifactValidationOverride    `json:"validationOverrides,omitempty"`
	EdifactDelimiterOverrides *[]EdifactDelimiterOverride     `json:"edifactDelimiterOverrides,omitempty"`
}

// EdifactSchemaReference is the Edifact schema reference.
type EdifactSchemaReference struct {
	MessageID                  *string `json:"messageId,omitempty"`
	MessageVersion             *string `json:"messageVersion,omitempty"`
	MessageRelease             *string `json:"messageRelease,omitempty"`
	SenderApplicationID        *string `json:"senderApplicationId,omitempty"`
	SenderApplicationQualifier *string `json:"senderApplicationQualifier,omitempty"`
	AssociationAssignedCode    *string `json:"associationAssignedCode,omitempty"`
	SchemaName                 *string `json:"schemaName,omitempty"`
}

// EdifactValidationOverride is the Edifact validation override settings.
type EdifactValidationOverride struct {
	MessageID                              *string                 `json:"messageId,omitempty"`
	EnforceCharacterSet                    *bool                   `json:"enforceCharacterSet,omitempty"`
	ValidateEdiTypes                       *bool                   `json:"validateEdiTypes,omitempty"`
	ValidateXsdTypes                       *bool                   `json:"validateXsdTypes,omitempty"`
	AllowLeadingAndTrailingSpacesAndZeroes *bool                   `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrailingSeparatorPolicy                TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
	TrimLeadingAndTrailingSpacesAndZeroes  *bool                   `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
}

// EdifactValidationSettings is the Edifact agreement validation settings.
type EdifactValidationSettings struct {
	ValidateCharacterSet                      *bool                   `json:"validateCharacterSet,omitempty"`
	CheckDuplicateInterchangeControlNumber    *bool                   `json:"checkDuplicateInterchangeControlNumber,omitempty"`
	InterchangeControlNumberValidityDays      *int32                  `json:"interchangeControlNumberValidityDays,omitempty"`
	CheckDuplicateGroupControlNumber          *bool                   `json:"checkDuplicateGroupControlNumber,omitempty"`
	CheckDuplicateTransactionSetControlNumber *bool                   `json:"checkDuplicateTransactionSetControlNumber,omitempty"`
	ValidateEdiTypes                          *bool                   `json:"validateEdiTypes,omitempty"`
	ValidateXsdTypes                          *bool                   `json:"validateXsdTypes,omitempty"`
	AllowLeadingAndTrailingSpacesAndZeroes    *bool                   `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrimLeadingAndTrailingSpacesAndZeroes     *bool                   `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrailingSeparatorPolicy                   TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}

// ErrorProperties is error properties indicate why the Logic service was not
// able to process the incoming request. The reason is provided in the error
// message.
type ErrorProperties struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ErrorResponse is error reponse indicates Logic service is not able to
// process the incoming request. The error property contains the error details.
type ErrorResponse struct {
	Error *ErrorProperties `json:"error,omitempty"`
}

// GenerateUpgradedDefinitionParameters is the parameters to generate upgraded
// definition.
type GenerateUpgradedDefinitionParameters struct {
	TargetSchemaVersion *string `json:"targetSchemaVersion,omitempty"`
}

// GetCallbackURLParameters is the callback url parameters.
type GetCallbackURLParameters struct {
	NotAfter *date.Time `json:"notAfter,omitempty"`
	KeyType  KeyType    `json:"keyType,omitempty"`
}

// IntegrationAccount is the integration account.
type IntegrationAccount struct {
	autorest.Response `json:"-"`
	ID                *string                 `json:"id,omitempty"`
	Name              *string                 `json:"name,omitempty"`
	Type              *string                 `json:"type,omitempty"`
	Location          *string                 `json:"location,omitempty"`
	Tags              *map[string]*string     `json:"tags,omitempty"`
	Properties        *map[string]interface{} `json:"properties,omitempty"`
	Sku               *IntegrationAccountSku  `json:"sku,omitempty"`
}

// IntegrationAccountAgreement is the integration account agreement.
type IntegrationAccountAgreement struct {
	autorest.Response                      `json:"-"`
	ID                                     *string             `json:"id,omitempty"`
	Name                                   *string             `json:"name,omitempty"`
	Type                                   *string             `json:"type,omitempty"`
	Location                               *string             `json:"location,omitempty"`
	Tags                                   *map[string]*string `json:"tags,omitempty"`
	*IntegrationAccountAgreementProperties `json:"properties,omitempty"`
}

// IntegrationAccountAgreementFilter is the integration account agreement
// filter for odata query.
type IntegrationAccountAgreementFilter struct {
	AgreementType AgreementType `json:"agreementType,omitempty"`
}

// IntegrationAccountAgreementListResult is the list of integration account
// agreements.
type IntegrationAccountAgreementListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountAgreement `json:"value,omitempty"`
	NextLink          *string                        `json:"nextLink,omitempty"`
}

// IntegrationAccountAgreementListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountAgreementListResult) IntegrationAccountAgreementListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountAgreementProperties is the integration account agreement
// properties.
type IntegrationAccountAgreementProperties struct {
	CreatedTime   *date.Time              `json:"createdTime,omitempty"`
	ChangedTime   *date.Time              `json:"changedTime,omitempty"`
	Metadata      *map[string]interface{} `json:"metadata,omitempty"`
	AgreementType AgreementType           `json:"agreementType,omitempty"`
	HostPartner   *string                 `json:"hostPartner,omitempty"`
	GuestPartner  *string                 `json:"guestPartner,omitempty"`
	HostIdentity  *BusinessIdentity       `json:"hostIdentity,omitempty"`
	GuestIdentity *BusinessIdentity       `json:"guestIdentity,omitempty"`
	Content       *AgreementContent       `json:"content,omitempty"`
}

// IntegrationAccountCertificate is the integration account certificate.
type IntegrationAccountCertificate struct {
	autorest.Response                        `json:"-"`
	ID                                       *string             `json:"id,omitempty"`
	Name                                     *string             `json:"name,omitempty"`
	Type                                     *string             `json:"type,omitempty"`
	Location                                 *string             `json:"location,omitempty"`
	Tags                                     *map[string]*string `json:"tags,omitempty"`
	*IntegrationAccountCertificateProperties `json:"properties,omitempty"`
}

// IntegrationAccountCertificateListResult is the list of integration account
// certificates.
type IntegrationAccountCertificateListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountCertificate `json:"value,omitempty"`
	NextLink          *string                          `json:"nextLink,omitempty"`
}

// IntegrationAccountCertificateListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountCertificateListResult) IntegrationAccountCertificateListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountCertificateProperties is the integration account
// certificate properties.
type IntegrationAccountCertificateProperties struct {
	CreatedTime       *date.Time              `json:"createdTime,omitempty"`
	ChangedTime       *date.Time              `json:"changedTime,omitempty"`
	Metadata          *map[string]interface{} `json:"metadata,omitempty"`
	Key               *KeyVaultKeyReference   `json:"key,omitempty"`
	PublicCertificate *string                 `json:"publicCertificate,omitempty"`
}

// IntegrationAccountListResult is the list of integration accounts.
type IntegrationAccountListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccount `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// IntegrationAccountListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountListResult) IntegrationAccountListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountMap is the integration account map.
type IntegrationAccountMap struct {
	autorest.Response                `json:"-"`
	ID                               *string             `json:"id,omitempty"`
	Name                             *string             `json:"name,omitempty"`
	Type                             *string             `json:"type,omitempty"`
	Location                         *string             `json:"location,omitempty"`
	Tags                             *map[string]*string `json:"tags,omitempty"`
	*IntegrationAccountMapProperties `json:"properties,omitempty"`
}

// IntegrationAccountMapFilter is the integration account map filter for odata
// query.
type IntegrationAccountMapFilter struct {
	MapType MapType `json:"mapType,omitempty"`
}

// IntegrationAccountMapListResult is the list of integration account maps.
type IntegrationAccountMapListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountMap `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// IntegrationAccountMapListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountMapListResult) IntegrationAccountMapListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountMapProperties is the integration account map.
type IntegrationAccountMapProperties struct {
	MapType          MapType                                          `json:"mapType,omitempty"`
	ParametersSchema *IntegrationAccountMapPropertiesParametersSchema `json:"parametersSchema,omitempty"`
	CreatedTime      *date.Time                                       `json:"createdTime,omitempty"`
	ChangedTime      *date.Time                                       `json:"changedTime,omitempty"`
	Content          *string                                          `json:"content,omitempty"`
	ContentType      *string                                          `json:"contentType,omitempty"`
	ContentLink      *ContentLink                                     `json:"contentLink,omitempty"`
	Metadata         *map[string]interface{}                          `json:"metadata,omitempty"`
}

// IntegrationAccountMapPropertiesParametersSchema is the parameters schema of
// integration account map.
type IntegrationAccountMapPropertiesParametersSchema struct {
	Ref *string `json:"ref,omitempty"`
}

// IntegrationAccountPartner is the integration account partner.
type IntegrationAccountPartner struct {
	autorest.Response                    `json:"-"`
	ID                                   *string             `json:"id,omitempty"`
	Name                                 *string             `json:"name,omitempty"`
	Type                                 *string             `json:"type,omitempty"`
	Location                             *string             `json:"location,omitempty"`
	Tags                                 *map[string]*string `json:"tags,omitempty"`
	*IntegrationAccountPartnerProperties `json:"properties,omitempty"`
}

// IntegrationAccountPartnerFilter is the integration account partner filter
// for odata query.
type IntegrationAccountPartnerFilter struct {
	PartnerType PartnerType `json:"partnerType,omitempty"`
}

// IntegrationAccountPartnerListResult is the list of integration account
// partners.
type IntegrationAccountPartnerListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountPartner `json:"value,omitempty"`
	NextLink          *string                      `json:"nextLink,omitempty"`
}

// IntegrationAccountPartnerListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountPartnerListResult) IntegrationAccountPartnerListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountPartnerProperties is the integration account partner
// properties.
type IntegrationAccountPartnerProperties struct {
	PartnerType PartnerType             `json:"partnerType,omitempty"`
	CreatedTime *date.Time              `json:"createdTime,omitempty"`
	ChangedTime *date.Time              `json:"changedTime,omitempty"`
	Metadata    *map[string]interface{} `json:"metadata,omitempty"`
	Content     *PartnerContent         `json:"content,omitempty"`
}

// IntegrationAccountSchema is the integration account schema.
type IntegrationAccountSchema struct {
	autorest.Response                   `json:"-"`
	ID                                  *string             `json:"id,omitempty"`
	Name                                *string             `json:"name,omitempty"`
	Type                                *string             `json:"type,omitempty"`
	Location                            *string             `json:"location,omitempty"`
	Tags                                *map[string]*string `json:"tags,omitempty"`
	*IntegrationAccountSchemaProperties `json:"properties,omitempty"`
}

// IntegrationAccountSchemaFilter is the integration account schema filter for
// odata query.
type IntegrationAccountSchemaFilter struct {
	SchemaType SchemaType `json:"schemaType,omitempty"`
}

// IntegrationAccountSchemaListResult is the list of integration account
// schemas.
type IntegrationAccountSchemaListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountSchema `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// IntegrationAccountSchemaListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountSchemaListResult) IntegrationAccountSchemaListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountSchemaProperties is the integration account schema
// properties.
type IntegrationAccountSchemaProperties struct {
	SchemaType      SchemaType              `json:"schemaType,omitempty"`
	TargetNamespace *string                 `json:"targetNamespace,omitempty"`
	DocumentName    *string                 `json:"documentName,omitempty"`
	FileName        *string                 `json:"fileName,omitempty"`
	CreatedTime     *date.Time              `json:"createdTime,omitempty"`
	ChangedTime     *date.Time              `json:"changedTime,omitempty"`
	Metadata        *map[string]interface{} `json:"metadata,omitempty"`
	Content         *string                 `json:"content,omitempty"`
	ContentType     *string                 `json:"contentType,omitempty"`
	ContentLink     *ContentLink            `json:"contentLink,omitempty"`
}

// IntegrationAccountSession is the integration account session.
type IntegrationAccountSession struct {
	autorest.Response                    `json:"-"`
	ID                                   *string             `json:"id,omitempty"`
	Name                                 *string             `json:"name,omitempty"`
	Type                                 *string             `json:"type,omitempty"`
	Location                             *string             `json:"location,omitempty"`
	Tags                                 *map[string]*string `json:"tags,omitempty"`
	*IntegrationAccountSessionProperties `json:"properties,omitempty"`
}

// IntegrationAccountSessionFilter is the integration account session filter.
type IntegrationAccountSessionFilter struct {
	ChangedTime *date.Time `json:"changedTime,omitempty"`
}

// IntegrationAccountSessionListResult is the list of integration account
// sessions.
type IntegrationAccountSessionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]IntegrationAccountSession `json:"value,omitempty"`
	NextLink          *string                      `json:"nextLink,omitempty"`
}

// IntegrationAccountSessionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IntegrationAccountSessionListResult) IntegrationAccountSessionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IntegrationAccountSessionProperties is the integration account session
// properties.
type IntegrationAccountSessionProperties struct {
	CreatedTime *date.Time              `json:"createdTime,omitempty"`
	ChangedTime *date.Time              `json:"changedTime,omitempty"`
	Content     *map[string]interface{} `json:"content,omitempty"`
}

// IntegrationAccountSku is the integration account sku.
type IntegrationAccountSku struct {
	Name IntegrationAccountSkuName `json:"name,omitempty"`
}

// KeyVaultKeyReference is the reference to the key vault key.
type KeyVaultKeyReference struct {
	KeyVault   *KeyVaultKeyReferenceKeyVault `json:"keyVault,omitempty"`
	KeyName    *string                       `json:"keyName,omitempty"`
	KeyVersion *string                       `json:"keyVersion,omitempty"`
}

// KeyVaultKeyReferenceKeyVault is the key vault reference.
type KeyVaultKeyReferenceKeyVault struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// Operation is logic REST API operation
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is the object that represents the operation.
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult is result of the request to list Logic operations. It
// contains a list of operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PartnerContent is the integration account partner content.
type PartnerContent struct {
	B2b *B2BPartnerContent `json:"b2b,omitempty"`
}

// RecurrenceSchedule is the recurrence schedule.
type RecurrenceSchedule struct {
	Minutes            *[]int32                        `json:"minutes,omitempty"`
	Hours              *[]int32                        `json:"hours,omitempty"`
	WeekDays           *[]DaysOfWeek                   `json:"weekDays,omitempty"`
	MonthDays          *[]int32                        `json:"monthDays,omitempty"`
	MonthlyOccurrences *[]RecurrenceScheduleOccurrence `json:"monthlyOccurrences,omitempty"`
}

// RecurrenceScheduleOccurrence is the recurrence schedule occurence.
type RecurrenceScheduleOccurrence struct {
	Day        DayOfWeek `json:"day,omitempty"`
	Occurrence *int32    `json:"occurrence,omitempty"`
}

// RegenerateActionParameter is the access key regenerate action content.
type RegenerateActionParameter struct {
	KeyType KeyType `json:"keyType,omitempty"`
}

// Resource is the base resource type.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceReference is the resource reference.
type ResourceReference struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// RetryHistory is the retry history.
type RetryHistory struct {
	StartTime        *date.Time     `json:"startTime,omitempty"`
	EndTime          *date.Time     `json:"endTime,omitempty"`
	Code             *string        `json:"code,omitempty"`
	ClientRequestID  *string        `json:"clientRequestId,omitempty"`
	ServiceRequestID *string        `json:"serviceRequestId,omitempty"`
	Error            *ErrorResponse `json:"error,omitempty"`
}

// SetObject is
type SetObject struct {
	autorest.Response `json:"-"`
	Value             *map[string]interface{} `json:"value,omitempty"`
}

// Sku is the sku type.
type Sku struct {
	Name SkuName            `json:"name,omitempty"`
	Plan *ResourceReference `json:"plan,omitempty"`
}

// SubResource is the sub resource type.
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// Workflow is the workflow type.
type Workflow struct {
	autorest.Response   `json:"-"`
	ID                  *string             `json:"id,omitempty"`
	Name                *string             `json:"name,omitempty"`
	Type                *string             `json:"type,omitempty"`
	Location            *string             `json:"location,omitempty"`
	Tags                *map[string]*string `json:"tags,omitempty"`
	*WorkflowProperties `json:"properties,omitempty"`
}

// WorkflowFilter is the workflow filter.
type WorkflowFilter struct {
	State WorkflowState `json:"state,omitempty"`
}

// WorkflowListResult is the list of workflows.
type WorkflowListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Workflow `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// WorkflowListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WorkflowListResult) WorkflowListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WorkflowOutputParameter is the workflow output parameter.
type WorkflowOutputParameter struct {
	Type        ParameterType           `json:"type,omitempty"`
	Value       *map[string]interface{} `json:"value,omitempty"`
	Metadata    *map[string]interface{} `json:"metadata,omitempty"`
	Description *string                 `json:"description,omitempty"`
	Error       *map[string]interface{} `json:"error,omitempty"`
}

// WorkflowParameter is the workflow parameters.
type WorkflowParameter struct {
	Type        ParameterType           `json:"type,omitempty"`
	Value       *map[string]interface{} `json:"value,omitempty"`
	Metadata    *map[string]interface{} `json:"metadata,omitempty"`
	Description *string                 `json:"description,omitempty"`
}

// WorkflowProperties is the workflow properties.
type WorkflowProperties struct {
	ProvisioningState  WorkflowProvisioningState      `json:"provisioningState,omitempty"`
	CreatedTime        *date.Time                     `json:"createdTime,omitempty"`
	ChangedTime        *date.Time                     `json:"changedTime,omitempty"`
	State              WorkflowState                  `json:"state,omitempty"`
	Version            *string                        `json:"version,omitempty"`
	AccessEndpoint     *string                        `json:"accessEndpoint,omitempty"`
	Sku                *Sku                           `json:"sku,omitempty"`
	IntegrationAccount *ResourceReference             `json:"integrationAccount,omitempty"`
	Definition         *map[string]interface{}        `json:"definition,omitempty"`
	Parameters         *map[string]*WorkflowParameter `json:"parameters,omitempty"`
}

// WorkflowRun is the workflow run.
type WorkflowRun struct {
	autorest.Response      `json:"-"`
	ID                     *string `json:"id,omitempty"`
	*WorkflowRunProperties `json:"properties,omitempty"`
	Name                   *string `json:"name,omitempty"`
	Type                   *string `json:"type,omitempty"`
}

// WorkflowRunAction is the workflow run action.
type WorkflowRunAction struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	*WorkflowRunActionProperties `json:"properties,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
}

// WorkflowRunActionFilter is the workflow run action filter.
type WorkflowRunActionFilter struct {
	Status WorkflowStatus `json:"status,omitempty"`
}

// WorkflowRunActionListResult is the list of workflow run actions.
type WorkflowRunActionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]WorkflowRunAction `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// WorkflowRunActionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WorkflowRunActionListResult) WorkflowRunActionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WorkflowRunActionProperties is the workflow run action properties.
type WorkflowRunActionProperties struct {
	StartTime         *date.Time              `json:"startTime,omitempty"`
	EndTime           *date.Time              `json:"endTime,omitempty"`
	Status            WorkflowStatus          `json:"status,omitempty"`
	Code              *string                 `json:"code,omitempty"`
	Error             *map[string]interface{} `json:"error,omitempty"`
	TrackingID        *string                 `json:"trackingId,omitempty"`
	Correlation       *Correlation            `json:"correlation,omitempty"`
	InputsLink        *ContentLink            `json:"inputsLink,omitempty"`
	OutputsLink       *ContentLink            `json:"outputsLink,omitempty"`
	TrackedProperties *map[string]interface{} `json:"trackedProperties,omitempty"`
	RetryHistory      *[]RetryHistory         `json:"retryHistory,omitempty"`
}

// WorkflowRunFilter is the workflow run filter.
type WorkflowRunFilter struct {
	Status WorkflowStatus `json:"status,omitempty"`
}

// WorkflowRunListResult is the list of workflow runs.
type WorkflowRunListResult struct {
	autorest.Response `json:"-"`
	Value             *[]WorkflowRun `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// WorkflowRunListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WorkflowRunListResult) WorkflowRunListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WorkflowRunProperties is the workflow run properties.
type WorkflowRunProperties struct {
	StartTime     *date.Time                           `json:"startTime,omitempty"`
	EndTime       *date.Time                           `json:"endTime,omitempty"`
	Status        WorkflowStatus                       `json:"status,omitempty"`
	Code          *string                              `json:"code,omitempty"`
	Error         *map[string]interface{}              `json:"error,omitempty"`
	CorrelationID *string                              `json:"correlationId,omitempty"`
	Correlation   *Correlation                         `json:"correlation,omitempty"`
	Workflow      *ResourceReference                   `json:"workflow,omitempty"`
	Trigger       *WorkflowRunTrigger                  `json:"trigger,omitempty"`
	Outputs       *map[string]*WorkflowOutputParameter `json:"outputs,omitempty"`
	Response      *WorkflowRunTrigger                  `json:"response,omitempty"`
}

// WorkflowRunTrigger is the workflow run trigger.
type WorkflowRunTrigger struct {
	Name              *string                 `json:"name,omitempty"`
	Inputs            *map[string]interface{} `json:"inputs,omitempty"`
	InputsLink        *ContentLink            `json:"inputsLink,omitempty"`
	Outputs           *map[string]interface{} `json:"outputs,omitempty"`
	OutputsLink       *ContentLink            `json:"outputsLink,omitempty"`
	StartTime         *date.Time              `json:"startTime,omitempty"`
	EndTime           *date.Time              `json:"endTime,omitempty"`
	TrackingID        *string                 `json:"trackingId,omitempty"`
	Correlation       *Correlation            `json:"correlation,omitempty"`
	Code              *string                 `json:"code,omitempty"`
	Status            WorkflowStatus          `json:"status,omitempty"`
	Error             *map[string]interface{} `json:"error,omitempty"`
	TrackedProperties *map[string]interface{} `json:"trackedProperties,omitempty"`
}

// WorkflowTrigger is the workflow trigger.
type WorkflowTrigger struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	*WorkflowTriggerProperties `json:"properties,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
}

// WorkflowTriggerCallbackURL is the workflow trigger callback URL.
type WorkflowTriggerCallbackURL struct {
	autorest.Response      `json:"-"`
	Value                  *string                                `json:"value,omitempty"`
	Method                 *string                                `json:"method,omitempty"`
	BasePath               *string                                `json:"basePath,omitempty"`
	RelativePath           *string                                `json:"relativePath,omitempty"`
	RelativePathParameters *[]string                              `json:"relativePathParameters,omitempty"`
	Queries                *WorkflowTriggerListCallbackURLQueries `json:"queries,omitempty"`
}

// WorkflowTriggerFilter is the workflow trigger filter.
type WorkflowTriggerFilter struct {
	State WorkflowState `json:"state,omitempty"`
}

// WorkflowTriggerHistory is the workflow trigger history.
type WorkflowTriggerHistory struct {
	autorest.Response                 `json:"-"`
	ID                                *string `json:"id,omitempty"`
	*WorkflowTriggerHistoryProperties `json:"properties,omitempty"`
	Name                              *string `json:"name,omitempty"`
	Type                              *string `json:"type,omitempty"`
}

// WorkflowTriggerHistoryFilter is the workflow trigger history filter.
type WorkflowTriggerHistoryFilter struct {
	Status WorkflowStatus `json:"status,omitempty"`
}

// WorkflowTriggerHistoryListResult is the list of workflow trigger histories.
type WorkflowTriggerHistoryListResult struct {
	autorest.Response `json:"-"`
	Value             *[]WorkflowTriggerHistory `json:"value,omitempty"`
	NextLink          *string                   `json:"nextLink,omitempty"`
}

// WorkflowTriggerHistoryListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WorkflowTriggerHistoryListResult) WorkflowTriggerHistoryListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WorkflowTriggerHistoryProperties is the workflow trigger history properties.
type WorkflowTriggerHistoryProperties struct {
	StartTime   *date.Time              `json:"startTime,omitempty"`
	EndTime     *date.Time              `json:"endTime,omitempty"`
	Status      WorkflowStatus          `json:"status,omitempty"`
	Code        *string                 `json:"code,omitempty"`
	Error       *map[string]interface{} `json:"error,omitempty"`
	TrackingID  *string                 `json:"trackingId,omitempty"`
	Correlation *Correlation            `json:"correlation,omitempty"`
	InputsLink  *ContentLink            `json:"inputsLink,omitempty"`
	OutputsLink *ContentLink            `json:"outputsLink,omitempty"`
	Fired       *bool                   `json:"fired,omitempty"`
	Run         *ResourceReference      `json:"run,omitempty"`
}

// WorkflowTriggerListCallbackURLQueries is gets the workflow trigger callback
// URL query parameters.
type WorkflowTriggerListCallbackURLQueries struct {
	APIVersion *string `json:"api-version,omitempty"`
	Sp         *string `json:"sp,omitempty"`
	Sv         *string `json:"sv,omitempty"`
	Sig        *string `json:"sig,omitempty"`
}

// WorkflowTriggerListResult is the list of workflow triggers.
type WorkflowTriggerListResult struct {
	autorest.Response `json:"-"`
	Value             *[]WorkflowTrigger `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// WorkflowTriggerListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WorkflowTriggerListResult) WorkflowTriggerListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WorkflowTriggerProperties is the workflow trigger properties.
type WorkflowTriggerProperties struct {
	ProvisioningState WorkflowTriggerProvisioningState `json:"provisioningState,omitempty"`
	CreatedTime       *date.Time                       `json:"createdTime,omitempty"`
	ChangedTime       *date.Time                       `json:"changedTime,omitempty"`
	State             WorkflowState                    `json:"state,omitempty"`
	Status            WorkflowStatus                   `json:"status,omitempty"`
	LastExecutionTime *date.Time                       `json:"lastExecutionTime,omitempty"`
	NextExecutionTime *date.Time                       `json:"nextExecutionTime,omitempty"`
	Recurrence        *WorkflowTriggerRecurrence       `json:"recurrence,omitempty"`
	Workflow          *ResourceReference               `json:"workflow,omitempty"`
}

// WorkflowTriggerRecurrence is the workflow trigger recurrence.
type WorkflowTriggerRecurrence struct {
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	Interval  *int32              `json:"interval,omitempty"`
	StartTime *date.Time          `json:"startTime,omitempty"`
	EndTime   *date.Time          `json:"endTime,omitempty"`
	TimeZone  *string             `json:"timeZone,omitempty"`
	Schedule  *RecurrenceSchedule `json:"schedule,omitempty"`
}

// WorkflowVersion is the workflow version.
type WorkflowVersion struct {
	autorest.Response          `json:"-"`
	ID                         *string             `json:"id,omitempty"`
	Name                       *string             `json:"name,omitempty"`
	Type                       *string             `json:"type,omitempty"`
	Location                   *string             `json:"location,omitempty"`
	Tags                       *map[string]*string `json:"tags,omitempty"`
	*WorkflowVersionProperties `json:"properties,omitempty"`
}

// WorkflowVersionListResult is the list of workflow versions.
type WorkflowVersionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]WorkflowVersion `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// WorkflowVersionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WorkflowVersionListResult) WorkflowVersionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WorkflowVersionProperties is the workflow version properties.
type WorkflowVersionProperties struct {
	CreatedTime        *date.Time                     `json:"createdTime,omitempty"`
	ChangedTime        *date.Time                     `json:"changedTime,omitempty"`
	State              WorkflowState                  `json:"state,omitempty"`
	Version            *string                        `json:"version,omitempty"`
	AccessEndpoint     *string                        `json:"accessEndpoint,omitempty"`
	Sku                *Sku                           `json:"sku,omitempty"`
	IntegrationAccount *ResourceReference             `json:"integrationAccount,omitempty"`
	Definition         *map[string]interface{}        `json:"definition,omitempty"`
	Parameters         *map[string]*WorkflowParameter `json:"parameters,omitempty"`
}

// X12AcknowledgementSettings is the X12 agreement acknowledgement settings.
type X12AcknowledgementSettings struct {
	NeedTechnicalAcknowledgement           *bool   `json:"needTechnicalAcknowledgement,omitempty"`
	BatchTechnicalAcknowledgements         *bool   `json:"batchTechnicalAcknowledgements,omitempty"`
	NeedFunctionalAcknowledgement          *bool   `json:"needFunctionalAcknowledgement,omitempty"`
	FunctionalAcknowledgementVersion       *string `json:"functionalAcknowledgementVersion,omitempty"`
	BatchFunctionalAcknowledgements        *bool   `json:"batchFunctionalAcknowledgements,omitempty"`
	NeedImplementationAcknowledgement      *bool   `json:"needImplementationAcknowledgement,omitempty"`
	ImplementationAcknowledgementVersion   *string `json:"implementationAcknowledgementVersion,omitempty"`
	BatchImplementationAcknowledgements    *bool   `json:"batchImplementationAcknowledgements,omitempty"`
	NeedLoopForValidMessages               *bool   `json:"needLoopForValidMessages,omitempty"`
	SendSynchronousAcknowledgement         *bool   `json:"sendSynchronousAcknowledgement,omitempty"`
	AcknowledgementControlNumberPrefix     *string `json:"acknowledgementControlNumberPrefix,omitempty"`
	AcknowledgementControlNumberSuffix     *string `json:"acknowledgementControlNumberSuffix,omitempty"`
	AcknowledgementControlNumberLowerBound *int32  `json:"acknowledgementControlNumberLowerBound,omitempty"`
	AcknowledgementControlNumberUpperBound *int32  `json:"acknowledgementControlNumberUpperBound,omitempty"`
	RolloverAcknowledgementControlNumber   *bool   `json:"rolloverAcknowledgementControlNumber,omitempty"`
}

// X12AgreementContent is the X12 agreement content.
type X12AgreementContent struct {
	ReceiveAgreement *X12OneWayAgreement `json:"receiveAgreement,omitempty"`
	SendAgreement    *X12OneWayAgreement `json:"sendAgreement,omitempty"`
}

// X12DelimiterOverrides is the X12 delimiter override settings.
type X12DelimiterOverrides struct {
	ProtocolVersion            *string                 `json:"protocolVersion,omitempty"`
	MessageID                  *string                 `json:"messageId,omitempty"`
	DataElementSeparator       *int32                  `json:"dataElementSeparator,omitempty"`
	ComponentSeparator         *int32                  `json:"componentSeparator,omitempty"`
	SegmentTerminator          *int32                  `json:"segmentTerminator,omitempty"`
	SegmentTerminatorSuffix    SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
	ReplaceCharacter           *int32                  `json:"replaceCharacter,omitempty"`
	ReplaceSeparatorsInPayload *bool                   `json:"replaceSeparatorsInPayload,omitempty"`
	TargetNamespace            *string                 `json:"targetNamespace,omitempty"`
}

// X12EnvelopeOverride is the X12 envelope override settings.
type X12EnvelopeOverride struct {
	TargetNamespace          *string       `json:"targetNamespace,omitempty"`
	ProtocolVersion          *string       `json:"protocolVersion,omitempty"`
	MessageID                *string       `json:"messageId,omitempty"`
	ResponsibleAgencyCode    *string       `json:"responsibleAgencyCode,omitempty"`
	HeaderVersion            *string       `json:"headerVersion,omitempty"`
	SenderApplicationID      *string       `json:"senderApplicationId,omitempty"`
	ReceiverApplicationID    *string       `json:"receiverApplicationId,omitempty"`
	FunctionalIdentifierCode *string       `json:"functionalIdentifierCode,omitempty"`
	DateFormat               X12DateFormat `json:"dateFormat,omitempty"`
	TimeFormat               X12TimeFormat `json:"timeFormat,omitempty"`
}

// X12EnvelopeSettings is the X12 agreement envelope settings.
type X12EnvelopeSettings struct {
	ControlStandardsID                           *int32         `json:"controlStandardsId,omitempty"`
	UseControlStandardsIDAsRepetitionCharacter   *bool          `json:"useControlStandardsIdAsRepetitionCharacter,omitempty"`
	SenderApplicationID                          *string        `json:"senderApplicationId,omitempty"`
	ReceiverApplicationID                        *string        `json:"receiverApplicationId,omitempty"`
	ControlVersionNumber                         *string        `json:"controlVersionNumber,omitempty"`
	InterchangeControlNumberLowerBound           *int32         `json:"interchangeControlNumberLowerBound,omitempty"`
	InterchangeControlNumberUpperBound           *int32         `json:"interchangeControlNumberUpperBound,omitempty"`
	RolloverInterchangeControlNumber             *bool          `json:"rolloverInterchangeControlNumber,omitempty"`
	EnableDefaultGroupHeaders                    *bool          `json:"enableDefaultGroupHeaders,omitempty"`
	FunctionalGroupID                            *string        `json:"functionalGroupId,omitempty"`
	GroupControlNumberLowerBound                 *int32         `json:"groupControlNumberLowerBound,omitempty"`
	GroupControlNumberUpperBound                 *int32         `json:"groupControlNumberUpperBound,omitempty"`
	RolloverGroupControlNumber                   *bool          `json:"rolloverGroupControlNumber,omitempty"`
	GroupHeaderAgencyCode                        *string        `json:"groupHeaderAgencyCode,omitempty"`
	GroupHeaderVersion                           *string        `json:"groupHeaderVersion,omitempty"`
	TransactionSetControlNumberLowerBound        *int32         `json:"transactionSetControlNumberLowerBound,omitempty"`
	TransactionSetControlNumberUpperBound        *int32         `json:"transactionSetControlNumberUpperBound,omitempty"`
	RolloverTransactionSetControlNumber          *bool          `json:"rolloverTransactionSetControlNumber,omitempty"`
	TransactionSetControlNumberPrefix            *string        `json:"transactionSetControlNumberPrefix,omitempty"`
	TransactionSetControlNumberSuffix            *string        `json:"transactionSetControlNumberSuffix,omitempty"`
	OverwriteExistingTransactionSetControlNumber *bool          `json:"overwriteExistingTransactionSetControlNumber,omitempty"`
	GroupHeaderDateFormat                        X12DateFormat  `json:"groupHeaderDateFormat,omitempty"`
	GroupHeaderTimeFormat                        X12TimeFormat  `json:"groupHeaderTimeFormat,omitempty"`
	UsageIndicator                               UsageIndicator `json:"usageIndicator,omitempty"`
}

// X12FramingSettings is the X12 agreement framing settings.
type X12FramingSettings struct {
	DataElementSeparator       *int32                  `json:"dataElementSeparator,omitempty"`
	ComponentSeparator         *int32                  `json:"componentSeparator,omitempty"`
	ReplaceSeparatorsInPayload *bool                   `json:"replaceSeparatorsInPayload,omitempty"`
	ReplaceCharacter           *int32                  `json:"replaceCharacter,omitempty"`
	SegmentTerminator          *int32                  `json:"segmentTerminator,omitempty"`
	CharacterSet               X12CharacterSet         `json:"characterSet,omitempty"`
	SegmentTerminatorSuffix    SegmentTerminatorSuffix `json:"segmentTerminatorSuffix,omitempty"`
}

// X12MessageFilter is the X12 message filter for odata query.
type X12MessageFilter struct {
	MessageFilterType MessageFilterType `json:"messageFilterType,omitempty"`
}

// X12MessageIdentifier is the X12 message identifier.
type X12MessageIdentifier struct {
	MessageID *string `json:"messageId,omitempty"`
}

// X12OneWayAgreement is the X12 oneway agreement.
type X12OneWayAgreement struct {
	SenderBusinessIdentity   *BusinessIdentity    `json:"senderBusinessIdentity,omitempty"`
	ReceiverBusinessIdentity *BusinessIdentity    `json:"receiverBusinessIdentity,omitempty"`
	ProtocolSettings         *X12ProtocolSettings `json:"protocolSettings,omitempty"`
}

// X12ProcessingSettings is the X12 processing settings.
type X12ProcessingSettings struct {
	MaskSecurityInfo                        *bool `json:"maskSecurityInfo,omitempty"`
	ConvertImpliedDecimal                   *bool `json:"convertImpliedDecimal,omitempty"`
	PreserveInterchange                     *bool `json:"preserveInterchange,omitempty"`
	SuspendInterchangeOnError               *bool `json:"suspendInterchangeOnError,omitempty"`
	CreateEmptyXMLTagsForTrailingSeparators *bool `json:"createEmptyXmlTagsForTrailingSeparators,omitempty"`
	UseDotAsDecimalSeparator                *bool `json:"useDotAsDecimalSeparator,omitempty"`
}

// X12ProtocolSettings is the X12 agreement protocol settings.
type X12ProtocolSettings struct {
	ValidationSettings      *X12ValidationSettings      `json:"validationSettings,omitempty"`
	FramingSettings         *X12FramingSettings         `json:"framingSettings,omitempty"`
	EnvelopeSettings        *X12EnvelopeSettings        `json:"envelopeSettings,omitempty"`
	AcknowledgementSettings *X12AcknowledgementSettings `json:"acknowledgementSettings,omitempty"`
	MessageFilter           *X12MessageFilter           `json:"messageFilter,omitempty"`
	SecuritySettings        *X12SecuritySettings        `json:"securitySettings,omitempty"`
	ProcessingSettings      *X12ProcessingSettings      `json:"processingSettings,omitempty"`
	EnvelopeOverrides       *[]X12EnvelopeOverride      `json:"envelopeOverrides,omitempty"`
	ValidationOverrides     *[]X12ValidationOverride    `json:"validationOverrides,omitempty"`
	MessageFilterList       *[]X12MessageIdentifier     `json:"messageFilterList,omitempty"`
	SchemaReferences        *[]X12SchemaReference       `json:"schemaReferences,omitempty"`
	X12DelimiterOverrides   *[]X12DelimiterOverrides    `json:"x12DelimiterOverrides,omitempty"`
}

// X12SchemaReference is the X12 schema reference.
type X12SchemaReference struct {
	MessageID           *string `json:"messageId,omitempty"`
	SenderApplicationID *string `json:"senderApplicationId,omitempty"`
	SchemaVersion       *string `json:"schemaVersion,omitempty"`
	SchemaName          *string `json:"schemaName,omitempty"`
}

// X12SecuritySettings is the X12 agreement security settings.
type X12SecuritySettings struct {
	AuthorizationQualifier *string `json:"authorizationQualifier,omitempty"`
	AuthorizationValue     *string `json:"authorizationValue,omitempty"`
	SecurityQualifier      *string `json:"securityQualifier,omitempty"`
	PasswordValue          *string `json:"passwordValue,omitempty"`
}

// X12ValidationOverride is the X12 validation override settings.
type X12ValidationOverride struct {
	MessageID                              *string                 `json:"messageId,omitempty"`
	ValidateEdiTypes                       *bool                   `json:"validateEdiTypes,omitempty"`
	ValidateXsdTypes                       *bool                   `json:"validateXsdTypes,omitempty"`
	AllowLeadingAndTrailingSpacesAndZeroes *bool                   `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	ValidateCharacterSet                   *bool                   `json:"validateCharacterSet,omitempty"`
	TrimLeadingAndTrailingSpacesAndZeroes  *bool                   `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrailingSeparatorPolicy                TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}

// X12ValidationSettings is the X12 agreement validation settings.
type X12ValidationSettings struct {
	ValidateCharacterSet                      *bool                   `json:"validateCharacterSet,omitempty"`
	CheckDuplicateInterchangeControlNumber    *bool                   `json:"checkDuplicateInterchangeControlNumber,omitempty"`
	InterchangeControlNumberValidityDays      *int32                  `json:"interchangeControlNumberValidityDays,omitempty"`
	CheckDuplicateGroupControlNumber          *bool                   `json:"checkDuplicateGroupControlNumber,omitempty"`
	CheckDuplicateTransactionSetControlNumber *bool                   `json:"checkDuplicateTransactionSetControlNumber,omitempty"`
	ValidateEdiTypes                          *bool                   `json:"validateEdiTypes,omitempty"`
	ValidateXsdTypes                          *bool                   `json:"validateXsdTypes,omitempty"`
	AllowLeadingAndTrailingSpacesAndZeroes    *bool                   `json:"allowLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrimLeadingAndTrailingSpacesAndZeroes     *bool                   `json:"trimLeadingAndTrailingSpacesAndZeroes,omitempty"`
	TrailingSeparatorPolicy                   TrailingSeparatorPolicy `json:"trailingSeparatorPolicy,omitempty"`
}
