; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s

; LSR should be able to eliminate both smax and umax expressions
; in loop trip counts.

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128"

define void @fs(double* nocapture %p, i64 %n) nounwind {
; CHECK-LABEL: fs:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    .p2align 4, 0x90
; CHECK-NEXT:  .LBB0_1: # %bb
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    movq $0, (%rdi,%rax,8)
; CHECK-NEXT:    incq %rax
; CHECK-NEXT:    cmpq %rsi, %rax
; CHECK-NEXT:    jl .LBB0_1
; CHECK-NEXT:  # BB#2: # %return
; CHECK-NEXT:    retq
entry:
	%tmp = icmp slt i64 %n, 1		; <i1> [#uses=1]
	%smax = select i1 %tmp, i64 1, i64 %n		; <i64> [#uses=1]
	br label %bb

bb:		; preds = %bb, %entry
	%i.0 = phi i64 [ 0, %entry ], [ %0, %bb ]		; <i64> [#uses=2]
	%scevgep = getelementptr double, double* %p, i64 %i.0		; <double*> [#uses=1]
	store double 0.000000e+00, double* %scevgep, align 8
	%0 = add i64 %i.0, 1		; <i64> [#uses=2]
	%exitcond = icmp eq i64 %0, %smax		; <i1> [#uses=1]
	br i1 %exitcond, label %return, label %bb

return:		; preds = %bb
	ret void
}

define void @bs(double* nocapture %p, i64 %n) nounwind {
; CHECK-LABEL: bs:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    .p2align 4, 0x90
; CHECK-NEXT:  .LBB1_1: # %bb
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    movq $0, (%rdi,%rax,8)
; CHECK-NEXT:    incq %rax
; CHECK-NEXT:    cmpq %rsi, %rax
; CHECK-NEXT:    jl .LBB1_1
; CHECK-NEXT:  # BB#2: # %return
; CHECK-NEXT:    retq
entry:
	%tmp = icmp sge i64 %n, 1		; <i1> [#uses=1]
	%smax = select i1 %tmp, i64 %n, i64 1		; <i64> [#uses=1]
	br label %bb

bb:		; preds = %bb, %entry
	%i.0 = phi i64 [ 0, %entry ], [ %0, %bb ]		; <i64> [#uses=2]
	%scevgep = getelementptr double, double* %p, i64 %i.0		; <double*> [#uses=1]
	store double 0.000000e+00, double* %scevgep, align 8
	%0 = add i64 %i.0, 1		; <i64> [#uses=2]
	%exitcond = icmp eq i64 %0, %smax		; <i1> [#uses=1]
	br i1 %exitcond, label %return, label %bb

return:		; preds = %bb
	ret void
}

define void @fu(double* nocapture %p, i64 %n) nounwind {
; CHECK-LABEL: fu:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    .p2align 4, 0x90
; CHECK-NEXT:  .LBB2_1: # %bb
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    movq $0, (%rdi,%rax,8)
; CHECK-NEXT:    incq %rax
; CHECK-NEXT:    cmpq %rsi, %rax
; CHECK-NEXT:    jb .LBB2_1
; CHECK-NEXT:  # BB#2: # %return
; CHECK-NEXT:    retq
entry:
	%tmp = icmp eq i64 %n, 0		; <i1> [#uses=1]
	%umax = select i1 %tmp, i64 1, i64 %n		; <i64> [#uses=1]
	br label %bb

bb:		; preds = %bb, %entry
	%i.0 = phi i64 [ 0, %entry ], [ %0, %bb ]		; <i64> [#uses=2]
	%scevgep = getelementptr double, double* %p, i64 %i.0		; <double*> [#uses=1]
	store double 0.000000e+00, double* %scevgep, align 8
	%0 = add i64 %i.0, 1		; <i64> [#uses=2]
	%exitcond = icmp eq i64 %0, %umax		; <i1> [#uses=1]
	br i1 %exitcond, label %return, label %bb

return:		; preds = %bb
	ret void
}

define void @bu(double* nocapture %p, i64 %n) nounwind {
; CHECK-LABEL: bu:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    .p2align 4, 0x90
; CHECK-NEXT:  .LBB3_1: # %bb
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    movq $0, (%rdi,%rax,8)
; CHECK-NEXT:    incq %rax
; CHECK-NEXT:    cmpq %rsi, %rax
; CHECK-NEXT:    jb .LBB3_1
; CHECK-NEXT:  # BB#2: # %return
; CHECK-NEXT:    retq
entry:
	%tmp = icmp ne i64 %n, 0		; <i1> [#uses=1]
	%umax = select i1 %tmp, i64 %n, i64 1		; <i64> [#uses=1]
	br label %bb

bb:		; preds = %bb, %entry
	%i.0 = phi i64 [ 0, %entry ], [ %0, %bb ]		; <i64> [#uses=2]
	%scevgep = getelementptr double, double* %p, i64 %i.0		; <double*> [#uses=1]
	store double 0.000000e+00, double* %scevgep, align 8
	%0 = add i64 %i.0, 1		; <i64> [#uses=2]
	%exitcond = icmp eq i64 %0, %umax		; <i1> [#uses=1]
	br i1 %exitcond, label %return, label %bb

return:		; preds = %bb
	ret void
}
