﻿#region License
// Copyright (c) 2007 James Newton-King
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
#endregion

namespace Newtonsoft.Json.Serialization
{
  /// <summary>
  /// Used to resolve references when serializing and deserializing JSON by the <see cref="JsonSerializer"/>.
  /// </summary>
  public interface IReferenceResolver
  {
    /// <summary>
    /// Resolves a reference to its object.
    /// </summary>
    /// <param name="context">The serialization context.</param>
    /// <param name="reference">The reference to resolve.</param>
    /// <returns>The object that</returns>
    object ResolveReference(object context, string reference);
    /// <summary>
    /// Gets the reference for the sepecified object.
    /// </summary>
    /// <param name="context">The serialization context.</param>
    /// <param name="value">The object to get a reference for.</param>
    /// <returns>The reference to the object.</returns>
    string GetReference(object context, object value);
    /// <summary>
    /// Determines whether the specified object is referenced.
    /// </summary>
    /// <param name="context">The serialization context.</param>
    /// <param name="value">The object to test for a reference.</param>
    /// <returns>
    /// 	<c>true</c> if the specified object is referenced; otherwise, <c>false</c>.
    /// </returns>
    bool IsReferenced(object context, object value);
    /// <summary>
    /// Adds a reference to the specified object.
    /// </summary>
    /// <param name="context">The serialization context.</param>
    /// <param name="reference">The reference.</param>
    /// <param name="value">The object to reference.</param>
    void AddReference(object context, string reference, object value);
  }
}