/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.Parser;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.StructureElement;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class StructureTree {
    private PdfModule _module;
    private RandomAccessFile _raf;
    private Parser _parser;
    private PdfDictionary _rootDict;
    private PdfDictionary _roleMap;
    private List children;
    private boolean _present;
    private boolean _valid;

    public StructureTree(PdfModule pdfModule, RandomAccessFile randomAccessFile, Parser parser) throws PdfException {
        this._module = pdfModule;
        this._raf = randomAccessFile;
        this._parser = parser;
        try {
            PdfDictionary pdfDictionary = pdfModule.getCatalogDict();
            this._rootDict = null;
            try {
                this._rootDict = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("StructTreeRoot"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._rootDict == null) {
                this._present = false;
                this._valid = false;
                return;
            }
            this._present = true;
            this.validateRoot();
            this.getRoleMap();
            this.children = this.getChildren();
            this._valid = true;
        }
        catch (Exception exception) {
            this._valid = false;
        }
    }

    public boolean isPresent() {
        return this._present;
    }

    public boolean isValid() {
        return this._valid;
    }

    public PdfModule getModule() {
        return this._module;
    }

    public String dereferenceStructType(String string) {
        if (this._roleMap == null) {
            return string;
        }
        for (int i = 0; i < 50; ++i) {
            try {
                PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)this._roleMap.get(string);
                if (pdfSimpleObject == null) {
                    return string;
                }
                string = pdfSimpleObject.getStringValue();
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private void validateRoot() throws PdfException {
        try {
            PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)this._rootDict.get("Type");
            if (!"StructTreeRoot".equals(pdfSimpleObject.getStringValue())) {
                throw new PdfInvalidException("Invalid document structure root");
            }
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (Exception exception) {
            throw new PdfInvalidException("Invalid document structure root");
        }
    }

    private List getChildren() throws PdfException {
        ArrayList<StructureElement> arrayList = null;
        PdfObject pdfObject = null;
        try {
            pdfObject = this._module.resolveIndirectObject(this._rootDict.get("K"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pdfObject == null) {
            return null;
        }
        if (pdfObject instanceof PdfDictionary) {
            arrayList = new ArrayList<StructureElement>(1);
            StructureElement structureElement = new StructureElement((PdfDictionary)pdfObject, this);
            structureElement.buildSubtree();
            structureElement.checkAttributes();
            arrayList.add(structureElement);
            return arrayList;
        }
        if (pdfObject instanceof PdfArray) {
            Vector vector = ((PdfArray)pdfObject).getContent();
            arrayList = new ArrayList(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                PdfObject pdfObject2;
                try {
                    pdfObject2 = this._module.resolveIndirectObject((PdfObject)vector.elementAt(i));
                }
                catch (IOException iOException) {
                    throw new PdfMalformedException("Invalid data in document structure root");
                }
                StructureElement structureElement = new StructureElement((PdfDictionary)pdfObject2, this);
                structureElement.buildSubtree();
                structureElement.checkAttributes();
                arrayList.add(structureElement);
            }
            return arrayList;
        }
        throw new PdfInvalidException("Invalid data in document structure root");
    }

    private void getRoleMap() throws PdfException {
        try {
            this._roleMap = (PdfDictionary)this._module.resolveIndirectObject(this._rootDict.get("RoleMap"));
        }
        catch (Exception exception) {
            throw new PdfInvalidException("Invalid RoleMap");
        }
    }
}

