#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotlsashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# Zork series:
# - Zork 1: The Great Underground Empire
# - Zork 2: The Wizard of Frobozz
# - Zork 3: The Dungeon Master
# send your bug reports to contact@dotslashplay.it
###

script_version=20240604.3

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID_EPISODE1='zork-1'
GAME_ID_EPISODE2='zork-2'
GAME_ID_EPISODE3='zork-3'
GAME_NAME_EPISODE1='Zork I: The Great Underground Empire'
GAME_NAME_EPISODE2='Zork II: The Wizard of Frobozz'
GAME_NAME_EPISODE3='Zork III: The Dungeon Master'

ARCHIVE_BASE_EPISODE1_0_NAME='setup_zork_2.1.0.17.exe'
ARCHIVE_BASE_EPISODE1_0_MD5='6bd42788d696f154ce363830909259d3'
ARCHIVE_BASE_EPISODE1_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_0_SIZE='22000'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.0-gog2.1.0.17'
ARCHIVE_BASE_EPISODE1_0_URL='https://www.gog.com/game/the_zork_anthology'

ARCHIVE_BASE_EPISODE2_0_NAME='setup_zork2_2.1.0.17.exe'
ARCHIVE_BASE_EPISODE2_0_MD5='2ea2cf45bb6cf76b0365567e81f27aab'
ARCHIVE_BASE_EPISODE2_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_0_SIZE='23000'
ARCHIVE_BASE_EPISODE2_0_VERSION='1.0-gog2.1.0.17'
ARCHIVE_BASE_EPISODE2_0_URL='https://www.gog.com/game/the_zork_anthology'

ARCHIVE_BASE_EPISODE3_0_NAME='setup_zork3_2.1.0.17.exe'
ARCHIVE_BASE_EPISODE3_0_MD5='1526e9be21bf47412dc053f4097e25bd'
ARCHIVE_BASE_EPISODE3_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE3_0_SIZE='23000'
ARCHIVE_BASE_EPISODE3_0_VERSION='1.0-gog2.1.0.17'
ARCHIVE_BASE_EPISODE3_0_URL='https://www.gog.com/game/the_zork_anthology'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_MAIN_FILES='
data
save
*.com
*.inf'
CONTENT_DOC_MAIN_FILES='
*.htm
*.pdf
*.txt'

USER_PERSISTENT_DIRECTORIES='
save'

APP_MAIN_EXE_EPISODE1='_zork1.com'
APP_MAIN_EXE_EPISODE2='_zork2.com'
APP_MAIN_EXE_EPISODE3='_zork3.com'
APP_MAIN_ICON_EPISODE1='goggame-1207661493.ico'
APP_MAIN_ICON_EPISODE2='goggame-1207661503.ico'
APP_MAIN_ICON_EPISODE3='goggame-1207661513.ico'

## Easier upgrade from packages generated with pre-20190303.1 scripts
PKG_MAIN_PROVIDES_EPISODE1="${PKG_MAIN_PROVIDES_EPISODE1:-}
zork"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
