/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.DerivedKeyTokenProcessor;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.processor.X509Util;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReferenceListProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$processor$ReferenceListProcessor == null ? (class$org$apache$ws$security$processor$ReferenceListProcessor = ReferenceListProcessor.class$("org.apache.ws.security.processor.ReferenceListProcessor")) : class$org$apache$ws$security$processor$ReferenceListProcessor).getName());
    private boolean debug = false;
    WSDocInfo wsDocInfo = null;
    static /* synthetic */ Class class$org$apache$ws$security$processor$ReferenceListProcessor;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wdi, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        this.debug = log.isDebugEnabled();
        if (this.debug) {
            log.debug((Object)"Found reference list element");
        }
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        this.wsDocInfo = wdi;
        ArrayList uris = this.handleReferenceList(elem, cb, crypto);
        returnResults.add(0, new WSSecurityEngineResult(4, uris));
    }

    private ArrayList handleReferenceList(Element elem, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        Document doc = elem.getOwnerDocument();
        Node tmpE = null;
        ArrayList<WSDataRef> dataRefUris = new ArrayList<WSDataRef>();
        for (tmpE = elem.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
            if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") || !tmpE.getLocalName().equals("DataReference")) continue;
            String dataRefURI = ((Element)tmpE).getAttribute("URI");
            WSDataRef dataRef = new WSDataRef(dataRefURI.substring(1));
            this.decryptDataRefEmbedded(doc, dataRefURI, dataRef, cb, crypto);
            dataRefUris.add(dataRef);
        }
        return dataRefUris;
    }

    public void decryptDataRefEmbedded(Document doc, String dataRefURI, WSDataRef dataRef, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found data reference: " + dataRefURI));
        }
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        boolean content = X509Util.isContent(encBodyData);
        String symEncAlgo = X509Util.getEncAlgo(encBodyData);
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (tmpE == null) {
            throw new WSSecurityException(3, "noKeyinfo");
        }
        Element secRefToken = (Element)WSSecurityUtil.getDirectChild(tmpE, "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SecretKey symmetricKey = null;
        symmetricKey = secRefToken == null ? X509Util.getSharedKey(tmpE, symEncAlgo, cb) : this.getKeyFromSecurityTokenReference(secRefToken, symEncAlgo, crypto, cb);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
            xmlCipher.init(2, (Key)symmetricKey);
        }
        catch (XMLEncryptionException e1) {
            throw new WSSecurityException(2, null, null, e1);
        }
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
            dataRef.setName(new QName(encBodyData.getNamespaceURI(), encBodyData.getLocalName()));
        }
        try {
            String wsuPrefix;
            Node parentEncBody = encBodyData.getParentNode();
            List before_peers = ReferenceListProcessor.listChildren(parentEncBody);
            xmlCipher.doFinal(doc, encBodyData, content);
            if (parentEncBody.getLocalName().equals("EncryptedHeader") && parentEncBody.getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) {
                Node decryptedHeader = parentEncBody.getFirstChild();
                Element decryptedHeaderClone = (Element)decryptedHeader.cloneNode(true);
                String sigId = decryptedHeaderClone.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if (sigId == null || sigId.equals("")) {
                    String id = ((Element)parentEncBody).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    wsuPrefix = WSSecurityUtil.setNamespace(decryptedHeaderClone, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                    decryptedHeaderClone.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", wsuPrefix + ":Id", id);
                    dataRef.setWsuId(id.substring(1));
                } else {
                    dataRef.setWsuId(sigId);
                }
                parentEncBody.getParentNode().appendChild(decryptedHeaderClone);
                parentEncBody.getParentNode().removeChild(parentEncBody);
            }
            List after_peers = ReferenceListProcessor.listChildren(parentEncBody);
            List new_nodes = ReferenceListProcessor.newNodes(before_peers, after_peers);
            Iterator pos = new_nodes.iterator();
            while (pos.hasNext()) {
                Node node = (Node)pos.next();
                if (!(node instanceof Element)) continue;
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(node.getNamespaceURI()) && node.getAttributes().getNamedItemNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id") == null) {
                    wsuPrefix = WSSecurityUtil.setNamespace((Element)node, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
                    ((Element)node).setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", wsuPrefix + ":Id", dataRefURI);
                    dataRef.setWsuId(dataRefURI.substring(1));
                }
                dataRef.setName(new QName(node.getNamespaceURI(), node.getLocalName()));
            }
        }
        catch (Exception e) {
            throw new WSSecurityException(6, null, null, e);
        }
    }

    public String getId() {
        return null;
    }

    private SecretKey getKeyFromSecurityTokenReference(Element secRefToken, String algorithm, Crypto crypto, CallbackHandler cb) throws WSSecurityException {
        SecurityTokenReference secRef = new SecurityTokenReference(secRefToken);
        byte[] decryptedData = null;
        if (secRef.containsReference()) {
            Processor p;
            Reference reference = secRef.getReference();
            String uri = reference.getURI();
            String id = uri;
            if (id.charAt(0) == '#') {
                id = id.substring(1);
            }
            if (!((p = this.wsDocInfo.getProcessor(id)) instanceof EncryptedKeyProcessor || p instanceof DerivedKeyTokenProcessor || p instanceof SAMLTokenProcessor)) {
                WSPasswordCallback pwcb = new WSPasswordCallback(id, 7);
                try {
                    Callback[] callbacks = new Callback[]{pwcb};
                    cb.handle(callbacks);
                }
                catch (Exception e) {
                    throw new WSSecurityException(0, "noPassword", new Object[]{id}, e);
                }
                decryptedData = pwcb.getKey();
                if (decryptedData == null) {
                    throw new WSSecurityException(6, "unsupportedKeyId");
                }
            }
            if (p instanceof EncryptedKeyProcessor) {
                EncryptedKeyProcessor ekp = (EncryptedKeyProcessor)p;
                decryptedData = ekp.getDecryptedBytes();
            } else if (p instanceof DerivedKeyTokenProcessor) {
                DerivedKeyTokenProcessor dkp = (DerivedKeyTokenProcessor)p;
                decryptedData = dkp.getKeyBytes(WSSecurityUtil.getKeyLength(algorithm));
            } else if (p instanceof SAMLTokenProcessor) {
                SAMLTokenProcessor samlp = (SAMLTokenProcessor)p;
                SAMLKeyInfo keyInfo = SAMLUtil.getSAMLKeyInfo(samlp.getSamlTokenElement(), crypto, cb);
                decryptedData = keyInfo.getSecret();
            }
        } else if (secRef.containsKeyIdentifier()) {
            String sha = secRef.getKeyIdentifierValue();
            WSPasswordCallback pwcb = new WSPasswordCallback(secRef.getKeyIdentifierValue(), null, secRef.getKeyIdentifierValueType(), 8);
            try {
                Callback[] callbacks = new Callback[]{pwcb};
                cb.handle(callbacks);
            }
            catch (Exception e) {
                throw new WSSecurityException(0, "noPassword", new Object[]{sha}, e);
            }
            decryptedData = pwcb.getKey();
        } else {
            throw new WSSecurityException(6, "noReference");
        }
        return WSSecurityUtil.prepareSecretKey(algorithm, decryptedData);
    }

    private static List listChildren(Node parent) {
        NodeList children;
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        if (parent.hasChildNodes() && (children = parent.getChildNodes()) != null) {
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                ret.add(children.item(i));
            }
        }
        return ret;
    }

    private static List newNodes(List a, List b) {
        if (a.size() == 0) {
            return b;
        }
        if (b.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        a = new ArrayList(a);
        for (int x = 0; x < b.size(); ++x) {
            Node anode;
            Node bnode = (Node)b.get(x);
            if (bnode != (anode = (Node)a.get(x)) && (!bnode.getLocalName().equals(anode.getLocalName()) || !bnode.getNamespaceURI().equals(anode.getNamespaceURI()))) continue;
            b.remove(x);
            a.remove(x);
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator bpos = b.iterator();
        while (bpos.hasNext()) {
            Node bnode = (Node)bpos.next();
            String bns = bnode.getNamespaceURI();
            String bln = bnode.getLocalName();
            boolean found = false;
            Iterator apos = a.iterator();
            while (apos.hasNext() && !found) {
                boolean lnmatch;
                boolean nsmatch;
                Node anode = (Node)apos.next();
                String ans = anode.getNamespaceURI();
                String aln = anode.getLocalName();
                boolean bl = ans == null ? bns == null : (nsmatch = bns == null ? false : ans.equals(bns));
                boolean bl2 = aln == null ? bln == null : (lnmatch = bln == null ? false : aln.equals(bln));
                if (!nsmatch || !lnmatch) continue;
                found = true;
            }
            if (found) continue;
            ret.add(bnode);
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

