// Location: 40.942707, 14.370705
// Map Width: 80km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing tile classes...");
setBiome(5);
initMapSettings();
initTileClasses(["decorative", "lava"]);

log("Initializing environment...");
setSunColor(0.8, 0.8, 0.8);

setWaterTint(0.5, 0.5, 0.5);
setWaterColor(0.3, 0.3, 0.3);
setWaterWaviness(8);
setWaterMurkiness(0.87);
setWaterType("lake");

setTerrainAmbientColor(0.3, 0.3, 0.3);
setUnitsAmbientColor(0.3, 0.3, 0.3);

setSunRotation(-1 * PI);
setSunElevation(PI / 6.25);

setFogFactor(0);
setFogThickness(0);
setFogColor(0.69, 0.616, 0.541);

setSkySet("stormy");

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

log("Initializing biome...");
g_Terrains.mainTerrain = "ocean_rock_a";
g_Terrains.forestFloor1 = "dirt_burned";
g_Terrains.forestFloor2 = "shoreline_stoney_a";
g_Terrains.tier1Terrain = "rock_metamorphic";
g_Terrains.tier2Terrain = "fissures";
g_Terrains.tier3Terrain = "LavaTest06";
g_Terrains.tier4Terrain = "ocean_rock_b";
g_Terrains.roadWild = "road1";
g_Terrains.road = "road1";
g_Gaia.mainHuntableAnimal = "gaia/fauna_goat";
g_Gaia.secondaryHuntableAnimal =  "gaia/fauna_hawk";
g_Gaia.fruitBush = "gaia/fauna_chicken";
g_Gaia.fish = "gaia/fauna_fish";
g_Gaia.tree1 = "gaia/flora_tree_dead";
g_Gaia.tree2 = "gaia/flora_tree_oak_dead";
g_Gaia.tree3 = "gaia/flora_tree_dead";
g_Gaia.tree4 = "gaia/flora_tree_oak_dead";
g_Gaia.tree5 = "gaia/flora_tree_dead";
g_Gaia.stoneSmall = "gaia/geology_stone_alpine_a";
g_Decoratives.grass = "actor|props/flora/grass_field_parched_short.xml";
g_Decoratives.grassShort = "actor|props/flora/grass_soft_dry_tuft_a.xml";
g_Decoratives.bushMedium = "actor|props/special/eyecandy/barrels_buried.xml";
g_Decoratives.bushSmall = "actor|props/special/eyecandy/handcart_1_broken.xml";
initBiome();
RMS.SetProgress(5);

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet(), (tile, x, y) => {
	if (tile.indexOf("mud_slide") >= 0)
		addToClass(x, y, g_TileClasses.mountain);
	else if (tile.indexOf("Lava") >= 0)
		addToClass(x, y, g_TileClasses.lava);
});

log("Paint tile classes...");
paintTileClassBasedOnHeight(-100, -1, 3, g_TileClasses.water);
RMS.SetProgress(30);

log("Placing players...");
//Coordinate system of the heightmap
var singleBases = [
	[220,80],
	[70,140],
	[180,270],
	[280,280],
	[50,270]
];

if (g_MapInfo.mapSize >= 320 || g_MapInfo.numPlayers > singleBases.length)
	singleBases.push(
		[50,200],
		[125,190],
		[180,140]
	);

randomPlayerPlacementAt(singleBases, [], scale, 0.06);
RMS.SetProgress(40);

addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.lava, 2,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["normal"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.lava, 2,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["normal"]
	}
]);
RMS.SetProgress(50);

addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 10,
			g_TileClasses.metal, 20,
			g_TileClasses.lava, 5,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 10,
			g_TileClasses.lava, 5,
			g_TileClasses.water, 5
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 18,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 5,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			//g_TileClasses.lava, 10,
			g_TileClasses.water, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]));
RMS.SetProgress(60);

addElements(shuffleArray([
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.lava, 10,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	},
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 12,
			g_TileClasses.player, 8
		],
		"stay": [g_TileClasses.water, 4],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 7,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.lava, 5,
			g_TileClasses.water, 5
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	}
]));
RMS.SetProgress(65);

log("Adding smoke...");
var smokeActors = [
	new Entity("actor|particle/smoke_volcano.xml", 0, 178, 112, 0),
	new Entity("actor|particle/smoke_volcano.xml", 0, 179, 112, 0),
	new Entity("actor|particle/smoke_volcano.xml", 0, 180, 111, 0),
	new Entity("actor|particle/smoke_volcano.xml", 0, 177, 111, 0),
	new Entity("actor|particle/smoke_curved.xml", 0, 176, 111, 0),
	new Entity("actor|particle/smoke_volcano.xml", 0, 177, 112, 0),
	new Entity("actor|particle/smoke_curved.xml", 0, 181, 111, 0),
	new Entity("actor|particle/smoke_volcano.xml", 0, 180, 112, 0),
];

for (let smoke of smokeActors)
{
	smoke.position.x = Math.floor(smoke.position.x / scale);
	smoke.position.z = Math.floor(smoke.position.z / scale);
	g_Map.addObject(smoke);
}
RMS.SetProgress(70);

log("Adding gatherable stone ruins...");
createObjectGroups(
	new SimpleGroup(
		[new SimpleObject("gaia/special_ruins_stone_statues_roman", 1, 1, 1, 4)],
		true,
		g_TileClasses.metal
	),
	0,
	avoidClasses(
		g_TileClasses.water, 2,
		g_TileClasses.player, 20,
		g_TileClasses.mountain, 3,
		g_TileClasses.forest, 2,
		g_TileClasses.lava, 5,
		g_TileClasses.metal, 20
	),
	5 * scaleByMapSize(1, 4),
	500
);
RMS.SetProgress(75);

log("Adding stone ruins...");
createObjectGroups(
	new SimpleGroup(
		[
			new SimpleObject("other/unfinished_greek_temple", 0, 1, 1, 4),
			new SimpleObject("gaia/special_ruins_column_doric", 1, 1, 1, 4)
		],
		true,
		g_TileClasses.decorative
	),
	0,
	avoidClasses(
		g_TileClasses.water, 2,
		g_TileClasses.player, 20,
		g_TileClasses.mountain, 5,
		g_TileClasses.forest, 2,
		g_TileClasses.lava, 5,
		g_TileClasses.decorative, 20
	),
	10 * scaleByMapSize(1, 4),
	200
);
RMS.SetProgress(80);

log("Adding shipwrecks...");
var shipwrecks = [
	"shipwreck_hull",
	"shipwreck_ram_side",
	"shipwreck_sail_boat",
	"shipwreck_sail_boat_cut",
	"barrels_floating"
].map(shipwreck => new SimpleObject("actor|props/special/eyecandy/" + shipwreck + ".xml", 0, 1, 1, 20));

createObjectGroups(
	new SimpleGroup(shipwrecks, true, g_TileClasses.decorative),
	0,
	[
		avoidClasses(g_TileClasses.decorative, 20),
		stayClasses(g_TileClasses.water, 0)
	],
	6 * scaleByMapSize(1, 4),
	200
);
RMS.SetProgress(85);

log("Adding more ruins...");
var ruins = [
	"statue_aphrodite_huge",
	"sele_colonnade",
	"well_1_b",
	"anvil",
	"wheel_laying",
	"vase_rome_a"
].map(ruin => new SimpleObject("actor|props/special/eyecandy/" + ruin + ".xml", 0, 1, 1, 20));

createObjectGroups(
	new SimpleGroup(ruins, true, g_TileClasses.decorative),
	0,
	avoidClasses(
		g_TileClasses.water, 2,
		g_TileClasses.player, 20,
		g_TileClasses.mountain, 2,
		g_TileClasses.forest, 2,
		g_TileClasses.lava, 5,
		g_TileClasses.decorative, 20
	),
	10 * scaleByMapSize(1, 4),
	200
);
RMS.SetProgress(90);

log("Adding bodies...");
createObjectGroups(
	new SimpleGroup(
		[new SimpleObject("actor|props/special/eyecandy/skeleton.xml", 3, 10, 1, 7)],
		true,
		g_TileClasses.dirt
	),
	0,
	avoidClasses(
		g_TileClasses.water, 2,
		g_TileClasses.player, 10,
		g_TileClasses.mountain, 2,
		g_TileClasses.forest, 2,
		g_TileClasses.decorative, 2
	),
	30 * scaleByMapSize(1, 4),
	200
);
RMS.SetProgress(95);

ExportMap();

function getHeightMap()
{
	return [-4.17,-4.50,-4.88,-5.25,-5.60,-5.86,-6.12,-6.35,-6.50,-6.60,-6.72,-6.75,-6.75,-6.67,-6.86,-6.97,-7.04,-7.24,-7.49,-7.63,-7.73,-7.65,-7.60,-7.48,-7.38,-7.25,-7.23,-7.29,-7.41,-7.50,-7.50,-7.50,-7.38,-7.25,-7.05,-6.86,-6.54,-6.23,-5.89,-5.55,-5.18,-4.80,-4.41,-3.99,-3.59,-3.26,-3.11,-3.02,-3.01,-3,-2.98,-2.73,-0.93,1.23,5.01,9.87,13.95,17,20,23,26,28,31,32,35,39,41,37,30,21.76,15.36,10.60,7.14,4.37,2.37,0.97,0.01,-1,-1.93,-2.68,-3.23,-3.63,-4.22,-5,-5.88,-6.59,-6.98,-6.78,-6.65,-6.48,-6.77,-7.16,-7.64,-8.22,-8.68,-9.25,-9.78,-10,-10,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-10,-9.93,-9.66,-9.50,-9.29,-9.02,-8.66,-8.30,-8.01,-7.62,-7.25,-7,-6.76,-6.64,-6.72,-6.92,-7.26,-7.66,-8.04,-8.38,-8.75,-9.10,-9.38,-9.61,-9.78,-9.88,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.97,-9.75,-9.42,-9.12,-8.73,-8.23,-7.88,-7.50,-7.10,-6.62,-6.05,-5.47,-5,-4.50,-4.01,-3.88,-4.14,-4.75,-5.49,-5.84,-6.10,-6.02,-5.77,-5.25,-4.49,-4,-3.38,-3.02,-3.04,-3.03,-3.01,-3.01,-3.01,-3,-3,-3,-2.99,-2.98,-2.98,-2.99,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,-1,-1,-1,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,6,13,18,17,16,18,20,20,18,18,18,19,18,19,22,25,27,25,22,19,17,14,10,7,5,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5,5,5,6,6,6,7,7,7,7,6,7,7,7,6,7,7,7,8,8,8,8,9,8,-4.48,-4.88,-5.29,-5.68,-6.01,-6.30,-6.53,-6.75,-6.89,-7.09,-7.18,-7.25,-7.27,-7.34,-7.43,-7.50,-7.73,-8,-8.26,-8.41,-8.50,-8.51,-8.50,-8.40,-8.25,-8.12,-7.88,-7.86,-7.93,-8.01,-8.01,-8,-7.90,-7.77,-7.63,-7.38,-7.10,-6.75,-6.38,-5.92,-5.55,-5.13,-4.63,-4.15,-3.73,-3.42,-3.18,-3.09,-3.02,-3,-2.88,-2.25,-0.79,1.49,4.36,8,11.87,14.98,18,21,24,27,29,32,35,38,39,35,28,20.39,14.59,10.14,6.84,4.07,1.96,0.50,-0.49,-1.34,-2.11,-2.76,-3.30,-3.86,-4.63,-5.63,-6.50,-7.23,-7.67,-8.02,-7.89,-7.60,-7.63,-8,-8.34,-8.67,-9.17,-9.78,-10,-11,-11,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.78,-9.51,-9.25,-8.98,-8.67,-8.27,-7.86,-7.48,-7.22,-7,-7.01,-7.14,-7.38,-7.88,-8.26,-8.65,-9.12,-9.43,-9.73,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-13,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.75,-9.38,-9,-8.52,-8.11,-7.72,-7.27,-6.80,-6.27,-5.72,-5.15,-4.67,-4.64,-4.78,-5.10,-5.64,-6.36,-6.61,-6.39,-6.35,-6.02,-5.51,-4.66,-4,-3.43,-3.22,-3.09,-3.01,-3,-3,-3,-3,-2.99,-2.92,-2.87,-2.78,-2.75,-2.84,-2.91,-2.99,-3,-3,-3,-3,-3,-3,-2,-1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,7,14,17,17,16,17,17,17,16,16,18,20,19,19,23,26,27,24,22,23,20,16,12,9,7,5,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,5,5,6,6,6,7,7,7,7,7,7,7,8,7,7,7,7,8,8,9,9,9,9,9,-4.84,-5.29,-5.73,-6.11,-6.41,-6.73,-7,-7.26,-7.50,-7.66,-7.76,-7.85,-7.87,-8,-8.12,-8.28,-8.54,-8.88,-9.05,-9.14,-9.27,-9.40,-9.38,-9.30,-9.12,-8.88,-8.63,-8.42,-8.40,-8.50,-8.49,-8.48,-8.38,-8.25,-8.10,-7.88,-7.59,-7.25,-6.87,-6.42,-5.97,-5.48,-4.98,-4.47,-3.99,-3.55,-3.26,-3.12,-3.03,-3,-2.88,-2.17,-0.80,1.25,3.65,6.41,9.83,12.90,16,19,22,25,28,30,33,36,37,32,25,18.49,13.48,9.37,6.15,3.50,1.38,-0.13,-1.03,-1.75,-2.37,-2.90,-3.49,-4.17,-5.18,-6.25,-7.26,-8.01,-8.55,-9,-9.25,-9.25,-8.89,-9.04,-9.38,-9.63,-9.68,-10,-11,-11,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.90,-9.64,-9.39,-9,-8.50,-8.13,-7.80,-7.65,-7.63,-7.72,-7.79,-8.13,-8.63,-9.10,-9.51,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.97,-9.63,-9.25,-8.77,-8.25,-7.88,-7.43,-7,-6.42,-5.88,-5.27,-5.30,-5.25,-5.43,-5.73,-6.04,-6.74,-7,-6.86,-6.36,-6.04,-5.50,-4.66,-3.90,-3.50,-3.22,-3.03,-2.98,-2.92,-2.91,-2.91,-2.91,-2.88,-2.77,-2.62,-2.39,-2.25,-2.18,-2.42,-2.73,-3,-3,-3,-3,-3,-2,-1,-1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,8,13,15,14,14,14,14,14,13,15,18,21,21,21,24,26,27,25,25,26,24,19,14,11,8,7,6,5,4,3,3,3,3,3,3,3,3,3,3,3,3,4,4,3,3,3,4,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,8,8,7,7,8,8,8,8,8,9,10,10,10,10,10,10,-5.17,-5.66,-6.10,-6.43,-6.88,-7.25,-7.53,-7.84,-8,-8.17,-8.28,-8.38,-8.38,-8.54,-8.67,-9,-9.38,-9.72,-9.88,-10,-10,-10,-10,-10,-9.89,-9.60,-9.25,-8.97,-8.85,-8.88,-8.91,-8.88,-8.79,-8.67,-8.50,-8.26,-8,-7.66,-7.30,-6.88,-6.37,-5.85,-5.28,-4.75,-4.22,-3.75,-3.40,-3.22,-3.09,-2.99,-2.80,-2.13,-0.76,1.20,3.50,6.02,8.41,10.12,13,18,21,24,26,29,32,34,33,28,22,17.12,12.48,8.49,5.26,2.85,0.87,-0.48,-1.54,-2.13,-2.63,-3.11,-3.64,-4.52,-5.61,-6.77,-7.86,-8.75,-9.50,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-9.73,-9.18,-8.89,-8.63,-8.43,-8.30,-8.39,-8.50,-8.65,-9,-9.61,-10,-10,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.84,-9.47,-8.99,-8.47,-8.01,-7.59,-7.13,-6.60,-6,-5.78,-6.10,-6,-6.01,-6.05,-6.14,-6.65,-7,-6.88,-6.27,-5.77,-5.22,-4.37,-3.79,-3.38,-3.11,-2.90,-2.80,-2.76,-2.75,-2.75,-2.74,-2.66,-2.50,-2.23,-1.86,-1.51,-1.34,-1.25,-1.16,-1.09,-1.01,-1,-1,-1,-1,-1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,8,12,11,10,10,11,10,10,11,14,17,20,22,22,25,28,29,28,30,31,28,24,19,16,12,10,8,7,5,4,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,6,6,7,7,7,8,8,8,9,9,8,8,9,9,10,10,10,11,11,11,11,12,12,12,-5.51,-5.99,-6.47,-6.92,-7.37,-7.68,-8.02,-8.28,-8.50,-8.63,-8.75,-8.79,-8.87,-9.04,-9.30,-9.73,-10,-10,-10,-10,-11,-11,-10,-10,-10,-10,-9.88,-9.51,-9.27,-9.25,-9.25,-9.24,-9.14,-9.02,-8.87,-8.64,-8.38,-8.04,-7.66,-7.25,-6.74,-6.18,-5.63,-5.02,-4.48,-3.97,-3.53,-3.26,-3.11,-2.93,-2.75,-2.02,-0.67,1.37,3.75,6.24,8.62,10.35,14,17,20,22,25,28,30,32,31,26,20,16.12,11.82,7.95,4.74,2.50,0.75,-0.55,-1.75,-2.41,-2.85,-3.25,-3.78,-4.74,-5.88,-7.13,-8.35,-9.43,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-9.67,-9.50,-9.29,-9.25,-9.41,-9.74,-10,-10,-10,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.97,-9.60,-9.13,-8.61,-8.10,-7.64,-7.18,-6.68,-6.63,-6.66,-6.88,-6.77,-6.64,-6.63,-6.23,-6.22,-6.52,-6.43,-5.88,-5.18,-4.55,-4,-3.51,-3.13,-2.87,-2.66,-2.53,-2.48,-2.42,-2.40,-2.38,-2.29,-2.11,-1.74,-1.25,-0.75,-0.38,-0.17,0.21,0.64,0.97,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,5,7,7,7,7,6,7,7,9,11,14,18,21,24,27,31,32,33,36,37,34,30,27,22,18,15,13,11,8,6,4,4,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,6,6,7,8,8,8,8,9,9,9,10,10,10,10,10,11,12,12,12,13,13,13,13,14,13,-5.84,-6.35,-6.88,-7.36,-7.75,-8.13,-8.47,-8.68,-8.91,-9.04,-9.14,-9.23,-9.30,-9.51,-9.85,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.76,-9.66,-9.72,-9.65,-9.59,-9.41,-9.17,-8.97,-8.73,-8.38,-8.02,-7.61,-7.05,-6.50,-5.91,-5.29,-4.67,-4.13,-3.65,-3.35,-3.12,-2.89,-2.52,-1.78,-0.47,1.62,4.27,6.97,9.61,12.32,15,18,20,22,24,27,29,31,29,25,20,15.49,11.82,7.96,4.75,2.50,0.75,-0.61,-1.78,-2.50,-2.93,-3.34,-3.87,-4.76,-6,-7.38,-8.76,-10,-11,-12,-13,-12,-12,-11,-11,-12,-12,-12,-12,-13,-14,-15,-16,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.65,-9.23,-8.68,-8.13,-7.68,-7.24,-7.24,-7.14,-7.13,-7.29,-7.17,-6.86,-6.77,-6.38,-5.90,-5.75,-5.52,-5,-4.51,-4,-3.53,-3.13,-2.78,-2.50,-2.29,-2.13,-2.03,-1.98,-1.92,-1.88,-1.78,-1.59,-1.22,-0.75,-0.28,0.03,0.21,0.25,0.32,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,4,5,5,5,5,7,8,10,13,17,21,25,30,35,37,38,40,41,39,36,32,28,24,21,18,16,13,9,6,5,4,4,3,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,6,6,6,7,7,8,8,9,9,9,9,10,10,10,10,11,11,12,12,13,14,14,15,15,15,15,15,15,-6.13,-6.75,-7.27,-7.74,-8.15,-8.50,-8.78,-9.05,-9.25,-9.38,-9.52,-9.55,-9.72,-9.86,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.90,-9.67,-9.40,-9.05,-8.66,-8.29,-7.88,-7.37,-6.78,-6.16,-5.53,-4.89,-4.28,-3.77,-3.39,-3.13,-2.85,-2.35,-1.48,-0.12,2.12,4.83,7.77,10.62,13.33,16.74,18,20,21,24,26,28,29,28,25,22,16.59,12.25,8.51,5.26,2.91,0.99,-0.48,-1.68,-2.42,-2.92,-3.37,-3.86,-4.75,-6.05,-7.54,-9.14,-10,-12,-13,-14,-14,-13,-12,-12,-12,-12,-12,-13,-14,-15,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.67,-9.25,-8.73,-8.13,-7.67,-7.48,-7.59,-7.50,-7.34,-7.47,-7.30,-6.93,-6.42,-6.14,-5.59,-5.18,-4.67,-4.27,-3.85,-3.40,-3.01,-2.65,-2.36,-2.09,-1.85,-1.65,-1.51,-1.41,-1.37,-1.29,-1.22,-1,-0.74,-0.38,-0.10,0.11,0.14,0.13,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,3,4,4,5,6,8,11,15,19,23,27,33,38,42,44,44,43,40,38,35,33,30,27,24,22,18,13,10,7,5,4,4,4,4,4,4,4,5,5,5,5,5,5,5,6,7,8,8,8,7,8,8,8,9,10,10,10,11,11,11,11,11,12,12,13,14,15,16,16,17,17,17,17,18,18,-6.50,-7.09,-7.59,-8.03,-8.43,-8.80,-9.13,-9.37,-9.51,-9.77,-9.88,-9.98,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.50,-9.12,-8.65,-8.13,-7.63,-7.03,-6.41,-5.76,-5.11,-4.43,-3.88,-3.48,-3.14,-2.80,-2.24,-1.28,0.07,2.39,5.27,8.37,11,13.34,15.72,19,20,21,23,25,28,28,27,25,21,16.87,12.99,9.51,6.32,3.59,1.34,-0.34,-1.59,-2.36,-2.89,-3.38,-3.88,-4.75,-6.09,-7.67,-9.43,-11,-13,-15,-15,-14,-14,-13,-13,-13,-12,-12,-13,-14,-15,-16,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-17,-16,-16,-15,-15,-15,-14,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.67,-9.23,-8.72,-8.13,-7.68,-7.61,-7.72,-7.61,-7.25,-7.25,-7.10,-6.77,-6.18,-5.50,-4.98,-4.48,-4,-3.55,-3.16,-2.78,-2.47,-2.13,-1.86,-1.60,-1.36,-1.14,-1,-0.88,-0.80,-0.75,-0.65,-0.52,-0.36,-0.14,0,0.09,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,3,3,4,4,6,9,12,17,22,26,31,35,39,42,44,43,41,39,36,35,34,32,29,28,27,23,18,14,11,7,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,8,9,10,10,8,8,8,9,10,11,11,11,11,12,12,12,12,13,14,15,16,17,18,19,20,19,19,20,21,21,-6.75,-7.34,-7.88,-8.35,-8.68,-9.03,-9.43,-9.75,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.49,-9,-8.50,-7.90,-7.28,-6.63,-5.98,-5.25,-4.60,-4,-3.59,-3.16,-2.72,-2.05,-1.10,0.52,2.87,5.62,8.28,10.47,12.37,14.15,17,18,18,20,23,24,25,25,23,20,16.15,13.50,10.36,6.98,3.96,1.53,-0.25,-1.50,-2.30,-2.88,-3.38,-3.99,-4.86,-6.13,-7.80,-9.72,-11,-13,-15,-15,-15,-14,-14,-13,-13,-12,-12,-13,-15,-16,-17,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-10,-9.61,-9.13,-8.63,-8.12,-7.63,-7.54,-7.63,-7.51,-7.14,-6.74,-6.61,-6.25,-5.54,-4.93,-4.38,-3.88,-3.37,-2.89,-2.50,-2.13,-1.87,-1.61,-1.36,-1.12,-0.88,-0.72,-0.59,-0.49,-0.39,-0.36,-0.27,-0.22,-0.12,0,0.03,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,4,6,8,13,19,25,30,33,35,36,37,38,38,37,36,34,34,32,31,31,31,30,28,24,20,16,11,8,7,6,5,5,5,5,5,6,6,6,6,6,6,7,8,10,11,10,9,9,9,9,10,11,11,12,12,13,13,13,14,14,15,17,17,18,20,21,22,22,22,22,24,24,-6.99,-7.61,-8.10,-8.51,-9.03,-9.49,-9.88,-10,-10,-10,-10,-10,-10,-11,-11,-12,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.77,-9.34,-8.79,-8.17,-7.51,-6.85,-6.13,-5.39,-4.73,-4.13,-3.63,-3.22,-2.73,-2.09,-1.11,0.58,3,5.77,8.25,9.99,11.14,12.12,12,13,15,17,18,19,20,20,18,17.01,15.88,14.50,11.13,7.20,3.76,1.27,-0.36,-1.51,-2.34,-2.88,-3.39,-4.02,-4.92,-6.25,-7.98,-9.98,-12,-13,-15,-15,-15,-14,-14,-13,-13,-12,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-17,-17,-16,-16,-16,-15,-15,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-9.90,-9.48,-9.02,-8.51,-7.98,-7.50,-7.26,-7.36,-7.23,-6.86,-6.39,-5.88,-5.47,-4.91,-4.40,-3.88,-3.36,-2.76,-2.26,-1.87,-1.50,-1.27,-1.09,-0.89,-0.68,-0.51,-0.38,-0.26,-0.18,-0.14,-0.12,-0.09,-0.03,0,0.02,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,3,3,4,5,8,13,20,26,30,32,31,32,32,32,33,33,33,31,32,30,29,32,32,31,31,29,25,20,15,12,9,7,6,6,5,5,6,6,6,6,7,7,7,7,8,9,10,10,10,10,10,10,11,12,12,12,13,13,13,14,15,15,17,18,19,20,21,23,24,24,24,25,26,26,-7.16,-7.75,-8.34,-8.90,-9.40,-9.80,-10,-10,-10,-10,-11,-11,-11,-11,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.53,-9.04,-8.42,-7.74,-7,-6.26,-5.51,-4.84,-4.22,-3.67,-3.25,-2.77,-2.13,-1.23,0.39,2.82,5.62,8.10,9.57,10.10,10.28,10,12,13,14,14,15,16,16,15,14.08,14.86,14.70,12.32,6.74,2.25,0.84,-0.63,-1.64,-2.38,-2.88,-3.38,-4.02,-4.93,-6.35,-8.13,-10,-12,-14,-15,-15,-15,-14,-14,-13,-12,-12,-13,-14,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-17,-17,-16,-16,-16,-15,-15,-15,-15,-15,-16,-16,-17,-17,-16,-16,-17,-17,-17,-17,-18,-17,-17,-17,-17,-17,-16,-16,-16,-16,-16,-16,-17,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-11,-10,-10,-9.75,-9.27,-8.84,-8.30,-7.77,-7.29,-6.88,-6.88,-6.60,-6.26,-5.77,-5.29,-4.80,-4.38,-3.92,-3.43,-2.88,-2.25,-1.73,-1.26,-0.91,-0.77,-0.64,-0.51,-0.38,-0.25,-0.16,-0.12,-0.05,-0.02,-0.01,0,0,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,4,7,12,18,23,25,27,26,27,28,27,29,29,29,28,29,28,28,30,31,31,32,31,30,26,20,17,13,10,8,6,6,6,6,6,6,7,7,8,8,8,8,9,10,10,11,11,11,11,12,13,13,13,14,14,14,15,15,16,18,20,21,22,24,25,26,27,27,28,29,29,-7.26,-8,-8.63,-9.18,-9.72,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-13,-13,-14,-14,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-9.75,-9.24,-8.65,-7.89,-7.15,-6.38,-5.62,-4.88,-4.25,-3.73,-3.27,-2.79,-2.16,-1.18,0.32,2.37,4.76,7.10,8.62,9.24,9.07,9.26,10,11,12,12,12,12,13,12.96,13.07,13.82,12.65,9.52,5.75,2.02,0.25,-0.93,-1.87,-2.49,-2.90,-3.38,-3.98,-4.89,-6.38,-8.18,-10,-12,-14,-15,-16,-15,-14,-13,-13,-13,-13,-13,-14,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-17,-16,-16,-16,-16,-16,-16,-17,-17,-17,-18,-18,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.52,-9.05,-8.61,-8.11,-7.53,-7.11,-6.63,-6.28,-5.98,-5.60,-5.14,-4.68,-4.25,-3.87,-3.49,-3.03,-2.47,-1.84,-1.26,-0.84,-0.49,-0.39,-0.34,-0.25,-0.16,-0.12,-0.05,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.14,0.37,0.63,0.85,1.21,1.86,2,2,3,3,5,8,14,17,18,20,20,22,23,23,25,26,24,24,26,24,26,28,28,30,30,31,31,30,27,23,20,15,12,9,8,7,7,7,7,7,7,8,8,9,9,10,10,12,11,12,12,12,13,14,14,14,15,15,16,16,17,18,20,22,23,25,27,28,29,30,30,32,34,33,-7.50,-8.18,-8.87,-9.47,-9.91,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.99,-9.36,-8.76,-8.03,-7.27,-6.48,-5.65,-4.90,-4.26,-3.75,-3.30,-2.87,-2.25,-1.37,-0.01,1.78,3.89,6.03,7.76,8.71,9,8.96,9.14,10,10,10,10,10,10,10.89,10.85,11.77,10.62,7.50,4.25,1.75,-0.03,-1.25,-2.09,-2.63,-2.99,-3.36,-3.88,-4.67,-6.36,-8.18,-10,-12,-13,-14,-15,-15,-14,-13,-13,-13,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-17,-16,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-19,-19,-19,-18,-18,-18,-18,-17,-17,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-9.85,-9.25,-8.76,-8.29,-7.76,-7.18,-6.75,-6.27,-5.84,-5.38,-4.93,-4.50,-4.09,-3.68,-3.36,-3,-2.62,-2.02,-1.47,-0.91,-0.50,-0.23,-0.14,-0.13,-0.09,-0.05,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.15,0.37,0.62,0.98,1.33,1.62,2,2.37,3.07,4.26,6.50,9.03,11.64,12.87,14,16,18,19,19,21,21,20,21,22,22,23,24,25,25,26,26,28,29,29,27,24,20,16,13,10,8,8,7,7,7,8,8,8,9,10,10,11,12,12,12,13,13,14,14,15,15,16,17,17,18,18,20,21,23,25,27,29,31,32,33,34,36,37,37,-7.65,-8.39,-9.01,-9.60,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-15,-16,-16,-16,-15,-15,-15,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.59,-8.88,-8.14,-7.37,-6.50,-5.67,-4.92,-4.27,-3.75,-3.35,-2.88,-2.34,-1.52,-0.38,1.13,3.08,5.25,7.23,8.63,9.12,8.96,8.63,8,8,8,8,8,8,8,8.15,7.82,6.73,4.49,2.58,1.08,-0.36,-1.50,-2.27,-2.75,-3.10,-3.43,-3.75,-4.41,-6.50,-8.17,-9.80,-11,-12,-13,-14,-14,-13,-13,-12,-12,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-17,-17,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-17,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,-10,-9.49,-8.88,-8.40,-7.97,-7.42,-6.85,-6.38,-5.88,-5.37,-4.84,-4.34,-3.85,-3.40,-3.05,-2.75,-2.41,-2.10,-1.60,-1.11,-0.65,-0.30,-0.11,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.16,0.38,0.65,0.99,1.32,1.64,2.07,2.52,3.33,4.40,5.77,6.65,7.50,9.27,11.98,13,14,15,15,15,15,17,17,18,20,20,20,20,20,22,23,26,26,25,25,24,21,17,14,11,9,8,8,8,8,8,8,9,10,10,11,11,12,12,13,14,15,15,16,16,18,19,19,19,20,22,23,25,27,30,33,34,36,37,39,40,41,41,-7.75,-8.50,-9.13,-9.68,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.75,-9.04,-8.25,-7.39,-6.52,-5.67,-4.91,-4.25,-3.75,-3.35,-2.91,-2.40,-1.68,-0.73,0.53,2.25,4.62,7.25,9.25,9.87,9.25,7.75,7,6,6,6,6,5,5.87,5.20,5,4.10,2.49,1.57,0.50,-0.61,-1.65,-2.39,-2.88,-3.25,-3.68,-4.28,-5.47,-6.80,-8.26,-9.55,-10,-11,-12,-13,-13,-13,-13,-12,-13,-14,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-18,-17,-16,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.63,-9.02,-8.47,-8,-7.50,-7,-6.47,-5.93,-5.42,-4.89,-4.28,-3.72,-3.13,-2.65,-2.30,-2.03,-1.75,-1.48,-1.12,-0.75,-0.42,-0.17,-0.03,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.22,0.41,0.70,1,1.34,1.71,2.08,2.57,3,3.65,4.41,5.62,6.95,8.25,9,10,11,11,11,12,13,14,15,15,16,16,16,18,20,21,23,23,22,22,23,23,21,17,14,12,10,9,8,9,9,9,9,10,10,11,11,12,13,13,14,15,16,16,17,18,19,20,22,22,24,26,27,29,32,35,38,40,42,44,45,46,46,-7.80,-8.52,-9.14,-9.72,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-14,-14,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.85,-9.13,-8.28,-7.41,-6.51,-5.66,-4.88,-4.25,-3.75,-3.34,-2.93,-2.50,-1.88,-1.03,0.02,1.62,4.37,7.83,10.77,11.53,10.12,8.03,6.15,6,5,5,4,4,3.88,3.20,3.08,2.37,1.47,0.87,0.37,-0.89,-1.80,-2.51,-3.02,-3.59,-4.25,-5.13,-6.22,-7.38,-8.50,-9.49,-10,-10,-11,-12,-13,-13,-13,-13,-13,-14,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-18,-19,-19,-19,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-17,-16,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.89,-9.05,-8.53,-7.99,-7.50,-7.01,-6.50,-6,-5.50,-5,-4.43,-3.79,-3.13,-2.47,-1.88,-1.49,-1.25,-1.05,-0.85,-0.63,-0.40,-0.25,-0.10,0,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.25,0.46,0.71,1,1.34,1.70,2,2.36,2.71,3.24,4.12,4.98,5.59,6.27,6,7,7,8,9,9,11,12,11,12,13,15,17,18,20,20,20,18,17,18,20,22,21,19,16,13,11,10,9,9,10,10,10,10,11,12,13,14,15,14,14,17,17,18,19,20,22,23,24,26,28,29,31,35,39,42,45,47,49,50,51,51,-7.78,-8.50,-9.13,-9.73,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-13,-14,-14,-15,-16,-16,-16,-16,-16,-16,-16,-15,-14,-14,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.79,-9.13,-8.35,-7.39,-6.49,-5.63,-4.85,-4.22,-3.72,-3.30,-2.97,-2.54,-2,-1.27,-0.37,1.16,4.39,8.61,13.21,14.63,11.33,8.25,7.23,6,5,4,3,3,2.87,2.16,1.96,1.34,0.89,0.47,-0.50,-1.27,-2.04,-2.65,-3.25,-3.90,-4.78,-5.87,-6.93,-7.98,-8.86,-9.53,-10,-10,-10,-11,-12,-12,-13,-13,-14,-14,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-18,-18,-18,-18,-18,-18,-17,-16,-16,-15,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-10,-10,-9.26,-8.50,-7.93,-7.42,-6.97,-6.48,-6,-5.50,-5.01,-4.53,-4,-3.36,-2.61,-1.86,-1.15,-0.66,-0.52,-0.38,-0.28,-0.25,-0.14,-0.05,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.25,0.46,0.72,1,1.32,1.62,1.87,2.15,2.59,3.10,3.63,4.09,4.49,4.87,5,6,6,7,8,9,9,9,10,12,14,16,17,19,18,16,15,14,16,19,21,23,24,21,17,14,11,9,10,10,10,10,10,11,13,14,15,15,16,16,17,18,18,19,21,23,24,26,28,29,31,34,37,42,44,46,48,49,50,51,51,-7.65,-8.42,-9.13,-9.80,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-14,-14,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.75,-9.04,-8.25,-7.38,-6.39,-5.53,-4.77,-4.14,-3.65,-3.28,-2.98,-2.61,-2.10,-1.41,-0.50,0.99,4.12,8.76,14.12,14.53,12.61,10.25,8.12,6.97,5,4,3.27,2.75,2.33,1.83,1.41,1.08,0.51,-0.24,-1,-1.76,-2.37,-2.92,-3.54,-4.38,-5.43,-6.63,-7.73,-8.63,-9.28,-9.74,-9.97,-10,-10,-10,-11,-11,-12,-13,-14,-14,-14,-14,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-18,-18,-18,-17,-17,-17,-16,-15,-15,-14,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.36,-8.51,-7.87,-7.29,-6.80,-6.35,-5.88,-5.41,-4.99,-4.52,-4.10,-3.59,-2.92,-2.16,-1.38,-0.66,-0.13,-0.02,0.09,0.11,0.02,0.01,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.25,0.46,0.71,0.98,1.25,1.52,1.76,2.08,2.39,2.76,3.11,3.50,3.89,4,5,5,6,6,7,8,9,11,13,14,15,16,16,16,13,13,13,16,19,22,25,27,25,20,17,13,10,10,11,11,11,11,11,13,14,15,17,17,17,17,18,19,20,21,23,25,27,29,31,33,36,39,42,43,44,44,45,45,46,46,-7.51,-8.37,-9.13,-9.88,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.59,-8.88,-8.11,-7.17,-6.29,-5.47,-4.73,-4.10,-3.62,-3.25,-2.99,-2.63,-2.14,-1.51,-0.63,0.70,3.09,6.08,10.12,13.50,13.98,11.39,9.09,6.99,5.25,4,3.20,2.47,1.87,1.36,1.07,0.86,0.26,-0.51,-1.42,-2.13,-2.73,-3.30,-3.99,-4.92,-6.14,-7.40,-8.59,-9.38,-9.80,-10,-9.93,-9.76,-9.61,-9.73,-10,-11,-12,-13,-13,-13,-13,-14,-15,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-18,-18,-18,-17,-17,-17,-17,-17,-16,-16,-15,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.75,-9.18,-8.40,-7.74,-7.13,-6.60,-6.13,-5.68,-5.26,-4.86,-4.42,-4.02,-3.62,-3.13,-2.55,-1.80,-1.11,-0.43,0.03,0.21,0.32,0.26,0.22,0.11,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.25,0.46,0.70,0.91,1.20,1.40,1.65,1.90,2.21,2.50,2.87,3.26,3.99,4,4,5,5,6,8,11,13,14,15,14,14,15,12,11,10,13,17,20,23,26,26,26,23,20,16,11,10,11,12,11,11,12,13,15,16,17,17,18,18,19,19,20,22,23,26,30,31,33,35,38,40,40,40,40,41,42,42,42,43,-7.39,-8.29,-9.10,-9.79,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.65,-8.97,-8,-7.01,-6.25,-5.38,-4.63,-4.01,-3.54,-3.25,-3,-2.67,-2.25,-1.67,-0.97,0.07,1.49,3.32,3.85,10.52,14.01,12.12,9.60,6.95,4.87,3.52,2.86,2.08,1.50,0.89,0.50,0.24,-0.18,-0.89,-1.76,-2.49,-3.10,-3.72,-4.47,-5.50,-6.75,-8.05,-9.13,-9.88,-10,-10,-10,-9.59,-9.24,-9.24,-9.68,-10,-11,-12,-12,-12,-13,-13,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-18,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-18,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-13,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.90,-9.65,-9.27,-8.78,-8.13,-7.49,-6.86,-6.34,-5.86,-5.43,-5.03,-4.64,-4.26,-3.88,-3.50,-3.12,-2.66,-2.14,-1.50,-0.87,-0.30,0.10,0.25,0.33,0.26,0.21,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.25,0.45,0.62,0.87,1.10,1.34,1.57,1.82,2.08,2.38,2.77,3.09,3,4,4,4,5,7,10,11,14,14,13,12,12,11,8,9,12,15,19,22,24,24,24,23,22,17,12,10,11,11,12,12,13,14,15,17,17,18,18,20,20,20,21,22,24,27,31,34,35,37,38,38,38,39,40,41,42,42,42,42,-7.25,-8.13,-8.97,-9.74,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.90,-9.16,-8.34,-7.30,-6.25,-5.37,-4.59,-3.97,-3.50,-3.24,-3,-2.76,-2.41,-1.98,-1.42,-0.79,-0.04,0.83,3.22,6.65,11.12,12.73,10.10,5.73,3.46,2.50,2.08,1.50,0.91,0.27,-0.24,-0.63,-0.99,-1.50,-2.23,-2.84,-3.41,-4.04,-4.85,-5.88,-7.13,-8.39,-9.50,-10,-10,-10,-10,-9.49,-8.90,-8.75,-9.03,-9.68,-10,-11,-11,-11,-12,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-18,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-18,-18,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-13,-12,-11,-11,-11,-10,-10,-10,-9.85,-9.41,-9.17,-9,-8.86,-8.60,-8.17,-7.66,-7.12,-6.52,-5.99,-5.53,-5.13,-4.76,-4.40,-4.09,-3.73,-3.36,-2.98,-2.55,-2.14,-1.67,-1.14,-0.64,-0.24,0.09,0.25,0.25,0.23,0.13,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.25,0.37,0.59,0.78,1.01,1.25,1.48,1.72,2,2.33,2.62,2.95,3.03,3,4,4,6,8,9,11,12,11,10,9,9,8,9,11,13,16,18,20,21,20,21,22,19,14,11,11,12,13,13,13,14,16,17,18,19,20,20,21,22,22,23,24,28,32,35,36,37,37,37,38,39,41,42,43,44,43,43,-7,-7.92,-8.75,-9.48,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.03,-7.67,-6.47,-5.40,-4.53,-3.91,-3.50,-3.23,-3.02,-2.88,-2.63,-2.36,-2,-1.63,-1.13,-0.27,1.24,3.13,6.33,8.75,6.95,1.77,1.59,0.89,0.82,0.59,0.25,-0.40,-1.04,-1.55,-1.84,-2.18,-2.66,-3.15,-3.68,-4.29,-5.09,-6.03,-7.16,-8.38,-9.41,-10,-10,-10,-9.87,-9.38,-8.91,-8.65,-8.74,-9.03,-9.48,-9.87,-10,-10,-12,-13,-14,-15,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-18,-18,-18,-18,-18,-19,-19,-20,-20,-20,-20,-20,-19,-19,-19,-18,-18,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-14,-13,-12,-12,-11,-10,-10,-10,-9.88,-9.49,-8.97,-8.40,-8.24,-8.05,-7.79,-7.50,-7.13,-6.65,-6.15,-5.64,-5.17,-4.84,-4.47,-4.15,-3.85,-3.51,-3.17,-2.80,-2.40,-2,-1.61,-1.17,-0.78,-0.42,-0.13,0.09,0.16,0.15,0.12,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.22,0.37,0.57,0.76,1,1.21,1.40,1.64,1.91,2.24,2.59,2.83,3.02,3,4,5,6,7,8,8,8,8,8,7,7,8,10,11,13,15,17,18,18,19,21,20,15,12,11,12,13,13,14,15,16,17,19,20,21,21,22,23,24,25,26,29,32,34,36,36,37,37,38,40,43,45,46,46,45,44,-6.65,-7.62,-8.43,-9.17,-9.88,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-11,-10,-8.85,-6.85,-5.63,-4.59,-3.90,-3.48,-3.22,-3.04,-2.97,-2.84,-2.67,-2.50,-2.26,-1.88,-1.23,-0.29,1.07,2.33,2.13,2.12,0.96,-0.22,-0.40,-0.18,0.03,-0.16,-0.86,-1.63,-2.13,-2.49,-2.73,-3.01,-3.39,-3.88,-4.41,-5.12,-5.98,-6.97,-8,-8.99,-9.64,-10,-9.88,-9.65,-9.26,-8.88,-8.53,-8.42,-8.50,-8.64,-8.88,-9.35,-10,-11,-12,-13,-14,-15,-15,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-18,-18,-18,-18,-18,-19,-19,-19,-20,-20,-19,-19,-19,-19,-18,-18,-18,-17,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-11,-10,-10,-9.67,-9.42,-9.11,-8.63,-8.13,-7.64,-7.42,-7.16,-6.88,-6.55,-6.16,-5.75,-5.34,-4.88,-4.50,-4.18,-3.88,-3.61,-3.28,-3,-2.65,-2.26,-1.88,-1.49,-1.10,-0.74,-0.41,-0.23,-0.04,0.08,0.12,0.12,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.11,0.22,0.37,0.57,0.76,0.99,1.15,1.37,1.61,1.85,2.23,2.59,2.84,3,3,4,5,5,6,6,6,6,7,7,7,7,9,10,11,12,13,14,14,17,19,19,16,14,12,12,13,13,14,15,17,18,19,20,21,23,23,24,25,26,28,31,33,35,36,36,37,38,39,42,47,49,50,50,48,47,-6.27,-7.15,-8.02,-8.79,-9.54,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-10,-10,-11,-12,-13,-13,-12,-11,-9.75,-7.79,-5.89,-4.63,-3.88,-3.47,-3.18,-3.09,-3,-2.97,-2.88,-2.80,-2.67,-2.42,-2,-1.41,-0.84,-0.47,-0.37,-0.40,-0.84,-1.18,-1.29,-0.97,-0.62,-0.63,-1.16,-1.87,-2.50,-2.84,-2.98,-3.18,-3.51,-3.92,-4.39,-5,-5.72,-6.53,-7.40,-8.24,-8.87,-9.22,-9.40,-9.38,-9.15,-8.87,-8.55,-8.34,-8.17,-8.12,-8.15,-8.63,-9.52,-10,-11,-12,-13,-14,-15,-16,-16,-17,-17,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-18,-17,-18,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-17,-16,-16,-15,-15,-15,-15,-14,-14,-13,-13,-12,-11,-11,-10,-9.49,-8.99,-8.63,-8.23,-7.75,-7.24,-7,-6.66,-6.39,-6.09,-5.75,-5.38,-5.01,-4.63,-4.25,-3.92,-3.66,-3.38,-3.11,-2.78,-2.49,-2.13,-1.75,-1.38,-1,-0.65,-0.38,-0.15,-0.03,0.01,0.03,0.08,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.23,0.38,0.61,0.82,1,1.16,1.37,1.52,1.90,2.26,2.52,2.82,3,3,4,4,5,5,5,6,6,6,6,7,8,9,10,10,10,11,12,14,16,17,17,15,13,13,13,13,14,15,17,18,19,20,22,23,24,24,26,28,30,33,35,37,37,36,37,38,40,44,48,51,53,53,52,51,-6.05,-6.75,-7.62,-8.50,-9.26,-9.97,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-11,-13,-14,-14,-13,-12,-10,-8.40,-6.22,-4.76,-3.88,-3.43,-3.17,-3.09,-3.01,-3,-3,-2.97,-2.89,-2.76,-2.54,-2.26,-2.01,-1.80,-1.76,-1.76,-1.93,-2.10,-1.98,-1.63,-1.05,-0.97,-1.50,-2.22,-2.74,-2.97,-3.05,-3.24,-3.51,-3.88,-4.26,-4.75,-5.29,-5.98,-6.66,-7.38,-7.97,-8.47,-8.80,-9,-9,-8.80,-8.62,-8.38,-8.13,-8.04,-8.13,-8.50,-9.24,-10,-11,-12,-13,-13,-14,-15,-15,-16,-17,-17,-17,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-17,-17,-17,-17,-18,-18,-18,-18,-19,-19,-19,-19,-18,-18,-18,-18,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-9.55,-8.75,-8.17,-7.84,-7.40,-6.88,-6.55,-6.26,-6,-5.68,-5.38,-5.05,-4.75,-4.39,-4.09,-3.75,-3.49,-3.24,-2.92,-2.63,-2.29,-1.99,-1.63,-1.25,-0.92,-0.62,-0.35,-0.14,-0.02,0.03,0.02,0.03,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.27,0.49,0.70,0.87,1.07,1.24,1.38,1.73,2.01,2.26,2.37,3,3,3,4,4,4,5,5,6,6,6,6,7,8,8,8,9,10,10,11,13,14,15,15,14,13,13,14,15,16,16,17,18,20,22,24,24,26,27,29,31,35,36,37,36,36,37,38,40,43,48,52,55,56,57,55,-5.93,-6.63,-7.30,-8.05,-8.87,-9.59,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-12,-13,-14,-14,-14,-13,-11,-9.54,-6.54,-4.85,-3.98,-3.43,-3.22,-3.09,-3.02,-3.01,-3,-3,-3,-2.93,-2.87,-2.75,-2.63,-2.54,-2.51,-2.63,-2.63,-2.63,-2.52,-2.28,-2.09,-2,-2.22,-2.54,-2.86,-3,-3.05,-3.16,-3.43,-3.74,-4.03,-4.39,-4.84,-5.30,-5.88,-6.49,-7.09,-7.63,-8.13,-8.52,-8.75,-8.75,-8.63,-8.43,-8.27,-8.17,-8.18,-8.47,-9,-9.86,-10,-11,-12,-13,-13,-14,-15,-15,-16,-16,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-17,-17,-17,-17,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.42,-8.74,-7.88,-7.27,-6.91,-6.54,-6.23,-5.90,-5.63,-5.37,-5.09,-4.76,-4.50,-4.23,-3.90,-3.63,-3.37,-3.10,-2.80,-2.50,-2.17,-1.86,-1.50,-1.15,-0.85,-0.54,-0.34,-0.14,-0.03,0.01,0.03,0.02,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.23,0.39,0.62,0.83,1,1.16,1.36,1.62,1.87,2.09,2.25,2.14,2.91,3.02,3,4,4,4,5,5,5,6,6,6,7,7,7,8,9,9,10,12,13,13,13,14,14,13,14,16,17,17,18,18,19,21,23,25,26,29,30,32,34,36,35,36,36,37,38,40,43,48,52,55,57,57,56,-5.87,-6.63,-7.29,-7.91,-8.47,-9.03,-9.60,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-12,-13,-14,-14,-14,-14,-12,-10,-7.48,-5.30,-4.40,-3.65,-3.25,-3.13,-3.05,-3.03,-3.04,-3.04,-3.04,-3.03,-3.01,-3,-2.97,-2.97,-2.97,-2.99,-2.99,-2.98,-2.98,-2.86,-2.75,-2.63,-2.75,-2.86,-2.97,-3.01,-3.04,-3.13,-3.34,-3.53,-3.77,-4.03,-4.34,-4.65,-5.09,-5.64,-6.24,-6.85,-7.40,-7.93,-8.35,-8.52,-8.53,-8.48,-8.41,-8.43,-8.52,-8.75,-9.14,-9.97,-10,-11,-12,-12,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-17,-17,-18,-18,-18,-18,-18,-18,-17,-16,-16,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.38,-8.63,-7.86,-6.92,-6.48,-6.13,-5.86,-5.54,-5.28,-5.04,-4.79,-4.53,-4.26,-4.01,-3.76,-3.50,-3.25,-2.99,-2.73,-2.39,-2.10,-1.75,-1.40,-1.09,-0.76,-0.50,-0.27,-0.13,-0.03,0,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.20,0.37,0.58,0.77,0.98,1.13,1.36,1.60,1.83,2,2.12,2.32,2.62,2.95,3.12,3.37,3.71,4.01,4.35,4.66,5,5.12,6,6,6,7,7,7,8,9,10,11,12,12,12,13,13,13,15,16,18,18,18,19,20,22,24,26,27,29,31,32,34,35,34,35,36,36,37,39,42,47,51,53,54,54,52,-5.78,-6.50,-7.23,-7.80,-8.36,-8.80,-9.23,-9.53,-9.88,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-13,-14,-14,-15,-14,-13,-11,-8.63,-6.37,-5.15,-4.30,-3.59,-3.34,-3.16,-3.18,-3.24,-3.25,-3.25,-3.25,-3.24,-3.17,-3.18,-3.10,-3.38,-3.29,-3.18,-3.11,-3.04,-3,-2.97,-2.97,-2.97,-2.99,-3,-3.01,-3.02,-3.10,-3.17,-3.35,-3.50,-3.67,-3.88,-4.11,-4.38,-4.89,-5.42,-6.04,-6.66,-7.26,-7.77,-8.13,-8.25,-8.37,-8.50,-8.67,-8.92,-9.28,-9.75,-10,-10,-11,-11,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-16,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-17,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-10,-10,-9.78,-9.22,-8.42,-7.75,-6.90,-6.25,-5.78,-5.50,-5.23,-4.97,-4.75,-4.52,-4.29,-4.05,-3.85,-3.62,-3.38,-3.13,-2.88,-2.62,-2.30,-2,-1.63,-1.30,-1,-0.74,-0.49,-0.27,-0.13,-0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.15,0.35,0.52,0.75,0.97,1.13,1.36,1.59,1.78,1.98,2.12,2.32,2.57,2.82,3,3.15,3.49,3.82,4.12,4.47,4.76,5.12,5.25,5.98,6,6,7,7,8,9.02,10.08,9.89,11.12,10.87,11.87,13.12,12.89,14.03,15.02,16,17,18,19,21,22,23,25,27,28,30,32,33,33,33,34,36,36,36,37,38,40,44,47,49,49,48,48,-5.80,-6.40,-7.01,-7.66,-8.22,-8.63,-9.04,-9.38,-9.66,-9.88,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-14,-15,-14,-13,-12,-9.99,-8.18,-6.91,-6.02,-4.85,-3.75,-3.53,-3.51,-3.62,-3.72,-3.75,-3.74,-3.72,-3.43,-3.27,-3.79,-4.27,-4.16,-3.87,-3.48,-3.17,-3.09,-3.02,-3,-3,-3,-2.99,-2.97,-2.93,-2.98,-3,-3.12,-3.25,-3.38,-3.50,-3.64,-3.88,-4.29,-4.75,-5.34,-5.93,-6.53,-7.11,-7.50,-7.84,-8.12,-8.47,-8.88,-9.29,-9.79,-10,-10,-11,-11,-11,-12,-12,-13,-14,-14,-15,-15,-15,-14,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-14,-14,-15,-15,-15,-15,-16,-16,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.48,-8.80,-8.09,-7.38,-6.73,-6.10,-5.61,-5.14,-4.88,-4.65,-4.41,-4.25,-4.04,-3.86,-3.63,-3.42,-3.23,-3,-2.75,-2.50,-2.22,-1.88,-1.53,-1.23,-0.89,-0.63,-0.43,-0.26,-0.13,-0.05,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.14,0.32,0.50,0.73,0.95,1.12,1.35,1.58,1.76,1.97,2.12,2.27,2.50,2.74,2.91,3.08,3.37,3.66,4,4.36,4.71,5,5.37,5.73,6.07,6.13,7,7,8,9.11,8.85,10.16,9.79,10.79,12.20,13.20,14.16,13.85,14.88,15.95,17,19,21,21,23,24,25,27,29,31,32,34,33,33,34,35,36,37,36,37,39,41,43,44,44,45,45,-5.77,-6.36,-6.88,-7.38,-7.92,-8.41,-8.85,-9.16,-9.43,-9.66,-9.79,-9.89,-9.97,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-11,-11,-10,-10,-11,-11,-13,-13,-14,-14,-13,-12,-11,-10,-9.36,-8.15,-6.78,-5.34,-4.25,-4,-4.14,-4.60,-4.72,-4.60,-4.30,-4.79,-5.74,-5.89,-5.97,-5.64,-5.04,-4.28,-3.61,-3.17,-3.05,-3.01,-3,-2.93,-2.87,-2.76,-2.74,-2.72,-2.75,-2.85,-2.98,-3.12,-3.24,-3.36,-3.50,-3.86,-4.23,-4.68,-5.25,-5.84,-6.38,-6.85,-7.25,-7.74,-8.26,-8.88,-9.51,-10,-10,-11,-11,-11,-11,-12,-12,-13,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.79,-9.25,-8.67,-8.01,-7.27,-6.63,-6,-5.48,-5,-4.62,-4.38,-4.16,-3.97,-3.76,-3.61,-3.40,-3.24,-3.03,-2.84,-2.61,-2.36,-2.10,-1.77,-1.47,-1.13,-0.80,-0.55,-0.36,-0.24,-0.13,-0.05,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.25,0.47,0.66,0.87,1.11,1.34,1.57,1.75,1.95,2.11,2.25,2.47,2.65,2.87,3.07,3.27,3.60,3.91,4.27,4.63,5,5.36,5.75,6.12,6.57,6.97,6.92,7.87,9.16,8.78,10.24,9.75,10.73,11.73,12.75,13.75,15,16.16,17.12,18.08,19,20,22,23,24,26,27,29,31,33,34,32,31,33,34,35,36,36,37,37,38,39,40,41,42,43,-5.67,-6.27,-6.79,-7.26,-7.74,-8.10,-8.55,-8.93,-9.24,-9.48,-9.63,-9.73,-9.72,-9.68,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-12,-12,-13,-13,-12,-12,-12,-12,-11,-9.63,-8.25,-7.40,-6.48,-5.55,-5.63,-5.86,-5.88,-5.90,-6.25,-7.38,-8.39,-8.52,-8.23,-7.59,-6.66,-5.53,-4.37,-3.50,-3.12,-3.02,-2.97,-2.85,-2.63,-2.38,-2.22,-2.17,-2.29,-2.49,-2.67,-2.88,-3.01,-3.13,-3.25,-3.51,-3.79,-4.17,-4.63,-5.13,-5.63,-6.13,-6.63,-7.22,-7.88,-8.64,-9.50,-10,-11,-11,-11,-11,-11,-12,-12,-13,-14,-14,-15,-15,-15,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-12,-12,-13,-13,-13,-13,-13,-14,-13,-13,-14,-13,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-9.74,-9.30,-8.84,-8.38,-7.76,-7.14,-6.50,-5.91,-5.36,-4.90,-4.50,-4.15,-3.92,-3.74,-3.51,-3.35,-3.15,-3,-2.80,-2.63,-2.41,-2.18,-1.93,-1.66,-1.38,-1.04,-0.75,-0.48,-0.27,-0.15,-0.09,-0.04,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.21,0.37,0.60,0.83,1.07,1.32,1.51,1.73,1.89,2.08,2.24,2.40,2.62,2.83,3.01,3.25,3.52,3.87,4.23,4.59,4.96,5.35,5.75,6.21,6.64,7.16,7.76,7.83,9.23,8.73,10.15,11.29,12.32,12.83,13.83,15.28,16.26,15.76,16.82,17.87,18.95,21,22,24,25,26,28,29,31,33,34,32,31,32,33,34,35,36,36,36,37,37,38,39,40,41,-5.55,-6.11,-6.64,-7.23,-7.73,-8.14,-8.50,-8.85,-9.10,-9.30,-9.48,-9.53,-9.53,-9.50,-9.79,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-12,-10,-9.84,-9.62,-9.15,-8.22,-7.84,-7.55,-7.49,-7.63,-8.51,-9.93,-10,-11,-10,-9.60,-8.30,-6.80,-5.28,-3.99,-3.25,-3.04,-2.88,-2.64,-2.25,-1.80,-1.49,-1.41,-1.65,-2.04,-2.38,-2.67,-2.88,-3,-3.12,-3.27,-3.50,-3.76,-4.12,-4.50,-4.89,-5.38,-5.92,-6.54,-7.34,-8.22,-9.14,-10,-10,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-15,-15,-14,-14,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-10,-9.91,-9.59,-9.22,-8.75,-8.25,-7.87,-7.38,-6.79,-6.28,-5.78,-5.28,-4.79,-4.41,-4.05,-3.77,-3.53,-3.30,-3.11,-2.89,-2.73,-2.53,-2.38,-2.18,-2,-1.77,-1.53,-1.27,-1,-0.73,-0.47,-0.25,-0.11,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.27,0.50,0.75,1,1.25,1.49,1.70,1.87,2.02,2.22,2.37,2.59,2.76,3,3.24,3.50,3.82,4.14,4.51,4.89,5.28,5.73,6.16,6.67,7.26,7.76,8.03,9.26,10.29,9.66,10.64,13.35,14.35,15.35,16.33,15.70,17.26,18.23,17.83,20.11,21.02,22,23,25,26,28,30,31,33,33,32,30,31,32,33,34,35,35,35,36,36,37,38,39,39,-5.54,-6.11,-6.63,-7.22,-7.72,-8.13,-8.51,-8.79,-9.04,-9.24,-9.35,-9.41,-9.40,-9.41,-9.68,-9.92,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-11,-12,-12,-13,-13,-13,-12,-11,-11,-11,-11,-10,-9.98,-9.65,-9.18,-9.36,-10,-11,-13,-13,-13,-11,-9.72,-7.88,-6,-4.43,-3.42,-3.09,-2.86,-2.48,-1.85,-1.18,-0.75,-0.76,-1.09,-1.62,-2.13,-2.50,-2.74,-2.88,-2.98,-3.10,-3.25,-3.43,-3.67,-3.93,-4.25,-4.67,-5.18,-5.84,-6.62,-7.54,-8.52,-9.50,-10,-10,-11,-11,-11,-11,-12,-13,-14,-15,-15,-15,-15,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.51,-9.14,-9.39,-9.88,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-11,-10,-9.50,-8.88,-8.50,-8.04,-7.62,-7.15,-6.67,-6.15,-5.67,-5.15,-4.75,-4.35,-4,-3.68,-3.40,-3.15,-2.91,-2.67,-2.48,-2.26,-2.10,-1.91,-1.75,-1.59,-1.38,-1.16,-0.92,-0.68,-0.48,-0.25,-0.13,-0.02,0,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.24,0.46,0.66,0.95,1.16,1.41,1.62,1.84,2,2.16,2.37,2.53,2.75,2.96,3.16,3.46,3.75,4.10,4.47,4.85,5.25,5.66,6.12,6.53,6.99,7.50,8.07,8.79,10.35,11.37,12.37,13.38,13.77,14.77,16.37,17.35,16.70,18.26,19.21,20.14,20.91,22,23,25,27,29,30,31,33,33,31,30,30,31,31,32,33,34,35,35,36,36,37,38,38,-5.64,-6.22,-6.66,-7.13,-7.63,-8.09,-8.42,-8.75,-9.03,-9.25,-9.38,-9.42,-9.47,-9.49,-9.64,-9.85,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-12,-12,-12,-12,-13,-12,-12,-11,-11,-11,-11,-12,-13,-14,-15,-14,-12,-10,-8.49,-6.38,-4.68,-3.59,-3.11,-2.84,-2.38,-1.66,-0.88,-0.50,-0.47,-0.75,-1.25,-1.93,-2.28,-2.52,-2.66,-2.76,-2.85,-2.98,-3.13,-3.30,-3.51,-3.73,-4.09,-4.50,-5.10,-5.80,-6.75,-7.68,-8.63,-9.49,-10,-10,-10,-10,-11,-11,-12,-13,-14,-15,-15,-15,-14,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.67,-9.25,-9.13,-8.84,-8.53,-8.66,-9.09,-9.85,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-12,-11,-10,-9.91,-9.10,-8.47,-7.92,-7.48,-7.01,-6.59,-6.12,-5.63,-5.14,-4.65,-4.29,-3.91,-3.63,-3.34,-3.03,-2.77,-2.50,-2.25,-2.01,-1.84,-1.63,-1.49,-1.34,-1.16,-1.01,-0.84,-0.64,-0.48,-0.28,-0.14,-0.04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.23,0.39,0.62,0.87,1.12,1.37,1.60,1.78,1.98,2.13,2.34,2.50,2.71,2.89,3.12,3.38,3.71,4.02,4.38,4.77,5.21,5.62,6.11,6.50,6.97,7.50,8.11,8.82,9.63,11,12.39,13.39,13.76,15.39,16.38,15.62,16.66,17.84,19.24,20.16,21.10,23,24,25,28,29,30,32,32,32,31,30,29,29,30,31,32,35,35,36,36,36,37,38,38,-5.73,-6.25,-6.75,-7.18,-7.59,-8,-8.41,-8.79,-9.09,-9.34,-9.43,-9.52,-9.54,-9.60,-9.64,-9.88,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-12,-12,-12,-13,-13,-14,-13,-13,-12,-13,-13,-13,-13,-13,-15,-15,-14,-13,-11,-8.54,-6.25,-4.61,-3.59,-3.13,-2.87,-2.49,-1.79,-1.13,-0.63,-0.50,-0.64,-1.16,-1.75,-2.13,-2.23,-2.35,-2.43,-2.51,-2.65,-2.80,-3,-3.15,-3.35,-3.62,-3.93,-4.39,-5.03,-5.88,-6.75,-7.62,-8.38,-9,-9.43,-9.68,-10,-10,-11,-12,-12,-13,-14,-14,-14,-14,-13,-12,-11,-11,-10,-10,-10,-10,-9.89,-9.63,-9.15,-9.02,-8.89,-8.50,-8.61,-8.62,-9.35,-9.63,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-11,-10,-10,-9.28,-8.54,-7.90,-7.38,-6.88,-6.43,-6,-5.55,-5.13,-4.66,-4.25,-3.88,-3.53,-3.25,-2.93,-2.65,-2.38,-2.11,-1.84,-1.61,-1.38,-1.24,-1.09,-0.93,-0.80,-0.67,-0.54,-0.40,-0.28,-0.17,-0.10,-0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.21,0.37,0.59,0.83,1.08,1.32,1.52,1.75,1.91,2.12,2.27,2.48,2.64,2.87,3.10,3.36,3.63,3.99,4.35,4.74,5.13,5.60,6.08,6.48,6.96,7.50,8.13,8.87,9.67,10.60,11.57,13.41,13.75,15.41,14.60,15.62,17.35,18.29,19.25,18.79,19.87,22,23,25,27,28,29,31,32,32,30,29,28,28,29,31,33,35,36,36,37,37,37,38,38,-5.72,-6.25,-6.75,-7.28,-7.76,-8.22,-8.59,-8.85,-9.11,-9.28,-9.42,-9.50,-9.53,-9.55,-9.67,-9.77,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-11,-12,-13,-14,-14,-14,-14,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-10,-7.86,-5.43,-4,-3.38,-3,-3,-2.74,-2.25,-1.54,-0.84,-0.41,-0.54,-1.03,-1.36,-1.63,-1.75,-1.80,-1.93,-2.11,-2.25,-2.47,-2.65,-2.87,-3.04,-3.26,-3.53,-3.88,-4.36,-5.04,-5.84,-6.55,-7.25,-7.84,-8.26,-8.62,-9,-9.50,-10,-11,-11,-12,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-9.77,-9.51,-9.26,-9.03,-8.78,-8.79,-8.38,-8.54,-8.92,-9.35,-9.40,-9.59,-9.85,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.28,-8.55,-7.89,-7.29,-6.77,-6.29,-5.88,-5.43,-5.01,-4.61,-4.18,-3.80,-3.48,-3.14,-2.86,-2.54,-2.25,-1.98,-1.67,-1.40,-1.15,-1,-0.85,-0.74,-0.63,-0.51,-0.42,-0.35,-0.25,-0.16,-0.12,-0.05,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.20,0.35,0.52,0.75,1,1.25,1.49,1.71,1.87,2.08,2.25,2.40,2.62,2.83,3.03,3.32,3.61,3.91,4.27,4.70,5.11,5.57,6.03,6.46,6.97,7.51,8.66,8.89,9.72,10.62,11.58,12.58,13.58,15.41,14.60,15.61,17.35,18.32,17.73,18.79,19.87,21,22,24,25,27,28,30,32,32,30,29,28,28,29,30,33,35,35,36,36,36,37,37,37,-5.64,-6.25,-6.87,-7.40,-7.89,-8.34,-8.66,-9,-9.23,-9.40,-9.50,-9.54,-9.54,-9.61,-9.72,-9.89,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-11,-13,-14,-14,-14,-14,-14,-13,-13,-14,-14,-14,-13,-14,-13,-13,-11,-9.41,-6.37,-4.37,-3.87,-3.24,-3,-3,-2.93,-2.49,-1.76,-0.74,-0.23,-0.17,-0.38,-0.65,-0.87,-1.02,-1.13,-1.25,-1.42,-1.67,-1.99,-2.28,-2.55,-2.80,-3.02,-3.26,-3.51,-3.84,-4.38,-4.98,-5.60,-6.15,-6.67,-7.11,-7.50,-7.88,-8.37,-9,-9.88,-10,-11,-11,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.88,-9.64,-9.41,-9.22,-9,-8.79,-8.59,-8.40,-8.38,-8.50,-8.63,-8.73,-8.79,-8.98,-9.17,-9.38,-9.40,-9.52,-9.75,-10,-10,-10,-9.98,-9.53,-9.02,-8.38,-7.76,-7.18,-6.64,-6.15,-5.73,-5.27,-4.88,-4.47,-4.03,-3.67,-3.37,-3.01,-2.74,-2.41,-2.13,-1.84,-1.53,-1.25,-1.02,-0.79,-0.63,-0.51,-0.47,-0.38,-0.30,-0.25,-0.18,-0.13,-0.10,-0.04,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.15,0.32,0.50,0.73,0.96,1.21,1.41,1.63,1.87,1.99,2.28,2.25,2.62,2.64,2.88,3.15,3.49,3.86,4.25,4.63,5.08,5.51,6.01,6.64,6.97,8.10,8.35,9.09,9.89,11.41,12.24,12.74,15.41,14.58,16.39,15.61,16.64,18.32,17.73,18.79,20.08,21,22,23,25,25,27,28,30,31,31,31,29,27,28,29,31,33,34,35,35,36,35,35,35,-5.66,-6.34,-6.90,-7.47,-7.98,-8.39,-8.75,-9.04,-9.30,-9.50,-9.60,-9.65,-9.64,-9.66,-9.76,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-11,-12,-12,-13,-14,-14,-14,-14,-14,-13,-12,-13,-14,-13,-13,-13,-12,-10,-7.65,-4.88,-4,-3.54,-3,-3,-3,-2.75,-2.24,-1.24,-0.38,0.22,0.37,0.34,0.15,0,-0.17,-0.29,-0.38,-0.63,-1,-1.38,-1.85,-2.25,-2.61,-2.86,-3.05,-3.26,-3.49,-3.86,-4.26,-4.75,-5.24,-5.65,-6.04,-6.48,-6.85,-7.27,-7.87,-8.72,-9.43,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.66,-9.47,-9.23,-8.98,-8.72,-8.54,-8.37,-8.13,-7.99,-7.90,-7.90,-7.90,-7.93,-8,-8.10,-8.15,-8.25,-8.35,-8.50,-8.72,-8.86,-8.84,-8.66,-8.38,-7.91,-7.42,-6.91,-6.41,-5.97,-5.50,-5.10,-4.65,-4.25,-3.84,-3.42,-3.11,-2.80,-2.51,-2.25,-1.99,-1.68,-1.39,-1.13,-0.88,-0.66,-0.50,-0.38,-0.28,-0.25,-0.22,-0.17,-0.13,-0.12,-0.10,-0.04,-0.03,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.14,0.27,0.47,0.65,0.88,1.13,1.37,1.64,1.73,2.11,2.04,2.51,2.33,2.84,3.07,3.32,3.37,3.95,4.24,4.61,5.01,5.50,6,6.48,7.02,7.64,8.79,9.61,10.47,11.35,11.45,12.64,15.40,14.58,16.39,17.37,16.64,17.70,19.25,18.79,19.87,21,22,24,25,26,26,27,29,30,31,31,29,27,26,28,31,33,33,34,35,35,35,34,33,-5.88,-6.39,-6.92,-7.50,-7.99,-8.39,-8.78,-9.10,-9.34,-9.50,-9.63,-9.65,-9.66,-9.63,-9.88,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-12,-13,-13,-13,-13,-14,-15,-14,-13,-13,-12,-12,-14,-14,-13,-12,-10,-9.16,-7.04,-4.77,-3.54,-3.03,-3,-3,-3,-2.67,-1.66,-0.72,0.12,0.50,0.64,0.73,0.72,0.57,0.46,0.38,0.37,0.25,-0.13,-0.67,-1.28,-1.88,-2.38,-2.73,-2.92,-3.12,-3.25,-3.50,-3.77,-4.13,-4.50,-4.85,-5.17,-5.61,-5.93,-6.36,-6.86,-7.63,-8.29,-8.89,-9.39,-9.75,-10,-10,-10,-10,-10,-9.92,-9.80,-9.67,-9.51,-9.34,-9.11,-8.80,-8.50,-8.25,-8.05,-7.85,-7.59,-7.38,-7.25,-7.13,-7.04,-7,-6.98,-6.98,-6.99,-7.04,-7.13,-7.24,-7.38,-7.50,-7.51,-7.41,-7.23,-6.87,-6.47,-6.03,-5.63,-5.22,-4.80,-4.40,-4,-3.55,-3.13,-2.76,-2.47,-2.18,-1.99,-1.75,-1.50,-1.25,-1,-0.75,-0.55,-0.40,-0.27,-0.23,-0.14,-0.12,-0.11,-0.11,-0.09,-0.05,-0.04,-0.03,-0.02,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.40,0.62,0.86,1.10,1.38,1.64,1.90,1.82,2.34,2.13,2.72,2.82,2.65,2.92,3.57,3.61,4.02,4.48,4.98,5.41,5.95,6.59,7.25,7.96,8.67,9.46,10.25,11.09,11.13,12.22,14.36,14.76,15.61,17.37,18.33,19.28,18.75,20.16,21.10,22,23,25,27,28,27,27,28,29,29,28,28,26,25,28,31,33,33,33,34,35,34,33,32,-6.02,-6.54,-7,-7.43,-7.91,-8.36,-8.72,-9.01,-9.25,-9.43,-9.53,-9.63,-9.62,-9.54,-9.80,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-12,-13,-13,-13,-13,-14,-14,-14,-13,-12,-11,-12,-13,-13,-13,-11,-9.88,-8.25,-6.43,-4.52,-3.24,-3,-3,-3,-3,-2.87,-1.36,0.11,0.07,0.15,0.39,0.62,0.83,0.86,0.84,0.84,0.82,0.72,0.47,0.02,-0.66,-1.47,-2.15,-2.66,-2.88,-3,-3.13,-3.26,-3.42,-3.65,-3.93,-4.24,-4.50,-4.88,-5.23,-5.59,-6.02,-6.66,-7.25,-7.76,-8.24,-8.60,-8.87,-9.02,-9.14,-9.23,-9.25,-9.25,-9.13,-9.01,-8.87,-8.63,-8.38,-8.12,-7.84,-7.55,-7.30,-7.09,-6.87,-6.64,-6.48,-6.29,-6.14,-6.02,-5.92,-5.88,-5.85,-5.92,-6,-6.04,-6.13,-6.26,-6.30,-6.25,-6.09,-5.79,-5.49,-5.13,-4.75,-4.40,-4.05,-3.68,-3.28,-2.87,-2.40,-2.11,-1.78,-1.54,-1.39,-1.25,-1.04,-0.88,-0.65,-0.49,-0.29,-0.23,-0.14,-0.11,-0.05,-0.04,-0.03,-0.02,-0.02,-0.02,-0.02,-0.01,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.24,0.37,0.59,0.82,1,1.38,1.39,1.91,1.75,2.34,2.52,2.12,2.78,3.13,3.25,3.52,3.84,4.16,4.58,4.85,5.35,5.85,6.33,7.10,7.62,8.48,9.16,9.92,10.65,10.70,11.58,12.75,15.37,16.37,18.35,17.70,19.26,18.78,19.85,21.08,22,23,25,27,28,28,28,28,27,27,26,26,25,25,27,31,33,33,33,33,34,33,32,31,-6.14,-6.67,-7.13,-7.53,-7.89,-8.23,-8.55,-8.88,-9.13,-9.30,-9.39,-9.49,-9.48,-9.39,-9.68,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-14,-13,-13,-13,-13,-12,-12,-11,-11,-12,-13,-14,-14,-14,-13,-13,-13,-12,-11,-11,-12,-13,-13,-13,-11,-10,-8.25,-6.60,-4.47,-3.38,-3,-3,-3,-3,-2.93,-1.38,0.24,-0.38,-0.26,0.01,0.40,0.74,0.86,0.90,0.98,1,0.82,0.49,0.11,0.07,-1.28,-2.01,-2.55,-2.87,-2.99,-3.04,-3.12,-3.24,-3.38,-3.55,-3.77,-4.01,-4.35,-4.64,-5,-5.42,-5.90,-6.38,-6.84,-7.22,-7.52,-7.78,-8,-8.14,-8.26,-8.36,-8.38,-8.30,-8.24,-8.10,-7.88,-7.63,-7.37,-7.05,-6.78,-6.51,-6.28,-6.05,-5.86,-5.63,-5.43,-5.26,-5.12,-4.99,-4.87,-4.79,-4.92,-4.99,-5.01,-5.10,-5.18,-5.25,-5.15,-5,-4.77,-4.50,-4.17,-3.88,-3.59,-3.26,-2.93,-2.59,-2.15,-1.75,-1.43,-1.17,-0.98,-0.79,-0.76,-0.64,-0.52,-0.39,-0.26,-0.15,-0.11,-0.04,-0.04,-0.02,-0.01,-0.01,-0.01,-0.01,-0.01,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.23,0.37,0.57,0.77,0.96,1.14,1.67,1.91,2.13,1.72,2.51,2.02,2.76,2.47,2.73,3.49,3.37,4.20,4.52,4.65,5.24,5.70,6.24,6.86,7.50,8.13,8.79,8.99,9.83,10.14,10.95,11.89,14.26,16.33,17.29,19.26,19.23,20.16,19.88,20.97,22,24,25,26,27,28,28,28,26,25,25,25,25,25,27,29,33,34,32,31,31,30,30,30,-6.23,-6.73,-7.18,-7.60,-7.93,-8.25,-8.51,-8.75,-8.90,-9.09,-9.17,-9.26,-9.25,-9.26,-9.50,-9.75,-9.91,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-12,-13,-14,-14,-14,-14,-13,-12,-12,-12,-11,-12,-13,-14,-14,-12,-10,-8.80,-7.01,-5.02,-3.38,-3,-3,-3,-3,-2.88,-1.23,-1.34,-1.04,-0.97,-0.38,0.12,0.45,0.62,0.74,0.87,0.90,0.74,0.34,-0.23,-0.85,-1.48,-2.15,-2.62,-2.88,-3,-3.02,-3.04,-3.12,-3.17,-3.30,-3.49,-3.64,-3.98,-4.25,-4.52,-4.88,-5.25,-5.64,-6,-6.37,-6.64,-6.88,-7.09,-7.24,-7.37,-7.42,-7.47,-7.42,-7.38,-7.25,-7.04,-6.80,-6.53,-6.25,-6,-5.74,-5.50,-5.26,-5.05,-4.87,-4.65,-4.49,-4.30,-4.15,-4.03,-3.99,-4.09,-4.12,-4.14,-4.22,-4.27,-4.28,-4.22,-4.02,-3.80,-3.53,-3.25,-3,-2.74,-2.49,-2.22,-1.88,-1.52,-1.15,-0.88,-0.67,-0.51,-0.39,-0.34,-0.34,-0.26,-0.22,-0.13,-0.10,-0.04,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.22,0.36,0.52,0.75,0.91,1.41,1.70,1.48,2.14,2.34,1.95,2.12,2.72,2.92,3.15,3.41,3.25,4,4.12,4.49,5.03,5.50,5.99,6.46,6.95,7.76,8,9,9.49,9.63,10.33,11.26,12.32,13.92,15.37,16.63,19.04,20.12,21.04,21,22,24,25,27,28,28,28,27,25,24,24,24,24,25,26,28,32,33,31,28,29,28,28,29,-6.23,-6.75,-7.18,-7.62,-7.92,-8.25,-8.50,-8.74,-8.89,-9,-9.11,-9.14,-9.13,-9.16,-9.35,-9.63,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-12,-12,-13,-14,-14,-14,-13,-12,-12,-12,-11,-11,-14,-15,-14,-13,-11,-9.24,-7.40,-5.48,-3.49,-3,-3,-3,-3,-2.85,-2.77,-2.13,-1.87,-1.39,-0.72,-0.17,0.11,0.13,0.32,0.53,0.72,0.62,0.23,-0.50,-1.65,-2,-2.40,-2.74,-2.90,-3,-3.01,-3.02,-3.02,-3.09,-3.13,-3.25,-3.47,-3.63,-3.87,-4.10,-4.39,-4.68,-5,-5.30,-5.60,-5.85,-6.03,-6.23,-6.37,-6.49,-6.53,-6.55,-6.53,-6.48,-6.36,-6.16,-5.93,-5.68,-5.42,-5.22,-4.99,-4.75,-4.55,-4.38,-4.17,-4,-3.85,-3.65,-3.50,-3.38,-3.30,-3.36,-3.37,-3.38,-3.42,-3.49,-3.47,-3.36,-3.14,-2.91,-2.65,-2.39,-2.15,-1.93,-1.75,-1.51,-1.27,-1,-0.73,-0.50,-0.37,-0.25,-0.15,-0.11,-0.09,-0.12,-0.10,-0.04,-0.03,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.22,0.36,0.52,0.75,0.88,1.42,1.26,1.92,1.60,2.33,2.49,2.26,2.66,2.27,2.51,2.79,3.12,3.89,4.23,4.62,4.95,5.25,5.73,6.21,6.77,7.35,7.63,8.04,8.96,9.13,9.76,10.58,11.62,12.85,14.53,15.29,16.32,17.83,18.98,20,21,24,26,28,29,30,28,26,23,24,24,23,23,24,25,26,30,30,28,27,27,28,27,28,-6.14,-6.66,-7.13,-7.53,-7.88,-8.18,-8.42,-8.66,-8.84,-8.97,-9.01,-9.05,-9.01,-9.12,-9.26,-9.49,-9.86,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-12,-13,-14,-14,-14,-14,-13,-12,-12,-11,-11,-13,-14,-14,-14,-12,-10,-8.12,-5.35,-3.63,-3.02,-3,-3,-3,-2.99,-2.88,-2.74,-2.66,-1.88,-1.13,0.09,-0.50,-0.51,-0.35,0.12,0.48,0.62,0.36,-0.63,-1.66,-2.29,-2.63,-2.87,-2.98,-3,-3.01,-3.01,-3.01,-3.02,-3.03,-3.14,-3.25,-3.38,-3.52,-3.75,-3.93,-4.15,-4.41,-4.65,-4.88,-5.11,-5.27,-5.41,-5.55,-5.64,-5.68,-5.68,-5.64,-5.59,-5.47,-5.28,-5.11,-4.88,-4.65,-4.48,-4.27,-4.12,-3.93,-3.79,-3.64,-3.50,-3.35,-3.13,-2.97,-2.79,-2.68,-2.65,-2.65,-2.66,-2.72,-2.73,-2.66,-2.55,-2.36,-2.13,-1.88,-1.64,-1.43,-1.25,-1.12,-0.97,-0.78,-0.61,-0.39,-0.25,-0.15,-0.11,-0.04,-0.01,0,0,-0.02,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.22,0.36,0.52,0.75,0.87,1.46,1.25,1.92,2.12,1.71,1.85,2.46,2,2.20,3.02,3.26,3.51,3.34,4.09,4.09,4.51,5.01,5.45,5.87,6.36,6.84,7.38,7.90,8.42,8.66,9.26,10,10.88,12.17,13.26,14.10,14.64,15.50,16.27,17,20,23,25,27,30,30,28,24,22,23,24,23,23,23,24,25,27,27,26,26,25,26,25,25,-6.12,-6.59,-7.02,-7.43,-7.79,-8.11,-8.38,-8.54,-8.72,-8.87,-8.91,-8.97,-8.97,-9,-9.14,-9.34,-9.68,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-12,-14,-14,-15,-14,-13,-13,-12,-11,-11,-13,-14,-15,-15,-13,-11,-9.09,-6.25,-3.87,-3.03,-3,-3.01,-3.01,-3,-3,-2.97,-2.79,-2.63,-1.40,-1.30,-1.24,-1.49,-0.92,-0.47,0.45,0.63,0.50,-0.63,-1.67,-2.47,-2.76,-2.92,-3,-3,-3,-3,-3,-3,-3,-3.02,-3.09,-3.14,-3.25,-3.36,-3.50,-3.66,-3.88,-4.09,-4.25,-4.43,-4.61,-4.73,-4.80,-4.88,-4.88,-4.88,-4.79,-4.73,-4.61,-4.43,-4.27,-4.12,-3.92,-3.78,-3.65,-3.52,-3.41,-3.30,-3.23,-3.11,-2.91,-2.68,-2.42,-2.18,-2.02,-1.98,-1.93,-1.93,-1.98,-1.99,-1.93,-1.85,-1.63,-1.47,-1.25,-1.03,-0.88,-0.75,-0.63,-0.52,-0.42,-0.34,-0.23,-0.13,-0.03,-0.03,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.23,0.37,0.52,0.67,0.87,1.45,1.23,1.95,2.12,2.27,2.25,1.77,2.58,2.12,2.36,3.17,3.41,3.66,3.52,4.21,4.29,4.76,5.14,5.58,6,6.46,6.87,7.28,7.90,8.24,8.75,9.38,10.14,11,11.89,12.61,13.20,14.16,15.51,17.23,19,21,23,25,27,28,25,22,21,22,23,22,22,22,23,24,26,26,25,24,24,25,24,23,-6.13,-6.50,-6.88,-7.28,-7.65,-7.93,-8.22,-8.40,-8.55,-8.68,-8.75,-8.78,-8.78,-8.86,-9,-9.26,-9.51,-9.79,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-13,-14,-14,-14,-14,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-12,-13,-14,-14,-14,-14,-13,-13,-12,-12,-12,-14,-14,-14,-13,-11,-9.50,-7.18,-4.73,-3.03,-3,-3.04,-3.03,-3.02,-3.02,-3,-2.97,-2.68,-2.48,-2.10,-2.02,-1.87,-1.47,-0.55,0.45,0.66,0.52,-0.63,-1.68,-2.50,-2.84,-2.98,-3,-3,-3,-2.99,-2.97,-2.92,-2.88,-2.85,-2.86,-2.85,-2.86,-2.90,-3,-3.13,-3.30,-3.50,-3.67,-3.86,-3.99,-4.05,-4.13,-4.14,-4.13,-4.10,-4,-3.88,-3.75,-3.63,-3.50,-3.38,-3.25,-3.13,-3.04,-2.99,-2.90,-2.87,-2.78,-2.68,-2.50,-2.25,-1.88,-1.54,-1.30,-1.26,-1.25,-1.25,-1.25,-1.27,-1.26,-1.17,-1,-0.88,-0.75,-0.61,-0.49,-0.38,-0.30,-0.25,-0.23,-0.15,-0.11,-0.04,-0.01,0,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.24,0.37,0.53,0.67,1.15,1.42,1.22,1.91,2.11,1.64,1.61,1.75,1.89,2.09,2.28,2.52,2.78,3.08,3.38,3.73,4.27,4.52,4.87,5.25,5.64,6.08,6.50,6.95,7.37,7.85,8.34,8.87,9.49,10.13,10.78,11.37,11.99,13.21,15.26,17.51,17.13,19,20,22,23,23,21,20,20,21,21,21,21,21,22,24,25,24,24,24,23,24,23,22,-6.13,-6.50,-6.79,-7.05,-7.41,-7.75,-8,-8.22,-8.38,-8.50,-8.55,-8.60,-8.54,-8.61,-8.84,-9.13,-9.27,-9.50,-9.66,-9.75,-9.84,-10,-10,-11,-11,-12,-12,-12,-13,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-12,-14,-14,-14,-14,-14,-13,-13,-13,-13,-14,-14,-14,-13,-11,-9.88,-7.89,-5.75,-4,-3.22,-3.13,-3.15,-3.10,-3.10,-3.05,-3.01,-2.97,-2.80,-2.68,-2.54,-2.38,-1.85,-1,0.39,0.50,0.60,-0.89,-1.80,-2.54,-2.87,-3,-3,-3,-2.93,-2.88,-2.76,-2.68,-2.55,-2.48,-2.41,-2.37,-2.29,-2.36,-2.39,-2.54,-2.75,-2.92,-3.13,-3.26,-3.38,-3.48,-3.50,-3.49,-3.41,-3.35,-3.23,-3.10,-2.97,-2.84,-2.73,-2.63,-2.54,-2.49,-2.40,-2.38,-2.36,-2.34,-2.27,-2.23,-2.03,-1.74,-1.34,-0.91,-0.62,-0.63,-0.63,-0.63,-0.63,-0.63,-0.67,-0.64,-0.53,-0.48,-0.38,-0.29,-0.24,-0.16,-0.13,-0.13,-0.11,-0.09,-0.04,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.24,0.37,0.57,0.63,1.15,1.02,1.65,1.88,2.08,2.24,2.23,1.73,1.87,2.67,2.25,3.04,3.25,2.99,3.25,3.57,3.90,4.33,4.62,4.98,5.34,5.72,6.11,6.50,6.91,7.37,7.78,8.25,8.75,9.28,9.84,10.28,10.88,12.22,13.58,14.62,15.32,16,18,19,20,19,19,18,19,20,21,21,21,21,22,23,24,23,23,23,22,22,22,22,-6.10,-6.43,-6.77,-7.04,-7.25,-7.48,-7.75,-7.97,-8.13,-8.25,-8.34,-8.35,-8.34,-8.29,-8.63,-8.88,-9.05,-9.15,-9.28,-9.38,-9.64,-10,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-12,-13,-14,-14,-14,-14,-14,-13,-13,-13,-15,-15,-14,-12,-11,-10,-8.49,-7.23,-5.97,-4.75,-3.88,-3.25,-3.36,-3.25,-3.23,-3.18,-3.15,-3.12,-3.02,-2.98,-2.77,-2.38,-1.63,-1.16,-0.88,-1.01,-1.26,-2.13,-2.73,-2.91,-3,-3,-3,-2.89,-2.67,-2.40,-2.17,-1.91,-1.75,-1.68,-1.53,-1.50,-1.59,-1.66,-1.88,-2.10,-2.30,-2.52,-2.73,-2.85,-2.88,-2.88,-2.84,-2.75,-2.63,-2.49,-2.30,-2.15,-2.02,-1.92,-1.87,-1.80,-1.76,-1.74,-1.72,-1.68,-1.66,-1.64,-1.60,-1.42,-1.14,-0.77,-0.38,-0.11,-0.13,-0.15,-0.22,-0.23,-0.24,-0.25,-0.25,-0.25,-0.14,-0.14,-0.13,-0.11,-0.09,-0.04,-0.04,-0.04,-0.04,-0.03,-0.02,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.38,0.58,0.65,1.12,1.02,1.62,1.87,2.07,1.65,1.62,1.75,1.89,2.09,2.26,3.01,2.70,3.36,3.17,3.46,3.77,4.12,4.39,4.72,5.01,5.37,5.75,6.12,6.51,6.91,7.34,7.75,8.16,8.62,9.11,9.58,10.12,11.12,12.20,12.73,13.45,15.01,17,17,17,17,17,18,19,19,20,20,21,21,21,22,23,22,22,22,21,21,21,22,-6,-6.38,-6.66,-6.98,-7.23,-7.40,-7.59,-7.72,-7.88,-8.02,-8.12,-8.13,-8.13,-8.02,-8.37,-8.60,-8.75,-8.90,-9,-9.38,-9.88,-10,-11,-11,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-12,-11,-11,-12,-13,-13,-13,-13,-13,-13,-13,-14,-15,-15,-13,-12,-11,-10,-9.43,-9,-7.97,-6.75,-6,-4.88,-3.77,-3.68,-3.60,-3.59,-3.50,-3.48,-3.40,-3.36,-3.25,-3.09,-2.84,-2.53,-2.38,-2.26,-2.29,-2.77,-2.88,-2.99,-3,-3,-2.99,-2.80,-2.43,-1.90,-1.42,-1,-0.74,-0.53,-0.39,-0.42,-0.62,-0.85,-1.12,-1.38,-1.65,-1.91,-2.13,-2.26,-2.30,-2.27,-2.22,-2.11,-1.93,-1.76,-1.60,-1.39,-1.25,-1.15,-1.11,-1.04,-1.02,-1,-1,-0.98,-0.97,-0.92,-0.88,-0.75,-0.54,-0.28,-0.04,0.12,0.14,0.09,0,-0.01,-0.02,-0.03,-0.04,-0.09,-0.03,-0.02,-0.03,-0.02,-0.03,-0.03,-0.03,-0.03,-0.03,-0.02,-0.02,-0.02,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.38,0.58,0.70,1.10,1.04,1.61,1.25,2.04,1.54,1.70,1.84,1.99,2.14,2.32,3,3.14,2.89,3.13,3.37,3.67,3.98,4.23,4.49,4.76,5.09,5.40,5.77,6.15,6.58,6.98,7.37,7.77,8.22,8.63,9.15,9.65,10.47,11.34,12.21,13.16,14.02,16,17,16,16,17,18,18,19,19,20,20,20,21,22,22,21,21,22,21,20,20,20,-5.88,-6.25,-6.55,-6.86,-7.11,-7.38,-7.63,-7.80,-7.99,-8.09,-8.13,-8.13,-8.13,-8.09,-8.34,-8.63,-8.79,-8.88,-9.13,-9.59,-10,-10,-11,-12,-12,-13,-13,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-13,-12,-12,-11,-11,-11,-12,-12,-13,-13,-12,-12,-12,-13,-14,-14,-13,-12,-11,-11,-10,-10,-9.74,-9.38,-8.48,-7,-5.78,-4.73,-4.63,-4.24,-4.23,-4.12,-4.01,-3.97,-4,-4.12,-4.13,-4.09,-3.88,-3.61,-3.35,-3.14,-3.04,-3.02,-3.02,-3.01,-2.99,-2.78,-2.23,-1.39,-0.40,0.03,0.50,0.86,0.99,0.87,0.50,0.02,-0.37,-0.66,-1,-1.30,-1.59,-1.73,-1.75,-1.72,-1.62,-1.49,-1.29,-1.12,-0.89,-0.73,-0.55,-0.47,-0.38,-0.35,-0.36,-0.28,-0.26,-0.25,-0.25,-0.25,-0.18,-0.13,0,0.11,0.15,0.20,0.15,0.11,0.07,0.01,0,0,0,0,0,0,-0.01,-0.02,-0.03,-0.03,-0.03,-0.03,-0.03,-0.03,-0.03,-0.02,-0.02,-0.02,-0.01,-0.01,-0.01,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.13,0.25,0.38,0.58,0.73,1.04,1.04,1.58,1.58,1.48,2.13,1.82,1.96,2.12,2.28,2.42,3.02,2.74,2.90,3.10,3.50,3.61,3.85,4.08,4.28,4.57,4.84,5.13,5.50,5.87,6.27,6.72,7.13,7.57,8,8.45,8.91,9.45,10.12,11.08,12.01,13,13.99,15,16,15,16,17,17,17,18,19,19,20,20,21,22,21,21,20,21,20,20,19,19,-5.74,-6.11,-6.39,-6.79,-7.14,-7.50,-7.77,-7.98,-8.13,-8.25,-8.25,-8.25,-8.16,-8.14,-8.35,-8.61,-8.76,-9.11,-9.60,-9.98,-10,-10,-11,-12,-12,-13,-13,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-12,-12,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-9.23,-7.80,-6.76,-6.02,-5.59,-5.24,-5.01,-4.90,-4.93,-5.13,-5.40,-5.65,-5.75,-5.50,-5,-4.35,-3.38,-3.22,-3.11,-3.03,-3.01,-2.98,-2.79,-2.15,-1.05,0.15,1.01,1.65,2.37,2.58,2.39,1.52,0.76,0.27,-0.09,-0.40,-0.78,-1.10,-1.25,-1.25,-1.17,-1.09,-0.90,-0.74,-0.51,-0.30,-0.13,0.01,0.12,0.21,0.25,0.23,0.25,0.32,0.35,0.36,0.36,0.37,0.39,0.40,0.37,0.27,0.22,0.12,0.08,0.02,0,0,0,0,0,-0.01,-0.01,-0.02,-0.02,-0.02,-0.03,-0.03,-0.03,-0.03,-0.03,-0.03,-0.03,-0.02,-0.02,-0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.13,0.25,0.38,0.57,0.75,1,1.03,1.21,1.73,1.99,2.23,2,2.65,2.35,2.49,2.61,2.72,2.82,2.96,3.12,3.32,3.53,3.75,3.96,4.14,4.37,4.62,4.91,5.26,5.64,6.10,6.52,7,7.46,7.87,8.35,8.83,9.36,10.10,10.91,11.87,12.77,13.95,14,14,15,15,15,15,16,17,18,20,19,19,20,21,20,20,19,19,19,19,19,18,-5.55,-5.93,-6.50,-6.97,-7.37,-7.67,-8,-8.18,-8.38,-8.42,-8.50,-8.47,-8.38,-8.34,-8.35,-8.51,-8.86,-9.38,-9.92,-10,-10,-11,-11,-11,-12,-13,-13,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-11,-12,-12,-12,-11,-9.52,-8.39,-7.53,-6.88,-6.38,-6.04,-5.93,-6.10,-6.47,-6.88,-7.25,-7.51,-7.30,-6.42,-5.38,-4.36,-3.26,-3.14,-3.09,-3.01,-2.93,-2.79,-2.10,-0.88,0.41,1.51,2.48,3.23,3.52,3.62,2.07,1.25,0.75,0.37,0,-0.39,-0.75,-0.92,-0.89,-0.78,-0.63,-0.40,-0.23,-0.01,0.16,0.36,0.50,0.59,0.62,0.64,0.66,0.63,0.70,0.72,0.73,0.73,0.74,0.73,0.65,0.50,0.35,0.20,0.09,0.01,0,0,0,0,0,0,-0.01,-0.01,-0.02,-0.02,-0.03,-0.03,-0.04,-0.04,-0.04,-0.03,-0.03,-0.02,-0.01,0,0.01,0.02,0.03,0.07,0.03,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.14,0.25,0.38,0.57,0.75,0.96,1.11,1.47,1.49,1.75,2.37,2.25,2.99,3.15,2.87,3.29,2.90,3.22,3.02,3.16,3.35,3.50,3.66,3.87,4.07,4.25,4.50,4.75,5.11,5.50,5.91,6.38,6.87,7.36,7.82,8.24,8.72,9.28,9.98,10.62,11.39,12.16,12.72,13.09,13.41,13.87,14.51,14.34,15.11,16,17,18,19,18,19,19,20,19,19,18,18,18,19,18,18,-5.73,-6.16,-6.63,-7.12,-7.50,-7.87,-8.13,-8.37,-8.50,-8.63,-8.63,-8.63,-8.53,-8.52,-8.51,-8.61,-9.09,-9.61,-10,-10,-11,-11,-11,-11,-12,-13,-13,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-14,-13,-12,-12,-11,-11,-10,-10,-10,-11,-11,-12,-12,-13,-13,-12,-11,-11,-12,-13,-13,-12,-13,-13,-13,-12,-10,-9.61,-8.76,-8,-7.39,-7,-6.89,-7.13,-7.64,-8.36,-8.65,-8.85,-8.65,-7.84,-6.39,-5.09,-3.68,-3.25,-3.09,-3.01,-2.91,-2.64,-1.99,-0.66,0.75,2,2.99,3.61,3.49,2.75,2.08,1.41,1.01,0.70,0.33,-0.13,-0.66,-0.89,-0.86,-0.50,-0.24,0,0.23,0.40,0.60,0.75,0.87,0.91,0.90,0.87,0.87,0.87,0.87,0.87,0.88,0.87,0.87,0.87,0.77,0.59,0.35,0.14,0.03,0,0,0,0,0,0,0,-0.01,-0.02,-0.02,-0.03,-0.03,-0.03,-0.03,-0.03,-0.03,-0.03,-0.02,0,0,0.03,0.09,0.12,0.12,0.13,0.12,0.12,0.09,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.14,0.25,0.38,0.57,0.75,0.96,1.16,1.48,1.63,2.14,2.41,2.96,3.25,3.45,3.52,3.50,3.13,3.12,3.14,3.24,3.34,3.47,3.62,3.78,3.99,4.15,4.37,4.62,4.97,5.35,5.76,6.25,6.75,7.24,7.65,8.09,8.50,9.01,9.60,10.16,10.75,11.34,11.82,12.25,12.61,13.03,13.37,13.89,14.65,15.75,16.97,18,18,18,18,19,19,18,18,18,17,18,18,17,17,-6,-6.42,-6.85,-7.17,-7.59,-7.92,-8.25,-8.50,-8.72,-8.79,-8.86,-8.79,-8.68,-8.62,-8.63,-8.76,-9.38,-9.97,-10,-11,-11,-11,-11,-12,-12,-12,-13,-14,-14,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-14,-14,-12,-12,-11,-11,-10,-10,-10,-10,-11,-11,-12,-13,-12,-11,-10,-10,-11,-13,-13,-13,-13,-13,-13,-12,-11,-10,-9.61,-8.88,-8.17,-7.73,-7.63,-7.92,-8.52,-9.27,-9.63,-9.63,-9.47,-8.63,-7.25,-5.61,-4.27,-3.30,-3.09,-3.01,-2.88,-2.48,-1.55,-0.29,1.23,2.60,3.62,4.15,3.21,2.35,1.62,1.48,1.24,0.98,0.62,0.12,-0.47,-1.79,-0.67,-0.26,0.10,0.37,0.62,0.84,1.01,1.21,1.32,1.28,1.16,1.03,0.98,0.96,0.95,0.96,0.97,0.97,0.97,0.95,0.87,0.61,0.33,0.08,0,0,0,0,0,0,0,0,0,-0.01,-0.02,-0.02,-0.03,-0.03,-0.03,-0.03,-0.02,-0.01,0,0.01,0.08,0.12,0.16,0.23,0.25,0.25,0.25,0.23,0.16,0.12,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.14,0.25,0.38,0.57,0.75,0.96,1.20,1.48,1.78,2.26,2.73,3.17,3.52,3.75,3.79,3.71,3.53,3.37,3.27,3.26,3.35,3.47,3.62,3.75,3.91,4.11,4.28,4.52,4.84,5.21,5.62,6.08,6.53,7,7.41,7.82,8.23,8.65,9.14,9.62,10.12,10.58,11.01,11.57,12.02,12.37,12.62,13.15,14.13,15.46,16.64,17.01,17,17,18,18,18,17,17,17,17,17,17,17,16,-6.18,-6.63,-7.04,-7.50,-7.86,-8.15,-8.48,-8.75,-8.88,-9.03,-9.05,-9.01,-8.92,-8.85,-8.75,-9.09,-9.51,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-15,-16,-16,-16,-17,-17,-17,-17,-18,-17,-17,-17,-16,-15,-15,-14,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-11,-12,-11,-11,-10,-10,-11,-12,-12,-13,-13,-13,-12,-11,-11,-10,-10,-9.52,-8.80,-8.15,-8,-8.50,-9.13,-9.66,-9.93,-9.89,-9.72,-8.88,-7.41,-5.77,-4.40,-3.35,-3.09,-3.01,-2.97,-2.63,-1.25,0.62,1.35,3.63,4.62,4.59,2.76,1.50,1.52,1.50,1.49,1.25,0.90,0.47,-0.09,-0.29,-0.28,-0.05,0.45,0.75,1.07,1.33,1.59,1.84,1.97,1.87,1.59,1.23,1.08,0.99,0.98,0.98,0.98,0.98,0.99,0.99,0.96,0.62,0.32,0,0,0,0,0,0.02,0.07,0.09,0.07,0.02,0,-0.01,-0.02,-0.02,-0.03,-0.03,-0.02,-0.01,0,0.02,0.09,0.13,0.22,0.25,0.33,0.37,0.37,0.37,0.34,0.26,0.23,0.14,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.14,0.25,0.38,0.53,0.74,0.96,1.21,1.50,1.87,2.33,2.83,3.34,3.76,4.01,4.02,3.87,3.65,3.50,3.37,3.36,3.38,3.49,3.62,3.75,3.89,4.07,4.24,4.46,4.73,5.03,5.45,5.86,6.27,6.71,7.11,7.49,7.87,8.27,8.74,9.13,9.53,9.97,10.47,11.12,11.62,11.98,12.22,12.62,13.74,15.33,16.74,17.71,17,17,17,17,17,17,17,17,16,16,17,16,16,-6.36,-6.90,-7.40,-7.85,-8.24,-8.50,-8.76,-8.91,-9.03,-9.16,-9.18,-9.15,-9.09,-8.92,-9.05,-9.47,-9.98,-10,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-14,-15,-15,-16,-16,-17,-17,-17,-18,-18,-17,-17,-17,-16,-16,-15,-14,-13,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-11,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.36,-8.68,-8.23,-8.88,-9.68,-10,-10,-10,-9.42,-8.50,-7,-5.51,-4.22,-3.38,-3.10,-3.01,-2.97,-2.63,-1.04,0.62,2.63,3.65,3.70,2.91,2.25,1.39,1.41,1.88,1.87,1.62,1.22,0.83,0.51,0.38,0.40,0.60,0.87,1.22,1.57,1.91,2.33,2.73,2.89,2.77,2.27,1.62,1.16,1.07,1.01,1,0.99,1,1,1,1,1,0,0,0,0.02,0.15,0.33,0.35,0.28,0.25,0.15,0.11,0.07,0,0,-0.01,-0.02,-0.02,-0.01,0,0.01,0.09,0.12,0.22,0.27,0.37,0.41,0.47,0.49,0.48,0.45,0.37,0.33,0.25,0.20,0.12,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.13,0.25,0.37,0.53,0.74,0.95,1.21,1.50,1.90,2.37,2.91,3.50,4,4.25,4.25,4.03,3.83,3.62,3.50,3.46,3.48,3.57,3.65,3.78,3.91,4.07,4.21,4.37,4.62,4.89,5.25,5.62,6,6.38,6.75,7.13,7.51,7.91,8.36,8.75,9.12,9.60,10.21,10.86,11.39,11.71,12,12.45,13.63,15.12,17.14,17.47,16.84,16,17,17,16,16,16,16,15,16,16,16,16,-6.64,-7.22,-7.72,-8.13,-8.50,-8.79,-9.02,-9.22,-9.30,-9.40,-9.38,-9.37,-9.25,-9.10,-9.39,-9.88,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-14,-13,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.67,-9.43,-9.75,-10,-11,-11,-10,-9.26,-7.86,-6.36,-5,-3.65,-3.28,-3.09,-3.01,-2.97,-2.65,-1.25,0.63,1.35,2.65,2.25,1.25,1.90,2,2.25,2.70,2.62,1.91,1.50,1.13,0.96,0.95,1.03,1.22,1.40,1.73,2.11,2.60,3.12,3.73,4.45,3.83,3.47,2.49,1.40,1.32,1.16,1.01,1.01,1.02,1.02,1.02,1,0.96,0.02,0,0.09,0.21,1.63,0.86,0.72,0.59,0.47,0.34,0.24,0.13,0.09,0.02,0,0,0,0,0,0.07,0.12,0.21,0.27,0.37,0.47,0.51,0.58,0.60,0.59,0.53,0.50,0.41,0.36,0.26,0.22,0.13,0.11,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.13,0.25,0.37,0.53,0.73,0.95,1.20,1.50,1.89,2.37,2.90,3.50,3.98,4.25,4.25,4.09,3.88,3.74,3.62,3.61,3.62,3.71,3.77,3.88,4,4.11,4.22,4.36,4.52,4.76,5.08,5.39,5.75,6.11,6.47,6.84,7.23,7.62,8.08,8.46,8.87,9.37,10,10.62,11.15,11.37,11.75,12.45,13.49,14.76,15.70,16.07,15.99,16,16,16,15,15,15,15,15,15,15,15,15,-6.88,-7.41,-7.91,-8.35,-8.73,-9,-9.25,-9.40,-9.53,-9.62,-9.62,-9.55,-9.42,-9.28,-9.67,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-14,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-16,-15,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-12,-12,-11,-9.27,-7.14,-5.61,-4.09,-3.41,-3.16,-3.05,-3,-2.97,-2.65,-1.37,-0.67,0.65,1.16,1.25,1.37,1.87,2.50,2.98,3.33,2.73,2.24,1.70,1.33,1.13,1.21,1.60,1.74,2,2.26,2.75,2.86,3.87,4.95,5,4,5,3.98,2,2.02,2.03,2.02,2,2,1.89,1.09,1.09,0.89,0.09,0.11,0.24,0.71,1.11,1.21,1.03,0.87,0.71,0.52,0.38,0.25,0.15,0.12,0.08,0.02,0,0.01,0.07,0.11,0.15,0.25,0.36,0.46,0.53,0.62,0.65,0.70,0.70,0.64,0.61,0.52,0.47,0.37,0.28,0.24,0.15,0.12,0.08,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.13,0.25,0.37,0.52,0.73,0.91,1.15,1.48,1.86,2.32,2.82,3.33,3.75,4,4.11,4.08,3.84,3.75,3.71,3.73,3.77,3.87,3.96,4.09,4.16,4.24,4.28,4.37,4.50,4.70,4.91,5.22,5.50,5.85,6.16,6.53,6.95,7.37,7.82,8.22,8.64,9.21,9.82,10.36,10.73,11.02,11.49,12.25,13.16,14,14.62,15,15.23,15,15,15,15,15,15,15,14,14,14,14,14,-7,-7.59,-8.04,-8.50,-8.87,-9.13,-9.38,-9.53,-9.65,-9.75,-9.74,-9.68,-9.60,-9.52,-9.88,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-11,-9.52,-7.01,-4.63,-3.43,-3.30,-3.13,-3.01,-2.98,-2.88,-2.72,-1.75,-0.72,0.72,0.26,0.50,1.23,1.98,3.14,3.37,3.08,2.65,2.33,1.84,1.28,1.09,1.12,1.40,2.36,2.50,2.70,2.88,2.07,2.01,3,3,3.98,3.97,3.96,3.91,3.90,3.09,3.10,3.11,3.11,3.11,3.11,2.12,1.12,0.87,0.24,0.37,0.76,1.11,1.27,1.26,1.10,0.95,0.75,0.60,0.46,0.33,0.24,0.13,0.11,0.08,0.09,0.11,0.13,0.23,0.33,0.40,0.51,0.62,0.71,0.75,0.76,0.76,0.75,0.72,0.63,0.58,0.49,0.39,0.33,0.25,0.20,0.12,0.09,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.13,0.25,0.37,0.52,0.72,0.89,1.13,1.41,1.76,2.20,2.62,3.08,3.46,3.77,3.98,4.01,3.82,3.85,3.92,4.02,4.10,4.20,4.25,4.36,4.42,4.50,4.50,4.50,4.51,4.63,4.84,5.08,5.34,5.62,5.91,6.25,6.63,7.10,7.51,7.96,8.39,8.95,9.49,9.91,10.25,10.75,11.36,12.03,12.75,13.37,13.87,14.24,14.47,14.66,14.85,15,14,14,14,14,14,14,14,14,14,-7.10,-7.64,-8.13,-8.59,-8.90,-9.18,-9.47,-9.61,-9.75,-9.79,-9.80,-9.75,-9.64,-9.64,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.93,-10,-10,-11,-11,-10,-10,-10,-11,-11,-11,-10,-10,-11,-11,-11,-12,-13,-14,-13,-13,-12,-9.88,-7.50,-4.93,-3.50,-3.34,-3.12,-2.97,-2.87,-2.74,-2.38,-1.75,-0.84,-0.15,0.26,0.52,1.02,1.78,2.91,3,2.60,2.21,1.87,1.51,1.11,0.73,0.65,0.97,1.40,1.99,2.52,2.73,1.99,1,1,1,2.02,3.07,3.89,4.10,4.87,4.12,4.12,4.87,4.97,5.85,5.85,3.87,2.13,1.25,0.87,0.53,0.91,1.14,1.35,1.37,1.27,1.15,1,0.84,0.64,0.50,0.37,0.26,0.21,0.15,0.13,0.15,0.22,0.27,0.37,0.49,0.60,0.70,0.76,0.84,0.87,0.87,0.85,0.78,0.75,0.65,0.60,0.50,0.40,0.35,0.25,0.21,0.13,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.13,0.25,0.37,0.51,0.71,0.88,1.12,1.37,1.70,2.03,2.45,2.84,3.21,3.52,3.52,3.71,3.87,4.11,4.29,4.49,4.62,4.72,4.79,4.84,4.87,4.85,4.82,4.70,4.62,4.65,4.77,4.97,5.16,5.39,5.66,5.99,6.36,6.75,7.15,7.62,8.09,8.59,9.02,9.45,9.90,10.49,11.13,11.77,12.37,12.87,13.25,13.59,13.82,13.96,14,13.87,13.98,13,13,13,13,13,13,13,13,-7.10,-7.63,-8.13,-8.54,-8.90,-9.18,-9.47,-9.63,-9.75,-9.84,-9.80,-9.75,-9.64,-9.68,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-11,-11,-10,-10,-10,-11,-11,-12,-14,-14,-14,-13,-12,-10,-7.99,-5.60,-4.04,-3.40,-3.03,-2.79,-2.63,-2.40,-2.13,-1.52,-0.88,-0.28,0.12,0.46,0.84,1.37,2,2.16,1.88,1.59,1.23,0.86,0.41,0.02,-0.13,0.02,0.53,1.12,1.61,1.77,1.70,1.02,1.01,1.07,1.09,2.88,3.87,4.12,4.87,5.85,5.14,5.83,6.83,6.83,6.82,5.82,3.76,2.34,1.45,1.15,1.12,1.26,1.39,1.49,1.48,1.38,1.25,1.10,0.89,0.74,0.58,0.46,0.36,0.26,0.25,0.25,0.27,0.37,0.46,0.57,0.65,0.75,0.85,0.89,0.95,0.96,0.91,0.88,0.85,0.76,0.70,0.62,0.51,0.45,0.36,0.27,0.22,0.13,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.13,0.25,0.37,0.51,0.71,0.87,1.10,1.34,1.62,1.91,2.26,2.54,2.84,3.11,3.39,3.71,4.08,4.45,5.12,5.25,5.89,5.38,5.58,5.90,5.77,5.36,5.16,4.97,4.77,4.73,4.76,4.88,5.07,5.25,5.48,5.75,6.08,6.39,6.82,7.25,7.72,8.14,8.57,9.07,9.61,10.25,10.90,11.51,12,12.38,12.71,12.98,13.15,13.26,13.28,13.25,13.03,12.87,12.72,12.84,13,13,13,13,12,-7,-7.55,-8.05,-8.49,-8.85,-9.13,-9.39,-9.54,-9.66,-9.75,-9.75,-9.68,-9.63,-9.64,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-12,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-14,-14,-13,-12,-10,-8.01,-5.78,-4.25,-3.40,-2.89,-2.51,-2.24,-1.97,-1.63,-1.25,-0.77,-0.36,0,0.25,0.51,0.84,1.08,1.23,1.12,0.87,0.51,0.13,-0.29,-0.73,-0.90,-0.75,-0.25,0.37,0.89,1.25,1.32,1.20,1.07,1.03,1.11,2.87,3.86,4.85,5.15,5.83,5.86,6.16,6.78,6.88,6.77,6.76,4.65,3.01,2,1.52,1.37,1.45,1.57,1.63,1.66,1.62,1.51,1.37,1.20,1,0.83,0.64,0.51,0.45,0.37,0.37,0.38,0.46,0.52,0.62,0.75,0.85,0.91,1,1.01,1.02,1.01,1,0.95,0.87,0.78,0.72,0.62,0.52,0.46,0.37,0.27,0.22,0.13,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.13,0.25,0.37,0.51,0.71,0.87,1.08,1.28,1.53,1.85,2.12,2.37,2.64,2.98,3.36,3.79,4.34,5.60,6.13,6.54,6.75,6.79,6.77,6.66,6.49,6.16,5.72,5.23,4.97,4.83,4.78,4.87,5,5.12,5.34,5.59,5.87,6.16,6.53,7,7.45,7.87,8.36,8.83,9.39,10.08,10.66,11.22,11.59,11.89,12.21,12.45,12.62,12.71,12.72,12.63,12.52,12.40,12.37,12.36,12.28,12,12,12,12,-6.85,-7.40,-7.90,-8.37,-8.72,-9,-9.25,-9.42,-9.54,-9.62,-9.63,-9.60,-9.48,-9.50,-9.98,-10,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.75,-10,-9.89,-9.64,-9.88,-9.62,-9.38,-9.27,-9.86,-10,-12,-13,-13,-12,-11,-9.41,-7.30,-5.54,-4.15,-3.25,-2.63,-2.13,-1.68,-1.37,-1.11,-0.87,-0.63,-0.38,-0.15,0.02,0.15,0.25,0.32,0.26,0.24,0.07,-0.23,-0.60,-1,-1.38,-1.53,-1.37,-0.86,-0.15,0.52,1.09,1.38,1.41,1.25,1.12,1.12,2.12,3.15,4.82,5.78,5.77,5.87,6.21,6.75,6.78,6.77,6.73,4.82,3.39,2.48,1.87,1.63,1.70,1.75,1.86,1.89,1.88,1.82,1.65,1.50,1.27,1.10,0.89,0.75,0.62,0.53,0.50,0.51,0.58,0.63,0.74,0.85,0.95,1,1.10,1.12,1.13,1.12,1.10,1.03,0.98,0.88,0.83,0.73,0.62,0.53,0.46,0.37,0.27,0.22,0.12,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.14,0.25,0.37,0.52,0.71,0.87,1.07,1.26,1.50,1.76,2,2.24,2.54,2.89,3.37,3.96,5.35,6.13,6.87,7.37,7.62,7.62,7.53,7.37,7.09,6.60,6.04,5.40,5.11,4.88,4.86,4.87,4.97,5.09,5.26,5.53,5.84,6.15,6.50,6.90,7.37,7.86,8.28,8.75,9.34,9.89,10.45,10.85,11.13,11.45,11.72,11.95,12.12,12.20,12.21,12.14,12.10,12.01,11.99,11.96,11.87,11.77,11.98,12,12,-6.85,-7.27,-7.68,-8.13,-8.50,-8.78,-9.03,-9.23,-9.36,-9.40,-9.41,-9.38,-9.25,-9.26,-9.72,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-16,-15,-15,-15,-14,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.78,-9.30,-9.25,-9.09,-8.80,-8.63,-7.92,-7.50,-7.30,-8.98,-10,-11,-11,-10,-9.41,-7.92,-6.37,-4.98,-3.85,-2.97,-2.25,-1.61,-1.03,-0.63,-0.43,-0.47,-0.49,-0.43,-0.38,-0.36,-0.35,-0.38,-0.47,-0.55,-0.66,-0.78,-1,-1.28,-1.63,-1.88,-2,-1.78,-1.27,-0.54,0.32,1.12,1.76,1.89,1.53,1.13,1.14,1.82,2.20,3.21,4.76,5.23,5.78,6.12,6.25,6.75,6.74,5.84,4.78,3.71,2.82,2.24,2.01,1.98,2,2.11,2.15,2.16,2.12,2,1.78,1.61,1.37,1.16,1,0.86,0.75,0.71,0.66,0.72,0.76,0.86,0.96,1.03,1.12,1.20,1.24,1.25,1.25,1.21,1.13,1.09,1,0.90,0.83,0.74,0.62,0.53,0.46,0.37,0.26,0.20,0.12,0.07,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.09,0.14,0.25,0.38,0.53,0.72,0.87,1.07,1.25,1.50,1.75,1.95,2.17,2.49,2.88,3.40,4.07,5.61,6.53,7.38,8,8.25,8.25,8.10,7.83,7.39,6.85,5.92,5.46,5.20,4.98,4.89,4.89,4.97,5.07,5.26,5.61,5.99,6.34,6.66,7.07,7.49,7.89,8.34,8.75,9.25,9.75,10.15,10.45,10.73,11,11.25,11.49,11.64,11.75,11.75,11.74,11.71,11.65,11.63,11.61,11.52,11.47,11.28,11,11,-6.84,-7.23,-7.62,-7.97,-8.25,-8.51,-8.75,-8.93,-9.13,-9.22,-9.25,-9.23,-9.12,-9,-9.42,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.66,-9.25,-8.78,-8.13,-7.53,-6.80,-6.38,-6.61,-7.52,-8.30,-8.41,-8.03,-7.48,-6.36,-5.25,-4.25,-3.40,-2.63,-1.90,-1.18,-0.62,-0.38,-0.38,-0.52,-0.67,-0.77,-0.85,-0.88,-0.92,-1.03,-1.16,-1.37,-1.48,-1.61,-1.73,-1.91,-2.13,-2.29,-2.34,-2.12,-1.61,-0.84,0.12,1.09,2.07,2.51,1.87,1.16,1.16,1.21,1.84,2.23,3.24,5.25,6.09,6.25,6.25,6.25,6.25,5.70,4.85,3.96,3.16,2.64,2.39,2.27,2.32,2.38,2.46,2.48,2.45,2.33,2.12,1.91,1.72,1.50,1.27,1.12,1,0.89,0.87,0.87,0.91,1,1.09,1.15,1.25,1.32,1.36,1.37,1.36,1.33,1.25,1.20,1.11,1,0.90,0.83,0.73,0.62,0.51,0.41,0.34,0.25,0.15,0.11,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.10,0.15,0.26,0.39,0.57,0.73,0.87,1.07,1.25,1.49,1.73,1.88,2.12,2.47,2.85,3.91,4.83,5.66,6.65,7.52,8.17,8.52,8.54,8.37,8.01,7.50,6.86,6.26,5.48,5.23,5.02,4.97,4.95,4.98,5.02,5.28,5.76,6.14,6.51,6.87,7.25,7.62,7.97,8.34,8.73,9.12,9.52,9.82,10.08,10.33,10.58,10.84,11.07,11.25,11.36,11.38,11.37,11.37,11.37,11.36,11.32,11.25,11.14,11,10.87,11,-6.90,-7.24,-7.50,-7.86,-8.14,-8.49,-8.75,-9,-9.23,-9.34,-9.36,-9.36,-9.25,-9.09,-9.38,-9.99,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-9.99,-9.47,-8.76,-8.15,-7.59,-6.80,-6.27,-6.17,-6.37,-6.43,-6.04,-5.49,-4.84,-4.13,-3.60,-3.09,-2.49,-1.85,-1.16,-0.76,-0.75,-0.86,-1.01,-1.18,-1.34,-1.41,-1.50,-1.61,-1.74,-1.88,-2.04,-2.13,-2.25,-2.29,-2.40,-2.52,-2.61,-2.52,-2.28,-1.76,-1.02,-0.11,0.86,1.78,2.16,1.83,1.37,1.13,1.23,1.24,2.25,4.25,6.25,7.26,7.27,7.10,6.73,6.36,5.76,5,4.23,3.51,3.08,2.75,2.62,2.62,2.66,2.75,2.77,2.75,2.62,2.48,2.25,2.03,1.83,1.61,1.39,1.25,1.13,1.10,1.08,1.11,1.14,1.23,1.28,1.37,1.41,1.48,1.49,1.47,1.41,1.37,1.27,1.21,1.12,1,0.89,0.82,0.72,0.61,0.50,0.39,0.32,0.23,0.13,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.16,0.27,0.41,0.58,0.74,0.88,1.08,1.25,1.48,1.72,2.04,2.10,2.39,2.82,3.33,4.36,5.52,6.41,7.27,7.95,8.37,8.50,8.38,8.07,7.50,6.49,5.85,5.42,5.25,5.10,5,4.99,4.99,5,5.12,5.99,6.25,6.61,7,7.36,7.70,7.91,8.25,8.60,8.95,9.25,9.49,9.72,9.91,10.15,10.41,10.66,10.87,11.01,11.10,11.12,11.12,11.12,11.11,11.10,11.03,10.97,10.82,10.63,10,-6.97,-7.25,-7.52,-7.88,-8.25,-8.66,-9,-9.26,-9.48,-9.60,-9.63,-9.61,-9.51,-9.35,-9.48,-9.97,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.65,-9.04,-8.48,-7.73,-7.13,-6.50,-5.98,-5.53,-5,-4.01,-3.80,-3.50,-3.25,-2.91,-2.50,-2.01,-1.60,-1.38,-1.38,-1.50,-1.68,-1.87,-2,-2.11,-2.22,-2.30,-2.40,-2.51,-2.63,-2.65,-2.73,-2.72,-2.75,-2.76,-2.75,-2.63,-2.38,-1.87,-1.14,-0.26,0.61,1.34,1.75,1.83,1.57,1.23,1.25,2.25,3.25,6.01,8.71,9.71,9.22,8.32,7.33,6.82,6.09,5.27,4.50,3.87,3.37,3.07,2.89,2.89,2.96,3,3.07,3.01,2.91,2.77,2.61,2.37,2.13,1.91,1.73,1.53,1.39,1.33,1.27,1.27,1.33,1.37,1.45,1.50,1.57,1.59,1.60,1.58,1.52,1.48,1.37,1.28,1.21,1.11,1,0.87,0.77,0.66,0.59,0.48,0.37,0.26,0.20,0.12,0.08,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.11,0.20,0.32,0.45,0.60,0.75,0.89,1.08,1.25,1.48,1.71,2.02,2.04,2.75,2.72,3.20,3.77,5.07,6.02,6.77,7.46,7.98,8.25,8.25,7.99,7.48,6.37,5.88,5.49,5.33,5.15,5.09,5.02,5,5,5,6,6.03,6.61,6.90,7.25,7.59,7.77,8.07,8.36,8.64,8.91,9.13,9.37,9.59,9.82,10.07,10.33,10.57,10.74,10.85,10.88,10.89,10.88,10.87,10.87,10.86,10.75,10.60,10.33,10,-6.99,-7.34,-7.84,-8.26,-8.65,-9,-9.25,-9.43,-9.63,-9.75,-9.77,-9.76,-9.65,-9.50,-9.42,-9.88,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.86,-9.25,-8.53,-7.88,-7.28,-6.55,-5.75,-5.05,-4.28,-3.80,-3.41,-3.24,-2.99,-2.68,-2.38,-2.12,-2,-2.03,-2.17,-2.37,-2.51,-2.67,-2.84,-2.97,-3.04,-3.13,-3.13,-3.13,-3.09,-3.01,-2.97,-2.91,-2.88,-2.84,-2.64,-2.34,-1.80,-1.14,-0.37,0.46,1.14,1.72,2.08,2.28,2.25,3.21,3.25,4.27,7.96,11.66,12.66,11.66,9.66,8.35,7.37,6.46,5.57,4.75,4.11,3.61,3.27,3.13,3.12,3.15,3.24,3.27,3.25,3.21,3.10,2.91,2.73,2.50,2.25,2.02,1.85,1.70,1.58,1.50,1.49,1.50,1.52,1.60,1.62,1.66,1.71,1.71,1.66,1.62,1.58,1.49,1.38,1.27,1.20,1.09,0.98,0.87,0.75,0.63,0.52,0.45,0.35,0.25,0.15,0.11,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.22,0.33,0.46,0.61,0.75,0.90,1.09,1.25,1.47,1.70,2,2.33,2.29,2.62,3.02,3.54,4.14,4.82,5.49,6.98,7.52,7.91,8.09,7.95,7.51,6.60,5.98,5.62,5.47,5.33,5.25,5.20,5.09,5,5,6,6,6.07,6.75,7.12,7.36,7.58,7.78,8.07,8.34,8.60,8.84,9.07,9.26,9.50,9.74,10,10.25,10.46,10.60,10.65,10.70,10.66,10.64,10.63,10.62,10.50,10.34,10.13,10,-7.12,-7.67,-8.16,-8.63,-9,-9.29,-9.54,-9.75,-9.88,-9.97,-9.99,-9.98,-9.88,-9.74,-9.52,-9.91,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.93,-9.25,-8.62,-7.97,-7.27,-6.48,-5.75,-5,-4.27,-3.75,-3.40,-3.14,-2.91,-2.74,-2.59,-2.51,-2.59,-2.72,-2.88,-3.13,-3.38,-3.62,-3.76,-3.87,-3.86,-3.75,-3.62,-3.42,-3.25,-3.13,-3.02,-2.92,-2.80,-2.55,-2.18,-1.64,-1.01,-0.28,0.47,1.21,1.90,2.65,3.45,4.25,5.72,6.24,7.02,9.66,12.65,13.64,12.64,10.78,9.23,7.90,6.75,5.75,4.89,4.25,3.75,3.41,3.28,3.25,3.32,3.37,3.45,3.46,3.45,3.36,3.23,3.02,2.83,2.60,2.37,2.14,1.98,1.84,1.75,1.70,1.66,1.71,1.74,1.75,1.78,1.82,1.82,1.76,1.74,1.65,1.59,1.49,1.37,1.25,1.14,1.03,0.95,0.84,0.73,0.62,0.50,0.39,0.33,0.24,0.14,0.10,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.22,0.34,0.48,0.62,0.75,0.91,1.10,1.25,1.47,1.66,1.82,2,2.24,2.53,2.90,3.37,3.87,4.48,5.11,5.76,7.15,7.62,7.91,7.90,7.58,7.08,6.17,5.87,5.74,5.70,5.66,5.59,5.26,5,5,6,6,6,6.98,6.88,7.13,7.33,7.50,7.75,8.01,8.28,8.53,8.77,9,9.23,9.46,9.70,9.95,10.14,10.33,10.40,10.41,10.38,10.36,10.34,10.28,10.23,10.08,9.87,10,-7.41,-8,-8.48,-8.89,-9.26,-9.60,-9.80,-10,-10,-10,-10,-10,-10,-9.99,-9.76,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.85,-9.18,-8.61,-7.88,-7.11,-6.38,-5.63,-4.88,-4.25,-3.76,-3.42,-3.16,-3,-2.90,-2.88,-2.91,-3.10,-3.36,-3.73,-4.13,-4.48,-4.68,-4.75,-4.64,-4.41,-4.11,-3.77,-3.47,-3.25,-3.10,-2.92,-2.75,-2.42,-2,-1.42,-0.79,-0.12,0.62,1.40,2.33,3.46,4.96,7.10,9.71,8.70,8.15,8.34,9.34,11.63,12.62,11.62,9.87,8.27,6.96,5.85,4.98,4.26,3.77,3.49,3.37,3.36,3.38,3.49,3.53,3.62,3.62,3.60,3.50,3.35,3.13,2.90,2.70,2.47,2.25,2.11,1.99,1.89,1.87,1.87,1.87,1.89,1.91,1.91,1.90,1.87,1.84,1.75,1.65,1.58,1.48,1.36,1.25,1.12,1,0.89,0.78,0.70,0.60,0.49,0.38,0.32,0.23,0.13,0.09,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.23,0.35,0.49,0.62,0.76,0.95,1.11,1.26,1.47,1.65,1.82,1.98,2.22,2.48,2.79,3.21,3.66,4.22,4.85,5.50,6.15,7.45,7.83,7.89,7.62,7.16,6.41,6.17,6.20,6.33,6.47,6.37,6,6,5,6,6,6,6,6.99,6.97,7.09,7.20,7.45,7.75,8.03,8.28,8.53,8.75,8.99,9.21,9.40,9.64,9.87,10.02,10.12,10.12,10.10,10.01,10,9.98,9.90,9.77,9.60,9,-7.65,-8.24,-8.68,-9.13,-9.50,-9.79,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,-10,-9.72,-9.13,-8.41,-7.63,-6.90,-6.18,-5.62,-4.92,-4.34,-3.87,-3.51,-3.29,-3.16,-3.13,-3.17,-3.39,-3.80,-4.38,-5,-5.50,-5.75,-5.75,-5.51,-5.13,-4.63,-4.13,-3.66,-3.37,-3.13,-2.89,-2.63,-2.25,-1.75,-1.16,-0.52,0.15,0.90,1.75,2.78,4.25,6.32,9.71,12.70,10.14,8.34,7.34,7.36,10.35,12.62,12.62,10.22,8.37,6.95,5.76,4.87,4.22,3.75,3.50,3.37,3.37,3.41,3.52,3.62,3.73,3.77,3.77,3.74,3.62,3.46,3.25,3,2.76,2.57,2.37,2.23,2.12,2.08,2.02,2.02,2.03,2.03,2.03,2.01,2,1.91,1.86,1.75,1.65,1.57,1.45,1.34,1.22,1.10,0.99,0.87,0.75,0.65,0.58,0.48,0.37,0.28,0.22,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.12,0.24,0.36,0.50,0.63,0.78,0.96,1.12,1.27,1.48,1.65,1.86,2,2.20,2.42,2.74,3.11,3.53,4.07,4.70,5.39,6.40,7.36,7.78,7.87,7.66,7.27,6.66,6.62,6.78,7.21,7.75,7.87,7,6,6,6,6,6,6,6,7,6.71,6.83,7.13,7.50,7.84,8.07,8.32,8.52,8.75,8.98,9.20,9.38,9.61,9.75,9.85,9.84,9.75,9.70,9.64,9.63,9.61,9.46,9.14,9,-7.86,-8.38,-8.89,-9.30,-9.68,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-11,-10,-10,-9.59,-8.88,-8.10,-7.55,-7.11,-6.67,-5.98,-5.18,-4.53,-4.03,-3.75,-3.59,-3.47,-3.50,-3.76,-4.38,-5.23,-6.04,-6.67,-6.97,-6.87,-6.47,-5.86,-5.17,-4.50,-3.88,-3.47,-3.13,-2.85,-2.49,-2,-1.50,-0.88,-0.23,0.50,1.25,2.11,3.22,4.77,7.37,11.70,13.66,10.77,8.66,7.36,7.36,9.37,12.62,12.62,10.03,8.15,6.65,5.50,4.70,4.07,3.63,3.45,3.36,3.37,3.41,3.53,3.66,3.82,3.89,3.97,3.96,3.87,3.75,3.53,3.33,3.09,2.86,2.62,2.48,2.35,2.25,2.23,2.21,2.20,2.20,2.16,2.13,2.11,2.02,1.97,1.87,1.75,1.63,1.51,1.39,1.27,1.16,1.07,0.96,0.86,0.75,0.63,0.57,0.47,0.37,0.26,0.16,0.10,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.13,0.25,0.37,0.50,0.64,0.83,0.98,1.12,1.32,1.49,1.65,1.87,2.12,2.21,2.45,2.73,3.07,3.50,4.02,4.66,5.37,6.67,7.33,7.75,7.85,7.65,7.34,6.92,7.03,7.48,8.25,9.16,11,9,7,6,6,6,6,6,6,6,6.13,6.48,6.88,7.26,7.61,7.82,8.03,8.27,8.51,8.75,8.98,9.15,9.37,9.50,9.59,9.53,9.47,9.37,9.34,9.28,9.24,9.03,8.73,8,-7.97,-8.52,-9,-9.43,-9.79,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.91,-9.27,-9.01,-8.68,-8.65,-8.04,-7.23,-6.39,-5.63,-5.03,-4.59,-4.24,-4,-3.92,-4.28,-5.14,-6.26,-7.27,-8.03,-8.34,-8.05,-7.41,-6.59,-5.65,-4.78,-4.03,-3.51,-3.12,-2.75,-2.28,-1.78,-1.23,-0.59,0.12,0.84,1.60,2.46,3.51,5,7.46,10.66,12.64,10.64,8.62,6.36,6.37,8.62,11.62,10.60,9.58,7.50,6.14,5.11,4.38,3.87,3.50,3.37,3.28,3.33,3.39,3.53,3.71,3.87,4,4.12,4.14,4.12,4,3.86,3.62,3.37,3.12,2.89,2.72,2.57,2.47,2.38,2.37,2.36,2.34,2.32,2.26,2.23,2.13,2.07,1.97,1.86,1.74,1.62,1.50,1.37,1.25,1.13,1.02,0.91,0.84,0.74,0.62,0.53,0.46,0.35,0.24,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.08,0.14,0.25,0.37,0.51,0.66,0.85,1,1.15,1.34,1.50,1.66,1.87,2.09,2.25,2.46,2.71,3.04,3.48,4,4.64,5.37,6.63,7.33,7.70,7.77,7.54,7.16,7.12,7.37,8.08,9.26,11,13,12,8,7,6,6,6,6,6,6,6,6.26,6.66,7.08,7.35,7.57,7.75,8,8.25,8.50,8.75,8.96,9.12,9.25,9.32,9.27,9.23,9.13,9.10,9.02,8.88,8.65,8.35,8,-8.02,-8.59,-9.09,-9.50,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-10,-10,-9.80,-9.98,-9.88,-9.40,-8.50,-7.80,-7.24,-6.60,-5.92,-5.38,-4.97,-4.80,-5.24,-6.24,-7.52,-8.65,-9.50,-9.65,-9.18,-8.27,-7.23,-6,-4.92,-4.13,-3.52,-3.04,-2.61,-2.12,-1.53,-0.91,-0.25,0.48,1.20,1.96,2.76,3.75,5.02,6.71,8.65,9.64,8.12,6.36,5.37,5.37,6.37,8.60,8.60,7.58,6.46,5.48,4.63,4.10,3.64,3.37,3.27,3.25,3.27,3.37,3.52,3.73,3.90,4.11,4.25,4.34,4.35,4.26,4.12,3.90,3.65,3.39,3.15,2.96,2.77,2.65,2.60,2.52,2.50,2.49,2.46,2.39,2.35,2.25,2.15,2.08,1.96,1.84,1.71,1.59,1.47,1.35,1.23,1.12,1,0.89,0.82,0.73,0.62,0.51,0.40,0.32,0.21,0.11,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.15,0.26,0.39,0.53,0.72,0.87,1.01,1.20,1.37,1.51,1.71,1.87,2.10,2.32,2.48,2.74,3.04,3.46,3.98,4.92,5.77,6.57,7.21,7.52,7.50,7.29,7.08,7.11,7.48,8.32,10,13,16,16,12,9,7,6,6,6,6,6,6,6,6.66,6.98,7.12,7.28,7.50,7.73,7.99,8.25,8.50,8.71,8.86,8.97,9.01,9.08,9.07,9,8.95,8.78,8.61,8.37,8.12,8,-8.01,-8.59,-9.09,-9.50,-9.97,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.88,-9.80,-9.80,-9.77,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,-10,-10,-10,-10,-10,-10,-9.47,-9.36,-8.92,-8.34,-7.65,-7,-6.50,-6.30,-6.74,-7.73,-9,-10,-10,-10,-10,-9.04,-7.52,-6.13,-4.92,-4.10,-3.48,-2.98,-2.48,-1.90,-1.27,-0.61,0.12,0.87,1.61,2.37,3.16,4.09,5.10,5.99,6.34,6.35,5.36,5.36,4.37,4.37,4.38,5.38,5.38,5.40,5.34,4.78,4.22,3.84,3.50,3.27,3.23,3.21,3.25,3.36,3.51,3.74,3.96,4.16,4.37,4.50,4.57,4.51,4.38,4.20,3.95,3.66,3.40,3.20,3,2.87,2.77,2.73,2.66,2.63,2.61,2.53,2.48,2.37,2.27,2.15,2.03,1.91,1.78,1.65,1.53,1.41,1.32,1.20,1.10,1,0.88,0.82,0.72,0.62,0.50,0.38,0.26,0.14,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.16,0.27,0.41,0.59,0.74,0.88,1.07,1.23,1.38,1.57,1.73,1.89,2.10,2.28,2.52,2.82,3.07,3.45,3.92,4.83,5.53,6.26,6.84,7.11,7.04,6.88,6.76,6.88,7.26,8.03,10,13,16,19,17,12,8,7,6,6,6,6,6,6,6.98,6.99,7,7.01,7.25,7.45,7.66,7.96,8.23,8.41,8.57,8.63,8.73,8.82,8.87,8.87,8.75,8.60,8.37,8.12,8,8,-7.93,-8.50,-9.09,-9.63,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.53,-9.29,-9.30,-9.40,-9.43,-9.67,-9.87,-10,-10,-10,-10,-11,-11,-11,-12,-13,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-11,-11,-10,-10,-11,-10,-10,-9.48,-8.88,-8.48,-8.38,-8.76,-9.61,-10,-11,-11,-11,-11,-9.26,-7.49,-5.88,-4.66,-3.91,-3.35,-2.86,-2.34,-1.72,-1,-0.24,0.53,1.34,2.11,2.87,3.71,4.59,5.47,6.16,6.34,6.36,5.36,5,4.37,4.12,4.22,4.35,4.40,4.45,4.58,4.35,3.91,3.64,3.38,3.23,3.16,3.15,3.23,3.34,3.51,3.75,4,4.25,4.50,4.65,4.75,4.75,4.63,4.46,4.21,3.91,3.65,3.41,3.24,3.09,2.99,2.89,2.86,2.78,2.75,2.66,2.61,2.50,2.38,2.26,2.13,2.01,1.88,1.75,1.62,1.50,1.38,1.26,1.16,1.09,0.99,0.87,0.78,0.72,0.61,0.50,0.37,0.25,0.12,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.20,0.32,0.46,0.61,0.75,0.91,1.10,1.25,1.40,1.59,1.75,1.91,2.12,2.32,2.51,2.76,3.07,3.41,3.88,4.48,5.12,5.75,6.25,6.50,6.50,6.41,6.36,6.34,7.08,8,10,13,17,19,19,15,11,8,8,7,7,7,6,6,7,7,7,7,7.02,7.22,7.39,7.64,7.91,8.13,8.25,8.34,8.40,8.51,8.62,8.62,8.50,8.35,8.12,7.99,8,8,-7.79,-8.50,-9.24,-9.89,-10,-10,-11,-11,-11,-11,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.98,-9.88,-9.75,-9.76,-9.91,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.63,-9.30,-9.14,-9.15,-9.12,-9.16,-9.25,-9.37,-9.55,-9.67,-10,-10,-10,-10,-11,-12,-13,-13,-14,-14,-14,-14,-14,-14,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-11,-11,-11,-10,-11,-12,-12,-11,-11,-10,-10,-10,-11,-11,-12,-12,-13,-12,-11,-9.04,-6.93,-5.29,-4.27,-3.61,-3.14,-2.73,-2.16,-1.48,-0.63,0.21,1.03,1.87,2.71,3.51,4.38,5.32,6.26,7.02,7.64,7.62,6.62,5.37,4.38,4.24,4.11,4.12,4.13,4.25,4.37,4.23,3.87,3.62,3.37,3.21,3.14,3.13,3.21,3.33,3.51,3.76,4.03,4.35,4.62,4.85,4.97,4.99,4.87,4.71,4.46,4.16,3.88,3.64,3.46,3.27,3.16,3.10,3.01,2.97,2.88,2.83,2.74,2.62,2.50,2.37,2.25,2.12,2,1.86,1.74,1.61,1.49,1.37,1.25,1.15,1.08,0.98,0.87,0.78,0.71,0.61,0.49,0.37,0.24,0.12,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.21,0.34,0.48,0.62,0.78,0.97,1.12,1.28,1.47,1.62,1.76,1.96,2.12,2.33,2.51,2.75,3,3.34,3.74,4.22,4.75,5.25,5.64,5.87,5.89,5.89,5.95,6.08,7,8,10,13,16,19,20,19,16,12,9,8,8,7,7,7,7,7,7,7,7,7,7.13,7.37,7.62,7.87,8.01,8.11,8.14,8.24,8.27,8.27,8.24,8.12,7.99,8,8,8,-7.79,-8.65,-9.42,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.67,-9.35,-9.11,-9,-9.09,-9.29,-9.60,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.72,-9.60,-9.37,-9.04,-9.01,-9.10,-9.03,-9.01,-9.27,-9.48,-9.59,-9.74,-9.87,-10,-10,-11,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-11,-11,-10,-11,-12,-13,-13,-12,-12,-12,-13,-14,-13,-13,-14,-13,-12,-10,-8.13,-6.11,-4.63,-3.75,-3.36,-2.97,-2.51,-1.90,-1.12,-0.22,0.73,1.62,2.52,3.40,4.32,5.24,6.21,7.22,8.50,8.63,8.62,7.62,6.28,5.34,4.38,4.38,4.40,4.40,4.41,4.63,4.45,4.09,3.72,3.39,3.22,3.14,3.12,3.20,3.33,3.52,3.78,4.12,4.45,4.75,5,5.14,5.21,5.12,4.95,4.70,4.39,4.12,3.87,3.65,3.50,3.37,3.26,3.21,3.12,3.03,2.97,2.87,2.75,2.62,2.50,2.36,2.23,2.10,1.96,1.84,1.71,1.59,1.47,1.36,1.25,1.14,1.07,0.98,0.87,0.78,0.72,0.61,0.50,0.37,0.25,0.15,0.10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.11,0.22,0.35,0.50,0.65,0.84,1,1.14,1.34,1.50,1.63,1.82,1.98,2.13,2.34,2.51,2.74,2.97,3.25,3.59,3.99,4.38,4.76,5.09,5.25,5.34,5.25,5.91,6,6,7,9,11,15,19,23,23,21,17,12,10,8,8,7,7,7,7,7,7,7,7,7,7.12,7.33,7.62,7.84,8,8.01,8.02,8.01,8,8,8,8,8,8,8,-7.86,-8.75,-9.49,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-9.86,-9.35,-9.12,-8.85,-8.50,-8.34,-8.50,-8.80,-9.25,-9.63,-9.85,-9.98,-9.99,-9.87,-9.75,-9.75,-9.76,-9.68,-9.55,-9.36,-9.17,-8.93,-8.97,-9,-9.37,-9.65,-9.63,-9.86,-10,-10,-10,-10,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-11,-12,-13,-13,-12,-13,-14,-15,-15,-14,-13,-14,-13,-11,-9.62,-7,-5,-4.01,-3.43,-3.14,-2.78,-2.29,-1.59,-0.66,0.35,1.35,2.35,3.28,4.25,5.23,6.21,7.21,8.21,8.98,9.62,9.62,8.10,7.08,6.27,5.87,5.40,5.37,5.08,5.02,5.10,5,4.36,3.87,3.49,3.25,3.15,3.13,3.21,3.34,3.58,3.86,4.20,4.53,4.88,5.16,5.36,5.39,5.35,5.15,4.90,4.62,4.36,4.11,3.87,3.71,3.58,3.47,3.37,3.27,3.21,3.11,3,2.87,2.74,2.61,2.47,2.33,2.20,2.07,1.91,1.78,1.66,1.57,1.46,1.35,1.25,1.13,1.03,0.98,0.87,0.82,0.73,0.62,0.53,0.46,0.33,0.21,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.23,0.37,0.51,0.71,0.87,1.02,1.21,1.37,1.51,1.70,1.85,2,2.15,2.36,2.52,2.74,2.96,3.20,3.48,3.77,4.11,4.34,4.58,4.87,5.01,5.03,5.99,6,6,7,8,11,16,21,24,25,22,19,15,11,9,8,8,8,8,7,7,7,7,8,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,-7.90,-8.65,-9.41,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-9.75,-9.38,-8.99,-8.63,-8.42,-8.34,-8.41,-8.63,-8.93,-9.25,-9.50,-9.67,-9.76,-9.76,-9.85,-9.89,-9.84,-9.73,-9.60,-9.47,-9.28,-9.03,-8.85,-9.26,-9.62,-9.85,-10,-10,-10,-10,-10,-10,-11,-11,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.92,-9.92,-9.66,-9.64,-9.92,-10,-11,-12,-13,-13,-13,-14,-15,-15,-14,-13,-13,-12,-10,-8.27,-5.97,-4.38,-3.50,-3.25,-3.02,-2.73,-2.12,-1.18,-0.13,1,2.12,3.16,4.16,5.14,6.16,7.24,8.25,9.14,9.77,9.88,9.36,8.37,7.73,7.35,7.11,7.58,6.58,5.87,5.41,5.65,5.27,4.72,4.08,3.60,3.32,3.23,3.16,3.24,3.37,3.62,3.90,4.27,4.66,5.03,5.36,5.53,5.62,5.57,5.37,5.12,4.86,4.58,4.32,4.10,3.89,3.75,3.62,3.52,3.45,3.35,3.24,3.12,2.99,2.85,2.71,2.57,2.41,2.27,2.14,2.01,1.88,1.76,1.64,1.52,1.41,1.34,1.23,1.12,1.03,0.97,0.87,0.83,0.75,0.71,0.62,0.50,0.33,0.13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.24,0.37,0.53,0.73,0.88,1.08,1.25,1.40,1.59,1.73,1.87,2.01,2.20,2.37,2.57,2.75,2.97,3.20,3.47,3.75,3.97,4.12,4.26,4.87,4.99,5,6,6,6,7,8,10,14,19,23,24,23,20,17,13,11,10,9,8,8,8,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,7,-7.92,-8.65,-9.29,-9.93,-10,-10,-11,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.75,-9.42,-9.03,-8.80,-8.65,-8.49,-8.37,-8.53,-8.80,-9.15,-9.38,-9.55,-9.67,-9.76,-9.89,-10,-10,-9.99,-9.87,-9.64,-9.35,-9.12,-9,-9.39,-9.63,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.80,-9.50,-9.25,-9.26,-9.03,-8.86,-9.86,-11,-12,-13,-13,-13,-14,-14,-13,-12,-11,-10,-8.74,-6.75,-5.13,-3.90,-3.34,-3.13,-3,-2.64,-1.93,-0.79,0.48,1.78,3.03,4.12,5.11,6.01,7.03,8.14,9.34,10.24,10.64,10.62,9.62,8.62,8.16,8.11,8.60,7.66,7.58,6.37,6.03,6.10,6.15,5.01,4.27,3.74,3.39,3.28,3.25,3.27,3.40,3.71,4,4.39,4.84,5.23,5.53,5.75,5.83,5.75,5.60,5.35,5.07,4.76,4.50,4.27,4.11,3.96,3.83,3.71,3.60,3.49,3.37,3.24,3.11,2.97,2.82,2.65,2.51,2.38,2.25,2.12,2,1.87,1.75,1.62,1.51,1.40,1.32,1.21,1.12,1.01,0.97,0.88,0.87,0.83,0.75,0.62,0.41,0.21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.12,0.25,0.38,0.58,0.75,0.90,1.11,1.26,1.46,1.62,1.75,1.88,2.02,2.21,2.37,2.58,2.76,3,3.25,3.58,3.83,3.99,4.01,4.08,4.96,5,5,6,6,6,6,7,9,11,14,19,22,23,22,19,15,13,12,10,9,9,8,8,7,7,7,7,7,7,7,7,7.13,7.14,7.87,7.91,7.96,7.97,7.99,8,8,7,7,-7.91,-8.63,-9.25,-9.75,-10,-10,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.75,-9.48,-9.25,-9.05,-8.86,-8.67,-8.55,-8.53,-8.80,-9.12,-9.34,-9.51,-9.64,-9.88,-10,-10,-10,-10,-10,-9.84,-9.52,-9.18,-9.18,-9.48,-9.76,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.97,-9.68,-9.63,-9.17,-8.60,-8.54,-10,-11,-12,-12,-12,-11,-12,-12,-11,-10,-8.59,-7.05,-5.47,-4.40,-3.63,-3.25,-3.11,-2.97,-2.60,-1.85,-0.53,1.01,2.66,4.13,5.23,5.99,6.66,7.58,8.85,10.07,11.32,11.64,9.62,8.08,7.63,8.62,8.60,8.25,7.84,7.11,6.40,6.32,6.57,6.26,5.35,4.57,3.96,3.58,3.45,3.36,3.37,3.50,3.83,4.15,4.59,5,5.41,5.75,5.98,6.02,5.97,5.77,5.52,5.25,4.98,4.72,4.49,4.27,4.12,4,3.87,3.75,3.62,3.49,3.36,3.22,3.08,2.90,2.76,2.62,2.50,2.37,2.24,2.11,1.99,1.87,1.74,1.62,1.50,1.37,1.26,1.15,1.09,1,0.97,0.91,0.88,0.85,0.73,0.50,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.13,0.25,0.40,0.60,0.75,0.96,1.12,1.33,1.50,1.64,1.78,1.91,2.03,2.21,2.37,2.60,2.77,3,3.32,3.75,4.08,4.10,4.03,4.01,4.99,5,5,5,6,6,6,7,8,9,12,17,21,23,24,21,18,16,14,12,10,9,9,8,7,7,7,7,7,7,7,7.01,7.03,7.15,7.25,7.20,7.14,7.08,7.04,7.01,7,7,7,-7.76,-8.49,-9.12,-9.64,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.86,-9.60,-9.47,-9.26,-8.97,-8.80,-8.65,-8.54,-8.79,-9.10,-9.38,-9.61,-9.88,-10,-10,-10,-10,-10,-10,-9.92,-9.63,-9.29,-9.23,-9.48,-9.92,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.51,-9.24,-8.54,-9,-9.93,-9.92,-9.87,-9.77,-10,-10,-10,-9.25,-8.10,-6.85,-5.55,-4.38,-3.79,-3.36,-3.13,-3.04,-2.93,-2.66,-1.98,-0.51,1.41,3.70,5.62,6.50,6.75,6.86,7.37,8.15,9.07,9.50,9.64,7.35,5.36,5.37,6.95,8.60,8.23,7.75,7.02,6.40,6.39,6.60,6.39,5.64,4.96,4.28,3.85,3.65,3.52,3.51,3.65,4,4.37,4.82,5.25,5.66,6,6.20,6.25,6.15,5.99,5.74,5.46,5.15,4.89,4.65,4.48,4.32,4.14,4,3.87,3.75,3.62,3.48,3.33,3.16,3.01,2.87,2.74,2.61,2.47,2.34,2.22,2.09,1.97,1.84,1.72,1.60,1.47,1.35,1.24,1.12,1.03,1,0.97,0.95,0.88,0.77,0.62,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.14,0.27,0.45,0.62,0.77,0.98,1.14,1.35,1.51,1.70,1.84,1.95,2.03,2.21,2.38,2.62,2.82,2.97,3.12,3.89,4.07,4.96,4.98,5,5,5,5,5,5,6,6,6,7,8,11,16,21,24,25,23,21,19,18,15,12,10,9,8,7.07,7.02,7.01,7.01,7.01,7.04,7.08,7.09,7.08,7.08,7.07,7.04,7.03,7.02,7,7,7,7,7,-7.68,-8.25,-8.93,-9.63,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.91,-9.61,-9.37,-9,-8.75,-8.64,-8.63,-8.88,-9.25,-9.51,-9.75,-10,-10,-10,-10,-10,-10,-10,-10,-9.63,-9.36,-9.25,-9.49,-9.87,-10,-10,-10,-11,-11,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.29,-8.78,-9.38,-9.14,-8.14,-7.78,-7.88,-8,-7.25,-6.91,-6.13,-5.15,-4.26,-3.63,-3.39,-3.16,-3.09,-3.01,-2.92,-2.65,-1.92,-0.47,1.58,3.87,5.58,6.25,6.24,6.32,6.64,7.24,7.85,8.53,6.84,5.32,3.36,3.37,5.37,7.60,8.60,7.87,7.15,6.40,6.40,6.86,6.72,6.23,5.53,4.85,4.26,4,3.82,3.76,3.89,4.26,4.66,5.12,5.59,5.99,6.26,6.46,6.48,6.37,6.15,5.90,5.62,5.35,5.09,4.86,4.63,4.48,4.32,4.15,4.01,3.87,3.74,3.60,3.45,3.27,3.12,2.99,2.85,2.71,2.58,2.45,2.32,2.16,2.03,1.91,1.78,1.65,1.52,1.39,1.27,1.16,1.10,1.01,0.99,0.96,0.90,0.86,0.72,0.52,0.24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.09,0.16,0.32,0.48,0.63,0.83,1,1.16,1.37,1.58,1.75,1.87,1.96,2.01,2.13,2.38,2.64,2.87,2.98,3.07,3.96,4.01,5,6,6,6,6,6,5,5,6,6,7,7,8,11,17,21,25,25,24,24,22,21,17,13,11,9,8.07,7.12,7.17,7.15,7.10,7.12,7.22,7.32,7.33,7.23,7.12,7.08,7.02,7,7,7,7,7,7,7,-7.61,-8.28,-9,-9.59,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.39,-9,-8.76,-8.74,-8.75,-8.97,-9.34,-9.62,-9.89,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.52,-9.14,-9.29,-9.48,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-10,-10,-10,-10,-10,-10,-9.85,-9.29,-8.98,-7.87,-6.28,-5.50,-5.12,-5.30,-5.12,-4.54,-3.92,-3.50,-3.25,-3.10,-3.04,-3.02,-3,-2.92,-2.64,-1.92,-0.50,1.49,3.47,4.84,5.32,5.34,5.37,5.63,6.15,6.70,6.70,4.32,3.34,3.36,3.36,5.37,7.33,8.60,8.28,7.38,7.13,7.21,7.40,7.61,7.14,6.45,5.64,4.91,4.50,4.25,4.14,4.26,4.66,5.10,5.53,5.99,6.36,6.61,6.73,6.72,6.59,6.37,6.10,5.78,5.50,5.25,5,4.83,4.62,4.48,4.32,4.14,4,3.86,3.71,3.53,3.38,3.24,3.09,2.95,2.78,2.65,2.51,2.38,2.25,2.12,2,1.87,1.75,1.62,1.48,1.35,1.23,1.12,1.02,1,0.97,0.95,0.89,0.78,0.62,0.33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.10,0.20,0.34,0.50,0.65,0.85,1,1.20,1.37,1.59,1.75,1.87,1.97,2.01,2.11,2.26,2.88,2.91,2.99,3.01,3.98,4,5,7,8,7,7,6,6,6,6,6,7,8,9,12,18,22,24,25,25,26,26,23,18,14,11,9.01,8.11,7.90,7.75,7.33,7.38,7.46,7.48,8.03,7.98,7.51,7.39,7.22,7.09,7.01,7,7,7,7,6.99,6.99,-7.61,-8.34,-9,-9.60,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.66,-9.24,-8.78,-8.66,-8.73,-8.91,-9.26,-9.59,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.37,-8.88,-9.09,-9.63,-10,-10,-10,-9.88,-9.52,-9.62,-9.74,-10,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-10,-10,-11,-11,-11,-11,-10,-10,-9.11,-7.88,-6.25,-5.11,-4.48,-4.29,-3.98,-3.62,-3.30,-3.13,-3,-2.97,-2.92,-2.97,-2.98,-2.91,-2.64,-1.91,-0.53,1.28,3,4.14,4.40,4.37,4.24,4.58,5.11,5.70,5.71,3.32,2.34,3.25,4.24,5.37,7.96,9.62,8.87,8.23,7.38,8.38,8.88,9.03,8.60,7.70,6.75,5.84,5.21,4.88,4.74,4.83,5.25,5.63,6.09,6.49,6.77,6.99,7.02,6.98,6.78,6.53,6.25,5.97,5.66,5.40,5.16,4.98,4.77,4.62,4.46,4.28,4.12,3.99,3.83,3.64,3.50,3.35,3.20,3.02,2.88,2.75,2.62,2.49,2.36,2.22,2.09,1.96,1.82,1.65,1.51,1.37,1.25,1.13,1.07,1,0.98,0.96,0.95,0.86,0.73,0.37,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.21,0.36,0.51,0.71,0.87,1.02,1.22,1.39,1.62,1.77,1.88,1.97,2,2.10,2.07,2.96,2.99,3,3,4,4,6,8,9,9,8,7,6,6,6,7,8,9,10,12,17,21,23,25,26,27,28,24,19,14,11,9.92,8.87,8.21,8.17,8.01,8,8.28,9,9.48,9.38,8.58,7.96,7.48,7.21,7.07,7,7,7,7,6.99,6.97,-7.75,-8.39,-8.93,-9.52,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.50,-8.92,-8.62,-8.64,-8.91,-9.34,-9.66,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-9.86,-9.54,-9.23,-8.91,-8.79,-9.13,-9.29,-9.41,-9.38,-9.30,-9.13,-8.88,-9.54,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-9.25,-7.68,-6.59,-5.23,-4.26,-3.84,-3.50,-3.17,-2.90,-2.75,-2.68,-2.73,-2.78,-2.86,-2.88,-2.80,-2.53,-1.85,-0.51,1.15,2.75,3.76,3.74,3.50,3.23,3.47,4.08,4.73,4.71,3.32,3.12,3.34,4.36,6.87,9.62,10.62,9.37,9.13,9.36,9.96,10.61,10.99,10.60,9.50,7.98,7.11,6.20,5.75,5.53,5.61,5.95,6.37,6.75,7.08,7.28,7.38,7.37,7.24,7,6.74,6.41,6.12,5.84,5.58,5.34,5.12,4.91,4.75,4.60,4.41,4.25,4.11,3.95,3.76,3.61,3.46,3.27,3.12,3,2.85,2.71,2.57,2.40,2.27,2.13,2,1.87,1.73,1.59,1.41,1.28,1.16,1.09,1,0.98,0.97,0.96,0.88,0.82,0.61,0.23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.21,0.37,0.57,0.75,0.89,1.08,1.24,1.45,1.64,1.85,1.96,1.99,2,2.01,2.99,2.99,3,3,4,4,4,6,7,9,11,10,8,7,7,7,7,8,9,11,13,17,21,23,25,27,28,29,26,21,16,12,10.10,9.16,8.87,8.65,8.58,8.48,9.20,10.46,12.40,11.39,10.13,8.59,7.87,7.38,7.12,7.02,7,7,7,6.99,6.96,-7.86,-8.49,-9.04,-9.53,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.72,-9.04,-8.72,-8.88,-9.13,-9.38,-9.74,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.93,-9.60,-9.30,-8.90,-8.60,-8.75,-8.99,-9.13,-9.05,-8.86,-8.88,-9.02,-9.87,-10,-10,-11,-11,-11,-11,-12,-11,-11,-11,-11,-10,-10,-10,-9.91,-9.75,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-11,-11,-10,-9.89,-8.60,-7.52,-6.29,-5.12,-4.13,-3.59,-3.22,-2.84,-2.50,-2.25,-2.17,-2.25,-2.42,-2.61,-2.73,-2.60,-2.27,-1.60,-0.38,1.12,2.52,3.52,3.41,2.50,2.33,2.22,3.14,3.74,4.72,3.27,3.32,4.32,5.34,7.77,10.62,10.62,10.01,9.90,10.60,11.60,12.60,12.75,13.60,11.62,10.08,8.74,7.58,6.87,6.70,6.64,6.87,7.25,7.50,7.74,7.85,7.84,7.72,7.50,7.23,6.89,6.59,6.25,5.98,5.71,5.48,5.25,5.07,4.87,4.72,4.53,4.37,4.23,4.03,3.87,3.72,3.53,3.37,3.23,3.08,2.91,2.76,2.62,2.50,2.36,2.21,2.07,1.90,1.75,1.62,1.48,1.34,1.21,1.11,1.01,0.99,0.97,0.96,0.96,0.89,0.75,0.61,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.23,0.38,0.60,0.77,0.97,1.12,1.27,1.50,1.74,1.89,1.99,2,2,2,3,3,3,3,4,4,5,6,7,9,11,13,11,9,8,7,8,9,10,12,15,18,21,24,26,28,30,30,27,23,18,13,11.12,9.82,9.22,8.95,8.87,9.07,9.54,11.54,14.37,14.37,11.61,9.61,8.37,7.54,7.27,7.10,7.01,7,7,6.99,6.95,-7.89,-8.52,-9.13,-9.76,-10,-10,-11,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.80,-9.28,-8.80,-9.04,-9.37,-9.72,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.66,-9.30,-9.04,-8.77,-8.92,-9.04,-9.12,-9.10,-9,-8.92,-9.36,-9.89,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.50,-9.42,-9.88,-10,-11,-11,-12,-12,-12,-13,-12,-12,-11,-10,-10,-9.41,-8.55,-7.17,-6,-4.88,-3.97,-3.43,-3,-2.50,-2.01,-1.64,-1.50,-1.63,-1.88,-2.13,-2.28,-2.26,-1.99,-1.28,-0.23,1.12,2.40,3.41,3.63,3.22,2.16,2.20,2.23,2.76,3.21,3.71,4.13,5.12,6.64,8.64,9.62,10.21,10.25,10.25,10.75,11.66,12.87,14.62,14.62,13.62,12.50,10.53,9.25,8.40,8.10,8,8.08,8.25,8.37,8.45,8.39,8.25,8.03,7.75,7.40,7.07,6.73,6.38,6.10,5.84,5.60,5.37,5.20,5,4.85,4.65,4.50,4.34,4.15,4,3.83,3.63,3.48,3.32,3.13,3,2.85,2.70,2.53,2.38,2.25,2.11,1.97,1.82,1.64,1.50,1.36,1.23,1.12,1.02,1,0.98,0.97,0.96,0.89,0.82,0.57,0.25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.25,0.41,0.62,0.85,1.01,1.20,1.37,1.61,1.84,1.96,1.99,2,2.11,2,3,3,3,4,4,4,5,6,7,10,13,15,14,11,8,8,9,10,11,13,15,18,22,25,27,29,30,30,27,24,19,15,11.12,10.17,9.25,9.03,9.02,9.22,10.04,11.64,14.37,15.37,12.67,10.61,8.59,8.16,7.51,7.22,7.07,7,7,6.99,6.95,-7.88,-8.61,-9.28,-9.90,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-12,-11,-11,-11,-11,-11,-10,-10,-9.90,-9.38,-9.11,-9.36,-9.63,-9.99,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.78,-9.42,-9.09,-9.12,-9.24,-9.27,-9.26,-9.17,-9.02,-8.88,-9.38,-9.79,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.61,-9.22,-9.72,-10,-11,-11,-12,-12,-13,-13,-12,-12,-11,-10,-9.72,-8.93,-7.90,-6.74,-5.60,-4.61,-3.80,-3.35,-2.87,-2.27,-1.63,-1,-0.78,-1,-1.28,-1.54,-1.67,-1.63,-1.28,-0.68,0.20,1.16,2.20,3.12,4.25,4.78,2.87,2.02,1.22,1.90,2.25,3.25,4.71,5.70,6.99,8.25,9.34,10.62,10.11,10.13,10.37,11.37,12.85,14.62,15.62,14.62,13.62,12.46,11.37,10.38,9.87,9.61,9.46,9.37,9.26,9.13,8.96,8.66,8.35,7.98,7.59,7.21,6.85,6.50,6.21,5.95,5.71,5.50,5.28,5.12,4.96,4.77,4.62,4.46,4.25,4.10,3.90,3.74,3.57,3.37,3.23,3.07,2.88,2.75,2.60,2.45,2.27,2.12,1.99,1.84,1.66,1.51,1.37,1.25,1.12,1.03,1,0.98,0.96,0.96,0.88,0.76,0.58,0.32,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.13,0.28,0.50,0.72,0.90,1.12,1.32,1.50,1.72,1.91,1.98,2,2,2,3,3,3,4,4,4,5,6,7,8,12,15,17,15,13,9,9,10,11,12,14,16,20,23,26,29,31,31,30,28,24,20,15,12.12,10.21,9.25,9.15,9.09,9.24,9.54,11.09,12.49,13.37,13.37,12.38,10.35,8.87,7.90,7.35,7.10,7,7,6.99,6.95,-7.88,-8.66,-9.38,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.92,-9.63,-9.51,-9.50,-9.79,-10,-10,-11,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-10,-10,-9.78,-9.40,-9.24,-9.34,-9.39,-9.38,-9.28,-9.13,-8.87,-8.74,-9.13,-9.64,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-9.79,-9.76,-9.79,-10,-11,-12,-13,-14,-14,-14,-13,-12,-11,-10,-9.79,-8.63,-7.30,-6.14,-5.12,-4.25,-3.62,-3.25,-2.78,-2.22,-1.50,-0.77,-0.48,-0.63,-0.78,-0.92,-0.98,-0.87,-0.55,-0.12,0.51,1.21,1.97,2.71,3.33,3.83,3.85,1.16,1.21,1.23,1.90,2.82,4.22,5.87,7.28,8.32,9.25,9.64,9.75,9.85,10.32,11.22,12.36,13.84,14.77,15.12,14.86,14.62,13.65,12.82,11.96,11.35,10.87,10.50,10.13,9.82,9.45,9.01,8.61,8.14,7.73,7.33,6.95,6.60,6.27,6.01,5.78,5.60,5.39,5.23,5.07,4.88,4.73,4.53,4.37,4.20,4,3.83,3.63,3.47,3.27,3.12,2.96,2.77,2.62,2.48,2.33,2.15,2,1.87,1.71,1.53,1.39,1.25,1.13,1.07,1,0.98,0.97,0.95,0.87,0.75,0.58,0.34,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.10,0.22,0.37,0.60,0.82,1.02,1.25,1.45,1.63,1.82,1.98,2,2,2,2,3,3,3,4,4,4,5,7,8,10,13,17,18,17,14,11,10,11,12,13,15,18,22,26,30,33,35,35,32,30,27,23,18,13.12,11.20,9.97,9.28,9.09,9.12,9.50,10.14,11.08,12.10,13.37,13.38,11.40,9.46,8.14,7.45,7.12,7,7,6.99,6.95,-7.88,-8.64,-9.37,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.97,-9.75,-9.63,-9.85,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.73,-9.38,-9.36,-9.41,-9.39,-9.28,-9.11,-8.86,-8.63,-8.80,-9.11,-9.67,-10,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-10,-9.84,-10,-11,-13,-14,-14,-14,-14,-13,-12,-11,-10,-9.10,-7.79,-6.55,-5.50,-4.55,-3.87,-3.39,-3.14,-2.78,-2.27,-1.63,-1.01,-0.62,-0.43,-0.41,-0.39,-0.29,-0.14,0.10,0.37,0.76,1.20,1.73,2.24,2.52,2.12,1.12,1.14,1.03,1.14,1.23,2.25,3.25,6,8.71,9.70,9.25,9.25,9.34,9.34,10.14,11.03,12.14,13.36,14.73,15.62,16.09,16.14,16.62,15.35,14.03,12.99,12.20,11.52,10.96,10.37,9.85,9.33,8.78,8.28,7.84,7.38,7,6.65,6.37,6.11,5.87,5.66,5.50,5.33,5.14,4.99,4.83,4.63,4.47,4.26,4.10,3.89,3.72,3.51,3.35,3.15,3,2.83,2.64,2.50,2.35,2.16,2.01,1.87,1.73,1.59,1.41,1.27,1.15,1.08,1,0.98,0.97,0.95,0.87,0.75,0.57,0.36,0.15,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.14,0.28,0.50,0.72,0.96,1.16,1.38,1.61,1.75,1.89,2,2,2,2,2,3,3,3,4,4,5,6,7,9,11,16,20,20,19,16,12,12,12,14,15,17,21,26,31,36,40,41,39,35,32,29,25,18,14.10,11.91,10.24,9.34,9.07,9.07,9.21,9.47,9.59,10.60,12.39,12.40,11.42,9.52,8.21,7.41,7.11,7,7,6.99,6.96,-7.77,-8.60,-9.28,-9.90,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.98,-9.91,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-9.93,-9.53,-9.29,-9.38,-9.37,-9.25,-9.13,-9,-8.88,-8.68,-9.02,-9.48,-9.84,-10,-10,-10,-11,-11,-11,-11,-11,-10,-10,-9.92,-10,-11,-12,-14,-15,-15,-14,-13,-12,-12,-10,-9.30,-8,-6.72,-5.75,-4.88,-4.11,-3.52,-3.25,-3.11,-2.87,-2.42,-1.84,-1.23,-0.68,-0.36,-0.13,0.07,0.24,0.38,0.57,0.72,0.88,1.12,1.48,1.88,2.15,1.88,1.12,1.02,1.03,1.16,1.22,2.23,3.25,6.25,9.73,9.71,9.27,9.09,9.09,9.32,10.07,11,11.95,13.25,14.76,16.64,17.28,17.84,17.78,17.62,15.71,14.47,13.37,12.45,11.62,10.85,10.14,9.51,8.96,8.39,7.89,7.47,7.07,6.73,6.40,6.15,5.95,5.75,5.58,5.38,5.24,5.08,4.88,4.73,4.52,4.36,4.15,3.98,3.77,3.60,3.39,3.22,3.02,2.86,2.70,2.50,2.36,2.21,2.03,1.88,1.75,1.61,1.46,1.32,1.16,1.09,1,0.99,0.97,0.90,0.85,0.72,0.52,0.36,0.16,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.25,0.41,0.62,0.85,1.08,1.33,1.53,1.75,1.87,1.99,2,2,2,2,3,3,3,3,4,5,5,6,8,10,13,19,21,22,20,17,14,13,15,16,19,22,26,31,35,41,45,45,41,35,30,27,23,18,15.07,12.14,10.21,9.28,9.04,9,9,8.97,9.09,9.57,10.40,11.45,10.47,9.12,8.03,7.37,7.11,7,7,6.99,6.97,-7.63,-8.41,-9.13,-9.80,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-11,-11,-10,-10,-9.66,-9.27,-9.24,-9.22,-9.22,-9.18,-9.13,-9.13,-9.13,-9.15,-9.43,-9.75,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-11,-12,-13,-15,-16,-16,-14,-12,-12,-11,-9.86,-8.50,-6.87,-5.52,-5.04,-4.38,-3.78,-3.38,-3.14,-3.04,-2.88,-2.51,-1.97,-1.25,-0.62,-0.12,0.25,0.48,0.62,0.75,0.84,0.88,0.96,1.08,1.25,1.62,2.11,2.91,1.11,1.12,1.13,1.15,2.16,2.22,4.23,7.75,9.74,9.73,9.24,9.02,9.02,9.28,10.03,11,12.07,12.32,15.32,17.25,18.66,19.66,19.70,18.13,16.98,15.60,14.36,13.14,12.12,11.21,10.37,9.66,9.02,8.47,7.96,7.50,7.10,6.75,6.46,6.21,6,5.78,5.62,5.47,5.28,5.12,4.97,4.77,4.61,4.41,4.24,4.03,3.86,3.63,3.46,3.25,3.08,2.87,2.72,2.52,2.37,2.22,2.07,1.89,1.75,1.62,1.48,1.34,1.20,1.10,1,0.99,0.96,0.89,0.83,0.70,0.51,0.36,0.20,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.11,0.24,0.38,0.58,0.75,0.96,1.15,1.41,1.78,1.88,1.98,2,2,2,2,2,3,3,3,3,4,5,6,7,9,12,15,19,22,22,19,17,15,16,18,21,25,29,33,37,42,46,49,46,41,34,28,24,20,18,16.01,13.88,10.16,9.24,9.02,8.99,8.90,8.75,8.50,8.51,9.22,9.46,9.21,8.45,7.86,7.33,7.10,7.01,7,7,6.99,-7.38,-8.16,-8.99,-9.76,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.84,-9.35,-9.04,-9.13,-9.25,-9.34,-9.39,-9.47,-9.55,-9.59,-9.51,-9.55,-9.76,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-11,-12,-13,-14,-15,-16,-16,-14,-13,-11,-10,-9.13,-7.75,-6.13,-5.03,-4.59,-4.10,-3.63,-3.28,-3.12,-3.01,-2.84,-2.48,-1.85,-1,-0.25,0.37,0.75,0.91,0.98,0.98,0.98,0.98,0.98,1,1.12,1.27,2,2.96,2.09,2.11,2.12,2.13,3.15,4.78,6.77,7.95,9.75,9.25,9.14,9.07,9.08,9.27,10.09,11.16,12.27,14.27,16.71,18.71,19.71,19.87,19.71,18.84,17.75,16.70,15.10,13.71,12.47,11.39,10.50,9.75,9.10,8.50,7.98,7.50,7.12,6.76,6.49,6.24,6.01,5.85,5.66,5.50,5.36,5.20,5,4.85,4.65,4.49,4.28,4.11,3.89,3.71,3.50,3.28,3.11,2.90,2.74,2.53,2.37,2.23,2.08,1.91,1.77,1.63,1.50,1.35,1.22,1.11,1.01,0.99,0.95,0.87,0.78,0.65,0.50,0.35,0.20,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.07,0.16,0.37,0.53,0.73,0.87,1,1.15,1.49,1.85,2,2,2,2,2,2,2,3,3,3,4,5,6,7,9,11,15,17,19,18,18,17,16,17,19,22,26,30,34,37,40,44,49,50,46,39,33,28,23,21,19,18,14.92,11.12,9.17,9.02,8.99,8.89,8.65,8.40,8.32,8.40,8.45,8.38,8.13,7.71,7.25,7.08,7.09,7.04,7.01,7,-7.11,-7.97,-8.80,-9.61,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.34,-9,-9.15,-9.36,-9.50,-9.64,-9.77,-9.88,-9.88,-9.88,-9.74,-9.54,-9.54,-9.53,-10,-10,-10,-11,-11,-10,-11,-12,-13,-13,-14,-15,-15,-16,-15,-12,-11,-10,-8.05,-6.65,-5.55,-4.72,-4.27,-3.86,-3.49,-3.24,-3.10,-3,-2.78,-2.25,-1.51,-0.53,0.37,1.11,1.46,1.50,1.37,1.22,1.10,1.01,1,1,1,1,2,2,3.95,4.89,4.87,4.12,5.85,6.83,7.15,8.77,8.76,9,9.15,9.25,9.25,9.25,10.25,11.25,13.26,16.72,18.72,19.99,20.73,20.25,19.86,19.25,18.75,17.24,15.73,14.12,12.62,11.46,10.52,9.76,9.11,8.50,7.99,7.50,7.12,6.76,6.50,6.25,6.03,5.87,5.72,5.57,5.38,5.24,5.08,4.88,4.72,4.52,4.35,4.14,3.96,3.75,3.53,3.35,3.12,2.95,2.75,2.58,2.37,2.23,2.09,1.95,1.82,1.65,1.50,1.36,1.22,1.11,1.01,0.98,0.91,0.87,0.77,0.64,0.50,0.36,0.20,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.11,0.27,0.50,0.72,0.85,0.91,1,1.11,1.13,2,2,2,2,2,2,2,2,3,3,3,4,5,7,8,11,13,16,17,16,16,16,16,17,20,23,27,31,34,37,38,40,44,49,50,46,39,34,30,26,22,21,20,16,11.07,9.12,9.13,9,8.90,8.65,8.36,8.13,8.10,8.10,8.07,7.98,7.75,7.15,7.09,7.04,7.97,8,8,-6.99,-7.80,-8.54,-9.34,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-10,-9.47,-9.11,-9.25,-9.48,-9.67,-9.89,-10,-10,-10,-10,-10,-9.77,-9.54,-9.26,-9.59,-10,-11,-11,-11,-10,-11,-12,-13,-13,-14,-15,-16,-15,-14,-12,-11,-9.72,-7.40,-5.90,-4.63,-4.43,-4,-3.63,-3.36,-3.15,-3.04,-2.98,-2.73,-2.13,-1.15,-0.01,1.13,2,2.35,2.16,1.89,1.52,1.25,1.12,1.01,0.99,0.99,1,1,2,3,5.91,5.89,5.87,5.95,6.85,7.08,7.82,8.20,8.87,9.22,10.22,10.24,11.25,11.25,13.25,16.88,19.13,20.74,21.74,21.75,20.85,20.21,19.75,18.96,17.91,16.77,14.24,12.47,11.37,10.49,9.75,9.10,8.50,7.98,7.50,7.12,6.76,6.50,6.25,6.08,5.88,5.74,5.59,5.41,5.25,5.11,4.91,4.75,4.58,4.37,4.21,4,3.78,3.59,3.37,3.15,2.98,2.75,2.59,2.38,2.24,2.09,1.96,1.83,1.66,1.50,1.37,1.22,1.11,1.01,0.98,0.91,0.87,0.76,0.64,0.50,0.36,0.21,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.16,0.45,0.73,0.87,0.95,0.98,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,6,7,10,12,15,16,15,14,15,16,17,19,22,27,33,36,37,36,35,38,44,49,51,48,42,37,33,29,25,23,22,17,12,10.07,9.11,9,8.92,8.75,8.27,8.07,8,8,7.98,7.95,7.85,7.08,7.04,7.98,8,9,9,-6.97,-7.65,-8.39,-9.03,-9.63,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.65,-9.22,-9.26,-9.63,-9.89,-10,-10,-10,-10,-10,-10,-9.99,-9.73,-9.88,-9.90,-10,-10,-11,-11,-11,-10,-12,-13,-14,-13,-15,-15,-15,-14,-11,-10,-9.25,-7.86,-5.76,-4.92,-4.11,-3.77,-3.39,-3.25,-3.12,-3.01,-2.91,-2.63,-2,-0.97,0.32,1.61,2.70,3.13,3.07,2.62,2.02,1.52,1.20,1.01,1,1,1,1,2,3,4,5.95,5.89,5.87,5.87,6.12,6.88,7.83,8.82,10.20,12.13,13.22,14.22,15.23,18.21,20.75,22.75,22.75,22.23,21.75,21.07,20.76,19.84,19.77,18.78,16.82,14.15,12.16,11.15,10.39,9.71,9.03,8.48,7.96,7.50,7.10,6.75,6.49,6.25,6.08,5.89,5.75,5.61,5.46,5.28,5.12,4.97,4.77,4.62,4.41,4.24,4.02,3.84,3.62,3.40,3.21,3,2.77,2.60,2.38,2.24,2.09,1.96,1.84,1.70,1.51,1.37,1.22,1.11,1.01,0.98,0.91,0.87,0.76,0.64,0.51,0.36,0.21,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,6,9,11,13,15,15,14,14,15,16,18,20,25,31,36,38,37,34,34,38,45,50,52,48,43,38,34,30,26,24,21,17,12,10,9.01,9,8.96,8.87,8.15,8.02,7.99,7.98,7.97,7.95,7.96,7.02,7,8,9,11,10,-6.92,-7.64,-8.26,-8.80,-9.38,-9.88,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-9.93,-9.59,-9.47,-9.76,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-11,-12,-13,-13,-13,-14,-15,-14,-13,-11,-10,-9.28,-8.09,-6.49,-5.40,-4.49,-3.38,-3.34,-3.14,-3.09,-3,-2.88,-2.54,-1.90,-0.89,0.39,1.78,3.12,4.01,4.16,3.62,2.87,1.88,1.22,1,1,1,1,1,2,2,3,4,4.99,5.07,5.09,5.11,6.12,7,8.13,10.83,15.83,17.82,19.78,21.78,22.77,23.77,23.77,23.77,22.77,21.77,20.87,20.10,19.82,18.83,17.83,16.85,14.12,12.12,11.07,10.33,9.62,9,8.41,7.89,7.47,7.08,6.75,6.48,6.25,6.08,5.90,5.75,5.62,5.48,5.32,5.13,4.99,4.82,4.62,4.46,4.25,4.08,3.87,3.64,3.46,3.24,3,2.78,2.60,2.38,2.23,2.09,1.96,1.84,1.71,1.53,1.37,1.23,1.11,1.01,0.98,0.91,0.87,0.76,0.64,0.51,0.36,0.21,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,5,7,10,12,13,13,13,13,14,15,17,19,23,29,34,37,38,35,33,34,39,46,52,52,47,42,37,32,28,25,22,19,16,13,11,9,9,9,8.97,8.07,8,7.99,7.99,7.99,7.98,7.89,7.07,7.02,8,10,11,11,-6.85,-7.52,-8.14,-8.75,-9.23,-9.75,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-13,-13,-12,-11,-11,-10,-10,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-13,-13,-13,-13,-12,-13,-12,-13,-13,-14,-14,-13,-12,-11,-10,-8.49,-6.89,-5.73,-4.90,-3.98,-3.39,-3.15,-3.09,-3,-2.86,-2.51,-1.90,-0.99,0.22,1.52,2.84,4,4.75,4.72,4,3.16,2.24,1.20,1,1,1,1,1,2,3,4,4,4.96,4.91,4.89,5.10,6.11,7.12,9.87,13.85,18.84,22.83,24.83,24.83,24.82,23.82,22.85,22.15,21.83,20.15,19.15,18.84,17.95,16.95,15.87,13.87,12.10,11,10.10,9.63,9,8.37,7.86,7.39,7.02,6.73,6.47,6.25,6.07,5.90,5.76,5.62,5.49,5.34,5.14,5,4.83,4.63,4.48,4.27,4.10,3.88,3.70,3.49,3.25,3.02,2.83,2.61,2.38,2.22,2.08,1.96,1.86,1.72,1.53,1.37,1.23,1.11,1.01,0.98,0.91,0.87,0.77,0.66,0.51,0.36,0.21,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,5,7,10,12,12,12,12,12,14,16,18,22,27,32,37,38,37,34,32,34,39,48,54,54,49,44,39,34,30,25,20,18,15,12,11,9,9,8.98,8.88,8.13,8,7.99,7.99,7.98,7.96,7.83,7.13,7.11,8.04,10,11,10,-6.65,-7.38,-8,-8.59,-9.14,-9.75,-10,-10,-11,-11,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-12,-14,-15,-15,-14,-13,-12,-12,-12,-12,-12,-13,-13,-13,-12,-11,-8.75,-7.13,-6.11,-5.35,-4.27,-3.41,-3.22,-3.12,-3,-2.86,-2.53,-2,-1.15,-0.11,1.12,2.41,3.73,4.82,5.33,5.12,4.49,3.71,2.78,2.27,1.98,1,1,1,2,3,4,4,4,4,4.02,4.91,5.09,6.10,7.11,10.12,15.12,21.87,24.86,24.85,23.85,22.95,22,21.13,20.85,19.12,18.12,17.87,16.87,15.97,14.88,13.09,12.07,11,10,9.87,8.89,8.32,7.77,7.37,7,6.71,6.45,6.23,6.03,5.90,5.77,5.63,5.50,5.34,5.15,5,4.84,4.65,4.49,4.32,4.12,3.90,3.73,3.50,3.27,3.07,2.84,2.61,2.38,2.22,2.08,1.97,1.86,1.73,1.53,1.37,1.23,1.11,1.01,0.98,0.91,0.87,0.77,0.70,0.51,0.36,0.21,0.10,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,5,8,11,12,12,11,11,12,14,17,21,26,31,36,39,39,35,32,31,34,40,48,54,57,54,50,45,39,33,26,20,17,14,12,11,9,9,8.97,8.79,8.27,8.10,8,7.98,7.96,7.89,7.71,7.32,7.23,8.12,8.92,9,9,-6.48,-7.14,-7.78,-8.39,-9.09,-9.75,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-11,-13,-14,-15,-15,-15,-14,-13,-11,-10,-10,-11,-12,-13,-13,-13,-11,-9.62,-6.98,-6.23,-5.50,-4.41,-3.59,-3.25,-3.12,-3,-2.88,-2.61,-2.13,-1.41,-0.49,0.63,1.87,3.16,4.39,5.49,5.97,5.65,5.15,4.72,4.13,3.34,2,2,1,2,3,4,4,4,4,4,4.97,5.02,6,7.08,9.09,13.10,18.87,22.87,23.87,22.98,22,21,20.12,19.11,18.11,17.87,16.10,15.89,14.97,13.91,12.96,11.97,10.98,10,9,8.83,8.26,7.75,7.33,6.98,6.63,6.39,6.21,6.02,5.89,5.78,5.64,5.50,5.35,5.16,5,4.85,4.66,4.50,4.33,4.12,3.95,3.75,3.51,3.32,3.09,2.85,2.62,2.38,2.20,2.07,1.97,1.86,1.73,1.53,1.37,1.23,1.11,1.01,0.98,0.91,0.87,0.78,0.70,0.51,0.35,0.20,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,6,8,11,12,11,11,11,12,14,17,23,28,34,38,39,36,32,29,30,34,39,45,52,55,56,54,48,42,34,27,21,17,14,12,11,9.04,9,8.87,8.64,8.39,8.17,8.07,8.01,8,7.99,7.91,7.86,7.91,8.12,8.14,8.04,8,-6.23,-6.86,-7.50,-8.23,-8.97,-9.74,-10,-10,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-14,-15,-16,-16,-16,-14,-13,-11,-9.75,-10,-11,-12,-13,-12,-11,-9.38,-7.26,-6.11,-5.38,-4.35,-3.52,-3.24,-3.11,-3.01,-2.90,-2.68,-2.30,-1.73,-0.89,0.11,1.23,2.39,3.62,4.86,5.50,5.76,5.89,5.96,6.36,5,3.53,2.12,2,2,3,4,4,4,4,4,5,5,6,7.02,9.03,13.07,17.98,21.90,22.89,22.09,21.09,20.09,19.09,18.09,17.08,16.07,15.07,14.95,13.98,12.99,12,11,10,10,9,8.90,8.23,7.71,7.33,6.98,6.64,6.37,6.14,6,5.90,5.78,5.66,5.50,5.36,5.16,5,4.86,4.70,4.50,4.34,4.13,3.96,3.75,3.53,3.33,3.10,2.87,2.62,2.37,2.20,2.07,1.97,1.87,1.73,1.57,1.37,1.23,1.12,1.01,0.98,0.91,0.87,0.82,0.66,0.50,0.34,0.16,0.08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,6,9,11,11,10,10,11,12,16,20,26,32,36,38,36,33,29,27,29,33,38,43,48,53,54,53,50,43,35,28,22,18,14,12,10.97,9.11,9.14,8.92,8.70,8.47,8.28,8.20,8.17,8.23,8.32,8.36,8.45,8.51,8.45,8.29,8.13,7.97,-6.05,-6.60,-7.25,-8,-8.88,-9.63,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-13,-14,-14,-15,-15,-15,-15,-15,-16,-16,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-12,-12,-14,-15,-16,-16,-16,-15,-13,-11,-9.91,-10,-10,-11,-12,-11,-10,-8.72,-7.28,-5.88,-4.92,-4.02,-3.34,-3.15,-3.09,-3.02,-2.98,-2.85,-2.60,-2.13,-1.42,-0.51,0.49,1.51,2.51,3.40,4.14,4.83,5.37,5.87,6.75,5.86,4.62,3.50,2.24,2,3,4,5,5,5,4,5,5,6,8,10,14,17.97,21.96,21.96,21.02,20.96,19.96,18.96,17.02,16.02,15.97,14.98,13.98,13,12,11,11,10,10,9,9,8.12,7.73,7.34,6.99,6.66,6.38,6.14,6,5.90,5.84,5.71,5.52,5.36,5.16,5,4.87,4.72,4.52,4.36,4.14,3.97,3.76,3.57,3.34,3.11,2.87,2.62,2.37,2.21,2.07,1.97,1.87,1.74,1.57,1.37,1.24,1.12,1.01,0.98,0.91,0.88,0.83,0.66,0.50,0.33,0.14,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,3,4,6,7,5,4,4,5,6,9,11,10,10,10,11,14,20,25,30,34,36,34,31,28,26,26,28,32,37,41,46,49,51,51,50,43,37,30,24,19,15,12,11,10.07,9.45,9.09,8.77,8.57,8.40,8.36,8.40,8.54,8.78,9.04,9.02,9.62,9.63,9.41,10.12,9.89,-5.85,-6.38,-7.10,-7.79,-8.74,-9.63,-10,-11,-11,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-14,-15,-16,-17,-16,-15,-13,-11,-11,-10,-11,-10,-11,-10,-9.36,-8.18,-6.89,-5.30,-4.15,-3.62,-3.05,-3.10,-3.05,-3.02,-3,-2.89,-2.73,-2.38,-1.80,-1.12,-0.30,0.50,1.25,1.96,2.60,3.22,3.85,4.50,4.87,5.37,5.02,4.48,3.50,3.25,4,5,6,6,5,5,5,6,7,8,11,14,19,21,21,20,20,19,18,17,16,15,14,13,12,12,11,10,10,10,9,9,8,7.84,7.26,6.97,6.70,6.39,6.14,6,5.90,5.84,5.71,5.52,5.35,5.15,5,4.87,4.73,4.53,4.36,4.14,3.97,3.76,3.58,3.35,3.11,2.87,2.62,2.38,2.21,2.08,1.98,1.87,1.74,1.57,1.37,1.24,1.12,1.01,0.99,0.95,0.89,0.84,0.70,0.50,0.32,0.13,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0.01,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,3,4,6,8,8,6,5,4,5,6,8,10,10,10,10,13,18,24,30,33,34,33,30,27,25,24,25,27,31,36,40,44,47,49,50,49,45,39,33,26,20,16,13,11.17,10.49,9.75,9.27,8.96,8.75,8.63,8.64,8.76,9.07,9.47,10.03,10.64,11.10,11.82,12.27,12.37,12.83,-5.55,-6.22,-6.92,-7.86,-8.77,-9.66,-10,-11,-12,-12,-13,-14,-14,-14,-14,-15,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-16,-17,-17,-17,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-14,-16,-17,-17,-17,-15,-13,-11,-11,-11,-11,-11,-10,-10,-8.88,-7.50,-6.22,-4.76,-3.63,-3.03,-3.03,-3.04,-3.09,-3.05,-3.02,-2.98,-2.84,-2.59,-2.17,-1.64,-1.09,-0.50,0.03,0.51,1,1.51,2.09,2.62,3.15,3.75,5.21,4.76,5.03,5.09,5.75,8,8,7,6,6,6,7,8,9,11,15,18,19,20,19,19,19,18,18,16,15,14,13,12,11,11,10,10,10,9,9,8,7.96,7.15,6.90,6.66,6.38,6.14,6,5.89,5.82,5.66,5.50,5.33,5.13,5,4.87,4.73,4.53,4.36,4.14,3.97,3.76,3.58,3.35,3.11,2.87,2.62,2.37,2.21,2.08,1.98,1.87,1.74,1.57,1.37,1.23,1.11,1.01,0.99,0.98,0.91,0.85,0.71,0.50,0.32,0.12,0.02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.21,0.15,0.12,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,3,5,7,9,8,6,5,5,5,6,6,8,8,10,14,17,23,28,32,33,31,28,25,23,22,21,23,26,30,34,41,44,45,47,49,49,47,40,33,27,22,18,14.02,12.37,10.70,9.97,9.58,9.25,9.08,9.02,9.12,9.37,9.66,10.50,11.36,12.26,13.25,14.11,15.22,15.51,14.74,-5.38,-5.98,-6.88,-7.93,-8.93,-9.85,-10,-11,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-16,-17,-17,-18,-18,-18,-18,-18,-17,-18,-17,-17,-18,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-15,-16,-17,-17,-16,-15,-13,-12,-12,-11,-11,-11,-11,-10,-8.78,-7.01,-5.72,-4.50,-3.50,-3.02,-3,-3.12,-3.13,-3.13,-3.13,-3.05,-2.97,-2.76,-2.50,-2.14,-1.75,-1.40,-1.11,-0.77,-0.40,0,0.38,0.86,1.41,2.07,3,4.46,6.11,5.84,6.59,7.87,9,8,7,7,7,8,9,10,12,15,17,18,19,18,18,19,18,17,16,15,14,12,11,11,11,10,10,9,9,9,8,8,7.02,6.87,6.64,6.37,6.13,5.99,5.87,5.75,5.62,5.45,5.25,5.12,4.98,4.85,4.71,4.51,4.35,4.13,3.97,3.75,3.58,3.35,3.11,2.87,2.62,2.37,2.21,2.08,1.98,1.87,1.74,1.57,1.37,1.22,1.10,1,0.99,0.98,0.97,0.87,0.73,0.50,0.28,0.12,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.24,0.73,0.75,0.77,0.13,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,2,2,3,5,8,9,7,6,5,5,5,6,7,7,10,14,18,22,26,30,30,28,26,23,21,20,20,21,23,25,28,34,40,42,44,46,48,51,48,43,36,30,24,19,16.10,13.36,11.60,10.57,10.03,9.77,9.70,9.77,10.01,10.37,11,11.86,12.91,14.07,15.22,16.83,17.09,16.40,15.67,-5.22,-5.97,-7,-8.01,-9,-9.89,-10,-11,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-17,-17,-18,-18,-19,-19,-19,-19,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-15,-15,-15,-16,-17,-17,-16,-15,-14,-13,-12,-11,-10,-11,-10,-10,-9.24,-7.24,-6.04,-5.22,-4.53,-3.43,-3.14,-3.34,-3.28,-3.28,-3.26,-3.23,-3.13,-2.98,-2.76,-2.54,-2.36,-2.14,-1.97,-1.75,-1.50,-1.23,-0.92,-0.53,0,0.50,1.66,2.89,4.33,5.14,5.52,6.73,7,9,9,8,8,9,10,11,12,14,16,17,17,17,17,17,17,16,15,14,13,12,11,11,10,10,9,9,9,9,8,8,7,6.96,6.62,6.35,6.11,5.91,5.78,5.64,5.50,5.35,5.20,5.03,4.91,4.78,4.64,4.49,4.28,4.12,3.95,3.75,3.53,3.34,3.11,2.87,2.62,2.37,2.20,2.08,1.98,1.87,1.75,1.58,1.37,1.21,1.09,1,0.99,0.98,0.97,0.95,0.76,0.50,0.26,0.11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.24,0.71,0.73,0.23,0.12,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,5,7,9,7,6,6,6,6,7,8,10,14,19,24,27,28,27,25,23,20,19,18,18,19,20,22,25,28,33,37,40,42,46,51,54,52,49,42,34,27,22,17.15,13.59,11.89,11.23,10.66,10.47,10.51,10.79,11.20,11.72,12.26,13.37,14.46,15.64,17.37,17.67,16.97,16.25,15.64,-5.12,-6.05,-7.15,-8.15,-9.11,-10,-10,-11,-12,-13,-14,-14,-15,-15,-15,-16,-16,-17,-17,-17,-18,-18,-19,-19,-20,-20,-20,-19,-19,-19,-19,-19,-19,-18,-18,-18,-19,-19,-19,-19,-19,-18,-18,-18,-18,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-16,-16,-16,-16,-16,-16,-14,-14,-13,-12,-10,-10,-10,-10,-10,-9.42,-7.91,-6.61,-6.23,-5.54,-4.74,-3.92,-3.98,-3.85,-3.75,-3.63,-3.47,-3.29,-3.14,-3.01,-2.88,-2.76,-2.63,-2.51,-2.38,-2.23,-2.01,-1.78,-1.49,-1,-0.49,0.46,1.47,2.38,3.15,3.84,4.37,6,8,10,9,9,9,10,11,12,13,15,16,17,17,16,16,16,15,15,14,13,12,11,10,10,9,9,9,9,8,8,8,7,7,6.59,6.25,6.01,5.85,5.70,5.52,5.37,5.24,5.11,4.99,4.87,4.74,4.59,4.40,4.25,4.09,3.89,3.72,3.50,3.28,3.09,2.87,2.62,2.37,2.20,2.07,1.98,1.87,1.75,1.58,1.37,1.16,1.03,1,0.99,0.98,0.98,0.95,0.84,0.59,0.13,0.07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.02,0.07,0.15,0.26,0.25,0.13,0.01,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,2,2,2,2,2,3,3,5,7,9,8,7,6,7,7,9,12,15,18,23,27,29,26,23,21,18,17,16,16,17,18,20,22,25,28,32,37,40,44,48,52,54,54,51,44,36,30,24,18.22,14.62,13.03,11.90,11.34,11.25,11.58,12.09,12.72,13.37,14.11,14.92,15.88,16.96,18.16,17.63,17.08,16.11,14.64,-5.09,-6.13,-7.25,-8.26,-9.25,-10,-11,-12,-12,-13,-14,-15,-15,-16,-16,-17,-17,-17,-18,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-20,-19,-19,-19,-18,-18,-18,-18,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-16,-16,-16,-15,-14,-13,-12,-11,-11,-10,-10,-10,-10,-9.40,-8.22,-7.65,-7.26,-6.91,-6.01,-5.10,-5.03,-4.86,-4.63,-4.35,-4,-3.72,-3.48,-3.28,-3.14,-3.03,-2.97,-2.87,-2.76,-2.65,-2.51,-2.35,-2.10,-1.72,-1.26,-0.55,0.21,0.83,1.35,2.02,3.12,4.02,7,10,11,10,10,10,11,12,13,14,15,16,16,16,16,15,15,14,13,12,11,11,10,10,9,9,9,8,8,8,7,7,7,6.37,6.12,5.89,5.73,5.53,5.38,5.25,5.12,5,4.88,4.75,4.62,4.49,4.34,4.16,4.01,3.86,3.64,3.45,3.24,3.03,2.86,2.62,2.37,2.20,2.07,1.98,1.87,1.75,1.58,1.36,1.12,1,1,0.99,0.99,0.99,0.96,0.86,0.59,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.12,0.24,0.33,0.34,0.34,0.26,0.16,0.07,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,3,4,5,7,9,9,7,7,8,10,13,16,19,22,25,27,26,23,19,17,16,15,15,15,16,17,19,24,28,32,36,40,45,48,49,51,52,51,48,45,39,33,26,20.25,15.67,13.86,12.52,11.87,12.13,12.74,13.57,14.47,15.25,15.90,16.50,17.14,17.84,18.07,17.75,17.04,16.14,14.66,-5.10,-6.13,-7.25,-8.30,-9.38,-10,-11,-12,-13,-14,-14,-15,-15,-16,-16,-17,-18,-18,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-15,-14,-13,-12,-12,-12,-11,-11,-11,-11,-10,-9.97,-9.01,-8.63,-8.67,-8.26,-7.25,-6.59,-6.27,-6.03,-5.75,-5.34,-4.84,-4.37,-3.98,-3.67,-3.49,-3.34,-3.22,-3.12,-3.01,-2.91,-2.80,-2.66,-2.50,-2.23,-1.88,-1.38,-0.79,-0.26,0.27,1,2,4.25,6.96,9,11,10,10,10,11,12,13,14,15,16,16,16,15,14,14,13,13,12,11,10,10,10,9,9,8,8,8,7,7,7,6,6.13,5.97,5.76,5.58,5.38,5.25,5.12,5,4.89,4.77,4.64,4.50,4.37,4.24,4.11,3.97,3.77,3.59,3.36,3.14,3,2.83,2.61,2.37,2.20,2.07,1.98,1.88,1.78,1.61,1.35,1.12,1,0.99,0.99,0.99,0.99,0.96,0.85,0.60,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.24,0.34,0.35,0.62,0.62,0.64,0.64,0.65,0.28,0.12,0,0,0,0,0,0,0,1,0,0,0,1,1,1,2,2,2,2,2,2,3,3,4,5,7,9,10,9,8,9,13,18,21,22,23,23,23,20,18,15,14,13,14,14,14,15,17,21,26,32,37,42,44,47,49,49,49,50,48,47,45,42,35,28,21.29,16.75,14.22,13.21,12.75,13.08,13.99,15.15,16.35,17.38,17.63,17.89,18.24,18.42,18.32,17.79,16.99,16.12,14.66,-5.13,-6.11,-7.13,-8.35,-9.39,-10,-11,-12,-13,-14,-14,-15,-16,-16,-17,-18,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-13,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.85,-9.15,-8.51,-7.98,-7.27,-7.30,-7,-6.42,-5.80,-5.22,-4.67,-4.27,-3.98,-3.74,-3.51,-3.37,-3.24,-3.13,-3,-2.88,-2.75,-2.63,-2.36,-2,-1.52,-1.09,-0.50,0.32,1.87,4.14,6.96,9.99,10,11,10,10,11,11,12,14,15,15,15,16,15,14,13,13,12,11,11,10,10,9,9,8,8,8,7,7,7,6,6.10,5.90,5.77,5.59,5.37,5.22,5.12,5.01,4.90,4.82,4.65,4.50,4.37,4.25,4.12,4,3.87,3.71,3.50,3.26,3.11,2.96,2.76,2.58,2.37,2.16,2.07,1.98,1.91,1.82,1.60,1.34,1.12,1,0.99,0.99,0.99,0.99,0.99,0.89,0.64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.26,0.70,0.65,0.74,0.84,0.91,0.95,0.91,0.83,0.71,0.24,0.01,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,3,3,4,6,8,10,11,10,9,12,16,19,20,19,19,18,17,15,14,13,12,12,13,13,14,15,17,22,27,33,39,43,45,47,47,48,48,47,47,47,47,43,37,30,23.33,17.76,15.21,13.62,12.96,14.03,15.13,16.58,18.40,19.37,18.97,19.08,19.20,19.12,18.72,17.92,16.88,15.66,14.71,-5.13,-6.10,-7.15,-8.24,-9.28,-10,-11,-12,-13,-14,-14,-15,-16,-16,-17,-18,-18,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-16,-15,-14,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.85,-8.75,-8.50,-8.52,-8.10,-7.52,-6.79,-6.14,-5.59,-5.11,-4.66,-4.30,-4,-3.73,-3.50,-3.29,-3.14,-3.02,-2.91,-2.84,-2.65,-2.41,-2.04,-1.67,-1.10,-0.04,1.63,3.97,7.51,9.85,11,11,11,10,10,11,12,13,14,14,14,14,14,13,12,12,11,11,10,10,9,9,8,8,8,7,7,7,6,6,5.91,5.77,5.59,5.37,5.22,5.10,5,4.96,4.86,4.70,4.51,4.37,4.25,4.12,4.02,3.91,3.78,3.61,3.38,3.21,3.03,2.88,2.74,2.51,2.33,2.14,2.02,1.98,1.89,1.76,1.57,1.33,1.12,1,0.99,0.99,0.99,0.99,0.99,0.89,0.66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.12,0.23,0.73,0.85,0.95,0.96,0.96,0.97,0.99,0.97,0.91,0.73,0.25,0.02,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,3,3,3,4,6,8,10,11,11,12,15,17,17,15,14,13,12,12,11,11,11,12,12,13,13,14,16,19,23,27,33,39,43,45,45,46,45,45.01,45.07,46.10,47.87,47.87,44.87,39.12,33.89,25.83,18.74,15.14,14.42,14.25,14.90,16.04,17.48,19.48,19.48,19.76,19.97,20.11,19.91,19.24,18.11,16.72,15.35,13.75,-5.03,-6,-7.17,-8.25,-9.17,-10,-11,-12,-13,-14,-14,-15,-16,-17,-17,-18,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-14,-14,-13,-12,-12,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-10,-9.50,-9.13,-9.05,-8.37,-7.67,-7.12,-6.59,-6.10,-5.62,-5.13,-4.66,-4.24,-3.86,-3.52,-3.29,-3.13,-3.02,-2.93,-2.87,-2.65,-2.48,-2.10,-1.39,-0.26,1.41,3.63,6.38,9.66,11,12,11,10,10,10,11,11,12,12,12,13,13,12,12,11,11,10,10,9,9,8,8,8,7,7,7,6,6,6,5.85,5.62,5.37,5.22,5.10,5,4.96,4.87,4.75,4.58,4.37,4.22,4.11,4.01,3.96,3.87,3.71,3.50,3.28,3.12,3,2.87,2.71,2.47,2.25,2.12,2,1.96,1.87,1.73,1.50,1.26,1.11,1,0.99,0.99,0.99,0.99,0.99,0.90,0.74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0,0.01,0.12,0.14,0.77,0.86,0.97,0.98,0.99,0.99,0.99,0.99,0.99,0.96,0.75,0.23,0.16,0.12,0.03,0.01,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,3,3,4,5,6,8,10,12,13,15,16,15,14,12,10,10,10,10,10,10,11,11,12,13,14,15,18,22,25,29,34,39,42,42,43,44,43.07,44.11,44.14,46.96,48.78,49.78,47.78,41.78,35.82,27.70,19.77,16.08,14.60,15.13,15.75,16.62,17.73,18.70,19.46,19.99,20.51,20.97,20.92,19.92,18.28,16.57,14.66,13.79,-4.88,-5.90,-7.11,-8.14,-9.13,-10,-11,-12,-13,-13,-14,-15,-16,-17,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-16,-15,-14,-13,-13,-12,-12,-11,-11,-11,-12,-12,-11,-12,-12,-11,-11,-11,-10,-9.59,-8.85,-8.43,-8,-7.63,-7.23,-6.75,-6.16,-5.55,-4.90,-4.30,-3.84,-3.41,-3.24,-3.12,-3.01,-2.92,-2.80,-2.61,-2.23,-1.50,-0.36,1.25,3.11,5.53,8.24,12,12,12,10,9,9,9,8,8,9,11,12,12,12,11,11,10,10,9,9,8,8,8,7,7,7,6,6,6,6,5.62,5.37,5.15,5.09,5,4.96,4.87,4.75,4.58,4.37,4.22,4.10,4,3.97,3.87,3.75,3.52,3.36,3.20,3.03,2.95,2.75,2.57,2.36,2.20,2.07,1.98,1.88,1.77,1.62,1.41,1.24,1.09,1,0.99,0.99,0.99,0.99,0.99,0.95,0.82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.07,0.09,0.09,0.15,0.25,0.35,0.36,0.86,0.87,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.86,0.78,0.86,0.89,0.96,0.98,1,1,1,0,0,0,0.71,1,1.13,1.46,1.87,2.26,2.51,2.70,3,3.25,3,4,6,7,8,10,13,15,14,12,11,10,9,9,8,8,9,9,10,11,11,12,13,15,18,21,24,27,30,34,38,40,41,41,41.92,42.12,43.17,45.78,47.75,49.74,49.73,48.73,43.74,36.82,29.39,21.82,17.39,15.88,15.88,16.35,17.01,17.78,18.60,19.37,20.13,21.01,21.79,22.78,20.48,18.39,16.35,14.50,12.84,-4.67,-5.73,-6.89,-8,-8.91,-9.89,-10,-12,-12,-13,-14,-15,-16,-17,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-16,-15,-14,-13,-13,-12,-12,-11,-11,-12,-12,-12,-12,-11,-12,-12,-12,-11,-10,-9.51,-8.76,-8.91,-8.75,-8.48,-8.03,-7.40,-6.61,-5.72,-4.84,-4.13,-3.63,-3.34,-3.15,-3.05,-2.98,-2.87,-2.61,-2.15,-1.43,-0.38,1.08,2.75,4.75,7.13,9.96,11,10,8,8,7,7,7,6,8,10,11,11,11,10,10,10,9,9,8,8,8,7,7,7,6,6,6,6,6,5.35,5.12,5.01,5,4.96,4.87,4.75,4.59,4.37,4.22,4.10,4,3.96,3.87,3.75,3.53,3.37,3.23,3.09,2.97,2.82,2.59,2.37,2.23,2.11,2,1.89,1.82,1.66,1.50,1.34,1.15,1.07,1,0.99,0.99,0.99,0.99,0.98,0.96,0.62,0.28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.12,0.24,0.28,0.36,0.41,0.52,0.62,0.74,0.84,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.97,0.98,0.99,1,1,1,1,1,0.96,0.72,0.86,1.10,1.34,1.71,2.32,2.97,3.52,3.90,4.23,4.47,4.60,5.03,7,10,11,13,14,13,11,9,9,8,8,8,8,8,8,9,10,11,12,12,13,16,20,22,24,25,29,33,36,38,40,40.07,40.12,41.17,42.23,44.73,46.71,47.67,48.66,47.66,44.67,39.71,31.39,23.12,18.73,17.12,16.66,16.84,17.27,17.87,18.52,19.25,20.11,21.17,22.24,22.65,20.59,18.29,16.08,13.91,11.87,-4.65,-5.52,-6.63,-7.68,-8.67,-9.74,-10,-11,-12,-13,-14,-15,-16,-17,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-17,-16,-15,-14,-13,-13,-12,-12,-12,-12,-12,-12,-11,-12,-12,-12,-12,-11,-11,-9.93,-9.55,-9.66,-9.77,-9.90,-9.64,-8.99,-7.98,-6.75,-5.60,-4.63,-3.91,-3.50,-3.25,-3.11,-3,-2.85,-2.54,-2.09,-1.38,-0.38,0.87,2.32,3.89,5.65,7.63,7.97,6,6,6,6,6,6,6,7,8,9,10,10,10,9,9,9,8,8,8,7,7,7,6,6,6,6,6,5,5.11,5,5,4.97,4.88,4.75,4.59,4.37,4.22,4.10,4,3.96,3.87,3.75,3.58,3.37,3.24,3.11,2.98,2.82,2.61,2.37,2.22,2.10,2,1.90,1.83,1.70,1.52,1.37,1.23,1.11,1.02,1,0.99,0.99,0.99,0.98,0.98,0.90,0.62,0.32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.15,0.35,0.50,0.62,0.66,0.73,0.78,0.89,0.95,0.97,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1.01,1,1.02,1.13,1.37,1.73,2.32,3.22,4.25,5.20,5.74,6.04,6.32,7.08,8.62,10.96,13,15,16,14,11,9,8,7,7,7,7,7,8,8,9,10,11,12,13,14,17,19,20,22,24,27,31,36,39,39.98,39.02,39.17,40.23,42.73,43.76,44.71,45.36,46.01,46.04,45.63,42.65,33.27,25.45,19.97,18.08,17.29,17.21,17.49,17.92,18.48,19.11,19.89,20.98,21.88,21.72,20.27,18.02,15.66,13.26,10.87,-4.62,-5.38,-6.38,-7.37,-8.30,-9.42,-10,-11,-12,-13,-14,-15,-15,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-16,-15,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-10,-9.52,-7.91,-6.39,-5.10,-4.15,-3.63,-3.34,-3.14,-3,-2.80,-2.50,-2.02,-1.36,-0.42,0.63,1.82,3,4.15,5,5.13,5,4,5,5,5,5,5,5,7,8,9,9,9,9,8,8,8,8,7,7,7,6,6,6,6,6,5,5,5,5,4.99,4.97,4.82,4.61,4.36,4.21,4.10,4,3.97,3.87,3.75,3.58,3.37,3.23,3.10,2.97,2.82,2.61,2.37,2.22,2.10,2,1.95,1.85,1.71,1.53,1.37,1.25,1.12,1.07,1,1,0.99,0.99,0.99,0.98,0.98,0.87,0.63,0.33,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.15,0.37,0.60,0.75,0.85,0.87,0.89,0.95,0.97,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1.17,1.15,1.25,1.50,1.95,2.58,3.47,4.65,5.99,7.04,7.54,7.73,7.99,8.87,10.76,14.39,17,17,16,13,10,8,8,8,7,7,7,7,8,8,9,10,11,12,14,16,17,18,18,20,23,28,33,38,41,38.92,37.14,37.21,39.92,42.67,42.64,42.83,43.37,44.22,45.09,45.61,42.38,34.86,27.21,21.67,18.82,17.78,17.50,17.65,18.03,18.47,18.92,19.51,20.34,21.12,20.99,19.73,17.54,15.40,12.26,9.89,-4.53,-5.22,-6.15,-7.11,-8.03,-9.03,-10,-11,-11,-12,-13,-14,-15,-16,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-15,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.92,-10,-11,-12,-12,-13,-12,-10,-9.02,-7.25,-5.65,-4.52,-3.88,-3.48,-3.23,-3.02,-2.84,-2.51,-2.09,-1.40,-0.60,0.34,1.25,2.12,2.86,3.26,3.38,3.13,4,4,4,5,5,5,6,7,8,9,9,9,8,8,7,7,7,7,7,6,6,6,6,6,5,5,5,5,5,5,4.87,4.62,4.35,4.14,4.09,4.01,4,3.97,3.77,3.57,3.32,3.14,3.08,2.95,2.76,2.59,2.37,2.15,2.10,2,1.96,1.87,1.75,1.57,1.38,1.25,1.12,1.07,1.01,1,0.99,0.99,0.99,0.98,0.98,0.95,0.84,0.62,0.35,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.15,0.37,0.61,0.78,0.90,0.97,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1.03,1.01,1,1,2,2,2,2,2,1.73,1.50,1.40,1.57,2.04,2.82,3.84,5.03,6.36,7.51,8.25,8.36,8.27,8.42,9.22,10.63,12.95,13.66,14,13,10,9,9,9,7,7,7,7,7,8,8,9,10,11,13,15,17,18,18,18,19,23,29,35,39,39,36.13,35.28,37,39.51,40.48,40.50,40.75,41.40,42.48,44.57,45.52,42.11,35.60,27.86,22.25,19.46,18.21,17.79,17.91,18.24,18.57,18.83,19.04,19.59,20.23,20.21,19.08,16.87,14.25,10.23,8.92,-4.43,-5.12,-5.84,-6.77,-7.77,-8.76,-9.65,-10,-11,-12,-13,-14,-15,-16,-17,-17,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-13,-13,-12,-11,-11,-10,-10,-10,-11,-11,-10,-10,-9.89,-9.77,-9.54,-10,-11,-12,-14,-14,-14,-12,-9.97,-7.92,-6.15,-4.88,-4.09,-3.60,-3.28,-3.09,-2.88,-2.62,-2.23,-1.62,-0.88,-0.12,0.63,1.33,1.86,2.12,2.25,2.28,3,3,4,4,4,4,6,8,9,9,9,8,8,8,7,7,7,7,6,6,6,6,6,5,5,5,5,5,5,4.77,4.60,4.38,4.23,4.11,4.01,3.98,3.87,3.75,3.57,3.28,3.11,3.02,2.91,2.75,2.57,2.35,2.14,2.03,2,1.96,1.87,1.75,1.59,1.37,1.24,1.12,1.02,1,1,0.99,0.99,0.99,0.98,0.98,0.97,0.89,0.77,0.60,0.36,0.12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.15,0.37,0.61,0.78,0.90,0.97,0.99,0.99,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1.01,1,2,2,2,2,3,3,4,3,2.58,1.99,1.75,1.98,2.70,3.84,5.20,6.50,7.57,8.12,8.14,7.79,7.49,7.53,8.01,8.83,9.46,9.70,9,8,7,7,7,7,6,6,6,6,7,8,8,9,11,13,15,17,19,20,20,20,21,23,29,33,33.98,33.10,32.28,33.42,36.49,37.07,37.78,38.26,38.70,38.65,41.62,44.40,45.39,41.88,34.51,27.96,22.85,19.95,18.58,18.12,18.34,18.67,18.90,18.97,18.89,19.07,19.39,19.40,18.38,16,13,9.13,7.97,-4.42,-4.97,-5.54,-6.38,-7.41,-8.42,-9.34,-10,-11,-12,-12,-13,-14,-15,-16,-17,-18,-18,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-14,-13,-12,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.63,-9.30,-9.85,-11,-13,-15,-15,-15,-13,-10,-8.41,-6.40,-5,-4.13,-3.63,-3.30,-3.13,-2.97,-2.75,-2.38,-1.88,-1.27,-0.62,0.07,0.63,1.12,1.39,1.61,1.87,2,3,3,3,3,4,5,7,8,9,8,8,8,7,7,7,6,6,6,6,6,6,5,5,5,5,5,4.98,4.78,4.60,4.37,4.23,4.11,4.01,3.97,3.87,3.75,3.58,3.37,3.16,3,3,2.75,2.53,2.34,2.14,2.03,2,1.98,1.89,1.75,1.59,1.37,1.21,1.09,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.90,0.77,0.60,0.37,0.15,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.15,0.37,0.61,0.78,0.90,0.97,0.99,0.99,0.99,1,1.01,1.07,1.03,0.99,1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,5,6,5,3.60,2.59,2.20,2.45,3.27,4.57,5.96,7.04,7.57,7.42,6.92,6.34,5.97,5.91,6.15,6.49,6.70,6.63,6,6,6,6,6,6,6,6,6,6,7,8,8.99,10.01,12,14.04,17.04,20.04,22.04,23.03,23.01,22,22,23,26,28.01,29.12,29.21,30.37,32.48,34.37,35.10,35.70,35.75,36.76,38.75,42.01,45.26,44.27,39.70,33.49,27.60,23.09,20.40,19.07,18.61,18.96,19.34,19.48,19.29,18.99,18.77,18.66,18.64,17.35,14.75,11.88,9.07,8,-4.38,-4.89,-5.38,-5.93,-6.93,-7.99,-8.88,-9.68,-10,-11,-12,-13,-14,-15,-16,-17,-17,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-15,-14,-13,-12,-12,-11,-10,-9.59,-9.39,-9.85,-10,-10,-9.92,-9.61,-9.13,-9.13,-9.60,-10,-12,-14,-15,-14,-12,-10,-8.87,-6.91,-5.41,-4.40,-3.80,-3.43,-3.22,-3.03,-2.86,-2.60,-2.18,-1.67,-1.10,-0.49,0.11,0.59,0.91,1.22,1.40,2,2,2,2,3,3,4,6,6,7,7,7,7,7,7,6,6,6,6,6,6,5,5,5,5,5,5,4.83,4.60,4.37,4.22,4.10,4,3.97,3.87,3.75,3.58,3.37,3.21,3.03,2.90,2.86,2.57,2.35,2.15,2.03,2,1.98,1.91,1.78,1.59,1.37,1.21,1.09,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.90,0.77,0.60,0.37,0.15,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.15,0.37,0.61,0.78,0.90,0.97,0.99,0.99,0.99,0.99,1,1.07,1.11,1.09,1.11,1,1,1,1,1,1,1,2,2,3,3,4,5,5,5,6,8,7,4.79,3.24,2.59,2.76,3.54,4.70,5.77,6.40,6.40,5.89,5.25,4.72,4.47,4.45,4.58,4.72,4.79,4.77,4,5,5,5,5,5,5,5,6,6,7,8.01,9.04,10.92,12.09,16.09,20.89,24.89,27.90,27.90,27.07,25.04,24.01,24,24.01,25.12,25.21,26.27,28.48,31.39,32.37,33.33,33.83,34.85,35.85,39.70,42.62,45.15,43.15,38,32.34,27.04,23.14,20.74,19.40,19.21,19.87,20.38,20.38,19.88,19.13,18.41,17.85,17.26,15.83,13.11,10.50,8,7,-4.28,-4.80,-5.28,-5.73,-6.40,-7.47,-8.38,-9.16,-9.99,-10,-11,-12,-13,-14,-15,-16,-17,-17,-18,-18,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-15,-14,-13,-13,-12,-11,-10,-9.78,-9.14,-8.99,-9.42,-9.50,-9.15,-8.90,-8.88,-8.63,-8.92,-10,-12,-13,-13,-13,-12,-11,-9.27,-7.47,-5.91,-4.78,-4.09,-3.63,-3.35,-3.13,-2.98,-2.75,-2.47,-2.03,-1.50,-0.91,-0.36,0.20,0.62,0.90,1.12,1,2,2,2,2,2,3,5,4,5,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,4.86,4.60,4.37,4.20,4.09,4,3.96,3.87,3.75,3.59,3.37,3.21,3.03,2.89,2.75,2.57,2.37,2.20,2.07,2,1.98,1.91,1.78,1.61,1.37,1.15,1.09,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.90,0.77,0.60,0.37,0.15,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.09,0.21,0.37,0.61,0.78,0.90,0.97,0.99,0.99,0.99,0.99,0.99,1,1.01,1.07,1.08,1.11,2,1,1,1,2,2,2,2,3,4,5,7,8,7,8,8,10,9,5.96,3.82,2.88,2.89,3.47,4.23,4.84,5.02,4.78,4.28,3.78,3.47,3.35,3.38,3.50,3.62,3.73,3.85,4,4,4,4,4,4,5,5,6,6,7.01,8.95,10.09,11.10,14.11,19.11,25.87,29.87,33.88,33.88,32.10,30.09,28.04,27.01,25.07,24.20,25.26,25.35,27.52,29.57,30.95,31.83,32.87,33.90,36.89,40.71,44.12,45.08,42.08,36.58,31.28,26.67,23.20,20.97,19.89,20.24,21.24,21.92,21.71,20.67,19.36,18.01,16.73,15.35,13.65,11.47,8.82,7.07,7,-4.15,-4.67,-5.16,-5.62,-6.11,-6.89,-7.75,-8.55,-9.39,-10,-11,-12,-13,-13,-14,-15,-16,-17,-17,-18,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-18,-18,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-15,-14,-13,-13,-12,-11,-10,-9.97,-9.29,-8.99,-8.75,-8.72,-8.60,-8.55,-8.68,-8.36,-8.54,-10,-11,-12,-12,-13,-12,-11,-9.77,-8.10,-6.52,-5.29,-4.43,-3.88,-3.50,-3.25,-3.05,-2.88,-2.65,-2.34,-1.87,-1.29,-0.66,-0.10,0.39,0.75,0.95,1,1,1,1,1,2,2,3,3,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,4.87,4.62,4.37,4.16,4.08,4,3.97,3.87,3.75,3.58,3.37,3.22,3.07,2.88,2.73,2.52,2.35,2.22,2.10,2,1.98,1.90,1.78,1.61,1.37,1.15,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.90,0.77,0.60,0.37,0.15,0.03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.08,0.20,0.36,0.57,0.75,0.88,0.97,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.02,1.11,1,1,1,2,2,2,2,3,4,5,8,9,11,10,11,11,12,11,6.61,4.15,3,2.78,3.08,3.45,3.67,3.66,3.42,3.10,2.79,2.64,2.63,2.74,2.87,3.03,3.24,3.54,4,4,4,4,4,4,5,6,6,7.01,7.95,9.09,10.88,12.87,16.13,21.86,28.86,33.86,37.86,39.86,38.87,36.88,35.90,31.91,28.85,27.20,26.34,26.40,27.54,28.87,29.76,30.84,31.88,34.91,38.20,42.09,46.10,44.02,40.02,34.97,30.36,26.38,23.32,21.13,20.41,21.42,22.91,23.89,23.21,21.54,19.62,17.57,15.54,13.64,11.77,9.87,8.21,7.10,6.97,-4,-4.53,-5,-5.42,-5.89,-6.49,-7.25,-8,-8.75,-9.59,-10,-11,-12,-13,-14,-14,-15,-16,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-18,-18,-18,-19,-19,-19,-20,-20,-20,-20,-19,-19,-19,-19,-19,-19,-18,-18,-17,-17,-17,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-15,-14,-13,-13,-12,-11,-10,-10,-9.40,-9.13,-8.93,-8.73,-8.86,-8.75,-8.98,-8.88,-8.90,-9.23,-10,-11,-12,-12,-12,-12,-10,-8.86,-7.23,-5.88,-4.88,-4.14,-3.65,-3.37,-3.14,-2.99,-2.78,-2.50,-2.11,-1.59,-0.91,-0.25,0.27,0.70,0.89,1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,5,5,5,5,5,5,5,5,5,4.65,4.37,4.15,4.03,4,3.98,3.88,3.75,3.57,3.37,3.22,3.07,2.89,2.74,2.53,2.37,2.21,2.11,2.01,1.98,1.89,1.77,1.61,1.37,1.15,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.88,0.75,0.58,0.37,0.21,0.09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.01,0.12,0.25,0.47,0.66,0.86,0.95,0.97,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.11,1,2,2,2,2,2,3,3,5,7,9,12,13,14,14,15,14,10,6.83,4.25,2.96,2.57,2.62,2.74,2.79,2.74,2.60,2.42,2.29,2.25,2.25,2.37,2.53,2.75,3.01,3.45,4,4,4,4,4,5,6,7,8,8.04,8.09,9.11,11.12,13.13,16.14,21.83,27.83,32.83,36.83,41.85,42.86,39.86,37.86,34.83,31.71,28.95,27.42,27.11,27.60,28.71,29.97,31.25,32.90,35.45,38.73,43.04,45.11,41.03,37.01,33.07,29.32,26.14,23.58,21.70,21.36,22.54,24.27,25.15,24.40,22.37,19.82,17.09,14.42,12.02,10.12,8.63,7.66,7.13,6.92,-3.88,-4.35,-4.78,-5.25,-5.74,-6.27,-6.88,-7.50,-8.24,-8.99,-9.73,-10,-11,-12,-13,-13,-14,-15,-16,-16,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-18,-17,-17,-17,-17,-17,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-17,-16,-15,-15,-14,-14,-13,-12,-11,-10,-10,-9.43,-9.27,-9.05,-9.25,-9.40,-9.34,-9.12,-9.05,-8.88,-9.52,-10,-11,-11,-12,-13,-12,-11,-9.60,-7.89,-6.43,-5.28,-4.40,-3.79,-3.41,-3.18,-3.02,-2.88,-2.62,-2.28,-1.74,-1.03,-0.36,0.25,0.71,0.89,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,5,5,5,5,5,5,5,5,5,4.36,4.14,4.03,4,3.96,3.87,3.74,3.57,3.37,3.22,3.03,2.88,2.74,2.57,2.37,2.23,2.10,2.01,1.97,1.87,1.76,1.60,1.37,1.15,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.95,0.87,0.74,0.57,0.37,0.21,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.02,0.13,0.34,0.53,0.74,0.87,0.97,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1,2,2,2,2,2,3,3,4,6,8,11,14,16,18,18,17,14,10,6.61,4.12,2.85,2.36,2.26,2.26,2.27,2.24,2.17,2.12,2.09,2.07,2.09,2.17,2.35,2.60,2.88,3.25,4,4,4,4,5,6,8,10,10.98,10.89,10.15,10.23,11.25,13.27,16.29,20.75,25.72,29.75,34.77,39.83,41.82,39.79,36.78,34.76,32.62,29.41,28.25,27.58,27.62,29.09,30.33,31.70,33.39,35.57,38.34,42.08,41.09,37.77,33.96,31.27,28.48,26.10,24,22.61,22.41,23.29,24.42,24.99,24.49,22.72,19.86,16.41,13.34,10.71,8.95,7.82,7.36,7.09,6.89,-3.78,-4.15,-4.60,-5.03,-5.54,-6.12,-6.67,-7.27,-7.89,-8.50,-9.15,-9.78,-10,-11,-12,-13,-13,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-18,-18,-18,-18,-19,-19,-18,-18,-18,-18,-18,-17,-17,-17,-17,-16,-16,-16,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-15,-14,-14,-13,-12,-11,-10,-10,-9.76,-9.49,-9.35,-9.66,-9.77,-9.72,-9.41,-9,-9.01,-9.68,-10,-10,-11,-13,-14,-13,-12,-10,-8.48,-6.89,-5.62,-4.61,-3.88,-3.43,-3.18,-3.04,-2.90,-2.68,-2.34,-1.76,-1.10,-0.38,0.25,0.71,0.88,1,1,1,1,1,1,1,2,2,3,3,4,4,4,5,5,5,5,5,5,5,5,5,5,4,4.12,4.03,4,3.96,3.87,3.75,3.58,3.37,3.22,3.03,2.88,2.74,2.57,2.38,2.25,2.12,2.01,1.99,1.88,1.75,1.60,1.37,1.20,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.91,0.87,0.74,0.57,0.37,0.21,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.03,0.15,0.37,0.60,0.76,0.88,0.96,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1,2,2,2,2,2,3,3,4,5,7,11,14,16,20,23,22,19,15,10,5.70,4.03,2.76,2.25,2.10,2.07,2.04,2.03,2.02,2.01,2,2,2.01,2.10,2.25,2.49,2.76,3.07,3,3,4,4,5,7,11,13,13.88,13.82,12.75,11.70,12.27,13.37,16.22,19.37,22.90,26.34,30.27,34.72,38.75,37.75,34.75,32.75,31.08,29.50,28.53,28.52,28.63,29.74,30.86,32.08,33.51,35.27,37.12,39.11,37.16,34.89,31.90,29.95,27.97,26.32,24.79,23.86,23.48,23.62,23.96,24.13,23.71,22.08,18.99,15.28,12.15,9.70,8.26,7.48,7.12,6.87,6.87,-3.75,-3.98,-4.38,-4.85,-5.38,-6,-6.63,-7.24,-7.80,-8.35,-8.80,-9.34,-9.87,-10,-11,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-17,-17,-16,-16,-16,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-16,-16,-15,-14,-13,-13,-12,-11,-11,-10,-10,-9.76,-9.75,-9.92,-9.99,-9.88,-9.62,-9.37,-9.37,-9.51,-10,-10,-11,-13,-14,-14,-12,-10,-8.88,-7.25,-5.86,-4.75,-3.99,-3.50,-3.22,-3.03,-2.88,-2.65,-2.28,-1.75,-1.10,-0.39,0.25,0.66,0.87,1,1,1,1,1,1,1,2,2,3,4,4,4,5,5,5,5,5,5,5,5,5,5,4,4,4,4,3.96,3.87,3.75,3.57,3.37,3.22,3.03,2.87,2.73,2.58,2.39,2.25,2.12,2.01,1.96,1.87,1.76,1.61,1.37,1.22,1.08,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.91,0.87,0.74,0.57,0.37,0.21,0.09,0.01,0,0,0,0,0,0,0,0,0,0,0,0.01,0.01,0,0,0.08,0.20,0.38,0.62,0.82,0.89,0.97,0.98,0.99,0.99,0.99,0.99,1,1,1.01,1.12,1,2,2,2,2,2,3,4,4,5,6,8,12,16,20,24,26,25,20,16,11,6.33,4.04,2.82,2.22,2.03,2,2,2,2,2,2,2,2,2.04,2.15,2.38,2.67,2.89,3,3,4,4,5,8,10,11.92,12.82,12.75,11.95,12.03,12.73,13.96,15.45,18.03,20.41,23.38,27.27,30.74,33.65,32.98,31.77,30.32,29.97,29.52,29.35,29.52,30,30.67,31.47,32.41,33.49,34.66,36.13,35.41,34.34,32.54,30.67,28.79,27.77,26.64,25.62,24.72,24,23.52,23.24,22.84,22,20.15,16.96,13.66,10.73,8.71,7.76,7.24,6.90,6.79,5.87,-3.54,-3.76,-4.18,-4.72,-5.30,-6,-6.68,-7.38,-8,-8.50,-8.88,-9.25,-9.42,-9.67,-10,-10,-11,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-16,-16,-15,-15,-15,-15,-15,-15,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-20,-19,-19,-18,-17,-17,-16,-16,-15,-14,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.91,-9.63,-9.53,-9.55,-10,-10,-10,-12,-14,-15,-14,-13,-11,-9.05,-7.35,-5.89,-4.76,-4,-3.50,-3.22,-3.01,-2.86,-2.60,-2.22,-1.66,-1.01,-0.37,0.25,0.64,0.91,1,1,1,1,1,1,1,2,3,3,4,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,3.96,3.87,3.73,3.57,3.37,3.22,3.03,2.87,2.73,2.58,2.39,2.25,2.12,2,1.90,1.84,1.73,1.57,1.36,1.14,1.09,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.91,0.87,0.74,0.57,0.37,0.21,0.09,0,0,0,0,0,0,0,0,0,0,0.03,0.08,0.10,0.10,0.09,0.09,0.12,0.25,0.47,0.66,0.85,0.91,0.97,0.98,0.99,0.99,0.99,0.99,1,1.12,1.15,1,2,2,2,2,2,3,4,5,5,6,7,9,12,17,23,27,29,26,20,16,12,7,4.37,2.72,2.20,2.02,2,2,2,2,2,2,2,2,2.01,2.11,2.25,2.57,3,3,3,4.02,5,6.10,6.12,8.20,9.25,9.36,10.40,10.46,11.77,12.79,13.99,15.45,17.11,18.48,21.47,24.47,27.47,29.37,29.37,28.28,28.34,29.24,29.47,29.71,30.35,31.33,31.50,32.20,32.76,33.51,34,34.21,33.34,31.77,30.77,29.64,28.58,27.65,26.96,26.11,25.39,23.88,22.90,22.20,21.38,20.22,17.96,14.83,11.71,9.22,7.98,7.37,6.97,6.74,6.20,5.87,-3.39,-3.64,-4.02,-4.63,-5.26,-6,-6.75,-7.47,-8.12,-8.63,-9.01,-9.27,-9.41,-9.38,-9.43,-9.98,-10,-11,-11,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-16,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-15,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-16,-15,-15,-14,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.88,-9.51,-9.39,-9.80,-10,-10,-11,-12,-14,-15,-15,-13,-10,-8.92,-7.17,-5.75,-4.63,-3.88,-3.43,-3.16,-2.99,-2.76,-2.50,-2.09,-1.53,-0.89,-0.26,0.26,0.71,0.95,1,1,1,1,1,1,1,2,3,4,4,5,5,5,5,5,5,5,5,4,4,4,4,4,4,3.96,3.87,3.73,3.57,3.37,3.22,3.03,2.87,2.73,2.57,2.39,2.25,2.12,2,1.89,1.78,1.66,1.50,1.34,1.14,1.02,1,0.99,0.99,0.99,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.91,0.87,0.74,0.57,0.37,0.21,0.09,0,0,0,0,0,0,0,0,0.01,0.08,0.12,0.16,0.22,0.22,0.21,0.20,0.24,0.37,0.57,0.75,0.87,0.95,0.98,0.98,0.99,0.99,0.99,0.99,1.01,1,2,2,2,2,2,2,3,4,5,6,7,8,8,10,13,18,24,28,28,24,20,16,11,8,3.03,2.59,2.12,2.01,2,2,2,2,2,2,2,2,2,2.03,2.12,2.03,3,3,4.07,5.11,5.13,7.16,9.23,9.28,8.36,8.47,9.52,10.50,11.52,12.73,13.96,15.26,16.52,18.50,20.51,22.52,25.50,27.37,28.37,28.34,28.35,29.11,29.40,29.82,30.37,31.15,32.07,33.13,33.75,33.87,33.38,32.70,31.74,30.74,29.72,28.74,28.09,27.57,27.12,27.02,24.72,23.10,21.84,20.85,19.87,18.27,15.77,12.77,9.36,8.09,7.48,7.01,6.71,6.25,6.12,5.87,-3.34,-3.54,-3.99,-4.51,-5.17,-5.90,-6.65,-7.39,-8.10,-8.63,-9.01,-9.26,-9.36,-9.37,-9.28,-9.27,-9.84,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-13,-14,-14,-14,-15,-16,-17,-17,-18,-18,-18,-18,-18,-18,-19,-19,-19,-19,-18,-18,-18,-17,-17,-16,-16,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.98,-9.75,-9.29,-9.13,-9.63,-9.78,-10,-11,-13,-14,-15,-14,-12,-10,-8.50,-6.80,-5.42,-4.38,-3.73,-3.34,-3.12,-2.92,-2.74,-2.38,-1.90,-1.34,-0.68,-0.12,0.38,0.75,0.97,1,1,1,1,1,1,1,2,3,4,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3.88,3.74,3.57,3.37,3.22,3.03,2.87,2.73,2.57,2.39,2.25,2.12,2,1.88,1.77,1.64,1.50,1.34,1.15,1.03,1,0.99,0.99,0.99,0.99,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.91,0.86,0.74,0.57,0.37,0.21,0.09,0,0,0,0,0,0,0,0.01,0.08,0.12,0.24,0.33,0.37,0.37,0.37,0.36,0.37,0.50,0.65,0.83,0.90,0.97,0.98,0.98,0.99,1,1,1,1,2,2,2,2,2,2,2,3,5,7,9,11,11,11,12,15,19,24,27,25,22,18,15,10,6,3,2.03,2.04,2,2,2,2,2,2,2,2,2,2,2,2,2,3,4.01,5.12,6.16,9.21,12.09,13.66,12.60,9.46,8.58,9.37,10.40,11.49,12.64,13.89,15.25,16.91,18.82,20.65,22.63,24.59,26.90,28.38,29.62,29.67,29.40,29.42,29.52,30.35,30.63,32.66,33.92,36.32,34.33,32.95,31.64,31.07,30.08,29.10,28.26,27.60,27.34,27.40,26.37,23.53,21.70,20.47,19.37,18.22,16.70,13.62,10.79,8.74,7.58,7.03,6.70,6.27,6.12,6,5.89,-3.27,-3.50,-3.87,-4.39,-5.05,-5.76,-6.52,-7.28,-8,-8.59,-9,-9.24,-9.28,-9.26,-9.18,-9.05,-9.13,-9.65,-10,-10,-11,-11,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-15,-15,-16,-16,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-17,-17,-16,-16,-15,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-9.75,-9.59,-9.36,-8.97,-8.65,-9.40,-9.66,-10,-12,-13,-14,-14,-12,-11,-9.59,-7.79,-6.23,-4.90,-4.13,-3.59,-3.25,-3.05,-2.88,-2.63,-2.25,-1.72,-1.09,-0.47,0.13,0.58,0.87,0.97,1,1,1,1,1,1,1,1,3,4,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,3.82,3.59,3.37,3.22,3.03,2.87,2.73,2.57,2.39,2.25,2.12,2,1.88,1.76,1.63,1.50,1.37,1.21,1.08,1,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.91,0.86,0.74,0.57,0.37,0.21,0.09,0,0,0,0,0,0,0,0.08,0.12,0.24,0.37,0.48,0.53,0.58,0.53,0.52,0.57,0.63,0.75,0.87,0.95,0.98,1,1,0.99,1,1,1,2,2,2,2,2,2,2,3,4,7,10,12,14,15,16,16,18,21,23,23,20,18,16,13,8,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3.07,4.12,7.13,10.23,14.74,18.71,18.60,14.79,11.53,8.62,9.75,10.62,11.58,12.67,13.85,15.23,17.01,19.17,21.50,23.59,25.51,27.24,28.88,30.58,30.70,29.89,29.45,29.48,30.54,31.61,33.64,35.34,34.39,33.62,32.67,31.82,30.82,29.65,28.62,27.99,27.47,27.01,26.49,24.02,21.64,19.71,18.78,18.27,16.34,14.39,11.51,8.49,7.41,7.12,6.71,6.28,6.13,6,5.87,5.92,-3.26,-3.41,-3.75,-4.27,-4.88,-5.54,-6.28,-6.98,-7.63,-8.17,-8.61,-8.88,-9,-9.04,-9.02,-9,-9.01,-8.88,-9.29,-9.80,-10,-10,-11,-11,-11,-12,-12,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-12,-13,-13,-12,-12,-12,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-9.75,-9.04,-8.75,-8.37,-8.50,-8.88,-9.63,-10,-12,-13,-14,-13,-11,-10,-8.63,-6.98,-5.48,-4.49,-3.75,-3.38,-3.14,-3,-2.87,-2.59,-2.13,-1.50,-0.79,-0.13,0.38,0.76,0.90,0.98,1,1,1,1,1,1,1,1,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.64,3.40,3.23,3.03,2.87,2.73,2.57,2.39,2.25,2.12,2,1.88,1.76,1.63,1.50,1.37,1.25,1.12,1.02,1,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.90,0.85,0.73,0.53,0.37,0.20,0.08,0,0,0,0,0,0,0.03,0.11,0.21,0.34,0.48,0.60,0.65,0.70,0.71,0.72,0.73,0.76,0.86,0.90,0.97,0.98,1,1.12,1.22,1,1,2,2,2,2,2,2,2,2,3,5,7,11,14,15,17,19,20,21,21,20,19,16,14,13,9,6,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2.02,3.89,5.16,9.23,13.73,18.70,23.66,21.52,17.47,13.61,10.73,10.85,10.92,11.99,12.99,13.98,14.92,16.86,19.77,22.32,25.17,26.34,27.84,29.42,30.57,30.71,30.10,30,30.40,31.49,33.25,36.41,35.38,33.61,32.62,32.34,32.33,30.84,29.63,28.61,28.04,27.46,26.64,25.59,22.41,18.59,17.63,16.87,16.36,14.07,11.53,9.45,8.12,7.26,6.79,6.28,6.13,6,5.87,5.89,4.97,-3.23,-3.36,-3.67,-4.11,-4.63,-5.25,-5.88,-6.53,-7.15,-7.73,-8.15,-8.49,-8.66,-8.77,-8.80,-8.80,-8.77,-8.75,-8.50,-8.84,-9.38,-9.76,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-17,-16,-16,-16,-16,-16,-16,-16,-15,-14,-14,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.63,-8.88,-8.39,-8.10,-8.74,-9.40,-10,-11,-13,-14,-13,-12,-10,-9.27,-7.73,-6.17,-4.88,-3.93,-3.52,-3.25,-3.11,-2.99,-2.80,-2.50,-1.99,-1.27,-0.52,0.13,0.70,0.87,0.96,0.98,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,3.40,3.24,3.07,2.87,2.73,2.57,2.39,2.26,2.13,2,1.88,1.76,1.63,1.50,1.37,1.25,1.14,1.08,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.90,0.85,0.72,0.53,0.37,0.20,0.08,0,0,0,0,0,0,0.08,0.13,0.25,0.39,0.53,0.65,0.75,0.76,0.82,0.83,0.84,0.87,0.90,0.96,0.97,0.99,1.08,1.25,1.62,2,2,2,2,2,2,2,2,2,3,3,5,8,10,13,16,18,20,21,21,19,17,15,12,11,9,6,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3.07,4.86,7.21,11.22,15.85,21.65,25.63,24.49,19.70,15.71,12.82,12.92,13.01,13.54,14.08,14.83,15,17.95,20.53,23.15,25.34,27.20,28.28,29.15,29.48,29.91,30.11,30.24,31.21,32.37,34.54,35.50,33.87,32.52,31.59,32.38,31.61,31,30.23,29.33,28.50,27.32,26.61,24.61,21.08,17.49,15.51,15.20,13.90,12.10,9.42,8.37,7.29,7,6.72,6.23,6,5.87,5.87,5.07,5,-3.16,-3.34,-3.55,-3.88,-4.36,-4.88,-5.47,-6.04,-6.63,-7.15,-7.53,-7.88,-8.13,-8.30,-8.42,-8.50,-8.53,-8.50,-8.48,-8.14,-8.38,-8.68,-9.29,-9.88,-10,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-13,-12,-12,-12,-11,-11,-11,-10,-10,-11,-11,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-15,-14,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-9.29,-8.73,-8.23,-8.75,-9.59,-10,-11,-12,-13,-14,-13,-11,-10,-8.38,-6.88,-5.50,-4.40,-3.67,-3.28,-3.13,-3.01,-2.97,-2.86,-2.55,-1.93,-1.09,-0.14,0.50,0.83,0.90,0.97,0.99,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,4,4,4,3,3,3,3.20,3.03,2.88,2.73,2.57,2.39,2.25,2.13,2.01,1.89,1.76,1.63,1.50,1.37,1.25,1.15,1.09,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.89,0.85,0.72,0.52,0.36,0.21,0.10,0.01,0,0,0,0,0.02,0.10,0.20,0.32,0.48,0.62,0.75,0.83,0.87,0.87,0.87,0.87,0.89,0.91,0.97,1,1.01,1.14,1.40,1.75,2,2,2,2,2,2,2,2,2,3,4,5,7,10,14,17,20,20,19,18,16,14,12,11,9,7,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3.10,5.16,8.77,12.71,17.28,21.71,25.61,25.47,21.78,17.76,16.85,15.90,15.53,15.47,15.75,16.25,17.04,18.98,21.63,24.08,26.14,27.71,28.74,29.25,29.49,29.26,30.11,30.88,31.76,32.70,33.62,33.59,32.58,31.38,31.13,31.24,31.35,31.23,30.87,30.50,28.45,26.92,25.59,23.59,19.39,17.10,15.49,14.14,12.49,10.47,9.04,7.88,7.12,6.75,6.23,6.11,5.87,5.87,5.07,5,5,-3.13,-3.25,-3.42,-3.67,-4.10,-4.50,-5,-5.50,-6,-6.49,-6.89,-7.25,-7.59,-7.84,-8.02,-8.17,-8.28,-8.36,-8.34,-8.28,-8.12,-8.13,-8.52,-9.17,-9.92,-10,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.75,-9.74,-10,-10,-11,-12,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-12,-12,-11,-11,-11,-11,-12,-12,-11,-11,-10,-9.38,-8.53,-8.72,-9.91,-10,-12,-13,-14,-14,-13,-12,-10,-9.11,-7.47,-6,-4.90,-4.03,-3.50,-3.18,-3.03,-2.92,-2.85,-2.68,-2.38,-1.75,-0.87,0.01,0.63,0.88,0.96,0.98,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,2.97,2.87,2.74,2.57,2.38,2.25,2.13,2.01,1.89,1.76,1.63,1.50,1.37,1.25,1.15,1.10,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.97,0.96,0.89,0.84,0.72,0.51,0.37,0.22,0.11,0.02,0,0,0,0,0.03,0.12,0.23,0.36,0.50,0.65,0.76,0.85,0.87,0.88,0.89,0.90,0.95,0.96,0.99,1.02,1.13,1.34,1.59,1.87,2,2,2,2,2,2,2,2,2,3,4,5,7,10,14,17,19,18,17,15,13,12,11,10,8,5,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,4.01,6.20,9.25,13.70,18.04,22.62,25.60,25.50,23.95,21.82,20.34,19.07,18,17.42,17.42,17.87,18.88,20.62,22.92,25.32,27.24,28.57,29.38,29.70,29.72,29.76,30.10,30.88,32.79,32.79,31.96,31.27,30.29,29.33,30.40,30.45,31.20,31.58,31.59,30.60,28.60,25.83,23.58,20.73,17.40,16.04,15.54,13.54,11.54,9.41,8.22,7.32,6.79,6.17,6.12,5.88,5.89,5.07,5,5,5,-3.12,-3.18,-3.29,-3.52,-3.79,-4.13,-4.50,-4.93,-5.39,-5.84,-6.25,-6.63,-6.99,-7.28,-7.55,-7.79,-8,-8.15,-8.26,-8.35,-8.40,-8.53,-8.77,-8.88,-9.47,-10,-10,-11,-12,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-9.78,-9.25,-9.24,-9.43,-9.90,-10,-11,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.43,-9.12,-9.67,-10,-12,-13,-13,-14,-14,-12,-11,-9.72,-8.09,-6.53,-5.25,-4.25,-3.74,-3.34,-3.11,-2.91,-2.76,-2.62,-2.38,-2,-1.38,-0.61,0.14,0.70,0.90,0.98,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,2.87,2.74,2.57,2.38,2.25,2.13,2.02,1.90,1.77,1.64,1.50,1.37,1.25,1.14,1.10,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.95,0.89,0.83,0.66,0.51,0.37,0.23,0.12,0.02,0,0,0,0,0.08,0.13,0.25,0.37,0.50,0.65,0.76,0.85,0.87,0.90,0.91,0.95,0.96,0.98,1,1.12,1.26,1.49,1.72,1.97,2,2,2,2,2,2,2,2,2,3,4,5,7,10,14,15,15,15,14.01,12.07,12.10,11.12,11.87,10.87,8.87,6.10,4.07,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,4.12,6.20,9.90,14.01,18.63,22.61,26.59,27.04,26.60,25.29,24.08,22,19.97,18.99,18.84,19.12,20.11,21.84,24.20,27.12,28.54,29.73,30.29,30.40,29.91,29.73,29.82,30.11,30.82,30.82,30.16,30,29.14,29.12,30.12,30.73,30.87,31.67,30.63,28.61,26.59,24.16,21.58,18.58,15.41,14.40,14.61,13.61,10.37,8.36,7.32,6.79,6.12,6.12,5.89,5.92,5.02,5,5,5,5,-3.09,-3.13,-3.18,-3.36,-3.53,-3.77,-4.05,-4.43,-4.80,-5.18,-5.60,-5.98,-6.35,-6.67,-7,-7.34,-7.62,-7.88,-8.12,-8.34,-8.55,-8.87,-9.23,-9.64,-9.92,-10,-10,-11,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-10,-9.50,-9.13,-9.49,-9.89,-10,-10,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-11,-11,-11,-11,-10,-10,-9.55,-10,-10,-11,-13,-14,-14,-13,-13,-12,-10,-8.50,-7,-5.66,-4.61,-3.87,-3.41,-3.18,-2.98,-2.75,-2.52,-2.25,-1.89,-1.48,-0.88,-0.25,0.35,0.75,0.91,0.98,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,2.77,2.59,2.38,2.25,2.12,2.02,1.91,1.83,1.65,1.51,1.37,1.25,1.14,1.09,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.95,0.88,0.83,0.66,0.51,0.37,0.24,0.12,0.03,0,0,0,0.01,0.09,0.15,0.25,0.38,0.51,0.64,0.76,0.86,0.88,0.91,0.95,0.96,0.98,1,1.08,1.22,1.40,1.62,1.83,1.91,1.99,2,2,2,2,2,2,2,2,3,4,5,7,10,13,13,12,12.07,12.11,12.14,12.16,12.86,12.78,11.78,9.79,5.16,4.14,3.03,2.07,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,4.12,6.20,10.13,14.32,18.36,23.25,26.67,29.50,30.33,28.21,26.08,23.10,21.11,19.91,19.61,19.86,20.76,22.49,25.12,28.15,30.17,31.24,31.37,30.50,29.70,29.21,28.88,28.83,28.16,28.16,28.15,29.14,30.87,30.11,30.77,30.15,30.73,29.67,28.14,26.29,24.23,22.09,19.58,16.41,13.41,12.82,12.08,10.87,9.32,7.85,6.90,6.12,6,6,6,5,5,5,5,5,5,-3,-3.01,-3.05,-3.15,-3.28,-3.47,-3.73,-4,-4.27,-4.62,-4.99,-5.37,-5.73,-6.09,-6.43,-6.80,-7.16,-7.51,-7.88,-8.23,-8.60,-9,-9.52,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.99,-9.41,-9.65,-9.98,-10,-10,-11,-11,-12,-12,-13,-13,-13,-14,-14,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.68,-9.91,-10,-11,-12,-13,-14,-13,-13,-12,-10,-9,-7.37,-6.01,-4.89,-4.11,-3.60,-3.25,-3.03,-2.84,-2.54,-2.22,-1.75,-1.29,-0.80,-0.35,0.13,0.53,0.84,0.98,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,2.64,2.38,2.24,2.12,2.01,1.91,1.83,1.70,1.52,1.37,1.25,1.13,1.08,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.91,0.87,0.77,0.65,0.50,0.37,0.25,0.12,0.07,0,0,0,0.03,0.11,0.16,0.27,0.39,0.52,0.64,0.75,0.87,0.89,0.95,0.96,0.98,1,1.02,1.13,1.35,1.58,1.77,1.89,1.98,2,2,2,2,2,2,2,2,3,3,4,5,6,9,11,10,9.07,10.12,12.16,14.03,14.75,14.22,13.74,11.74,8.25,5.24,4.21,3.16,2.12,2.07,2,2,2,2,2,2,2,2,2,2,2,2,2,3,4.12,6.20,10.25,14.75,19.64,24.62,27.60,30.54,31.36,29.22,26.10,23.59,21.08,20.40,19.91,19.99,20.82,22.50,25,28.22,31.25,32.32,32.39,30.17,29.02,28.09,27.85,27.14,27.14,27.14,28.13,30.11,31.88,31.90,29.82,28.98,28.74,27.70,25.74,23.87,22,19.97,17.58,14.89,12.40,11.07,10.01,9.02,8,7.12,6.20,6.12,6,6,6,5,5,5,5,5,5,-2.90,-2.88,-2.89,-2.92,-3.02,-3.15,-3.36,-3.54,-3.79,-4.11,-4.41,-4.75,-5.11,-5.48,-5.87,-6.25,-6.63,-7.03,-7.47,-7.88,-8.37,-8.89,-9.50,-10,-10,-11,-11,-11,-11,-11,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-9.90,-9.93,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.87,-10,-11,-12,-13,-13,-13,-13,-11,-10,-9.12,-7.63,-6.18,-5,-4.29,-3.75,-3.38,-3.13,-2.92,-2.68,-2.36,-1.85,-1.25,-0.63,-0.12,0.27,0.60,0.82,0.91,0.98,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,2.37,2.21,2.10,2,1.95,1.85,1.70,1.53,1.37,1.25,1.13,1.08,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.91,0.87,0.76,0.64,0.50,0.37,0.25,0.13,0.08,0.01,0,0.01,0.07,0.12,0.21,0.32,0.41,0.53,0.65,0.75,0.86,0.90,0.96,0.98,1,1.03,1.12,1.26,1.50,1.73,1.87,1.98,2.02,2.12,2.13,2,2,2,2,2,3,3,3,4,5,6,7,8.01,9.08,9.23,11.29,14.63,16.61,17.59,15.60,13.62,10.34,7.29,6.28,5.25,4.23,3.17,3.12,3.07,3,2,2,2,2,2,2,2,2,2,2.08,2.37,3.03,4.27,6.16,10.75,14.71,19.66,23.63,27.61,28.60,29.39,27.53,25.61,23.51,21.86,20.61,19.90,19.67,20,21.87,24.36,27.23,29.29,31.35,30.41,29.54,27.86,26.86,25.12,26.87,27.12,28.12,29.87,30.89,31.90,30.92,28.12,27.16,26.10,24.85,23.28,21.63,19.83,17.90,15.70,13.39,11.25,9.38,8.36,7.33,7.02,6.24,6.14,6,6,6,5,5,5,5,5,5,5,-2.72,-2.63,-2.63,-2.63,-2.73,-2.85,-2.98,-3.13,-3.35,-3.60,-3.87,-4.15,-4.50,-4.88,-5.25,-5.63,-6.03,-6.48,-6.90,-7.38,-7.90,-8.50,-9.15,-9.85,-10,-10,-11,-11,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-11,-11,-11,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.73,-9.38,-9.75,-9.99,-10,-10,-10,-10,-11,-13,-13,-13,-13,-13,-12,-10,-9.05,-7.63,-6.27,-5.15,-4.29,-3.74,-3.47,-3.22,-3,-2.76,-2.47,-2,-1.38,-0.73,-0.10,0.39,0.66,0.83,0.90,0.97,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,2,2.12,2.03,2,1.96,1.86,1.73,1.53,1.38,1.25,1.12,1.03,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.96,0.87,0.76,0.63,0.50,0.37,0.25,0.14,0.09,0.02,0.01,0.02,0.09,0.13,0.24,0.34,0.45,0.57,0.65,0.75,0.86,0.91,0.99,1,1.08,1.14,1.26,1.46,1.65,1.85,1.96,2,2.12,2.34,2.70,3,3,3,3,3,3,3,3,4,5,6,6.95,7.12,8.25,10.35,13.41,16.57,20.50,19.47,16.48,12.50,9.47,8.39,8.65,6.91,5.26,5.23,6.83,6.11,4.01,3,2.01,2.16,2.09,2.02,2,2,2,2.01,2.12,2.41,2.98,4.11,5.50,8.87,12.25,15.29,20.07,23.63,25.37,26.60,26.41,24.83,23.61,22.09,20.75,19.73,19.01,18.96,20.74,23.03,26.27,27.35,28.41,27.74,27.08,26.70,25.21,25.10,27,28.89,29.89,30.90,30.91,29.95,28.02,26.92,25.13,23.78,22.11,20.70,19.07,17.63,15.62,13.62,11.75,9.90,8.36,7.34,6.82,6.25,6.13,6,5.92,6,5,5,5,5,5,5,5,5,-2.30,-2.22,-2.23,-2.22,-2.28,-2.40,-2.50,-2.66,-2.84,-3.02,-3.27,-3.55,-3.88,-4.25,-4.63,-5,-5.41,-5.85,-6.27,-6.75,-7.29,-7.89,-8.53,-9.22,-9.79,-10,-10,-10,-11,-11,-11,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-10,-9.28,-8.63,-8.88,-9.12,-9.63,-9.80,-9.75,-11,-12,-13,-14,-14,-13,-12,-11,-9.52,-7.73,-6.38,-5.22,-4.38,-3.77,-3.40,-3.23,-3.02,-2.84,-2.54,-2.13,-1.55,-0.91,-0.28,0.26,0.64,0.85,0.90,0.97,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1.97,1.87,1.75,1.57,1.37,1.25,1.12,1.07,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.87,0.76,0.63,0.50,0.37,0.25,0.15,0.10,0.03,0.02,0.07,0.11,0.16,0.25,0.37,0.48,0.59,0.70,0.77,0.87,0.97,1.02,1.12,1.21,1.32,1.48,1.64,1.83,1.91,1.99,2.07,2.24,2.51,2.85,3,3,3,3,3,3,3,3,4,5,5.92,6.12,7.21,8.36,11.25,14.67,19.41,21.38,19.38,15,10.59,9.54,10.25,10.58,8.34,7.29,9.12,11.78,10.85,7.07,5.01,3.39,2.73,2.26,2.11,2.07,2.07,2.04,2.04,2.12,2.37,2.84,3.73,5.36,7.36,9.25,12.75,16.70,20.13,23.35,25.63,26.24,25.41,23.88,22.25,20.70,19.40,18.54,17.86,19.37,21.22,23.34,24.40,24.90,24.99,24.83,24.25,24.16,25.04,27.92,29.92,30.95,30.96,29.97,27.99,26,25.02,23.88,21.16,19.23,17.73,16.21,14.66,12.99,11.36,9.99,8.65,7.33,6.79,6.26,6.12,6,5.88,5.97,5,5,5,5,5,5,5,5,5,-1.65,-1.59,-1.62,-1.61,-1.67,-1.86,-1.91,-2.11,-2.22,-2.39,-2.63,-2.89,-3.25,-3.61,-4,-4.38,-4.76,-5.15,-5.59,-6.01,-6.52,-7.12,-7.75,-8.38,-8.98,-9.50,-9.99,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.76,-9.12,-8.50,-8.14,-8.53,-9.12,-9.30,-9.89,-11,-13,-13,-13,-13,-13,-11,-10,-8.34,-6.55,-5.41,-4.43,-3.84,-3.42,-3.22,-3.01,-2.88,-2.63,-2.25,-1.73,-1.09,-0.42,0.12,0.51,0.76,0.88,0.96,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1.98,1.95,1.77,1.58,1.37,1.23,1.11,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.95,0.87,0.76,0.63,0.50,0.37,0.25,0.15,0.11,0.07,0.07,0.10,0.12,0.22,0.28,0.38,0.50,0.62,0.73,0.84,0.91,1,1.12,1.22,1.33,1.47,1.63,1.82,1.90,1.98,2,2.09,2.28,2.62,2.97,3,3,3,3,3,3,3,3,4,4.99,5.87,6.17,7.25,8.45,11.51,15.38,19.35,20.33,17.29,13.67,10.66,10.62,12.40,12.49,10.40,9.34,11.71,15.75,15.83,12.89,8.63,5.63,3.53,2.46,2.23,2.14,2.16,2.14,2.11,2.12,2.28,2.67,3.46,4.71,6.26,7.53,9.23,12.25,17.28,22.70,26.58,27.47,26.38,24.29,22.27,20.48,19.01,17.78,17.50,17.65,19.21,20.58,21.50,22.42,22.37,22.29,23.22,25.11,27,28,28,28,28,26,25,25,24,21.92,18.87,16.17,14.76,13.25,11.28,10.29,9.32,8.32,7.29,6.86,6.25,6.11,5.96,5.87,5.92,5,5,5,5,5,5,5,5,5,5,-0.75,-0.75,-0.85,-0.75,-0.85,-1.01,-1.15,-1.38,-1.41,-1.60,-1.78,-2.13,-2.50,-2.91,-3.36,-3.75,-4.13,-4.50,-4.88,-5.27,-5.73,-6.24,-6.78,-7.38,-8,-8.61,-9.16,-9.75,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.49,-8.84,-8.28,-7.91,-7.93,-8.60,-9.13,-10,-11,-12,-12,-13,-12,-12,-10,-8.92,-7.25,-5.68,-4.74,-3.92,-3.47,-3.15,-2.93,-2.76,-2.63,-2.38,-1.92,-1.25,-0.51,0.20,0.62,0.84,0.90,0.97,0.98,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1.99,1.85,1.60,1.37,1.20,1.09,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.91,0.87,0.75,0.63,0.50,0.37,0.26,0.16,0.12,0.08,0.09,0.12,0.15,0.25,0.34,0.45,0.53,0.64,0.76,0.87,1,1.10,1.21,1.33,1.45,1.59,1.75,1.88,1.97,1.99,2,2.09,2.36,2.66,2.97,3,3,3,4,4,4,4,4,4.01,4.98,5.83,6.23,7.38,9.45,11.58,13.64,16.28,17.25,15.21,12.75,10.74,11.70,13.35,13.41,11.79,10.37,13.02,16.75,18.79,15.70,11.37,7.46,4.26,2.75,2.33,2.25,2.26,2.24,2.15,2.12,2.25,2.62,3.28,4.33,5.70,7.48,9.36,12.21,16.24,22.82,27.65,28.54,26.46,24.39,21.91,20.02,18.48,17.25,16.51,16.51,17.50,18.50,20.22,21.25,21.36,23.02,24.82,25.91,27,27,26,26,25,24,23,22,21,19,16.07,13.16,12.28,10.36,9.45,8.50,8.01,7.32,6.51,6.35,6.12,5.91,5.79,5.72,5.14,5.12,5,5,5,5,5,5,5,5,5,0.90,-0.40,0.20,0.50,0.46,0.12,-0.12,-0.39,-0.37,-0.51,-0.75,-1.16,-1.66,-2.22,-2.73,-3.15,-3.52,-3.88,-4.17,-4.51,-4.88,-5.35,-5.86,-6.42,-7.04,-7.68,-8.36,-9,-9.61,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-11,-10,-10,-9.63,-9.09,-8.52,-8.09,-7.72,-8.02,-8.59,-9.13,-9.98,-10,-11,-11,-11,-11,-10,-9.22,-7.75,-6.29,-5.02,-4.23,-3.59,-3.15,-2.86,-2.62,-2.40,-2.16,-1.80,-1.25,-0.63,0.07,0.58,0.84,0.91,0.99,1,1,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1.98,1.70,1.34,1.13,1.02,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.91,0.87,0.75,0.62,0.50,0.37,0.26,0.16,0.12,0.11,0.11,0.13,0.21,0.26,0.37,0.49,0.61,0.73,0.84,0.96,1.08,1.16,1.28,1.40,1.52,1.66,1.78,1.91,1.98,1.99,2.01,2.15,2.41,2.73,2.97,3,3,3,4,4,4,4,4,4.07,4.99,5.88,6.82,8.23,9.96,11.87,13.70,14.98,15.10,13.77,11.77,11.75,12.99,14.29,14.38,12.65,11.41,13.32,15.97,18.78,17.47,13.15,8.74,5.12,3.14,2.49,2.32,2.29,2.25,2.16,2.12,2.23,2.59,3.25,4.21,5.62,7.75,10.50,14,18.83,24.79,27.75,27.64,25.08,23.03,21.12,19.34,17.79,16.48,15.49,15.49,16.48,18.46,19.40,20.91,22.67,23.75,23.85,23.98,24,25,25,25,24,22,20,19,17,15.84,13.85,12.09,10.60,9.41,8.41,7.76,7.22,6.74,6.37,6.11,5.96,5.78,5.62,5.39,5.15,5.01,5,5,5,5,5,5,5,5,5,1,1.03,1.46,2.25,2.76,1.78,1.25,1.10,1.24,1,0.62,0,-0.73,-1.43,-2.09,-2.59,-2.91,-3.24,-3.50,-3.75,-4.09,-4.48,-4.93,-5.50,-6.13,-6.80,-7.51,-8.24,-8.90,-9.61,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-16,-17,-17,-17,-16,-17,-17,-17,-16,-16,-16,-15,-15,-14,-14,-13,-12,-11,-11,-10,-9.77,-9.52,-9.30,-8.88,-8.15,-7.89,-8.04,-8.42,-8.99,-9.52,-10,-10,-10,-10,-9.88,-9.01,-7.89,-6.63,-5.50,-4.49,-3.78,-3.24,-2.80,-2.48,-2.16,-1.88,-1.54,-1.11,-0.59,0,0.50,0.82,0.99,1.09,1.12,1.09,1.02,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.12,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.91,0.87,0.75,0.62,0.50,0.37,0.26,0.20,0.12,0.12,0.12,0.15,0.24,0.33,0.41,0.52,0.64,0.76,0.89,1.01,1.13,1.26,1.38,1.50,1.62,1.75,1.85,1.95,1.98,2,2.09,2.26,2.57,2.84,2.98,3,3,3,4,4,4,4,4,4.10,5.01,6.04,7.17,8.58,10.53,12.47,14.15,14.88,14.85,13.84,13.73,13.70,14.25,14.24,14.36,12.99,12.46,12.32,15.78,18.78,18.29,14.01,9.47,5.76,3.53,2.62,2.33,2.25,2.22,2.16,2.13,2.25,2.58,3.20,4.16,5.70,7.98,11.39,14.92,18.89,21.87,24.82,24.76,23.21,21.63,20,18.39,17.01,15.85,15.27,15.42,17.33,19.60,20.22,20.75,21.74,21.82,21.89,21.95,22,23,23,24,23,20,17.02,15.25,14.35,13.09,11.78,10.50,9.39,8.46,7.72,7.13,6.72,6.39,6.15,5.98,5.83,5.65,5.48,5.25,5.10,5,5,5,5,5,5,5,5,5,5,14,11,8.99,8.82,7.12,2.50,3.26,3.49,3.49,3.03,2.32,1.37,0.35,-0.63,-1.42,-1.90,-2.28,-2.54,-2.77,-3,-3.27,-3.64,-4.12,-4.66,-5.29,-6,-6.75,-7.50,-8.27,-9.02,-9.75,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-13,-14,-14,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-18,-17,-17,-17,-16,-16,-15,-14,-14,-13,-12,-11,-10,-10,-10,-10,-9.92,-9.52,-9.16,-9.03,-8.30,-8.50,-8.75,-9.10,-9.26,-9.37,-9.26,-8.99,-8.42,-7.63,-6.67,-5.65,-4.75,-3.98,-3.37,-2.85,-2.38,-2,-1.63,-1.25,-0.87,-0.40,0.08,0.51,0.87,1.09,1.23,1.28,1.35,1.35,1.35,1.28,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.98,0.97,0.97,0.91,0.87,0.75,0.62,0.50,0.38,0.26,0.20,0.13,0.12,0.14,0.21,0.26,0.37,0.48,0.60,0.73,0.85,0.98,1.11,1.24,1.37,1.50,1.61,1.72,1.78,1.87,1.96,1.98,2.01,2.14,2.39,2.72,2.97,2.99,3,3,3,4,4,4,4,4,4.17,5.10,6.14,7.38,9.13,11.03,13.14,15.09,15.57,15.72,15.62,15.45,15.28,14.97,14.48,13.74,13.02,12.52,13.34,15.25,18.79,18.21,13.90,9.37,5.87,3.62,2.66,2.27,2.20,2.22,2.25,2.28,2.38,2.63,3.13,4.03,5.48,7.61,10.33,13,16,19,20.95,21.90,21.12,20.10,18.76,17.67,16.12,15.07,14.38,15.38,17.88,20.64,21.67,20.09,19.20,19.12,19.09,19.04,21,21,22,22,19.96,17.12,13.50,12.74,11.90,10.99,10.10,9.23,8.41,7.71,7.12,6.70,6.37,6.12,6,5.87,5.74,5.57,5.37,5.16,5.07,5,5,5,5,5,5,5,5,5,5,20,17,14,13,12.98,9.50,7.64,6.85,6.32,5.45,4.25,2.87,1.50,0.25,-0.59,-1.17,-1.53,-1.75,-1.98,-2.18,-2.50,-2.88,-3.38,-3.97,-4.61,-5.29,-6.05,-6.87,-7.65,-8.43,-9.15,-9.84,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-15,-16,-16,-17,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-12,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.97,-8.93,-8.88,-8.68,-8.59,-8.38,-8.10,-7.66,-7.12,-6.39,-5.62,-4.78,-4.11,-3.43,-2.88,-2.38,-1.89,-1.47,-1.02,-0.62,-0.17,0.25,0.64,1,1.25,1.46,1.59,1.65,1.73,1.74,1.70,1.86,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.98,0.97,0.97,0.89,0.84,0.75,0.62,0.50,0.38,0.27,0.22,0.16,0.15,0.20,0.24,0.33,0.40,0.51,0.63,0.76,0.89,1.03,1.20,1.34,1.47,1.59,1.66,1.76,1.85,1.89,1.96,1.99,2.07,2.25,2.52,2.84,2.98,3,3,4,3,4,4,4,4,4.07,4.25,5.25,6.32,7.62,9.46,11.48,13.54,15.37,16.82,16.97,17.11,17.13,16.96,15.99,14.84,13.75,12.73,12.61,13.39,15.70,17.83,15.85,12.50,8.48,5.22,3.29,2.57,2.25,2.24,2.40,2.62,2.74,2.76,2.85,3.13,3.85,4.99,6.71,8.73,11,13,16,18,19.08,19.88,18.87,17.16,16.23,15.12,14.07,13.29,15.29,18.71,20.73,20.76,19.16,17.12,17.11,17.08,18,19,20,19.99,19.82,16.95,14.62,12.62,11.12,10.16,9.45,8.82,8.24,7.65,7.14,6.74,6.39,6.16,6,5.88,5.76,5.62,5.47,5.26,5.12,5.02,5,5,5,5,5,5,4.99,4.99,4.99,4.99,22,21,18,16,15,13.98,12.25,10.76,9.38,8.03,6.32,4.50,2.74,1.16,0.41,-0.22,-0.52,-0.74,-0.93,-1.25,-1.65,-2.16,-2.75,-3.38,-4.03,-4.75,-5.50,-6.29,-7.10,-7.86,-8.59,-9.23,-9.78,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-14,-14,-15,-16,-16,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-16,-16,-15,-14,-13,-12,-11,-10,-10,-10,-10,-10,-11,-11,-11,-10,-9.76,-8.99,-8.38,-7.97,-7.50,-7.03,-6.52,-5.97,-5.35,-4.67,-4.03,-3.49,-2.91,-2.38,-1.88,-1.37,-0.88,-0.39,0.08,0.49,0.87,1.21,1.49,1.72,1.87,2,2.12,2.15,2.25,2.25,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.98,0.97,0.95,0.88,0.84,0.74,0.62,0.50,0.38,0.28,0.23,0.20,0.20,0.23,0.26,0.36,0.47,0.59,0.71,0.85,0.98,1.12,1.25,1.39,1.52,1.64,1.75,1.83,1.87,1.91,1.97,1.99,2.07,2.28,2.62,2.97,2.99,3,3,3,4,4,4,4,4,4.12,4.75,5.49,6.62,7.98,9.70,11.78,14.03,16.04,17.65,18.21,18.59,18.66,18.77,16.89,15.41,13.88,12.76,12.63,13.42,15.79,17.77,15.21,11.37,7.29,4.37,2.92,2.41,2.24,2.39,2.82,3.27,3.50,3.39,3.20,3.20,3.66,4.50,5.75,7.37,9,12,14,16,17.07,18.89,17.87,16.13,15,13.89,13.01,12.16,14.83,16.83,18.84,20.85,18.13,17.11,16.10,15.92,15.97,17,16.88,16.60,15.62,14.25,12.53,11.03,9.86,8.99,8.37,7.87,7.48,7.08,6.73,6.41,6.22,6.02,5.89,5.77,5.65,5.50,5.37,5.22,5.10,5.01,5,5,5,5,5,5,4.99,4.99,4.97,4.84,21,22,20,18,18,18,17,14.83,12.10,10.40,8.36,6.33,4.16,2.47,1.78,1.26,0.97,0.73,0.37,-0.12,-0.74,-1.39,-2.10,-2.77,-3.50,-4.23,-5,-5.76,-6.54,-7.29,-8,-8.62,-9.15,-9.66,-10,-10,-11,-11,-11,-11,-12,-12,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-17,-17,-17,-18,-18,-18,-19,-19,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-14,-13,-12,-10,-10,-10,-10,-10,-10,-11,-12,-12,-11,-10,-9.02,-8.12,-7.39,-6.76,-6.15,-5.60,-5.02,-4.48,-3.91,-3.38,-2.88,-2.38,-1.87,-1.34,-0.78,-0.25,0.25,0.73,1.13,1.50,1.77,2.01,2.23,2.37,2.50,2.58,2.62,2.63,2.98,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.98,0.97,0.95,0.89,0.85,0.75,0.62,0.50,0.38,0.28,0.24,0.21,0.21,0.25,0.32,0.38,0.50,0.62,0.75,0.88,1.02,1.20,1.35,1.49,1.62,1.73,1.82,1.87,1.89,1.95,1.98,1.99,2.03,2.33,2.64,2.99,3,3,3,3,4,4,4,4,4.11,4.16,5.04,5.90,7,8.37,9.96,12.10,14.83,16.95,18.53,19.25,19.70,20.54,18.97,17.74,15.90,14.60,13.85,13.77,14.58,16.28,17.70,15.22,10.90,6.39,3.86,2.71,2.29,2.25,2.57,3.22,4.16,4.71,4.12,3.52,3.32,3.62,4.32,5.34,6.66,8,11,13,14.99,15.95,15.91,15.88,14.87,13.87,12.87,11.15,11.87,12.15,14.15,16.14,17.86,17.87,16.88,14.91,13.95,13.02,13.25,13.59,13.36,12.73,11.75,10.66,9.62,8.75,8.09,7.60,7.24,6.89,6.63,6.39,6.22,6.03,5.90,5.78,5.65,5.52,5.38,5.25,5.13,5.07,5,5,5,5,5,4.99,4.99,4.99,4.98,4.95,4.70,21,22,20,18,19,20,19,16,14.12,12.26,10.28,8.34,6.26,4.25,3.97,3.38,3.01,2.61,1.99,1.20,0.33,-0.55,-1.38,-2.13,-2.88,-3.64,-4.43,-5.25,-6.04,-6.79,-7.50,-8.09,-8.61,-9.13,-9.75,-10,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-17,-17,-17,-18,-18,-19,-19,-19,-19,-19,-18,-18,-18,-18,-17,-17,-16,-15,-14,-13,-12,-10,-10,-10,-10,-10,-11,-12,-12,-12,-11,-10,-8.88,-7.76,-6.89,-6.13,-5.43,-4.86,-4.28,-3.76,-3.27,-2.78,-2.30,-1.80,-1.28,-0.75,-0.22,0.35,0.87,1.37,1.78,2.12,2.39,2.62,2.75,2.87,2.96,2.97,2.95,2.97,3,3,3,3,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.97,0.95,0.89,0.86,0.75,0.63,0.50,0.39,0.28,0.24,0.22,0.22,0.25,0.35,0.41,0.53,0.65,0.82,0.96,1.11,1.25,1.39,1.57,1.66,1.76,1.86,1.88,1.91,1.97,1.98,1.99,2.01,2.34,2.64,3,3,3,3,3,4,4,4,4.07,4.13,4.73,5.37,6.24,7.36,8.79,10.63,13.14,15.82,18.54,19.47,19.97,20.41,20.42,19.48,17.64,16.15,15.02,14.62,14.84,15.64,17.12,18.61,15.22,11.33,6.32,3.95,2.70,2.29,2.26,2.62,3.35,4.46,4.83,4.37,3.66,3.39,3.64,4.33,5.26,6.50,8,10,12,14,13.98,13.95,13.09,13.11,12.87,11.88,11.10,10.13,10.92,11.13,13.87,15.87,15.88,14.90,13.04,11.12,10.35,10.70,11,10.85,10.39,9.83,9.12,8.49,7.88,7.41,7.03,6.75,6.51,6.36,6.20,6.07,5.95,5.82,5.70,5.57,5.40,5.27,5.16,5.10,5.01,5,5,5,5,5,4.99,4.99,4.99,4.98,4.88,4.50,18,19,18,17,18,20,20,18,15,13.82,12.16,10.57,8.87,7.47,6.63,6.01,5.41,4.70,3.75,2.61,1.41,0.32,-0.63,-1.49,-2.26,-3.10,-3.91,-4.77,-5.63,-6.39,-7.12,-7.68,-8.18,-8.53,-9.13,-9.63,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-13,-14,-15,-15,-16,-16,-17,-17,-17,-18,-18,-18,-18,-19,-18,-18,-18,-18,-18,-18,-17,-16,-16,-15,-14,-13,-11,-10,-9.89,-10,-10,-10,-11,-12,-12,-11,-10,-9.79,-8.50,-7.35,-6.38,-5.55,-4.87,-4.25,-3.68,-3.18,-2.73,-2.25,-1.75,-1.24,-0.72,-0.14,0.39,0.97,1.50,2.01,2.49,2.86,3.12,3.26,3.37,3.39,3.41,3.41,3.25,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.95,0.90,0.87,0.76,0.64,0.51,0.39,0.28,0.24,0.22,0.24,0.27,0.37,0.48,0.59,0.72,0.86,1,1.14,1.32,1.48,1.62,1.74,1.84,1.87,1.90,1.95,1.97,1.99,1.99,2,2.33,2.75,3,3,3,3,3,4,4,4,4.10,4.78,5.09,5.60,6.54,7.73,9.10,11.42,14.15,17.02,19.46,20.41,20.47,20.21,19.62,18.63,17.38,16.09,15.11,14.97,16.25,17.29,18.25,18.59,16.27,12.23,8.02,4.45,2.99,2.39,2.27,2.53,3.12,3.84,4.20,3.88,3.58,3.45,3.75,4.45,5.38,6.53,7.84,9.46,11,11.87,12.25,12.08,11.90,11.72,11.49,11.17,10.33,9.42,9.23,10.15,11.88,12.89,12.98,12.04,11.02,9.40,8.74,9.14,9.16,9.01,8.75,8.38,8,7.62,7.25,6.90,6.64,6.46,6.28,6.15,6.07,5.97,5.86,5.73,5.60,5.46,5.33,5.21,5.12,5.03,5,5,5,5,5,5,4.99,4.99,4.98,4.96,4.86,4.25,11,12,12,14,17,19,20,19,17,15,14.02,12.91,11.70,10.49,9.53,8.75,7.88,6.87,5.58,4.02,2.53,1.21,0.11,-0.86,-1.66,-2.52,-3.48,-4.38,-5.27,-6.13,-6.87,-7.50,-8,-8.43,-8.64,-9.03,-9.47,-9.79,-10,-10,-10,-10,-10,-11,-12,-12,-13,-14,-14,-15,-16,-16,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-11,-10,-9.43,-9.47,-9.98,-10,-11,-12,-12,-11,-10,-9.11,-7.88,-6.76,-5.86,-5.03,-4.36,-3.75,-3.18,-2.67,-2.17,-1.66,-1.15,-0.63,-0.10,0.48,1.02,1.61,2.16,2.75,3.25,3.65,3.91,4.02,4.01,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.96,0.91,0.87,0.77,0.66,0.52,0.39,0.28,0.23,0.22,0.24,0.28,0.38,0.50,0.62,0.75,0.88,1.02,1.21,1.37,1.51,1.65,1.77,1.87,1.90,1.95,1.96,1.98,1.99,2,2,2.12,3,3,3,3,3,4,4,4,4,4.87,5.07,5.49,6.09,6.89,8.04,9.97,12.25,15.15,18.13,21.38,21.35,20.83,20,19.03,17.97,16.92,15.99,15.12,16.37,17.70,19.29,19.40,19.50,17.40,14.09,8.82,5.28,3.32,2.50,2.27,2.37,2.73,3.12,3.36,3.38,3.35,3.48,3.88,4.60,5.52,6.61,7.77,9,10,10.66,10.88,10.82,10.63,10.54,10.42,10.13,9.71,9.32,9.25,9.72,10.38,10.87,10.82,10.28,9.51,8.82,8.37,8.12,8.02,7.87,7.71,7.49,7.25,7.01,6.77,6.59,6.40,6.27,6.16,6.10,6,5.89,5.78,5.64,5.50,5.37,5.25,5.13,5.08,5,5,5,5,5,5,5,4.99,4.99,4.98,4.95,4.78,4.02,1,1,8,12,15,18,20,18,17,16,15.98,15.47,14.51,13.37,12.37,11.39,10.25,8.95,7.25,5.37,3.57,1.99,0.70,-0.37,-1.24,-2.13,-3.11,-4.11,-5.04,-5.92,-6.73,-7.38,-7.92,-8.36,-8.72,-8.63,-8.89,-9.26,-9.53,-9.75,-9.88,-10,-10,-10,-11,-12,-13,-14,-14,-15,-15,-16,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-14,-13,-12,-11,-10,-9.47,-8.99,-9.66,-10,-10,-10,-10,-10,-9.25,-8.24,-7.13,-6.13,-5.25,-4.51,-3.87,-3.25,-2.73,-2.16,-1.63,-1.11,-0.53,0,0.58,1.12,1.70,2.25,2.87,3.50,4.12,4.62,4.88,4.98,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.96,0.91,0.88,0.83,0.71,0.57,0.39,0.27,0.22,0.21,0.24,0.33,0.41,0.53,0.65,0.78,0.95,1.09,1.25,1.40,1.59,1.73,1.84,1.88,1.95,1.96,1.97,1.99,2,2,2,2,3,3,3,3,3,4,4,4,5,5.07,5.41,6.01,6.72,7.67,8.97,10.66,13.09,16.02,19.09,22.25,22.22,21.17,19.91,18.70,17.50,16.51,16.03,16.09,17.50,19.24,20.29,20.36,19.42,16.52,12.35,8.66,5.60,3.62,2.61,2.28,2.29,2.45,2.63,2.83,2.97,3.12,3.45,3.97,4.72,5.62,6.63,7.70,8.64,9.41,9.89,10.08,9.97,9.76,9.62,9.53,9.41,9.17,8.99,8.91,9.04,9.27,9.46,9.35,9.07,8.63,8.23,7.86,7.58,7.38,7.25,7.11,6.98,6.83,6.65,6.52,6.40,6.33,6.24,6.15,6.10,6,5.88,5.75,5.62,5.48,5.33,5.21,5.11,5.03,5,5,5,5,5,5,5,5,5,5,4.91,4.73,3.82,-1,1,7,10,15,18,20,18,17,16,18,18.98,17.16,16.14,15.12,13.95,12.37,10.63,8.62,6.46,4.34,2.50,1.03,-0.13,-1.14,-2.05,-3,-3.97,-4.89,-5.78,-6.60,-7.26,-7.84,-8.25,-8.59,-8.59,-8.30,-8.64,-8.90,-9.12,-9.25,-9.52,-9.88,-10,-11,-12,-13,-14,-14,-14,-15,-16,-16,-16,-17,-17,-17,-17,-18,-18,-18,-18,-17,-17,-17,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.90,-9.59,-9.38,-9.51,-9.73,-9.74,-9.50,-8.99,-8.15,-7.25,-6.34,-5.42,-4.64,-4,-3.38,-2.78,-2.24,-1.64,-1.09,-0.50,0.10,0.65,1.25,1.83,2.40,3,3.64,4.35,5.10,5.63,5.96,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,4,4,4,4,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.95,0.89,0.85,0.74,0.59,0.39,0.25,0.20,0.16,0.24,0.34,0.47,0.60,0.72,0.85,0.98,1.12,1.27,1.47,1.62,1.75,1.87,1.90,1.96,1.97,1.99,1.99,2,2,2,2,2.99,3,3,3.04,3.07,3.89,4.12,4.86,5.03,5.39,6.02,6.73,7.60,8.63,10,11.35,13.47,17,19.89,22.16,23.09,21.37,19.95,18.57,17.32,16.45,16.23,16.99,18.62,20.48,22.25,21.33,18.39,15.04,10.40,7.61,5.51,3.84,2.87,2.49,2.40,2.39,2.46,2.57,2.73,2.99,3.38,3.99,4.75,5.65,6.65,7.62,8.49,9.12,9.50,9.60,9.49,9.27,9.15,9.01,8.87,8.73,8.59,8.49,8.48,8.57,8.57,8.50,8.34,8.02,7.75,7.49,7.25,7.09,6.95,6.82,6.71,6.62,6.51,6.47,6.39,6.36,6.28,6.25,6.14,6.07,5.91,5.76,5.61,5.46,5.28,5.16,5.10,5.02,5,5,5,5,5,5,5.01,5.02,5.03,5.02,4.95,4.64,3.50,-1,1,5,10,15,19,20,19,18,18,19,20,19.98,19.10,18,16.34,14.08,11.87,9.53,7.12,4.75,2.74,1.11,-0.16,-1.22,-2.13,-3,-3.88,-4.76,-5.63,-6.42,-7.13,-7.72,-8.13,-8.36,-8.37,-8.03,-8.13,-8.40,-8.59,-8.73,-9.03,-9.59,-10,-11,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-13,-12,-11,-10,-10,-9.88,-9.50,-9.22,-9.03,-8.79,-8.39,-7.85,-7.13,-6.28,-5.50,-4.75,-4.05,-3.49,-2.88,-2.28,-1.68,-1.11,-0.49,0.12,0.75,1.36,1.97,2.58,3.16,3.82,4.47,5.21,6.03,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,5,5,5,4,4,4,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.97,0.97,0.96,0.91,0.87,0.75,0.60,0.39,0.25,0.14,0.13,0.24,0.36,0.50,0.62,0.75,0.87,1,1.14,1.34,1.51,1.70,1.82,1.88,1.95,1.97,1.98,1.99,2,2,2,2,2.02,2.95,2.99,3.09,3.10,3.84,4.20,4.89,5.26,5.37,6.08,6.74,7.63,8.65,9.82,11.25,13.12,15.50,18.17,20.67,23.13,22.46,21.49,20.08,18.67,17.46,16.63,16.50,17.48,19.22,21.99,23.08,20.62,18.12,14.52,10.41,7.25,5.52,4.22,3.27,2.91,2.72,2.54,2.48,2.49,2.61,2.87,3.32,3.95,4.74,5.66,6.66,7.62,8.46,9.03,9.37,9.41,9.35,9.13,8.95,8.75,8.60,8.46,8.32,8.24,8.13,8.12,8.11,8,7.87,7.72,7.50,7.27,7.11,6.95,6.83,6.73,6.64,6.61,6.58,6.53,6.51,6.50,6.47,6.38,6.28,6.14,5.99,5.78,5.62,5.45,5.27,5.16,5.10,5.02,5,5,5,5,5,5.02,5.09,5.12,5.14,5.12,5,4.62,3.51,-0.97,1.03,4.95,9.96,14.97,18,21,21,21,20,20,21,22,23,21.64,18.22,15.34,12.62,10,7.37,4.82,2.62,0.88,-0.38,-1.38,-2.23,-3,-3.80,-4.63,-5.50,-6.28,-7,-7.61,-8,-8.25,-8.23,-7.88,-7.72,-7.97,-8.15,-8.29,-8.55,-9.12,-9.89,-10,-11,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-17,-16,-17,-17,-17,-16,-16,-15,-15,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.55,-9,-8.50,-8.02,-7.49,-6.87,-6.16,-5.42,-4.77,-4.13,-3.52,-2.93,-2.38,-1.75,-1.13,-0.50,0.13,0.77,1.40,2.07,2.72,3.37,4.02,4.70,5.37,6.03,7,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,6,6,5,5,5,4,4,4,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.97,0.97,0.96,0.88,0.78,0.62,0.38,0.22,0.12,0.12,0.24,0.38,0.57,0.72,0.83,0.91,1.02,1.21,1.38,1.60,1.75,1.87,1.90,1.96,1.98,1.99,2,2,2,2.12,2.14,2.84,2.89,3.12,3.12,3.84,4.25,5.11,5.74,6.13,6.38,6.64,7.53,8.65,10.07,11.32,12.45,15.21,17.49,19.64,21.60,23.13,22.63,21.57,20.27,18.88,17.64,16.79,16.65,17.45,19,21.83,21.89,20.10,18.17,15.82,12.75,9.25,6.20,4.29,3.99,3.57,3.13,2.79,2.58,2.48,2.52,2.75,3.21,3.76,4.66,5.66,6.73,7.72,8.57,9.15,9.48,9.50,9.38,9.14,8.88,8.66,8.50,8.34,8.22,8.08,8,7.88,7.84,7.75,7.62,7.51,7.37,7.23,7.08,6.97,6.87,6.82,6.75,6.75,6.75,6.75,6.75,6.75,6.71,6.62,6.48,6.27,6.08,5.85,5.62,5.45,5.27,5.16,5.11,5.03,5,5,5,5,5.02,5.11,5.16,5.25,5.34,5.33,5.12,4.62,3.60,-0.50,0.62,1.51,9.52,15.64,18.83,20.98,23,23,22,22,22,23,24,23,19.70,16.02,12.99,10.09,7.23,4.52,2.32,0.59,-0.67,-1.59,-2.35,-3.02,-3.74,-4.49,-5.27,-6.11,-6.86,-7.49,-7.92,-8.23,-8.17,-7.90,-7.29,-7.47,-7.63,-7.79,-8.13,-8.54,-9.30,-10,-11,-12,-13,-13,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.54,-8.79,-8.09,-7.38,-6.68,-6.02,-5.37,-4.73,-4.11,-3.59,-3.03,-2.48,-1.87,-1.22,-0.53,0.12,0.78,1.47,2.12,2.78,3.50,4.24,4.96,5.61,6.27,7,8,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,7,6,6,5,5,5,5,4,4,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.97,0.90,0.82,0.62,0.37,0.16,0.10,0.12,0.25,0.47,0.63,0.77,0.87,0.97,1.03,1.25,1.50,1.73,1.85,1.90,1.96,1.99,2.01,2.04,2.09,2.12,2.20,2.23,2.82,3.10,3.25,3.24,4.01,4.27,5.26,6.02,6.74,7.48,7.35,7.59,7.95,9.90,11.82,13.72,15.66,17.62,19.59,21.23,22.64,23.29,23,21.97,20.61,19.13,17.83,16.89,16.62,17.07,18.10,19.09,19.49,19.15,19.08,17.26,15.51,11.87,7.21,5.25,4.90,4.25,3.59,3.02,2.61,2.36,2.32,2.51,2.95,3.64,4.58,5.62,6.74,7.88,8.75,9.38,9.71,9.75,9.59,9.34,9.01,8.75,8.53,8.36,8.16,8.02,7.89,7.78,7.73,7.62,7.57,7.47,7.37,7.25,7.14,7.10,7.02,7.01,7,7.02,7.07,7.08,7.09,7.07,7,6.87,6.66,6.41,6.14,5.87,5.62,5.41,5.26,5.16,5.11,5.07,5.01,5,5,5.02,5.10,5.20,5.34,5.48,5.59,5.59,5.34,4.74,3.66,-0.88,-0.15,1.78,8.25,14.37,19.50,21.71,23.95,24,24,23,23,24,25,23,19.98,16.16,12.87,9.70,6.63,4.03,1.89,0.25,-0.89,-1.74,-2.41,-3,-3.62,-4.25,-5,-5.80,-6.61,-7.27,-7.80,-8.15,-8.18,-8,-7.60,-7.18,-7.48,-7.66,-7.88,-8.13,-8.89,-9.90,-10,-11,-12,-13,-13,-14,-14,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-9.48,-8.54,-7.64,-6.84,-6.02,-5.36,-4.67,-4.13,-3.60,-3.11,-2.55,-1.99,-1.34,-0.63,0.08,0.75,1.47,2.13,2.85,3.57,4.34,5.12,5.95,6.63,7,8,9,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,8,7,6,6,6,5,5,5,4,4,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.97,0.91,0.83,0.62,0.37,0.14,0.09,0.13,0.34,0.53,0.75,0.87,0.91,0.99,1.09,1.11,1.87,1.87,1.97,1.99,2,2.07,2.12,2.22,2.29,2.42,2.63,3.02,3.48,3.88,3.97,4.59,5.16,5.57,6.38,7.21,7.82,8.15,8.37,8.62,8.97,11.17,14.08,16.42,18.49,20.37,21.52,22.79,23.91,24.27,23.83,22.65,21.11,19.45,17.96,16.87,16.36,16.42,16.89,17.50,17.90,18.12,18.01,18.17,18.41,14.66,10.32,7.41,5.78,4.76,3.91,3.22,2.70,2.37,2.32,2.49,2.92,3.62,4.58,5.64,6.84,8.15,9.04,9.66,10.02,10.10,9.87,9.53,9.22,8.89,8.63,8.39,8.22,8.02,7.88,7.76,7.70,7.61,7.58,7.50,7.46,7.38,7.36,7.34,7.33,7.35,7.37,7.39,7.41,7.46,7.45,7.38,7.27,7.12,6.87,6.57,6.23,5.89,5.62,5.40,5.25,5.15,5.11,5.07,5.02,5.02,5.03,5.10,5.16,5.33,5.50,5.73,5.87,5.88,5.62,4.87,3.77,-1.30,-0.64,1.12,1.99,12.12,17.25,20.45,22.65,22.96,24,24,24,24,25,23,19,15.75,12.08,8.65,5.73,3.48,1.61,0.12,-0.98,-1.78,-2.43,-2.93,-3.49,-4.04,-4.72,-5.41,-6.15,-6.85,-7.40,-7.80,-8.02,-8.13,-8.03,-7.99,-7.63,-7.75,-7.98,-8.14,-8.30,-9.29,-10,-11,-12,-12,-13,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-11,-11,-10,-9.25,-8.24,-7.22,-6.29,-5.48,-4.74,-4.15,-3.64,-3.13,-2.63,-2.11,-1.49,-0.77,-0.05,0.70,1.40,2.12,2.85,3.57,4.33,5.13,6.03,7,7.98,8,9,10,11,12,12,11,11,11,11,11,11,11,11,11,11,10,10,9,8,7,7,6,6,5,5,5,4,4,3,3,3,2,2,2,2,2,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.91,0.83,0.62,0.36,0.14,0.11,0.21,0.40,0.63,0.84,0.91,0.97,1,1,2,2,2,1.98,2.02,2.11,2.22,2.36,2.52,2.75,3,3.40,3.91,4.51,5.15,5.76,6.28,7,7.50,8.03,8.57,8.97,9.23,9.50,9.78,10.96,13.84,16.50,19.50,21.41,22.35,22.97,24.09,25.27,26.22,25.20,23.71,21.78,19.78,18.04,16.76,16.01,15.73,15.92,16.33,16.71,17.04,17.32,17.65,18.37,16.58,11.46,8.40,6.38,5.07,4.11,3.25,2.72,2.39,2.32,2.50,2.99,3.71,4.65,5.79,7,8.49,9.45,10.12,10.41,10.41,10.16,9.76,9.37,9.01,8.73,8.47,8.24,8.03,7.88,7.77,7.72,7.65,7.63,7.62,7.62,7.61,7.62,7.63,7.70,7.74,7.77,7.83,7.86,7.85,7.78,7.72,7.53,7.32,7,6.62,6.25,5.88,5.60,5.37,5.24,5.13,5.11,5.09,5.08,5.09,5.12,5.15,5.27,5.48,5.72,5.99,6.20,6.22,5.97,5.12,3.95,-1.63,-1.09,-0.28,1.82,2.08,14.03,17.23,19.70,21.72,22,23,24,24,25,23,19,14.71,10.50,7,4.62,3.02,1.50,0.21,-0.89,-1.75,-2.38,-2.87,-3.34,-3.80,-4.38,-5.02,-5.75,-6.41,-7.03,-7.54,-7.92,-8.22,-8.39,-8.38,-7.90,-7.75,-8.04,-8.25,-8.25,-8.62,-9.75,-10,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-12,-12,-11,-11,-10,-9.88,-8.88,-7.78,-6.74,-5.78,-4.97,-4.25,-3.68,-3.18,-2.68,-2.15,-1.60,-0.93,-0.24,0.50,1.25,2,2.75,3.49,4.25,5.09,6,7,8,9,10,10,12,13,13,13,13,13,13,12,12,12,12,12,12,12,11,10,10,9,8,7,7,6,6,5,5,5,4,4,3,3,3,2,2,2,2,2,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.95,0.83,0.61,0.36,0.14,0.12,0.25,0.50,0.75,0.88,0.97,0.99,1,2,2,2,2,2.02,2.12,2.27,2.50,2.78,3.12,3.51,3.98,4.57,5.24,6.09,7.03,7.87,8.62,9.13,9.53,9.87,10.12,10.38,10.60,10.76,11.83,13.88,16.51,18.85,21.54,22.48,22.87,23.71,24.88,26.37,28.23,26.99,25.16,22.67,20.22,18.11,16.66,15.66,15.25,15.25,15.39,15.99,16.21,16.54,16.77,17.35,14.21,11.27,8.47,6.40,4.99,3.92,3.16,2.63,2.37,2.35,2.58,3.11,3.87,4.87,6.04,7.34,8.92,9.88,10.58,10.84,10.75,10.40,9.96,9.49,9.10,8.75,8.48,8.24,8.03,7.89,7.83,7.75,7.75,7.75,7.77,7.84,7.87,7.95,8,8.10,8.15,8.23,8.25,8.25,8.22,8.12,7.97,7.74,7.41,7.07,6.63,6.24,5.86,5.53,5.34,5.21,5.12,5.11,5.11,5.12,5.13,5.21,5.28,5.45,5.64,5.95,6.24,6.46,6.49,6.22,5.34,4.12,-1.90,-1.51,-0.73,0.22,2.25,7.99,13.51,17.27,19.48,21.14,23,24,24,24,21,17,12.12,8.45,5.71,4,2.95,1.63,0.37,-0.75,-1.62,-2.26,-2.75,-3.15,-3.55,-4.04,-4.63,-5.28,-6,-6.64,-7.26,-7.79,-8.25,-8.62,-8.75,-8.55,-8.15,-8.30,-8.50,-8.62,-8.74,-9.15,-10,-11,-12,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-15,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-10,-9.38,-8.37,-7.25,-6.22,-5.26,-4.49,-3.79,-3.25,-2.75,-2.25,-1.64,-1.01,-0.36,0.36,1.08,1.78,2.52,3.26,4.02,4.84,5.71,6.89,8,9,10,11,12,13,15,15,15,15,15,14,14,14,13,13,13,13,13,12,11,10,10,9,8,7,7,6,6,5,5,5,4,4,4,3,3,2,2,2,2,2,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.95,0.84,0.62,0.35,0.14,0.13,0.32,0.59,0.78,0.91,0.98,1,1,2,2,2,2,2.11,2.28,2.60,3,3.50,4.10,4.75,5.48,6.28,7.16,8.16,9.23,10.37,11.12,11.59,11.67,11.84,12.03,11.90,12.71,12.77,15.36,17.46,19.92,20.74,21.66,22.39,23,23.82,25.07,26.76,29.36,30.13,26.98,23.41,20.60,18.32,16.57,15.38,14.65,15,15.37,16,16.16,16.02,15.86,15.08,12.82,10.26,7.84,5.98,4.62,3.64,2.96,2.51,2.32,2.35,2.70,3.27,4.12,5.22,6.46,8.27,9.46,10.42,11.03,11.25,11.02,10.59,10,9.50,9.10,8.74,8.41,8.20,8,7.88,7.84,7.83,7.86,7.89,7.99,8.08,8.15,8.26,8.37,8.50,8.60,8.63,8.64,8.62,8.50,8.35,8.12,7.83,7.47,7.03,6.61,6.15,5.77,5.49,5.26,5.15,5.12,5.12,5.14,5.22,5.25,5.36,5.48,5.63,5.87,6.15,6.47,6.65,6.70,6.38,5.51,4.27,-2.23,-1.87,-1.22,-0.17,1.60,2.65,10.60,15.25,18.32,20.32,23,25,24,22,20,15,10,7.25,5.50,4.24,3.20,1.96,0.64,-0.48,-1.41,-2.13,-2.61,-3,-3.36,-3.78,-4.29,-4.89,-5.53,-6.22,-6.87,-7.49,-8.05,-8.53,-9,-9.30,-8.88,-8.36,-8.49,-8.64,-8.63,-9.11,-10,-11,-12,-13,-13,-14,-14,-14,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.62,-8.72,-7.68,-6.63,-5.63,-4.75,-4,-3.35,-2.78,-2.28,-1.75,-1.12,-0.43,0.24,0.90,1.60,2.28,3,3.74,4.50,5.36,6.21,7,9,10,11,12,13,15,16,17,17,17,17,17,16,15,15,14,14,14,14,13,12,11,11,10,9,8,7,7,6,6,5,5,5,4,4,4,3,3,2,2,2,2,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.96,0.85,0.62,0.35,0.13,0.12,0.34,0.62,0.86,0.96,0.99,1,2,2,2,2,2.02,2.23,2.53,3.02,3.66,4.46,5.36,6.37,7.39,8.47,9.42,10.40,11.48,12.62,14.54,14.01,13.79,13.89,14.50,15.13,15.86,17.13,18.66,21.13,21.99,21.90,22.08,22.34,22.76,23.39,24.72,26.37,28.51,30.36,27.21,23.66,20.79,18.37,16.39,14.99,14.57,15,16.12,16.92,17.08,16.40,15.21,13.53,11.47,9.12,6.89,5.26,4.09,3.27,2.72,2.37,2.25,2.39,2.83,3.48,4.42,5.62,7.54,8.86,10.07,10.99,11.53,11.62,11.25,10.59,10,9.46,9,8.62,8.34,8.11,7.95,7.86,7.84,7.87,7.95,8.02,8.15,8.32,8.46,8.61,8.75,8.87,8.97,9,8.99,8.87,8.72,8.48,8.15,7.82,7.39,6.97,6.50,6.09,5.71,5.40,5.24,5.13,5.12,5.16,5.25,5.35,5.45,5.57,5.72,5.89,6.14,6.45,6.71,6.87,6.86,6.52,5.72,4.47,-2.50,-2.17,-1.63,-0.66,0.57,3.07,8.52,14,17.73,20.95,24,26,25,23,18,14,9,7,5.76,4.76,3.65,2.40,1.12,-0.13,-1.13,-1.88,-2.38,-2.77,-3.13,-3.52,-3.99,-4.50,-5.11,-5.75,-6.41,-7.10,-7.75,-8.37,-8.84,-9.05,-9,-8.43,-8.24,-8.27,-8.15,-8.72,-9.76,-10,-11,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.77,-8.89,-7.98,-6.98,-5.97,-5,-4.16,-3.47,-2.84,-2.26,-1.75,-1.15,-0.52,0.13,0.82,1.46,2.10,2.76,3.47,4.15,4.88,5.75,6.98,8,9,11,12,13,14,16,18,19,20,21,21,20,18,17,16,16,17,16,15,14,13,12,11,11,10,9,8,7,7,6,6,6,5,5,5,4,4,3,3,2,2,2,2,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.97,0.86,0.62,0.34,0.12,0.12,0.37,0.64,0.90,0.99,1,1,2,2,2,2,2.08,2.39,2.89,3.58,4.42,5.48,6.71,8.12,9.54,10.75,11.73,12.57,13.45,14.48,15.01,15.36,15.67,16.34,17.39,18.53,19.52,20.47,22.21,22.38,22.67,22.47,22.22,22.12,22.26,22.85,23.90,25.41,26.83,27.61,25.86,23.38,20.74,18.25,16.11,14.45,13.47,15.17,17.03,18.87,18.97,17.08,14.95,12.61,10.29,7.98,6,4.57,3.57,2.89,2.48,2.25,2.24,2.47,2.96,3.74,4.77,6.09,8.09,9.42,10.64,11.57,11.98,11.88,11.34,10.53,9.88,9.33,8.84,8.47,8.16,7.97,7.85,7.77,7.78,7.87,8,8.13,8.33,8.50,8.71,8.87,9.03,9.16,9.25,9.25,9.21,9.02,8.78,8.49,8.12,7.72,7.26,6.83,6.37,5.96,5.61,5.35,5.20,5.12,5.15,5.25,5.39,5.53,5.70,5.86,6.01,6.25,6.50,6.75,6.98,7.11,7.03,6.70,5.88,4.62,-2.66,-2.43,-2,-1.27,0,2.65,7.22,12.64,17.65,21.33,24.98,26,26,24,19,13,9,7,6,5.25,4.47,3.09,1.65,0.37,-0.66,-1.49,-2.05,-2.50,-2.89,-3.27,-3.66,-4.13,-4.74,-5.30,-5.92,-6.55,-7.17,-7.75,-8.17,-8.43,-8.48,-8.30,-8,-7.60,-7.37,-7.93,-9,-9.99,-10,-11,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-9.91,-9.13,-8.18,-7.23,-6.23,-5.25,-4.37,-3.59,-2.88,-2.25,-1.68,-1.13,-0.54,0.07,0.70,1.32,1.95,2.60,3.28,4,4.71,5.36,6.03,7,8,10,11,12,13,15,17,19,21,22,23,23,22,20,19,17,18,18,17,16,15,14,13,12,11,10,9,9,8,7,7,6,6,6,5,5,5,4,3,3,3,2,2,2,2,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.91,0.63,0.33,0.03,0.13,0.34,0.85,1,1,1,1,2,2,2.02,2.12,2.29,2.71,3.29,4.12,5.14,6.39,7.85,9.52,11.61,13.14,13.77,14.25,14.82,15.34,15.75,16.28,17.09,18.28,20.09,22.65,23.22,22.92,23.22,24.21,23.11,22.58,22.07,21.77,21.77,22.07,23.02,24.37,25.41,25.73,24.88,22.99,20.52,18.01,15.66,13.71,12.26,14.91,18.89,19.96,20.01,18.03,14.51,11.74,9.26,6.90,5.16,3.96,3.13,2.62,2.34,2.24,2.33,2.62,3.16,4.02,5.14,7.16,8.52,9.90,11.12,11.97,12.25,11.99,11.22,10.41,9.75,9.13,8.63,8.26,8,7.78,7.72,7.66,7.75,7.86,8,8.20,8.39,8.62,8.87,9.11,9.33,9.47,9.53,9.52,9.40,9.20,8.86,8.46,8,7.52,7.09,6.62,6.21,5.82,5.49,5.25,5.13,5.13,5.25,5.39,5.61,5.83,6,6.22,6.40,6.63,6.88,7.12,7.34,7.38,7.28,6.87,6.07,4.75,-2.66,-2.55,-2.26,-1.68,-0.50,1.53,3.36,11.99,17.40,21.45,24.74,27,28,26,22,15,11,9,8,7,5.62,4,2.40,1.02,-0.09,-0.99,-1.63,-2.22,-2.65,-3.03,-3.42,-3.87,-4.35,-4.87,-5.41,-6,-6.62,-7.16,-7.63,-7.98,-8.13,-8.10,-7.88,-7.41,-6.98,-7.41,-8.23,-8.99,-10,-10,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.40,-8.50,-7.50,-6.50,-5.50,-4.59,-3.73,-2.92,-2.25,-1.64,-1.11,-0.53,0.01,0.62,1.23,1.85,2.50,3.20,3.88,4.62,5.28,6.02,7,8,9,10,12,13,14,16,18,21,23,24,25,25,25,23,22,21,20,20,19,18,16,15,14,13,12,11,10,9,9,8,7,7,6,6,6,5,5,4,4,3,3,2,2,2,2,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,0,0,0,1,1,1,1,1,1,1.98,2,2.07,2.21,2.47,2.98,3.66,4.60,5.75,7.12,8.67,10.42,12.25,13.88,14.59,14.86,15.25,15.66,16.11,16.83,17.88,19.46,21.78,25.26,24.79,24.25,23.87,23.47,23.20,22.25,21.62,21.25,21.17,21.54,22.35,23.46,24.36,24.95,24.87,22.71,20.34,17.65,15.11,12.86,11.20,14.09,17.97,20.01,19.10,16.87,13.58,10.70,8.15,6,4.50,3.49,2.84,2.49,2.33,2.34,2.51,2.88,3.50,4.39,5.52,7.20,8.87,10.21,11.35,12.08,12.24,11.87,11.09,10.26,9.59,8.99,8.47,8.12,7.83,7.62,7.58,7.58,7.63,7.77,7.97,8.16,8.41,8.66,8.97,9.25,9.48,9.62,9.66,9.60,9.45,9.16,8.78,8.36,7.86,7.34,6.85,6.38,6,5.62,5.36,5.15,5.12,5.15,5.34,5.59,5.86,6.12,6.38,6.62,6.87,7.12,7.37,7.61,7.75,7.77,7.62,7.14,6.23,4.90,-2.47,-2.41,-2.26,-1.88,-0.93,0.52,3.53,10.82,16.62,21.11,25.09,28.86,30,28,24,16,13,12,10,9,7.25,5.14,3.33,1.78,0.61,-0.38,-1.23,-1.88,-2.40,-2.76,-3.13,-3.50,-3.90,-4.38,-4.88,-5.42,-6.01,-6.61,-7.12,-7.52,-7.79,-7.92,-7.88,-7.73,-7.53,-7.01,-7.53,-8.25,-8.89,-9.78,-10,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-11,-11,-10,-9.78,-8.90,-7.90,-6.88,-5.86,-4.88,-3.93,-3.11,-2.30,-1.63,-1,-0.50,0.01,0.58,1.13,1.75,2.45,3.13,3.87,4.59,5.32,6,7,8,9,10,11,13,14,16,18,20,23,25,26,28,28,28,27,27,26,24,23,22,20,18,17,15,14,13,12,11,10,9,9,8,7,7,6,6,5,5,4,4,3,3,3,2,2,2,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,0,0,1,1,1,1,1,1,1.98,1.84,2,2.11,2.27,2.59,3.16,3.95,4.97,6.21,7.63,9.22,10.85,12.38,13.61,14.37,14.83,15.20,15.60,16.11,16.88,18.02,19.63,21.91,24.17,25.50,24.85,23.83,23,22.26,21.57,20.89,20.51,20.50,20.75,21.73,22.76,23.58,24.04,23.99,22.98,20,17.01,14.29,11.89,10.03,11.96,16.08,19.13,18.21,14.85,12.03,9.38,7.09,5.21,3.97,3.13,2.67,2.49,2.49,2.63,2.92,3.37,4.01,4.87,6.01,7.20,9.10,10.29,11.27,11.88,11.99,11.53,10.70,10.13,9.46,8.87,8.37,8.01,7.73,7.50,7.48,7.46,7.52,7.70,7.87,8.10,8.35,8.67,9,9.25,9.46,9.61,9.62,9.53,9.35,9,8.61,8.12,7.62,7.12,6.61,6.12,5.74,5.41,5.20,5.08,5.07,5.20,5.41,5.75,6.12,6.47,6.76,7.03,7.33,7.59,7.86,8.10,8.24,8.24,8.01,7.50,6.50,5.11,-2.03,-2.09,-2.05,-1.80,-1.18,0.16,3.36,8.64,15.10,20.62,24.73,28.72,30,29,24,18,16,15,14,12,8.83,6.48,4.10,2.53,1.25,0.16,-0.76,-1.53,-2.13,-2.40,-2.75,-3.10,-3.43,-3.85,-4.28,-4.80,-5.38,-5.98,-6.51,-7.01,-7.41,-7.72,-7.89,-7.99,-7.90,-7.73,-7.02,-7.72,-8.13,-8.55,-9.86,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-9.38,-8.41,-7.37,-6.27,-5.26,-4.27,-3.37,-2.50,-1.74,-1.02,-0.42,0.10,0.58,1.07,1.62,2.26,3.09,3.87,4.63,5.24,6,7,8,9,10,11,12,14,16,18,20,22,26,27,28,29,30,31,31,32,31,28,26,25,24,20,18,17,15,14,13,12,11,10,9,9,8,7,7,6,5,5,4,4,3,3,3,2,2,2,1,1.14,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.63,1.89,2.01,2.13,2.35,2.67,3.33,4.14,5.25,6.58,8.08,9.63,11.14,12.49,13.51,14.23,14.66,14.97,15.28,15.79,16.54,17.61,19.02,20.73,22.40,23.71,24.48,23.37,22.40,21.42,20.59,19.91,19.54,19.64,20.36,21.39,22.37,22.90,23.22,23.14,22.13,18.87,16.03,13.28,10.71,8.84,10.75,14.25,16.29,15.17,12.66,10,7.86,5.96,4.45,3.50,2.90,2.63,2.62,2.82,3.17,3.62,4.16,4.77,5.53,6.53,7.54,9.12,10.26,11.11,11.62,11.67,11.08,10.71,10.12,9.50,8.91,8.39,8.08,7.75,7.50,7.41,7.37,7.41,7.57,7.73,7.90,8.21,8.53,8.84,9.10,9.32,9.41,9.42,9.33,9.10,8.75,8.32,7.84,7.32,6.79,6.03,5.73,5.46,5.20,5,4.95,5,5.20,5.50,5.88,6.33,6.73,7.09,7.38,7.70,7.99,8.27,8.53,8.71,8.66,8.40,7.87,6.84,5.28,-1.63,-1.73,-1.80,-1.74,-1.28,-0.25,1.87,3.37,12.01,17.57,23.59,27.61,30,29,25,20,19,18,16,13,9.99,6.32,4.60,3.12,1.85,0.74,-0.27,-1.13,-1.61,-1.99,-2.29,-2.61,-2.88,-3.22,-3.63,-4.13,-4.73,-5.35,-5.97,-6.53,-7.09,-7.51,-7.88,-8.16,-8.38,-8.39,-8,-8.12,-8.68,-8.75,-9.35,-9.68,-10,-10,-11,-11,-11,-10,-10,-10,-9.99,-9.88,-9.75,-9.55,-9.28,-9.28,-10,-10,-10,-10,-9.89,-8.93,-7.92,-6.86,-5.75,-4.73,-3.75,-2.84,-1.98,-1.18,-0.51,0.07,0.52,0.98,1.45,2,2.76,3.65,4.52,5.25,6,7,8,9,10,11,12,13,15,18,20,23,26,29,30,30,31,32,33,34,35,34,33,32,30,27,24,22,19,17,15,14,12,11,11,10,9,9,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.37,1.15,1.02,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.20,1.59,1.87,2.02,2.15,2.38,2.76,3.40,4.33,5.50,6.95,8.51,10.12,11.59,12.83,13.75,14.34,14.64,14.78,14.96,15.32,15.95,16.79,17.90,19.25,20.66,22.09,22.95,22.75,21.63,20.57,19.57,18.78,18.47,18.49,19.47,21.58,22.62,22.32,21.95,21.35,19.58,17.35,14.74,12.11,9.57,6.72,8.71,11.33,11.36,10.62,9.25,7.66,6.21,4.82,3.75,3.13,2.78,2.74,2.95,3.37,3.88,4.51,5.14,5.77,6.46,7.23,8.03,8.90,9.73,10.97,11.35,11.42,11.03,10.66,10.25,9.75,9.20,8.65,8.32,7.90,7.61,7.47,7.34,7.35,7.39,7.51,7.64,7.99,8.28,8.58,8.79,9,9.10,9.11,8.99,8.74,8.38,7.95,7.46,6.50,6.22,5.62,5.39,5.11,4.91,4.78,4.78,4.89,5.14,5.50,5.96,6.40,6.86,7.25,7.61,7.90,8.25,8.59,8.87,9.07,9.02,8.75,8.20,7.10,5.46,-1.38,-1.52,-1.67,-1.74,-1.47,-0.78,0.33,2.63,2.97,14.59,22.15,26.50,30,29,25,22,20,18,15,11,7,6.02,4.85,3.62,2.41,1.35,0.32,-0.61,-1.01,-1.40,-1.73,-1.98,-2.13,-2.42,-2.87,-3.38,-4,-4.66,-5.38,-6.03,-6.68,-7.28,-7.86,-8.36,-8.84,-9.29,-9.84,-10,-10,-10,-10,-10,-9.97,-10,-10,-10,-10,-10,-10,-9.75,-9.38,-9.13,-8.98,-8.74,-8.66,-9.37,-10,-10,-10,-10,-9.50,-8.50,-7.42,-6.35,-5.25,-4.18,-3.24,-2.35,-1.50,-0.75,-0.11,0.46,0.88,1.32,1.75,2.37,3.12,4.12,5.11,6,7,8,9,10,11,12,13,15,17,19,23,25,29,30,32,33,34,35,36,37,37,37,37,37,34,31,28,25,23,20,17,15,13,12,11,11,10,9,8,7,6,6,5,5,4,4,4,3,3,3,2,2,1.64,1.37,1.15,1.12,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.28,1.61,1.86,2.02,2.16,2.41,2.83,3.48,4.48,5.82,7.38,9.09,10.75,12.25,13.47,14.33,14.79,14.95,14.87,14.78,14.86,15.20,15.75,16.59,17.62,18.84,19.99,21.11,21.37,20.62,19.46,18.57,17.72,17.42,17.25,19.22,21.83,22.79,21.73,20.60,19.49,17.63,15.62,13.34,10.84,8.39,6.62,6.62,7.39,7.57,6.98,5.42,5.50,4.70,3.82,3.22,2.88,2.79,2.97,3.40,4.03,4.77,6.12,6.88,7.52,7.46,8.02,8.65,9.29,9.97,10.50,11.03,11.48,11.12,10.96,10.62,10.20,9.66,9.14,8.73,8.25,7.86,7.60,7.37,7.25,7.25,7.28,7.38,7.67,7.91,8.16,8.39,8.59,8.67,8.65,8.54,8.32,7.97,7.52,7.04,6.53,5.51,5.20,4.92,4.75,4.64,4.59,4.62,4.77,5.07,5.45,5.88,6.37,6.84,7.25,7.62,7.98,8.34,8.70,9,9.23,9.24,8.97,8.38,7.23,5.52,-1.53,-1.64,-1.78,-1.88,-1.74,-1.29,-0.41,0.95,3.21,11.15,20.08,25.45,28.99,29,27,22,17,14,11,8,7,6,5.08,4.10,3.07,2.02,1,0.11,-0.29,-0.67,-0.93,-1.03,-1.15,-1.47,-1.92,-2.53,-3.25,-4,-4.75,-5.50,-6.23,-6.91,-7.63,-8.35,-9.13,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-10,-10,-10,-9.63,-8.77,-8.18,-8.36,-8.88,-9.63,-10,-10,-10,-9.86,-9.02,-8.01,-6.93,-5.86,-4.76,-3.74,-2.75,-1.87,-1.10,-0.37,0.25,0.76,1.22,1.62,2.10,2.70,3.47,4.16,5.99,7,8,9,10,11,12,13,14,16,18,21,24,28,31,32,34,35,37,38,40,40,41,40,40,41,38,35,32,29,27,24,20,17,15,14,12,11,10,9,8,7,7,6,6,5,5,4,4,4,3,3,3,2,1.87,1.61,1.38,1.24,1.12,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.29,1.62,1.86,2.02,2.17,2.45,2.88,3.59,4.66,6.16,7.97,9.82,11.61,13.16,14.39,15.24,15.65,15.66,15.45,15.08,14.72,14.57,14.67,15,15.89,16.91,17.89,18.62,18.89,18.66,18.14,17.57,17.22,17.12,17.86,19.25,21.89,22.87,21.12,19.20,17.32,15.89,14.04,11.90,9.49,7.45,5.52,4.50,4.49,4.45,4.77,4.41,4.03,3.54,3.11,2.84,2.75,2.89,3.27,3.91,4.75,6.13,7.14,8.02,8.64,9.02,9.42,9.74,9.83,10.34,10.82,11.20,11.60,11.62,11.50,11.22,10.84,10.36,9.82,9.25,8.73,8.20,7.78,7.45,7.23,7.09,7.03,6.97,6.96,7.49,7.67,7.87,8.02,8.12,8.12,8,7.76,7.47,7.03,6.60,5.46,5.08,4.76,4.57,4.40,4.38,4.37,4.45,4.62,4.90,5.28,5.74,6.21,6.63,7.07,7.46,7.83,8.21,8.60,8.95,9.15,9.22,9,8.48,7.27,5.62,-1.89,-1.98,-2.09,-2.13,-2.02,-1.72,-1.02,0.35,3.09,7.47,16.75,23.37,26.98,27,24,19,15,11,9,8,7,6,5.28,4.62,3.75,2.84,1.87,1,0.73,0.39,0.23,0.24,0.21,-0.22,-0.86,-1.63,-2.48,-3.30,-4.13,-4.91,-5.67,-6.43,-7.25,-8.11,-9.11,-10,-11,-12,-12,-11,-12,-12,-11,-10,-10,-11,-11,-11,-10,-10,-9.65,-8.74,-8.13,-8.09,-8.75,-9.65,-10,-10,-10,-9.43,-8.54,-7.52,-6.47,-5.38,-4.30,-3.29,-2.36,-1.48,-0.66,0.01,0.62,1.10,1.50,1.91,2.38,2.98,3.76,4.97,6,9,9,10,11,12,13,14,16,17,20,22,26,29,33,35,36,38,40,41,42,44,44,43,44,44,42,38,35,32,30,26,22,19,17,15,13,12,11,10,9,8,7,6,6,5,5,5,4,4,3,3,3,2,2,1.85,1.60,1.38,1.25,1.12,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.29,1.62,1.86,2.02,2.20,2.50,3.02,3.85,4.99,6.70,8.67,10.66,12.59,14.25,15.57,16.42,16.86,16.85,16.47,15.87,15.14,14.48,13.86,13.71,14.22,15.13,15.85,16.41,16.75,16.82,16.70,16.54,16.52,16.88,17.91,19.83,21.62,22.98,21,19,16.03,14.12,12.74,10.66,8.36,6.39,5.04,4.09,3.37,3.33,3.61,3.47,3.20,2.87,2.70,2.62,2.72,3.08,3.62,4.41,5.72,6.89,8.08,9,9.62,9.78,10.12,10.49,10.85,10.95,11.64,11.97,12.15,12.22,12.13,11.98,11.60,11.12,10.52,9.87,9.23,8.59,8.02,7.53,7.20,6.90,6.78,6.78,6.50,6.88,7.13,7.28,7.39,7.49,7.50,7.38,7.17,6.89,6.51,6.11,5.52,4.65,4.38,4.21,4.12,4.14,4.15,4.25,4.47,4.75,5.10,5.50,5.91,6.36,6.75,7.14,7.52,7.91,8.33,8.66,8.91,9,8.86,8.40,7.39,5.64,-2.29,-2.36,-2.40,-2.41,-2.35,-2.05,-1.47,-0.34,1.26,2.98,2.48,19.09,24.88,24,22,18,15,12,9,8,7,6,5.85,5.16,4.58,3.71,2.91,2.23,2.25,2.20,2.24,2.32,2.09,1.37,0.39,-0.63,-1.66,-2.63,-3.51,-4.35,-5.13,-5.88,-6.73,-7.63,-8.74,-10,-11,-11,-11,-11,-12,-12,-12,-11,-10,-11,-11,-11,-10,-10,-9.99,-9.29,-8.29,-7.86,-8.63,-9.75,-10,-10,-9.85,-9.02,-8.11,-7.03,-5.97,-4.90,-3.88,-2.89,-1.99,-1.13,-0.37,0.32,0.87,1.37,1.85,2.32,2.85,3.50,4.14,5,7,8,9,10,12,13,14,16,17,19,21,24,27,31,35,37,39,41,43,44,46,47,48,47,47,49,46,42,39,35,31,27,23,20,18,16,14,12,11,10,9,8,7,6,6,5,5,5,4,4,3,3,3,3,2,2,1.75,1.58,1.37,1.23,1.10,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.33,1.63,1.87,2.04,2.25,2.66,3.35,4.29,5.63,7.41,9.50,11.52,13.62,15.41,16.83,17.82,18.27,18.32,17.84,17.11,16.11,14.90,13.52,12.92,13.12,13.42,13.97,14.42,14.79,15.04,15.22,15.40,15.84,16.66,18.09,19.99,22.25,21.77,19.98,17,14,12.02,10.90,9.84,7.22,5.85,4.25,3.25,3.21,3.11,3.03,2.88,2.73,2.58,2.48,2.50,2.74,3.22,3.91,4.92,6.10,7.38,8.53,9.46,10.07,10.22,10.59,10.95,11.29,11.67,12.09,12.42,12.66,12.84,12.90,12.84,12.45,11.96,11.33,10.50,9.73,8.98,8.25,7.64,7.15,6.76,6.52,6.24,6.07,5.96,5.92,6.10,6.75,6.77,6.78,6.70,6.53,6.28,5.97,5.62,4.51,4.25,4.03,3.91,3.87,3.96,3.99,4.10,4.27,4.53,4.87,5.24,5.62,6.01,6.40,6.78,7.16,7.58,7.96,8.28,8.57,8.70,8.62,8.26,7.38,5.70,-2.63,-2.64,-2.66,-2.66,-2.60,-2.36,-1.87,-1.15,-0.25,0.83,2.95,11.75,19.62,19.99,19,18,15,12,10,9,8,7,6,5.75,5.20,4.58,4.09,3.84,4.50,5,5.38,5.26,4.48,3.22,1.75,0.36,-0.90,-1.99,-2.90,-3.75,-4.50,-5.25,-6.02,-6.90,-7.98,-9.17,-10,-10,-11,-11,-11,-12,-11,-10,-10,-11,-11,-10,-10,-10,-10,-9.64,-8.89,-8.50,-9.64,-10,-10,-10,-9.59,-8.68,-7.64,-6.59,-5.50,-4.48,-3.50,-2.55,-1.65,-0.85,-0.11,0.57,1.12,1.63,2.15,2.73,3.37,4,5,6,7,8,9,11,12,14,15,17,19,21,23,26,29,33,36,39,41,44,46,48,49,51,52,50,51,53,51,48,42,38,33,29,24,21,19,16,14,13,11,10,9,8,7,7,6,5,5,5,4,4,3,3,3,3,2,2,1.87,1.73,1.52,1.35,1.15,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.37,1.70,1.91,2.13,2.48,3,3.97,5.23,6.75,8.41,10.28,12.32,14.37,16.27,17.90,19.16,19.87,19.90,19.57,18.58,17.33,15.86,14.21,13.20,12.51,12.23,12.37,12.73,13.03,13.37,13.74,14.21,15.03,16.25,17.96,20.10,21.96,22.25,19.62,15,11,10,9,8,7,5,4,3,3,3,2.78,2.54,2.38,2.25,2.22,2.33,2.63,3.20,4.01,5.09,6.22,7.45,8.50,9.34,9.90,10.25,10.71,11.14,11.61,12.07,12.48,12.89,13.13,13.46,13.62,13.62,13.16,12.70,12,11.03,10.15,9.27,8.46,7.73,7.12,6.62,6.26,5.87,5.63,5.46,5.35,5.32,5.88,6.10,6.08,6,5.87,5.65,5.39,4.92,4.10,3.88,3.73,3.65,3.63,3.75,3.84,3.96,4.12,4.37,4.64,5,5.35,5.72,6.09,6.46,6.83,7.20,7.57,7.89,8.16,8.35,8.37,8.12,7.47,5.66,-2.86,-2.87,-2.88,-2.87,-2.76,-2.59,-2.28,-1.77,-1.12,-0.11,1.90,2.62,1.85,13.78,16,17,16,14,12,10,9,8,7,6,5.75,5.37,5.24,5.75,7.25,8.66,9.37,9,7.37,5.11,3.03,1.26,-0.17,-1.37,-2.34,-3.13,-3.88,-4.54,-5.25,-6,-6.90,-7.88,-8.88,-9.63,-10,-10,-11,-11,-10,-9.66,-9.67,-10,-10,-10,-10,-10,-9.80,-10,-10,-10,-10,-11,-10,-10,-9.38,-8.37,-7.25,-6.14,-5.11,-4.11,-3.14,-2.25,-1.38,-0.62,0.12,0.75,1.35,1.89,2.50,3.10,3.83,4.98,5,6,7,8,10,11,13,14,16,18,20,22,25,28,31,35,38,41,45,48,50,52,53,53,53,52,52,55,56,52,47,40,35,30,26,22,19,17,15,13,12,10,9,8,7,7,6,6,5,5,4,4,4,3,3,3,2,2,1.95,1.86,1.71,1.50,1.25,1.11,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.46,1.78,2,2.29,2.84,3.79,5.27,6.77,8.12,9.39,10.84,12.60,14.62,16.72,18.71,20.36,21.37,21.62,21.40,20.22,18.83,17.17,15.50,13.89,12.50,11.58,11.25,11.29,11.50,11.79,12.25,12.97,14.03,15.53,17.36,19.45,21.71,21,18.36,13.20,10,9,8,7,6,5,4,4,3,3.04,2.61,2.34,2.15,2.04,2.04,2.22,2.57,3.13,4.24,5.12,6.10,7.09,8,8.72,9.37,9.88,10.48,11.08,11.64,12.20,12.70,13.20,13.50,13.87,14.12,14.12,13.66,13.14,12.45,11.39,10.46,9.49,8.53,7.75,7.02,6.46,6,5.53,5.21,4.99,4.82,4.72,4.63,4.60,5.22,4.47,4.36,4.21,4.03,3.86,3.67,3.57,3.49,3.45,3.50,3.62,3.72,3.85,4,4.24,4.50,4.78,5.12,5.46,5.78,6.13,6.50,6.87,7.22,7.53,7.84,8.03,8.12,7.98,7.45,5.72,-2.92,-2.93,-2.97,-2.97,-2.89,-2.77,-2.54,-2.22,-1.74,-0.99,-0.16,0.49,2.25,1.63,11.98,16,18,16,13,11,10,9,8,7,6,6.16,6.49,7.33,10.24,12.62,14.87,13.28,9.88,6.71,4.14,2.10,0.49,-0.75,-1.75,-2.54,-3.25,-3.87,-4.43,-5.04,-5.74,-6.48,-7.25,-7.99,-8.74,-9.42,-9.89,-10,-9.55,-8.78,-9.52,-10,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-11,-10,-9.22,-8.01,-6.85,-5.75,-4.75,-3.78,-2.89,-2.02,-1.18,-0.39,0.32,0.95,1.52,2.12,2.76,3.50,4,5,6,7,8,9,10,12,13,15,17,19,22,24,27,30,34,37,40,44,49,53,56,57,57,56,55,54,53,57,59,57,50,42,36,32,27,23,20,17,15,13,12,11,9,8,8,7,6,6,5,5,4,4,4,3,3,3,2,2,1.98,1.95,1.84,1.63,1.38,1.20,1.07,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1.66,1.87,2.10,2.50,3.37,4.90,6.83,8.67,9.66,10,10.87,12.37,14.45,16.84,19.21,21.33,22.67,23.20,22.96,22,20.45,18.71,16.83,14.89,13.03,11.52,10.64,10.25,10.21,10.37,10.82,11.61,12.82,14.41,16.32,18.12,19.21,18.95,17.14,12.40,8,7,7,6,5,5,5,4,2.92,3.12,2.46,2.15,2,1.91,1.97,2.12,2.47,3,4.01,4.91,5.75,6.53,7.25,7.95,8.61,9.25,10,10.73,11.41,12.10,12.70,13.25,13.59,13.98,14.22,14.25,13.76,13.25,12.50,11.47,10.49,9.50,8.51,7.64,6.89,6.25,5.73,5.24,4.84,4.53,4.33,4.16,4.08,4,3.95,3.87,4.42,3.67,3.57,3.46,3.37,3.28,3.25,3.29,3.39,3.53,3.63,3.76,3.96,4.14,4.38,4.65,4.97,5.26,5.60,5.91,6.25,6.61,6.96,7.26,7.59,7.85,7.99,7.87,7.40,5.87,-2.88,-2.89,-2.91,-2.93,-2.92,-2.88,-2.75,-2.51,-2.18,-1.75,-1.18,-0.66,0.13,2.07,1.25,15,19,17,14,12,11,10,9,8,7,7,7.38,9.83,12.77,16.34,16.53,14.24,11.20,7.74,5,2.87,1.16,-0.11,-1.11,-1.93,-2.63,-3.23,-3.73,-4.16,-4.63,-5.09,-5.62,-6.27,-7.03,-7.75,-8.38,-8.74,-8.88,-9.09,-9.64,-10,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-11,-10,-8.92,-7.63,-6.40,-5.34,-4.38,-3.53,-2.73,-1.89,-1.11,-0.34,0.37,1.02,1.63,2.27,3,3.82,5,5,6,7,8,9,11,12,14,16,18,20,23,26,29,32,35,38,41,46,52,58,61,63,62,60,57,56,55,57,61,59,53,44,38,33,28,24,20,17,15,14,12,11,10,9,8,7,7,6,5,5,5,4,4,3,3,3,2,2,1.99,1.98,1.89,1.73,1.50,1.25,1.11,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,2,1.83,1.97,2.15,2.61,3.75,5.70,8.29,10.87,10.28,9.91,10.34,11.70,14.02,16.91,19.77,22.23,23.79,24.58,23.96,22.95,21.75,20.14,18.22,16.17,14.11,12.08,10.57,9.66,9.25,9.15,9.45,10.23,11.40,12.90,14.62,15.96,16.67,16.64,15,10.58,7,6,6,5,4,4,4,2.92,2.87,3.16,2.36,2.02,1.87,1.83,1.86,2.01,2.32,2.76,3.37,4.57,5.25,5.88,6.50,7.12,7.83,8.62,9.46,10.27,11.09,11.82,12.45,13,13.35,13.71,13.89,13.90,13.46,12.95,12.22,11.22,10.26,9.28,8.34,7.47,6.70,6,5.45,4.91,4.49,4.15,3.88,3.72,3.58,3.50,3.42,3.36,3.32,3.24,3.16,3.12,3.09,3.09,3.13,3.22,3.34,3.50,3.62,3.75,3.91,4.12,4.36,4.62,4.87,5.16,5.49,5.78,6.12,6.46,6.77,7.12,7.48,7.75,7.98,7.88,7.37,5.52,-2.75,-2.77,-2.85,-2.88,-2.92,-2.92,-2.88,-2.75,-2.54,-2.24,-1.88,-1.39,-0.55,0.50,1.72,12.84,17,17,14,13,12,11,10,9,8,9,10,12.26,15.25,16.37,15.97,14.08,11.12,8.21,5.71,3.64,2.01,0.73,-0.37,-1.28,-2.01,-2.62,-3.05,-3.42,-3.74,-3.98,-4.23,-4.86,-5.52,-6.30,-7.11,-7.75,-8.29,-8.87,-9.48,-10,-10,-10,-11,-12,-13,-14,-14,-14,-14,-13,-11,-9.98,-8.50,-7.15,-5.97,-4.92,-4.05,-3.29,-2.55,-1.79,-1.01,-0.25,0.47,1.11,1.74,2.37,3.11,4,5,6,6,7,8,10,11,13,15,17,19,21,24,27,30,33,36,39,43,48,55,62,66,67,68,65,61,58,56,57,60,61,55,47,39,34,29,24,21,18,16,14,12,11,10,9,8,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.98,1.91,1.77,1.53,1.33,1.12,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,4,3,2,2,1,1,1,1,1,2,1.98,2,2.16,2.62,3.91,5.88,8.37,10.04,9.42,9.10,9.58,11.33,14.14,17.50,20.60,23.14,24.50,25.21,24.12,23.32,22.53,21.65,19.61,17.50,15.24,12.98,10.92,9.58,8.76,8.34,8.37,8.92,9.91,11.12,12.40,13.37,13.76,13.24,11.41,8.67,7,6,5,4,4,3,2.98,2.88,3.16,3.22,2.26,1.96,1.79,1.75,1.76,1.88,2.13,2.50,2.98,3.57,4.17,4.84,5.51,6.28,7.08,8,8.89,9.77,10.62,11.37,11.98,12.50,12.83,13.12,13.28,13.25,12.83,12.32,11.62,10.72,9.83,8.90,8,7.13,6.37,5.72,5.12,4.62,4.17,3.83,3.54,3.35,3.21,3.12,3.02,3,2.97,2.91,2.90,2.90,2.92,2.98,3.07,3.16,3.35,3.50,3.62,3.77,3.97,4.14,4.37,4.62,4.87,5.15,5.46,5.75,6.08,6.39,6.75,7.12,7.50,7.87,8.12,8.12,7.60,5.62,-2.54,-2.63,-2.72,-2.84,-2.90,-2.98,-2.99,-2.91,-2.76,-2.55,-2.26,-1.79,-1.04,0.33,2.12,11.37,16.98,16,15,14,13,12,11,11,10,12,15,16.98,17.75,17,15.47,13.20,10.71,8.35,6.37,4.66,3.15,1.77,0.52,-0.52,-1.37,-2,-2.49,-2.87,-3.13,-3.35,-3.61,-3.91,-4.49,-5.25,-6.22,-6.99,-7.66,-8.36,-9,-9.62,-10,-10,-11,-12,-14,-15,-15,-14,-13,-12,-10,-9.38,-7.91,-6.62,-5.49,-4.54,-3.78,-3.13,-2.48,-1.75,-1,-0.25,0.48,1.12,1.75,2.41,3.12,4,5,6,7,8,9,10,11,13,16,17,19,22,25,28,31,34,38,40,44,50,58,66,68,70,71,68,63,59,57,57,60,62,57,47,40,34,28,25,21,18,16,14,13,12,11,10,9,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.99,1.95,1.78,1.59,1.35,1.13,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,7,6,4,3,2,1,1,1,1,1,2,2,2.03,2.23,2.65,3.85,5.47,7.16,7.90,8.16,8.15,9.34,11.64,14.86,18.15,21.91,23.73,24.77,24.78,24.03,23.39,22.89,22.57,21.23,18.84,16.48,14.04,11.64,9.83,8.65,7.92,7.63,7.88,8.51,9.29,10.15,10.73,10.78,10.20,8.98,7.49,6,5,5,4,3,3,3.02,2.91,3.21,3.25,2.24,1.91,1.77,1.71,1.72,1.77,1.96,2.24,2.59,3.02,3.52,4.12,4.75,5.53,6.41,7.41,8.37,9.26,10.11,10.78,11.37,11.84,12.11,12.36,12.47,12.37,11.98,11.49,10.84,10,9.16,8.35,7.51,6.73,6,5.36,4.77,4.33,3.91,3.53,3.27,3.07,2.91,2.83,2.76,2.73,2.72,2.72,2.73,2.75,2.85,2.92,3.03,3.21,3.37,3.51,3.66,3.86,4.02,4.25,4.48,4.73,4.98,5.25,5.52,5.84,6.14,6.50,6.87,7.28,7.75,8.15,8.50,8.59,8.23,6.53,-2.27,-2.38,-2.54,-2.75,-2.90,-3.02,-3.09,-3.04,-2.97,-2.76,-2.48,-2,-1.17,0.40,2.62,9.38,15.73,17,17,17,16,14,13,13,14,18,22,22,20,17.83,14.82,12.37,10.12,8.27,7.25,6.10,4.73,3.15,1.60,0.33,-0.60,-1.26,-1.87,-2.36,-2.72,-2.90,-3.12,-3.39,-3.88,-4.68,-5.50,-6.26,-7.01,-7.75,-8.41,-9.02,-9.61,-10,-10,-12,-13,-15,-14,-14,-12,-11,-10,-8.59,-7.24,-6.01,-5,-4.18,-3.53,-2.99,-2.38,-1.74,-1,-0.25,0.48,1.13,1.77,2.41,3.13,4.01,5,6,7,8,9,10,11,13,16,18,19,22,25,28,32,35,37,41,45,50,59,66,70,72,72,68,63,59,57,57,61,62,56,46,39,33,28,25,21,18,16,14,13,12,11,10,9,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.99,1.91,1.78,1.60,1.36,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,8,9,8,5,3,2,1,1,1,1,2,2,2,2,2.25,2.70,3.65,4.87,5.97,6.66,7.10,8,9.85,12.36,15.38,19,21.77,24.36,25.26,24.24,23.62,23.16,22.90,22.83,22.03,20.17,17.84,15.23,12.62,10.37,8.86,7.87,7.29,7.13,7.36,7.72,8.20,8.46,8.36,7.86,7.01,6.07,5,4,4,3,3,3,3,2.90,3.24,3.27,2.25,1.96,1.77,1.67,1.65,1.71,1.79,1.99,2.25,2.57,2.99,3.50,4.15,4.95,5.90,6.95,7.88,8.78,9.58,10.20,10.65,11.03,11.26,11.46,11.50,11.39,11,10.53,9.91,9.23,8.41,7.65,6.90,6.21,5.52,4.96,4.41,3.99,3.64,3.32,3.08,2.87,2.75,2.64,2.62,2.60,2.60,2.62,2.66,2.75,2.84,2.96,3.10,3.28,3.41,3.60,3.75,3.97,4.16,4.38,4.63,4.88,5.15,5.45,5.74,6.02,6.37,6.75,7.15,7.63,8.14,8.64,9.10,9.28,9.13,7.84,-1.93,-2.13,-2.38,-2.68,-2.97,-3.13,-3.23,-3.22,-3.12,-2.90,-2.62,-2.11,-1.17,0.63,3.23,9.35,15.49,19.86,21,21,19,17,17,18,18,23,25,23,20,17,14.03,11.62,9.07,8.39,8.72,8.08,6.87,4.87,2.85,1.23,0.48,-0.26,-1.09,-1.75,-2.13,-2.47,-2.67,-3.02,-3.53,-4.15,-4.88,-5.60,-6.34,-7.03,-7.73,-8.34,-8.89,-9.50,-10,-11,-12,-12,-13,-12,-11,-10,-8.93,-7.65,-6.49,-5.42,-4.55,-3.88,-3.30,-2.84,-2.28,-1.67,-1,-0.25,0.48,1.14,1.82,2.46,3.15,4.01,5,6,7,8,9,10,11,13,15,17,19,22,24,27,30,34,37,41,45,51,57,64,68,70,68,64,60,58,57,58,61,58,52,44,37,32,28,25,21,18,16,15,13,12,11,10,9,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.99,1.91,1.82,1.61,1.37,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,7,10,12,9,5,4,2,2,1,1,1,2,2,2,2,2.01,2.83,3.50,4.35,5.36,6.11,7,8.41,10.32,12.58,15.34,18.36,21.12,23.74,24.62,23.51,22.91,22.61,22.57,22.62,22.70,21.71,19.33,16.52,13.75,11.15,9.26,8,7.13,6.64,6.50,6.51,6.67,6.72,6.51,6.07,5.52,4.97,4,4,3,3,3,3,3,2.89,3.25,3.29,2.28,1.99,1.78,1.66,1.62,1.62,1.67,1.82,1.99,2.24,2.59,3.07,3.67,4.50,5.51,6.52,7.49,8.34,9.02,9.53,9.90,10.21,10.37,10.48,10.50,10.37,10,9.53,8.98,8.33,7.62,6.89,6.25,5.61,5.01,4.50,4.07,3.65,3.37,3.13,2.95,2.75,2.63,2.58,2.54,2.54,2.59,2.63,2.70,2.78,2.89,3.10,3.23,3.36,3.50,3.70,3.88,4.12,4.37,4.62,4.88,5.16,5.48,5.75,6.08,6.39,6.75,7.15,7.62,8.15,8.75,9.34,9.87,10.20,10.21,9.13,-1.84,-2.01,-2.41,-2.85,-3.14,-3.35,-3.41,-3.40,-3.28,-3.05,-2.74,-2.16,-1.17,0.72,3.87,9.50,17.02,22.63,26,26,23,20,21,21,22,24,24,22,19,16,13,10.02,10.37,10.62,10.87,10.63,9.75,7.96,3.64,3.62,2.91,1.34,-0.17,-1,-1.37,-1.75,-2.12,-2.50,-3.04,-3.64,-4.27,-4.92,-5.60,-6.25,-6.88,-7.43,-8,-8.50,-9.12,-9.77,-10,-10,-11,-10,-9.84,-8.85,-7.76,-6.73,-5.74,-4.88,-4.13,-3.55,-3.10,-2.64,-2.15,-1.61,-0.93,-0.24,0.50,1.16,1.86,2.50,3.21,4,5,6,7,8,9,10,11,13,15,17,19,21,24,26,29,32,36,40,45,49,55,60,63,64,63,61,59,57,57,59,60,56,50,42,36,31,28,25,21,19,17,15,13,12,11,10,9,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.99,1.95,1.83,1.62,1.37,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,9,13,14,10,6,4,3,2,1,1,2,2,2,2,2,3,3,3.20,4.09,5.21,6.24,7.42,8.78,10.41,12.40,14.41,17.20,20.07,22.73,22.86,22.50,22.04,21.78,21.88,22.33,22.87,23.71,20.77,17.92,14.88,12.11,9.83,8.25,7.13,6.39,5.97,5.74,5.67,5.54,5.28,4.92,4.61,4.32,4,4,3,3,3,3,3,2.89,2.87,3.32,2.35,2.03,1.83,1.65,1.61,1.59,1.62,1.71,1.83,2,2.29,2.74,3.36,4.17,5.22,6.16,7.09,7.86,8.47,8.87,9.12,9.33,9.39,9.49,9.46,9.33,8.98,8.53,8,7.37,6.75,6.12,5.52,4.99,4.49,4.07,3.65,3.37,3.12,2.91,2.84,2.72,2.62,2.60,2.58,2.60,2.63,2.72,2.78,3.02,3.03,3.16,3.32,3.46,3.62,3.84,4.07,4.33,4.61,4.90,5.24,5.58,5.89,6.24,6.59,6.91,7.33,7.75,8.26,8.87,9.50,10.15,10.77,11.23,11.45,10.50,-2.25,-2.48,-2.80,-3.18,-3.50,-3.67,-3.75,-3.68,-3.53,-3.26,-2.88,-2.26,-1.29,0.45,3.12,8.62,17.40,26.24,31.99,31,25,22,22,23,24,24,23,21,19,17,14,12,12.03,13.10,13.62,13.61,13.12,11.84,10.59,9.34,7.03,2.82,1.57,0.01,0.03,-0.50,-1.09,-1.79,-2.50,-3.13,-3.74,-4.27,-4.85,-5.39,-5.91,-6.42,-6.89,-7.38,-7.88,-8.38,-8.84,-9.12,-9.13,-8.79,-8.23,-7.41,-6.59,-5.76,-5,-4.35,-3.75,-3.25,-2.86,-2.42,-1.99,-1.43,-0.85,-0.15,0.51,1.25,1.88,2.52,3.22,4,5,6,7,8,9,10,11,13,15,16,18,21,23,26,28,31,34,39,43,48,52,55,58,59,59,58,57,57,59,62,60,56,49,42,36,31,28,24,21,19,17,15,13,12,11,10,9,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.99,1.96,1.85,1.62,1.37,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,10,14,16,12,7,4,3,2,2,2,2,2,3,2,3,3,3,3,4,5,7,8,9,10,11,14,17,19.89,21.73,22.10,21.75,21.17,20.72,21,21.72,22.77,24.14,22.66,19.26,15.96,12.97,10.48,8.59,7.22,6.27,5.64,5.28,5.10,4.87,4.62,4.39,4.23,4.08,4,4,3,3,3,3,3,3,2.87,3.32,3.17,2.11,1.84,1.65,1.60,1.58,1.58,1.62,1.73,1.87,2.12,2.52,3.12,3.89,4.90,5.83,6.63,7.34,7.84,8.12,8.28,8.37,8.41,8.45,8.38,8.25,7.95,7.51,7,6.48,5.87,5.35,4.85,4.37,3.96,3.62,3.34,3.10,2.90,2.77,2.72,2.66,2.65,2.65,2.71,2.75,2.82,2.87,2.98,3.07,3.15,3.27,3.41,3.59,3.76,4,4.25,4.58,4.89,5.26,5.65,6.07,6.47,6.85,7.23,7.62,8.01,8.50,9.07,9.71,10.39,11.13,11.85,12.37,12.63,12.83,-3,-3.17,-3.47,-3.75,-4,-4.15,-4.17,-4.10,-3.88,-3.54,-3.12,-2.49,-1.62,-0.27,1.84,4.26,13.87,24.66,31.77,30,27,24,24,25,26,25,24,23,23,20,16,13,15,15.96,16.76,16.39,16.15,15.91,15.63,14.74,12.62,9,2.62,2.62,2.84,1.50,0.12,-0.97,-1.87,-2.60,-3.17,-3.66,-4.16,-4.63,-5.04,-5.48,-5.88,-6.30,-6.73,-7.05,-7.35,-7.47,-7.41,-7.16,-6.76,-6.16,-5.50,-4.88,-4.30,-3.85,-3.38,-2.97,-2.55,-2.16,-1.75,-1.25,-0.66,-0.05,0.60,1.26,1.91,2.52,3.21,4,5,6,7,8,9,10,11,13,14,16,18,20,22,25,27,30,33,37,42,46,49,52,54,55,56,56,57,58,60,61,59,54,47,41,35,31,27,24,21,19,17,15,13,12,11,10,9,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.99,1.97,1.83,1.61,1.37,1.15,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,9,15,17,13,7,4,3,2,2,2,2,3,3,3,3,3,3,3,4,5,6,7,8,10,12,16,18,20.12,21.74,21.97,21.45,20.61,19.67,19.75,20.99,22.29,23.42,24.20,20.38,16.83,13.61,10.91,8.82,7.25,6.21,5.46,5.07,4.79,4.52,4.29,4.14,4.07,4.01,4,4,3,3,3,3,3,3,2.87,3.29,3.34,2.10,1.76,2.27,1.59,2.21,2.21,1.61,1.65,1.78,2.02,2.38,2.91,3.66,4.61,5.40,6.14,6.75,7.12,7.33,7.38,7.40,7.40,7.37,7.34,7.20,6.91,6.51,6.09,5.60,5.09,4.62,4.20,3.82,3.49,3.22,3.02,2.87,2.75,2.70,2.63,2.63,2.65,2.71,2.75,2.83,2.88,2.98,3.08,3.16,3.28,3.41,3.58,3.75,3.97,4.22,4.50,4.86,5.25,5.70,6.13,6.62,7.09,7.51,7.97,8.37,8.84,9.35,9.95,10.62,11.40,12.25,13.07,13.70,14.07,13.13,-3.85,-3.98,-4.17,-4.43,-4.65,-4.76,-4.75,-4.59,-4.28,-3.89,-3.40,-2.78,-2.04,-1.13,0.32,2.58,3.51,20.25,28.37,30,28,27,28,29,29,29,28,28,26,22,17,14,15,17,17.98,17.97,18.37,18.65,19.07,18.95,18,15.59,11.77,9.37,8.12,3.12,1.85,-0.01,-1.23,-2,-2.63,-3.13,-3.55,-3.93,-4.30,-4.64,-5.01,-5.35,-5.64,-5.88,-6.03,-6.09,-6.01,-5.84,-5.59,-5.14,-4.64,-4.17,-3.75,-3.38,-3,-2.63,-2.26,-1.88,-1.48,-1,-0.49,0.09,0.70,1.35,1.98,2.53,3,4,5,6,7,8,9,10,11,12,14,15,17,19,21,24,26,28,31,35,39,43,47,50,52,53,53,54,56,57,57,56,55,50,45,39,34,31,27,24,21,19,17,15,13,12,11,9,8,8,7,6,6,5,5,4,4,3,3,3,2,2,2,1.99,1.95,1.83,1.61,1.37,1.15,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,8,14,17,14,8,5,4,3,3,3,3,3,3,3,3,3,3,3,4,5,6,7,9,11,15,19,20,21.87,22.76,22.62,21.47,20.42,19.64,19.61,19.75,21.91,23.64,24.87,21.16,17.38,14,11.15,8.89,7.22,6.09,5.32,4.96,4.67,4.38,4.16,4.04,4,4,4,4,3,3,3,3,3,3,2.87,3.28,3.34,1.96,1.74,1.62,1.60,2.20,2.20,2.17,1.65,1.76,1.96,2.27,2.78,3.45,4.25,5,5.61,6.08,6.36,6.47,6.47,6.41,6.38,6.37,6.27,6.13,5.91,5.60,5.22,4.77,4.36,3.95,3.62,3.35,3.11,2.90,2.76,2.72,2.64,2.62,2.62,2.64,2.72,2.76,2.85,2.90,3,3.11,3.22,3.34,3.46,3.60,3.75,3.95,4.15,4.45,4.75,5.14,5.62,6.12,6.63,7.16,7.72,8.23,8.71,9.14,9.62,10.16,10.84,11.62,12.50,13.49,14.46,15.25,15.63,15.50,-4.63,-4.75,-4.97,-5.18,-5.38,-5.47,-5.38,-5.14,-4.77,-4.30,-3.76,-3.16,-2.50,-1.77,-0.66,0.71,3.78,13.95,25.07,29.86,30,32,33,35,35,34,32,30,28,22,18,16,16,17,18,18.98,19.85,21.02,22,22.64,22.50,20.87,18.20,15.98,13.34,8.21,3.62,0.88,-0.39,-1.37,-2.02,-2.62,-3.05,-3.43,-3.75,-4,-4.30,-4.52,-4.75,-4.92,-5,-5,-4.93,-4.77,-4.63,-4.37,-4,-3.65,-3.36,-3,-2.65,-2.28,-1.90,-1.50,-1.09,-0.63,-0.17,0.28,0.83,1.39,2.03,2.65,3,4,5,6,7,8,9,10,11,12,13,15,16,18,20,22,24,26,28,32,36,40,44,48,49,50,52,53,53,53,52,52,50,47,43,38,34,30,26,23,20,18,16,14,13,12,10,9,8,7,7,6,6,5,5,4,4,3,3,3,2,2,1.99,1.98,1.96,1.83,1.61,1.37,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,12,16,15,10,7,5,4,3,3,5,4,3,3,3,3,3,3,4,5,6,7,11,15,19,22,23,23.12,23.21,22.86,21.82,20.53,19.61,19.40,19.72,21.65,24.24,25.85,21.50,17.63,14.13,11.20,8.78,7.03,5.88,5.23,4.92,4.66,4.38,4.12,4.02,4,4,4,4,3,3,3,3,3,3,2.89,2.87,3.29,1.74,1.67,1.62,2.17,2.17,2,2.16,1.66,1.76,1.95,2.22,2.63,3.23,3.88,4.50,5,5.36,5.52,5.58,5.51,5.47,5.38,5.37,5.28,5.16,5,4.74,4.40,4.08,3.73,3.38,3.12,2.97,2.78,2.70,2.62,2.62,2.61,2.62,2.65,2.73,2.77,2.87,2.96,3.03,3.13,3.25,3.37,3.50,3.63,3.78,3.98,4.15,4.39,4.70,5.03,5.48,5.97,6.50,7.10,7.66,8.25,8.83,9.34,9.83,10.35,10.96,11.66,12.58,13.62,14.83,16.03,17.14,17.86,17.76,-5.27,-5.41,-5.64,-5.89,-6.11,-6.15,-6.04,-5.75,-5.34,-4.76,-4.16,-3.52,-2.89,-2.25,-1.38,-0.23,1.99,3.23,17.85,26.71,33,36,39,42,42,40,36,33,29,26,22,18,18,18,19,19,21,23.22,25.50,26.25,26.77,26.12,22.89,21.37,19.62,14.36,3.37,2.58,0.50,-0.52,-1.41,-2.14,-2.67,-3.03,-3.34,-3.52,-3.76,-3.91,-4.10,-4.22,-4.25,-4.22,-4.16,-4.05,-3.97,-3.76,-3.51,-3.25,-3,-2.68,-2.35,-1.97,-1.53,-1.11,-0.65,-0.25,0.12,0.50,0.96,1.49,2.12,2.86,3,4,5,6,7,8,9,10,11,12,13,14,16,17,19,21,22,24,26,29,33,36,40,44,46,47,47,48,48,47,47,47,45,44,41,37,32,28,25,22,19,17,16,14,13,11,10,9,8,7,7,6,6,5,5,4,4,3,3,3,2,2,2,1.98,1.95,1.83,1.61,1.37,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,10,16,17,14,10,6,4,4,4,4,4,3,3,3,3,3,3,4,5,6,8,13,18,23,25,26,25.12,24.79,23.75,22.37,20.95,19.54,19.46,19.65,20.66,24.32,25.28,21.59,17.63,14.10,11.02,8.62,6.85,5.70,5.17,5.03,4.82,4.48,4.16,4,4,4,4,4,3,3,3,3,3,3.04,3.09,2.88,3.26,1.70,1.65,2.16,2.16,2.16,2,2.15,1.70,1.76,1.91,2.16,2.52,3.01,3.51,4,4.37,4.62,4.73,4.73,4.63,4.53,4.47,4.41,4.38,4.32,4.15,3.96,3.73,3.47,3.21,2.98,2.77,2.63,2.60,2.53,2.53,2.57,2.62,2.66,2.74,2.83,2.88,2.99,3.09,3.21,3.33,3.46,3.60,3.74,3.88,4.07,4.24,4.45,4.66,4.98,5.34,5.75,6.26,6.85,7.45,8.07,8.65,9.25,9.77,10.32,10.87,11.58,12.41,13.49,14.75,16.25,17.86,19.41,20.83,20.99,-5.79,-6,-6.26,-6.60,-6.86,-6.93,-6.80,-6.47,-5.90,-5.25,-4.55,-3.88,-3.23,-2.60,-1.79,-0.98,0.70,3.26,13.49,23.33,31,38,42,46,45,42,38,35,31,27,22,21,20,21,21,21,23,25,28.14,30.35,31.60,31.41,28.60,26.41,24,17.75,10.62,3.37,2.07,0.37,-0.85,-1.75,-2.38,-2.75,-3.02,-3.22,-3.38,-3.50,-3.63,-3.72,-3.73,-3.66,-3.65,-3.60,-3.47,-3.34,-3.13,-2.89,-2.64,-2.37,-2,-1.62,-1.14,-0.67,-0.25,0.12,0.46,0.74,1.03,1.50,2.12,3,3,4,5,6,6,7,8,9,10,12,13,14,15,17,18,19,21,22,24,27,30,33,36,40,41,40,41,41,41,41,41,41,40,39,37,35,30,27,24,21,19,17,15,14,12,11,10,9,8,7,7,6,6,5,5,4,4,3,3,3,2,2,1.99,1.98,1.91,1.83,1.61,1.36,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,11,17,20,18,14,9,5,4,4,4,4,3,3,3,3,3,3,4,5,7,10,14,20,24,27,28,27.89,26.83,25.12,23.27,21.39,20.27,19.52,19.58,20.60,23.38,25.38,21.40,17.52,13.87,10.85,8.54,6.87,5.85,5.45,5.38,5.14,4.79,4,4,4,4,4,4,3,3,3,3,3,2.92,3.07,2.90,3.23,1.74,1.71,2.15,1.70,2.14,2.14,2.13,1.74,1.82,1.95,2.15,2.47,2.85,3.21,3.52,3.82,3.97,4,3.96,3.86,3.75,3.65,3.62,3.62,3.58,3.48,3.33,3.13,3,2.83,2.65,2.51,2.40,2.37,2.37,2.38,2.46,2.52,2.64,2.87,2.89,3.01,3.12,3.25,3.36,3.50,3.65,3.84,4,4.20,4.37,4.53,4.75,4.99,5.25,5.62,6.02,6.52,7.10,7.66,8.26,8.87,9.46,10,10.59,11.24,12.01,13.02,14.32,15.85,17.66,20.09,22.10,24,25,-6.18,-6.43,-6.84,-7.23,-7.59,-7.74,-7.62,-7.17,-6.51,-5.75,-4.93,-4.17,-3.49,-2.80,-2.17,-1.25,0.50,3.25,12.37,21.50,31,39,45,48,46,42,40,37,33,27,24,24,24,24,23,24,26,30,32,34.99,37.97,37.96,34.02,31.95,27.63,22.33,14.49,7.98,3.58,1.23,-0.34,-1.38,-2.13,-2.54,-2.84,-3,-3.14,-3.25,-3.30,-3.38,-3.38,-3.36,-3.34,-3.25,-3.13,-2.99,-2.76,-2.53,-2.26,-1.98,-1.62,-1.22,-0.75,-0.34,0.09,0.40,0.65,0.87,1.10,1.48,1.99,3,3,4,5,5,6,7,8,9,10,11,12,14,15,16,17,18,19,21,22,24,27,29,30,34,35,34,34,35,35,35,35,35,35,34,33,31,28,25,22,20,18,16,15,13,12,11,10,9,8,7,7,6,6,5,5,4,4,3,3,3,2,2,2,1.99,1.95,1.82,1.61,1.36,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,12,18,22,23,20,13,8,5,4,4,4,3,3,3,3,3,3,4,5,7,10,14,19,24,29,31,30.92,28.96,26.89,24.25,22.29,21.03,19.41,19.48,19.50,22.49,24.49,21.51,17.42,13.37,10.27,8.21,7.14,6.07,6,6,6,5,4,4,4,4,4,4,4,4,4,4,4,3,2.92,2.92,3.16,1.78,1.75,1.87,1.76,1.76,1.75,1.76,1.82,1.89,2.01,2.22,2.49,2.73,2.98,3.20,3.34,3.39,3.38,3.33,3.23,3.12,3.03,3,2.99,2.99,2.91,2.84,2.73,2.62,2.51,2.38,2.28,2.24,2.23,2.28,2.66,2.42,2.54,2.95,2.88,3.01,3.13,3.27,3.39,3.53,3.72,3.88,4.12,4.34,4.52,4.75,4.95,5.12,5.36,5.61,5.90,6.28,6.75,7.25,7.78,8.35,8.88,9.47,10.02,10.64,11.37,12.28,13.46,15,17.08,19.22,22.98,26,28,29,-6.53,-6.89,-7.30,-7.75,-8.16,-8.37,-8.25,-7.78,-7.04,-6.16,-5.27,-4.42,-3.68,-3,-2.30,-1.34,0.46,3.37,12.50,22.75,34,42,48,50,48,46,43,40,34,28,26,27,26,26,25,26,29,33,36,39,43,42,39,35,29.86,24.50,16.12,9.86,4.96,1.87,0.09,-1.10,-1.90,-2.38,-2.66,-2.88,-3,-3.09,-3.13,-3.15,-3.15,-3.13,-3.10,-3,-2.87,-2.67,-2.42,-2.13,-1.86,-1.50,-1.14,-0.76,-0.38,0,0.35,0.62,0.78,0.91,1.07,1.20,2,2,3,3,4,5,6,7,7,8,9,10,12,13,14,15,16,17,18,19,20,21,22,23,25,27,29,28,28,30,31,31,31,31,30,29,28,27,25,23,21,19,18,16,14,13,12,11,10,9,8,7,6,6,5,5,5,4,4,3,3,3,2,2,2,1.99,1.95,1.83,1.61,1.36,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,11,17,22,25,23,17,11,6,4,4,4,3,3,3,3,3,4,4,5,7,10,14,18,24,30,33,32.98,31.88,28.83,26.23,24.26,22.09,20.34,19.35,19.36,21.92,24.64,21.65,17.29,14,11.23,9.16,7.11,7.01,7,7,7,6,5,4,4,4,4,4,4,5,5,5,5,4,3,2.92,3.11,3.14,3.16,1.79,2.26,1.86,2.15,1.87,1.92,2.01,2.16,2.37,2.52,2.73,2.87,3,3.02,3,2.98,2.87,2.75,2.66,2.62,2.59,2.53,2.58,2.53,2.50,2.41,2.37,2.27,2.21,2.16,2.15,2.17,2.25,2.36,2.87,3,2.87,3.32,3.39,3.48,3.52,3.60,3.75,3.95,4.14,4.40,4.70,4.97,5.20,5.38,5.60,5.76,5.99,6.25,6.58,6.96,7.37,7.85,8.33,8.83,9.36,9.95,10.61,11.39,12.36,13.70,15.39,18.02,22,26,30,34,35,-7,-7.27,-7.75,-8.25,-8.66,-8.88,-8.76,-8.26,-7.50,-6.53,-5.59,-4.64,-3.84,-3.13,-2.38,-1.35,0.35,3.37,12.77,24.47,35,45,50,51,50,49,46,41,35,29,29,29,29,28,28,29,32,35,40,44,46,46,39,34,28,22.87,16.71,10.52,5.62,2.37,0.39,-0.79,-1.66,-2.17,-2.52,-2.76,-2.88,-2.97,-3,-3,-3,-2.97,-2.88,-2.75,-2.60,-2.35,-2.04,-1.74,-1.37,-1,-0.65,-0.30,0,0.32,0.57,0.75,0.87,0.96,1,1,1,2,2,3,4,4,5,6,7,7,8,10,11,12,13,14,14,15,16,17,18,18,19,20,21,23,25,25,25,26,27,27,27,27,27,26,25,23,22,21,20,18,16,15,14,12,11,10,9,9,8,7,6,6,5,5,5,4,4,3,3,3,2,2,2,1.99,1.95,1.83,1.62,1.37,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,10,16,21,24,24,19,12,7,5,4,4,3,3,3,3,3,4,5,6,8,10,15,19,25,31,34,34,32.07,31.12,29.17,26.76,23.25,20.28,19.29,19.32,21.67,23.70,21.08,17.25,14.23,12.02,10.02,8.07,8,8,8,7,6,5,4,4,4,5,5,6,6,6,6,6,5,4,3,2.98,2.97,3.10,3.12,1.88,2.08,1.99,2.01,2.09,2.23,2.37,2.53,2.73,2.87,2.99,3,2.95,2.83,2.66,2.62,2.50,2.40,2.37,2.33,2.28,2.26,2.28,2.25,2.25,2.16,2.12,2.10,2.10,2.12,2.63,2.75,2.87,2.70,2.84,2.97,3.50,3.25,3.67,3.49,3.71,3.97,4.16,4.47,4.76,5.12,5.41,5.72,5.91,6.12,6.25,6.40,6.61,6.85,7.13,7.49,7.86,8.25,8.65,9.15,9.75,10.46,11.28,12.37,13.16,16,19,24,29,34,38,40,-7.53,-7.63,-8.13,-8.65,-9.16,-9.43,-9.35,-8.77,-7.89,-6.86,-5.78,-4.79,-3.97,-3.22,-2.42,-1.38,0.14,3.37,12.45,22.49,34,45,50,51,50,49,46,41,36,32,31,31,31,32,33,34,34,37,42,48,51,46,36,31,28,23,16.49,10.99,6.07,2.72,0.63,-0.53,-1.39,-1.97,-2.37,-2.63,-2.75,-2.84,-2.84,-2.78,-2.75,-2.73,-2.63,-2.47,-2.22,-1.91,-1.55,-1.22,-0.85,-0.48,-0.13,0.15,0.40,0.62,0.77,0.88,0.96,0.98,0.99,1,1,2,2,3,3,4,4,5,6,7,8,9,10,11,12,13,13,13,14,15,16,17,17,18,19,21,21,22,22,23,23,23,24,24,24,24,22,21,20,19,18,17,15,14,13,12,11,10,9,8,7,7,6,5,5,5,4,4,4,3,3,3,2,2,2,1.98,1.90,1.82,1.61,1.37,1.15,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,10,14,19,23,23,20,14,7,5,4,4,3,3,3,3,4,4,6,7,8,11,16,22,26,33,35,35,35,34.92,32.99,30,26.13,21.24,19.25,18.25,20.99,23.75,21.75,18.21,15.16,12.12,11,10,9,9,8,7,6,5,5,5,5,5,6,7,8,8,7,6,5,4,4,3,3,3,3,3,2.11,2.24,2.24,2.35,2.47,2.62,2.85,3.07,3.20,3.24,3.16,3.01,2.85,2.63,2.50,2.40,2.34,2.25,2.23,2.16,2.14,2.13,2.14,2.12,2.04,2.02,2.03,2.50,2.61,2.74,2.33,2.63,3.34,3.47,3.60,3.70,3.37,3.51,3.61,3.85,4.14,4.41,4.76,5.15,5.61,6,6.33,6.57,6.71,6.78,6.87,7,7.13,7.35,7.60,7.86,8.12,8.47,8.88,9.48,10.24,11.09,12.13,14.01,16,20,26,33,39,45,47,-8.01,-7.93,-8.49,-9,-9.43,-9.64,-9.50,-8.92,-8.04,-7,-5.93,-4.97,-4.09,-3.28,-2.50,-1.65,0,3.26,9.87,19.26,30,39,45,45,46,46,44,39,36,34,33,33,34,36,38,40,39,39,44,50,54,48,39,35,31,25,17,11.59,6.45,2.62,0.75,-0.30,-1.11,-1.65,-2.13,-2.43,-2.53,-2.62,-2.59,-2.52,-2.43,-2.37,-2.24,-2.03,-1.75,-1.39,-1.02,-0.65,-0.30,0.01,0.33,0.51,0.70,0.82,0.87,0.95,0.97,0.99,1,1,1,1,2,2,3,3,4,4,5,6,7,8,9,10,11,11,11,12,13,14,14,15,15,16,17,18,19,19,19,20,20,20,21,21,21,21,20,19,18,17,16,15,14,13,12,12,10,9,8,8,7,6,6,5,5,5,4,4,4,3,3,3,2,2,1.99,1.97,1.89,1.77,1.61,1.37,1.16,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,6,9,13,17,19,21,19,13,8,5,4,4,3,3,3,4,4,5,6,9,10,13,18,24,29,33,36,36,38,39,37.92,34.88,28.89,24.15,19.20,18.21,20.21,22.79,23.83,19.14,16.03,13.07,12,11,11,10,9,8,7,6,5,5,5,6,7,8,9,9,8,7,6,5,4,3,3,3,3,3,3,2.12,2.50,2.62,2.86,3.08,3.33,3.52,3.63,3.62,3.50,3.26,3.01,2.78,2.61,2.50,2.38,2.33,2.25,2.20,2.12,2.11,2.12,2.04,2,2.01,2.45,2.10,2.16,2.26,2.58,2.73,3.47,3.62,3.75,3.87,3.97,3.65,4.15,3.97,4.29,4.66,5.09,5.59,6.12,6.62,7.01,7.26,7.37,7.46,7.49,7.51,7.61,7.72,7.84,7.98,8.11,8.27,8.63,9.15,10.02,11.12,12.01,15,18,23,29,36,45,52,55,-8.50,-8.23,-8.87,-9.35,-9.63,-9.73,-9.50,-8.90,-8.04,-7.03,-6,-5.02,-4.14,-3.38,-2.63,-1.75,-0.34,1.83,2.28,15.27,25,32,36,36,40,42,41,38,35,34,35,37,37,40,44,46,46,45,48,54,58,53,47,42,36,28,21,13,6.50,2.03,0.66,-0.16,-0.74,-1.29,-1.84,-2.16,-2.25,-2.28,-2.25,-2.12,-1.99,-1.86,-1.67,-1.48,-1.17,-0.84,-0.50,-0.13,0.15,0.41,0.62,0.76,0.87,0.91,0.97,0.98,1,1,1,1,1,1,2,2,3,3,3,4,5,6,6,7,8,9,10,10,10,11,12,12,13,13,14,14,15,16,17,17,17,17,18,18,18,19,19,19,18,17,16,15,14,13,13,12,11,10,9,8,8,7,7,6,5,5,5,4,4,4,4,3,3,3,2,2,1.99,1.97,1.90,1.78,1.61,1.37,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,7,12,16,19,20,21,20,14,8,5,4,4,3,3,4,4,4,5,6,9,11,14,19,25,30,34,35,37,39,42,41,36.98,31.92,26.10,21.12,18.12,19.12,22.87,23.89,20.07,16.98,14,13,13,12,11,9,8,7,6,5,5,6,7,8,9,11,10,9,8,6,5,4,3,3,3,3,3,3,3,2.98,3.22,3.40,3.74,4,4.21,4.23,4.12,3.88,3.62,3.35,3.09,2.87,2.72,2.62,2.50,2.37,2.26,2.21,2.12,2.12,2.03,2.28,2.02,2.08,2.83,2.60,3.11,3.26,2.82,3.60,3.76,3.89,4.01,4.12,3.62,4.22,4.39,4.49,4.96,5.39,5.96,6.60,7.24,7.74,8,8.10,8.16,8.24,8.28,8.37,8.40,8.47,8.49,8.45,8.52,8.37,9.23,10.12,11.01,13,16,20,24,31,38,46,54,59,-9.34,-8.99,-9.28,-9.62,-9.79,-9.79,-9.50,-8.89,-8.03,-7.03,-6,-5.01,-4.16,-3.41,-2.67,-1.88,-0.72,0.53,2.53,10.63,21,27,28,30,37,40,40,38,37,36,38,41,42,42,46,51,52,52,55,58,61,58,52,46,38,31,22,14,7,1.37,-0.29,0.03,-0.13,-0.91,-1.40,-1.76,-1.92,-1.79,-1.66,-1.51,-1.38,-1.22,-1.03,-0.84,-0.55,-0.25,0.07,0.35,0.58,0.74,0.85,0.89,0.96,0.98,0.99,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,6,7,7,8,9,9,9,10,11,11,11,12,12,13,14,14,15,15,15,15,16,16,16,16,16,16,16,15,14,14,13,12,11,11,10,9,8,8,7,7,6,6,5,5,5,4,4,4,4,3,3,3,2.27,2.03,1.99,1.98,1.91,1.82,1.61,1.37,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,9,15,20,24,25,25,22,15,9,6,5,4.16,3.88,3.77,3.89,4.03,4.39,5.09,6.39,8.16,10.16,15,21,26,30,33,35,37,40,43,42,39,34,28,23,19,18,21,23,21,17,15,15,14,13,11,9,8,7,6,5,6,7,8,9,10,11,9,8,7,6,5,4,3,3,3,3,3,3,3,4,4,4.25,4.60,4.95,5.03,4.95,4.70,4.37,4.03,3.75,3.49,3.26,3.11,2.95,2.82,2.62,2.49,2.34,2.24,2.16,2.08,2.04,2.48,2.60,2.90,2.48,2.59,2.73,3.53,3.07,3.89,4.02,4.15,4.25,4.37,3.98,4.25,4.63,5.15,5.65,6.25,6.90,7.57,8.10,8.47,8.74,9,9.26,9.53,9.75,9.75,9.75,9.65,9.50,9.32,10.12,10.10,10,11,13,17,21,26,31,38,46,54,60,-10,-9.73,-9.74,-9.87,-9.88,-9.73,-9.34,-8.68,-7.88,-6.93,-5.99,-5.04,-4.24,-3.50,-2.77,-2,-1.12,0.37,3,7.88,15.98,21,23,27,34,39,39,40,39,38,41,45,46,47,49,53,56,58,59,62,64,62,55,46,38,30,21,13,7,1,0.82,-0.50,-0.29,-0.40,-0.88,-1.27,-1.37,-1.13,-0.92,-0.78,-0.64,-0.50,-0.38,-0.18,0,0.24,0.46,0.62,0.76,0.87,0.90,0.96,0.97,0.99,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,6,7,7,8,8,9,9,10,10,10,10,11,12,12,13,13,14,14,14,14,14,14,14,14,14,14,13,13,12,12,11,10,10,9,8,8,7,7,6,6,5,5,5,4,4,4,4,3,3,3,2.83,2.37,2.08,1.99,1.98,1.91,1.83,1.61,1.36,1.13,1.01,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,9,18,25,31,32,30,24,17,10,7.01,5.34,4.78,4.37,4.15,4.10,4.20,4.54,5.23,6.25,7.76,10.40,14.65,19.98,24,27,30,34,37,40,41,41,38,35,31,26,21,18,18,21,20,17,15,15,15,13,11,9,8,7,6,5,6,7,9,10,10,10,9,8,7,5,5,4,3,3,3,3,3,3,4,5,5,5,5.84,6.14,6.12,5.76,5.27,4.86,4.50,4.22,3.98,3.76,3.62,3.41,3.23,3,2.76,2.53,2.37,2.25,2.12,2.11,2.13,2.36,2.45,3.12,3.26,2.58,3.62,3.14,4,4.13,4.25,4.37,4.48,4.61,4.59,4.97,5.34,5.87,6.49,7.13,7.75,8.36,8.87,9.36,9.89,10.53,11.12,11.62,11.73,11.58,12.40,11.24,12.13,12.07,13,11,11,13,16,21,26,32,39,47,55,60,-10,-10,-10,-10,-10,-9.67,-9.23,-8.55,-7.75,-6.86,-5.90,-5.03,-4.25,-3.54,-2.88,-2.16,-1.25,0.16,2.22,5.46,10.66,14,17,24,30,36,39,40,40,41,42,47,52,55,55,57,59,61,63,65,66,62,54,44,36,27,19,12,7,3,1.07,0.87,0.82,0.75,-0.74,-0.43,-0.43,-0.29,-0.11,0,0.11,0.22,0.25,0.37,0.49,0.61,0.73,0.83,0.87,0.95,0.97,0.98,0.99,1,1,1,1,1,1,2,2,2,1.87,1.98,2.01,2.25,2.58,3.08,3.62,4.20,4.77,5.37,6,6.70,7.11,8,8,8,9,9,9,9,10,11,11,11,12,12,12,12,12,12,12,12,12,12,12,12,12,11,11,10,9,9,8,8,7,7,7,6,6,5,5,4,4,4,4,3,3,3,2.99,2.66,2.35,2.12,2,1.97,1.88,1.75,1.59,1.37,1.15,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,10,20,29,35,35,31,24,17,10.01,7.37,6.10,5.38,4.99,4.70,4.54,4.60,4.88,5.45,6.26,7.52,9.60,12.42,15.37,18.01,21,25,31,35,36,36,35,33,31,30,28,23,19,17,18,18,16,14,14,15,14,12,10,8,7,6,6,6,8,9,11,11,10,9,8,7,7,5,4,4,4,4,4,4,4,5,5,6,7,7,7.91,7.63,6.62,5.83,5.28,4.95,4.72,4.51,4.37,4.24,4.07,3.83,3.50,3.13,2.84,2.53,2.37,2.20,2.15,2.75,2.92,3.09,2.62,2.50,2.63,2.83,3.89,4.09,4.23,4.34,4.45,4.53,4.65,4.51,5.10,5.37,5.90,6.52,7.20,7.86,8.52,9.32,10.28,11.50,12.82,13.70,14.59,15.46,16.27,17.15,17.09,17.99,18,17,13,11,13,16,20,25,31,39,47,54,58,-11,-11,-10,-10,-10,-9.75,-9.18,-8.50,-7.67,-6.77,-5.88,-5.02,-4.27,-3.63,-2.97,-2.26,-1.39,-0.29,1.36,3.70,5.77,8.12,12,16,23,31,36,38,41,44,45,48,55,61,61,61,62,63,65,66,63,58,50,40,32,25,17,11,7,4,2,1.07,1.09,0.83,0.77,0.74,0.50,0.46,0.62,0.76,0.64,0.66,0.75,0.82,0.86,0.87,0.90,0.96,0.98,0.99,1,1,1,1,1,1,1,2,2,2,2,1.98,1.95,1.89,1.99,2.13,2.40,2.77,3.25,3.75,4.26,4.83,5.37,5.89,6.45,6.87,7,8,8,8,8,8,9,10,10,10,10,11,11,11,11,11,11,11,11,11,11,11,11,10,10,9,9,8,8,7,7,7,6,6,5,5,4,4,4,4,3,3,3,3,2.97,2.62,2.34,2.12,2.01,1.97,1.88,1.76,1.59,1.37,1.15,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,12,24,32,37,36,30,23,15,10.34,7.66,6.85,6.32,5.90,5.59,5.33,5.27,5.40,5.78,6.45,7.41,8.82,10.63,12.66,14.34,17,23,29,33,33,32,31,28,27,26,25,23,19,16,16,16,14,13,13,14,14,12,10,8,7,6,6,7,9,10,12,12,10,9,9,9,7,5,4,4,4,4,4,4,5,5,6,7,8,9,9,9,7.07,6.32,5.52,5.39,5.24,5.11,5.02,4.99,4.86,4.59,4.15,3.65,3.13,2.73,2.45,2.23,2.20,2.27,3,3.15,2.49,3.16,2.67,3.54,4,4.20,3.66,4.37,4.46,4.53,4.62,4.78,4.83,5.32,5.85,6.48,7.16,7.96,8.85,10.12,11.71,13.62,16.27,18.75,20.84,22.14,23.89,24.98,24,24,22,18,13,12,14,16,20,24,30,37,44,51,55,-12,-11,-11,-10,-10,-9.92,-9.27,-8.52,-7.68,-6.80,-5.92,-5.12,-4.37,-3.68,-3.04,-2.38,-1.63,-0.64,0.59,2,3.15,5.37,7,11,17,24,31,38,44,48,49,50,58,65,67,66,65,66,67,65,58,51,43,34,26,21,15,10,7,5,3,2,1.07,1.11,0.97,0.96,0.95,0.87,0.88,0.89,0.91,0.95,0.96,0.97,0.98,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1.84,1.66,1.66,1.66,1.66,1.74,1.84,2,2.25,2.53,2.87,3.33,3.82,4.28,4.78,5.27,5.75,6.14,6.70,6.98,7,8,8,8,8,9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,8,8,7,7,7,6,6,5,5,4,4,4,4,3,3,3,3,3,2.91,2.57,2.26,2.10,2,1.97,1.88,1.75,1.58,1.37,1.16,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,12,24,33,37,36,29,22,15.16,10.60,8.77,7.87,7.51,7.24,6.88,6.52,6.25,6.12,6.27,6.75,7.53,8.61,10.03,11.90,13.58,17.16,22,30,33,33,31,29,27,26,24,23,21,18,16,14,14,13,12,12,13,14,12,10,8,7,6,7,8,10,11,12,11,10,9,9,9,7,6,5,5,5,5,5,5,5,6,7,9,11,11,10,9,8,7,6,5.96,5.76,5.71,5.71,5.88,5.85,5.52,5,4.28,3.53,2.87,2.39,2.12,2.20,2.85,3.11,3.23,3.29,2.61,2.73,3.01,4.11,4.25,4.34,4.37,4.42,4,4.51,4.62,4.79,5.09,5.62,6.28,7.12,8.12,9.51,11.25,13.39,16.33,20.23,24.87,27.96,30,31,32,29,28,24,18,13,12,14,17,20,23,29,36,42,49,54,-12,-12,-11,-11,-10,-10,-9.48,-8.65,-7.77,-6.88,-6,-5.16,-4.41,-3.75,-3.13,-2.49,-1.75,-0.92,-0.03,0.87,1.61,1.74,6,12,19,25,32,41,48,52,53,54,61,68,70,69,69,69,68,62,55,47,38,28,22,17,13,10,7,5,4,3,2,1,1.07,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,1.12,1.25,1.37,1.37,1.38,1.45,1.50,1.63,1.82,2.01,2.28,2.62,2.99,3.37,3.84,4.26,4.73,5.12,5.52,5.84,6.09,6.26,6.86,7,7,8,8,8,8,8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,7,7,6,6,6,5,5,4,4,4,4,3,3,3,3,3,3,2.71,2.37,2.16,2.08,2,1.97,1.88,1.76,1.59,1.37,1.16,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,5,12,24,31,35,34,28,21,14.39,11.13,9.70,9.23,9.08,8.85,8.47,7.92,7.39,7.01,6.92,7.23,7.89,8.88,10.33,12.35,15.25,18.37,25,32,34,34,33,33,32,31,28,23,20,17,15,13,13,12,11,12,12,13,11,10,8,7,6,8,10,11,12,12,10,9,9,8,7,7,6,6,6,6,6,7,7,6,7,8,10,12,13,11,10,9,8,7,7,6,6,7,7,7,7,6,5,4,3,2,1.92,1.85,3.21,3.21,3.26,3.33,2.62,2.84,4.12,4.25,4.33,4.35,3.83,3.87,4.21,3.90,4.01,4.27,4.74,5.24,6,6.88,8.12,10,12.88,14.95,19,24,30,34,36,38,37,33,28,22,16,13,13,15,17,20,24,30,38,46,52,56,-13,-12,-12,-11,-11,-10,-9.73,-8.88,-7.98,-7.04,-6.15,-5.30,-4.53,-3.86,-3.17,-2.50,-1.80,-1.11,-0.38,0.26,0.75,1.91,9,17,24,32,39,47,55,59,58,61,68,71,72,72,72,71,65,58,51,43,34,25,19,15,12,9,7,5,4,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,1,1.01,1.08,1.12,1.14,1.16,1.24,1.33,1.46,1.62,1.83,2.07,2.36,2.70,3.02,3.40,3.83,4.22,4.58,4.87,5.10,5.26,5.58,5.87,6.25,6.98,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,6,6,6,5,5,4,4,4,4,3,3,3,3,3,3,2.87,2.38,2.21,2.10,2.01,2,1.97,1.88,1.76,1.59,1.37,1.15,1.03,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,12,23,31,33,32,26,19,14.86,11.59,10.99,10.77,10.82,10.70,10.25,9.53,8.73,8.08,7.75,7.87,8.41,9.45,11,13.36,16.64,21.38,27.02,34,36,37,37,38,38,37,33,27,22,18,16,14,12,12,11,11,11,11,11,10,8,7,7,8,10,12,11,10,9,9,8,8,7,7,7,6,7,7,8,8,9,8,9,10,11,13,14,13,12,11,10,8,7,7,8,8,8,9,8,7,6,4,3,3,1.98,1.88,3.16,3.23,3.26,3.29,2.65,2.64,4.36,4.36,4.35,4.34,3.85,3.73,3.76,3.83,3.88,3.98,4,5,6,6,8,10,13,15,18,23,30,35,38,39,36,31,25,19,14,12,14,15,18,21,25,31,39,48,55,57,-13,-13,-13,-12,-11,-10,-10,-9.12,-8.17,-7.25,-6.35,-5.48,-4.65,-3.90,-3.22,-2.50,-1.78,-1.05,-0.37,0.07,0.76,2.21,12,20,27,37,44,52,60,65,65,69,72,73,74,74,73,68,61,56,48,39,31,23,17,15,13,10,7,6,5,4,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,1,1,1.01,1.03,1.10,1.15,1.27,1.45,1.62,1.85,2.11,2.39,2.74,3.07,3.39,3.75,4.08,4.34,4.50,4.65,4.90,5.24,5.63,5.87,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,5,5,4,4,4,4,3,3,3,3,3,3,3,2.25,2.13,2.02,2.01,2,1.99,1.97,1.89,1.77,1.59,1.36,1.15,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,13,24,30,31.83,27.62,22.52,17.78,14.87,13.39,12.64,12.61,12.73,12.61,12.09,11.22,10.16,9.27,8.74,8.64,9.07,10.01,11.64,14.12,17.72,22.66,29.59,34.97,37,38,40,42,43,41,37,32,26,22,19,16,13,12,11,11,11,10,10,10,8,7,7,8,10,11,10,9,9,8,8,8,8,7,7,7,7,8,9,10,10,10,10,11,13,15,15,14,13,12,10,8,8,8,9,10,10,10,10,9,8,6,4,3,2,1.92,3.12,2.89,2.87,2.87,3.14,2.70,2.67,4.32,4.29,4.28,4.25,4.23,4.17,4.12,4.02,4,4,5,6,6,7,10,13,14,17,21,26,32,36,35,31,25,20,15,12,13,14,16,19,23,27,32,39,48,54,57,-14,-14,-13,-12,-12,-11,-10,-9.37,-8.40,-7.43,-6.50,-5.61,-4.75,-3.93,-3.16,-2.40,-1.62,-0.75,0.02,0.78,1.47,2.53,14,22,30,39,47,55,64,70,74,74,75,75,75,74,71,65,59,51,42,35,29,22,17,14,12,10,8,6,5,4,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.14,1.27,1.46,1.64,1.87,2.14,2.46,2.75,3.03,3.36,3.62,3.87,4.03,4.21,4.41,4.70,4.98,5.21,5.25,5,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,5,5,4,4,4,4,3,3,3,3,3,3,3,2,2.11,2,2,2,2,1.99,1.97,1.89,1.78,1.60,1.36,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,4,8,15,25.98,31.65,29.40,25.72,20.90,17.37,16.41,15.27,14.87,14.82,14.82,14.59,13.92,12.91,11.71,10.62,9.87,9.58,9.83,10.66,12.24,14.66,18.12,22.83,29.25,33.63,35,37,41,42,43,42,39,33,28,24,21,17,15,13,11,11,11,10,10,9,8,7,7,8,9,10,10,9,8,8,8,8,8,8,8,8,8,9,10,11,12,12,12,13,14,16,15,14,12,11,9,9,9,9,10,12,12,13,12,11,9,7,5,3,2,2,3.07,2.92,3,3,3.12,3.12,2.74,2.74,2.75,2.75,2.78,2.83,2.87,4.07,4,4,4,5,6,7,8,9,12,13,16,19,23,27,31,29,25,20,16,13,11,13,15,17,20,24,30,35,40,46,52,57,-14,-14,-13,-13,-12,-11,-10,-9.61,-8.63,-7.63,-6.63,-5.68,-4.78,-3.92,-3.12,-2.25,-1.27,-0.25,1.07,2.58,4.11,2.78,18,26,33,41,50,58,66,74,78,77,76,74,74,71,65,61,56,48,40,33,27,22,17,15,13,11,9,8,6,5,4,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.09,1.16,1.32,1.49,1.70,1.91,2.20,2.47,2.73,3,3.25,3.48,3.64,3.84,4.02,4.24,4.47,4.61,4.76,4.99,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,4,4,4,4,3,3,3,3,3,3,3,2,2,2,2,2,2,1.99,1.99,1.98,1.90,1.78,1.60,1.36,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,6,11,19.01,28.62,31.32,29.09,25.09,21.23,19.21,18.34,17.65,17.37,17.29,17.14,16.67,15.85,14.67,13.36,12.11,11.15,10.66,10.73,11.39,12.77,15.02,18.12,22.14,26.36,30.45,33.20,36,39,41,40,39,37,32,28,25,24,22,19,17,14,12,11,10,9,9,8,7,7,8,9,9,9,9,8,8,9,9,10,10,10,10,9,9,10,11,12,13,14,14,15,16,14,13,12,11,10,10,10,11,11,12,13,14,13,11,9,7,5,3,3,2,3,3,3,3,3,3.10,3.11,3.11,3.10,3.09,3.08,3.04,2.92,4,4,4,4,5,7,9,10,9,11,12,14,17,19,22,25,23,20,15,12,11,11,13,16,19,23,27,33,39,44,47,54,58,-15,-14,-14,-13,-12,-11,-10,-9.79,-8.78,-7.76,-6.75,-5.75,-4.77,-3.88,-2.93,-1.99,-0.93,0.50,2.47,5.11,8.37,14.41,23,29,35,43,51,58,66,75,79,76,72,68,67,65,60,54,51,45,39,32,27,22,20,19,19,17,13,9,7,5,4,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.10,1.21,1.35,1.51,1.74,1.97,2.21,2.45,2.66,2.89,3.12,3.32,3.49,3.64,3.86,4.01,4.20,4.40,4.63,4.97,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,5,5,5,4,4,4,4,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1.99,1.98,1.90,1.82,1.60,1.36,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,8,14,21.97,30.32,32.03,29.59,26.13,23.23,21.39,20.87,20.49,20.32,20.13,19.75,19.03,17.98,16.62,15.13,13.74,12.62,11.91,11.75,12.21,13.35,15.27,17.96,21.28,24.75,28.47,32.03,35,39,39,38,37,35,32,29,27,28,25,22,18,16,14,14,11,10,9,8,8,7,8,9,9,9,9,9,9,10,10,11,11,11,11,11,10,11,12,14,15,15,15,15,15,14,13,12,11,11,11,12,12,13,13,14,13,12,11,9,7,5,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,5,6,8,10,10,10,10,12,14,15,17,18,20,19,16,13,12,11,11,13,16,21,26,31,35,41,47,51,56,61,-15,-14,-14,-13,-12,-11,-10,-9.99,-8.92,-7.88,-6.79,-5.75,-4.72,-3.73,-2.75,-1.67,-0.43,1.32,4,7.82,12.99,19.62,28,34,41,48,55,60,66,74,77,70,65,60,59,56,54,49,44,40,35,30,26,24,25,26,27,24,17,11,7,6,4,4,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.12,1.24,1.37,1.57,1.75,1.98,2.20,2.39,2.62,2.78,2.98,3.12,3.32,3.50,3.63,3.75,3.90,4.12,4.10,4.95,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,1.98,1.91,1.82,1.60,1.36,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,7,10,16.16,24.15,31.09,32.82,30.35,27.26,25,23.75,23.63,23.62,23.57,23.28,22.65,21.63,20.28,18.72,17.07,15.49,14.17,13.28,12.88,13.08,13.92,15.54,17.84,20.77,23.95,27.37,31.35,35,38,39,39,38,37,35,31,30,29,28,23,20,18,17,16,14,11,10,9,8,8,8,9,9,9,10,10,11,11,12,12,13,13,12,13,12,13,14,16,17,17,16,15,14,13,12,12,12,13,13,14,14,14,15,15,14,12,11,9,8,6,5,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,5,5,6,6,7,8,9,9,11,12,14,14,15,16,16,15,14,12,11,11,11,14,18,24,30,36,39,42,49,56,61,64,-15,-15,-14,-13,-13,-12,-11,-10,-9,-7.89,-6.76,-5.63,-4.50,-3.39,-2.29,-1.13,0.15,2.16,5.50,10.33,16.49,23.26,31,38,46,53,59,64,69,74,76,67,59,55,52,50,48,44,41,36,32,28,26,26,28,30,30,26,18,11,8,6,5,4,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.07,1.13,1.25,1.39,1.59,1.75,1.96,2.13,2.34,2.50,2.64,2.82,2.97,3.12,3.25,3.37,3.50,3.70,3.99,4.12,4.07,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1.98,1.91,1.82,1.60,1.36,1.14,1.02,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,9,14,19.37,26.57,31.90,32.64,30.85,28.23,26.58,26.09,26.46,26.87,27.04,26.71,25.78,24.40,22.74,20.91,19.08,17.33,15.83,14.72,14.07,14,14.59,15.91,17.90,20.50,23.64,27.29,31.48,35.35,38.01,40,41,41,40,36,33,30,29,27,25,21,19,19,18,16,13,11,9,9,9,8,9,9,10,11,12,12,13,13,14,15,14,14,14,14,15,16,17,18,16,15,14,14,13,13,13,13,15,15,16,17,17,17,17,16,14,12,10,8,7,5,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,6,8,7,7,7,7,8,9,11,13,14,14,14,14,13,13,12,11,11,11,12,15,20,26,34,42,44,46,51,58,65,67,-15,-15,-14,-14,-13,-12,-11,-10,-9.02,-7.88,-6.66,-5.43,-4.17,-2.91,-1.63,-0.37,1.21,3.21,6.62,13,19.75,27.22,32,40,48,56,62,68,72,78,73,65,55,49,46,45,43,39,36,32,30,28,27,28,31,32,28,21,15,10,8,6,5,4,4,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.09,1.14,1.26,1.40,1.58,1.74,1.89,2.08,2.23,2.37,2.50,2.62,2.75,2.89,3.01,3.15,3.37,3.77,3.83,3.87,3.95,4,4,4,4,4,5,5,5,5,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1.98,1.91,1.82,1.61,1.36,1.13,1.01,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,7,12,17,23.59,29.27,33.76,33.02,31.07,28.87,27.84,28.03,29.07,29.96,30.49,30.14,28.95,27.16,25.15,23.11,21.09,19.20,17.52,16.23,15.37,15.07,15.37,16.42,18.20,20.45,23.75,27.49,32.11,37.25,39.62,42,43,42,39,36,32,29,28,27,26,25,22,23,21,19,17,14,12,11,10,9,9,10,10,11,13,15,15,16,16,17,16,16,16,17,18,18,19,18,16,15,14,14,14,14,15,16,17,18,19,20,21,21,20,18,16,14,12,10,7,6,4,3,3,3,3,3,3,3,3,3,3,3,3,3,4,6,8,9,8,7,7,7,8,9,11,14,15,14,13,13,12,12,12,11,11,11,12,16,21,28,35,44,49,51,54,61,66,69,-15,-15,-14,-14,-13,-12,-11,-10,-9,-7.78,-6.50,-5.14,-3.74,-2.24,-0.67,0.97,2.75,5.47,6.39,17.46,25.64,32.91,39,45,52,59,64,68,74,75,71,64,56,49,44,41,39,36,33,31,28,27,27,29,31,29,23,17,12,9,7,6,5,5,4,4,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.10,1.15,1.26,1.38,1.51,1.66,1.83,1.97,2.10,2.22,2.34,2.45,2.59,2.72,2.86,3.02,3.21,3.21,3.13,3.10,3.01,3,3,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1.99,1.95,1.86,1.62,1.35,1.12,1,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,8,14,21,27.37,31.99,34.70,32.98,30.87,29.17,28.59,29.32,31.07,32.86,33.75,33.25,31.72,29.66,27.41,25.17,23.03,21.03,19.25,17.78,16.75,16.24,16.34,17.15,18.72,20.67,24.11,27.87,32.70,38,41.37,42.82,43,41,37,32,29,28,28,28,29,28,26,26,25,22,21,18,14,12,11,10,9,10,11,12,13,15,16,17,17,18,18,18,19,20,21,21,20,19,17,16,15,15,15,15,16,18,19,21,23,26,28,28,25,22,18,16,14,11,8,6,5,4,3,3,3,3,3,3,3,3,3,3,3,3,4,7,9,10,9,8,7,7,8,9,11,13,14,14,13,12,12,12,12,11,11,11,13,17,22,29,36,44,51,57,59,63,67,67,-16,-15,-14,-14,-13,-12,-11,-10,-8.97,-7.67,-6.29,-4.78,-3.14,-1.38,0.60,2.78,5.46,7.16,15.50,23.64,32.87,41.24,47,52,57,62,64,67,69,69,67,64,58,51,45,41,37,35,32,29,27,26,26,28,29,23,18,13,10,8,7,7,6,6,5,5,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.10,1.15,1.25,1.36,1.48,1.61,1.73,1.85,1.96,2.07,2.15,2.32,2.41,2.53,2.65,2.73,2.76,2.87,2.98,2.99,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1.99,1.97,1.88,1.62,1.34,1.08,1,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,9,16,23,29.32,32.95,33.64,31.96,30.10,28.73,28.33,29.17,31.29,34,36,35.37,33.60,31.62,29.35,27.07,24.87,22.82,20.95,19.37,18.17,17.49,17.40,18.07,19.09,21.28,24.61,28.33,33,38,41.14,41.59,41,37,33,29,27,27,27,29,30,29,28,28,26,24,23,20,17,14,14,12,10,11,12,12,13,15,16,17,19,19,20,20,21,23,24,24,23,22,20,18,17,17,17,17,18,19,22,25,29,34,37,36,32,26,23,21,18,13,9,6,5,4,3,3,3,3,3,3,3,3,3,3,3,3,5,7,9,9,8,7,7,7,8,9,10,12,13,14,13,12,12,12,12,11,11,11,13,17,23,29,37,46,54,60,62,63,63,63,-16,-15,-14,-14,-13,-12,-11,-10,-8.90,-7.60,-6.13,-4.48,-2.60,-0.41,2.11,5.12,8.75,14.02,21.34,31.77,40.99,48.51,55,58,61,64,63,62,63,62,61,61,59,53,48,43,38,34,30,28,26,25,24,26,27,21,16,11,9,8,8,7,7,7,6,6,5,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.09,1.13,1.21,1.28,1.38,1.50,1.61,1.72,1.83,1.95,2.07,2.14,2.25,2.33,2.27,2.25,2.77,2.85,2.89,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1.99,1.98,1.97,1.63,1.33,1,0.99,1,1,1,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,5,8,15,23,28.32,31.95,30.95,29.84,28.23,27.02,26.54,27.45,29.75,32.84,35.14,35.63,34.58,32.87,30.86,28.70,26.53,24.47,22.52,20.85,19.51,18.71,18.51,18.82,20.14,22.07,25.21,28.74,33.08,37.65,39.37,38.99,37,32,28,26,24,25,26,29,30,30,30,30,27,25,22,20,18,18,16,14,12,12,12,13,14,15,17,19,21,22,22,23,24,25,27,27,27,25,23,21,20,19,19,18,19,21,24,29,35,42,44,42,37,30,27,25,20,14,9,7,6,5,4,3,3,3,3,3,3,3,3,3,3,4,5,8,8,8,7,7,7,7,8,9,10,11,12,13,13,12,12,12,12,11,11,11,12,17,22,29,38,47,55,59,60,59,57,56,-15,-15,-14,-13,-13,-12,-11,-10,-8.80,-7.48,-5.91,-4.13,-2,0.52,3.62,7.37,12.16,18.41,26.52,36.02,46.24,53.85,59,61,63,63,60,57,58,57,57,59,56,52,49,44,38,32,29,27,25,24,23,24,25,20,15,12,9,9,9,8,8,8,8,8,7,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.07,1.10,1.14,1.23,1.28,1.37,1.49,1.60,1.73,1.84,1.88,1.97,2,2,2.12,2.23,2.15,2.11,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1.99,1.99,1.98,1.63,1.32,1,1,1,1.12,1.11,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,4,7,13,19,24.37,26.99,27.70,26.83,25.60,24.45,23.96,24.86,27.21,30.35,33.03,34.62,34.66,33.54,32,30.12,28.07,26,24.01,22.25,20.82,19.82,19.35,19.82,21.10,23.17,25.82,29.09,32.98,37.17,38.13,37.33,34,30,27,25,23,23,25,28,30,30,31,31,29,26,23,20,18,18,16,14,13,13,13,14,15,16,19,22,24,26,25,25,26,28,30,32,32,29,27,24,22,21,20,20,21,23,26,33,41,48,51,47,41,35,31,28,21,15,11,8,7,6,5,4,3,3,3,3,3,3,3,3,3,4,6,8,8,7,7,6,7,7,8,9,10,11,12,12,12,12,12,12,12,11,11,11,12,16,21,29,37,45,52,56,56,54,51,50,-15,-15,-14,-13,-13,-12,-11,-9.91,-8.72,-7.34,-5.75,-3.85,-1.52,1.37,5,9.49,14.96,21.60,29.53,39.41,47.62,54,59,60,60,59,55,53,53,53,55,57,53,48,44,40,35,31,29,26,25,22,22,22,21,17,13,12,11,11,10,9,9,10,11,11,9,5,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.01,1.07,1.09,1.12,1.20,1.25,1.37,1.50,1.58,1.62,1.64,1.73,1.86,1.98,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1.99,1.64,1.32,1,1,1.12,1.24,1.98,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,4,6,10,14,19.47,22.10,23.39,23.35,22.41,21.37,20.90,21.89,24.37,27.67,30.70,32.95,34.09,34.11,33.13,31.51,29.54,27.49,25.37,23.46,21.90,20.86,20.45,20.83,22.07,24.01,26.54,29.40,32.79,36.10,37.40,35.75,33,32,30,26,24,22,24,27,28,29,31,32,30,27,24,21,18,16,15,15,15,15,15,16,18,20,22,25,27,28,28,28,29,31,35,37,38,36,32,29,25,22,21,21,22,24,29,37,45,52,53,49,43,37,34,28,21,15,11,9,8,7,6,5,4,3,3,3,3,3,3,3,3,5,7,8,7,7,6,6,7,8,8,9,10,11,12,12,12,12,12,12,12,12,11,11,12,14,20,28,35,42,49,52,52,48,45,44,-15,-15,-14,-13,-12,-11,-10,-9.79,-8.55,-7.15,-5.52,-3.60,-1.14,2,6,10.90,16.73,23.41,30.61,38.87,45.98,52,56,56,55,54,51,50,50,52,55,55,52,46,42,37,34,31,30,28,26,22,20,19,17,14,13,13,13,15,12,11,11,12,13,13,11,7,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.03,1.11,1.16,1.25,1.33,1.35,1.36,1.35,1.66,1.84,1.96,1.98,1.98,2,2,2,2,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1.99,1.64,1.33,0.99,0.99,1.12,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,4,5,7,10,14.37,17.77,19.57,19.99,19.49,18.82,18.75,19.88,22.33,25.59,28.90,31.65,33.48,34.21,33.85,32.62,30.87,28.88,26.87,24.99,23.41,22.34,21.89,22.22,23.28,25.01,27.23,29.72,32.60,35.40,35.87,34.75,33,34,32,28,23,21,23,25,26,26,28,29,28,26,24,21,17,15,15,16,16,16,17,19,21,23,26,27,28,29,30,30,31,34,38,41,43,42,38,33,29,25,22,22,24,27,32,40,48,54,55,51,44,39,35,29,22,16,12,10,9,7,6,6,4,3,3,3,3,3,3,3,3,5,7,7,7,6,6,6,7,8,9,9,10,11,12,13,12,12,12,12,12,12,12,11,12,14,19,25,32,40,45,48,47,43,40,39,-15,-14,-14,-13,-12,-11,-10,-9.74,-8.48,-7.04,-5.42,-3.50,-1.03,2.14,6.26,11.32,17.59,23.32,29.87,36.64,43.25,50,51,51,50,49,48,48,49,52,56,57,53,48,42,38,34,34,32,31,28,26,21,18,16,14,13,14,17,18,15,12,12,13,15,16,14,8,4,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.07,1.10,1.11,1.11,1.07,1.13,1.32,1.73,1.75,1.83,1.87,2,2,2,2,2,2,2,2,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,4,5,6,8,12,14.85,16.53,17.25,17.08,16.89,17.28,18.64,21.12,24.37,27.87,30.95,33.24,34.50,34.63,33.75,32.16,30.26,28.27,26.36,24.72,23.54,23.01,23.24,24.16,25.72,27.73,30,32.45,34.64,34.59,33.59,32.92,33,32,27,23,20,22,23,22,23,24,24,24,25,23,20,16,15,16,17,17,18,20,22,24,27,29,29,30,31,32,33,35,38,42,45,48,47,43,38,32,27,24,25,27,31,38,46,53,56,56,51,46,41,37,30,23,17,13,11,9,8,7,6,5,4,3,3,3,3,3,3,4,5,6,7,7,6,6,6,7,8,9,9,10,11,12,13,13,13,12,12,12,12,12,12,12,13,18,24,31,37,41,44,43,39,35,33,-15,-14,-14,-13,-12,-11,-10,-9.63,-8.40,-7.05,-5.50,-3.68,-1.40,1.62,5.65,10.72,16.25,21.98,26.84,34.50,41.34,45,46,45,45,45,46,47,50,54,57,59,57,50,43,38,36,36,35,33,31,29,24,19,16,15,15,16,20,22,18,14,13,15,16,18,16,10,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1.12,1.24,1.21,1.13,1.09,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,4,4,5,6,8,11,13.04,14.45,15.15,15.39,15.87,16.82,18.47,20.96,24.09,27.61,30.89,33.58,35.25,35.73,35.03,33.58,31.72,29.64,27.65,25.91,24.63,23.99,24.07,24.84,26.22,28,30.10,32.09,33.75,33.03,31.88,31.20,31,31,26,22,20,20,20,20,20,19,20,21,22,22,19,16,16,17,18,18,20,22,24,27,30,31,32,32,33,35,37,38,42,46,49,52,51,46,40,34,30,27,28,31,37,44,53,57,58,57,54,48,44,39,31,24,18,14,12,10,8,7,6,5,4,3,3,3,3,3,3,4,6,7,7,7,7,7,7,7,8,8,9,10,11,12,14,14,13,13,12,12,12,12,12,12,13,17,24,31,36,39,40,38,32,29,26,-14,-14,-13,-13,-12,-11,-10,-9.47,-8.34,-7.04,-5.62,-3.91,-1.91,0.76,4.47,9.20,14.53,19.78,25.85,33.26,39.58,42,42,42,42,43,44,46,49,52,56,58,56,50,44,40,39,38,37,36,35,33,28,22,18,17,17,19,24,25,21,17,15,16,18,19,17,11,7,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,5,5,6,8,10,11.98,12.67,13.62,14.37,15.32,16.54,18.40,21.04,24.24,27.84,31.40,34.52,36.59,37.25,36.62,35.23,33.20,31.02,28.92,27.04,25.63,24.82,24.66,25.23,26.38,28,29.98,31.67,32.10,31.04,29.54,28.33,29,28,26,22,20,19,19,18,18,18,18,18,19,20,18,17,17,18,19,20,21,24,26,28,31,33,35,35,37,39,41,42,45,49,53,55,54,49,43,36,31,30,32,36,43,53,58,61,61,59,55,50,46,41,33,25,19,15,12,10,9,8,7,5,4,3,3,3,3,3,4,5,7,8,8,7,7,7,7,7,7,8,8,9,10,11,13,14,14,13,13,13,13,13,12,12,13,16,22,28,33,36,37,33,27,24,23,-14,-14,-13,-12,-12,-11,-10,-9.26,-8.17,-6.99,-5.62,-4.02,-2.13,0.39,3.84,8.26,13.58,19.70,26.70,34.50,38.70,40,40,40,41,41,42,44,46,49,52,53,55,50,47,43,42,42,41,40,40,38,31,25,21,19,19,23,28,28,25,20,16,16,18,19,18,13,10,5,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,5,6,7,8,9,10,11.01,12.34,14.42,15.67,16.90,18.67,21.11,24.35,28.20,32.25,35.95,38.61,39.35,38.83,36.99,34.76,32.45,30.20,28.12,26.50,25.45,25.03,25.32,26.21,27.62,29.25,30.73,29.76,28.41,26.76,25,24,24,24,23,20,19,18,17,17,17,17,17,17,18,19,18,19,19,20,22,24,26,28,29,31,34,37,38,40,42,44,45,47,51,56,58,57,51,45,38,34,33,35,41,49,58,62,64,63,60,54,48,44,39,32,25,19,15,13,11,9,8,7,5,4,3,3,3,3,3,5,6,8,9,8,8,7,7,7,7,7,7,8,9,10,11,12,13,14,14,13,13,13,13,13,13,13,15,18,24,29,32,31,28,23,22,25,-14,-13,-13,-12,-11,-10,-10,-9.11,-8.03,-6.88,-5.60,-4.09,-2.23,0.21,3.50,7.86,13.32,19.77,27.15,35.52,38.85,39,39,39,39,40,40,41,43,45,47,50,55,54,51,46,45,45,45,44,44,41,33,26,23,22,21,25,30,32,28,22,18,18,19,20,19,15,12,6,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,6,8,8,9,10,11,12,14,15.16,17.37,18.52,19.62,20.67,24.37,28.72,33.03,37.58,41.71,42.37,40.89,38.83,36.38,33.89,31.46,29.20,27.28,25.91,25.20,25.12,25.62,26.60,27.67,28.01,27.26,25.72,23.77,21.70,21,21,23,23,21,18,17,17,16,16,16,16,16,18,19,19,19,20,22,24,27,29,31,32,35,37,39,41,44,46,47,48,50,53,58,61,59,54,47,41,36,36,40,46,55,63,66,66,64,59,51,45,40,35,30,25,20,17,14,11,9,8,7,5,4,3,3,3,3,4,5,7,9,10,9,8,7,7,7,7,7,7,8,9,9,10,12,14,15,15,14,14,13,13,13,13,14,15,16,20,24,26,25,23,21,25,28,-14,-13,-12,-12,-11,-10,-9.87,-8.89,-7.88,-6.77,-5.52,-4.09,-2.28,0.07,3.25,7.52,13.02,19.59,26.97,34.71,39,39,39,38,38,38,39,39,40,42,44,48,53,56,53,49,48,47,48,48,47,43,35,28,26,26,24,26,31,35,31,25,20,20,22,22,22,19,15,9,5,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,4,5,6,6,6,6,6,5,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,5,7,9,10,10,11,13,14,16,18,21,22,22,23,25.58,29,33.53,38.47,43.54,44,42.72,40.59,38.04,35.41,32.77,30.26,28.04,26.33,25.17,24.64,24.66,25.02,25.47,25.37,24.50,23.07,21.15,19.26,18,19,21,20,19,18,17,16,16,16,16,16,16,17,18,19,20,22,24,28,30,32,34,37,40,43,43,45,46,48,49,52,54,57,61,64,63,57,50,43,38,38,42,50,60,67,68,67,64,56,50,46,44,39,34,28,23,19,15,12,10,8,7,5,4,3,3,3,4,5,5,7,9,10,9,8,7,7,7,7,7,8,8,8,9,10,12,14,15,16,15,14,14,14,14,14,14,14,15,16,19,20,20,19,22,27,30,-13,-13,-12,-11,-11,-10,-9.62,-8.68,-7.74,-6.65,-5.49,-4.11,-2.42,-0.28,2.73,6.90,12.41,18.87,25.84,33,38,39,38,37,37,37,38,40,41,42,44,47,52,56,55,52,50,50,51,51,49,43,35,29,30,31,27,27,32,34,31,26,22,22,23,25,24,23,18,12,7,5,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,4,5,7,8,8,8,8,7,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,7,11,12,12,13,15,17,19,23,27,29,28,28,29.41,30.86,33.17,39.16,42.85,44.78,44.14,42.25,39.74,37.01,34.17,31.39,28.83,26.64,25.01,23.99,23.50,23.34,23.21,22.83,22.03,20.83,19.15,17.66,17,18,19,19,17,17,16,16,16,16,16,16,16,17,18,20,22,24,27,30,33,35,39,42,46,48,48,48,49,50,52,55,58,61,64,67,65,59,52,45,40,41,45,54,63,68,69,67,62,55,50,52,51,46,38,31,26,21,17,13,10,8,7,5,4,3,3,4,5,5,6,7,8,9,9,8,8,7,7,8,8,8,8,8,9,10,11,12,14,15,16,15,14,14,14,14,14,14,15,16,16,17,17,19,23,28,30,-13,-13,-12,-11,-10,-10,-9.36,-8.48,-7.51,-6.50,-5.36,-4.01,-2.47,-0.42,2.38,6.37,11.62,17.72,24.12,30,36,37,36,36,37,37,39,41,43,45,48,49,52,56,57,56,54,54,54,54,50,42,35,31,34,35,29,28,32,33,29,26,25,25,25,27,29,27,20,14,10,5,4,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,2,2,2,3,3,3,4,5,7,9,10,9,8,8,7,6,6,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,5,6,8,12,14,14,15,17,19,22,27,32,35,35,34,34.20,34.63,37,40.28,44.11,45.65,45.50,43.90,41.51,38.74,35.70,32.59,29.62,26.97,24.82,23.25,22.24,21.65,21.25,20.75,20.01,19.03,17.77,16.85,17,17,18,18,17,16,16,16,16,16,16,16,17,18,19,21,24,27,30,34,36,39,43,48,52,53,52,51,52,54,56,59,62,66,68,69,68,62,55,47,43,43,49,57,65,68,69,67,61,55,53,56,56,50,42,35,28,24,19,15,11,9,7,5,4,3,4,5,6,6,6,7,8,9,9,8,8,8,8,8,8,8,8,8,9,10,10,11,13,14,15,15,15,15,15,15,15,16,16,16,17,17,18,20,23,27,29,-13,-12,-12,-11,-10,-9.92,-9.12,-8.24,-7.30,-6.34,-5.25,-4,-2.51,-0.63,1.98,5.48,10.47,16.33,22.25,27.49,31,33,34,36,37,39,41,44,47,50,53,54,53,55,57,59,59,59,58,57,51,43,37,34,37,39,33,30,32,33,30,30,29,28,28,31,32,30,24,19,13,8,5,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,4,5,6,7,8,8,7,6,5,5,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,6,8,10,10,10,9,8,8,8,8,8,7,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,6,7,9,13,15,16,17,19,21,25,32,37,39,41,41,41,41.28,42.41,44.48,46.21,47.27,47.12,45.79,43.53,40.61,37.26,33.77,30.39,27.28,24.63,22.57,21.12,20.22,19.64,19.12,18.51,17.79,16.90,16.37,16,16,17,17,16,16,16,16,16,16,17,17,18,19,20,23,26,30,33,37,40,43,48,52,56,57,55,54,56,57,60,63,66,68,70,71,68,62,56,49,45,46,51,60,66,68,68,66,63,58,55,57,58,53,46,39,33,26,21,16,12,9,7,6,4,4,4,5,6,7,7,7,8,8,8,8,8,8,8,8,8,8,8,9,9,10,11,11,13,14,15,16,16,17,17,17,17,17,18,18,18,18,18,21,23,26,28,-12,-12,-11,-11,-10,-9.64,-8.87,-8,-7.13,-6.18,-5.17,-4.03,-2.73,-1.05,1.24,4.75,9.62,15.40,21.25,25.87,29,32,35,37,39,42,44,48,51,54,57,58,57,57,60,62,63,64,63,59,53,45,38,37,41,44,38,34,34,34,34,35,35,32,32,35,37,34,29,23,18,11,6,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,7,8,10,12,13,13,11,9,8,7,6,5,4,4,4,3,3,3,3,3,3,3,3,3,4,4,5,7,9,10,11,11,11,12,12,13,14,14,12,8,7,6,6,5,5,5,5,5,5,5,5,5,5,6,7,8,11,14,17,18,19,21,24,29,36,41,44,46,47,48,47,47.58,48.25,48.79,49.37,49.16,48.01,45.77,42.64,38.85,34.86,31.03,27.53,24.48,22,20.25,19.15,18.50,18,17.51,17,16.39,16.02,16,16,16,16,16,16,16,16,16,16,17,18,19,21,22,26,30,34,37,41,45,49,52,56,60,60,59,59,60,61,63,66,68,69,71,72,67,61,56,50,46,47,52,60,66,68,68,66,65,62,58,59,61,57,51,44,37,30,24,18,13,10,8,6,4,4,5,6,7,7,7,7,8,8,8,8,8,8,8,8,8,9,9,9,10,10,11,12,13,15,16,17,17,18,19,19,19,19,20,19,19,19,19,22,23,25,27,-12,-12,-11,-10,-10,-9.39,-8.63,-7.79,-6.93,-6.04,-5.10,-4,-2.75,-1.14,1.14,4.59,9.34,15.07,21.13,27.03,33,36,38,40,42,45,49,52,54,57,59,60,61,62,63,65,67,69,67,62,54,46,41,42,47,51,47,40,37,39,41,41,39,36,35,38,39,36,33,27,20,13,7,5,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,9,12,11,14,17,17,16,15,13,10,9,7,6,5,4,4,4,3,3,3,3,3,3,3,4,4,5,6,8,10,12,13,13,14,16,16,18,18,18,16,12,10,8,7,6,5,5,5,5,5,5,5,6,6,7,8,9,12,15,17,18,20,22,26,32,39,45,48,51,53,53,52,50.98,50.85,51.21,51.70,51.37,50.16,47.74,44.34,40.10,35.64,31.40,27.58,24.23,21.53,19.66,18.50,17.79,17.32,16.89,16.51,16.03,16,16,16,16,16,16,16,16,16,16,17,18,19,21,23,26,29,34,39,44,48,53,57,58,61,62,63,63,63,64,65,66,68,69,69,70,70,65,59,54,50,48,49,54,61,67,69,68,67,67,65,62,61,64,62,56,49,41,34,28,21,14,11,8,6,5,4,5,6,6,6,6,6,7,8,8,8,8,8,8,8,8,9,9,10,10,11,12,13,14,16,17,17,18,20,21,22,22,22,22,22,21,20,21,22,23,25,26,-12,-11,-11,-10,-9.88,-9.16,-8.41,-7.63,-6.79,-5.92,-5,-3.98,-2.75,-1.16,1.12,4.47,9.08,14.86,21.52,29,36,39,40,43,46,49,53,55,57,58,60,62,63,64,63,64,66,68,69,64,57,50,47,50,52,56,53,45,43,44,47,46,43,41,40,40,41,39,35,29,23,15,10,6,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,8,14,16,14,17,19,19,18,16,14,12,10,8,7,6,5,5,4,4,3,3,3,3,3,4,4,5,6,7,9,12,14,16,16,17,19,20,20,20,21,21,17,13,9,7,6,6,6,6,6,6,6,6,7,8,9,10,11,12,14,16,17,20,23,28,34,43,48,53,56,57,57,56,53,52,53.39,53.75,53.24,51.36,48.85,45.26,40.67,35.95,31.35,27.25,23.75,21.03,19.17,18.03,17.34,16.87,16.51,16.24,16,16,16,16,16,16,16,16,16,16,16,17,19,20,22,25,28,33,38,45,51,56,60,63,64,66,67,67,67,67,68,68,69,69,68,67,68,68,62,56,51,49,50,52,58,64,69,71,70,70,69,67,65,65,67,67,61,53,45,38,31,25,16,11,9,7,6,5,4,4,5,5,5,5,6,7,8,8,8,9,8,8,8,9,9,10,11,12,13,13,14,16,17,18,19,20,22,23,23,24,24,24,23,22,22,23,23,25,26,-11,-11,-10,-10,-9.66,-8.99,-8.25,-7.50,-6.67,-5.86,-4.93,-3.93,-2.75,-1.17,1,4,8.37,14.25,21.50,29.91,36.85,41,44,46,49,52,54,55,56,59,62,64,65,61,59,59,61,64,66,65,61,56,54,57,60,60,56,51,49,49,51,51,48,47,47,46,45,43,38,32,24,18,13,9,5,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,6,12,17,19,17,19,22,22,20,17,14,12,10,9,8,7,6,5,5,4,4,4,4,4,4,4,5,7,8,10,14,15,18,19,19,19,20,22,22,22,24,23,18,13,10,8,7,6,6,6,6,6,6,6,7,9,11,12,12,12,14,15,17,20,24,29,36,43,50,55,57,58,58,57,55,54,54.82,54.38,52.03,50.72,48.84,44.87,40.38,35.52,30.74,26.49,22.92,20.35,18.64,17.62,16.98,16.54,16.26,16.10,16,16,16,16,16,16,16,16,16,16,16,18,19,21,24,27,32,37,43,50,57,64,68,69,70,71,73,72,71,72,71,71,71,70,67,67,67,64,59,53,50,49,50,54,61,68,72,73,72,73,73,71,69,68,69,69,64,57,49,41,34,27,19,14,11,8,7,5,4,4,4,4,4,5,6,7,8,8,8,8,8,8,8,9,9,10,11,13,14,14,14,16,17,18,20,21,22,23,25,26,26,27,25,24,24,24,25,26,27,-11,-11,-10,-10,-9.52,-8.87,-8.13,-7.38,-6.61,-5.78,-4.92,-4,-2.86,-1.39,0.53,3.36,7.25,12.47,19.66,28.50,37.65,43,47,51,53,53,52,54,55,59,62,65,63,57,54,54,57,61,64,65,64,61,60,62,64,63,59,55,55,55,55,55,54,53,53,53,50,46,41,33,26,20,15,9,5,4,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,9,15,19,21,20,22,23,24,22,19,16,13,11,9,8,7,6,6,5,5,4,4,4,4,4,5,6,9,11,14,17,18,19,20,20,21,22,23,23,24,24,22,16,12,9,8,7,6,6,6,6,6,6,7,8,10,12,12,12,13,14,15,17,20,24,29,36,44,51,55,57,57,57,56,54,54,53,51.20,49.37,47.54,45.75,43.22,39.21,34.52,29.62,25.12,21.52,19.28,17.96,17.20,16.65,16.29,16.12,16,16,16,16,16,16,16,16,16,16,16,17,18,20,22,26,29,35,41,48,56,63,69,73,72,73,75,77,76,75,75,74,73,71,69,67,66,64,60,56,52,50,50,52,56,63,70,74,75,75,75,75,73,71,69,69,70,67,60,52,44,36,28,20,16,12,9,7,6,5,4,4,4,4,4,5,6,7,7,7,7,7,8,8,9,9,10,11,13,14,15,15,16,18,19,20,22,23,24,26,27,28,29,28,27,26,26,27,28,28,-11,-11,-10,-10,-9.47,-8.78,-8.10,-7.36,-6.59,-5.76,-4.91,-4,-2.91,-1.60,0.12,2.36,5.26,8.82,14.66,23.25,34.28,42,48,52,52,51,51,52,56,58,60,61,57,50,49,49,54,58,61,63,64,66,67,67,67,65,61,59,60,61,60,59,59,60,60,58,56,50,43,35,29,22,15,9,6,5,4,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,11,17,21,23,24,25,26,26,24,21,18,14,12,10,9,8,7,6,6,5,5,4,4,4,4,5,7,10,14,18,19,19,19,20,21,22,23,24,24,24,22,19,14,11,9,8,7,7,7,7,7,7,7,7,8,10,12,13,13,13,14,15,17,20,24,29,35,43,50,54,55,57,56,55,54,52,51,48.98,45.39,43.72,41.82,39.86,36.88,32.85,28.17,23.41,20.24,18.28,17.40,16.87,16.45,16.12,16.01,16,16,16,16,16,16,16,16,16,16,16,18,19,21,24,28,33,38,44,52,61,69,73,74,76,75,77,79,78,77,76,74,71,69,69,68,66,62,56,53,50,50,51,53,57,64,70,75,77,78,77,74,73,71,70,70,71,68,61,52,44,36,28,21,17,13,10,8,6,5,4,4,4,4,4,5,6,6,6,6,6,7,8,8,9,10,10,12,13,15,16,17,17,18,20,21,23,24,25,27,29,31,31,29,28,28,28,28,29,30,-11,-11,-10,-10,-9.43,-8.78,-8.10,-7.36,-6.60,-5.78,-4.97,-4.05,-3.10,-1.92,-0.55,1.07,2.75,4.64,3.85,15.61,24.72,36.84,43,47,49,48,49,51,55,55,52,50,47,44,42,47,51,54,58,62,65,69,70,69,67,66,63,63,63,65,65,63,63,64,64,61,59,54,45,37,30,22,15,9,7,5,4,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,7,12,18,23,26,27,28,29,28,27,24,20,16,13,11,10,9,8,7,7,6,5,5,5,4,4,5,7,9,14,17,19,19,19,20,21,22,23,23,23,22,21,17,14,11,10,8,8,7,7,7,7,7,7,8,9,11,12,14,14,14,14,15,17,20,24,30,37,44,49,51,53,55,57,56,54,50,48,45,43.98,40.34,36.61,35.66,33.49,30.92,26.37,22.26,19.07,17.62,17.08,16.70,16.34,16.01,16,16,16,16,16,16,16,16,16,16,16,17,18,20,22,26,30,36,43,49,56,65,72,74,75,77,78,77,77,77,77,75,72,70,69,69,68,64,59,54,51,50,50,51,53,58,64,70,74,77,78,76,74,72,71,69,71,71,69,62,53,45,38,30,22,17,14,11,9,6,5,4,4,4,4,4,4,5,6,5,6,6,7,8,9,9,10,11,12,14,16,18,18,19,20,21,23,24,26,27,28,30,31,32,31,30,30,30,30,30,31,-11,-11,-10,-10,-9.50,-8.85,-8.13,-7.38,-6.63,-5.84,-5.01,-4.18,-3.34,-2.38,-1.38,-0.26,0.75,1.75,3.86,3.47,16.87,25.34,34,39,44,46,47,48,49,47,42,39,37,37,41,48,54,57,61,64,67,70,71,69,67,66,65,65,66,67,68,67,66,66,63,58,57,55,48,36,28,22,15,10,7,6,5,4,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,7,11,16,21,25,29,30,32,33,32,30,27,23,19,15,12,11,10,9,9,9,8,6,6,5,5,5,5,6,9,12,16,19,19,19,20,21,21,22,23,23,23,21,19,16,13,10,9,8,8,8,8,8,8,8,9,10,11,13,15,15,15,15,16,17,20,24,30,37,44,48,50,52,55,57,56,51,47,44,43,41,39,34.82,31.39,29.37,27.34,24.27,20.72,18.65,17.40,17.01,16.82,16,16,16,16,16,16,16,16,16,16,16,16,16,17,18,21,24,28,32,39,47,55,60,68,74,74,76,78,77,76,74,74,74,72,70,68,69,69,66,60,55,52,50,49,49,51,55,60,66,71,73,75,76,76,75,73,71,70,72,73,71,65,57,50,41,32,24,20,16,12,9,7,5,4,4,4,4,4,4,4,5,5,6,6,7,8,9,10,11,12,13,14,17,19,20,21,22,23,25,27,28,29,30,32,33,33,32,32,32,32,32,32,32,-11,-11,-10,-10,-9.59,-8.91,-8.23,-7.49,-6.72,-5.91,-5.13,-4.37,-3.59,-2.79,-2.01,-1.25,-0.50,0.53,1.71,4.07,10.10,17.75,23,31,40,44,45,43,40,38,35,30,29,36,45,52,58,62,64,65,67,69,70,68,67,67,67,68,68,70,71,71,69,66,58,53,52,51,45,37,29,21,15,10,8,7,6,5,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,10,16,21,25,28,31,34,37,38,36,34,30,26,22,17,14,12,11,11,11,12,11,8,6,6,5,5,5,6,8,11,16,20,20,20,21,21,22,22,23,24,24,23,21,18,14,11,9,8,8,8,8,8,8,9,9,10,12,14,15,16,16,16,16,18,20,24,30,36,42,46,49,53,56,55,52,47,43,41,40,39,36,33,27,25,23,22,20,18,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,17,19,21,26,30,35,43,51,60,66,70,74,74,76,77,76,74,71,71,71,70,68,68,69,68,62,56,52,50,48,48,49,52,55,60,66,71,75,76,77,77,77,75,73,73,75,75,72,67,60,52,43,35,28,24,19,14,10,7,5,4,4,4,4,4,4,4,4,5,6,7,7,8,9,11,12,13,14,16,18,20,21,23,24,25,27,30,31,32,33,34,35,35,34,33,34,34,34,34,35,-11,-11,-10,-10,-9.68,-9.03,-8.36,-7.62,-6.85,-6.04,-5.27,-4.53,-3.85,-3.16,-2.52,-1.88,-1.22,-0.27,0.91,3.64,7.66,13.37,20.27,28.98,35,40,41,38,34,31,28,25,27,36,49,56,61,62,63,64,64,64,65,66,66,67,70,71,72,73,74,73,69,62,54,48,45,45,41,35,28,21,15,11,9,8,7,6,5,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,6,12,18,23,27,30,33,37,41,41,39,36,32,28,24,20,16,14,13,13,13,13,12,9,7,6,5,5,6,6,8,11,16,20,21,22,22,23,23,23,24,25,26,25,23,19,14,12,10,9,8,8,9,9,9,9,10,11,12,15,17,17,16,16,17,18,20,25,31,35,39,45,50,55,56,53,47,43,39,38,38,37,34,30,26,22,21,20,18,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,17,19,23,29,34,39,46,54,63,69,72,74,73,74,74,73,72,68,67,67,67,66,67,67,65,58,51,48,47,46,47,50,52,55,58,65,71,75,78,79,80,80,79,77,76,77,77,74,68,61,53,45,38,32,29,23,17,12,8,5,4,4,4,4,4,4,4,4,5,6,7,7,8,10,11,12,14,15,17,19,21,23,25,26,27,29,31,33,35,35,36,37,37,36,35,36,36,36,37,37,-11,-11,-10,-10,-9.86,-9.23,-8.51,-7.76,-7,-6.23,-5.48,-4.75,-4.10,-3.49,-2.89,-2.30,-1.67,-0.93,0.45,2.66,6,10.26,17.13,22.74,29,32,35,32,27,25,22,21,26,34,49,56,57,60,61,59,56,55,58,62,64,66,70,73,75,76,77,74,67,59,50,44,39,38,36,32,27,20,14,11,10,9,8,6,5,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,8,14,20,25,29,32,35,39,43,44,41,38,34,30,28,25,21,19,17,15,14,13,11,9,7,6,6,6,6,7,8,11,16,22,23,24,25,25,24,24,25,27,28,28,25,21,15,12,10,9,9,9,9,9,10,10,10,11,13,16,17,16,16,16,17,19,21,25,29,33,39,45,51,56,56,52,46,40,37,36,36,36,33,28,24,21,19,18,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,17,18,20,24,32,39,46,52,60,65,70,73,73,72,71,70,70,69,65,62,62,62,63,65,65,60,54,48,45,44,44,47,50,53,55,58,63,69,74,78,81,82,82,81,78,76,76,77,74,69,61,53,46,40,37,32,25,19,13,8,5,4,4,4,4,4,4,4,4,5,6,7,8,9,10,11,13,15,16,18,21,24,25,27,28,29,31,33,35,36,38,38,39,39,38,38,38,38,39,40,40,-11,-11,-11,-10,-10,-9.42,-8.75,-8,-7.22,-6.41,-5.65,-4.93,-4.29,-3.73,-3.16,-2.63,-2.11,-1.28,-0.10,1.64,4.02,6.85,9.91,14.57,19.84,23,25,23,18,17,18,23,28,35,46,52,52,55,56,53,49,49,54,57,58,60,65,69,72,75,76,72,65,57,49,42,37,33,31,29,24,19,14,12,11,10,9,7,5,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,7,12,17,22,28,32,35,37,40,44,44,42,39,37,34,32,29,26,23,20,18,15,12,10,9,7,6,6,6,7,8,9,12,18,24,25,25,26,25,25,26,27,28,30,29,26,22,15,12,10,9,9,9,9,10,10,10,11,12,14,16,16,16,16,17,18,19,22,26,29,34,39,46,53,56,55,50,45,39,36,35,34,33,30,26,21,19,18,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,17,19,21,26,34,42,49,58,65,69,72,74,72,70,69,69,69,67,61,58,58,59,61,62,61,56,50,46,42,42,44,47,50,52,54,57,62,67,72,76,80,83,83,80,76,74,74,73,70,65,59,51,46,42,39,33,26,20,14,8,5,4,4,4,4,4,4,4,4,5,6,7,8,9,10,11,13,15,17,19,22,25,27,29,30,32,33,35,37,38,40,41,41,41,41,40,40,41,42,43,44,-12,-11,-11,-10,-10,-9.75,-9.01,-8.25,-7.43,-6.63,-5.86,-5.13,-4.48,-3.90,-3.39,-2.90,-2.35,-1.63,-0.66,0.60,2.12,3.58,3.50,2.50,12.65,16.98,17,16,13,17,22,27,34,38,44,46,46,49,50,47,44,45,48,50,51,53,58,62,66,68,69,67,62,58,50,43,37,33,29,24,21,18,15,14,12,12,11,8,6,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,7,13,19,26,31,35,38,39,41,45,45,43,42,40,38,34,32,28,25,22,20,16,12,10,9,7,7,6,6,7,9,12,15,21,25,26,26,26,26,26,27,28,29,30,29,25,20,15,12,10,10,9,9,10,10,10,11,12,13,15,16,16,16,17,17,18,20,23,27,32,36,41,47,54,57,54,48,43,38,36,35,33,31,26,22,19,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,16,17,19,22,26,35,44,53,61,70,75,75,75,73,69,67,67,67,63,57,54,54,55,57,60,56,50,44,42,40,42,45,48,51,52,54,56,60,65,69,74,79,82,81,77,74,73,73,70,66,61,55,49,45,44,41,34,26,20,13,8,5,4,4,4,4,4,4,4,4,5,6,7,8,9,10,12,13,15,17,20,23,27,29,31,34,35,36,37,39,41,43,45,45,44,43,43,43,44,45,47,49,-12,-12,-11,-11,-10,-10,-9.39,-8.62,-7.78,-6.97,-6.14,-5.39,-4.74,-4.13,-3.63,-3.13,-2.62,-2,-1.26,-0.38,0.48,1.37,1.90,3.15,8.57,13.46,12,9,11,18,27,34,38,42,43,41,40,42,43,41,39,40,41,43,45,48,52,58,61,61,63,61,58,56,50,44,39,35,32,26,23,21,19,17,16,15,13,9,6,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,6,12,19,26,33,38,41,42,43,46,47,46,44,42,39,36,32,28,24,22,20,16,12,10,9,8,7,7,7,8,11,14,19,23,27,27,27,27,27,27,28,28,29,30,27,23,19,15,12,11,10,10,10,10,10,11,11,12,13,15,17,16,17,17,18,19,21,23,28,34,39,43,50,56,56,51,46,41,37,36,36,33,27,23,19,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,17,18,20,23,27,34,45,55,64,73,78,77,75,72,68,66,66,64,59,53,51,51,52,55,57,52,45,40,38,39,42,45,49,51,52,54,56,59,63,67,71,75,78,78,75,73,73,72,68,63,58,52,47,44,44,42,33,25,18,12,8,5,4,4,4,4,4,4,4,5,5,6,7,8,10,11,13,14,16,18,21,25,27,30,34,37,38,39,39,41,43,45,48,48,46,45,46,46,46,49,52,54,-12,-12,-12,-11,-11,-10,-9.86,-9.03,-8.22,-7.37,-6.51,-5.74,-5.01,-4.39,-3.88,-3.38,-2.89,-2.38,-1.79,-1.17,-0.53,0.27,1.20,3.10,6.12,8.75,9.48,9,12,19,29,34,37,39,38,36,36,37,37,36,36,37,38,40,43,46,50,56,57,55,56,55,53,52,51,48,44,40,38,31,28,26,25,23,22,18,13,8,5,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,7,11,18,25,32,39,44,45,46,46,47,46,43,41,38,35,31,27,23,20,18,15,12,10,9,8,7,7,8,10,14,17,22,27,29,29,28,28,28,29,28,29,30,29,26,23,20,15,12,11,10,10,10,10,11,11,12,12,14,15,17,17,17,18,18,20,22,25,28,33,39,45,52,57,55,49,43,40,37,36,35,31,25,20,19,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,17,18,20,23,28,35,45,55,65,74,79,78,74,70,67,65,64,61,55,51,48,47,50,53,52,47,41,36,35,37,40,45,48,50,52,56,58,59,62,64,67,70,74,75,73,73,73,72,69,64,57,51,46,43,43,40,32,24,17,12,7,5,4,4,4,4,4,4,4,5,6,6,7,9,10,12,13,15,16,19,22,25,28,32,36,39,41,41,41,42,45,47,49,49,48,47,48,49,50,54,58,58,-13,-13,-12,-12,-11,-11,-10,-9.51,-8.65,-7.79,-6.92,-6.13,-5.38,-4.72,-4.14,-3.65,-3.22,-2.75,-2.25,-1.75,-1.15,-0.38,0.65,2.24,4.47,6.66,8.98,10.71,14,20,25,29,31,33,33,32,32,32,32,33,34,36,39,41,44,47,52,55,52,50,49,48,47,46,49,50,50,47,42,36,33,31,30,28,26,20,14,8,6,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,5,7,12,17,24,33,40,47,48,47,47,46,43,41,38,36,32,28,25,22,19,16,13,11,10,8,8,8,8,9,12,16,20,25,28,30,30,28,28,29,30,29,29,30,29,26,24,20,16,12,11,10,10,10,11,11,11,12,13,14,15,16,17,17,18,19,21,23,26,29,35,41,47,54,58,54,48,42,38,36,35,33,28,22,19,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,17,18,21,24,28,35,45,55,65,74,78,74,70,67,65,64,62,58,53,49,46,45,48,51,50,44,38,34,34,36,39,43,46,49,53,57,58,59,61,64,66,69,72,75,74,74,74,73,70,64,57,50,45,42,41,39,30,23,17,12,8,6,5,4,4,4,4,4,4,4,5,6,7,9,10,12,13,15,17,19,22,26,30,34,39,42,43,42,42,44,46,48,49,50,49,49,50,52,55,59,59,59,-13,-13,-13,-12,-12,-11,-10,-10,-9.14,-8.26,-7.38,-6.53,-5.75,-5.09,-4.50,-4,-3.52,-3.11,-2.65,-2.16,-1.62,-0.93,0.14,1.50,3.26,5.37,7.62,10.28,13.16,17,21,24,26,28,29,30,31,31,32,33,35,37,39,41,44,47,51,52,51,46,43,42,41,42,45,47,49,48,45,42,38,36,32,29,26,20,14,9,6,5,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,5,6,8,11,17,25,33,41,47,49,49,48,45,42,39,37,34,29,24,22,20,17,15,12,11,9,8,8,8,8,10,12,16,20,25,29,31,30,28,28,30,30,30,30,30,29,27,25,22,17,13,11,11,10,11,11,11,11,12,13,14,15,16,17,18,19,20,22,24,28,32,38,43,49,56,58,53,47,41,38,36,33,29,24,20,19,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,17,18,21,24,28,35,46,56,66,74,75,71,66,64,63,62,58,54,50,46,44,43,47,48,46,41,35,32,33,35,38,41,45,49,54,57,57,58,60,64,68,71,73,75,75,75,75,74,70,62,56,50,45,41,39,37,29,22,16,12,9,7,5,4,4,4,4,4,4,4,5,7,8,9,10,11,13,14,17,20,23,26,31,36,40,42,43,42,42,44,46,47,47,49,51,51,52,54,57,59,59,58,-14,-14,-13,-13,-12,-12,-11,-10,-9.65,-8.75,-7.87,-7,-6.16,-5.47,-4.85,-4.30,-3.88,-3.47,-3.01,-2.53,-2.01,-1.30,-0.36,0.83,2.26,4.02,6.25,9,12.50,16.02,18,20,22,24,27,30,33,34,33,33,34,35,35,35,38,43,46,50,50,44,39,36,36,37,40,41,44,43,45,46,44,40,32,26,21,17,12,9,7,5,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,4,5,6,7,9,12,18,25,34,42,47,49,48,47,44,41,38,36,33,28,22,18,16,15,13,12,10,9,8,8,8,9,10,13,16,20,25,30,31,30,27,28,29,30,31,31,30,30,28,26,22,17,13,12,11,11,11,11,11,12,13,14,15,16,18,19,20,20,22,23,26,30,35,41,47,54,58,59,53,47,41,39,36,33,26,22,20,19,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,16,17,18,21,23,27,35,47,57,66,72,71,67,62,61,61,60,54,50,46,42,41,41,44,43,40,38,33,31,32,34,37,40,43,48,53,55,55,56,60,64,68,71,73,75,75,75,75,74,68,61,55,49,45,40,39,36,29,21,15,12,9,7,5,4,4,4,4,4,4,4,5,7,8,8,9,10,12,14,17,20,23,26,31,36,39,40,40,40,41,43,44,44,46,48,51,52,53,56,58,58,57,56,-14,-14,-14,-13,-13,-12,-11,-10,-10,-9.25,-8.36,-7.50,-6.66,-5.92,-5.28,-4.75,-4.26,-3.85,-3.38,-2.91,-2.39,-1.74,-0.88,0.12,1.28,2.74,4.64,7.16,11.12,16.37,18.98,20,21,21,24,29,33,32,29,30,29,30,29,31,35,38,42,47,48,43,37,34,32,33,35,37,38,38,42,45,46,40,32,26,21,17,14,11,8,6,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,4,4,5,6,7,9,11,15,20,29,37,43,46,47,47,46,43,40,37,35,32,27,22,17,15,14,12,11,10,9,9,9,9,10,12,16,20,24,28,31,31,28,26,26,27,29,30,30,30,29,27,25,21,16,13,12,12,12,12,12,12,12,13,15,17,19,21,22,23,22,23,25,28,33,39,45,52,59,62,59,53,47,42,39,37,32,26,22,20,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,16,17,17,18,20,23,26,35,46,56,64,67,67,63,58,58,58,57,52,48,44,40,38,38,40,38,36,34,32,30,31,34,36,39,42,46,51,53,53,54,59,63,66,68,68,70,71,73,73,72,67,60,54,49,44,41,39,38,32,22,15,12,9,7,5,4,4,4,4,4,4,5,5,6,7,8,9,11,12,14,17,20,22,26,30,34,36,37,37,38,40,41,42,44,46,48,50,53,54,55,56,56,55,55,-14,-14,-14,-14,-13,-12,-12,-11,-10,-9.68,-8.84,-7.98,-7.15,-6.41,-5.76,-5.18,-4.68,-4.25,-3.77,-3.30,-2.78,-2.16,-1.42,-0.62,0.37,1.48,3.03,4.86,8.21,11.62,15.57,18,19,19,22,25,26,25,23,24,24,25,26,30,33,36,40,45,45,40,36,32,30,29,31,33,33,34,37,41,42,40,33,27,25,22,20,16,10,6,4,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,6,6,7,8,9,11,14,18,25,33,40,45,47,47,46,45,42,38,36,33,30,25,20,16,14,13,12,10,10,9,9,10,11,13,17,21,25,28,30,32,31,27,25,24,24,25,26,27,28,27,24,22,18,15,14,13,12,12,12,12,13,13,14,16,19,21,23,25,25,24,25,28,31,35,42,49,56,63,64,58,52,46,42,39,36,30,25,21,19,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,17,17,17,18,20,22,26,33,44,51,57,61,62,59,54,54,54,52,50,46,42,39,36,34,34,33,32,30,30,30,31,33,35,37,39,43,48,50,51,53,57,61,62,62,62,64,66,68,70,70,66,59,53,49,45,42,41,39,34,23,16,11,9,6,5,4,4,4,4,4,4,5,6,7,8,9,10,12,13,15,17,19,22,25,29,31,32,33,35,37,38,39,41,43,46,48,50,52,53,54,55,55,54,53,-14,-14,-14,-14,-13,-13,-12,-11,-10,-10,-9.25,-8.41,-7.63,-6.88,-6.23,-5.63,-5.13,-4.65,-4.22,-3.74,-3.23,-2.64,-2.02,-1.29,-0.51,0.37,1.58,3.01,5.08,7.12,8.89,11.86,12,14,16,17,18,18,19,20,22,24,28,31,36,39,41,43,41,38,34,31,28,27,28,29,29,31,34,37,39,39,37,34,32,29,25,19,11,6,5,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,9,8,8,8,10,12,14,18,23,30,38,45,48,49,48,46,44,40,37,34,31,25,21,17,15,13,12,11,10,10,10,10,11,13,16,21,25,29,30,32,32,30,27,24,23,22,22,23,24,24,23,21,19,16,14,14,13,13,13,13,14,14,15,16,19,22,24,26,27,26,26,28,30,33,38,45,52,60,67,67,59,51,46,42,39,33,28,22,20,19,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,17,17,17,18,18,20,22,25,32,40,45,51,56,57,55,50,50,50,49,47,44,41,38,35,33,31,31,30,29,28,29,30,32,33,35,37,40,45,47,48,51,55,57,56,55,56,57,60,63,66,66,63,57,52,49,46,44,44,43,36,25,17,13,9,6,5,4,4,4,4,4,5,6,7,9,9,10,11,12,14,15,17,18,20,23,26,28,29,32,34,35,36,38,40,43,46,49,51,51,52,53,54,54,53,52,-15,-14,-14,-14,-14,-13,-12,-12,-11,-10,-9.64,-8.86,-8.10,-7.38,-6.75,-6.14,-5.63,-5.13,-4.65,-4.16,-3.66,-3.13,-2.59,-1.97,-1.36,-0.62,0.33,1.33,2.51,3.24,2.53,1.47,8,9,11,13,15,17,19,22,25,27,31,35,38,41,42,42,39,36,33,30,27,26,26,27,27,30,33,36,38,39,42,44,41,36,29,21,13,8,6,5,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,5,9,12,10,10,10,12,15,17,22,28,35,42,48,50,50,49,48,45,41,37,34,29,23,18,15,14,12,11,11,10,10,10,11,13,17,21,25,29,30,32,32,31,28,26,24,22,20,19,20,21,21,20,18,16,15,14,14,14,14,14,15,15,16,17,20,23,26,29,30,29,27,28,30,33,37,42,48,56,64,70,69,61,51,46,41,37,31,25,22,20,19,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,16,16,17,17,17,17,18,19,20,22,25,30,36,41,46,50,52,49,46,46,47,47,45,43,40,37,35,33,31,30,29,28,28,27,28,29,31,32,34,37,42,43,43,47,50,50,49,49,50,52,55,58,60,59,57,54,51,49,48,47,48,47,38,27,19,14,10,7,5,4,4,4,4,4,6,7,8,9,10,10,12,13,14,15,16,17,19,21,23,25,28,31,33,34,36,38,41,43,47,49,51,50,50,51,52,53,52,51,-15,-15,-14,-14,-14,-13,-12,-12,-11,-10,-9.99,-9.24,-8.50,-7.85,-7.24,-6.65,-6.13,-5.63,-5.13,-4.63,-4.13,-3.63,-3.11,-2.53,-2.01,-1.41,-0.73,-0.10,0.61,0.75,1.07,1.75,3,5,9,16,20,22,23,25,28,31,34,37,36,36,39,39,38,37,33,29,25,24,24,26,29,31,33,34,37,40,45,47,43,37,30,21,14,10,8,6,3,2,1,1,1,1,0.99,0.99,0.99,1,1,1,1,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,6,9,12,14,13,12,13,16,19,21,25,31,40,46,50,52,52,51,49,46,41,37,32,26,21,16,14,13,12,11,11,11,11,12,13,16,21,27,30,31,31,31,31,30,28,26,25,23,21,19,19,19,19,18,16,15,15,14,14,14,15,15,15,16,17,19,23,27,30,32,32,29,28,30,33,36,40,45,52,60,68,71,68,60,51,45,40,36,31,26,22,20,19,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,17,17,17,17,17,18,18,19,20,22,25,28,31,37,40,43,44,44,43,44,45,46,45,43,40,37,35,33,32,30,30,29,28,27,26,27,28,30,32,34,38,38,38,41,44,45,44,45,46,48,50,52,52,51,51,51,51,51,52,53,54,50,40,29,21,16,11,8,6,4,4,4,4,5,6,8,8,9,9,10,11,12,13,14,15,16,18,20,22,24,27,30,32,34,37,40,44,46,49,50,50,49,49,49,51,51,51,51,-15,-14,-14,-14,-14,-13,-13,-12,-11,-10,-10,-9.53,-8.88,-8.25,-7.66,-7.13,-6.63,-6.13,-5.62,-5.12,-4.61,-4.10,-3.55,-3.09,-2.60,-2.09,-1.51,-1.09,-0.59,-0.29,0.49,1.25,2,5,10,19,23,25,25,27,30,32,34,34,32,31,33,35,35,33,30,26,23,23,24,27,30,31,31,32,35,39,45,46,42,35,28,21,15,12,10,7,4,2,1,1,1,1,1,1.01,1.01,1.03,1.04,1.07,1.04,1.01,1,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,2,4,7,11,16,18,17,15,15,17,21,23,26,28,33,41,48,52,53,53,52,50,46,41,34,29,23,18,15,13,12,12,11,11,12,12,14,16,20,26,30,32,32,32,32,32,31,29,28,27,25,24,23,20,19,18,17,16,16,15,14,14,15,15,15,16,17,18,22,27,32,35,36,34,29,30,32,35,40,44,50,55,64,71,72,68,60,51,44,38,34,32,29,24,21,19,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,17,17,17,17,17,18,19,19,20,22,24,26,29,33,36,38,39,40,41,42,43,45,45,44,42,39,36,35,33,32,31,31,30,28,27,25,25,26,30,32,33,33,33,36,38,41,43,44,45,45,45,44,43,43,45,48,51,53,57,60,59,52,42,31,23,17,12,9,6,4,4,4,4,5,6,7,8,9,10,10,11,12,13,13,15,15,17,18,21,24,27,30,33,35,37,41,46,47,49,49,49,47,47,48,49,50,51,51,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-9.77,-9.15,-8.62,-8.11,-7.60,-7.11,-6.61,-6.10,-5.55,-5.02,-4.50,-3.99,-3.50,-3.02,-2.54,-2.13,-1.67,-1.18,-0.75,0.26,1.60,3,7,12,18,23,25,23,24,26,28,30,29,28,26,26,31,33,30,25,23,21,22,25,28,29,28,28,29,33,38,44,45,39,33,26,19,13,10,8,7,4,2,1,1.01,1.08,1.12,1.15,1.17,1.21,1.24,1.29,1.32,1.24,1.12,1.03,1,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,2,4,9,15,20,21,19,18,19,22,26,29,32,33,39,44,51,54,55,55,54,52,48,41,31,24,19,16,14,13,12,12,12,12,13,15,17,20,25,31,33,33,33,33,34,36,36,34,31,29,28,28,27,25,23,20,19,18,16,15,15,15,15,16,16,17,18,20,25,30,35,37,37,34,31,32,35,38,44,50,54,60,67,72,73,70,62,52,45,39,37,36,32,26,21,20,18,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,17,17,17,17,18,18,19,20,20,22,23,25,27,30,32,34,36,37,39,40,41,43,45,45,44,41,38,37,36,34,33,33,31,29,28,26,24,24,27,29,29,29,29,33,37,39,42,42,41,41,40,38,37,38,40,45,49,55,61,64,61,54,43,32,23,17,13,9,6,5,4,4,4,5,6,7,8,9,10,11,12,13,14,15,15,16,17,19,22,25,29,32,34,36,38,41,44,46,46,47,47,46,46,46,49,50,51,53,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-9.90,-9.38,-8.89,-8.43,-7.99,-7.50,-7.01,-6.50,-5.98,-5.40,-4.87,-4.35,-3.84,-3.36,-2.88,-2.48,-2.02,-1.50,-0.90,0.26,1.98,6,10,14,18,21,21,20,20,21,23,25,25,25,23,23,27,29,27,23,21,21,24,26,27,26,26,27,29,32,38,43,43,38,31,24,17,11,8,6,5,4,2,1,1.37,1.46,1.50,1.53,1.59,1.64,1.78,1.95,1.92,1.71,1.40,1.16,1.04,1,0.99,0.99,1,1,1,1,1,1,1,1,1,2,4,7,14,20,23,22,22,24,28,32,37,41,43,46,52,56,58,58,58,57,54,49,41,30,22,17,15,14,13,12,12,12,13,14,16,19,24,30,34,35,34,34,35,37,39,39,37,36,33,32,33,32,32,28,25,22,20,17,16,15,16,16,17,17,18,20,22,27,33,37,38,36,34,33,34,37,42,49,55,61,65,70,74,75,73,65,55,48,45,41,38,32,26,22,20,19,18,18,18,17,17,17,17,17,17,17,16,16,16,16,16,17,17,17,18,19,19,20,20,21,22,23,24,26,28,30,32,34,35,37,38,39,41,42,44,44,43,40,39,38,36,35,34,32,30,28,26,25,23,24,26,25,25,26,30,34,38,40,39,38,37,36,34,33,35,38,42,48,56,63,66,60,53,44,32,23,17,13,9,7,5,4,4,4,5,6,7,9,10,10,11,12,13,15,16,16,17,18,20,22,25,29,33,35,37,39,41,42,43,44,45,45,44,44,46,48,50,52,54,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-9.97,-9.50,-9.13,-8.73,-8.29,-7.88,-7.38,-6.88,-6.30,-5.75,-5.16,-4.61,-4.04,-3.53,-3.10,-2.63,-2.15,-1.68,-0.92,0.28,2.09,5,10,13,16,16,17,17,15,17,19,21,21,21,20,19,22,25,22,20,20,23,26,25,25,25,26,27,29,32,37,42,41,35,28,22,16,10,6,5,4,3,2,2.01,2.11,2.17,2.21,2.23,2.32,2.52,2.89,3.14,3.03,2.54,1.87,1.45,1.16,1.07,1.01,1,1,1,1,1,1,1,1,1,2,3,4,7,12,18,22,24,27,29,33,39,45,49,50,53,57,61,62,62,60,58,54,48,39,29,22,17,15,14,13,13,13,13,14,16,18,21,27,34,37,37,36,37,38,40,42,41,40,38,36,37,38,38,37,34,30,26,21,17,16,16,16,17,18,18,19,21,25,30,35,38,38,37,35,34,37,40,44,51,58,64,69,73,76,77,74,67,58,53,48,43,37,31,26,24,23,20,19,18,18,17,17,17,17,17,17,17,16,16,16,16,17,17,17,18,18,20,21,21,21,22,22,23,24,26,28,30,31,33,34,35,36,37,38,40,41,41,40,40,39,38,37,36,34,33,31,29,27,25,23,21,22,22,22,23,27,32,36,37,38,36,34,33,32,31,34,37,42,48,58,65,65,58,51,43,34,23,17,13,10,7,5,4,4,4,5,6,7,9,10,11,11,12,13,14,15,16,17,19,21,23,25,28,32,35,37,37,38,39,41,42,43,44,43,43,46,48,51,54,55,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-9.92,-9.61,-9.26,-8.91,-8.54,-8.13,-7.68,-7.16,-6.63,-6,-5.38,-4.76,-4.18,-3.64,-3.13,-2.63,-2.16,-1.61,-0.80,0.36,1.77,4,8,9,10,11,12,12,13,14,15,16,17,16,16,16,17,19,19,18,20,24,26,24,23,24,25,27,28,32,38,41,40,33,26,20,13,8,6,4,3,3,2,2.74,3.02,3.12,3.03,3.07,3.25,3.65,4.22,4.79,4.63,3.67,2.70,1.87,1.45,1.25,1.17,1.12,1.04,1,1,1,1,1,1,1,2,3,5,7,10,16,21,27,32,35,38,45,52,54,55,55,59,63,64,63,60,55,51,44,35.83,26.37,21.51,17.62,15.57,14.50,13.91,13.51,14.11,14.83,16,17,20,23,30,37,39,38,37,39,41,43,45,44,43,40,39,40,42,42,41,37,32,26,21,17,17,17,18,19,20,20,21,22,26,31,36,39,39,39,38,38,39,43,46,52,57,64,69,75,78,78,76,69,60,55,49,42,35,30,28,27,27,23,19,19,18,17,17,17,17,17,17,17,16,16,16,17,17,17,17,18,19,20,22,23,22,23,24,25,26,27,28,30,31,33,34,35,34,35,36,36,38,37,37,37,37,36,35,34,33,31,29,29,27,24,22,21,20,20,20,21,24,29,32,34,35,34,31,30,29,30,33,36,42,50,60,66,64,58,50,42,32,24,18,13,10,7,5,4,4,4,5,6,7,8,10,11,11,12,13,14,15,16,17,19,21,23,25,28,31,33,35,35,36,38,39,40,42,43,42,43,45,48,51,54,54,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-9.89,-9.64,-9.38,-9.10,-8.75,-8.38,-7.92,-7.40,-6.84,-6.17,-5.52,-4.88,-4.25,-3.63,-3.05,-2.53,-1.99,-1.29,-0.49,0.46,1.76,3,5,6,7,8,9,9,10,11,11,13,13,13,14,14,15,16,17,18,20,23,24,23,23,25,27,29,31,34,39,43,40,33,25,17,11,7,5,4,3,3,3,3.36,4,3.90,3.71,3.76,4.08,4.62,5.39,6.16,6,4.95,3.65,2.52,1.87,1.66,1.59,1.49,1.28,1,1,1,1,1,1,2,3,4,6,8,10,14,20,27,33,39,43,49,54,56,56,56,59,62,63,60,54,50,44.98,38.61,31.92,25.35,20.87,17.74,16.10,15.25,14.77,14.85,15.27,16.12,17.27,19,21,26,33,39,40,39,39,41,43,45,47,46,44,41,41,42,44,44,42,38,32,26,20,18,18,19,20,22,24,25,24,23,26,32,37,40,40,41,42,40,41,46,51,55,60,65,70,76,79,78,76,69,61,54,46,39,34,32,32,33,30,25,21,20,19,18,17,17,17,17,17,17,17,17,17,17,17,17,17,18,19,20,21,23,23,24,26,27,28,29,30,30,32,34,35,33,32,32,32,33,33,33,33,33,33,32,31,30,29,28,27,26,25,23,22,21,20,18,19,19,21,25,28,31,31,29,28,27,27,29,32,35,42,51,61,67,65,58,50,41,31,23,17,13,10,7,5,4,4,4,5,6,7,8,8,9,10,11,12,13,14,16,17,19,21,23,25,27,29,32,33,34,35,37,37,39,40,41,41,42,45,48,51,52,52,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-9.88,-9.62,-9.39,-9.13,-8.79,-8.42,-8,-7.50,-6.89,-6.25,-5.59,-4.88,-4.22,-3.53,-2.92,-2.27,-1.60,-0.86,0.08,1.16,1.48,4,5,7,8,8,7,7,9,9,9,10,11,13,15,16,17,18,18,19,20,21,22,23,26,28,30,34,37,39,45,46,41,33,25,16,10,7,5,4,3,3,3,3.49,3.88,3.96,3.89,4.07,4.46,5.07,5.75,6.46,6.54,5.83,4.58,3.53,2.76,2.50,2.37,2.25,2,1,1,1,1,1,2,2,3,5,7,9,11,14,20,26,33,39,45,51,54,54,55,56,58,60,60,55,49,43.03,38.73,34.32,29.08,24.27,20.62,18.42,17.12,16.39,16,16.02,16.47,17.27,18.52,20.35,23.01,28,37,42,41,41,42,43,45,47,48,46,44,42,41,42,43,43,41,37,32,26,21,18,19,21,23,26,28,29,27,25,27,33,39,41,43,43,43,42,44,49,55,60,65,71,75,79,80,79,76,69,61,52,43,37,35,34,37,38,33,26,22,21,19,18,17,17,17,17,17,17,17,17,17,17,17,17,18,18,19,20,21,22.22,23.75,25.37,26.50,28.09,29,30.07,31,32.08,33.03,34,33.41,32.40,30.62,30.38,29.87,29,29,29,29,29,29,29,28,27,26,26,25,24,22,22,22,22,20,18,18,18,20,22,25,26,26,25,25,25,25,28,31,35,41,50,60,65,63,57,50,40,30,21,16,12,9,7,5,4,4,4,5,6,7,8,8,9,9,10,11,12,13,15,17,19,21,23,25,26,28,30,31,33,33,34,36,38,40,41,40,40,44,47,49,51,50,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.88,-9.54,-9.30,-9.10,-8.79,-8.48,-8.04,-7.53,-6.97,-6.28,-5.60,-4.87,-4.13,-3.38,-2.63,-1.87,-1.03,-0.16,0.57,2.07,5.84,8,9,10,11,10,9,8,11,11,11,11,14,15,17,19,21,21,20,21,22,23,24,26,29,32,35,39,42,45,49,48,41,33,25,17,10,7,5,4,3,3,3,3.27,3.48,3.59,3.67,3.90,4.32,4.84,5.42,5.92,6.22,6.03,5.33,4.62,4.01,3.87,3.87,3.87,3.59,3,2,2,2,2,2,3,4,6,8,10,12,15,19,24,30,37,43,49,53,53,54,55,57,58,58,54,46.01,40.73,36.45,31.97,27.70,24.03,21.75,20.17,19.09,18.27,17.75,17.57,17.78,18.47,19.78,21.74,24.33,31,40,44,42,42,43,44,46,47,48,46,44,42,41,41,40,38,36,33,29,25,20,19,21,24,27,30,32,33,31,28,29,33,39,44,46,46,43,42,47,54,59,65,71,78,82,82,81,79,75,69,60,51,42,38,37,39,42,39,32,26,24,21,20,18,17,17,17,17,17,17,17,17,17,17,17,17,18,18,19.09,20.26,21.41,22.74,24.13,25.61,27.09,28.41,29.71,30.87,32.02,33.12,34.22,33.83,33.10,31.87,30.51,29.14,27.96,26.65,26.39,26.08,26,26,26,26,26,24,23,23,22,21,20,19,20,21,20,18,17,17,18,19,21,21,21,22,22,23,25,27,31,35,40,47,55,60,60,54,47,39,29,20,15,11,8,6,5,4,4,4,5,6,7,9,9,10,10,10,11,11,12,14,17,19,21,22,24,26,27,29,30,31,32,34,36,38,39,40,39,39,42,45,47,48,48,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.88,-9.50,-9.25,-9,-8.75,-8.40,-8,-7.50,-6.89,-6.24,-5.50,-4.75,-3.93,-3.13,-2.25,-1.30,-0.28,0.57,1.91,1.47,9,13,15,15,15,13,10,9,13,14,14,15,17,20,21,23,25,25,24,24,25,27,29,32,35,37,40,45,47,51,51,46,39,32,25,17,10,7,5,4,3,3,3,3.10,3.16,3.25,3.37,3.61,3.95,4.38,4.90,5.41,5.82,5.95,5.84,5.66,5.64,5.83,6.12,6.26,6.11,5,4,3,3,3,3,4,5,7,9,11,14,17,21,25,30,37,44,50,53,54,54,54,56,57,57,53,46.84,40.96,36,31.62,27.99,25.49,23.67,22.33,21.25,20.37,19.70,19.34,19.37,20.12,21.47,23.66,27.62,34.16,44,46,43,43,44,46,47,47,47,46,43,41,40,38,34,31,28,26,24,22,21,22,25,27,30,32,35,36,34,31,30,35,41,46,50,50,45,44,51,58,64,71,77,83,85,82,80,78,74,69,60,50,42,40,41,43,43,37,30,27,24,22,20,18,17,17,17,17,17,17,17,17,17,17,17,17,17.97,18.71,19.53,20.62,21.78,23.09,24.46,25.87,27.28,28.66,30,31.28,32.60,33.74,34.28,34.10,33.13,31.86,30.12,28.57,27.03,25.35,24.09,23.77,23.46,23.09,24,25,23,22,21,21,20,19,18,18,18,20,19,18,16,16,16,17,18,18,18,19,20,21,23,27,31,35,39,45,51,54,54,49,42,35,27,18,14,10,8,6,5,4,4,4,5,7,8,9,11,12,12,12,12.07,12.11,12.12,13.16,16.02,18.12,19.77,21.25,23.10,24.99,26.75,28.21,29.87,31.12,33.03,34.96,37,38,39,40,38,37,39,42,44,46,46,-14,-14,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.87,-9.49,-9.16,-8.93,-8.68,-8.38,-7.93,-7.42,-6.85,-6.14,-5.39,-4.61,-3.75,-2.80,-1.80,-0.74,0.50,2.20,2.03,7.98,12,18,21,22,20,15,12,10,13,18,19,18,20,24,25,26,29,29,28,28,29,32,35,40,42,43,46,50,53,55,53,46,38,30,24,17,11,7,5,4,3,3,3,3,3.02,3.09,3.21,3.38,3.67,4.07,4.53,5.03,5.50,5.86,6.16,6.58,7.16,7.89,8.54,9.22,8.92,8.98,7,5,4,4,4,4,5,7,9,11,15,19,23,27,33,40,48,53,56,55,55,55,55,56,55,52.82,46.86,41.52,36.77,32.61,29.39,27.16,25.62,24.46,23.36,22.37,21.53,21.02,21.15,22.08,23.82,26.50,30.29,37.37,46,47,44,43,43,45,46,47,46,44,42,39,37,33,29,26,25,24,23,22,22,26,29,31,33,34,38,39,36,32,32,37,44,51,55,55,50,48,54,62,70,77,83,87,85,82,80,77,73,68,60,48,44,44,44,44,40,33,27,25,25,22,20,18,17,17,17,17,17,17,17,17,17,17,17,17.70,18.22,18.98,19.86,20.87,22.03,23.32,24.62,26,27.34,28.63,29.98,31.39,32.79,33.95,34.51,34.27,33.32,31.90,29.96,28.35,26.70,25.13,23.76,22.39,21.09,20.71,21.70,22,21,19,19,19,19,19,17,17,17,17,18,16,15,15,15,15,16,16,17,18,19,21,23,28,32,36,40,45,48,48,46,41,36,30,23,17,13,9,7,5,5,4,4,4,5,7,9,10,11,12.97,13.88,13.83,13.76,13.82,14.09,14.50,16.01,17.62,19.15,20.64,22.53,24.50,26.38,28.21,29.88,31.70,33.59,35.66,37.76,38.09,39.98,39,37,37,38,40,43,44,45,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.88,-9.43,-9.15,-8.91,-8.65,-8.37,-7.93,-7.41,-6.79,-6.11,-5.30,-4.47,-3.52,-2.52,-1.40,-0.13,1.28,3.66,8.83,13,16,21,26,27,23,18,15,13,15,21,23,22,24,28,30,31,32,33,33,33,34,38,42,48,50,50,53,56,59,60,55,48,40,31,24,17,11,8,6,4,3,3,3,3,3.01,3.09,3.23,3.42,3.74,4.12,4.53,4.98,5.37,5.79,6.34,7.10,8.24,10.01,10.48,10.35,10.75,10.66,10,9,7,5,5,5,6,8,10,12,15,19,23,28,35,42,50,56,58,58,58,58,58,57,55,51.67,47,42.15,37.72,33.96,31.13,29.23,27.88,26.65,25.52,24.42,23.47,22.78,22.87,24,26.23,29.36,33.85,40.11,48,48,44,42,42,43,45,45,45,44,41,38,32,28,26,25,26,27,27,25,25,29,33,35,36,38,41,41,37,33,36,41,48,55,60,59,53,50,56,65,73,81,87,87,83,79,77,74,71,67,58,48,46,45,44,41,35,29,25,24,24,21,20,18,17,17,17,17,17,17,17,17,17,17.02,17.37,17.78,18.37,19.09,19.97,21,22.13,23.36,24.61,25.85,27.09,28.34,29.72,31.15,32.62,33.85,34.52,34.38,33.48,32.02,30.45,28.34,26.75,25.20,23.70,22.28,21,19.36,18.96,19.35,18.02,18,17,16,17,17,17,16,15,15,16,15,14,14,14,15,15,16,17,18,20,22,26,31,34,38,41,43,42,41,39,35,30,26,21,16,13,9,6,5,5,4,4,5,6,8,9,10,11.87,13.75,14.62,14.46,14.75,15.14,15.46,16,16.82,17.96,19.27,20.84,22.59,24.47,26.36,28.21,30,31.87,33.76,35.57,36.97,38.13,38.73,38.07,36.99,35,37,40,42,44,43,-13,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.89,-9.48,-9.17,-8.97,-8.72,-8.38,-7.99,-7.42,-6.78,-6.04,-5.23,-4.29,-3.30,-2.25,-1,0.49,2.36,2.66,11,17,22,25,29,30,26,22,17,16,19,25,29,27,30,34,35,37,38,37,38,39,42,45,50,52,51,52,55,59,63,63,57,48,41,34,26,18,12,9,6,4,3,3,3,3,3.04,3.16,3.38,3.71,4.11,4.51,4.89,5.21,5.49,5.82,6.35,7.14,8.34,9.42,10.09,10.48,11.23,12.26,13.16,14,10,7,6,6,7,9,11,13,16,20,25,31,37,43,50,54,58,60,60,60,60,60,57,51.85,47.10,42.64,38.71,35.49,33.13,31.53,30.21,29,27.78,26.57,25.45,24.61,24.62,25.84,28.26,31.74,36.08,41.51,49,48,44,41,41,43,45,44,44,42,39,34,29,27,26,28,30,32,32,29,28,31,36,37,39,42,44,43,38,36,40,46,53,60,64,61,54,51,57,66,75,83,88,85,79,75,72,69,67,64,56,47,45,44,41,37,31,27,25,24,22,21,20,18,17,17,17,17,17,17,17,17,17.02,17.16,17.41,17.77,18.28,18.98,19.82,20.82,21.91,23.08,24.23,25.35,26.50,27.82,29.22,30.66,32.20,33.53,34.35,34.29,33.47,32.09,30.54,28.96,27.38,25.84,23.97,22.58,21.15,19.87,18.50,18.09,17.45,16.12,15,14,15,16,16,14,13,13,13,13,13,13,15,15,16,17,18,19,22,25,30,35,39,41,41,39,37,34,32,29,26,23,19,16,12,10,7,5,5,4,4,5,7,8,9.10,10.25,11.40,12.62,13.75,14.50,15.14,15.78,16.49,16.85,17.50,18.39,19.61,21.03,22.74,24.52,26.37,28.24,30.02,31.82,33.52,35.24,36.63,37.75,38.40,37.60,36.25,35.09,36,39,41,42,42,-13,-13,-13,-13,-13,-12,-12,-12,-11,-10,-10,-9.93,-9.55,-9.26,-9.03,-8.78,-8.49,-8.03,-7.50,-6.84,-6.02,-5.13,-4.14,-3.10,-1.91,-0.62,1.01,3.22,7.50,14,21,26,30,33,35,32,26,21,21,23,29,34,34,37,40,42,43,44,42,44,45,49,51,53,51,48,48,51,57,62,64,57,47,40,33,26,18,12,9,6,5,4,3,3,3.01,3.11,3.32,3.66,4.16,4.72,5.16,5.48,5.62,5.71,5.86,6.23,6.86,7.63,8.42,9.12,9.98,11.24,13.99,17.62,18,15,11,9,9,9,11,13,14,18,22,27,34,39,46,50,53,56,59,59,58,59,59,57,51.75,46.95,42.99,39.65,37.09,35.23,33.78,32.59,31.38,30.10,28.72,27.45,26.48,26.37,27.58,30.03,33.49,37.59,42.11,46,48,44,41,41,42,43,42,40,38,34,31,28,28,30,33,37,38,35,32,31,35,38,40,43,46,47,43,39,40,45,52,58,64,66,61,55,52,56,67,76,84,87,83,78,72,68,66,64,61,54,47,45,43,40,35,29,27,27,25,24,21,19,18,17,17,17,17,17,17,17,16.87,16.88,17.03,17.25,17.57,18,18.62,19.40,20.36,21.37,22.45,23.50,24.58,25.72,26.86,28.41,29.88,31.37,32.75,33.61,33.65,32.90,31.72,30.36,28.92,27.50,26.09,24.67,23.32,21.97,20.45,19.17,18.12,17.08,15.54,15.02,13.92,12.98,14,14,13,12,11,11,12,13,14,16,16,17,18,19,21,25,30,35,40,42,42,40,37,33,31,29,26,24,21,18,15,12,9,7,5,5,5,5,6,7.01,8.22,9.62,10.39,11.36,12.37,13.37,14.32,15.16,16,16.66,17.28,17.96,18.86,19.99,21.37,22.96,24.64,26.45,28.21,29.90,31.60,33.22,34.73,36.12,37.25,38,37.25,35.75,34.83,35.03,36,39,40,40,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.98,-9.64,-9.38,-9.16,-8.93,-8.62,-8.16,-7.62,-6.88,-6.02,-5.05,-4,-2.84,-1.53,-0.10,1.39,3.45,9.39,17,24,30,35,39,41,39,34,28,27,26,32,39,43,45,48,49,50,47,49,51,53,55,56,51,45,42,43,46,52,59,63,57,47,38,30,24,18,12,9,7,5,4,3,3,3,3.13,3.47,4.03,4.75,5.41,5.97,6.10,6.02,5.90,5.87,6.03,6.41,6.98,7.57,8.32,8.86,12,16.32,20.48,22,18,15,13,13,14,14,15,17,20,25,31,36,42,47,50,51,53,55,55,56,57,56,54,50.08,46.46,43.26,40.66,38.71,37.22,36,34.90,33.72,32.35,30.85,29.41,28.34,28.11,29.21,31.64,34.99,38.75,42.53,46,47,43,40,39,39,38,37,36,34,31,28,29,32,34,37,41,42,38,34,35,38,40,42,45,48,48,44,41,43,50,57,63,68,67,62,56,53,58,66,76,84,87,84,78,71,65,62,61,57,51,46,44,42,40,34,30,29,28,27,24,21,19,18,17,17,17,17,17,16,16.12,16.50,16.59,16.72,16.88,17.14,17.53,18.12,18.87,19.75,20.71,21.66,22.64,23.66,24.71,25.83,27.22,28.99,30.45,31.66,32.49,32.61,32.09,31.12,29.95,28.65,27.38,26.13,24.95,23.75,22.54,21.36,19.88,19.16,17.70,16.71,15.77,14.87,13.88,12.95,13,13,12,11,11,12,13,15,17,18,18,19,21,24,28,34,39,42,43,41,38,35,32,30,27,25,22,20,17,15,12,9,7,5,5,5,5,6.11,7.71,8.74,9.73,10.62,11.50,12.37,13.25,14.13,15,15.86,16.62,17.37,18.14,19.10,20.23,21.57,23.07,24.66,26.36,28,29.61,31.13,32.63,34.08,35.32,36.37,36.72,36.14,34.95,33.66,32.47,34.25,35.96,38,38,-12,-13,-13,-13,-12,-12,-12,-12,-11,-11,-10,-10,-9.72,-9.50,-9.29,-9.12,-8.78,-8.38,-7.76,-7,-6.05,-5,-3.84,-2.52,-1.12,0.58,2.50,3.12,11.58,18,26,34,41,45,47,46,40,34,31,30,36,44,49,51,53,53,53,51,54,58,59,58,53,47,41,38,38,41,48,55,60,56,47,40,33,26,19,13,9,7,5,4,3,3,3,3.01,3.63,4.46,5.34,6.17,6.61,6.58,6.26,6,5.85,5.87,6.08,6.45,7.03,7.91,9.86,13.76,18.50,23.37,25,24,21,19,19,18,17,17,18,22,29,35,40,45,49,49,49,49,49,50,52,53,53,51,48.20,45.78,43.59,41.75,40.32,39.13,38.13,37.12,35.90,34.48,32.89,31.37,30.15,29.79,30.82,33.17,36.41,39.99,43.50,47,47,43,40,38,37,35,35,34,32,30,28,29,34,38,40,43,44,40,38,39,42,43,44,46,48,46,45,46,50,56,62,69,70,68,63,59,55,59,66,75,83,88,85,78,71,63,59,56,51,48,46,45,43,39,35,31,30,28,26,23,21,19,18,18,18,18,17,17,16.02,16.15,16.16,16.23,16.27,16.40,16.63,17.01,17.59,18.33,19.14,20.03,20.97,21.88,22.84,23.77,24.85,26.58,27.50,29.32,30.45,31.17,31.36,30.97,30.15,29.15,28.07,26.95,25.90,24.89,23.90,22.89,21.90,20.87,19.95,19.01,18.12,17.24,16.29,14.87,13.87,13.92,14,12,11,11,11,13,15,16,18,19,20,22,25,29,36,41,40,39,38,36,34,31,29,27,24,22,20,18,16,12,9,7,5,5,5,5.87,6.90,8.08,9.12,10.01,10.85,11.61,12.37,13.14,13.96,14.75,15.58,16.37,17.22,18.11,19.12,20.25,21.59,23,24.51,26.10,27.62,29.11,30.53,31.91,33.24,34.37,35.20,35.45,34.88,33.76,32.60,31.77,32.38,33.28,35.01,36,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.99,-9.74,-9.53,-9.38,-9.18,-8.92,-8.50,-7.88,-7.04,-6.04,-4.89,-3.62,-2.14,-0.52,1.33,4.09,8.89,14.28,21,28,37,45,50,52,51,46,41,36,35,40,47,52,52,52,51,52,54,57,59,59,54,48,42,37,34,34,37,44,51,56,53,46,41,36,29,22,15,9,7,5,4,3,3,3,3,3.70,4.91,5.92,6.63,6.87,6.63,6.28,5.98,5.75,5.72,5.84,6.17,6.90,8.12,11.01,15.29,20.95,25.33,29,28,27,25,22,20,17,16,18,22,29,36,43,48,51,50,48,47,47,48,49,49,49,47.03,46.75,45.50,44.23,43,41.90,40.99,40.12,39.13,37.91,36.46,34.83,33.25,31.99,31.51,32.45,34.82,38,41.41,44.73,48,48,44,40,39,37,37,36,36,34,32,30,30,34,39,43,44,42,41,42,44,44,45,46,47,48,48,48,50,55,62,68,72,73,70,66,61,57,60,68,77,85,89,85,79,71,64,58,53,50,48,47,48,46,40,36,31,28,26,24,22,20,19,18,18,18,18,18,17,16.53,16.15,16,15.87,15.87,15.95,16.13,16.57,17.15,17.95,18.75,19.63,20.46,21.25,22.11,22.92,23.91,25.47,26.24,28.09,29.09,29.72,29.88,29.57,28.90,28.04,27.10,26.16,25.28,24.45,23.62,22.87,22.12,21.29,20.54,19.83,19.10,18.36,17.54,16.27,15.83,16.12,16.04,13,11,10,11,12,14,16,18,19,20,22,25,29,34,37,36,36,35,35,33,31,29,27,24,22,20,18,16,12,9,7,5,5.01,5.15,6.35,7.39,8.47,9.39,10.25,10.90,11.53,12.22,12.87,13.58,14.27,15.07,15.87,16.75,17.74,18.82,20,21.28,22.64,24.09,25.57,26.98,28.29,29.59,30.83,32.01,33,33.65,33.84,33.37,32.52,31.62,30.99,30.88,31.53,33.25,34.91,-12,-12,-12,-12,-12,-12,-12,-12,-11,-10,-10,-9.99,-9.73,-9.54,-9.41,-9.23,-8.92,-8.50,-7.85,-6.99,-5.91,-4.72,-3.30,-1.72,0.25,2.51,3.75,13.46,20.86,25,32,39,46,52,51,50,50,47,43,42,45,50,50,47,45,46,49,50,53,55,52,49,43,38,34,32,31,34,40,46,50,47,41,37,34,29,22,15,10,7,5,4,3,3,3,3,4.27,5.52,6.47,6.77,6.76,6.48,6.13,5.83,5.62,5.58,5.72,6.12,6.84,8.75,11.87,16,20.62,25.33,27,30,31,26,21,17,15,15,17,21,28,35,43,49,52,49,46,45,49,50,50,48,46.03,45.75,46.34,46.07,45.25,44.35,43.50,42.73,41.90,40.92,39.70,38.21,36.60,35.08,33.87,33.40,34.33,36.65,39.86,43.16,46.26,49,49,45,43,41,41,42,42,41,38,35,32,31,34,40,43,43,43,43,44,45,47,48,49,50,51,53,52,52,58,66,73,78,77,72,66,61,58,63,72,81,88,89,86,81,74,67,59,54,50,49,50,51,47,41,34,28,25,24,22,21,19,18,18,18,19,19,18,17.25,16.62,16.16,15.86,15.62,15.50,15.53,15.77,16.27,16.99,17.78,18.62,19.37,20.10,20.76,21.50,22.22,23.12,24.12,25.79,26.85,27.72,28.15,28.25,27.99,27.40,26.04,25,24.87,23.24,23.37,22.86,22.23,21.67,21.10,20.65,20.20,19.73,19.26,18.74,18.25,17.88,16.84,17.11,13.98,12,11,11,12,13,15,17,18,19,21,24,27,30,32,33,33,33,32,31,30,29,27,25,21,19,17,15,12,9,7,5.01,5.14,5.75,6.70,7.70,8.62,9.37,10.08,10.74,11.33,11.87,12.47,13.07,13.73,14.46,15.25,16.15,17.16,18.28,19.50,20.77,22.15,23.50,24.78,26.01,27.21,28.36,29.47,30.47,31.27,31.84,31.97,31.71,31.20,30.50,30.13,30.25,31,32.08,32.71,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.89,-9.64,-9.50,-9.36,-9.17,-8.90,-8.49,-7.80,-6.91,-5.85,-4.59,-3.12,-1.39,0.75,4,9.26,16.71,25,28,33,39,43,45,46,47,49,50,47,47,49,49,46,42,40,41,42,44,46,47,46,43,39,35,32,29,28,30,35,40,42,38,34,30,27,24,19,13,8,6,5,4,4,3,3,3,4.77,6.36,6.83,6.86,6.66,6.27,5.87,5.57,5.37,5.36,5.58,6.12,7.20,9.12,12,15.58,19.50,23.17,25,29,29,25,19,15,13,14,16,20,26,34,42,48,48,45,41,43,49,54,53,51,50.54,49.08,48.16,47.41,46.63,45.79,44.92,44.07,43.12,42.04,40.79,39.45,38.10,36.91,36,35.53,36.53,38.88,42.08,45.29,48.22,51,49,48,48,47,47,49,48,45,41,37,33,32,35,39,42,43,45,46,48,50,51,53,54,55,57,59,57,56,59,68,76,80,77,71,66,61,60,66,76,84,91,91,87,81,75,69,63,56,51,50,50,50,45,37,30,25,23,21,20,19,19,18,17,18,19,20,18.09,17.25,16.62,16.12,15.72,15.40,15.26,15.28,15.61,16.14,16.95,17.75,18.50,19.21,19.76,20.35,20.97,21.58,22.37,23.25,24.35,25.73,26.42,26.82,26.87,26.59,25.24,25.17,23.74,22.88,22.10,21.41,20.85,21.24,21.03,20.61,20.36,20.11,19.85,19.65,19.53,19.37,19.09,19.04,16.87,14.92,13,11,10,11,13,15,16,17,19,21,23,25,28,30,31,30,30,31,30,29,27,25,23,20,18,16,14,12.07,8.90,6.89,5.01,5.25,5.87,6.91,7.72,8.51,9.23,9.87,10.46,10.97,11.47,11.96,12.48,13.08,13.75,14.52,15.45,16.45,17.57,18.76,20.09,21.39,22.66,23.85,24.99,26.02,27.03,27.32,28.11,29.29,29.74,29.95,29.53,29.46,29.38,29.50,29.86,30.58,31.32,31.41,-11,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.88,-9.54,-9.38,-9.23,-9,-8.67,-8.22,-7.53,-6.65,-5.61,-4.36,-2.88,-1.12,1.12,3.88,12.01,19.07,22,27,30,33,35,38,41,43,45,45,46,49,48,45,42,38,35,35,36,38,40,41,37,36,34,31,28,26,25,27,31,35,35,32,27,24,22,19,15,11,8,6,5,4,4,4,4,4,5.09,6.20,6.73,6.71,6.48,6.12,5.77,5.52,5.38,5.42,5.67,6.27,7.36,9.13,11.65,14.57,17.62,20.13,22,26,26,23,18,13,12,13,14,19,26,34,42,44,42,39,37,40,47,57,59,57.64,54.83,52.03,50.33,49.13,48.12,47.17,46.24,45.27,44.25,43.11,41.85,40.60,39.45,38.57,38.02,38.14,39.10,41.50,44.66,47.88,50.78,53,52,53,54,53,53,52,51,46,42,37,34,34,38,40,43,46,48,51,53,55,56,58,59,61,62,63,62,59,62,68,76,78,75,70,66,62,64,70,81,88,93,91,85,78,72,69,64,58,52,49,49,46,39,31,26,22,21,20,19,18,17.99,17.92,17.09,17.11,18.12,18.87,17.86,17.01,16.40,15.95,15.53,15.25,15.09,15.12,15.46,16.08,16.83,17.62,18.37,18.98,19.41,19.86,20.37,20.90,21.63,22.86,23.91,24.75,25.36,25.67,25.70,24.78,24.09,23.40,22.54,21.72,20.96,20.33,19.86,19.49,19.26,19.13,19.75,19.65,19.62,19.63,19.70,20,19.77,19.58,19.12,16.09,14,11,10,10,11,13,15,17,18,20,22,24,25,27,28,27,27,28,28,27,25,23,21,19,17,14.92,14.11,10.86,8.82,6.82,5.66,5.34,5.91,6.70,7.52,8.52,9.04,9.72,10.24,10.65,11.07,11.47,11.89,12.41,13.03,13.75,14.62,15.62,16.74,17.88,19.21,20.47,21.67,22.36,23.78,24.78,25.08,25.86,26.51,27.04,27.40,27.67,27.88,28.12,28.46,28.96,29.59,30.28,30.91,31.11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.87,-9.50,-9.24,-9.02,-8.77,-8.43,-7.98,-7.28,-6.43,-5.40,-4.18,-2.77,-1.11,1.13,4.25,11.91,16.12,19,23,26,28,32,34,37,38,38,39,43,47,46,41,37,34,33,31,32,33,35,35,32,32,29,27,25,23,23,24,27,29,28,26,24,20,17,15,12,9,7,6,5,5,4,4,4,4,5.37,6.22,6.67,6.74,6.51,6.20,5.87,5.63,5.51,5.54,5.83,6.40,7.42,9.02,11.12,13.40,15.54,17.33,19,22,23,21,16,12,11,11,14,18,25,33,39,39,37,34,34,38,46,55,60,59.24,56.46,54.07,52.02,50.62,49.50,48.45,47.37,46.27,45.12,43.91,42.71,41.54,40.59,39.98,39.82,40.41,41.99,44.33,47.51,50.88,53.99,56,57,59,59,58,57,55,52,48,42,37,35,38,41,44,45,49,53,56,59,60,61,62,64,67,68,67,65,63,64,68,73,75,72,69,65,65,68,77,87,93,94,91,85,77,70,66,62,57,52,50,47,42,34,27,24,22,20.01,19.07,18.10,17.83,17.23,16.92,16.27,16.90,17.74,17.67,17.16,16.60,16.10,15.67,15.34,15.03,14.87,14.95,15.28,15.87,16.58,17.35,18.01,18.52,18.89,19.25,19.74,20.24,20.88,21.78,23.14,23.95,24.50,24.77,24.77,24.48,23.16,22.52,21.74,20.95,20.20,19.58,19.07,18.72,18.50,18.37,18.24,18.90,18.32,19.09,19.24,19.38,19.36,19.09,17.96,16.17,14.11,12.09,9.92,8.98,10,12,14,16,18,20,21,22,23,24,25,25,26,26,27,26,24,22,20,19,15.92,15.12,13.16,11.20,7.87,6.63,5.27,5.57,6,6.73,7.54,8.33,9.08,9.71,10.25,10.62,11,11.33,11.70,12.12,12.61,13.21,13.96,14.85,15.87,16.91,18,19.11,20.63,21.23,22.21,23.12,23.90,24.62,25.24,25.73,26.03,26.28,26.66,27.14,27.79,28.54,29.32,30.03,30.73,30.75,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.88,-9.50,-9.13,-8.86,-8.59,-8.16,-7.64,-6.99,-6.14,-5.17,-4.04,-2.73,-1.13,0.95,4.26,8.63,13.08,16.28,19,24,27,28,29,31,30,28,33,40,45,45,41,36,32,28,27,28,30,31,31,29,26,25,23,22,21,20,20,22,22,21,20,19,17,15,12,10,8,7,6,6,6,5,5,5,5,5.86,6.77,7.11,7.13,6.90,6.59,6.23,5.92,5.75,5.75,5.99,6.53,7.50,8.90,10.62,12.35,13.77,14.70,15,18,20,19,14,11,10,11,13,17,23,31,35,34,32,31,31,35,42,51,56,56.26,55.87,54.71,53.01,51.76,50.63,49.50,48.27,47,45.73,44.48,43.28,42.25,41.49,41.13,41.36,42.36,44.26,46.99,50.29,54.09,58,61,63,64,63,60,57,56,53,47,41,37,37,40,44,45,48,52,57,60,63,64,64,66,69,72,71,69,67,65,64,68,71,72,71,68,66,67,72,80,90,92,91,89,83,76,69,62,58,53,51,49,46,39,30,25,22,21.04,20.11,19.04,18.17,17.32,16.95,16.38,16.15,16.26,16.60,16.66,16.45,16.07,15.72,15.38,15.10,14.86,14.65,14.74,15.08,15.58,16.20,16.86,17.45,17.87,18.21,18.51,18.92,19.46,20.10,20.98,22.49,23.27,23.85,24.11,24.08,23.79,22.51,21.96,21.15,20.38,19.66,19.03,18.50,18.10,17.82,17.63,17.51,17.48,17.50,18.42,18.59,18.66,18.59,18.20,17.29,14.98,13.85,11.84,9.86,7.88,8.95,11,13,15,18,19,20,21,21,22,23,23,24,25,25,24,24,21,19,16.92,14.87,14.16,11.76,9.75,7.91,6.17,5.84,5.74,6.14,6.85,7.73,8.57,9.36,10.04,10.62,11.11,11.41,11.73,12,12.28,12.62,13.03,13.61,14.33,15.20,16.10,17.09,18.14,19.25,20.29,21.34,22.25,23.09,23.82,24.42,24.97,25.45,25.75,26.14,26.75,27.51,28.37,29.32,29.83,30.21,30.50,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.91,-9.54,-9.17,-8.80,-8.41,-7.99,-7.41,-6.75,-5.97,-5.03,-4,-2.84,-1.38,0.50,3.13,6.35,10.10,13.73,18.64,21.98,24,22,22,25,24,23,28,38,44,43,40,36,32,30,27,26,28,29,28,25,24,22,21,20,19,18,18,18,17,17,17,16,15,12,10,9,8,7,7,7,7,8,7,7,7,7.61,8.04,8.35,8.23,7.85,7.37,6.87,6.49,6.17,6.08,6.22,6.70,7.53,8.75,10.23,11.54,12.46,12.65,11.35,13,17,16,12,10,9,10,12,16,21,27,30,29,27,27,29,32,38,46,52,54.16,54.72,54.33,53.49,52.52,51.47,50.23,48.84,47.37,45.99,44.71,43.59,42.70,42.12,42.03,42.58,43.88,46.01,48.96,52.64,56.86,62,64,64,65,63,59,57,54,50,44,39,37,39,42,46,48,51,55,59,62,64,65,66,69,74,76,75,72,69,66,66,67,70,72,72,68,67,70,75,83,89,88,86,83,79,74,67,60,52,48,48,48,42,34,28,24,22.92,21.12,20.15,19.20,18.21,17.40,16.85,16.25,15.51,15.52,15.87,15.98,15.88,15.71,15.39,15.12,14.87,14.65,14.49,14.52,14.75,15.20,15.70,16.23,16.70,17.08,17.37,17.67,18.12,18.66,19.35,20.17,21.78,22.61,23.22,23.49,23.53,23.33,22.90,21.59,20.90,20.25,19.60,18.96,18.37,17.88,17.51,17.22,16.98,16.86,16.74,16.71,16.87,17.76,17.71,17.46,16.90,16.13,15.09,14.14,10.79,8.84,7.87,9.92,12,15,17,17,18,19,20,20,20,21,22,22,23,23,21,20,18,15.88,15.16,12.76,10.73,8.89,7.82,6.78,6.20,6.14,6.51,7.24,8.14,9.09,10.39,11.12,11.50,12.10,12.50,12.82,13,13.12,13.27,13.49,13.77,14.25,14.87,15.59,16.47,17.49,18.57,19.65,20.74,21.74,22.65,23.47,24.20,24.84,25.37,25.89,26.39,26.95,27.65,28.47,29.35,29.65,29.66,28.16,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.68,-9.35,-8.92,-8.49,-7.98,-7.38,-6.66,-5.88,-5.01,-4.05,-2.99,-1.67,-0.12,1.75,4.14,7.34,10.91,14.66,19.39,19.86,18,16,18,19,20,27,36,40,40,37,35,33,29,26,24,26,28,28,24,21,20,19,18,17,16,16,15,14,14,14,13,11,10,9,8,8,8,7,8,10,11,14,13,11,9.75,10.36,10.73,10.36,9.63,8.78,7.98,7.28,6.78,6.50,6.50,6.85,7.54,8.58,9.76,11.41,11.50,11.07,10.71,11,13,12,10,9,9,10,12,17,22,26,26,25,25,26,28,30,36,42,51,52.62,53.83,53.90,53.61,52.90,51.87,50.49,48.87,47.27,45.84,44.59,43.58,42.85,42.50,42.63,43.37,44.85,47.04,50.09,54.20,59,63,63,62,62,60,58,56,52,46,41,38,39,41,46,49,51,55,58,59,62,64,65,68,72,78,80,79,76,71,67,67,69,71,72,70,68,68,71,78,86,89,85,81,79,76,72,65,59,49,44,44,44,37,31,27,25,23.10,21.83,20.75,19.25,18.33,17.64,17.03,16.29,15.62,15.50,15.62,15.51,15.75,15.62,15.35,15.03,14.76,14.54,14.41,14.35,14.49,14.77,15.21,15.60,15.98,16.28,16.53,16.86,17.29,17.90,18.59,19.40,21.07,21.85,22.50,22.89,23.07,22.96,22.61,22.13,21.51,20.24,19.63,18.99,18.37,17.84,17.36,16.88,16.52,16.23,16,15.87,15.82,16.79,16.85,16.73,16.50,16.16,15.74,15.79,13.12,9.77,7.83,8.87,10.95,14,15,16,17,18,18,18,18,18,19,20,21,20,19,18,17.07,16.13,14.17,13.14,11.12,8.92,7.75,6.90,6.42,6.40,6.87,7.64,8.64,9.72,10.75,11.75,12.57,13.27,13.83,14.15,14.38,14.51,14.53,14.50,14.51,14.72,15.09,15.53,16.28,17.23,18.29,19.45,20.58,21.64,22.65,23.60,24.42,25.16,25.83,26.40,27,27.57,28.17,28.78,29.60,29.74,29.37,27.73,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.61,-9.17,-8.72,-8.13,-7.50,-6.76,-6,-5.13,-4.24,-3.25,-2.13,-0.88,0.63,2.62,4.87,7.84,10.72,12.88,13.41,11.25,11,13,16,20,26,33,35,36,34,31,30,27,24,22,24,25,25,23,20,18,17,16,15,15,14,13,13,12,12,11,10,9,8,8,8,8,8,9,11,15,18,19,16,13.67,14.35,14.26,13.61,12.38,10.99,9.64,8.51,7.64,7.09,6.87,7,7.51,8.32,9.24,10.08,10.28,9.87,9.07,9,8,8,8,8,8,9,14,20,24,24,23,23,23,25,26,30,36,43,49,51.64,53.23,53.57,53.46,52.82,51.64,50.07,48.27,46.62,45.22,44.07,43.22,42.71,42.58,42.89,43.75,45.24,47.33,50.11,53.38,57,60,60,59,58,56,56,53,49,44,40,40,41,45,49,51,54,57,59,60,62,63,66,70,75,81,84,82,78,73,70,70,72,72,70,68,68,70,74,81,88,89,82,78,76,75,71,66,57,48,41,39,37,33,30,26.99,24.88,23.15,21.77,20.33,19.27,18.40,17.84,17.36,16.62,15.67,15.66,16.02,16.17,16.13,15.97,15.64,15.24,14.87,14.59,14.41,14.27,14.26,14.48,14.74,15.03,15.36,15.54,15.82,16.12,16.53,17.14,17.87,18.64,20.28,21.11,21.77,22.29,22.52,22.50,22.35,21.98,21.62,21.09,20.53,19.97,19.28,18.67,17.39,16.86,16.35,15.87,15.50,15.21,15,14.87,15.78,15.83,15.74,15.74,15.84,15.27,13.75,11.37,8.77,7.84,9.88,12.01,13,15,16,16,16,16,16,16,17,18,18,18,17,16,14.91,13.91,13.33,12.02,10.07,8.72,7.67,6.97,6.62,6.72,7.25,8.14,9.26,11.03,12.23,13.25,14.15,14.86,15.37,15.77,16,16.11,16.08,15.99,15.87,15.75,15.87,16.12,16.66,17.50,18.53,19.65,20.83,21.95,23.01,24.07,24.99,25.82,27.37,27.33,28.37,28.32,29.27,29.37,29.99,29.99,29.58,28.34,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.61,-9.04,-8.42,-7.75,-7,-6.17,-5.36,-4.50,-3.61,-2.63,-1.51,-0.28,1.09,2.86,4.89,6.86,8.32,9.02,8.50,11.28,15,19,23,27,28,28,31,31,30,28,25,23,21,21,22,21,19,18,17,16,15,14,14,13,13,12,11,11,10,9,9,9,9,10,9,9,10,11,14,19,22,21,19.58,19.53,19.16,17.82,15.90,13.78,11.79,10.11,8.77,7.85,7.32,7.20,7.48,8.01,8.62,9.13,9.25,8.87,8.04,7,7,7,7,7,8,10,15,20,23,22,21,21,22,23,26,29,35,42,48,51,52.99,53.15,52.88,52.02,50.63,48.85,46.99,45.39,44.10,43.12,42.49,42.16,42.25,42.74,43.63,44.97,46.71,48.83,51.27,53.62,55.83,53,54,53,53,50,48,44,41,41,43,45,49,52,53,55,59,59,60,61,64,67,73,80,84,85,84,81,75,73,74,76,73,69,67,68,71,77,83,89,86,79,76,75,75,71,63,56,45,39,36,33,31,28,25.92,24,22.79,21.73,20.39,19.29,18.60,18.07,17.64,17.27,16.82,16.79,17.13,17.22,17.08,16.75,16.32,15.77,15.26,14.88,14.59,14.34,14.22,14.27,14.45,14.62,14.85,15,15.20,15.49,15.88,16.46,17.14,17.89,18.62,20.28,21,21.51,21.87,22.03,22,21.79,21.50,21.04,20.50,19.98,18.79,18.22,17.50,16.88,16.22,15.62,15.10,14.64,14.26,14.01,13.83,13.73,14.73,14.74,15.25,14.66,13.14,11.62,9.98,7.83,8.86,9.92,12,13,15,15,14,14,15,15,15,16,17,16,15,14.90,13.96,13.04,12.25,10.62,9.50,8.40,7.57,6.99,6.79,7.03,7.70,8.70,9.91,11.91,13.20,14.41,15.51,16.40,17.02,17.53,17.82,17.87,17.76,17.60,17.38,17.25,17.21,17.22,17.64,18.35,19.25,20.28,21.40,22.57,23.67,24.72,26.12,27.41,28.20,28.84,29.34,29.75,30.07,30.28,30.46,30.35,29.88,28.98,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.63,-8.99,-8.25,-7.48,-6.63,-5.76,-4.90,-4.03,-3.13,-2.17,-1.18,-0.16,1.07,2.39,3.75,4.64,6.01,7.96,12.16,16.60,21,23,26,23,22,25,29,29,26,24,21,19,19,19,18,17,16,15,14,14,13,13,13,12,12,11,10,10,10,10,10,10,10,10,10,11,12,13,17,21,23,24.58,25.78,24.96,22.97,19.90,16.86,14.09,11.75,9.89,8.51,7.64,7.26,7.36,7.74,8.25,8.64,8.75,8.49,7.61,7,7,7,7,8,8,11,15,20,20,20,20,20,21,23,25,28,33,39,47,51.35,53.02,52.57,51.70,50.39,48.70,46.79,45.07,43.59,42.48,41.73,41.33,41.26,41.52,42.12,43.01,44.20,45.58,47.08,48.63,50.23,49.26,48.33,48,49,47,46,44,42,41,43,46,49,52,53,53,56,59,59,59,61,64,69,76,82,85,85,85,83,79,77,78,77,73,69,67,69,73,79,85,88,84,77,74,73,72,67,60,51,44,39,35,32,30,27,24.10,22.15,22.28,21.38,20.57,19.72,18.79,18.38,17.92,18.23,18.39,18.61,18.74,18.67,18.37,17.87,17.25,16.60,15.88,15.37,14.95,14.61,14.35,14.32,14.34,14.51,14.57,14.63,14.77,15,15.34,15.86,16.42,17.11,18.42,19.17,20.09,20.70,21.14,21.42,21.52,21.45,21.13,20.87,20.41,19.97,19.48,18.87,18.26,17.64,16.25,16.48,14.89,14.28,13.76,13.32,12.95,12.70,12.52,12.49,12.26,11.75,10.87,9.71,8.51,7.13,7.90,10.09,11,12,12,12,12,13,13,13.03,13.12,13.98,14.78,14,13.32,12.72,12.32,11.82,11.22,10.51,9.02,8.23,7.57,7.15,7.07,7.37,8.14,9.24,10.57,12.71,14.13,15.53,16.85,17.92,18.74,19.37,19.71,19.79,19.66,19.45,18.91,18.75,18.70,18.75,18.97,19.51,20.34,21.28,22.35,23.42,24.49,26.37,27.37,28.26,29.04,29.72,30.20,30.52,30.76,30.87,30.84,30.62,30.02,28.63,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.64,-8.88,-8.05,-7.18,-6.30,-5.42,-4.55,-3.72,-2.86,-2,-1.23,-0.38,0.50,1.47,2.15,3.37,6.24,9.71,14.10,16.61,18.98,21,18,17,21,25,27,25,23,21,18,17,17,16,15,14,14,13,13,13,13,13,12,12,11,11,11,11,11,12,11,11,12,12,12,13,14,16,18,22,28.79,31,31.53,28.25,23.78,19.83,16.50,13.70,11.38,9.61,8.35,7.66,7.51,7.77,8.25,8.75,9.11,8.98,8.35,7,8,8,8,9,10,12,15,17,18,18,19,20,21,23,25,28,33,41,50,53.24,53.46,51.28,49.74,47.97,46.04,44.24,42.60,41.29,40.46,40,39.86,40,40.42,41.11,42,43.01,44.08,45,45.60,45.45,44.49,43.12,42.37,42.01,42,41,40,41,43,47,49,52,52,52,54,54,55,57,58,60,65,71,78,84,86,86,85,84,83,81,81,79,74,69,68,70,75,81,85,84,80,74,72,71,68,63,57,50,44,39,35,32,29,26,24.11,22.25,22.37,22.47,21.63,20.54,19.63,18.96,19,19.37,20,20.42,20.59,20.33,19.86,19.20,18.37,17.50,16.66,16,15.46,15.02,14.65,14.53,14.58,14.62,14.54,14.57,14.60,14.71,14.95,15.35,15.78,16.36,17.04,17.73,18.59,19.78,20.29,20.65,20.78,20.82,20.71,20.54,20.23,19.84,19.40,18.88,18.32,17.66,17.10,16.47,15.70,14.02,13.38,12.78,12.28,11.87,11.58,11.29,10.90,10.39,9.75,8.99,8.23,7.87,8.10,8.82,9.88,9.03,9,10,10,11.03,11.82,11.23,11.27,12,12.59,12.09,11.35,10.77,10.36,10.24,10.20,9.74,8.61,8,7.54,7.34,7.45,7.89,8.71,9.79,11.14,13.02,14.95,16.51,18,19.34,20.33,21.08,21.49,21.59,21.45,21.17,20.88,20.37,20.35,20.22,20.50,20.99,21.61,22.47,23.40,24.39,26.20,27.21,28.15,29.09,29.86,30.50,30.98,31.27,31.39,31.32,31.08,30.72,29.78,28.35,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-12,-12,-12,-12,-11,-11,-10,-9.63,-8.75,-7.86,-6.90,-6,-5.11,-4.25,-3.48,-2.75,-2.09,-1.42,-0.79,-0.09,0.59,2,3.75,6.10,8.01,10.35,12.75,14.98,15,13,17,22,24,24,22,19,17,15,15,15,14,13,13,13,13,13,13,13,12,12,12,12,12,12,13,14,15,14,14,14,14,14,15,15,18,23,29,32.17,33.60,31.34,26.28,22.12,18.49,15.38,12.77,10.67,9.12,8.17,7.88,8.13,8.77,9.60,10.39,10.79,11.21,10,11,12,13,13,12,14,15,16,17,18,19,20,21,23,26,30,36,44,53,53.64,51.63,49.13,47.12,45.12,43.14,41.33,39.79,38.72,38.25,38.04,38.12,38.51,39.10,39.87,40.82,41.78,42.64,43.16,43.08,42.15,40.33,38.04,37.74,36.33,37,37,38,41,46,50,53,53,52,52,53,52,52,54,56,59,64,72,79,84,86,86,85,85,85,85,84,80,74,70,69,71,77,82,83,81,78,72,69,66,63,58,54,49,43,38,34,32,29,27,25.17,24.88,24.58,24.49,22.91,21.73,20.67,20,20.01,20.63,21.51,22.92,22.46,22.10,21.39,20.50,19.49,18.42,17.48,16.66,16.04,15.60,15.20,15.03,15.03,15,14.87,14.75,14.70,14.66,14.77,14.97,15.25,15.73,16.29,16.91,18.37,18.92,19.46,19.79,20.04,20.22,20.22,20.01,19.82,19.60,19.27,18.79,18.24,17.62,17.07,16.34,15.60,14.72,13.08,12.35,11.74,11.21,10.82,10.46,10.09,9.71,9.22,8.70,8.28,8.07,8.10,8.34,8.37,7.47,8.22,8.38,9.03,9.62,9.74,9.38,9.47,10.37,10.62,10.38,9.66,9.07,8.73,8.72,8.74,8.57,8.25,7.90,7.63,7.60,7.78,8.34,9.20,10.34,11.72,13.92,15.57,17.25,18.91,20.41,21.54,22.41,22.92,23.07,22.99,22.74,22.42,22.21,22.04,21.70,21.91,22.37,23.39,23.72,25.15,25.53,27.08,28,28.92,29.78,30.53,31.14,31.59,31.85,31.85,31.62,31.12,30.46,29.14,27.11,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-11,-11,-10,-9.59,-8.63,-7.66,-6.72,-5.75,-4.87,-4.02,-3.37,-2.75,-2.23,-1.68,-1.12,-0.50,0.50,1.50,2.58,2.62,2.13,7.65,9.85,10,11,15,20,22,22,20,18,16,14,13,14,13,12,12,13,13,14,14,14,14,13,13,13,13,14,15,15,16,16,16,16,16,16,16,17,20,26,32,34.49,33.17,30.57,27.16,23.41,19.86,16.65,13.89,11.62,9.87,8.78,8.45,8.79,9.73,11,12.36,13.87,15.17,17,18,19,21,18,17,17,16,16,17,18,19,20,21,22,26,31,38,46,50,51,48.41,46.27,44.23,42.15,40.14,38.29,36.86,36.16,35.91,35.97,36.33,36.88,37.62,38.54,39.61,40.64,41.48,41.82,41.39,40.10,37.59,35.83,34.73,34.63,34.16,36,39,43,48,52,53,53,52,52,52,50,51,52,54,58,64,72,80,85,86,86,87,86,87,90,87,80,75,71,71,73,79,81,80,78,76,70,66,61,56,54,53,48,42,38,35,32,30,28.01,27.23,26.84,26.52,25.50,24.32,23.01,21.96,21.04,21.10,21.89,22.88,23.88,24.27,23.87,22.95,21.64,20.40,19.23,18.20,17.33,16.67,16.23,15.87,15.82,15.75,15.70,15.49,15.26,15.03,14.90,14.76,14.75,14.87,15.21,15.62,16.15,16.73,18.09,18.53,18.97,19.27,19.39,19.50,19.47,19.28,19.17,18.88,18.52,18.08,17.49,16.87,16.14,15.35,14.53,12.77,12,11.34,10.85,10.37,9.99,9.65,9.34,9.03,8.77,8.58,8.39,8.37,8.35,8.26,8.13,8.11,8.25,8.45,8.51,8.75,8.85,9,9.32,9.45,9.24,8.57,7.98,7.36,7.76,8.01,8.12,8.08,8,7.89,7.98,8.25,8.83,9.66,10.78,12.14,13.66,15.91,17.75,19.50,21.02,22.28,23.27,23.87,24.12,24.12,23.95,23.75,23.53,23.47,23.49,23.75,23.70,24.73,25.37,26.20,27.02,27.88,28.74,29.57,30.32,31,31.57,31.97,32.14,32.04,31.70,30.99,30,28.23,24.86,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.50,-8.50,-7.50,-6.47,-5.50,-4.66,-3.97,-3.37,-2.85,-2.36,-1.87,-1.38,-0.75,-0.28,0.20,0.73,2.14,3.87,5.99,7.86,10,14,18,19,19,17,16,14,13,12,13,12,12,12,13,14,16,18,17,16,16,15,14,14,15,17,17,18,18,18,18,18,18,19,20,24,30,37,36.64,32.97,29.99,26.92,23.75,20.51,17.40,14.65,12.34,10.52,9.38,9.08,9.61,10.85,12.58,14.82,17.03,19.64,22,24,26,27,24,22,20,17,16,17,18,20,21,22,24,27,32,37,42,45,46,44.92,43.27,41.36,39.28,37.22,35.40,34.12,33.85,33.70,33.97,34.50,35.23,36.13,37.25,38.50,39.75,40.73,41.10,40.62,39.25,37.33,35.22,33.85,33.49,35.32,38.15,42,47,50,52,52,51,51,51,50,49,50,51,54,58,64,72,80,86,88,89,89,89,90,92,87,81,76,73,73,76,79,79,77,76,74,69,62,57,52,51,51,47,41,37,35,33,31,30.07,29.25,28.67,28.09,26.88,25.59,24.34,23.29,22.67,22.63,23.12,23.97,24.89,25.85,26.23,24,22.36,20.99,19.77,18.73,17.88,17.29,16.90,16.66,16.65,16.63,16.60,16.29,16.29,15.62,15.25,14.89,14.70,14.67,14.78,15.07,15.48,15.97,17.08,17.71,18.09,18.37,18.60,18.73,18.77,18.63,18.57,18.38,18.14,17.70,17.12,16.58,15.85,15.01,13.53,13.21,11.82,11.12,10.57,10.12,9.85,9.63,9.47,9.26,9.08,8.91,8.77,8.67,8.61,8.57,8.38,8.26,8.22,8.21,8.24,8.32,8.41,8.60,8.75,8.76,8.61,8.26,7.75,7.50,7.54,7.87,8.11,8.24,8.29,8.37,8.50,8.84,9.37,10.21,11.25,12.52,13.99,16.13,17.84,19.63,21.20,22.50,23.57,24.26,24.65,24.76,24.75,24.67,24.60,24.59,24.67,24.90,25.34,25.83,26.37,27.08,27.84,28.58,29.28,30,30.62,31.21,31.66,32,32.11,31.95,31.41,30.62,29.37,27.28,23.57,-11,-11,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-11,-10,-9.38,-8.34,-7.26,-6.26,-5.37,-4.59,-3.90,-3.38,-2.88,-2.47,-2.09,-1.65,-1.42,-0.98,-0.25,0.78,1.89,3.01,4.53,8.98,11,14,15,15,15,14,11,10,11,12,12,12,12,13,15,18,21,20,19,18,17,16,16,17,19,20,21,21,22,22,21,21,22,23,26,32,36,34.96,32.20,29.23,26.34,23.42,20.53,17.65,15,12.72,10.92,9.84,9.62,10.26,11.75,14.03,16.99,20.73,21.75,24,27,31,31,29,27,22,17,17,18,20,24,26,27,29,30,33,36,39,40,42,41.84,40.60,38.75,36.65,34.66,33.01,31.90,31.74,31.73,32.12,32.77,33.65,34.74,36.04,37.64,39.21,40.47,41.07,40.67,39.32,37.26,34.90,33.35,33.08,35.63,39.41,44.62,48.98,51,51,50,50,50,50,49,48,49,51,54,58,65,72,81,87,90,91,92,91,91,90,87,82,78,77,78,78,78,76,74,73,71,66,57,52,48,49,49,44,39,36,34,34,33,31.86,30.63,30.87,29.51,28.11,26.75,25.53,24.62,24.07,23.96,24.25,24.82,25.53,26.84,26.25,24.15,22.57,21.21,20.07,19.07,18.34,17.87,17.62,17.58,17.62,17.63,17.60,17.49,17.16,16.76,15.73,15.17,14.79,14.53,14.47,14.60,14.90,15.28,15.72,16.70,16.67,17.01,17.71,17.87,17.92,17.89,17.88,17.77,17.48,17.11,16.61,16.04,15.36,14.58,13.73,12.32,11.58,10.92,10.47,10.14,9.96,10.39,10.45,10.27,10.10,9.88,9.70,9.37,9.15,8.91,8.75,8.60,8.46,8.36,8.32,8.33,8.37,8.48,8.53,8.53,8.46,8.27,8.13,8.12,8.13,8.27,8.53,8.74,8.90,9.03,9.23,9.51,10,10.74,11.66,12.86,14.22,15.62,17.79,19.34,20.89,22.28,23.35,24.12,24.64,24.96,25.12,25.22,25.28,25.41,25.62,25.87,26.21,26.72,27.17,27.73,28.41,29.02,29.61,30.15,30.64,31.09,31.42,31.66,31.66,31.38,30.87,29.98,28.58,26.38,23.32,-11,-12,-12,-13,-14,-14,-15,-15,-15,-15,-16,-16,-15,-15,-15,-14,-13,-13,-12,-11,-10,-9.25,-8.16,-7.12,-6.13,-5.23,-4.48,-3.88,-3.38,-2.93,-2.62,-2.29,-2.11,-1.63,-1,-0.25,0.40,1.08,1.91,1.28,7,10,11,13,13,11,9,8,10,10,11,13,13,13,15,17,20,21,21,21,19,18,18,20,22,24,24,25,26,26,25,25,26,28,29,31,34,33.67,31.47,28.45,25.49,22.84,20.21,17.54,14.98,12.67,10.89,9.83,9.75,10.67,12.49,14.95,18.01,22.13,22.26,23,27,29,30,30,27,21,17,17,19,24,29,33,35,36,36,38,40,40,39,40,39.95,38.57,36.67,34.57,32.60,31.09,30.12,30.07,30.14,30.59,31.29,32.29,33.54,35.12,37.09,38.99,40.64,41.76,41.62,39.92,37.62,35.11,33.17,33.24,35.39,39.26,45.25,48.59,49.98,49,49,50,50,49,48,47,48,50,54,59,67,75,82,87,89,91,90,89,88,85,84,81,80,81,81,78,76,74,72,71,69,64,54,48,45,45,44,39,36,34,33,32,31.91,31.23,31.35,31.46,30.50,28.96,27.61,26.51,25.73,25.25,25.10,25.17,25.40,25.67,25.62,24.98,23.76,22.39,21.15,20.12,19.25,18.71,18.39,18.32,18.47,18.62,18.74,18.73,18.61,18.11,17.53,16.77,15.39,14.83,14.39,14.16,14.21,14.40,14.65,15.01,15.89,15.71,16.60,16.78,16.95,17.07,17.09,17.10,16.98,16.76,16.48,16,15.48,14.82,14.02,12.76,12.48,11.37,10.87,11.02,10.78,10.83,10.17,10.64,10.54,10.41,10.26,9.76,9.58,9.47,9.36,9.15,8.99,8.84,8.72,8.62,8.60,8.60,8.62,8.64,8.64,8.63,8.62,8.65,8.77,8.91,9.13,9.36,9.51,9.73,9.87,10.08,10.35,10.74,11.35,12.16,13.22,14.38,15.62,17.52,18.98,20.33,21.66,22.78,23.62,24.26,24.73,25.07,25.37,25.62,25.90,26.21,26.53,26.92,27.29,27.74,28.15,28.66,29.22,29.64,30.04,30.45,30.77,31,31.09,31,30.72,30.11,29.10,27.52,25.37,22.03,-11,-12,-13,-13,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-15,-14,-14,-13,-12,-11,-10,-9.11,-8,-6.91,-5.93,-5.09,-4.38,-3.79,-3.35,-3.01,-2.75,-2.52,-2.13,-1.64,-1.13,-0.65,-0.25,0.21,1.51,4.24,7,9,9,8,8,8,9,9,10,11,13,15,15,15,16,18,20,21,22,21,20,20,22,24,27,27,28,30,29,28,28,31,33,33,34,35,34.34,31.50,28.25,25.10,22.22,19.62,17.12,14.73,12.60,10.92,10,9.99,10.96,12.71,15.12,18,20.37,20.66,21,24,24,25,26,22,19,17,18,22,28,35,41,43,44,44,44,43,42,40,40,39.26,37.78,35.34,33.02,31.11,29.74,28.86,28.79,28.91,29.37,30.15,31.28,32.73,34.63,36.73,38.92,41,42.86,42.98,41.09,38.12,35.46,33.25,32.82,34.50,37.71,41.95,45.25,46.62,47,48,50,50,49,47,46,47,49,54,60,68,77,84,86,88,88,85,83,82,80,80,80,82,85,84,79,75,73,72,69,67,62,52,45,42,40,38,36,33,32,30,30,29.49,30.33,30.86,31.12,30.34,29.09,28.02,27.17,26.59,26.23,26.04,25.95,25.83,25.57,25.07,24.25,23.16,22,20.95,20,19.35,19,18.90,19.07,19.33,19.58,19.79,19.84,19.58,18.92,18.22,17.26,15.64,14.90,14.34,13.95,13.88,13.92,14.14,14.39,14.66,14.96,15.62,15.90,15.84,16.13,16.15,16.20,16.12,15.96,15.65,15.25,14.66,14.07,13.39,12.33,12.08,11.12,10.71,10.40,10.61,10.35,10.85,10.83,10.79,10.75,10.62,10.48,10.32,10.07,9.87,9.70,9.51,9.20,9.04,8.96,8.88,8.83,8.84,8.85,8.87,8.99,9.11,9.28,9.54,9.86,10.09,10.54,10.52,10.72,10.87,11.01,11.25,11.59,12.03,12.70,13.57,14.58,15.62,16.75,18,19.75,20.95,22,22.91,23.65,24.25,24.76,25.24,25.65,26.10,26.50,26.91,27.32,27.70,28.02,28.32,28.65,29.07,29.41,29.72,29.97,30.13,30.26,30.26,30.11,29.73,29.09,28.04,26.41,24.07,20.82,-11,-12,-13,-14,-14,-15,-16,-16,-16,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-12,-11,-10,-8.88,-7.77,-6.74,-5.76,-4.93,-4.24,-3.75,-3.38,-3.12,-2.88,-2.55,-2.18,-1.80,-1.52,-1.05,-0.16,1.03,2.45,5.12,7,8,10,11,10,10,12,12,12,14,17,17,17,17,18,20,22,23,22,22,22,24,27,30,32,33,34,33,31,32,35,37,38,39,39,36.29,32.88,28.64,25.29,22.15,19.35,16.78,14.48,12.46,10.89,10.01,10,10.87,12.41,14.46,17.46,17.79,18,19,19,18,18,20,18,16,17,20,25,32,39,46,50,50,49,47,45,43,41,40,39.76,38.39,35.79,32.61,30.34,28.90,28,27.92,28.08,28.53,29.37,30.59,32.23,34.17,36.39,38.78,41.27,43.50,44.63,41.75,38.36,35.48,33.13,32.09,32.85,35.10,37.72,40.15,42.22,44.14,47,48,48,47,45,45,45,47,53,61,70,77,81,82,83,79,76,74,73,75,78,82,86,88,86,81,76,73,71,67,64,59,50,44,41,39,37,34,32,30,28.09,28.27,28.59,29.02,29.72,29.87,29.49,28.71,28.02,27.50,27.08,26.83,26.62,26.36,26,25.48,24.77,23.89,22.86,21.75,20.59,19.91,19.50,19.35,19.45,19.75,20.12,20.50,20.75,20.71,20.25,19.54,18.73,17.70,15.87,15.01,14.33,13.87,13.60,13.51,13.64,13.85,14.04,14.26,14.50,14.75,15.08,15.21,15.27,15.27,15.23,15.07,14.75,14.34,13.78,13.27,12.67,11.85,11.28,10.86,10.51,10.33,10.70,10.84,10.89,10.95,10.99,11.01,10.98,10.84,10.63,10.46,10.32,10.14,9.97,9.79,9.37,9.65,9.17,9.48,9.17,9.23,9.34,9.50,9.72,10,10.36,10.73,11.12,11.51,11.74,12.09,11.96,12.09,12.25,12.47,12.83,13.33,13.98,14.77,15.59,16.59,17.97,18.58,19.53,21.24,22.12,22.91,23.63,24.27,24.88,25.47,26,26.50,27,27.41,27.79,28.11,28.26,28.51,28.78,29.09,29.25,29.34,29.40,29.40,29.33,29.09,28.65,27.99,26.96,25.32,22.75,18.71,-11,-12,-13,-14,-15,-15,-16,-17,-17,-17,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-12,-10,-9.78,-8.64,-7.53,-6.50,-5.53,-4.75,-4.18,-3.73,-3.41,-3.17,-2.90,-2.63,-2.29,-2.04,-1.42,-0.42,0.95,2.84,4.28,7,12,16,17,14,13,15,16,16,16,19,21,20,19,19,21,23,25,25,26,27,27,31,34,36,38,38,37,35,36,39,42,43,43,42,36.58,32.92,29.40,25.77,22.47,19.45,16.75,14.37,12.35,10.78,9.87,9.75,10.41,11.70,13.42,14.65,15.10,15.03,14.79,14,13,14,15,15,14,17,22,28,35,43,50,54,53,52,48,46,44,42,41,40.78,41,37.64,33.28,30.03,28.39,27.53,27.28,27.42,27.88,28.75,30.02,31.72,33.71,35.92,38.35,40.92,43.16,43.51,41.34,37.97,35.12,32.87,31.37,31.27,32.28,33.95,36.11,37.86,41.40,44,45,45,44,43,43,43,45,52,60,69,74,75,75,75,72,68,65,66,69,77,83,87,88,85,80,75,72,69,62,59,54,48,42,39,38,36,33,31,29.03,27.20,26.70,27.25,27.67,28.04,28.25,28.16,27.92,27.64,27.37,27.25,27.23,27.11,26.76,26.23,25.57,24.75,23.82,22.76,21.74,20.87,20.13,19.86,19.82,20.07,20.39,20.84,21.25,21.42,21.34,20.72,19.97,19.04,18.07,17.03,15.15,14.36,13.82,13.39,13.27,13.25,13.35,13.51,13.67,13.87,14.04,14.28,14.37,14.45,14.40,14.34,14.12,13.85,13.47,13,12.50,11.91,11.37,10.90,10.54,10.29,10.17,10.28,10.75,10.86,10.98,11.11,11.15,11.13,11.02,10.87,10.76,10.62,10.50,10.37,10.28,9.65,10.17,9.53,10.07,10.02,9.71,9.87,10.12,10.40,10.78,11.21,11.64,12.25,12.52,12.87,13.13,13.33,13.48,13.33,13.47,13.65,14.01,14.47,15.10,15.67,16.40,17.23,18.08,18.95,19.79,20.62,21.62,23,23.74,23.79,25.10,25.74,26.34,26.84,27.27,27.64,27.89,28,28.23,28.39,28.53,28.61,28.62,28.62,28.52,28.38,28.12,27.23,27.03,26.03,24.42,21.77,17.60,-11,-12,-13,-14,-15,-16,-16,-17,-18,-18,-19,-19,-19,-18,-18,-18,-17,-16,-16,-15,-14,-12,-11,-10,-9.50,-8.37,-7.25,-6.26,-5.41,-4.65,-4.15,-3.79,-3.50,-3.24,-2.97,-2.63,-2.27,-1.61,-0.55,0.87,2.70,5.40,9,14,18,18,17,16,18,20,19,19,22,23,22,21,20,22,25,28,29,29,31,31,32,36,38,40,41,40,39,39,42,45,46,45,40,35.60,31.73,28.83,26.33,22.83,19.62,16.76,14.25,12.11,10.42,9.32,9.02,9.62,10.72,11.85,12.62,12.76,12.27,11.41,11,12,12,13,13,14,18,26,33,40,46,52,55,54,53,49,46,44,42,41.01,41.72,42.03,37.82,33.67,30.25,28.12,27.11,26.92,27.02,27.49,28.34,29.60,31.22,33.14,35.28,37.54,39.75,41.52,41.58,39.67,37,34.41,32.26,30.65,30,30.25,31.27,33.24,35.99,39.40,42,43,41,40,40,39,40,44,50,59,67,69,66,65,66,62,59,58,60,66,74,79,83,82,79,75,72,69,65,55,50,48,42,39,37,36,34,32.02,30.24,28.40,26.74,26.14,25.97,26.24,26.47,26.66,26.79,26.86,26.85,26.95,27.12,27.33,27.34,27.01,26.46,25.75,24.89,23.96,22.98,22,21.24,20.73,20.37,20.37,20.61,20.96,21.41,21.76,21.89,21.64,21.02,20.24,19.24,17.49,16.34,15.34,14.51,13.85,13.42,13.15,13,13,13.14,13.24,13.36,13.48,13.62,13.65,13.66,13.62,13.50,13.32,13.01,12.65,12.25,11.83,11.37,10.90,10.50,10.23,10.07,10.28,10.45,10.57,10.71,10.90,11.08,11.16,11.16,11.11,11.07,10.99,10.88,10.78,10.74,10.71,10.66,10.65,10.66,9.86,10,10.23,10.46,10.76,11.16,11.62,12.58,13,13.39,13.74,14,14.23,14.37,14.46,14.50,14.52,14.62,14.76,15.02,15.40,15.79,16.33,16.99,17.67,18.42,19.24,20,20.79,21.59,22.37,23.98,24.09,25.37,26,26.54,26.98,27.32,27.50,27.61,27.76,27.87,27.89,27.89,27.24,27.12,26.99,26.79,26.57,26.23,25.85,25.42,23.98,21.46,17.49,-11,-12,-13,-14,-15,-16,-17,-18,-19,-19,-19,-20,-19,-19,-19,-19,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9.17,-8.10,-7.05,-6.11,-5.35,-4.75,-4.25,-3.88,-3.53,-3.22,-2.88,-2.40,-1.74,-0.75,0.50,2.15,4.50,8.71,11.98,15,17,17,18,20,23,22,21,23,25,23,22,22,24,27,30,33,34,36,35,35,34,36,37,40,40,39,39,41,43,45,43,39,32.20,29.77,27.26,25.03,22.54,19.66,16.95,14.49,12.35,10.62,9.41,8.90,9.13,9.88,10.72,11.26,11.42,11.20,11.35,11,12,12,13,13,15,20,28,35,41,45,47,51,53,52,50,47,44,42.07,41.11,42.65,42.16,37.28,33.36,29.98,27.99,26.98,26.71,26.83,27.25,28.02,29.21,30.72,32.52,34.53,36.60,38.39,39.47,39.33,37.95,35.78,33.48,31.46,29.97,29.10,28.97,29.50,31.17,33.50,36.29,39,39,38,36,35,34,36,41,48,57,63,63,59,58,57,56,53,54,57,62,69,74,75,74,71,67,64,63,57,48,43,41,38,36,35,34,33.03,31.53,29.79,28.04,26.37,25.37,24.82,24.75,24.89,25.09,25.34,25.61,25.90,26.27,26.67,27.09,27.25,27.09,26.63,26,25.20,24.28,23.37,22.49,21.75,21.23,20.90,20.84,21,21.35,21.76,22.08,22.14,21.82,21.22,20.42,19.42,18.39,16.57,15.59,14.74,14.01,13.54,13.17,12.97,12.90,12.90,12.97,12.99,13.09,13.09,13.08,13.02,12.98,12.82,12.60,12.32,11.98,11.60,11.20,10.78,10.46,10.13,9.91,9.79,9.78,9.92,10.09,10.48,10.72,10.89,11.01,11.10,11.12,11.12,11.09,11.03,11,11.01,11.02,10.13,10.12,10.16,10.71,11.25,11.47,11.64,11.45,11.92,12.46,13.60,14.09,14.54,14.95,15.21,15.40,15.53,15.60,15.58,15.52,15.50,15.50,15.62,15.83,16.04,16.39,16.87,17.46,18.09,18.79,19.54,20.34,21.12,21.92,22.73,23.71,24.97,25.62,26.14,26.59,26.87,27,27.12,27.25,27.27,27.12,26.58,26.42,26.29,26.17,26.02,25.87,25.62,25.76,25.21,24,21.86,18.37,-11,-12,-14,-15,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-13,-12,-11,-9.99,-8.88,-7.86,-6.90,-6.10,-5.38,-4.78,-4.28,-3.87,-3.47,-3.02,-2.53,-1.90,-1.09,-0.04,1.16,2.33,4.57,7.89,10,14,17,20,22,24,24,24,25,26,25,24,24,24,27,31,33,35,36,36,34,32,33,36,38,38,38,39,40,43,43,41,36,30,27.04,25.48,23.45,21.39,19.08,16.66,14.41,12.39,10.74,9.50,8.85,8.86,9.47,10.27,11.03,11.58,11.95,12.52,13,13,14,15,16,19,23,30,36,37,37,41,43,47,51,50,47,44.07,42.12,41.17,42.78,40.37,36.58,32.32,29.41,27.71,26.79,26.54,26.72,27.12,27.79,28.83,30.21,31.89,33.84,35.77,37.41,38.27,38.04,36.75,34.74,32.50,30.59,29.22,28.35,28.08,28.32,29.29,30.78,32.27,34,33,33,32,32,31,33,38,45,53,58,59,54,52,51,50,50,50,53,56,62,66,66,62,59,57,55,52,46,42,38,36,35,33,32.97,32.64,32.07,30.95,29.38,27.63,25.89,24.65,23.75,23.29,23.34,23.51,23.89,24.35,24.85,25.42,26.04,26.60,26.97,27.03,26.84,26.35,25.65,24.83,23.90,23.01,22.24,21.62,21.23,21.07,21.15,21.47,21.84,22.12,22.24,21.85,21.33,20.50,19.61,18.62,17.48,15.92,15.07,14.40,13.86,13.40,13.12,12.99,12.88,12.87,12.82,12.76,12.72,12.63,12.58,12.45,12.25,12,11.71,11.37,11,10.63,10.28,10,9.75,9.61,9.53,9.59,9.71,9.87,10.14,10.40,10.64,10.83,10.95,11.02,11.08,11.10,11.09,11.13,11.21,11.25,11.34,11.40,10.46,11.54,11.77,11.17,12.26,12.87,12.66,13.86,14.58,15.15,15.71,16.13,16.46,16.62,16.75,16.74,16.64,16.52,16.39,16.28,16.25,16.33,16.41,16.60,16.95,17.37,17.91,18.57,19.26,20,20.79,21.59,22.39,23.74,24.12,24.76,25.75,26.12,26.39,26.49,26.61,26.67,26.21,26.07,25.90,25.75,25.62,25.54,25.49,25.45,25.33,25.11,25.36,24.41,22.76,20.32,-11,-13,-14,-15,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-12,-11,-10,-9.65,-8.64,-7.72,-6.85,-6.03,-5.36,-4.75,-4.22,-3.72,-3.25,-2.75,-2.15,-1.47,-0.68,0.12,1.12,1.84,3.57,8.73,13,18,22,22,22,22,24,25,27,28,28,27,27,29,32,32,31,31,32,31,30,33,37,39,39,37,37,40,43,44,40,35,30,25.76,23.58,21.87,20,18.03,16.02,14.08,12.26,10.74,9.57,8.88,8.87,9.50,10.54,11.75,12.87,13.85,14.53,15,15,16,17,19,22,25,29,32,32,31,34,36,41,45,47,45.92,43.87,42.17,41.23,41.73,40.67,35.35,31.08,28.75,27.33,26.63,26.39,26.53,26.95,27.52,28.42,29.66,31.33,33.28,35.40,37.15,38.02,37.74,36.34,34.15,31.72,29.82,28.54,27.71,27.29,27.23,27.59,28.15,28.75,28,29,29,29,29,30,31,35,42,48,53,53,51,47,46,46,46,46,47,50,54,55,55,53,51,48,46,44,41,38,36,34,32,31.02,30.36,30.84,30.85,30.21,28.90,27.17,25.37,23.97,22.82,22.09,21.85,21.98,22.50,23.07,23.72,24.48,25.28,26.07,26.67,27.03,27.10,26.83,26.27,25.50,24.58,23.60,22.66,21.90,21.37,21.08,21.07,21.33,21.66,22,22.12,21.78,21.34,20.54,19.75,18.84,17.11,16.25,15.48,14.83,14.25,13.76,13.48,13.22,13.01,12.91,12.82,12.65,12.52,12.40,12.26,12.08,11.84,11.53,11.24,10.88,10.53,10.21,9.87,9.61,9.37,9.25,9.22,9.25,9.37,9.57,9.86,10.12,10.37,10.58,10.74,10.86,10.95,11,11.03,11.20,11.32,11.42,10.42,10.53,10.72,11.95,11.17,11.62,13,12.74,13.37,14.83,15.50,16.17,16.82,17.32,17.66,17.84,17.89,17.87,17.73,17.51,17.33,17.12,16.97,16.87,16.88,16.97,17.16,17.50,17.96,18.50,19.14,19.86,20.62,21.39,22.20,23.49,24.01,24.50,25.37,25.74,25.92,25.96,25.95,26.08,25.62,25.48,25.36,25.20,25.13,25.14,25.20,25.28,25.33,26.10,25.77,25.10,23.66,22.15,-12,-13,-14,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9.38,-8.43,-7.53,-6.68,-5.90,-5.17,-4.53,-3.99,-3.47,-2.93,-2.40,-1.88,-1.25,-0.63,0.12,0.71,1.82,5.48,10.86,16,20,20,19,20,22,26,29,32,32,31,30,32,33,31,28,27,27,26,28,32,37,41,40,37,36,38,42,44,41,36,30,24.75,22.13,20.38,18.64,16.92,15.23,13.54,12,10.64,9.60,8.99,9.03,9.77,11.12,12.96,14.74,16.08,16.96,17,18,19,20,21,23,24,26,27,26,26,28,30,33,36,39.98,42.88,43.82,41.76,39.88,38.62,37.57,33.53,30.49,28.13,27.10,26.57,26.35,26.38,26.75,27.27,27.97,29.12,30.73,32.98,35.75,37.91,38.92,38.50,36.76,34.25,31.50,29.37,28.08,27.20,26.64,26.45,26.37,26.37,26.37,26,27,27,27,28,29,30,33,39,44,47,47,45,44,43.98,43,43.01,43.01,44.01,46.01,47.01,49.01,49,47,45,44,42,40,38,36,34,32,30,28.32,28.79,29.28,29.53,29.22,28.17,26.57,24.75,23.25,22.02,21.12,20.61,20.57,21.15,21.79,22.60,23.52,24.54,25.58,26.49,27.14,27.49,27.46,27.07,26.33,25.33,24.14,23,22.02,21.29,20.86,20.66,20.91,21.24,21.61,21.79,21.57,21.24,20.52,19.82,19.01,17.52,17.24,15.87,15.24,14.67,14.22,13.84,13.52,13.25,13.13,12.91,12.74,12.53,12.36,12.12,11.86,11.57,11.25,10.88,10.53,10.20,9.86,9.52,9.26,9.08,8.95,8.88,8.95,9.03,9.23,9.36,9.52,10.09,10.28,10.49,10.64,10.77,10.89,10.99,11.17,10.36,11.34,11.52,11.89,11.98,11.10,11.52,12.04,13.52,13.35,14.74,15.24,16.39,17.17,17.89,18.50,18.90,19.08,19.14,19.08,18.84,18.54,18.21,17.95,17.70,17.50,17.45,17.41,17.51,17.76,18.13,18.61,19.22,19.88,20.62,21.39,22.13,22.90,24,24.66,25.09,25.38,25.53,25.59,25.64,25.29,25.15,25.02,24.92,24.84,24.87,24.99,25.17,25.40,25.60,26.51,26.41,25.89,24.64,21.85,-12,-13,-15,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-14,-13,-11,-11,-10,-9.13,-8.23,-7.30,-6.43,-5.63,-4.89,-4.25,-3.67,-3.14,-2.64,-2.16,-1.63,-1.05,-0.41,0.25,1.50,3.65,8.23,14,16,17,18,19,22,24,28,30,33,35,34,34,34,30,26,23.15,23.37,23.51,27.01,31,36.32,39.37,38.48,36.62,34.15,35,38,40,41,38,32,25.67,21.73,19.01,17.28,15.90,14.40,12.98,11.63,10.46,9.54,9.03,9.14,9.97,11.45,13.65,15.75,17.49,19.32,21,22,22,22,21,21,21,21,20,20,21,22,24,26,30,33.07,36.85,39.78,39.65,37.58,35.50,33.46,31.25,28.60,27.63,26.89,26.52,26.38,26.38,26.62,27.01,27.73,28.92,30.75,33.62,37.12,39.86,41.34,40.57,37.96,34.84,31.65,29.23,27.75,26.79,26.17,25.87,25.70,25.53,25.46,25,26,26,27,28,28,30,32,36,39.07,41.12,41.16,41.24,41.25,41.27,41.28,41.24,41.26,41.32,42.28,44,44.87,44.88,43.87,42.10,40.02,39,37,35,34,32,30,28.16,26.53,27.45,28,28.33,28.04,27.08,25.57,23.91,22.46,21.25,20.32,19.66,19.41,19.99,20.63,21.57,22.65,23.90,25.21,26.40,27.37,27.96,28.14,27.89,27.24,26.04,24.59,23.14,21.92,21.02,20.41,20.08,20.29,20.60,21,21.26,21.14,20.95,20.38,19.78,19.12,18.39,17.73,16.38,15.79,15.82,14.78,14.66,13.91,13.62,13.46,13.20,12.90,12.64,12.37,12.09,11.75,11.40,11.07,10.70,10.32,9.95,9.60,9.27,9,8.82,8.66,8.62,8.63,8.75,8.89,9.16,9.32,9.37,10.01,9.70,9.85,9.99,10.75,10.25,10.70,10.13,10.26,10.46,10.66,10.98,11.37,13,12.47,14.02,14.33,14.70,15.57,17.25,18.12,18.90,19.57,20.01,20.20,20.26,20.14,19.89,19.54,19.17,18.79,18.41,18.16,18,17.99,18,18.15,18.47,18.90,19.42,20.09,20.75,21.49,22.24,22.92,23.82,24.52,24.89,25.13,25.24,25.28,25.12,24.97,24.84,24.72,24.66,24.64,24.79,25.03,25.35,25.71,26.66,27.12,27.21,26.85,25.64,23.49,-12,-14,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9.75,-8.80,-7.88,-6.93,-6.05,-5.25,-4.51,-3.88,-3.36,-2.87,-2.38,-1.86,-1.26,-0.66,-0.13,0.71,1.83,6.01,10,12,16,18,21,21,22,23,27,31.82,35.59,35.41,34.32,31.25,28.07,24.87,22.14,20.17,22.09,24.83,28.96,31.96,33.99,33.25,31.87,31.09,31.46,32.71,35.27,37.25,37.32,33.41,26.99,22.20,18.89,16.63,14.96,13.61,12.37,11.22,10.13,9.26,8.79,8.88,9.76,11.36,13.38,15.62,17.73,20,21.42,22.33,22.25,21.25,19.88,18.91,18.14,17.17,16,17,17,18,19,21,24,26.89,29.82,32.67,34.58,33.49,31.58,30.38,28.65,27.70,27.03,26.88,26.70,26.54,26.51,26.58,26.83,27.35,28.70,31.27,35.12,39.39,43.11,45.22,43.41,39.50,35.57,31.87,29.24,27.52,26.52,25.88,25.51,25.29,25.14,25.07,25,25,26,27,27,28,29,31.10,33.78,36.01,37.32,38.37,38.85,39.14,39.37,39.50,39.50,39.27,39.33,39.97,41.02,41.99,42.10,41.28,39.78,38.22,36.12,34.91,33.01,31.98,31,29,27.36,26.51,26.46,26.86,27.08,26.67,25.64,24.32,22.86,21.54,20.46,19.54,18.91,18.60,19.03,19.67,20.65,21.92,23.37,24.91,26.38,27.63,28.42,28.66,28.51,27.90,26.58,24.74,22.98,21.58,20.52,19.79,19.28,19.26,19.78,20.15,20.52,20.50,20.45,20.01,19.61,19.09,18.49,17.88,17.32,16.75,16.22,15.67,14.76,14.70,14.12,13.77,13.47,13.12,12.83,12.50,12.12,11.75,11.37,10.98,10.58,10.14,9.76,9.40,9.10,8.83,8.61,8.46,8.37,8.37,8.48,8.62,8.70,8.79,9.36,9.12,9.82,10.01,9.61,10.40,10.59,10,11.15,11.45,10.54,10.82,11.17,11.62,12.15,12.84,14.48,15.12,15.26,17.03,17.98,18.96,19.79,20.50,20.99,21.14,21.25,21.12,20.85,20.46,20.03,19.62,19.12,18.86,18.63,18.52,18.58,18.66,18.90,19.28,19.79,20.38,21.04,21.73,22.41,23.10,24.01,24.48,24.79,24.98,25.10,25.12,24.95,24.76,24.62,24.57,24.57,24.62,24.87,25.21,25.64,26.11,27.41,27.78,28,27.75,26.91,25.16,-13,-14,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-15,-14,-13,-12,-12,-11,-10,-9.37,-8.38,-7.39,-6.43,-5.53,-4.75,-4.04,-3.50,-3,-2.50,-1.99,-1.39,-0.80,-0.24,0.25,1.95,4.50,7.20,11.66,15.40,18.32,19.25,19.51,20.39,21.61,25.70,30.15,33.13,31.51,30.12,28.38,26.07,23.37,20.88,19.60,19.87,22.32,25.03,27.42,28.29,27.95,27.03,26.53,27.15,28.78,30.97,33.86,34.88,31,26.88,23.01,19.76,16.84,14.84,13.35,12.15,11.08,10.09,9.25,8.77,8.83,9.53,10.91,12.64,14.59,16.60,18.72,20,20.88,20.86,19.42,18.04,16.77,15.60,14.63,14.32,14.01,14,15,15,16,18,20.12,23.26,25.38,27.27,28.01,28,27.71,27.46,27.15,27.24,27.17,27.08,26.96,26.87,26.79,26.75,27.25,28.75,31.98,36.82,42,47.84,49.04,45.92,40.67,36.12,32.03,29.28,27.52,26.42,25.75,25.35,25.14,25.04,25.01,25,25,26,26,26.97,27.13,28.28,30.24,32.25,34.03,35.47,36.46,37.12,37.50,37.70,37.71,37.59,37.41,37.37,37.75,38.70,39.95,40.40,39.37,37.83,36.23,34.65,32.87,31.13,30,28.97,27.98,26.57,25.75,25.50,25.59,25.58,25.03,24.11,22.95,21.67,20.61,19.64,18.87,18.27,17.95,18.33,18.95,19.96,21.32,22.89,24.62,26.34,27.72,28.42,28.52,28.26,27.58,26.12,24.17,22.36,20.89,19.82,19.02,18.46,18.38,18.57,19.17,19.53,19.65,19.71,19.41,19.16,18.86,18.39,17.89,17.48,17.01,16.50,16,15.50,15.03,14.57,14.10,13.73,13.37,13,12.62,12.25,11.83,11.37,10.95,10.50,10.09,9.66,9.28,8.98,8.66,8.46,8.27,8.20,8.16,8.25,8.37,8.45,8.57,8.73,8.89,9.08,9.25,10.07,10.28,9.87,9.99,10.14,10.37,10.64,10.99,12.59,11.87,13.60,14.22,14.88,14.88,15.77,17.64,18.64,19.64,20.53,21.27,21.76,22,22.09,21.99,21.67,21.32,20.86,20.41,19.82,19.48,19.27,19.13,19.12,19.25,19.48,19.79,20.27,20.82,21.42,22.08,22.90,23.57,24.08,24.49,24.77,24.99,25.03,25.01,25,24.66,24.52,24.49,24.54,24.72,25.02,25.47,26.60,27.37,27.95,28.41,28.70,28.54,27.88,27,-13,-15,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-14,-13,-12,-11,-10,-9.88,-8.87,-7.79,-6.75,-5.77,-4.91,-4.22,-3.63,-3.12,-2.63,-2.12,-1.53,-0.78,-0.39,0.12,1.37,3.85,6.86,10.21,13.99,15.88,16.66,17.45,18.54,20.87,23.83,27.36,27.77,27.39,26.29,25.08,23.84,21.57,19.50,18.11,18.25,19.62,21.51,22.97,23.57,23.21,22.35,22.25,23.07,24.75,26.87,29.03,29.75,28.61,26.23,23.34,20.32,17.61,15.11,13.42,12.17,11.08,10.09,9.27,8.75,8.75,9.32,10.37,11.77,13.25,14.77,15.95,16.75,17.25,17.25,16.72,15.77,14.63,13.48,12.78,12.49,12.40,12.01,13,13,13,14,16.14,17.32,19.45,21.54,23.33,24.57,25.42,26.26,27.12,27.70,27.85,27.67,27.50,27.45,27.41,27.32,27.71,29.38,33.11,38.50,44.35,50.82,51.01,46.45,41.02,36.21,32.11,29.38,27.67,26.54,25.85,25.36,25.13,25.04,25,25.10,25.86,25.78,25.98,26.21,26.73,27.86,29.37,31.07,32.62,33.91,34.95,35.62,36,36.10,36,35.77,35.58,35.58,36.07,37.16,38.27,39.15,37.65,36.07,34.47,32.78,31.02,29.33,28.02,27.12,26.02,25.46,24.77,24.37,24.22,23.98,23.45,22.63,21.64,20.62,19.63,19,18.34,17.77,17.45,17.78,18.37,19.38,20.73,22.37,24.14,25.97,27.24,27.73,27.61,27.15,26.25,24.76,22.96,21.28,19.89,18.87,18.11,17.57,17.41,17.47,18.08,18.39,18.59,18.71,18.61,18.50,18.35,18.04,17.71,17.41,17.09,16.60,16.16,15.73,15.27,14.77,14.34,13.90,13.53,13.16,12.75,12.35,11.87,11.39,10.95,10.48,10.01,9.62,9.23,8.87,8.59,8.35,8.15,8.07,8.01,8.09,8.21,8.26,8.39,8.53,8.72,8.91,9.67,9.37,9.60,9.86,10,10.22,10.49,11.90,11.15,11.59,12.12,12.76,13.52,14.40,15.27,17.21,17.25,19.25,20.22,21.17,21.92,22.46,22.71,22.82,22.71,22.42,22.03,21.61,21.15,20.73,20.11,19.92,19.77,19.74,19.83,20.02,20.37,20.82,21.35,21.91,22.52,23.13,23.73,24.24,24.62,24.89,25.07,25.09,25,24.95,24.63,24.53,24.50,24.62,24.84,25.24,26.50,27.10,27.74,28.37,28.88,29.14,28.97,28.37,26.87,-13,-15,-17,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-14,-13,-12,-11,-11,-10,-9.17,-8.11,-7,-6,-5.10,-4.34,-3.73,-3.22,-2.75,-2.26,-1.75,-1.15,-0.49,0.39,1.73,3.62,6,8.70,11.17,13.15,14.51,15.37,16.79,19.03,21.75,23.24,23.82,23.45,22.54,21.87,21,19.51,17.87,16.62,16.45,17.29,18.60,19.57,19.84,19.38,18.87,18.87,19.71,21.22,22.98,24.48,25.46,25.61,25.51,23.35,20.45,18.03,15.88,13.76,12.37,11.16,10.15,9.38,8.87,8.85,9.26,10.02,10.97,11.91,12.76,13.26,13.83,14.25,14.40,14.22,13.70,12.87,11.98,11.47,11.23,11.14,11.20,11,11,11,12,13.20,13.36,14.48,16.59,19.59,21.49,23.22,25,27.17,28.88,28.64,28.13,28.08,28.12,28.23,28.40,28.71,30.37,34.16,39.78,46.07,52,50.15,45.96,40.84,35.90,32.34,29.88,28.27,27.15,26.34,25.66,25.26,25.01,25,25.25,25.59,25.63,25.61,25.74,26.25,27.25,28.58,30.01,31.40,32.64,33.62,34.27,34.60,34.59,34.37,34.12,33.85,33.90,34.50,35.50,36.76,36.87,35.84,34.40,32.83,31.12,29.37,27.49,26.39,25.27,24.83,24.26,23.79,23.36,23.03,22.66,22.14,21.48,20.73,19.91,19.14,18.50,18.08,17.50,17.12,17.37,17.87,18.83,20.10,21.65,23.36,24.98,26.07,26.45,26.32,25.73,24.62,23.12,21.45,19.88,18.63,17.72,17.03,16.57,16.40,16.38,16.87,17.16,17.37,17.57,17.59,17.61,17.58,17.45,17.25,17.09,16.88,16.48,16.12,15.75,15.34,14.83,14.39,14,13.64,13.25,12.85,12.37,11.89,11.40,10.91,10.46,10,9.58,9.16,8.84,8.51,8.26,8.10,7.98,7.91,7.97,8.08,8.15,8.26,8.41,8.62,8.84,9.07,9.33,9.60,9.87,10.11,11.21,10.62,10.96,11.35,11.84,12.40,13.10,13.89,15.41,15.64,16.73,17.60,19.77,20.75,21.65,22.45,22.99,23.25,23.38,23.32,23.04,22.67,22.27,21.85,21.41,20.74,20.53,20.45,20.37,20.41,20.62,20.89,21.32,21.78,22.34,22.88,23.48,24.02,24.50,24.86,25.08,25.16,25.14,25.03,24.92,24.67,24.58,24.54,24.71,24.96,25.88,26.62,27.27,27.98,28.62,29.11,29.27,29,28.23,26.87,-14,-15,-17,-18,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-13,-13,-12,-11,-10,-9.39,-8.27,-7.15,-6.12,-5.16,-4.39,-3.77,-3.27,-2.87,-2.46,-1.91,-1.33,-0.55,0.40,1.64,3.21,5.12,7.25,9.34,11.15,12.62,13.88,15.25,16.87,18.58,19.76,20.11,19.97,19.50,18.78,18.13,17.13,16,15.04,14.84,15.37,16.25,16.91,17.13,16.79,16.50,16.58,17.20,18.33,19.64,20.82,21.62,22.21,22.34,21.61,20.03,18.26,16.45,14.52,12.67,11.35,10.36,9.59,9.13,9.09,9.37,9.85,10.35,10.84,10.95,11.24,11.60,11.92,12.15,12.22,12.04,11.62,11.10,10.73,10.59,10.50,10.45,10.17,10,10,11,11.22,12.37,13.37,14.61,16.64,18.66,20.78,23.29,25.98,27.67,28.01,28.14,28.35,28.75,29.08,29.36,29.86,31.10,34.62,40.29,47.14,51.16,49.27,44.70,40.11,35.84,32.83,30.76,29.29,28.21,27.23,26.28,25.36,25.15,25.12,25.13,25.14,25.14,25.21,25.37,25.88,26.75,27.87,29.10,30.28,31.40,32.37,33,33.23,33.12,32.87,32.57,32.38,32.46,32.89,33.77,34.50,34.73,34.12,32.91,31.39,29.74,27.97,26.41,25.12,24.21,23.35,23.32,23.01,22.75,22.32,21.87,21.33,20.84,20.35,19.87,19.36,18.77,18.09,17.53,16.98,17.03,17.38,18.20,19.34,20.75,22.22,23.52,24.46,24.98,24.98,24.37,23.14,21.51,19.79,18.28,17.16,16.37,15.84,15.41,15.32,15.27,15.37,15.73,15.78,16.36,16.48,16.58,16.63,16.63,16.57,16.51,16.38,16.10,15.83,15.50,15.13,14.70,14.27,13.97,13.62,13.24,12.82,12.36,11.87,11.37,10.87,10.39,9.97,9.52,9.13,8.78,8.50,8.25,8.07,7.91,7.87,7.88,8,8.12,8.23,8.39,8.59,8.82,9.08,9.34,9.63,9.95,10.24,10.50,10.79,11.16,11.60,12.10,12.75,13.46,14.29,15.87,16.03,18.15,19.22,20.23,21.17,22.03,22.85,23.38,23.73,23.87,23.79,23.60,23.25,22.88,22.48,22.09,21.37,21.16,21.10,21.01,21.07,21.22,21.48,21.84,22.25,22.75,23.26,23.83,24.35,24.75,25.07,25.24,25.28,25.24,25.11,24.95,24.85,24.62,24.60,24.75,25.02,25.62,26.64,27.32,28,28.60,29,29,28.51,27.58,25.88,-14,-16,-17,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-13,-13,-12,-11,-10,-9.50,-8.37,-7.23,-6.13,-5.17,-4.39,-3.77,-3.29,-2.89,-2.48,-2,-1.37,-0.55,0.38,1.50,2.83,4.37,6.12,7.89,9.53,10.96,12.16,13.32,14.46,15.58,16.42,16.85,16.86,16.60,16.12,15.51,14.84,14.08,13.49,13.38,13.77,14.38,14.89,15.12,14.97,14.87,14.97,15.39,16.14,17,17.77,18.21,18.86,19.22,19.26,19.03,18.46,17.01,15.02,13.03,11.62,10.62,9.96,9.62,9.57,9.70,9.88,10.10,10.09,10.23,10.37,10.64,10.95,11.11,11.16,11.12,11,10.75,10.50,10.33,10.25,10.16,10.08,10,10,10,10.77,11.37,12.12,13.20,14.37,15.75,18.25,20.78,23.12,24.99,26.34,27.29,28.14,29.08,30.12,29.98,30.34,31.29,34.27,39.57,45.37,49.47,46.59,42.84,39.22,35.75,33.67,32.12,30.79,29.62,28.48,27.26,25.64,25.63,25.32,25.03,24.85,24.73,24.71,24.87,25.36,26.12,27.12,28.20,29.25,30.24,31.01,31.52,31.75,31.63,31.40,31.12,30.97,31.08,31.50,32.15,32.76,33.08,32.75,31.82,30.37,28.62,26.87,25.45,24.36,23.46,22.49,22.77,22.83,22.60,22.22,21.72,21.23,20.92,20.76,20.54,20.21,19.62,18.77,17.77,17,16.75,16.83,17.41,18.50,19.75,21,22.02,22.79,23.32,23.58,23.24,21.85,20.02,18.12,16.58,15.52,14.96,14.50,14.24,14.14,14.16,14.25,14.39,14.61,14.75,14.99,15.10,15.61,15.67,15.72,15.72,15.67,15.50,15.28,15.03,14.73,14.37,14.01,13.74,13.40,13.07,12.65,12.23,11.75,11.27,10.82,10.36,9.89,9.50,9.12,8.78,8.50,8.25,8.07,7.91,7.87,7.87,7.98,8.12,8.24,8.39,8.60,8.85,9.12,9.42,9.75,10.54,10.41,10.72,11.04,11.47,11.91,12.45,13.12,13.86,14.72,16.21,16.45,18.52,18.46,20.62,21.60,22.41,23.17,23.72,24.10,24.25,24.25,24.04,23.77,23.46,22.63,22.35,22.16,21.82,21.75,21.66,21.70,21.82,22.02,22.34,22.77,23.14,23.61,24.21,24.70,25.04,25.29,25.40,25.39,25.28,25.12,24.95,24.77,24.64,24.62,24.74,25.34,25.92,26.49,27.12,27.75,28.26,28.52,28.36,27.66,26.41,23.98,-14,-16,-17,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-15,-15,-14,-13,-13,-12,-11,-10,-9.55,-8.38,-7.15,-6.03,-5.05,-4.27,-3.68,-3.25,-2.84,-2.38,-1.88,-1.23,-0.43,0.45,1.40,2.51,3.77,5.21,6.71,8.12,9.37,10.39,11.28,12.12,12.79,13.50,13.95,14.11,14.01,13.72,13.17,12.73,12.27,12,12.04,12.42,12.95,13.40,13.64,13.60,13.65,13.79,14.08,14.50,14.99,15.42,15.52,15.92,16.48,17.25,17.92,18.64,17.25,15.47,13.49,11.96,10.96,10.40,10.17,10.11,10.13,10.17,10.10,10.13,10.22,10.34,10.51,10.74,10.92,11.08,11.14,11.11,11,10.88,10.72,10.59,10.48,10.38,10,10,10,10.20,10.36,11.21,11.59,12.87,13.13,16.03,18.47,20.73,22.83,24.65,26.21,27.53,28.73,29.88,30.12,30.23,30.76,32.97,37,42.27,42.73,42.08,40.17,38,36,34.98,33.77,32.28,31.14,29.99,28.75,27.41,26.36,25.59,24.97,24.51,24.26,24.23,24.38,24.83,25.50,26.37,27.32,28.24,29.09,29.75,30.16,30.33,30.25,30.07,29.78,29.63,29.75,30.13,30.77,31.48,31.95,31.96,31.27,30,28.27,26.23,25.03,24.09,23.25,22.62,22.91,23.02,22.85,22.50,22.09,21.76,21.72,21.75,21.73,21.48,20.85,19.83,18.57,17.29,16.26,16.20,16.64,17.58,18.73,19.83,20.53,21,21.50,21.99,21.92,20.61,18.57,16.53,14.87,13.91,13.48,13.15,13.03,13.02,13.20,13.35,13.46,13.65,13.75,13.95,14.04,14.15,14.29,14.79,14.57,14.85,14.73,14.58,14.37,14.16,13.87,13.62,13.37,13.10,12.75,12.39,12,11.59,11.13,10.71,10.26,9.87,9.49,9.12,8.83,8.52,8.27,8.11,7.98,7.89,7.90,8,8.12,8.33,8.48,8.71,8.96,9.25,9.57,9.89,10.77,10.62,11,11.37,11.78,12.27,12.87,13.53,14.33,15.13,16.03,16.88,17.89,20,20.99,21.95,22.72,23.37,24,24.38,24.57,24.61,24.48,24.24,23.96,23.63,23.32,22.60,22.62,22.39,22.33,22.33,22.39,22.54,22.85,23.13,23.63,24.08,24.50,24.97,25.25,25.47,25.53,25.48,25.33,25.11,24.88,24.73,24.62,24.57,24.65,24.99,25.64,26.15,26.74,27.27,27.65,27.75,27.42,26.52,24.99,22.12,-14,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-15,-14,-13,-13,-12,-11,-10,-9.39,-8.18,-7,-5.88,-4.97,-4.18,-3.63,-3.15,-2.68,-2.21,-1.63,-0.93,-0.17,0.63,1.49,2.38,3.38,4.51,5.72,6.87,7.87,8.67,9.36,9.91,10.50,10.97,11.47,11.75,11.84,11.66,11.22,10.98,10.75,10.71,10.96,11.39,11.91,12.37,12.66,12.64,12.78,12.91,13.11,13.34,13.57,13.77,13.72,13.92,14.47,15.50,16.39,16.99,16.88,15.32,14,12,11,10.92,10.86,10.78,10.66,10.67,10.67,10.70,10.73,10.83,10.99,11.25,11.53,11.87,12.17,12.34,12.24,12.01,11.66,11.34,11.03,10.83,11,10,10,10.14,10.32,10.48,11.35,12.08,13.17,14.64,16.65,18.87,21.13,23.25,25.14,26.78,28.13,29.07,29.57,29.74,29.86,31.17,33.86,36.12,37.49,37.72,37.45,37,37.87,36.66,34.83,33.58,32.48,32,30,28.51,26.97,25.75,24.87,24.25,23.88,23.78,23.95,24.34,24.91,25.64,26.47,27.25,27.95,28.50,28.85,28.97,28.91,28.78,28.63,28.57,28.60,29,29.66,30.50,31.24,31.66,31.36,30.32,28.77,27.21,25.87,24.87,23.87,23.57,23.70,23.59,23.35,23.08,22.83,22.77,22.91,23.12,23.20,22.98,22.24,20.98,19.49,17.97,16.54,15.64,15.98,16.71,17.74,18.62,18.90,19.03,19.26,19.63,19.86,18.92,17.29,15,13.70,12.41,12.01,12.13,11.77,12.24,12.49,12.66,12.84,13.04,13.08,13.24,13.27,13.35,13.50,13.72,13.78,13.87,13.86,13.82,13.70,13.51,13.35,13.12,12.90,12.66,12.39,12.10,11.75,11.37,10.99,10.60,10.21,9.84,9.49,9.14,8.87,8.60,8.37,8.16,8.07,8,8,8.08,8.21,8.37,8.62,8.83,9.10,9.39,9.75,10.11,10.90,10.85,11.79,11.74,12.16,12.72,13.35,14.03,14.77,15.62,16.51,18.25,19.37,20.37,21.34,22.24,23,23.65,24.26,24.64,24.87,24.91,24.85,24.67,24.46,23.73,23.50,23.29,23.21,23.03,22.95,22.90,22.96,23.10,23.25,23.50,24,24.37,24.75,25.12,25.37,25.50,25.57,25.48,25.29,25.03,24.76,24.60,24.47,24.45,24.51,24.72,25.23,25.65,26.13,26.54,26.83,26.75,26.27,25.25,23.47,20.27,-15,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-14,-13,-13,-12,-11,-10,-9.13,-7.91,-6.75,-5.66,-4.76,-4.04,-3.50,-3.01,-2.50,-1.92,-1.27,-0.54,0.23,1,1.75,2.50,3.27,4.12,4.99,5.84,6.59,7.20,7.64,8.09,8.58,8.92,9.49,9.87,10.09,10.09,9.75,9.64,9.66,9.88,10.34,10.87,11.45,11.89,12.21,12.16,12.33,12.42,12.51,12.62,12.71,12.78,12.60,12.83,13.39,14.20,14.87,15.24,15.07,14.49,14,12,12,11.10,11.16,11.24,11.41,11.50,11.60,11.65,11.71,11.77,12,12.41,13.03,13.71,14.27,14.50,14.36,13.87,13.17,12.41,11.79,11.36,10.99,11,11,10.12,10.28,10.75,11.24,11.96,12.90,14.20,15.75,17.66,20,22.24,24.33,26.14,27.59,28.58,29.09,29.20,29,29.39,30.60,31.91,33.03,34.03,35.02,36.12,37.62,36.50,35.38,34.12,33,31.73,30.39,28.64,27.07,25.73,24.73,24,23.60,23.45,23.53,23.87,24.37,24.99,25.64,26.32,26.87,27.33,27.61,27.72,27.72,27.63,27.58,27.61,27.75,28.09,28.86,29.87,30.87,31.62,31.78,31.08,29.88,28.52,27.36,26.37,25.60,25,24.75,24.38,24.02,23.83,23.87,24.11,24.39,24.66,24.74,24.42,23.47,22.03,20.41,18.72,17.09,15.73,15.23,15.96,16.85,17.37,17.21,16.84,16.85,17.26,17.52,17.50,16.75,14.63,13.36,12.01,12,12,12.08,11.71,12.22,12.53,12.70,12.78,12.85,12.95,12.89,12.87,13.01,13.16,13.21,13.22,13.22,13.12,13.02,12.90,12.76,12.62,12.46,12.25,12.01,11.75,11.49,11.15,10.85,10.50,10.15,9.84,9.50,9.23,8.96,8.71,8.49,8.32,8.16,8.12,8.12,8.16,8.28,8.49,8.72,9,9.32,9.61,10.12,10.60,10.73,11.50,11.54,12.04,12.62,13.20,14.25,14.49,15.26,16.65,17,17.87,18.78,19.76,20.67,22.51,23.28,23.95,24.51,24.89,25.12,25.24,25.21,25.10,24.91,24.67,24.45,23.90,23.92,23.64,23.52,23.47,23.57,23.50,23.63,24.01,24.26,24.54,24.86,25.17,25.37,25.48,25.48,25.37,25.16,24.90,24.62,24.37,24.24,24.20,24.25,24.40,24.71,25.01,25.37,25.65,25.78,25.64,25.10,24.02,22.12,18.38,-15,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-15,-14,-14,-13,-13,-12,-11,-10,-8.78,-7.59,-6.41,-5.39,-4.54,-3.88,-3.36,-2.83,-2.26,-1.63,-0.89,-0.10,0.75,1.53,2.26,2.91,3.50,4.09,4.65,5.21,5.70,6.09,6.41,6.77,7.23,7.49,8.08,8.54,8.92,9.17,8.95,9.17,9.50,9.92,10.50,11.12,11.67,12.10,12.37,12.25,12.37,12.45,12.48,12.50,12.52,12.53,12.34,12.58,12.95,13.38,13.75,13.90,13.86,13.64,13,12,12,12.11,12,12.08,12.25,12.54,12.87,13.14,13.29,13.34,13.51,14.36,15.54,16.50,16.99,17.11,16.75,15.91,14.70,13.52,12.58,11.87,11.04,11.01,11,10.96,10.87,11.09,11.46,12.07,12.95,14.12,15.52,17.23,19.38,21.64,23.82,25.73,27.25,28.29,28.83,28.88,28.60,28.24,28.45,29.11,30.22,31.59,33.15,34.85,36.37,36.16,35.11,33.96,32.62,31.15,29.64,28.12,26.65,25.41,24.45,23.75,23.33,23.13,23.21,23.46,23.86,24.37,24.89,25.45,25.88,26.25,26.48,26.59,26.62,26.62,26.65,26.78,27.12,27.61,28.37,29.52,30.75,31.75,32.28,32.03,31.14,30.12,29.08,28.14,27.37,26.65,25.99,25.35,24.95,24.91,25.26,25.62,26,26.25,26.26,25.70,24.46,22.90,21.25,19.48,17.71,16,14.91,14.91,15.77,16.58,15.29,14.67,14.71,14.74,15.67,16.58,17.41,17.79,15,14,13,13,13,12.11,12.57,13.12,13.25,13.22,13.12,13.03,12.95,12.74,12.77,12.84,12.75,12.64,12.64,12.52,12.45,12.34,12.25,12.15,12.01,11.87,11.71,11.50,11.27,11.01,10.75,10.48,10.16,9.87,9.61,9.34,9.09,8.86,8.63,8.48,8.35,8.26,8.25,8.33,8.41,8.61,8.84,9.12,9.46,9.83,10.23,10.63,11.10,11.62,11.95,12.46,12.99,13.95,14.54,14.95,15.71,17.12,17.46,19.12,20.12,21.10,21.98,22.83,23.54,24.16,24.72,25.11,25.37,25.50,25.51,25.47,25.36,25.16,24.98,24.75,24.50,24.25,24.12,23.99,23.91,24.09,24.14,24.28,24.46,24.64,24.87,25.10,25.23,25.29,25.26,25.13,24.91,24.66,24.38,24.12,23.96,23.87,23.89,24,24.23,24.47,24.70,24.87,24.87,24.63,24,22.91,20.91,17.53,-15,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-16,-15,-15,-14,-14,-13,-12,-11,-10,-9.64,-8.38,-7.14,-6.02,-5.05,-4.27,-3.65,-3.14,-2.61,-2,-1.29,-0.50,0.39,1.33,2.22,3,3.65,4.13,4.50,4.82,5.08,5.32,5.51,5.75,6.10,6.51,6.75,7.39,8.01,8.62,9.21,9.32,9.98,10.60,11.15,11.73,12.27,12.75,13.09,13.22,13,13.03,13,12.92,12.89,12.87,12.83,12.66,12.82,12.99,13.17,13.32,13.32,13.21,13.11,13,13,13,12.87,12.79,12.79,13.14,13.75,14.49,15.14,15.61,15.86,16.21,17.42,18.73,19.59,20.12,20,19.49,18.12,16,14.46,13.21,12.37,11.90,11.95,11.97,11.25,11.51,11.65,11.89,12.38,13.24,14.39,15.77,17.38,19.34,21.50,23.62,25.59,27.17,28.28,28.85,28.87,28.51,27.76,27.37,27.53,28.59,29.92,31.50,33.36,34.24,34.60,34.25,33.24,31.83,30.25,28.75,27.34,26.03,24.96,24.08,23.45,23.02,22.87,22.88,23.09,23.39,23.83,24.25,24.65,25,25.27,25.47,25.60,25.70,25.78,25.97,26.23,26.65,27.37,28.34,29.52,30.87,32.12,32.87,33,32.53,31.75,30.88,30.02,29.20,28.33,27.38,26.39,26.07,26.40,26.84,27.24,27.57,27.85,27.61,26.71,25.20,23.57,21.89,20.22,18.26,16.33,14.33,14.01,15,14,13,13,13,14,16,17,20,21,18,16,16,15,15,14,14.12,14.46,14.78,14.46,14.12,13.89,13.62,13.23,13,12.89,12.63,12.38,12.34,12.13,12,11.87,11.90,11.87,11.75,11.63,11.50,11.37,11.21,11,10.76,10.51,10.26,10,9.75,9.50,9.25,9.02,8.85,8.65,8.53,8.48,8.46,8.50,8.60,8.75,8.98,9.25,9.60,9.98,10.37,10.84,11.28,11.70,12.38,13.08,13.73,13.77,14.40,16.01,15.96,16.82,18.67,18.73,20.59,21.50,22.37,23.15,23.84,24.37,24.88,25.29,25.60,25.79,25.90,25.95,25.88,25.76,25.59,24.98,25.12,24.79,24.60,24.57,24.48,24.23,24.41,24.46,24.53,24.63,24.79,24.95,25,25.01,24.96,24.82,24.62,24.36,23.98,23.78,23.62,23.52,23.52,23.60,23.74,23.88,24.03,24.12,24.03,23.75,23.10,22,20,16.72,-14,-16,-17,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-16,-15,-15,-14,-14,-14,-13,-12,-11,-10,-9.22,-7.87,-6.63,-5.55,-4.65,-3.92,-3.38,-2.91,-2.36,-1.73,-0.97,-0.11,0.86,1.88,2.92,3.88,4.63,5.12,5.37,5.47,5.48,5.49,5.50,5.64,5.95,6.39,6.74,7.52,8.37,9.29,10.26,10.95,12.01,12.87,13.50,13.98,14.37,14.72,14.87,14.77,14.46,14.26,14.04,13.85,13.73,13.65,13.57,13.46,13.48,13.52,13.60,13.61,13.57,13.42,13.21,13.12,13.11,13.07,13.14,13.20,13.26,14,14.96,16.26,17.49,18.45,19.12,19.98,21.04,22.04,23.23,22.87,22.02,20.77,19.11,16.91,15.15,13.75,12.95,12.12,12.09,12.04,12.21,12.24,12.46,12.64,13.09,13.85,15.01,16.35,17.89,19.72,21.73,23.77,25.71,27.34,28.57,29.17,29.12,28.65,27.92,27.17,26.96,27.54,28.59,29.84,31.16,32.22,32.77,32.86,32.21,30.85,29.32,27.84,26.50,25.37,24.41,23.65,23.12,22.76,22.62,22.62,22.78,23.07,23.38,23.74,24.01,24.26,24.47,24.62,24.75,24.89,25.12,25.39,25.82,26.37,27.21,28.32,29.63,31.12,32.61,33.62,34.07,33.91,33.38,32.66,31.89,31.01,30,28.98,27.90,27.62,28.12,28.52,28.87,29.07,29.01,28.52,27.32,25.64,23.99,22.37,20.82,19.35,16.20,14,14,14,14,14,14,14,15,17,19,21,22,20,19,18,18,17,16,17.97,17.83,17.14,16.53,16,15.60,15.08,14.37,13.86,13.50,12.99,12.52,12.35,12.03,11.86,11.70,11.78,11.75,11.70,11.62,11.51,11.40,11.26,11.11,10.89,10.70,10.46,10.22,9.97,9.73,9.50,9.26,9.09,8.89,8.76,8.70,8.64,8.70,8.75,8.90,9.12,9.39,9.74,10.12,10.52,11,11.54,11.87,12.79,12.86,13.37,14.91,15.71,15.39,17.47,18.35,19.21,20.11,21.04,21.87,22.71,23.45,24.12,24.62,25.08,25.50,25.87,26.12,26.28,26.37,26.37,26.27,26.14,25.92,25.67,25.27,25.24,25,24.84,24.71,24.62,24.57,24.54,24.57,24.62,24.71,24.73,24.70,24.62,24.48,24.25,24,23.52,23.50,23.28,23.21,23.16,23.20,23.27,23.38,23.49,23.49,23.36,23.01,22.35,21.27,19.36,15.85,-14,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-16,-15,-15,-14,-14,-14,-13,-13,-12,-11,-9.86,-8.55,-7.25,-6.09,-5.03,-4.24,-3.59,-3.09,-2.66,-2.08,-1.41,-0.65,0.24,1.24,2.36,3.58,4.76,5.73,6.34,6.58,6.53,6.36,6.12,5.95,5.96,6.23,6.75,7.28,8.34,9.52,10.87,12.26,13.51,14.87,15.97,16.74,17.20,17.39,17.47,17.33,16.99,16.42,15.88,15.41,15.09,14.91,14.85,14.77,14.66,14.57,14.46,14.35,14.22,14.07,13.87,13.63,13.20,13.83,13.99,14.03,14.09,14.21,14.73,16,17.74,20.11,21.25,22.50,23.67,24.73,25.51,25.39,24.50,23.17,21.51,19.54,17.51,15.51,14.22,13.52,13.15,13.10,13.12,13.22,13.46,13.76,14.12,14.57,15.10,16.02,17.16,18.64,20.36,22.25,24.22,26.08,27.67,28.97,29.61,29.47,28.85,28.02,27.12,26.49,26.58,27.23,28.11,29.12,30.08,30.85,31.21,30.83,29.75,28.34,26.98,25.75,24.75,23.90,23.27,22.83,22.52,22.39,22.45,22.60,22.83,23.10,23.36,23.53,23.71,23.83,23.91,24.08,24.25,24.53,24.91,25.41,26.12,27.03,28.23,29.62,31.24,33,34.26,35.01,35.20,34.91,34.37,33.65,32.75,31.62,30.50,29.73,29.45,29.90,30.37,30.49,30.25,29.71,28.76,27.48,25.76,24.22,22.71,21.16,20,17,15,15,16,16,16,16,17,18,19,21,22,23,22,21,20,19,17,18,20,20.97,20.03,19.25,18.66,18,17.16,16.14,15.25,14.57,13.77,13.12,12.74,12.33,12.03,11.87,11.98,11.95,11.88,11.84,11.75,11.63,11.50,11.36,11.14,10.95,10.72,10.48,10.24,10,9.75,9.53,9.36,9.16,9.02,8.95,8.87,8.88,8.96,9.09,9.26,9.52,9.87,10.25,10.66,11.14,11.72,12.02,13.09,13,14.57,15.24,16.14,15.66,17.98,18.85,19.72,20.59,21.42,22.25,22.38,23.70,24.33,24.82,25.26,25.71,26.09,26.39,26.61,26.75,26.79,26.76,26.66,26.47,26.25,25.72,25.73,25.45,25.16,24.91,24.47,24.28,24.49,24.41,24.39,24.38,24.35,24.29,24.17,24.03,23.86,23.65,23.10,23.16,22.98,22.88,22.84,22.86,22.89,22.99,23.02,23,22.87,22.50,21.95,20.85,19,15.97,-14,-15,-16,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-16,-15,-15,-14,-14,-14,-13,-13,-12,-11,-10,-9.14,-7.88,-6.64,-5.50,-4.55,-3.86,-3.25,-2.75,-2.35,-1.73,-1.09,-0.35,0.50,1.48,2.65,4.07,5.51,6.78,7.63,8,7.96,7.61,7.13,6.75,6.59,6.82,7.40,8.21,9.60,11.20,13,14.85,16.63,18.33,19.67,20.62,21.08,21.12,20.79,20.25,19.45,18.53,17.67,17,16.60,16.50,16.50,16.47,16.32,16.04,15.73,15.38,15.08,14.79,14.59,14.40,14.33,14.75,14.86,14.99,15.04,15.15,15.47,16.78,18.75,20.96,23.46,25.50,27.38,28.53,28.64,27.67,26.38,24.70,22.60,20.23,17.92,16.08,14.83,14.37,14.21,14.13,14.24,14.48,14.73,15.33,15.75,16.15,16.67,17.36,18.28,19.58,21.24,23.03,24.88,26.64,28.16,29.42,29.96,29.70,28.87,27.96,26.95,26.11,25.78,26,26.34,27.22,28.13,28.87,29.36,29.25,28.47,27.32,26.12,25.07,24.16,23.48,22.91,22.57,22.34,22.25,22.28,22.47,22.70,22.91,23.12,23.24,23.28,23.34,23.38,23.51,23.74,24.03,24.47,25,25.75,26.72,27.95,29.41,31.12,32.97,34.58,35.59,36,36,35.64,34.95,34,32.85,31.72,30.97,30.83,31.39,32.33,32.49,31.02,29.96,28.96,27,26,24,23,22,20,17,15,16,17,18,18,19,19,21,22,23,24,24,23,22,21,19,18,19,21,24,23.01,22.25,21.75,21.16,19.62,18.28,17.07,16,15,14.10,13.50,12.99,12.62,12.40,12.47,12.40,12.35,12.25,12.15,12.03,11.88,11.72,11.50,11.26,11.01,10.76,10.52,10.28,10.07,9.85,9.63,9.47,9.33,9.21,9.12,9.11,9.13,9.25,9.40,9.65,9.99,10.37,10.78,11.33,11.95,12.17,13.35,13.20,13.84,14.50,15.26,17.52,18.42,19.29,20.16,21,21.77,22.54,23.24,23.88,24.47,24.98,25.47,25.88,26.27,26.62,26.90,27.08,27.17,27.22,27.11,26.51,26.75,26.46,26.15,25.82,25.45,25.08,24.75,24.53,24.37,23.61,24.10,24,23.91,23.84,23.72,22.99,22.95,22.75,22.67,22.63,22.66,22.63,22.61,22.62,22.64,22.71,22.74,22.71,22.58,22.25,21.66,20.75,19.07,16.10,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-16,-15,-14,-14,-14,-13,-13,-13,-12,-11,-10,-9.63,-8.40,-7.14,-5.97,-4.88,-4.02,-3.38,-2.87,-2.40,-1.92,-1.25,-0.63,0,0.71,1.60,2.82,4.37,6.12,7.76,9,9.62,9.62,9.14,8.42,7.77,7.38,7.50,8.20,9.24,10.96,12.97,15.24,17.61,20,22.09,23.87,25.11,25.60,25.36,24.58,23.37,22.07,20.64,19.51,18.71,18.37,18.45,18.63,18.63,18.37,17.89,17.27,16.65,16.12,15.74,15.50,15.37,15.36,15.36,15.75,15.96,16.02,16.14,16.34,17.57,19.09,21.83,24.47,27.12,29.89,31.76,31.25,30.17,28.72,26.63,24.16,21.27,18.71,16.71,15.58,15.32,15.34,15.36,15.36,16.09,16.60,17.08,17.47,17.86,18.29,18.87,19.59,20.74,22.32,24.04,25.77,27.40,28.84,29.89,30.25,29.75,28.87,27.73,26.72,25.82,25.13,24.87,25.12,25.71,26.40,27.12,27.52,27.62,27.10,26.25,25.27,24.37,23.63,23.07,22.62,22.34,22.14,22.12,22.22,22.39,22.63,22.87,23.01,23.08,23.03,23,23,23.09,23.25,23.57,23.96,24.50,25.23,26.21,27.47,28.98,30.71,32.48,34.25,35.50,36.14,36.37,36.14,35.52,34.52,33.37,32.25,31.52,31.37,32.09,32.25,32.39,30.84,29.75,28.95,27.01,26,24,23,22,19,17,15,16,18,20,21,22,23,25,26,27,27,27,25,24,23,22,19,20,23,26,27,25.98,24.91,23.78,22.22,20.51,19,17.62,16.40,15.36,14.58,13.95,13.50,13.25,13.15,13.08,12.97,12.85,12.72,12.52,12.36,12.12,11.88,11.62,11.37,11.12,10.86,10.61,10.37,10.13,9.96,9.75,9.61,9.47,9.37,9.33,9.34,9.39,9.53,9.77,10.09,10.47,10.86,11.26,11.73,12.79,13.52,14.27,15.25,14.74,17,17.88,17.21,19.67,20.51,21.34,22.10,22.76,23.41,24,24.57,25.08,25.61,26.03,25.71,26.82,27.12,27.37,27.52,27.59,27.50,27.39,27.23,26.87,26.52,26.11,25.62,25.16,24.46,23.87,24.17,23.95,23.01,23.61,22.76,23.37,22.63,23.03,22.35,22.83,22.32,22.34,22.40,22.45,22.41,22.40,22.45,22.49,22.50,22.49,22.41,22.15,21.87,20.91,19.21,17.27,-14,-15,-15,-16,-17,-18,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-15,-14,-14,-14,-13,-13,-12,-12,-11,-10,-9.78,-8.73,-7.54,-6.38,-5.30,-4.38,-3.63,-3,-2.42,-1.88,-1.28,-0.67,-0.13,0.37,0.91,1.65,2.85,4.63,6.66,8.73,10.48,11.51,11.60,10.92,9.89,8.89,8.21,8.16,8.89,10.21,12.22,14.61,17.32,20.52,23.23,25.88,28.50,30.33,30.87,30.16,28.61,26.82,24.34,22.52,21.27,20.54,20.02,20.87,21.29,21.28,20.83,20,19.02,18.04,17.27,16.79,16.58,16.49,16.47,16.48,16.75,16.96,17.03,17.12,17.34,18.32,20.24,22.53,25.35,28.48,31.33,33.37,33.71,33.11,31.63,29.38,26.49,23.27,19.98,17.67,16.33,15.37,17.60,17.59,17.73,18.08,18.51,18.91,19.25,19.53,19.85,20.40,21.11,22.16,23.64,25.24,26.87,28.37,29.70,30.51,30.60,30.03,29.07,27.70,26.78,25.98,25.07,24.62,24.58,24.75,25.15,25.66,26.08,26.11,25.77,25.16,24.45,23.73,23.12,22.66,22.35,22.12,22,22,22.12,22.37,22.63,22.87,23,23,22.89,22.75,22.70,22.71,22.83,23.03,23.38,23.88,24.60,25.51,26.77,28.35,30.03,31.85,33.49,34.95,35.75,36.07,35.96,35.38,34.38,33.24,32.21,31.49,31.20,31.26,31.41,30.87,30,28.96,27.87,26.96,25,24,23,22,19,17,15,16,19,22,24,25,27,28,30,30,31,30,29,27,25,23,21,22,24,27,29,29,27.97,26.75,24.59,22.61,20.86,19.23,17.84,16.63,15.72,15,14.51,14.22,13.99,13.82,13.63,13.48,13.26,13.07,12.82,12.57,12.27,12,11.73,11.45,11.16,10.90,10.66,10.46,10.25,10.07,9.87,9.73,9.61,9.51,9.50,9.53,9.65,9.87,10.14,10.51,11,11.57,11.79,12.92,12.82,13.50,14.20,16.39,17.29,18.21,19.12,20,20.84,21.61,22.34,22.97,23.53,24.09,24.60,25.12,25.65,26.13,25.76,26.96,27.29,27.60,27.78,27.89,27.90,27.79,27.62,27.23,26.79,26.29,25.76,24.83,24.72,23.74,23.95,22.89,23.32,22.37,22.21,22.08,21.98,22.60,21.91,21.95,22,22.09,22.22,22.24,22.29,22.35,22.41,22.49,22.54,22.59,22.54,22.75,22.33,21.38,19.78,16.52,-14,-15,-15,-16,-16,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-15,-14,-13,-13,-13,-12,-12,-11,-10,-9.75,-8.78,-7.75,-6.66,-5.63,-4.66,-3.85,-3.13,-2.50,-1.91,-1.29,-0.63,-0.04,0.40,0.70,1.12,1.74,2.98,4.89,7.24,9.66,12.02,13.66,13.90,12.90,11.41,9.99,8.91,8.67,9.36,10.96,13.21,15.87,19.10,22.21,25.26,28.88,32.84,36.76,36.84,35.36,33.28,29.37,25.84,24.13,22.99,22.26,22.84,23.84,24.50,24.28,23.45,22.20,20.87,19.67,18.83,18.34,18.15,18.08,17.89,17.89,17.97,18.01,18.07,18.24,18.34,19.28,21.28,23.65,25.96,30.17,33.47,35.70,36.75,36.74,35.47,32.84,29.37,25.79,22.27,18.34,16.37,16.41,18.54,19.53,19.64,19.88,20.49,20.35,20.52,20.77,21.22,21.89,22.85,24.01,25.37,26.79,28.25,29.63,30.70,31.41,31.35,30.60,29.54,28.35,27.50,26.51,25.74,25.08,24.71,24.58,24.62,24.76,24.99,24.97,24.66,24.20,23.62,23.10,22.64,22.33,22.10,21.91,21.87,21.89,22.07,22.33,22.62,22.88,23.01,22.99,22.82,22.60,22.40,22.34,22.37,22.50,22.82,23.25,23.87,24.76,26,27.61,29.37,31.12,32.75,34.12,35.13,35.57,35.41,34.88,33.97,32.87,31.84,31.01,30.57,30.28,30.02,29.58,28.84,27.97,26.99,25.96,24.98,24,22,21,19,17,15,17,20,23,26,29,30,30,32,34,34,35,33,29,27,24,22,23,25,28,31,31,30,28.97,26.83,24.24,22.27,20.66,19.02,17.75,16.75,16,15.47,15.08,14.76,14.51,14.28,14.07,13.78,13.50,13.24,12.95,12.62,12.35,12.02,11.75,11.48,11.23,10.98,10.75,10.52,10.35,10.14,9.99,9.84,9.72,9.64,9.65,9.75,9.95,10.21,10.57,10.89,11.33,11.90,13.01,12.90,13.62,15.67,15.11,17.52,18.45,19.37,20.24,21.03,21.84,22.52,23.12,23.67,24.13,24.61,25.12,25.64,26.12,25.99,26.99,27.40,27.75,28.03,28.21,28.23,28.11,27.91,27.49,27,26.42,25.79,24.74,24.59,23.49,23.62,22.53,22.16,21.89,21.72,21.59,21.50,21.50,21.52,21.61,21.75,21.98,22.02,22.12,22.27,22.41,22.54,22.66,22.77,22.86,23,23.33,23,22.26,20.64,17.83,-14,-15,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-16,-16,-16,-15,-14,-13,-13,-12,-12,-11,-11,-10,-9.61,-8.72,-7.76,-6.78,-5.80,-4.88,-4,-3.25,-2.61,-1.98,-1.36,-0.68,-0.04,0.61,0.66,0.96,1.39,2.08,3.47,5.46,8,10.61,13.32,15.40,16.36,14.79,12.86,11.01,9.53,8.91,9.50,11.41,13.86,16.70,19.78,22.75,26.62,30.67,35.61,40.59,43.82,41,37,32.12,27.20,26.25,24.50,23.79,25.57,27.29,28.22,27.82,26.23,24.35,22.59,21.21,20.35,20,19.95,19.92,19.82,19.59,19.33,19.16,19.21,19.29,20.12,21.25,22.21,25.24,28.42,32.74,36.59,39.22,40.63,40.95,40.96,36.77,32.67,28.38,25.21,21.35,17.40,17.46,18.29,20.50,21.50,20.92,20.65,20.67,20.99,21.49,22.25,23.23,24.38,25.72,27.13,28.60,30,31.21,32.08,32.48,32.22,31.42,30.45,29.33,28.75,27.87,26.87,26,25.41,25.09,24.86,24.70,24.50,24.25,23.87,23.38,22.95,22.53,22.24,22,21.86,21.75,21.72,21.75,21.91,22.22,22.52,22.84,22.98,22.90,22.71,22.39,22.13,21.97,21.88,21.99,22.22,22.62,23.22,24.10,25.36,26.97,28.75,30.50,32.12,33.40,34.45,34.90,34.87,34.34,33.51,32.50,31.47,30.59,29.90,29.39,28.91,28.39,27.75,26.98,26.12,25.03,24,23,22,20,18,16,15,17,20,24,28,31,32,32,34,35,36,37,35,31,28,25,23,24,27,30,32,32,32,30,27.97,25.09,23.12,21.57,19.87,18.60,17.58,16.82,16.24,15.86,15.45,15.12,14.83,14.50,14.21,13.87,13.57,13.25,12.95,12.62,12.33,12.01,11.75,11.50,11.25,11.02,10.83,10.62,10.40,10.22,10.01,9.87,9.77,9.75,9.83,9.98,10.23,10.58,10.88,11.33,11.86,13.07,13.90,13.73,14.48,16.75,17.71,18.62,19.52,20.41,21.23,21.98,22.64,23.22,23.73,24.16,24.62,24.49,25.70,26.16,26.02,27.10,27.57,27.97,28.25,28.45,28.48,28.35,28.12,27.66,27.11,26.48,25.78,25.12,23.87,23.25,22.66,22.22,21.75,21.48,21.28,21.17,21.12,21.13,21.24,21.37,21.70,21.75,21.90,22.12,22.35,23.12,23.35,23.54,23.73,23.87,23.98,24.01,23.87,23.41,22.11,19.08,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-14,-14,-13,-12,-11,-11,-10,-10,-9.28,-8.50,-7.64,-6.75,-5.87,-4.97,-4.12,-3.35,-2.63,-2,-1.38,-0.76,-0.21,0.46,0.73,0.88,1.12,1.58,2.53,4.37,6.66,9,11.41,14.12,16.32,17.04,16.22,14.22,12,10.09,8.61,9.41,11.83,14,17,20,24,27,32,37,44,48,46,40,34.12,31.20,29.25,27.32,26.42,27.57,31.02,33.57,31.25,28.78,26.23,24.07,22.63,21.91,21.87,22.04,22.11,21.87,21.35,20.82,20.37,20.37,20.76,21.25,23.10,25.12,27.91,31.20,35.95,40.72,44.67,44.66,45.67,45.70,41.01,36.21,32.21,28.87,24.62,19.42,17.49,17.50,19.14,20.49,20.12,20.04,20.36,21.07,21.97,23.08,24.37,25.78,27.34,28.92,30.51,31.95,33.08,33.75,33.92,33.54,32.77,31.65,31.23,30.48,29.47,28.34,27.37,26.71,26.23,25.76,25.25,24.62,23.99,23.37,22.87,22.46,22.13,21.95,21.77,21.66,21.60,21.53,21.60,21.75,22,22.35,22.62,22.78,22.75,22.50,22.16,21.84,21.57,21.41,21.45,21.62,22,22.62,23.57,24.86,26.49,28.26,30.01,31.62,32.84,33.73,34.21,34.14,33.73,33.01,32.14,31.25,30.36,29.51,28.82,28.10,27.48,26.84,26.12,25.25,24.95,23,22,20,19,18,16,16,17,20,23,28,31,33,34,35,37,38,38,35,31,29,27,24,25,28,31,33,33,31,29,27,25,23.86,21.82,20.33,19.08,18.11,17.36,16.78,16.37,15.91,15.52,15.20,14.84,14.49,14.13,13.82,13.49,13.15,12.87,12.57,12.26,12,11.75,11.50,11.28,11.09,10.87,10.64,10.41,10.22,10.01,9.88,9.84,9.87,10,10.23,10.53,10.86,11.29,11.86,12.99,13.07,14.86,15.88,16.86,17.79,18.75,19.65,20.52,21.34,22.03,22.67,23.24,23.72,24.17,24.61,25.14,25.70,26.20,26.62,27.14,27.62,28.08,28.38,28.60,28.62,28.51,28.25,27.76,27.13,26.42,25.20,25,23.70,23.03,22.40,21.88,21.49,21.20,21,20.89,20.88,20.95,21.04,21.25,21.50,21.70,21.92,22.16,23.11,23.37,23.70,23.92,24.12,24.33,24.50,24.67,24.78,24.49,23.83,21.35,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-14,-13,-12,-11,-11,-10,-9.63,-8.90,-8.17,-7.40,-6.61,-5.75,-4.91,-4.11,-3.34,-2.62,-1.97,-1.38,-0.79,-0.29,0.20,0.57,0.84,1,1.29,1.65,2.90,5.52,7.83,9.96,12,14.12,15.97,17.12,17.13,15.37,12.95,10.01,9,10,12,15,17,21,25,30,36,42,47,52,50,43,38.12,35.20,33.75,31.29,30.45,30.84,32.87,35.28,33.97,30.25,27.50,25.22,23.83,23.39,23.75,24.24,24.32,23.88,23.08,22.25,21.75,21.41,22.24,23.22,24.91,27.07,30.10,34.87,39.16,43.78,47.75,48.11,48.76,48.78,45.79,41.20,37.78,33.66,27.61,21.46,18.49,17.50,18.49,18.95,18.70,19.11,19.96,21,22.24,23.67,25.28,26.98,28.71,30.53,32.34,33.99,35.16,35.66,35.60,35.17,34.61,33.92,33.41,32.32,31.14,30.02,29.07,28.27,27.62,26.88,26,25,24.08,23.25,22.62,22.23,21.96,21.77,21.66,21.58,21.47,21.37,21.37,21.50,21.73,22.01,22.32,22.48,22.45,22.21,21.85,21.46,21.12,20.91,20.89,21.09,21.49,22.13,23.12,24.46,26.07,27.84,29.63,31.15,32.25,32.90,33.28,33.22,32.87,32.38,31.77,31.03,30.23,29.41,28.60,27.74,26.98,26.32,25.48,24.87,23.95,22.01,21,20,18,17,15,16,18,20,23,26,29,31,33,35,38,40,38,35,31,28,26,26,27,28,31,33,33,31,29,27,25,23,21.87,20.28,19.23,18.36,17.65,17.12,16.65,16.23,15.82,15.40,15.02,14.66,14.34,14,13.66,13.37,13.08,12.76,12.50,12.24,12,11.75,11.53,11.34,11.12,10.87,10.62,10.37,10.13,9.98,9.87,9.87,9.98,10.20,10.50,10.83,11.28,11.85,13.10,13.11,13.83,14.61,15.58,17.87,18.84,19.74,20.61,21.37,22.08,22.71,23.23,23.70,24.12,24.54,25.11,25.62,25.42,26.61,27.15,27.66,28.12,28.47,28.66,28.72,28.63,28.32,27.77,27.12,26.37,25.60,24.25,24.03,22.84,22.21,21.64,21.26,21,20.87,20.82,20.83,20.91,21.07,21.26,21.47,21.71,22.59,22.47,23.33,23.61,23.89,24.17,24.41,24.64,24.90,25.20,25.34,25.37,25.23,24.58,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-16,-16,-15,-15,-14,-13,-12,-11,-10,-10,-9.25,-8.51,-7.79,-7.10,-6.36,-5.60,-4.85,-4.09,-3.35,-2.62,-1.91,-1.30,-0.75,-0.29,0.12,0.48,0.75,0.97,1.23,1.37,2.37,4.49,6.63,9.12,11.04,12.01,13.32,14.84,16.37,17.59,16.82,14,11,10,10,12,15,18,22,27,33,39,45,51,54,53,46,41.10,38.16,36.76,35.72,34.03,33.96,34.28,34.23,32.98,30.62,28.12,26.02,24.91,24.90,25.77,26.52,26.52,25.76,24.65,23.65,23.09,23.15,23.74,24.90,26.12,29,33,37,42.97,47.91,50.89,50.97,51.08,51.84,49.82,45.79,41.79,37.66,30.61,23.45,19.48,18.50,18.51,18.42,18.40,18.75,19.61,20.89,22.37,24.07,25.91,27.87,29.62,31.46,33.32,35.25,36.75,37.48,37.46,36.84,36.34,36.51,35.20,34.08,32.82,31.59,30.58,29.78,29.03,28.08,26.75,25.47,24.33,23.37,22.71,22.25,21.98,21.82,21.66,21.52,21.37,21.24,21.15,21.22,21.37,21.62,21.87,22,21.99,21.75,21.38,21,20.63,20.45,20.38,20.57,20.98,21.63,22.62,23.96,25.52,27.35,29.12,30.52,31.41,31.86,32,31.87,31.62,31.36,31.10,30.63,30.08,29.35,28.62,27.88,27.11,26.37,25.50,24.75,23.91,22.01,21,19,18,16,15,16,18,20,22,25,26,30,33,36,39,41,39,36,33,29,28,28,28,30,32,34,34,33,31,29,26,23,21,20.09,19.14,18.39,17.78,17.27,16.85,16.38,15.98,15.57,15.16,14.83,14.49,14.14,13.86,13.53,13.25,12.98,12.71,12.46,12.23,12,11.77,11.58,11.34,11.09,10.78,10.50,10.24,10,9.87,9.86,9.95,10.13,10.47,10.77,11.25,11.84,13.12,13.16,14.90,15.87,16.65,16.59,18.87,19.75,20.62,21.37,22.07,22.67,23.20,23.64,24.04,24.47,24.36,25.50,26.03,26.52,27.10,27.62,28.12,28.48,28.71,28.74,28.65,28.29,27.75,27.03,25.87,25.45,24.14,23.38,22.66,22.03,21.53,21.23,21.01,20.89,20.89,20.92,21.04,21.22,21.40,21.59,21.78,22.07,23.12,23.41,23.72,24.01,24.29,24.58,24.87,25.12,25.40,25.60,25.79,25.65,24.82,-14,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-14,-13,-12,-11,-10,-9.72,-8.88,-8.13,-7.38,-6.68,-6,-5.30,-4.63,-3.93,-3.25,-2.60,-1.91,-1.29,-0.71,-0.21,0.16,0.50,0.76,0.98,1.22,1.47,2.42,3.79,5.57,7.59,9.62,10.70,10.87,11.85,13.16,15.11,17.98,17,15,13,11,11,12,15,19,24,30,37,44,49,53,54,53,49,43.92,39.83,37.73,36.71,37.10,36.03,35.36,34.34,32.54,30.49,28.57,26.96,26.21,26.59,27.86,28.72,28.61,27.46,26.07,24.92,24.37,24.49,25.13,26.20,28.12,31,34,40,46,50.95,53.90,53.87,53.07,52.85,49.84,43.96,39.83,35.70,29.67,24.41,21.47,20.29,19.50,18.50,18.48,18.52,19.48,20.78,22.33,24.13,26.12,28.21,29.88,31.65,33.50,35.33,37.12,38.66,38.97,38.22,37.50,37.42,36.17,34.97,33.87,32.84,31.75,30.91,29.97,28.63,27.12,25.75,24.57,23.62,22.89,22.41,22.13,21.96,21.76,21.58,21.33,21.11,20.97,20.91,21,21.16,21.36,21.46,21.40,21.22,20.87,20.50,20.14,19.96,19.89,20.08,20.48,21.12,22.08,23.32,24.82,26.50,28.15,29.41,30.12,30.36,30.35,30.24,30.07,29.87,29.89,29.75,29.49,29.11,28.64,28.14,27.60,26.90,25.95,24.95,23.91,22.01,21,19,17,16,15,16,20,21,23,24,26,29,33,36,40,42,41,39,35,31,31,29,30,32,33,35,35,34,32,29,27,24,21,20,19.03,18.35,17.82,17.40,16.99,16.52,16.10,15.66,15.28,14.97,14.62,14.34,14.02,13.74,13.46,13.15,12.89,12.64,12.45,12.23,12,11.78,11.53,11.25,10.96,10.62,10.28,10.02,9.87,9.82,9.87,10.08,10.38,10.75,11.22,11.83,13,13.25,14,14.83,17,16.73,18.92,19.84,20.64,21.38,22.04,22.64,23.14,23.58,23.97,23.85,24.27,25.37,25.87,25.87,27,27.53,28.03,28.40,28.62,28.75,28.61,28.22,27.64,26.96,26.13,25.27,24.08,23.27,22.58,21.91,21.50,21.24,21.09,21.07,21.10,21.17,21.33,21.48,21.66,21.74,21.92,22.15,23.20,22.73,23.78,23.48,24.23,23.85,24.14,25.10,25.50,25.70,25.66,25.26,23.08,-13,-13,-13,-14,-14,-13,-13,-13,-14,-14,-14,-14,-14,-13,-12,-11,-10,-9.42,-8.50,-7.66,-6.98,-6.27,-5.63,-4.98,-4.30,-3.68,-3.09,-2.48,-1.87,-1.28,-0.71,-0.15,0.27,0.65,0.91,1.15,1.35,1.50,2.17,3.17,4.66,6.50,7.07,7.41,8.37,9.29,10.25,11.21,14.14,16.07,18,16,14,12,12,13,16,20,25,31,39,45.98,49.92,49.89,49.87,48.87,45.87,41.77,38.32,36.37,36.89,37.91,37.62,36.74,35.33,33.27,31.27,29.52,28.12,27.53,28.23,29.86,30.75,30.41,28.87,27.25,26.12,25.61,25.85,26.24,28.03,30.11,33,37,44,51,54.98,56.95,56.90,54.87,51.87,46.85,41.14,36.14,32.26,28.35,25.40,22.42,22.37,21.52,20.40,19.35,18.51,19.50,20.64,22.09,23.83,25.76,27.76,29.72,31.52,33.33,35.08,36.75,38.11,39.32,37.83,36.70,35.74,34.99,34.47,34.62,33,32.08,31.13,29.88,28.46,27,25.75,24.66,23.78,23.12,22.64,22.36,22.12,21.87,21.61,21.27,21,20.76,20.65,20.66,20.75,20.85,20.87,20.83,20.62,20.34,20,19.71,19.50,19.49,19.62,19.99,20.59,21.40,22.50,23.84,25.26,26.71,27.75,28.35,28.50,28.45,28.34,28.21,28.13,28.23,28.25,28.27,28.28,28.50,28.37,28.15,27.38,26.47,24.82,23.91,22.97,21,19,17,15,15,17,21,24,25,27,29,31,33,36,40,42,41,40,37,34,31,30,31,32,32,33,35,34,32,30,28,24,22,20,19,18.01,17.98,17.59,17.15,16.66,16.22,15.82,15.46,15.12,14.84,14.52,14.24,13.95,13.63,13.37,13.11,12.87,12.64,12.46,12.25,12,11.75,11.45,11.09,10.71,10.35,10.02,9.84,9.75,9.78,10,10.33,10.71,11.22,11.83,13,13.34,14.97,14.99,17.07,16.87,19,19.88,20.67,21.42,22.04,22.60,23.04,23.45,23.83,23.76,24.21,24.70,25.66,26.25,26.85,27.39,27.89,28.27,28.51,28.65,28.49,28.12,27.57,26.87,26.04,25.16,24.04,23.25,22.46,21.91,21.53,21.34,21.26,21.29,21.38,21.50,21.65,21.79,21.95,21.99,22.13,22.33,22.58,22.84,23.12,23.38,23.70,23.99,24.32,24.59,24.83,25.65,25.40,24.66,22.25,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-11,-10,-9.13,-8.15,-7.29,-6.50,-5.85,-5.24,-4.63,-4.01,-3.40,-2.80,-2.23,-1.65,-1.14,-0.65,-0.15,0.36,0.83,1.25,1.60,1.48,2.12,2.37,2.54,3.87,5.20,6.47,6.50,6.46,8.14,9.35,10.88,12.24,14.16,15.89,17,16,14,12,12,13,17,21,27,33,37.95,42.89,44.86,43.12,42.89,42.79,40.07,37.33,34.39,35.47,36.42,37.58,38.71,38.37,36.88,35.04,33,31.22,29.78,29.21,29.86,31.41,32.25,31.63,29.91,28.23,27.14,26.78,27.13,27.91,29.14,32.01,35,39,47,54,59,58.97,57.95,54.90,49.10,44.12,39.12,35.12,32.23,30.28,28.36,26.38,24.40,24,22.74,20.39,19.52,19.60,20.46,21.66,23.14,24.88,27.07,29.37,31.48,33.21,34.85,36.36,37.50,38.65,36.75,35.33,34.12,33.29,32.77,32.39,32,31.25,30.26,29,27.70,26.50,25.48,24.60,23.86,23.25,22.82,22.49,22.22,21.91,21.61,21.24,20.88,20.62,20.47,20.37,20.37,20.37,20.37,20.25,20.10,19.86,19.59,19.35,19.20,19.14,19.25,19.57,20.02,20.73,21.62,22.65,23.77,24.87,25.75,26.25,26.40,26.40,26.35,26.25,26.25,26.27,26.38,26.57,26.87,27.22,27.75,28.12,27.28,25.47,23.84,22.91,21.97,21,18,16,15,16,18,22,26,28,31,32,34,36,38,41,42,41,40,38,35,34,32,31,30,31,32,32,32,32,30,27,24,22,20,19,19,18,17.98,17.47,16.85,16.36,15.98,15.63,15.37,15.08,14.75,14.47,14.14,13.86,13.58,13.32,13.09,12.87,12.70,12.49,12.25,11.96,11.61,11.21,10.75,10.36,10,9.76,9.65,9.72,9.88,10.24,10.67,11.21,11.85,12.62,13.45,14.27,15.24,17.11,17.04,19.04,19.92,20.72,21.42,22.02,22.50,22.96,23.32,23.62,23.66,24.42,24.91,25.12,26.01,26.62,27.16,27.66,28.08,28.38,28.47,28.33,28,27.48,26.79,26,24.89,24.09,23.22,22.50,22,21.66,21.52,21.51,21.61,21.74,22.27,22.41,22.37,22.61,22.38,22.50,22.63,22.87,23.13,23.40,23.72,24.04,24.37,24.70,24.90,25.11,25.72,25.45,24.38,21.47,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-10,-9.75,-8.76,-7.75,-6.88,-6.11,-5.40,-4.78,-4.25,-3.72,-3.15,-2.61,-2.01,-1.47,-0.91,-0.50,-0.10,0.36,0.83,1.48,2.09,2.58,3.26,3.50,3.58,3.60,4.60,5.89,6.57,7.01,7.48,8.37,9.85,11.70,13.75,14.79,15.87,16,14,13,12,12,13,17,23,29,32.92,33.87,35.16,35.20,36.24,36.25,36.33,34.38,33.42,32.47,34.51,35.59,37.48,39.29,40,38.75,37.08,35.25,33.45,31.72,30.86,31.26,32.50,33.09,32.37,30.67,29.11,28.22,28.07,28.58,29.16,31.11,33.01,37,41,49,57,62,62,59.98,53.95,47.08,42.09,39.09,37.10,36.15,35.14,33.71,30.32,27.36,26.64,26.63,22.88,20.51,19.59,20.33,21.16,22.28,23.67,25.65,29.37,31.99,33.48,35.37,36.39,36.99,36.64,35.50,33.62,32.62,31,30.99,30.74,30.33,29.63,28.75,27.73,26.70,25.75,24.97,24.28,23.72,23.23,22.82,22.49,22.20,21.87,21.52,21.15,20.84,20.53,20.34,20.16,20.10,20,19.96,19.86,19.72,19.51,19.34,19.14,19.02,19,19.07,19.25,19.58,20.07,20.72,21.49,22.32,23.09,23.72,24.12,24.36,24.40,24.36,24.32,24.28,24.33,24.47,24.70,25,25.46,25.77,25.71,24.64,23.36,22.07,20.98,19.99,19,17,16,16,17,19,23,27,30,33,35,37,38,39,42,42,42,41,39,37,34,33,32,31,30,30,30,30,30,28,26,23,22,20,19,19,19,18.97,17.73,16.87,16.50,16.16,15.90,15.63,15.36,15.02,14.71,14.37,14.07,13.75,13.50,13.28,13.12,12.95,12.75,12.50,12.15,11.76,11.33,10.84,10.37,9.98,9.71,9.59,9.61,9.78,10.13,10.63,11.20,11.87,12.67,13.53,15,15.41,17.14,18.15,19.12,19.99,20.75,21.39,21.97,22.41,22.83,23.13,23.40,23.54,23.98,24.41,24.92,25.75,26.34,26.90,27.40,27.84,28.13,28.24,28.14,27.87,27.41,26.77,25.84,25.01,24.22,23.35,22.63,22.12,21.79,21.67,21.95,22.14,22.38,22.62,22.77,22.92,23.09,23.34,22.99,23.14,23.37,23.65,23.97,24.33,24.70,25.03,25.36,25.62,25.76,25.71,25.95,24.71,21.71,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.23,-8.34,-7.38,-6.43,-5.62,-5,-4.40,-3.88,-3.37,-2.86,-2.37,-1.85,-1.30,-0.79,-0.34,0.04,0.40,0.79,1.27,1.97,3.60,4.87,5.50,5.57,5.59,5.60,6.62,7.27,7.59,8,8.29,8.46,10.39,12.32,14.04,15.78,15.87,14,13,12,11,12,13,17,22,25.95,27.87,28.16,29.22,30.25,31.27,32.33,32.41,32.49,32.51,33.54,34.57,35.60,37.47,39.32,40.47,40.40,39.20,37.61,35.77,33.98,32.79,32.75,33.42,33.73,32.90,31.23,29.84,29.15,29.29,29.90,30.90,32.07,35,38,43,52,61,66,65,60,53,47.02,43.03,41.04,40.04,40.90,40.84,38.77,34.25,30.27,28.97,28.66,24.12,21.49,20.38,20.28,20.62,21.64,22.64,25.62,29.70,33.48,35.70,36.87,37.22,36.87,35.98,34.53,33.27,31.73,30.89,30.08,29.51,28.87,28.13,27.27,26.38,25.58,24.87,24.27,23.82,23.37,23,22.64,22.36,22.07,21.75,21.46,21.12,20.83,20.52,20.27,20.09,19.90,19.77,19.70,19.62,19.52,19.46,19.36,19.25,19.16,19.12,19.09,19.12,19.25,19.51,19.91,20.40,20.97,21.49,21.91,22.25,22.47,22.57,22.50,22.49,22.49,22.45,22.52,22.75,23.12,23.41,23.48,23,21.90,20.87,19.75,18.95,18,17,16,16,17,18,20,23,26,30,34,37,39,41,41,42,43,43,42,40,38,36,35,34,32,30,29,28,27,27,27,26,24,22,20,19,19,19,18,17.01,16.91,16.51,16.48,16.25,15.99,15.66,15.33,14.96,14.60,14.25,13.97,13.72,13.51,13.37,13.22,13.01,12.75,12.39,11.97,11.45,10.87,10.37,9.95,9.62,9.49,9.50,9.71,10.07,10.58,11.23,11.92,12.74,13.84,15.04,15.62,17.20,18.24,19.16,20.02,20.76,21.39,21.89,22.32,22.62,22.88,23.17,23.48,23.83,24.28,24.70,25.46,26.02,26.61,27.12,27.57,27.86,28,27.98,27.77,27.40,26.85,26.14,25.26,24.41,23.60,22.87,22.29,21.95,21.77,21.77,22.25,22.51,22.77,23.02,23.26,23.47,23.73,23.53,23.74,24.01,24.34,24.73,25.13,25.59,26,26.38,27.28,26.76,27.41,26.91,25.73,22.88,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.80,-9.28,-8.63,-7.84,-7,-6.13,-5.30,-4.62,-4.03,-3.55,-3.11,-2.61,-2.11,-1.62,-1.13,-0.64,-0.18,0.22,0.50,0.75,1.20,1.78,2.60,5.40,8.53,8.59,8.57,8.50,8.61,9.38,9.62,9.60,9.57,9.52,9.48,11.26,13.04,14.74,15.78,14.12,13,12,11,11,12,13,17,19.01,20.10,23.16,25.22,27.25,28.28,30.32,32.60,33.52,33.96,34.32,34.89,35.46,35.62,37.75,39.40,40.84,41.71,41.37,39.99,38.24,36.48,34.95,34.39,34.62,34.57,33.57,31.79,30.59,30.09,30.46,31.22,32.07,34,36,40,45,54,64,68,65,59,54,51,48,45,45,46,45.92,43.87,37.17,33.23,30.74,27.71,24.29,21.42,20.50,20.49,20.59,21.60,23.57,25.58,30.52,35.51,38.59,39.60,38.61,37.11,35.99,34.53,33.50,32.39,31.37,30.27,29.22,28,26.91,25.99,25.22,24.53,24,23.59,23.24,22.91,22.63,22.37,22.12,21.88,21.64,21.39,21.14,20.88,20.62,20.37,20.11,19.87,19.71,19.62,19.59,19.61,19.63,19.70,19.70,19.63,19.52,19.39,19.26,19.21,19.25,19.38,19.63,19.95,20.24,20.50,20.72,20.87,20.98,20.88,20.89,20.90,20.83,20.87,21.09,21.39,21.64,21.50,20.78,19.62,18.47,17.87,16.03,16,16,15,16,18,21,22,24,26,29,33,36,40,42,41,41,42,42,42,41,40,38,35,33,32,31,30,29,28,26,26,26,24,22,20,19,18,18,18,17,17.01,17.07,16.88,16.64,16.38,16.02,15.62,15.21,14.78,14.46,14.13,13.91,13.75,13.63,13.51,13.36,13.09,12.66,12.15,11.58,10.96,10.37,9.88,9.57,9.38,9.40,9.62,9.98,10.50,11.14,11.96,12.79,13.75,15.09,16.20,17.26,18.28,19.24,20.04,20.76,21.33,21.76,22.14,22.37,22.63,22.87,23.15,23.51,23.96,24.48,25.07,25.66,26.25,26.78,27.21,27.53,27.75,27.78,27.71,27.42,26.99,26.37,25.62,24.82,23.98,23.20,22.53,22.04,21.79,21.88,22.14,22.40,22.74,23.09,23.39,23.72,24.07,24.46,24.79,25.14,25.13,25.61,26.70,26.63,27.13,28.35,28.65,28.77,28.67,28.29,27.26,25.11,-11,-11,-11,-10,-10,-10,-10,-9.90,-9.54,-9.13,-8.63,-8.01,-7.38,-6.63,-5.89,-5.13,-4.41,-3.80,-3.28,-2.86,-2.37,-1.88,-1.40,-0.97,-0.51,-0.13,0.23,0.50,0.71,0.99,1.41,2.37,4.29,7.20,11.53,12.49,11.72,11.59,12.16,12.75,13.37,13.11,12.59,11.52,11.48,12.40,13.70,15.75,14.79,13.12,12,11,11,11,12,13,16,18.07,21.13,24.79,26.74,28.71,29.65,30.90,33.52,35.45,35.28,35.91,36.60,37.04,36.67,38.60,39.87,40.99,42.32,42.87,42.21,40.54,38.96,37.62,36.75,36.20,35.53,34.12,32.37,31.35,31.12,31.66,32.52,34,36,39,42,48,57,67,69,66,63,61,60,55,51,50,52,53,46.92,41.12,36.88,32.21,27.24,23.25,22.14,21.10,20.49,21.28,22.50,24.50,26.50,32.46,38.60,41.60,39.61,38.27,37.64,36.32,35.37,34.27,33.16,32,30.83,29.20,27.62,26.21,25.08,24.26,23.72,23.25,22.95,22.66,22.46,22.25,22.08,21.89,21.75,21.62,21.48,21.28,21.10,20.84,20.50,20.21,19.91,19.75,19.66,19.74,19.87,20.11,20.32,20.46,20.46,20.28,20.02,19.73,19.46,19.27,19.25,19.33,19.40,19.51,19.62,19.70,19.74,19.75,19.62,19.62,19.63,19.57,19.63,19.87,20.13,20.25,20.01,19.32,18.12,17.28,16.25,16.02,17,18,17,18,21,22,24,25,28,32,34,37,40,42,42,40,40,40,40,41,40,38,35,34,32,32,31,30,28,27,26,24,23,22,20,19,18,18,18,19,18,17.99,17.12,17.21,16.89,16.46,15.90,15.40,14.99,14.62,14.35,14.13,14.02,13.98,13.88,13.75,13.46,13,12.38,11.71,11,10.36,9.85,9.50,9.33,9.35,9.52,9.87,10.38,11.07,11.87,12.83,13.90,15.08,16.25,17.36,18.39,19.28,20.07,20.71,21.17,21.57,21.86,22.10,22.28,22.53,22.82,23.12,23.53,24.02,24.62,25.24,25.84,26.38,26.83,27.20,27.47,27.61,27.64,27.51,27.24,26.75,26.11,25.28,24.40,23.50,22.73,22.12,21.76,21.78,21.87,22.12,22.50,22.95,23.37,23.83,24.29,24.78,25.32,25.87,26.49,27.13,27.82,28.46,29.07,29.62,29.96,30.12,30.12,29.85,29.10,27.33,-10,-10,-10,-10,-10,-9.78,-9.49,-9.09,-8.63,-8.15,-7.61,-6.97,-6.37,-5.65,-4.97,-4.38,-3.75,-3.17,-2.64,-2.16,-1.68,-1.25,-0.76,-0.34,0.07,0.37,0.60,0.75,0.86,1.03,1.50,2.15,5.25,8.37,11.54,14.50,14.54,14.92,15.48,16.38,16.83,17.41,16.17,15.15,14.10,13.39,13.71,14.75,13.83,12.10,11,10,10,11,12,13,15,20.89,25.83,26.75,27.72,27.67,28.36,30.62,33.49,34.84,36.35,37.48,38.52,39.25,39.75,39.99,40.36,41.27,42.14,43.12,43.15,42.28,41.12,40.10,39.12,37.99,36.57,34.63,33.07,32.24,32.24,32.84,33.78,35,37,41,45,51,60,69,71,69,70,69,66,60,56,57,59,57,51,45.07,40.88,34.86,28.16,24.20,22.25,21.34,21.38,21.42,23.42,25.42,29.40,34.25,40.62,40.62,38.62,37.23,36.66,36.71,36.48,35.38,33.57,33,30.90,29.09,27.20,25.64,24.45,23.62,23.09,22.71,22.40,22.20,22,21.87,21.76,21.72,21.70,21.66,21.63,21.57,21.37,21.09,20.72,20.34,20,19.84,19.82,19.97,20.26,20.70,21.11,21.39,21.49,21.27,20.87,20.37,19.95,19.63,19.50,19.46,19.41,19.37,19.28,19.21,19.09,19,18.75,18.73,18.72,18.62,18.77,19.02,19.25,19.26,18.97,18.25,17.23,16.38,16.21,17.96,20,21,21,22,24,25,27,28,31,35,38,39,41,44,44,42,40,38,37,38,40,39,37,34,32,31,30,29,28,27,26,24,22,21,20,19,19,19,19,19,19,18,18,17.88,17.66,16.87,16.22,15.62,15.14,14.77,14.52,14.39,14.37,14.37,14.36,14.21,13.87,13.35,12.62,11.82,11,10.32,9.75,9.39,9.25,9.27,9.48,9.78,10.25,10.87,11.70,12.65,13.78,15.01,16.25,17.39,18.47,19.36,20.11,20.66,21.12,21.40,21.62,21.75,21.97,22.10,22.32,22.61,23.01,23.53,24.12,24.76,25.39,25.91,26.36,26.72,27.02,27.34,27.61,27.71,27.62,27.33,26.75,25.90,24.90,23.88,22.97,22.21,21.62,21.37,21.29,21.46,21.83,22.33,22.90,23.52,24.15,24.87,25.62,26.35,27.11,27.87,28.64,29.50,30.16,30.75,31.16,31.39,31.48,31.35,30.87,29.62,-9.78,-9.77,-9.73,-9.59,-9.35,-9.03,-8.72,-8.28,-7.84,-7.30,-6.75,-6.13,-5.52,-4.91,-4.35,-3.77,-3.22,-2.63,-2.05,-1.53,-1.04,-0.62,-0.17,0.23,0.51,0.74,0.86,0.90,0.92,1.02,1.13,3.07,5.75,9,12.60,15.52,17.49,17.46,18.42,19.41,20.41,20.45,20.48,18.50,16.57,14.37,13.20,12.21,11.85,10.07,10,10,10,11,12,13,15,19.87,22.98,24.77,25.28,26.20,26.37,28.38,31.53,34.70,37.33,38.97,40.40,42.24,42.25,41.87,41.20,41.42,42.40,42.88,43.14,43.08,42.87,42.38,41.29,39.25,37.03,35.01,33.86,33.14,33.27,33.89,35.09,36,39,42,47,53,61,70,74,75,77,77,70,65,65,66,66,60,54,49,42.97,35.92,29.10,24.12,23.15,22.23,22.27,23,24.33,27.24,31.07,35.65,39.64,38.64,36.34,35.32,35.28,35.75,36.52,34.90,33.38,31.72,30.10,28.25,26.52,25.03,23.87,23.11,22.61,22.25,21.99,21.75,21.61,21.50,21.48,21.51,21.63,21.77,21.87,21.85,21.62,21.26,20.83,20.36,20,19.78,19.83,20.08,20.52,21.13,21.86,22.41,22.62,22.36,21.73,21.01,20.46,20.09,19.87,19.78,19.72,19.57,19.34,19.08,18.82,18.58,18.28,18.14,18.10,18,18.24,18.48,18.61,18.51,18.12,17.46,16.50,16.34,17.13,19.01,22,23,23,24,26,29,30,31,34,37,39,40,42,44,45,43,41,37,35,36,37,38,36,34,31,30,29,28,27,26,25,23,22,21,20,20,20,20,21,20,19,19,19,18.99,18.03,17.25,16.52,15.84,15.27,14.91,14.74,14.71,14.75,14.86,14.87,14.74,14.36,13.70,12.83,11.86,10.95,10.15,9.62,9.26,9.14,9.22,9.38,9.66,10.07,10.59,11.33,12.34,13.53,14.89,16.25,17.51,18.60,19.47,20.13,20.62,20.95,21.12,21.20,21.33,21.32,21.37,21.51,21.84,22.27,22.85,23.57,24.25,24.89,25.45,25.87,26.22,26.53,27.01,27.46,27.83,28,27.88,27.37,26.50,25.39,24.22,23.02,22.01,21.24,20.70,20.40,20.45,20.75,21.27,22,22.84,23.72,24.59,25.52,26.50,27.50,28.46,29.37,30.23,31,31.64,32.14,32.48,32.62,32.62,32.37,31.87,-9.05,-9.03,-8.98,-8.84,-8.61,-8.30,-7.98,-7.55,-7.10,-6.55,-6,-5.42,-4.86,-4.28,-3.75,-3.27,-2.75,-2.13,-1.50,-0.90,-0.41,-0.03,0.26,0.52,0.74,0.87,0.91,0.97,0.97,0.99,1.11,2.13,5.82,9.72,12.62,15.58,17.51,19.49,20.47,20.89,22.47,22.48,22.50,21.54,18.62,15.21,12.23,10.16,10.01,9.01,9,10,10,11,12,13,16,20.12,22.20,23.25,24.32,24.35,26.37,27.38,30.53,34.50,38.33,40.26,42.02,43.62,45.24,44.33,43.52,42.96,42.83,42.95,43.24,43.52,43.77,43.54,42.23,39.70,37.42,35.85,35.03,34.37,33.61,35,36,38,40,43,47,52,60,70,77,80,83,80,75,71,72,72,69,62,56,50,43,35,29,25,24,23.04,23.12,23.91,25.22,28.25,32.27,36.71,37.20,36.29,34.28,33.27,33.25,34.77,35.57,34.47,32.04,30.32,28.66,27.12,25.62,24.27,23.25,22.58,22.12,21.76,21.49,21.24,21.02,20.91,20.96,21.12,21.41,21.76,22.01,22.02,21.75,21.25,20.62,20.02,19.60,19.37,19.41,19.75,20.38,21.25,22.16,22.95,23.25,22.99,22.25,21.37,20.65,20.32,20.21,20.16,20.08,19.83,19.41,18.99,18.53,18.22,18,17.76,17.62,17.62,17.82,18.03,18.11,17.86,17.37,16.62,16.33,16.26,18.10,20,23,23,24,26,28,30,31,32,34,38,38,39,41,44,44,41,39,37,34,33,33,35,34,33,30,29,28,27,26,25,24,23,22,21,21,21,21,21,21,20,20,19,20,20,18.99,17.96,16.89,15.97,15.37,15,14.89,14.99,15.15,15.37,15.47,15.34,14.87,14.01,12.89,11.75,10.66,9.85,9.27,9,8.91,9.07,9.26,9.50,9.72,10,10.60,11.62,13.01,14.62,16.20,17.51,18.62,19.39,19.96,20.27,20.47,20.51,20.53,20.38,20.22,20.13,20.25,20.62,21.21,21.96,22.66,23.38,24.11,24.75,25.26,25.50,25.82,26.25,26.78,27.39,27.96,28.20,27.88,27,25.71,24.24,22.77,21.50,20.41,19.60,19.02,18.84,19.03,19.65,20.57,21.63,22.77,23.95,25.08,26.23,27.36,28.45,29.50,30.50,31.41,32.20,32.79,33.17,33.39,33.48,33.37,33.12,-8.41,-8.37,-8.27,-8.13,-7.91,-7.62,-7.25,-6.86,-6.37,-5.86,-5.28,-4.74,-4.17,-3.65,-3.03,-2.67,-2.25,-1.63,-0.98,-0.38,0.10,0.39,0.62,0.75,0.87,0.91,0.97,0.98,0.98,1,1.10,2.12,4.13,7.23,10.70,13.62,15.96,18.53,20.50,21.51,22.51,23.53,22.57,21.61,18.74,15.74,12.12,9.12,9.07,9,9,10,10,11,13,15,20,24.87,25.79,25.74,25.67,25.96,26.76,28.37,30.52,34.53,38.33,41.27,42.99,45.24,47.25,47.26,45.28,43.89,43.32,43.12,43.25,43.60,44.13,43.75,42.02,39.52,37.67,36.78,36.22,35.54,35.34,36.01,38,39,41,44,47,52,60,71,78,83,86,84,80,77,77,75,69,62,54,48,41,34,28,26,24,23,23.07,24.87,26.15,29.20,33.76,37.75,37.22,35.25,33.25,31.23,31.20,32.84,32.97,32.11,30.51,28.66,27.13,25.74,24.41,23.25,22.34,21.76,21.47,21.10,20.72,20.35,20.12,19.95,19.87,20.12,20.62,21.28,21.63,21.60,21.10,20.32,19.46,18.74,18.14,17.99,18,18.34,19,19.96,21.08,21.98,22.46,22.28,21.48,20.40,19.75,19.65,19.90,20.09,19.96,19.60,19,18.38,17.84,17.62,17.58,17.32,17,17.08,17.37,17.70,17.60,17.09,16.57,16.22,16.25,17.12,18.97,21,23,24,25,27,29,29,30,32,34,36,36,36,39,42,43,40,37,35,33,32,31,31,32,31,29,28,27,26,25,24,23,22,22,21,21,21,22,22,21,20,20,20,20,20,20,18.99,17.03,16.12,15.27,14.96,14.89,15.11,15.50,15.90,16.12,15.89,15.33,14.23,12.78,11.32,10.01,9.13,8.61,8.37,8.41,8.72,9.07,9.25,9.20,9.02,9.16,10.23,12,14.07,15.85,17.23,18.32,18.98,19.36,19.50,19.62,19.63,19.38,18.96,18.50,18.16,18.32,18.83,19.66,20.50,21.36,22.23,22.91,23.53,24,24.40,24.62,24.89,25.39,26.26,27.25,27.87,27.72,26.66,25.11,23.40,21.86,20.50,19.25,18.03,17.03,16.53,16.59,17.24,18.24,19.61,20.91,22.25,23.52,24.82,26.12,27.42,28.72,29.97,31.08,32.08,32.82,33.32,33.54,33.67,33.74,33.51,-7.78,-7.75,-7.63,-7.49,-7.25,-6.88,-6.49,-6.02,-5.43,-4.63,-3.80,-3.05,-2.65,-2.30,-2.02,-1.78,-1.50,-1.03,-0.50,0.12,0.57,0.75,0.86,0.89,0.95,0.97,0.98,0.99,0.99,1,1.08,1.88,2.89,4.86,7.76,10.70,13.64,17.62,19.59,20.59,21.60,22.61,22.63,21.67,19.75,14.82,10.87,8.92,9,9,9,10,10,11,13,16,22,28.87,28.79,27.75,26.71,26.65,26.62,28.61,30.49,34.40,38.35,40.28,43.27,46.26,49.26,48.29,45.34,44.37,43.17,43.09,42.95,42.86,43.79,43.83,40.88,38,37.17,37.29,37.48,35.71,35.98,37,39,40,42,44,48,53,61,71,78,86,89,88,84,80,78,74,68,62,54,46,39,33,28,26,24,23,24,24.92,26.89,29.86,35.84,39.82,38.79,35.79,32.82,30.84,30.86,30.89,31.75,30.62,28.50,27.25,24.98,23.71,22.46,21.22,20,19.75,19.39,19.12,17.84,17.59,17.23,16.86,16.49,16.14,17.86,18.52,19.27,19.03,17.87,16.65,15.50,14.38,14.26,13.32,14.12,14.12,14.10,16.11,17.13,18.20,19.26,19.37,18.50,16.62,15.83,17,18.23,18.49,18.75,18.07,17.38,16.75,16.14,15.60,17.07,16.37,15.71,15,16.24,17.47,16.73,15.99,15.28,15.50,15.66,16.87,18.98,22,23,24,25,27,28,29,29,31,33,34,34,35,37,40,42,39,37,34,33,31,30,29,29,29,28,27,27,26,25,24,23,22,22,22,21,22,22,22,21,20,20,21,21,20,20,19,17.99,15.95,14.83,14.72,14.62,14.52,15.39,16.25,16.16,16.09,14.97,13.85,11.73,9.57,8.36,7.14,6.91,6.75,6.61,7.40,8.25,8.21,8.12,6.99,6.50,7.25,10.25,12.96,14.72,16.50,17.34,18.24,18.20,18.14,18.12,18,17.95,16.87,15.86,15.84,14.86,15.85,16.91,17.99,18.95,19.96,21,21.12,21.32,21.51,22.59,22.41,23.22,23.95,25.72,27.47,27.34,25.13,23,20.99,18.87,17.84,16.76,14.78,12.86,11.97,12.01,12.27,14.21,15.36,17.52,18.75,19.91,22.08,23.27,24.50,26.76,28.03,29.37,30.73,32.12,32.49,32.78,33.12,33.51,33.91];
}

function getTileMap()
{
	return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,1,1,0,0,0,0,0,0,0,2,2,2,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,0,1,0,1,0,1,1,0,1,1,2,1,0,0,1,1,1,0,1,1,0,0,1,0,0,1,0,1,0,0,0,1,1,1,0,1,0,1,1,1,0,1,0,0,1,1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,1,0,0,1,0,1,0,0,1,1,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,0,0,0,1,1,2,1,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,0,2,2,2,0,0,0,0,1,1,0,1,1,0,1,0,1,0,1,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,1,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,2,2,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,1,1,0,0,1,1,0,0,1,0,2,2,1,1,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,1,0,0,0,1,1,1,1,1,0,0,0,1,0,0,1,1,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1,1,0,1,0,1,0,1,1,1,1,0,0,1,2,1,0,1,1,1,1,0,0,2,2,0,0,1,0,1,0,0,2,2,2,2,2,0,0,1,1,1,1,1,1,1,0,1,1,1,0,0,1,0,1,0,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,1,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,0,0,1,1,0,1,1,0,0,1,1,0,1,1,0,0,0,0,0,1,0,1,0,0,1,1,1,0,1,0,1,0,0,1,1,0,1,0,2,0,0,2,2,2,2,2,2,2,2,2,2,1,0,0,1,1,0,1,1,0,1,0,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,0,1,1,0,1,1,1,0,0,0,0,1,0,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,1,0,0,1,0,1,1,0,1,1,0,1,0,0,1,1,0,0,1,1,1,1,1,0,0,0,1,1,1,0,1,1,0,0,0,0,1,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,1,1,1,1,0,0,1,0,1,1,1,0,0,1,0,0,0,0,0,1,1,1,1,0,0,1,1,0,1,0,0,1,1,1,0,0,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,1,1,1,0,0,0,1,1,0,0,1,1,0,1,0,1,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,1,1,0,1,0,0,1,0,1,0,0,0,1,0,1,0,0,1,1,0,0,0,0,0,1,1,0,0,1,0,0,1,0,1,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,0,0,1,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,1,0,0,1,1,0,1,0,1,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,1,1,0,0,1,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,0,0,1,0,0,0,0,0,0,1,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,1,1,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,1,1,0,0,0,0,1,0,1,2,2,2,2,0,0,0,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,2,1,1,0,1,1,0,0,1,0,0,1,0,0,1,0,1,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,1,1,1,0,0,1,0,0,0,1,1,0,0,1,0,0,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,2,2,2,2,2,0,2,0,0,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,1,0,1,1,0,0,0,1,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,0,1,0,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,1,1,1,0,0,1,0,0,0,1,1,1,1,0,1,1,1,0,1,1,0,1,1,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1,0,1,1,0,1,0,1,1,0,1,1,0,0,1,1,0,1,1,1,0,1,1,0,0,1,0,0,0,1,0,1,0,0,1,1,0,0,0,1,1,2,2,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,1,1,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,0,1,0,1,0,1,0,1,1,0,0,0,0,0,0,2,2,2,2,2,2,0,2,2,0,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,1,1,1,1,0,0,1,1,0,1,1,1,0,0,1,0,1,1,0,0,1,0,1,0,1,0,0,0,0,0,0,1,0,0,0,1,1,0,1,1,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,1,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,0,2,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,1,0,0,1,0,0,1,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,1,0,0,1,1,0,0,1,1,1,1,0,1,0,0,0,1,1,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,0,0,1,1,1,1,0,1,1,0,1,1,0,1,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,1,0,1,0,0,1,0,1,1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1,1,0,0,1,1,0,0,1,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,0,0,0,0,1,1,1,0,1,1,0,0,1,0,0,0,1,0,1,1,1,1,1,0,1,1,0,0,0,0,1,0,0,0,1,0,0,0,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,1,0,1,0,0,1,1,0,0,1,1,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,1,1,1,0,1,0,1,0,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1,0,0,0,1,0,1,1,0,0,1,0,1,0,0,1,1,1,0,1,0,1,1,0,0,1,1,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,0,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0,1,0,1,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,1,1,1,1,1,0,1,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,1,0,0,1,0,1,1,0,1,1,1,0,0,0,0,1,1,0,1,0,0,1,0,0,0,0,1,0,1,0,1,0,0,1,0,1,0,0,1,1,1,1,1,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,1,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,1,0,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,1,1,0,1,1,1,1,0,1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,0,1,0,0,1,1,0,0,1,1,1,2,2,2,0,0,0,2,2,0,0,0,0,0,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,0,1,1,0,1,0,1,0,1,1,0,1,0,0,1,1,0,1,0,1,0,1,0,1,0,0,1,1,0,0,1,0,1,0,1,1,1,1,0,1,0,0,0,0,1,1,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,1,1,0,0,0,0,1,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,0,0,0,1,0,0,0,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,0,1,0,0,1,0,1,0,0,0,1,1,0,1,0,0,1,0,0,0,0,0,1,1,1,1,0,1,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0,0,2,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,1,0,0,1,0,0,1,1,0,0,0,0,0,1,1,1,0,1,0,0,0,1,1,0,0,0,0,1,0,1,0,1,0,1,1,1,0,0,0,1,1,1,1,1,1,0,1,1,1,0,1,0,1,1,0,0,1,1,1,1,0,0,1,0,1,0,1,0,0,0,0,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,1,0,1,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,0,1,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,1,1,1,0,1,1,1,0,1,0,1,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,1,1,1,1,0,1,0,0,1,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,1,0,1,1,0,0,0,1,1,1,1,0,1,1,0,0,0,1,1,1,0,0,1,1,1,0,1,0,0,1,0,1,1,1,1,1,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,1,1,0,0,1,1,1,1,1,0,0,0,0,0,1,0,1,1,1,1,0,1,1,0,1,0,1,1,1,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,1,1,1,0,1,0,1,1,1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,1,0,1,1,1,0,0,1,1,0,1,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,1,1,1,1,0,0,1,1,0,0,1,0,0,1,0,0,1,0,1,0,1,0,1,1,1,1,0,0,1,0,0,0,1,0,1,0,1,1,1,1,0,1,0,1,1,1,1,1,0,0,1,0,0,0,1,1,1,0,1,1,1,1,0,1,0,1,1,1,0,1,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,0,1,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,0,1,1,0,0,0,0,1,0,0,0,1,1,1,1,0,0,1,0,1,0,0,0,1,0,0,1,1,0,1,1,0,0,1,1,1,1,1,0,1,0,0,0,1,1,0,1,0,0,0,1,1,0,0,1,1,0,0,0,1,0,1,0,0,1,1,1,1,0,1,1,0,1,1,0,0,1,1,1,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,0,0,1,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,1,1,0,0,1,0,0,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,1,1,1,1,1,1,0,1,0,0,1,1,1,0,1,1,0,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,0,0,1,1,0,1,0,1,0,1,1,1,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,1,1,0,1,1,0,0,1,1,1,0,0,0,0,1,0,0,1,1,0,0,0,1,0,1,0,0,1,0,1,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,1,0,1,0,0,1,1,1,0,0,1,1,0,1,0,1,0,1,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,0,0,0,1,0,1,1,0,1,1,1,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,0,1,0,1,1,0,1,1,1,1,0,1,0,1,0,1,1,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,1,0,1,1,1,1,0,0,1,1,0,0,0,1,0,0,0,0,0,1,1,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,1,0,1,1,0,1,0,1,1,0,0,0,1,0,1,0,1,0,1,1,0,0,1,0,0,1,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,1,1,0,0,1,0,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,1,1,0,1,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,1,1,0,1,1,0,0,1,1,0,1,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,1,1,1,0,0,0,1,1,0,0,1,0,1,1,1,0,1,0,0,1,1,1,0,0,0,0,0,1,1,0,0,1,1,0,0,1,0,1,1,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,1,0,0,1,0,0,0,1,1,0,1,1,1,0,1,0,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,1,1,1,1,0,0,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,1,0,0,1,1,1,1,1,0,1,0,0,0,1,0,1,0,1,1,1,1,1,0,0,1,0,0,1,0,1,0,1,1,1,1,1,0,0,1,1,0,1,0,1,1,1,1,1,1,0,1,0,1,0,0,0,0,0,1,1,1,1,1,0,1,0,0,1,1,1,0,1,1,1,0,0,0,1,1,0,1,1,1,1,0,1,1,0,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,1,1,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,1,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,1,0,1,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,1,1,0,1,0,0,0,1,1,0,1,0,1,1,1,1,0,1,1,0,0,1,0,1,1,1,0,0,1,0,0,1,0,0,1,0,1,1,1,0,0,1,1,0,0,1,0,0,0,0,1,0,1,1,0,1,0,1,0,1,0,0,1,1,0,0,0,1,0,1,1,1,0,0,0,1,1,0,1,1,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,1,0,1,0,0,1,1,0,1,0,0,1,0,1,1,1,1,0,1,1,1,0,1,1,0,0,0,0,0,1,1,1,0,1,0,1,1,1,1,0,1,1,0,1,0,1,1,0,0,0,0,0,1,0,0,1,0,1,0,1,1,1,1,1,1,1,1,0,1,0,0,1,1,0,1,1,0,1,0,0,1,1,0,0,1,1,0,1,0,0,1,0,0,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1,1,0,1,0,1,1,0,0,0,1,0,1,1,0,0,1,1,1,1,0,1,1,0,1,1,0,1,0,0,1,1,0,1,1,0,0,0,1,0,1,1,1,0,1,1,0,0,1,1,1,1,1,0,1,1,1,1,0,1,0,0,0,1,1,0,0,0,1,0,1,0,1,1,0,1,1,1,0,1,0,1,1,0,0,1,1,0,1,0,1,1,0,0,0,1,0,1,1,0,1,0,1,0,1,0,0,0,0,1,1,1,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,1,0,1,0,0,1,0,1,1,0,1,0,1,0,1,1,0,0,1,1,0,1,0,0,1,1,1,1,1,0,0,0,0,1,1,1,0,1,0,0,1,1,1,1,1,0,1,0,1,0,1,1,1,0,0,0,0,1,0,0,0,0,1,0,1,0,1,0,0,0,0,0,1,1,1,0,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,1,0,1,0,0,0,1,0,1,0,0,0,1,1,0,0,1,0,1,1,1,0,1,0,1,0,1,0,0,0,1,1,1,0,1,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,1,0,1,0,1,1,1,0,1,1,1,0,1,0,0,0,0,0,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,0,1,1,0,1,0,1,1,1,0,0,1,1,0,1,0,1,1,1,0,0,0,0,1,0,0,0,1,1,1,0,1,1,1,0,1,1,0,0,0,0,1,1,0,1,1,1,0,1,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,1,1,0,0,1,1,1,0,0,0,0,1,0,1,1,1,1,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1,0,0,1,1,1,1,0,0,1,0,0,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,1,0,0,1,1,1,0,0,1,0,0,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,0,1,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,1,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,0,0,0,1,1,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,1,1,1,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,1,1,1,0,1,0,1,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,0,1,1,0,0,0,0,1,1,1,1,0,0,0,1,0,1,1,0,1,1,0,0,0,1,1,0,1,0,1,0,1,1,0,1,0,1,1,0,1,1,1,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,1,0,1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,1,1,1,0,0,1,0,0,1,0,1,1,0,0,1,0,0,1,0,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,1,1,1,0,0,1,0,0,1,0,1,0,1,0,1,1,1,1,1,1,0,0,1,1,0,1,0,0,0,0,0,1,1,1,0,1,1,0,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,1,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,1,0,1,0,0,1,0,0,1,0,0,0,0,0,0,1,1,0,1,1,0,0,1,0,1,1,0,1,1,1,1,0,0,0,0,1,1,0,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,1,0,0,0,0,0,1,1,1,1,0,0,1,0,1,1,0,1,0,0,0,0,1,0,1,1,1,0,1,1,0,1,0,1,1,0,1,0,1,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,1,1,0,0,1,1,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,1,0,1,1,0,1,0,1,0,0,1,0,1,1,0,1,1,0,0,0,1,1,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,0,1,0,0,0,1,1,1,1,0,1,1,1,0,0,0,0,1,1,0,1,1,0,1,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,1,0,1,0,1,1,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,1,0,0,0,1,1,1,0,1,0,0,1,1,0,0,0,1,0,1,1,0,1,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,1,1,1,0,1,1,1,1,0,0,0,0,0,1,1,0,1,1,0,1,0,1,1,1,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,1,0,1,0,0,0,1,1,0,1,0,1,0,1,1,1,1,1,0,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,1,1,0,1,1,0,1,0,0,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,1,1,1,0,0,1,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,1,1,1,0,1,0,1,1,1,0,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,1,1,0,1,1,1,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,1,1,0,1,1,1,1,0,0,1,1,1,1,0,0,0,1,0,1,1,1,1,1,1,0,0,0,1,0,1,1,1,1,0,0,1,0,0,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,1,1,0,0,0,0,1,1,0,1,0,0,1,1,1,1,1,1,0,0,0,1,0,1,1,0,1,0,0,0,1,0,1,1,0,0,1,1,1,0,0,0,1,0,1,1,1,1,1,1,1,0,0,1,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,1,1,1,0,1,0,1,0,0,0,1,1,0,1,1,0,0,0,0,0,1,1,0,0,1,0,1,1,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,1,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,1,0,1,1,1,0,1,0,0,1,0,0,1,0,0,1,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,0,0,0,1,1,0,0,0,1,1,0,0,1,1,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,1,0,1,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,1,1,0,0,1,0,0,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,1,0,0,0,0,0,1,1,0,0,1,1,0,1,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,0,1,1,0,1,1,1,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,1,0,0,0,0,1,1,1,0,1,1,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,1,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,1,0,0,1,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,1,0,0,0,1,1,1,1,0,0,1,1,1,0,0,0,1,0,1,1,1,1,0,1,0,1,1,0,1,0,0,0,0,1,1,0,1,0,1,0,1,0,0,0,1,1,0,1,0,0,0,1,1,1,0,1,1,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,1,0,0,0,0,0,1,0,1,0,1,0,0,1,1,0,1,1,0,1,0,1,1,1,0,1,1,1,1,1,0,0,1,0,0,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,0,1,0,0,1,1,1,1,1,0,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,1,1,0,0,0,0,0,1,0,1,0,0,1,1,1,0,1,0,0,1,0,0,1,1,0,0,1,1,0,1,1,0,1,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0,1,1,1,1,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,0,1,0,0,1,0,0,0,1,1,0,0,1,1,0,1,1,0,1,0,0,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,0,1,1,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,1,0,0,1,1,1,0,0,0,1,1,1,1,0,1,0,1,1,1,0,0,0,0,1,0,1,1,0,1,1,1,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,1,0,1,1,1,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,1,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,1,1,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,1,0,0,1,0,0,1,1,0,1,0,1,0,0,1,0,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,1,0,0,1,1,0,1,0,1,1,0,0,1,0,0,0,0,1,1,1,0,1,1,0,1,1,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,0,0,0,1,0,1,0,0,1,1,0,0,0,1,1,0,0,1,0,0,0,1,0,1,1,1,1,0,0,0,1,0,0,0,0,0,1,0,1,1,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,0,1,1,1,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,1,0,0,1,0,1,0,1,0,1,1,0,0,0,0,0,1,1,0,0,1,0,1,1,1,1,0,1,0,0,0,1,1,1,1,0,1,0,1,1,0,0,1,0,1,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,0,1,1,0,1,1,0,1,0,1,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,1,1,0,0,1,1,1,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0,1,0,1,0,1,0,0,0,1,0,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,1,0,1,1,1,0,0,0,1,0,0,1,1,1,0,1,1,1,0,0,0,0,1,1,0,0,1,0,0,0,1,0,1,1,0,1,1,1,1,0,1,1,0,0,1,0,0,0,1,1,1,1,1,0,1,1,0,1,0,0,0,1,0,0,1,1,1,0,1,0,0,0,0,1,1,1,0,0,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,0,1,0,1,1,0,1,0,1,0,0,1,1,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0,0,0,1,1,1,1,0,0,1,0,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,1,1,0,1,0,0,0,1,0,1,1,0,1,0,0,1,0,1,0,0,1,1,0,0,1,1,0,1,1,1,0,0,0,1,0,1,0,0,0,1,0,1,1,1,0,0,1,1,1,0,1,1,0,0,0,1,1,1,0,1,0,1,0,1,0,0,1,0,0,0,1,1,0,1,1,0,1,1,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,1,1,1,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,1,1,1,0,0,1,1,0,1,1,0,0,1,0,1,0,1,0,1,1,0,0,0,1,0,1,1,0,0,1,0,1,1,1,1,1,0,0,1,0,0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,0,0,1,1,1,0,1,1,1,1,1,0,0,1,1,1,1,1,0,0,1,0,1,0,0,1,0,0,1,1,0,1,1,1,0,1,0,0,1,0,1,1,1,1,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,1,1,0,1,0,1,0,0,1,0,1,0,0,1,1,1,1,0,0,1,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,1,1,0,1,1,1,1,0,1,0,0,1,1,0,0,1,0,1,0,1,0,1,1,0,1,0,0,1,0,1,0,1,0,0,0,1,1,1,1,1,0,1,0,1,0,1,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,1,0,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,1,1,1,0,0,1,1,0,0,1,0,0,1,1,0,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,1,1,0,0,1,1,1,1,0,1,0,0,0,0,1,0,1,1,1,1,1,0,1,1,0,0,1,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,1,1,0,0,0,1,1,1,1,0,0,1,1,0,1,0,0,0,1,0,0,1,1,0,0,1,0,1,0,1,0,0,1,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,1,0,1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,0,0,1,1,0,0,0,1,1,1,0,1,1,1,1,0,1,0,0,1,0,0,1,1,1,0,0,1,0,1,0,1,0,0,1,1,0,1,1,0,1,1,1,0,1,1,0,1,0,1,1,0,0,1,0,1,1,1,1,0,0,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,1,0,1,1,1,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,1,1,1,1,0,1,0,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,1,1,1,0,1,0,0,1,0,0,1,0,0,0,1,1,0,0,0,1,1,0,1,1,1,0,1,1,0,1,1,0,1,1,0,1,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,0,1,0,1,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,1,1,1,0,1,0,0,1,0,0,0,1,1,1,0,1,0,0,1,1,0,1,0,0,0,1,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,1,1,1,0,1,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,1,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,0,1,0,0,1,1,1,0,1,1,1,0,0,1,1,1,0,0,0,1,1,0,1,1,1,1,0,0,0,0,1,1,0,1,0,0,1,1,1,1,0,0,1,0,0,0,1,1,1,0,1,1,0,0,0,0,0,1,0,0,1,1,1,1,1,0,1,0,0,1,1,1,0,0,0,1,1,1,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,1,0,1,0,1,0,1,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,0,0,1,1,1,1,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,1,0,1,1,0,1,1,0,1,1,0,1,0,1,0,1,0,0,1,0,1,0,1,1,1,1,0,1,1,1,1,1,0,1,1,1,0,0,1,0,1,0,0,1,1,1,1,0,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,1,0,1,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,1,0,0,1,0,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,1,0,0,1,0,1,1,1,0,1,0,1,1,0,1,0,0,0,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,0,1,0,1,0,0,0,1,1,0,0,1,1,1,1,1,0,1,1,0,0,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,1,1,0,1,0,1,0,1,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,1,0,0,0,1,1,1,1,0,1,0,1,0,0,0,1,1,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,1,1,1,0,1,0,1,0,1,1,1,0,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,0,0,0,0,0,1,1,0,1,1,0,1,0,1,0,0,1,1,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,1,1,1,0,1,1,0,1,0,1,0,1,0,1,1,1,1,1,1,0,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,1,0,0,1,0,0,0,1,0,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,0,0,0,1,1,0,0,1,0,0,1,0,1,1,1,0,1,1,0,0,1,1,0,1,1,0,1,0,0,1,1,0,1,1,1,0,0,1,0,0,0,1,0,1,1,1,0,0,0,1,0,0,1,1,1,1,1,0,0,1,0,1,1,0,0,1,0,1,1,0,0,0,0,1,1,0,0,1,0,1,0,0,1,1,0,0,1,0,0,0,1,1,0,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,1,1,0,1,0,0,1,1,0,1,1,1,0,0,0,0,0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0,1,0,1,1,1,0,0,1,1,1,1,1,1,1,0,1,1,0,1,0,0,1,1,1,0,0,1,0,0,0,1,0,0,1,1,1,0,1,0,1,0,1,1,1,1,0,0,1,1,1,1,1,0,1,0,1,0,0,1,1,1,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,1,1,0,0,1,0,0,0,1,1,1,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,0,1,1,0,1,1,1,0,1,1,0,1,0,0,1,0,0,0,0,1,0,0,0,1,0,1,1,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,2,2,2,0,0,1,2,2,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,0,1,1,1,1,1,0,1,0,1,1,1,1,0,1,0,1,0,1,1,1,0,1,1,0,1,0,1,1,0,1,1,1,1,1,1,0,0,0,1,0,1,1,1,0,1,0,0,1,1,1,0,1,0,0,1,1,1,0,1,0,1,1,0,1,0,1,0,0,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,0,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,1,0,1,1,1,1,0,0,1,1,0,0,1,1,1,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,2,2,0,1,0,1,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,1,1,1,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,1,0,1,1,0,1,0,1,0,1,0,0,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,1,1,0,1,1,0,0,0,1,1,1,1,0,0,1,0,1,1,1,0,1,1,0,1,1,0,1,0,1,1,0,0,1,1,1,0,1,0,1,0,0,1,1,1,1,0,0,1,0,1,0,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,2,2,0,0,0,0,2,2,2,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,1,0,0,0,1,1,1,1,1,1,0,1,0,0,1,1,0,1,0,1,0,1,0,1,1,0,0,0,0,1,0,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,1,0,1,0,1,1,0,1,0,0,1,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,1,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,1,0,0,1,1,0,1,1,1,0,0,0,1,1,0,0,0,1,1,0,0,0,0,1,1,1,0,1,1,0,1,0,0,0,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,2,2,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,0,1,0,1,1,0,1,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,0,1,0,1,1,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,1,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,1,1,1,0,1,0,0,1,0,0,0,0,0,1,1,1,1,0,1,0,1,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,2,0,0,1,0,0,1,1,1,0,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,1,0,1,1,0,0,1,1,0,1,0,1,1,0,1,0,0,1,0,1,1,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,0,1,1,0,0,1,1,1,0,0,0,1,1,0,1,0,0,1,0,1,0,1,1,0,0,0,0,0,1,1,0,1,1,1,0,1,1,1,0,0,1,1,1,0,1,1,0,1,0,1,0,0,1,0,1,0,1,1,0,1,0,1,1,0,1,0,1,1,0,0,0,2,2,1,1,0,1,1,1,1,1,1,0,0,1,1,0,1,0,1,1,0,0,1,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,0,1,1,1,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,0,1,1,0,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,1,1,0,1,1,0,0,1,1,0,0,0,0,0,1,0,0,0,1,0,1,1,0,1,0,1,1,0,0,0,0,1,0,1,1,0,1,0,1,1,1,0,0,0,1,0,0,0,1,0,1,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,1,0,1,1,1,0,0,0,0,1,0,0,0,1,1,1,0,1,0,1,1,1,1,1,2,2,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,1,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,1,1,0,1,1,1,1,1,1,0,1,0,1,1,0,1,1,0,0,0,1,1,1,1,1,0,1,1,1,0,1,1,0,1,1,0,0,0,1,0,0,1,0,0,0,0,1,1,1,1,0,1,1,1,0,0,1,0,1,1,0,0,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,1,1,0,1,1,0,0,1,1,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,1,0,1,1,0,1,1,1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,1,0,1,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,0,1,0,1,0,1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,1,0,1,1,0,0,0,1,0,1,1,0,1,0,1,1,1,1,0,1,1,0,1,0,1,0,1,1,0,0,1,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,0,1,1,0,2,2,2,0,0,0,0,1,0,1,0,1,0,0,0,1,1,0,0,0,0,0,0,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,0,1,1,1,0,0,1,1,1,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,1,0,0,1,1,0,1,1,0,1,0,0,0,1,1,0,0,1,0,0,1,0,0,1,0,0,1,1,1,1,0,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,0,0,1,0,1,1,0,0,0,0,1,0,1,1,0,1,1,0,1,0,0,0,1,1,0,0,1,1,1,0,0,1,1,1,1,0,0,0,1,0,0,0,0,0,0,1,1,0,1,1,0,1,1,0,2,2,0,0,0,2,0,0,0,0,0,0,1,1,0,1,1,1,1,0,1,1,1,0,1,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,1,0,0,1,1,0,0,0,0,1,0,0,1,0,1,1,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,1,1,1,0,0,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,1,0,1,1,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,0,1,0,1,0,0,0,1,0,0,1,1,0,1,0,0,1,1,1,0,1,0,1,1,0,0,1,0,1,0,1,1,0,1,0,1,0,0,1,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,2,2,0,0,0,2,0,0,0,0,1,1,0,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,1,0,0,1,1,0,0,1,0,0,0,1,0,1,1,1,0,1,1,1,1,1,1,0,1,1,1,1,0,1,0,0,1,0,1,1,0,1,0,1,0,1,0,1,1,1,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,0,1,1,0,1,0,0,1,0,0,0,0,1,1,0,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,1,0,0,1,0,1,1,1,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,1,1,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,1,1,1,0,0,1,0,1,1,1,0,1,1,1,1,0,1,1,0,1,1,0,0,0,0,1,1,0,0,1,1,0,1,1,1,1,1,1,1,0,1,0,0,1,0,1,0,0,0,1,1,0,1,1,0,0,1,1,1,1,0,1,1,1,1,0,1,1,0,1,0,1,0,0,0,1,0,1,1,1,0,0,1,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,0,0,0,0,1,1,0,0,0,1,0,1,1,0,1,0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,1,1,1,0,1,1,0,0,0,1,0,0,0,0,0,1,1,0,1,0,0,1,0,1,2,0,1,0,2,0,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,1,1,0,0,1,0,1,1,0,0,1,0,0,0,0,1,1,0,1,1,1,0,1,0,1,0,1,1,0,1,0,0,1,0,0,0,1,1,0,1,1,1,1,1,1,1,0,1,0,0,0,1,0,1,1,0,1,1,1,1,0,0,1,0,1,0,1,1,0,1,0,0,0,1,0,0,1,1,0,0,0,0,1,1,1,1,1,0,0,1,1,0,0,0,1,1,1,0,1,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,1,0,1,1,1,1,0,0,1,1,0,0,1,1,0,1,0,0,1,1,1,1,0,1,0,1,0,0,1,0,1,0,0,0,1,0,0,0,0,2,1,0,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,0,0,0,1,0,1,1,1,1,0,1,0,1,1,1,1,1,0,0,1,0,0,1,1,0,0,0,1,1,1,0,1,1,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,1,1,1,1,0,1,1,1,0,1,1,0,1,0,0,0,0,0,1,1,1,0,1,0,1,1,1,0,0,0,1,1,0,1,0,0,0,1,1,0,1,1,0,0,1,0,1,1,1,0,1,0,0,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,1,1,0,1,0,1,1,1,0,1,1,1,0,0,1,1,0,1,1,1,1,0,0,1,1,1,1,0,2,0,1,1,0,0,0,2,1,1,0,0,1,0,1,1,1,1,0,0,0,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,1,0,1,1,1,0,0,1,0,0,1,1,0,1,0,1,0,0,1,0,1,1,1,1,1,1,0,1,1,0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,1,0,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,1,1,1,1,0,0,1,0,1,0,1,1,0,1,0,1,0,0,1,0,1,1,0,0,0,0,1,0,1,0,0,1,0,1,0,1,1,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,1,2,1,1,1,0,0,0,2,0,0,0,0,1,1,1,1,1,0,1,1,1,0,1,0,1,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,1,0,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,0,1,0,1,0,0,0,0,1,0,1,0,1,1,1,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,0,1,0,1,0,1,1,1,1,0,0,0,0,1,0,1,1,0,0,0,0,1,0,1,0,0,1,1,1,1,1,0,1,0,0,1,1,1,0,1,1,1,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,1,0,0,1,1,0,0,0,0,1,0,1,0,1,1,1,0,1,1,1,0,1,1,0,0,0,1,0,1,0,1,0,0,0,1,1,0,1,1,1,1,1,0,0,0,0,1,1,1,0,0,1,0,1,1,1,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,0,1,0,0,1,0,0,1,0,1,1,0,1,1,0,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,1,1,1,1,1,0,1,1,0,0,1,1,0,1,0,1,1,0,0,1,0,0,0,1,0,1,1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,0,1,1,0,0,0,1,0,1,0,0,1,1,1,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,1,1,1,1,1,0,1,0,0,1,0,1,0,0,0,0,0,1,1,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,1,0,0,0,2,2,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,1,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,1,0,0,1,1,0,1,1,0,0,1,0,0,1,1,1,0,1,0,1,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0,1,1,0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,0,1,1,0,1,0,0,0,1,0,0,1,0,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,0,1,1,0,1,0,0,0,0,0,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,2,2,2,0,0,1,1,1,0,0,0,1,0,1,1,0,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,0,1,1,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,1,0,1,1,0,0,0,1,0,1,1,1,1,1,1,0,1,1,0,1,0,1,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,0,1,0,1,1,1,1,1,1,1,0,1,1,0,0,1,1,0,0,1,1,0,0,1,0,1,0,0,0,1,0,0,1,1,1,1,0,1,0,1,0,1,0,0,1,1,0,0,0,1,1,0,0,0,0,1,1,0,0,0,1,1,1,0,1,0,1,0,1,1,0,1,1,0,0,1,1,0,0,1,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,0,0,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,2,2,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,0,1,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,1,1,1,0,1,0,1,1,0,1,0,1,1,0,1,0,0,1,0,0,1,1,0,0,1,1,1,1,0,0,1,0,1,0,1,1,0,1,1,1,1,1,0,1,0,1,0,1,1,0,1,1,0,0,0,1,1,0,1,1,1,0,0,1,0,1,1,0,0,0,1,1,1,0,1,1,0,0,1,1,1,0,1,0,1,1,1,0,1,0,0,0,0,1,1,1,0,1,1,0,0,1,0,0,1,0,1,1,0,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,0,0,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,0,0,1,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,1,1,0,0,1,1,1,0,1,0,0,0,0,0,0,1,0,1,0,0,1,1,1,1,1,1,1,0,1,0,0,1,1,0,1,0,1,1,1,0,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,1,1,0,0,0,1,0,1,0,1,1,1,1,0,1,0,0,1,0,1,0,1,1,0,0,1,0,0,1,0,0,0,0,2,2,2,2,2,0,0,2,2,2,2,0,1,0,1,0,0,1,1,1,1,1,0,0,1,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,1,1,0,1,0,0,0,0,0,1,0,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,0,0,1,0,1,0,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,1,1,1,0,1,1,0,0,1,0,0,1,1,0,1,1,0,1,1,0,1,1,1,0,1,1,0,0,1,1,1,0,0,0,1,0,0,0,1,0,0,1,0,1,1,1,0,1,1,0,0,0,0,1,0,1,1,1,1,0,1,1,1,1,1,0,0,1,0,1,1,0,1,1,1,0,0,0,0,1,1,0,1,0,0,1,0,1,1,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,0,0,2,2,0,0,0,0,1,1,0,0,0,2,2,2,2,2,2,2,0,0,2,2,0,0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,1,1,1,1,1,0,1,1,0,1,0,0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,1,1,1,1,0,1,0,1,1,0,1,0,1,1,1,1,0,0,1,0,1,1,0,1,0,0,0,1,1,1,1,0,0,1,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,1,1,0,0,1,1,1,1,0,1,1,1,0,1,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,1,1,1,1,0,0,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,0,0,1,1,1,0,1,1,0,1,1,2,1,1,1,0,0,0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,0,0,1,1,1,0,0,0,0,1,0,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,0,0,1,1,0,1,0,0,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,0,0,0,0,0,1,0,1,1,1,1,0,1,0,1,1,1,1,0,0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,0,1,1,1,0,1,1,0,1,0,1,1,0,0,0,1,1,0,1,1,1,1,1,0,1,1,0,0,0,0,1,0,1,1,0,1,1,0,0,1,0,1,1,0,1,1,1,1,1,1,0,1,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,1,1,0,0,0,1,0,1,0,1,1,1,0,1,0,0,0,0,0,1,1,0,0,0,1,0,2,0,1,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,1,1,0,1,1,0,0,0,1,1,1,0,1,0,1,0,0,1,0,1,1,0,1,0,0,1,1,1,1,0,0,0,0,0,1,1,0,1,1,0,1,1,1,0,0,1,1,1,1,1,0,0,0,1,0,0,1,0,1,1,1,1,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,1,1,1,1,0,1,1,0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,1,1,1,1,1,0,0,1,0,0,1,1,1,1,1,0,0,0,0,0,1,0,1,1,1,0,0,1,0,1,1,0,1,1,1,1,0,0,1,0,0,1,1,1,1,0,1,1,1,0,1,1,1,0,0,1,1,0,1,1,0,0,1,1,0,0,1,1,0,1,2,0,1,0,1,1,0,0,0,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,1,0,0,0,1,1,1,0,0,1,1,0,0,1,0,0,1,0,1,1,1,2,2,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,1,0,1,0,1,0,1,0,0,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,1,1,1,1,1,0,1,1,0,0,0,1,1,1,0,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,1,0,1,1,0,1,0,1,1,1,0,0,0,0,0,0,1,1,1,0,1,0,0,1,1,0,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,1,1,0,0,1,0,0,0,0,2,2,2,2,2,0,0,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,1,0,0,1,1,0,1,1,0,1,0,1,0,1,0,1,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,1,1,0,1,0,1,1,0,0,0,1,0,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,1,0,1,0,0,0,1,1,0,1,1,0,0,0,1,0,1,0,0,0,0,0,0,1,0,1,0,1,1,1,0,0,0,0,0,1,0,0,0,0,1,1,0,1,1,0,1,1,0,1,1,0,1,0,1,0,0,0,1,1,0,0,0,0,1,1,1,1,0,1,0,1,0,1,1,1,1,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,0,0,0,2,0,0,2,2,2,2,2,0,0,2,2,0,0,0,1,1,1,0,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,1,0,0,0,0,1,1,1,0,1,1,1,2,2,2,2,2,2,2,2,1,0,0,1,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,0,0,1,0,1,1,1,0,1,0,0,1,1,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,1,0,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,1,0,0,0,0,1,1,1,1,0,1,0,0,1,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,1,0,0,1,1,1,0,0,0,0,1,0,2,2,2,2,2,2,2,2,2,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,1,0,0,1,0,1,0,0,1,0,1,0,1,0,0,1,1,0,1,0,0,1,1,0,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,1,0,1,1,1,1,1,1,1,0,0,1,1,1,0,1,1,0,1,1,1,1,1,1,0,1,1,1,1,1,1,0,1,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,1,0,0,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,1,0,2,2,2,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,1,1,1,0,1,1,0,0,1,1,0,1,0,2,2,2,2,2,2,0,1,1,1,0,0,1,0,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,1,0,0,0,1,0,1,1,0,1,1,0,1,0,0,1,0,0,0,0,0,1,1,0,1,1,0,1,1,1,1,0,1,0,0,1,1,0,0,0,0,0,1,0,1,1,1,1,0,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,1,0,1,1,1,0,0,1,0,0,0,1,0,1,0,0,1,1,1,1,1,0,0,0,1,1,1,0,0,1,0,1,0,1,0,1,1,1,0,0,0,1,1,0,1,0,0,0,1,0,1,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,0,0,1,1,1,1,1,0,0,0,1,2,2,2,2,2,2,2,0,0,0,0,1,1,0,1,1,0,1,1,0,0,1,0,1,1,0,1,0,0,0,1,0,0,1,1,0,0,0,1,1,0,1,0,1,1,0,0,1,1,1,0,1,1,0,0,0,0,0,1,0,0,0,1,1,0,0,1,1,0,0,0,1,0,1,1,1,0,0,0,0,0,0,1,0,1,1,0,1,0,0,1,0,0,1,1,0,0,1,1,1,1,1,0,1,1,1,1,0,1,0,1,1,1,1,1,1,0,0,0,1,0,0,1,1,1,1,0,1,0,0,1,0,0,1,0,0,1,1,0,1,0,1,1,0,1,0,1,1,1,0,0,1,1,0,1,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,1,1,0,0,0,2,2,2,2,0,2,1,0,0,0,0,1,0,1,1,1,1,1,0,1,0,0,1,1,1,1,0,1,1,0,1,1,1,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,0,1,1,0,0,0,0,1,1,1,0,1,0,0,1,0,0,1,0,0,0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,1,1,1,0,0,1,1,0,1,0,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,0,0,1,1,0,1,1,0,0,0,0,1,0,0,0,0,1,0,1,0,0,1,0,0,1,1,0,0,1,0,1,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,2,2,2,2,1,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,1,0,0,1,1,1,0,1,0,1,0,0,1,0,0,1,1,0,1,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,1,0,0,1,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,1,0,0,1,1,1,0,0,0,1,1,0,0,0,0,1,1,1,0,1,1,1,1,1,0,1,0,0,1,0,0,1,1,0,0,0,1,1,0,1,1,0,0,1,0,0,1,0,0,0,1,1,0,0,1,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,0,1,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,0,1,1,1,1,0,1,0,1,1,0,1,1,0,1,1,0,0,1,0,1,0,0,1,0,0,1,0,0,1,1,1,0,1,1,0,0,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,1,1,0,0,1,0,1,1,0,1,0,1,1,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,1,1,0,1,1,0,0,0,1,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,0,0,0,1,1,0,1,1,1,1,0,1,0,1,0,1,0,1,0,0,1,1,1,2,2,2,2,2,2,2,0,0,0,0,0,2,0,2,0,0,0,2,2,2,2,2,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,1,0,1,1,0,0,1,0,0,1,1,0,0,1,0,0,0,0,1,1,0,1,0,1,0,1,1,1,1,1,0,0,0,1,1,0,0,1,1,1,1,1,0,1,0,1,0,0,0,1,1,1,1,0,0,1,1,0,1,1,1,1,1,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,1,0,0,1,0,1,0,0,0,0,1,1,1,0,1,0,1,1,1,0,0,0,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,1,1,1,1,0,1,0,1,0,1,0,0,1,0,1,0,1,1,0,1,0,1,0,1,0,1,1,0,1,1,1,0,1,0,1,0,0,1,1,0,0,1,1,0,1,0,1,0,1,1,0,0,1,1,0,0,1,0,0,1,1,0,1,1,0,1,0,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,0,1,0,1,1,0,1,1,1,0,1,0,1,0,1,1,1,1,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,1,0,1,1,0,1,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,1,0,0,1,1,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,0,1,1,1,0,1,0,0,0,0,1,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,1,1,0,1,0,1,0,0,1,0,0,1,1,0,1,0,0,1,1,0,0,0,1,1,1,0,1,1,1,1,1,1,0,1,0,1,1,0,0,0,1,1,0,0,0,1,1,0,0,0,1,1,0,1,0,0,1,1,1,0,0,1,1,1,1,0,1,1,0,0,1,1,1,0,1,1,0,0,1,1,0,0,0,0,1,0,0,0,1,1,0,1,1,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,1,1,1,0,1,0,1,0,0,1,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,1,1,1,0,1,1,0,0,1,1,1,0,0,1,1,1,1,0,0,0,0,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0,0,0,1,0,1,1,0,0,1,1,1,1,1,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,0,0,1,1,1,0,1,1,1,0,0,0,1,0,0,1,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,1,1,0,1,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0,0,1,1,1,0,0,0,0,0,0,1,0,1,0,0,1,0,1,1,0,0,1,0,1,1,1,1,1,1,0,0,1,1,0,1,0,1,0,0,0,1,1,0,1,0,0,0,0,1,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,0,0,1,0,1,0,1,0,0,0,1,0,1,1,0,1,1,1,1,0,0,1,0,1,0,1,0,0,0,1,1,0,0,0,1,0,0,1,1,0,1,1,0,0,1,1,1,0,1,1,0,0,0,1,0,1,0,1,0,1,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,0,1,0,1,0,0,0,1,1,1,1,0,0,0,1,1,0,1,0,0,0,1,1,0,0,1,0,1,0,1,1,0,0,0,1,1,0,1,0,0,1,1,0,1,1,1,0,1,1,1,0,0,1,1,1,1,0,0,0,1,1,1,1,1,1,0,1,0,1,1,1,1,1,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,1,0,1,0,0,1,0,1,1,0,1,0,1,0,1,0,0,1,0,1,1,0,1,0,1,0,1,0,0,1,0,0,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,0,0,1,1,0,1,1,0,1,0,1,1,0,0,0,1,1,1,1,0,0,1,1,1,1,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,1,1,0,1,1,0,0,1,1,1,0,1,1,1,1,1,1,0,0,1,0,1,0,0,1,0,0,0,0,0,1,1,1,1,0,1,1,1,0,1,0,1,0,1,0,0,1,0,1,1,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,1,0,0,0,1,1,1,0,0,1,1,0,1,1,1,0,0,1,0,1,1,0,0,0,1,1,1,1,0,0,1,0,1,0,0,0,0,1,0,1,0,1,1,0,1,1,0,1,0,0,0,1,0,0,0,1,0,0,1,1,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,1,1,0,0,1,0,1,1,0,1,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,0,0,1,1,0,1,1,0,1,1,1,0,0,0,1,0,1,0,0,0,0,1,1,1,1,1,1,1,0,1,1,0,0,1,1,0,0,2,2,2,2,2,2,2,2,0,1,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,1,0,0,1,1,1,1,1,0,0,0,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1,1,1,0,1,1,1,1,1,1,0,1,0,1,1,1,0,1,0,0,1,0,1,0,0,1,1,1,0,1,1,0,0,1,0,1,0,0,0,0,0,1,1,0,0,1,1,0,1,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,1,1,0,0,0,1,1,1,0,1,0,1,1,1,1,0,0,1,1,1,1,1,1,0,1,1,0,1,1,1,0,1,0,1,0,0,0,0,1,0,1,1,0,1,0,1,0,1,0,2,2,2,2,2,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,1,1,0,0,1,0,1,0,0,1,1,0,1,1,1,1,1,0,0,1,1,0,1,0,0,1,0,0,0,1,0,0,0,1,0,1,1,1,0,0,0,1,1,0,0,0,1,1,1,0,0,0,1,1,1,1,0,1,0,1,1,0,0,1,0,1,0,1,0,1,1,1,0,0,1,0,1,0,1,0,0,0,1,1,0,0,1,1,0,0,1,0,1,1,1,1,0,1,0,1,0,1,1,0,0,0,1,1,1,1,0,1,0,1,2,2,2,2,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,1,1,0,0,0,0,0,0,0,1,0,1,1,0,1,0,0,0,1,1,0,0,0,1,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,0,1,0,1,1,0,1,1,1,1,1,1,0,0,1,1,0,0,0,1,0,1,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,1,0,1,0,1,0,1,1,1,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,1,1,1,0,1,1,1,1,0,1,0,1,0,0,1,1,1,0,2,2,2,2,0,0,0,1,0,1,0,0,0,0,0,1,1,1,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,1,1,1,1,0,0,1,1,1,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,1,1,1,0,1,1,1,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,0,1,0,0,0,0,1,1,1,1,0,0,0,0,1,0,1,1,1,1,0,1,0,1,0,1,1,1,0,0,0,0,1,1,1,1,0,1,0,0,1,1,1,0,1,1,1,1,1,0,1,1,0,0,1,1,1,1,2,2,2,2,2,2,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,1,0,1,1,0,1,1,0,1,1,0,1,1,1,1,0,1,0,1,1,0,1,0,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,1,0,0,1,1,0,0,0,0,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,1,1,0,0,1,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,1,1,0,1,0,1,2,2,2,2,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,1,1,1,0,1,0,0,0,0,1,1,1,0,1,1,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,0,0,1,1,0,1,0,0,0,0,0,1,1,0,1,1,1,0,1,0,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,1,1,1,1,0,0,0,0,1,1,0,0,0,1,1,1,1,0,1,0,1,0,1,1,0,0,1,0,0,0,0,1,0,1,0,0,1,1,1,0,1,0,0,0,0,1,0,1,1,1,1,1,1,0,1,1,2,2,2,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,1,1,1,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,1,0,1,0,1,1,1,0,0,0,1,1,1,1,0,1,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,0,0,1,1,1,1,1,1,0,1,0,1,0,1,1,0,0,1,1,1,1,1,1,0,0,1,0,0,0,1,1,0,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,2,1,0,0,1,0,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,0,0,1,0,0,1,0,0,0,1,1,0,1,1,1,1,0,1,0,1,0,1,0,1,1,0,1,0,0,0,1,0,0,1,1,0,0,0,0,1,1,0,1,0,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,1,1,0,1,0,1,1,1,0,0,1,1,1,1,0,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,1,0,1,0,0,1,1,2,1,1,1,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,1,0,1,0,0,1,1,0,0,1,1,1,0,1,0,0,0,0,1,0,1,1,0,1,1,1,0,1,1,1,0,0,0,0,1,1,0,1,1,0,1,1,1,0,1,1,0,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,0,1,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,1,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,1,0,1,0,1,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,1,0,0,1,1,1,0,1,0,0,1,1,0,0,0,1,0,1,0,1,1,1,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,0,0,1,1,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,1,0,1,0,1,1,1,1,0,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,1,0,0,0,1,1,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,0,1,0,1,0,0,1,0,0,1,0,1,0,1,1,0,0,0,1,0,1,0,0,1,1,1,0,1,1,0,1,1,0,0,1,0,1,1,1,1,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1,0,1,0,1,1,1,1,1,0,0,0,1,0,1,1,1,0,0,0,1,0,0,1,1,0,1,1,0,1,1,1,0,0,0,0,0,1,1,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,1,1,1,0,1,1,1,0,0,1,1,0,0,0,0,1,0,1,1,1,1,0,0,1,1,0,1,1,0,0,1,1,1,0,0,0,0,0,1,1,0,0,1,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,0,1,0,1,1,0,1,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,1,1,0,1,0,1,0,0,0,0,2,0,0,0,0,0,0,1,0,0,1,1,0,1,0,1,0,0,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,0,1,1,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,1,0,1,0,1,0,1,0,1,0,1,1,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,1,0,1,0,1,1,0,1,0,1,1,0,1,1,0,0,0,0,1,1,0,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,0,0,0,1,0,1,0,1,0,1,0,1,1,0,0,0,0,0,0,1,0,1,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,1,0,1,0,1,1,1,0,0,0,1,0,0,0,0,1,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,0,1,1,0,1,1,1,1,1,0,1,1,1,0,1,1,0,0,0,0,1,0,1,0,1,1,0,1,1,1,0,0,0,0,1,1,0,1,0,0,1,0,0,1,0,1,1,1,0,0,0,1,0,1,1,0,1,1,0,0,0,0,0,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,1,1,0,0,2,2,2,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,0,0,0,1,0,0,0,1,0,1,1,1,1,0,1,1,1,1,0,1,1,0,1,0,1,1,1,0,1,1,1,1,1,1,1,1,0,0,0,1,0,1,1,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,1,1,0,0,1,0,1,1,1,0,0,0,1,1,0,1,1,1,1,0,0,0,1,0,0,1,1,2,1,2,2,1,0,0,0,0,1,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,1,0,0,1,1,0,0,0,1,0,1,1,1,0,0,1,1,1,1,1,0,0,0,1,0,0,1,1,0,0,1,1,0,0,0,0,1,0,1,1,1,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,1,1,0,1,1,0,0,1,1,1,0,1,2,2,2,2,0,2,2,0,1,1,1,0,1,1,1,0,1,0,1,1,1,0,0,1,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,1,0,0,1,0,1,0,1,0,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1,1,1,0,0,0,0,0,1,0,1,0,1,0,1,0,0,0,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,1,0,2,2,0,2,0,0,2,0,0,1,0,1,0,0,1,1,0,0,1,0,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,0,1,0,1,1,1,1,0,1,0,0,0,0,1,1,0,1,1,0,1,1,0,1,0,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,0,0,1,0,1,1,1,0,1,1,0,0,1,0,0,0,1,1,1,0,1,0,1,0,2,2,0,2,2,0,2,0,0,1,1,0,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,1,1,0,1,0,2,2,2,2,2,0,2,2,0,1,1,0,0,0,0,0,0,1,1,0,1,0,1,1,1,0,0,0,0,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,1,2,2,2,2,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,0,1,0,1,1,0,1,0,0,1,1,0,0,1,1,1,1,0,1,0,0,1,0,0,0,1,0,0,1,0,1,1,1,1,0,0,1,0,1,1,1,0,0,0,0,0,1,1,0,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,1,0,1,1,0,1,0,1,1,1,1,0,0,1,1,0,0,0,0,0,1,0,1,0,1,1,1,1,0,2,2,0,2,2,0,2,2,0,0,0,1,1,0,0,0,0,0,1,0,1,0,1,1,1,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,2,2,2,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,1,1,0,0,1,1,1,0,1,0,0,1,0,0,0,0,0,1,0,0,1,1,1,0,0,1,1,0,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,1,0,1,0,0,1,0,0,1,0,1,0,1,1,1,1,0,1,1,0,1,0,1,0,1,1,1,1,0,0,1,0,2,0,0,2,2,0,0,0,1,1,0,1,0,0,1,0,1,0,1,1,0,1,1,0,1,1,2,2,2,2,2,2,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,1,2,2,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,1,0,0,0,1,0,1,0,1,0,0,1,1,0,1,0,0,1,1,1,1,0,0,0,1,1,0,0,1,1,1,0,0,1,1,1,1,0,1,0,1,0,0,1,1,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,1,0,1,0,1,0,0,1,0,0,0,0,1,0,1,0,1,1,1,1,0,1,1,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,2,2,2,2,2,2,2,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,2,0,1,0,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,0,1,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,0,1,0,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,0,0,1,0,1,1,0,0,1,0,1,1,1,0,1,0,1,0,1,1,1,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,0,1,0,0,0,1,0,1,0,1,1,2,2,2,1,2,2,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,0,1,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,0,1,1,1,0,0,1,1,0,1,0,0,0,0,1,0,1,1,0,0,1,0,1,0,1,1,1,1,1,1,0,0,1,1,1,0,0,1,1,1,0,1,0,0,1,1,0,1,0,1,1,1,1,1,0,1,0,0,1,0,1,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1,1,1,0,0,0,1,0,1,0,0,2,0,1,2,1,2,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,0,1,0,0,1,0,1,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,1,1,1,0,1,1,1,0,0,1,1,0,0,1,0,1,1,0,1,0,1,1,1,0,1,1,1,1,0,1,0,1,1,0,1,0,0,1,1,1,1,1,1,0,1,0,1,0,1,0,0,1,0,0,0,0,1,0,1,0,0,0,1,1,0,1,0,1,0,1,0,1,1,1,0,1,0,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,0,0,0,0,0,1,1,0,1,1,2,0,1,2,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,1,1,0,0,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,1,0,0,1,1,1,1,0,0,0,1,0,1,0,1,1,0,0,1,1,0,0,0,1,1,1,0,1,1,1,1,1,0,0,1,0,1,1,0,1,1,1,1,0,0,1,0,0,0,0,1,0,1,0,0,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,0,1,1,0,1,0,1,1,0,0,1,0,1,0,1,1,0,1,0,1,0,0,0,0,1,1,0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,1,1,1,1,0,0,1,1,0,1,1,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,1,1,1,1,0,1,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,1,0,1,0,0,0,0,0,1,1,1,1,0,1,0,1,0,1,1,1,1,0,1,0,0,1,1,0,1,0,1,1,0,0,1,1,0,1,0,1,0,0,1,1,0,0,0,0,1,0,1,0,0,1,0,1,1,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,1,1,1,0,1,0,1,1,2,2,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,1,1,1,1,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,0,0,1,1,0,1,1,0,1,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,1,1,0,0,0,0,1,1,0,1,1,0,1,1,1,0,1,1,0,0,0,1,0,1,1,1,1,1,0,1,0,0,0,1,0,1,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,1,0,0,1,1,1,0,1,0,2,2,2,2,2,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,2,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,1,0,0,1,0,1,1,1,1,0,0,1,0,0,1,0,0,1,1,0,1,1,1,0,1,1,0,0,1,0,0,0,1,1,0,1,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,1,1,0,0,0,1,1,1,0,0,0,1,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,1,0,1,1,1,0,0,0,0,1,1,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,1,0,2,2,0,2,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,0,1,0,1,0,0,0,1,1,0,1,2,2,2,1,0,1,0,1,0,1,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,1,1,1,0,1,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,0,1,1,0,0,0,0,1,1,0,0,1,1,1,0,1,0,1,0,0,0,1,1,0,0,0,1,0,1,0,0,0,0,1,1,0,0,1,1,1,0,1,0,0,1,0,1,0,0,1,1,1,1,0,0,0,1,0,1,0,0,1,1,1,1,0,1,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,1,0,1,0,1,0,1,0,0,1,1,0,0,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,0,2,0,2,0,0,0,0,0,0,0,0,2,2,1,1,1,1,1,0,1,0,0,0,1,1,1,1,0,0,0,2,2,2,2,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,1,0,0,0,1,1,0,0,1,1,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,0,1,0,0,1,0,1,0,1,0,1,0,1,0,1,1,1,0,0,1,1,0,0,0,1,0,1,0,1,1,0,0,1,0,1,0,1,0,1,1,1,0,1,1,1,0,0,1,0,1,0,1,1,1,0,0,0,1,1,0,0,1,0,0,0,0,1,0,0,0,1,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,1,0,1,0,0,1,1,0,0,1,0,0,0,0,1,0,0,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,1,1,0,0,0,0,1,0,1,0,0,1,0,1,1,1,1,2,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,1,0,1,0,1,1,1,1,1,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,1,0,1,1,0,1,0,1,1,1,1,1,0,1,1,0,0,0,1,0,0,1,0,0,1,0,0,0,1,1,0,1,1,1,0,1,1,0,0,1,1,1,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,1,0,0,1,0,0,1,1,1,0,0,1,1,1,1,1,0,2,1,0,0,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,1,0,1,0,1,0,0,1,1,0,1,1,1,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,0,1,1,0,1,1,0,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,0,0,1,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,1,1,1,0,1,0,1,1,1,1,0,0,0,0,1,1,0,0,0,1,1,0,1,0,1,0,0,1,0,0,1,0,0,1,1,0,1,0,1,0,0,1,1,0,1,1,0,1,1,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,1,2,2,2,2,1,1,1,0,1,0,0,0,1,1,1,1,0,1,1,2,2,2,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,1,0,0,1,1,1,1,1,1,0,1,1,0,1,1,0,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,1,0,1,1,1,1,0,0,1,0,1,1,0,0,0,0,1,0,1,1,1,0,1,1,0,1,1,0,1,1,1,1,0,0,0,0,1,1,0,1,0,0,1,0,1,0,0,1,1,0,0,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,0,0,1,1,0,1,1,1,0,1,1,1,1,1,0,1,0,0,1,1,1,1,1,1,0,1,0,1,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,1,0,0,1,0,1,1,2,2,2,0,1,0,1,1,0,0,1,1,1,0,1,0,1,0,2,2,2,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,1,0,1,0,1,1,1,1,0,1,0,1,1,0,0,1,0,1,1,0,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,1,0,1,0,0,1,1,1,1,1,0,1,1,0,0,1,0,1,1,1,0,1,0,0,1,0,0,1,0,0,1,0,1,0,1,0,1,1,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,0,1,1,1,0,1,1,0,0,1,1,0,1,1,1,1,0,1,0,0,0,0,1,1,0,0,1,1,0,1,0,1,0,1,1,0,0,0,0,0,1,1,0,1,0,1,1,1,0,1,2,2,2,2,1,1,0,1,1,0,1,1,1,0,1,0,0,1,0,0,2,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,1,0,1,0,0,0,0,1,1,0,1,1,0,0,1,1,1,0,1,0,0,1,1,0,2,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,1,1,1,1,1,0,0,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,1,0,1,0,0,0,1,1,0,0,1,0,0,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,1,1,0,1,0,0,1,1,0,1,0,1,1,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,2,2,0,0,1,1,1,1,0,1,1,1,1,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,1,0,0,1,0,1,0,1,1,0,1,1,0,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,2,0,1,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,1,1,0,1,1,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,1,0,1,1,0,0,0,0,1,1,0,1,0,1,1,1,0,0,1,0,1,1,0,0,1,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,1,1,0,1,1,1,0,1,0,0,0,1,1,0,1,1,0,0,1,1,0,1,0,1,1,1,0,1,0,1,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,2,2,0,0,1,1,0,1,1,1,1,0,0,1,0,0,0,1,1,1,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,1,0,1,0,1,1,0,1,0,1,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,1,1,0,1,0,0,0,0,1,1,1,0,1,0,1,0,1,1,0,0,1,1,1,1,1,0,1,0,1,0,0,0,0,1,0,0,0,0,1,0,1,1,0,0,1,1,1,0,0,0,1,0,1,1,0,1,0,1,0,0,1,0,1,0,1,1,0,0,0,1,1,0,0,1,0,1,1,0,0,1,1,0,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,2,2,1,0,1,1,1,1,0,0,0,1,0,1,1,0,1,1,0,1,1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,1,1,1,0,1,1,0,0,0,0,1,0,1,0,1,1,1,1,0,0,1,0,1,1,1,0,1,0,1,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,1,1,1,0,1,1,1,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,1,0,1,1,1,1,1,0,1,0,1,1,1,1,1,0,0,1,0,1,0,0,0,1,1,1,1,1,1,0,0,1,1,1,0,1,0,1,1,1,0,0,0,1,1,1,0,0,1,0,1,1,1,0,0,1,1,0,0,1,0,0,0,1,0,1,1,0,0,0,1,0,0,1,0,0,1,1,1,0,0,1,0,1,0,1,2,1,0,0,0,1,0,0,0,1,1,0,0,0,0,2,2,0,0,1,0,0,1,0,1,0,0,1,1,0,1,1,0,0,1,1,0,1,0,0,1,0,0,1,0,1,1,0,1,1,1,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,1,1,1,1,1,0,0,0,1,0,1,0,0,1,1,0,0,0,0,1,2,2,2,0,0,0,0,0,1,1,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,1,1,1,0,1,1,0,1,0,0,1,1,0,0,0,0,1,0,1,1,0,0,1,1,0,0,0,1,1,1,1,1,0,1,1,0,1,0,1,0,0,1,1,1,1,1,1,1,0,0,0,1,0,1,0,0,0,1,0,0,0,1,1,1,0,1,0,1,0,1,0,0,1,1,0,1,0,1,1,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,1,1,0,0,0,1,1,1,1,1,1,0,0,1,1,0,1,0,0,0,1,1,0,2,0,0,1,0,1,1,0,0,1,0,0,0,1,1,2,2,2,1,0,1,1,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,1,1,0,0,1,1,0,1,0,0,0,0,0,0,1,1,0,1,0,0,0,1,1,1,0,0,1,2,2,2,2,1,0,0,0,1,0,0,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,1,1,1,1,1,1,0,1,1,1,0,1,0,1,1,1,1,0,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,0,0,1,0,1,0,1,1,0,1,0,1,0,0,0,0,1,1,0,0,1,1,1,1,1,0,0,1,0,1,0,0,0,1,0,1,1,0,1,0,0,1,1,1,1,0,0,0,1,0,1,1,1,0,0,1,0,1,0,1,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,1,0,1,0,0,1,0,1,0,2,1,1,0,1,1,0,0,1,1,1,0,1,1,1,2,2,2,1,1,0,1,1,1,1,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,0,1,1,1,1,0,0,0,1,0,0,0,0,1,0,1,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,1,0,1,0,1,0,0,1,1,1,1,0,1,1,1,0,1,2,0,0,0,0,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,1,1,0,0,0,1,1,1,0,1,1,0,1,1,0,1,0,1,1,1,1,1,0,0,1,1,1,1,1,0,1,0,1,0,1,0,0,0,0,1,0,1,0,0,1,0,1,1,1,1,1,0,1,1,1,0,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,1,0,0,1,1,1,1,1,0,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0,1,1,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,2,2,2,0,0,1,0,0,0,1,0,0,0,1,1,0,1,1,0,1,0,0,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,0,1,0,1,1,0,0,0,0,1,1,0,0,1,1,0,1,0,0,0,0,1,1,0,1,0,1,1,1,0,0,1,0,1,1,0,0,2,0,0,1,0,0,0,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,0,0,0,1,1,1,0,0,1,0,1,1,1,1,0,1,1,1,0,1,1,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,1,0,1,1,1,1,0,1,0,0,0,1,0,0,1,0,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,0,1,0,1,0,0,0,0,1,0,1,1,1,1,0,0,1,1,0,1,0,1,0,1,1,1,1,1,0,0,0,1,1,0,1,1,1,1,0,0,1,1,1,1,0,1,0,0,0,1,1,0,1,1,2,0,0,0,0,0,1,0,0,1,1,1,1,0,0,2,2,0,0,1,0,1,1,1,1,0,1,0,1,1,0,1,0,1,0,1,1,0,1,1,1,1,0,0,0,1,0,0,1,1,0,1,0,0,1,1,0,1,0,0,0,0,0,1,1,0,0,1,1,0,1,0,0,1,0,1,1,1,1,0,1,0,1,0,1,0,0,1,1,0,0,1,1,0,0,0,0,0,2,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,0,1,0,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,1,1,0,0,1,1,1,0,1,0,1,0,1,1,0,0,1,0,1,0,0,0,0,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,1,0,0,1,0,1,0,0,0,1,0,1,0,0,1,1,1,1,0,0,0,1,0,1,0,1,1,1,2,0,0,0,0,0,1,0,1,0,1,0,1,1,0,2,2,0,0,0,1,1,1,0,1,0,0,0,1,1,1,1,1,1,1,0,0,1,1,1,0,1,1,0,1,1,1,0,0,1,1,1,0,0,1,0,1,1,1,1,1,1,1,0,1,0,1,0,0,1,0,0,1,0,1,1,1,1,0,0,1,1,0,1,0,0,0,0,1,0,0,0,2,1,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,1,0,0,1,0,0,1,1,0,1,0,1,0,0,1,0,1,1,1,0,1,1,0,0,0,0,1,1,1,0,1,1,0,1,1,1,0,1,1,0,0,0,1,0,0,1,1,0,1,0,0,1,0,1,0,1,0,0,0,0,0,1,1,1,0,0,1,1,0,1,1,1,1,0,1,0,0,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,1,0,1,1,0,1,0,0,1,1,0,0,1,0,1,0,1,1,1,0,1,0,1,0,0,0,0,1,0,0,0,1,0,0,1,1,0,2,0,0,0,0,0,0,0,0,0,1,0,1,0,1,2,2,0,0,0,0,1,0,0,0,1,0,0,1,1,1,0,1,1,1,0,1,1,1,1,0,1,0,1,1,1,0,0,1,0,0,1,1,1,1,1,0,0,0,0,1,0,1,1,0,1,1,0,1,1,0,0,1,1,1,1,0,1,0,1,1,0,0,0,0,1,0,1,0,0,0,1,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,1,0,1,1,0,0,1,1,0,1,1,0,1,1,1,1,1,0,0,1,0,0,1,1,0,0,0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,0,1,1,1,0,0,1,0,1,0,0,0,0,0,1,1,0,1,1,1,0,1,0,1,1,1,0,1,0,1,1,0,0,1,0,1,1,1,1,0,0,1,0,0,0,0,1,1,1,0,0,1,0,1,1,1,0,1,1,1,1,0,0,1,1,0,1,1,1,1,1,2,2,2,1,1,2,2,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,1,2,2,0,0,0,0,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,1,0,0,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,0,1,0,1,0,1,1,1,0,1,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,1,1,1,1,0,1,0,1,1,0,0,1,1,1,1,0,1,0,0,1,1,1,1,1,0,0,0,1,0,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,1,0,1,0,0,0,1,1,1,0,1,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,1,0,1,1,0,1,0,0,0,1,0,0,1,1,1,1,0,0,0,0,0,2,2,2,2,2,2,2,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,1,1,0,2,2,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,0,1,0,1,1,1,1,0,1,1,1,1,0,0,1,0,1,1,0,0,1,1,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,1,1,0,0,0,1,2,2,2,0,0,0,0,0,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,1,0,1,1,1,1,1,1,0,1,0,0,0,0,0,1,1,0,1,0,0,0,1,0,0,0,0,1,0,1,0,0,0,1,1,0,1,0,0,0,0,1,0,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,1,1,1,1,0,1,1,1,1,0,0,1,0,1,1,0,0,1,1,1,0,1,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1,1,2,2,2,2,2,2,1,0,0,1,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,1,2,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,1,0,1,1,1,1,0,0,1,1,1,1,1,0,1,0,0,0,0,0,1,1,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,1,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,1,1,1,0,1,0,1,1,0,1,0,0,0,0,1,0,0,1,0,1,1,0,1,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,0,0,0,1,0,1,0,1,1,1,0,1,0,1,0,0,0,0,1,1,0,1,0,0,1,0,0,1,0,0,1,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,1,0,0,1,0,0,1,1,0,2,2,2,2,2,2,0,1,0,0,0,0,2,2,0,0,0,0,0,0,0,1,1,0,1,0,2,2,0,0,0,1,1,0,1,0,0,0,1,1,1,0,1,1,0,0,0,1,1,1,1,0,0,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,0,0,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0,1,0,0,1,0,1,1,0,0,1,0,1,1,1,0,0,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,1,0,0,0,0,1,0,0,1,1,0,1,0,0,0,1,0,0,1,1,1,0,0,0,1,0,1,0,0,1,0,0,1,1,0,0,0,1,1,0,1,0,1,0,0,1,0,0,0,0,0,1,0,0,0,1,1,0,1,1,0,0,0,1,0,1,0,1,1,0,1,2,2,1,1,0,0,0,2,2,2,2,2,1,1,0,1,1,0,1,1,2,2,2,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,1,0,1,0,0,0,1,0,1,0,0,0,1,1,0,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,0,0,1,0,1,1,0,1,1,0,1,1,1,1,1,0,1,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,1,1,1,0,1,1,0,1,0,1,1,1,1,1,0,0,0,0,0,0,1,1,0,1,0,0,1,1,0,0,1,1,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,1,1,0,0,1,0,1,1,1,1,0,1,1,1,0,1,1,0,1,1,0,1,0,1,1,0,1,0,0,1,1,0,0,0,1,0,1,1,1,0,0,0,0,0,0,0,1,0,1,1,1,1,2,2,1,1,1,1,1,2,2,2,2,0,0,1,1,1,0,0,1,1,0,2,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,1,0,0,0,0,1,1,1,0,1,0,1,0,1,1,0,0,0,0,1,1,1,1,1,1,0,1,0,0,1,1,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,0,1,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,1,1,1,0,0,3,3,1,0,1,0,1,1,0,0,0,0,1,0,1,1,0,1,0,1,0,0,1,1,1,0,1,1,1,1,0,1,1,0,1,0,0,1,1,1,0,1,1,0,0,1,0,0,1,0,1,1,0,1,0,1,1,1,0,1,0,0,0,0,1,1,0,1,1,0,1,1,0,0,1,0,1,0,1,0,0,1,0,1,0,0,1,1,1,0,0,1,1,1,0,0,1,0,0,0,1,1,1,0,0,1,1,2,2,0,0,0,0,1,2,2,2,2,1,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,0,1,1,0,1,0,0,0,1,1,0,0,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,1,1,0,1,1,0,1,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,2,2,2,2,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1,0,1,1,0,1,1,1,1,0,1,1,0,0,1,0,1,1,1,1,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,1,1,0,0,0,0,0,1,1,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,2,2,2,2,2,2,1,0,0,0,1,2,2,2,1,1,1,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,2,0,0,0,2,0,1,1,0,1,1,0,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,1,0,1,1,1,0,0,0,0,0,1,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,1,1,1,0,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,0,0,1,0,0,1,1,0,0,3,4,3,0,0,0,1,0,0,0,0,1,0,1,1,0,0,0,0,0,1,0,0,1,1,0,0,1,1,0,1,1,0,1,1,1,0,1,0,1,0,1,1,1,1,0,0,0,1,1,0,1,1,1,0,1,0,1,0,1,0,0,1,0,0,0,1,1,0,0,1,1,0,0,1,0,1,0,0,0,1,1,0,1,1,1,0,0,0,1,0,1,0,0,0,0,0,1,1,0,0,1,0,2,2,1,1,1,1,1,0,1,2,2,0,1,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,2,0,0,0,0,1,0,0,1,0,1,1,1,1,1,0,1,0,1,0,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,1,0,1,1,0,1,0,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,1,0,0,1,0,0,0,1,1,1,1,1,3,4,3,0,2,2,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,1,1,1,0,0,1,0,1,1,1,0,0,1,1,1,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,1,0,1,0,1,0,0,1,1,0,0,1,0,0,0,0,1,1,1,0,1,1,0,1,1,1,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,2,0,1,2,0,1,1,0,1,1,1,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,1,1,1,0,0,0,0,1,1,0,1,1,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,2,2,2,2,0,0,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,1,0,1,0,1,0,0,0,1,0,0,0,0,1,2,0,1,1,3,3,0,2,2,0,0,0,2,0,0,0,0,0,1,1,0,0,0,1,0,1,0,0,0,1,1,0,1,0,1,0,0,1,0,0,0,1,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,1,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,1,0,0,1,0,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,1,2,2,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,1,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,0,1,0,0,0,0,1,1,0,1,0,0,0,0,1,0,1,0,1,0,0,1,1,1,0,0,1,1,1,0,0,1,1,0,1,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,1,0,2,2,1,0,0,1,2,0,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,1,0,1,1,0,1,1,0,0,2,2,0,3,1,3,3,4,0,2,2,2,2,2,2,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,1,0,0,1,0,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,0,1,0,1,1,1,0,0,1,1,1,0,1,1,1,0,1,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,0,1,0,0,1,1,0,0,0,1,0,0,1,0,1,0,0,1,0,1,1,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,0,0,0,0,0,1,0,1,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,1,0,0,1,1,0,1,0,0,0,0,1,0,0,1,0,1,0,1,1,0,0,1,0,1,1,0,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,2,0,0,3,4,4,4,4,3,3,0,2,2,2,2,2,2,0,0,1,1,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,1,0,1,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,0,1,1,1,1,0,1,1,1,0,1,0,1,0,1,1,0,1,0,1,0,0,1,1,0,1,1,0,1,0,0,1,1,1,0,0,1,0,0,0,1,1,1,0,1,1,1,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,1,0,1,1,0,0,0,1,1,0,0,0,0,1,1,1,1,1,0,1,0,1,0,0,0,0,1,0,1,1,1,0,0,1,1,1,1,1,1,0,1,0,0,0,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,2,2,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,2,0,0,3,4,4,4,4,4,3,3,2,2,2,2,2,2,2,0,1,0,1,0,1,0,0,1,1,1,0,0,1,1,0,0,0,1,1,0,0,0,1,0,0,1,1,1,1,1,1,0,0,1,0,1,1,0,0,1,0,1,1,0,0,0,1,1,0,1,0,0,1,0,1,0,0,0,1,0,0,1,1,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,0,0,1,0,0,0,0,0,1,1,0,0,1,0,0,0,0,1,0,1,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,1,0,1,1,0,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,1,1,1,0,1,1,0,1,1,1,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,0,0,2,2,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,3,4,4,3,4,4,4,0,2,2,2,2,0,2,2,0,1,1,1,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,1,1,0,1,0,1,0,0,0,0,0,1,1,1,1,0,0,1,0,1,1,0,0,0,1,1,1,0,0,0,0,0,1,0,1,1,1,0,1,0,1,0,0,0,0,1,0,1,0,1,0,2,2,0,1,0,2,0,0,0,0,0,0,1,0,1,0,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,0,1,0,0,1,0,1,0,0,1,1,1,0,1,0,0,0,1,1,0,1,0,1,1,0,0,0,1,1,0,1,0,0,1,0,0,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,1,2,2,2,2,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,1,1,1,3,3,3,3,4,4,4,2,2,2,2,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0,0,1,0,1,0,1,0,1,1,0,0,0,0,1,0,1,1,0,0,1,0,0,1,1,0,0,1,0,0,1,0,1,0,1,1,0,0,0,1,0,0,0,1,1,0,0,1,1,1,1,1,0,0,1,0,0,0,0,1,0,0,1,1,1,1,0,0,1,0,1,2,1,1,1,0,0,0,2,0,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,0,1,1,1,1,0,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,0,1,1,1,1,0,0,1,0,1,0,1,1,1,1,1,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,1,0,0,2,2,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,0,0,0,0,1,1,0,0,2,2,0,0,0,2,0,0,0,0,1,0,0,3,3,4,4,2,2,2,2,2,2,2,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,0,1,1,1,1,0,0,1,1,1,0,1,1,0,0,0,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,1,0,1,0,0,0,1,1,1,1,1,0,0,0,1,1,1,2,2,1,0,1,0,0,0,2,2,2,0,0,0,1,0,0,1,0,1,1,0,1,1,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,1,0,0,1,0,0,1,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,0,0,0,0,1,1,0,1,1,1,0,1,1,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,0,0,2,2,2,1,0,0,1,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,1,1,0,1,0,1,1,0,0,2,2,2,0,0,2,0,0,2,2,2,2,0,0,3,3,4,0,2,2,2,2,2,2,0,0,0,0,0,1,1,1,1,1,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,1,1,1,0,0,1,0,0,1,0,1,1,1,1,1,0,1,1,0,0,1,1,1,1,1,0,1,1,1,0,1,1,1,1,0,1,0,0,1,1,0,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,2,2,0,0,0,0,0,0,1,1,1,1,0,1,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1,0,1,0,0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,2,2,0,1,1,1,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,2,0,0,3,3,4,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,1,1,0,0,0,1,1,0,1,1,1,1,1,0,1,0,1,0,0,0,1,1,1,0,0,0,1,1,0,0,1,0,0,1,1,1,0,1,1,0,0,0,0,1,0,2,0,0,0,1,0,0,1,0,0,0,0,0,2,2,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,0,1,0,0,1,1,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,1,0,0,1,0,1,0,1,1,0,1,1,1,0,1,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,1,1,2,2,2,2,2,2,2,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,2,2,2,0,4,4,4,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,0,1,1,0,1,1,1,0,0,1,0,1,1,0,0,0,1,0,1,1,0,0,1,0,1,1,0,1,1,1,1,1,1,1,1,0,1,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,0,1,1,1,1,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,0,0,1,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,0,0,1,0,0,1,1,0,1,1,1,1,0,1,0,1,0,0,0,1,0,1,1,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,0,0,2,2,2,2,2,2,2,2,2,2,1,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,2,2,0,0,0,2,2,2,2,2,2,2,4,4,4,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,1,0,1,0,1,1,0,0,1,0,1,0,1,1,1,0,0,0,1,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,1,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,1,1,1,0,1,1,0,1,0,1,0,1,0,0,1,1,1,1,0,0,1,0,1,1,1,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,2,2,2,0,1,2,2,2,2,0,2,2,4,4,4,3,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,0,0,0,1,1,0,0,0,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,1,0,1,1,0,1,0,1,0,0,0,0,0,2,2,0,0,0,0,0,0,0,2,2,2,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,2,0,2,2,4,4,4,3,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,0,1,1,1,0,0,1,1,1,1,1,0,0,1,1,1,0,0,1,0,1,1,1,1,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,1,0,1,1,1,0,1,0,1,1,1,1,0,0,0,1,1,0,0,0,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,1,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,1,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,4,4,4,4,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,1,0,1,0,0,1,0,0,0,1,0,1,1,1,1,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,0,1,1,1,1,1,0,0,1,0,1,1,0,1,1,1,1,0,0,0,1,0,0,0,1,0,1,0,2,2,1,1,1,1,0,0,1,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,1,0,0,1,0,1,1,0,0,1,1,0,0,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,4,4,4,4,4,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,0,0,1,0,0,0,1,0,1,1,1,0,1,0,0,1,0,0,0,1,1,1,1,0,1,0,2,1,0,0,0,0,0,1,1,0,1,1,0,1,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,1,0,1,1,0,0,2,2,2,0,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1,1,1,0,0,1,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,1,1,0,0,1,1,0,1,1,1,1,1,0,0,1,0,1,1,1,1,1,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,1,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,1,4,4,4,4,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,1,0,0,1,0,0,0,1,0,1,1,2,0,2,2,1,0,0,1,0,0,1,0,0,1,1,1,0,0,1,1,0,1,0,0,0,1,0,0,1,0,0,0,0,1,1,1,1,2,2,2,1,1,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,1,0,0,1,1,0,0,1,0,1,1,0,0,1,1,0,1,1,0,1,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,1,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,4,4,3,3,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,1,0,0,0,0,0,1,0,1,1,0,0,0,1,0,0,1,1,1,0,0,0,0,2,0,2,0,1,1,0,1,1,0,1,0,1,1,1,0,0,0,1,0,1,0,1,1,0,0,0,0,1,0,0,1,1,1,1,0,2,2,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,1,0,1,0,1,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,0,1,0,0,1,1,0,0,0,1,1,1,0,0,1,0,0,0,1,1,1,1,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,2,0,0,0,0,1,0,1,1,0,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,0,0,1,1,0,0,0,2,2,2,2,2,0,2,3,4,3,3,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,2,0,2,0,0,1,1,1,0,1,1,0,1,1,0,0,0,1,0,0,0,0,0,1,2,0,1,1,1,1,0,1,0,0,0,1,0,2,0,1,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,1,0,0,1,1,1,1,1,0,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,0,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,1,1,0,1,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,0,0,1,1,1,0,1,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,0,1,1,1,1,0,1,1,0,0,1,1,0,0,0,2,2,2,2,2,2,3,3,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,0,0,1,1,1,0,1,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,1,1,2,2,2,1,1,0,1,1,1,1,1,0,0,1,0,1,0,1,1,0,0,1,2,2,2,1,0,1,1,1,1,1,0,1,1,0,2,1,0,0,1,1,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,1,0,1,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,0,0,1,1,1,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,0,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,0,1,1,0,0,0,0,0,0,1,1,1,1,1,0,0,1,0,1,1,1,0,1,1,0,0,1,2,2,2,1,1,1,0,0,0,1,1,1,1,0,1,1,0,1,0,1,2,2,2,2,1,1,0,0,0,1,1,1,1,0,1,0,1,0,1,0,1,1,0,1,1,0,0,1,1,1,0,0,0,0,1,1,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,1,0,0,1,1,0,1,0,1,1,1,1,1,0,1,0,1,1,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,0,2,0,2,2,2,2,2,2,1,1,2,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1,0,1,0,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,1,0,1,0,1,1,1,0,0,1,1,0,1,0,0,1,0,2,2,2,2,2,0,1,1,0,0,0,1,0,0,1,1,1,0,1,1,0,2,2,2,1,0,0,1,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,0,0,0,0,1,0,1,1,0,1,0,1,0,0,0,1,0,0,0,1,1,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,1,0,1,0,0,1,1,0,0,1,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,0,0,0,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,0,1,0,0,1,1,1,1,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,0,1,1,0,0,0,0,1,1,1,1,1,1,1,0,1,1,0,0,1,0,2,2,1,2,2,2,1,0,0,0,1,0,1,0,1,0,1,1,0,0,1,1,1,2,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1,0,0,0,1,0,1,0,1,1,1,1,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,0,0,1,0,0,0,1,1,0,0,1,0,0,0,1,0,1,0,1,0,1,1,0,1,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,1,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,1,1,1,0,0,1,1,1,0,1,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,1,0,1,0,0,0,1,1,1,0,0,0,1,0,1,0,0,1,1,1,0,1,0,0,1,1,0,1,0,1,1,1,0,1,0,1,0,1,0,1,0,0,0,1,1,1,1,0,0,1,1,2,2,1,2,2,2,1,0,1,0,1,1,1,0,1,1,0,0,1,0,1,0,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,1,0,0,0,0,0,0,1,1,0,0,1,0,0,1,1,0,1,1,1,1,1,0,1,1,0,1,0,0,1,1,0,1,1,1,0,0,1,1,1,1,0,1,0,0,1,1,0,1,0,0,1,1,0,0,1,1,1,0,1,0,0,1,0,0,0,1,1,0,0,0,1,0,0,0,1,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,1,1,0,0,0,0,1,1,1,1,0,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,0,1,0,0,1,0,0,0,0,0,1,0,1,1,1,0,1,0,1,0,0,1,0,1,1,1,1,0,0,0,0,1,0,0,0,0,1,1,0,0,1,1,0,1,0,1,0,0,0,1,0,1,1,2,2,2,2,2,2,0,0,0,0,0,1,0,1,0,1,0,0,1,1,0,0,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,1,0,1,1,0,0,1,1,0,1,1,0,1,0,0,1,1,0,0,0,0,0,1,0,0,0,1,0,1,1,0,1,0,1,1,1,1,1,1,0,0,1,1,0,1,1,0,0,0,0,0,1,0,1,0,0,0,1,1,0,1,0,1,1,1,1,1,0,1,1,0,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,2,2,2,0,0,0,0,2,2,2,1,0,2,2,2,2,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,1,1,0,0,1,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,1,0,0,0,0,1,0,1,0,1,1,1,0,0,1,0,1,1,0,0,1,0,1,0,1,1,1,1,0,1,0,0,0,0,0,1,0,1,0,0,0,1,0,1,0,0,1,0,1,0,0,2,2,0,2,2,1,0,0,0,0,1,1,0,0,0,1,1,0,1,2,2,2,2,1,1,0,2,2,2,2,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,0,1,1,0,0,1,1,1,1,1,0,1,0,1,1,1,1,0,0,1,1,1,0,0,0,1,0,1,1,1,0,1,0,1,1,0,0,1,1,0,0,0,0,0,1,1,1,0,1,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,1,1,1,0,0,1,1,1,1,0,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,1,0,0,1,1,1,0,0,1,0,1,0,1,1,1,1,1,1,0,1,1,1,2,2,2,2,2,2,1,0,1,1,1,1,0,0,1,0,0,0,1,0,2,2,2,2,0,0,1,2,2,2,2,0,0,0,0,0,2,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,1,1,1,1,1,0,0,1,0,1,1,0,1,0,1,1,1,0,0,0,1,1,0,1,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,0,1,0,0,0,1,1,0,0,1,0,1,1,1,0,1,0,0,0,0,1,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,1,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,1,0,0,0,0,1,0,0,1,0,1,1,0,0,1,1,0,1,0,1,0,1,1,0,0,0,1,0,0,1,0,0,1,1,1,1,0,1,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,0,0,0,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,1,1,1,1,1,2,2,2,0,0,0,1,0,2,2,2,2,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1,0,1,1,0,1,0,0,1,1,0,1,0,0,0,0,0,1,1,0,1,1,1,1,0,1,0,1,1,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,1,1,0,0,0,1,0,1,0,1,0,0,1,0,1,0,1,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,0,0,0,0,0,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,1,1,1,1,0,0,1,1,1,0,0,1,0,0,1,1,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1,0,0,1,0,0,1,0,0,1,0,1,0,1,0,0,0,1,0,1,1,1,1,1,0,0,1,1,1,1,1,0,0,1,0,1,1,0,0,0,1,1,0,1,0,0,1,0,0,1,1,0,0,0,0,0,2,2,2,2,2,2,2,0,0,1,1,0,0,1,0,1,0,0,0,0,1,2,2,2,2,1,1,1,0,0,2,2,2,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,1,1,1,1,1,1,0,1,1,0,0,1,1,0,0,1,0,0,1,0,0,1,1,1,0,1,1,1,1,0,1,0,1,1,1,1,0,1,0,1,0,0,0,1,0,0,1,1,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,0,1,1,0,1,1,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,0,0,0,0,2,1,1,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,1,1,1,0,0,1,1,0,0,0,1,0,1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,0,1,1,0,1,1,0,1,1,0,1,1,0,0,1,2,2,2,2,2,2,2,0,1,0,0,0,1,0,0,1,1,0,1,0,2,2,2,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,1,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,1,0,0,1,0,0,1,1,0,0,0,1,1,1,1,1,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,2,0,0,1,0,0,0,0,0,0,1,1,0,1,0,0,1,0,0,0,1,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,1,0,1,1,0,1,0,1,1,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,1,0,1,0,0,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,1,1,0,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,1,1,1,1,0,1,2,2,2,2,2,0,0,2,2,0,0,2,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,0,1,0,1,1,0,1,0,0,1,1,1,1,1,0,1,0,1,0,1,1,0,0,0,0,0,0,1,0,0,0,0,2,2,2,2,2,2,2,1,0,0,0,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,0,1,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,1,0,0,1,0,1,1,0,0,1,1,0,1,0,1,1,1,1,1,1,0,0,0,1,0,0,1,1,0,1,0,1,1,1,0,0,1,0,1,1,1,1,0,1,1,1,0,1,1,1,1,1,0,0,1,1,1,0,1,2,2,2,2,2,2,2,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0,1,1,0,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,1,1,1,1,0,0,1,1,0,0,1,0,0,0,1,0,1,0,1,0,1,1,1,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,1,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,2,0,2,2,0,2,2,2,2,2,2,2,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,0,1,1,0,1,0,1,0,0,1,1,0,0,1,0,0,0,0,1,1,1,0,0,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,1,0,1,1,1,1,0,0,1,1,0,0,1,0,1,1,1,0,0,1,0,1,0,1,0,1,1,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,1,1,0,1,0,0,1,1,0,1,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,1,0,0,1,0,1,0,0,1,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,2,2,2,2,2,2,0,2,2,1,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,0,1,1,0,0,1,0,1,0,0,1,1,0,1,0,1,0,1,1,1,1,1,0,0,0,0,0,1,0,0,0,1,1,1,1,0,1,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,1,1,1,1,0,1,0,1,1,0,1,1,1,1,0,1,0,0,1,0,1,1,0,1,1,1,0,1,0,1,0,1,1,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,1,1,1,1,1,1,0,0,1,0,1,1,0,0,1,1,1,0,0,0,0,1,0,0,1,1,1,2,2,2,1,2,2,2,0,0,1,1,1,1,0,1,0,1,1,0,0,0,0,1,1,1,2,2,1,0,0,2,2,2,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,0,1,0,0,0,1,0,1,1,2,2,2,2,2,2,2,2,2,2,0,1,1,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,0,1,0,0,1,0,1,0,0,1,0,1,1,0,1,0,1,1,0,0,1,0,0,0,0,1,0,0,1,0,1,1,0,1,1,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,1,0,0,1,1,0,1,1,1,0,0,1,1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,1,0,2,2,2,2,1,2,2,2,0,0,1,0,0,0,0,0,1,1,0,1,1,1,0,0,0,2,2,2,0,0,0,2,2,2,2,2,0,0,0,0,0,1,0,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,1,1,0,1,1,0,0,1,1,1,0,1,1,0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,1,1,0,1,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,1,0,1,1,0,0,1,1,1,1,0,0,1,0,0,0,1,1,0,0,0,1,0,1,1,1,0,0,1,1,1,1,1,0,1,0,1,1,1,1,1,0,1,0,1,0,1,1,0,0,0,1,1,1,0,1,0,1,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,1,1,0,1,0,1,1,1,0,1,0,0,0,0,0,1,0,1,0,0,1,1,1,0,1,1,0,0,1,1,1,1,1,0,1,1,0,2,2,2,2,2,2,2,0,0,0,1,0,0,0,0,0,1,1,0,0,0,1,0,0,2,2,2,2,1,0,0,0,2,2,2,2,2,2,0,0,0,1,0,1,0,1,1,1,1,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,0,0,1,0,1,1,0,1,1,0,1,1,0,0,0,0,1,1,0,1,0,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,0,0,0,1,1,0,0,1,1,1,1,0,1,1,0,0,0,0,0,2,2,2,2,2,2,2,0,1,1,1,1,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,1,0,1,1,1,0,0,0,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,1,1,0,1,1,0,1,1,0,0,0,1,0,1,1,1,0,1,0,0,1,1,0,0,1,0,1,0,1,0,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,0,0,0,0,1,0,1,0,1,1,0,0,0,1,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,1,0,0,0,0,2,1,1,1,0,0,0,1,1,1,1,2,2,2,1,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,1,1,1,0,0,1,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,1,0,1,1,0,1,1,1,0,0,0,1,1,1,1,1,0,1,1,1,0,1,0,0,1,0,0,0,0,2,2,2,2,2,2,0,1,0,0,1,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,0,0,0,1,0,1,1,1,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,1,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,1,0,1,1,0,0,1,1,0,1,1,0,1,0,1,0,0,0,1,1,1,0,1,1,0,0,1,0,1,0,1,1,0,1,0,0,0,1,1,0,0,1,1,0,1,0,1,0,0,0,1,1,1,0,1,1,0,1,1,0,0,1,0,1,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0,1,0,0,0,1,1,1,1,0,1,0,0,1,0,0,0,2,2,2,1,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,0,1,0,1,1,0,0,0,0,0,1,0,1,0,0,1,1,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,2,2,1,0,0,0,1,0,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,1,1,0,1,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,1,1,0,0,1,0,1,1,1,0,1,1,0,0,1,0,1,0,0,1,0,1,1,0,0,0,0,1,1,0,0,1,1,1,0,0,1,1,1,0,1,0,1,0,1,0,1,1,1,1,1,1,0,1,0,1,0,1,1,1,0,0,0,1,0,0,0,0,1,0,1,1,1,1,0,0,1,1,0,0,1,0,0,1,0,0,0,0,1,0,1,1,1,1,1,0,1,0,0,0,1,1,1,0,0,0,0,1,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,2,2,0,0,0,1,0,1,1,0,1,2,2,2,2,1,1,0,0,0,0,0,0,0,2,2,0,0,0,0,0,1,0,0,0,1,0,1,1,1,0,1,1,1,1,0,1,0,0,1,0,1,1,0,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,1,0,1,0,0,1,0,1,1,1,0,1,1,0,0,0,1,0,1,0,0,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,0,1,1,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,1,1,0,1,0,0,0,1,1,0,1,1,1,1,1,1,0,0,1,1,0,0,1,0,0,1,0,1,1,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,1,1,0,1,0,0,1,0,0,0,1,1,1,1,1,1,1,0,1,1,0,1,0,0,0,1,1,1,0,0,1,0,0,1,1,1,0,0,1,0,0,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,1,1,0,1,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,2,0,0,0,2,0,0,0,0,0,1,1,1,1,1,1,0,0,1,0,1,1,0,0,1,0,1,0,0,1,0,0,1,1,0,0,0,1,0,0,1,1,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,1,1,1,0,0,0,1,1,1,0,1,1,0,0,1,1,0,1,1,1,1,0,1,1,1,0,0,1,1,0,0,0,0,0,1,1,1,1,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,0,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,0,1,0,1,0,0,1,0,1,1,1,0,1,0,0,0,0,1,0,0,1,1,0,0,1,0,1,1,0,1,1,1,1,1,1,0,1,0,0,1,1,1,0,1,0,1,1,0,0,1,0,1,1,1,0,1,1,1,1,0,1,0,1,0,1,1,1,0,1,0,1,1,0,0,1,0,1,1,1,1,1,0,0,1,1,0,1,0,1,0,0,1,1,1,0,1,0,0,0,0,0,0,1,0,1,0,0,1,0,1,0,0,1,0,2,2,2,2,1,0,0,0,0,0,0,0,2,2,0,2,2,2,1,1,1,0,0,1,0,1,1,0,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,1,1,0,1,0,1,1,1,0,0,0,1,0,1,0,1,1,1,0,0,1,1,1,1,0,0,1,1,0,1,0,1,0,0,1,0,1,0,0,1,1,0,1,1,1,0,0,1,1,1,1,1,1,0,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,1,1,0,0,0,1,0,0,1,0,0,0,1,1,0,1,1,0,0,0,1,1,1,0,1,1,0,1,0,0,1,1,0,0,1,0,0,0,1,1,1,1,0,1,1,0,0,1,1,0,0,1,0,0,1,1,0,0,0,1,1,1,1,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,0,0,1,1,0,0,1,1,0,1,0,1,1,0,1,1,1,1,0,1,0,1,0,0,1,0,1,1,1,0,1,0,0,0,0,0,2,2,2,2,2,0,1,0,0,0,0,0,0,0,2,2,0,0,0,0,1,0,0,1,1,0,1,0,0,2,2,2,0,0,0,0,2,2,0,0,0,1,0,2,0,0,0,2,2,0,0,1,0,0,0,0,1,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,1,0,1,1,1,0,0,0,0,1,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,1,0,1,0,0,1,1,0,1,0,0,0,1,1,1,0,1,1,1,1,0,1,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,0,0,1,0,0,1,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,0,0,0,1,0,1,1,0,1,1,1,0,0,0,1,0,1,1,1,1,0,0,1,0,0,0,1,1,1,1,0,1,1,0,1,0,1,0,1,0,0,0,0,0,1,0,1,1,1,1,1,0,0,0,0,1,1,0,0,0,1,0,0,1,1,0,1,1,0,0,1,1,0,0,1,0,0,1,1,1,1,0,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,2,2,2,2,2,1,0,0,0,0,0,0,0,0,2,2,2,2,0,1,1,0,1,1,0,0,0,0,0,2,2,2,0,0,2,2,2,0,0,1,1,0,1,2,0,0,2,0,2,2,0,0,1,0,1,0,0,1,0,1,0,1,1,0,1,0,1,1,0,1,1,0,0,0,0,0,1,0,1,0,1,1,0,2,2,2,2,2,0,0,0,1,0,1,1,1,0,0,1,1,0,0,0,1,1,0,1,0,1,1,1,0,0,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,1,1,1,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,0,2,2,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,1,0,0,1,0,1,1,0,1,0,1,1,1,1,0,1,0,0,1,0,0,1,0,1,0,0,1,0,1,1,1,1,0,0,0,1,0,1,1,1,0,0,1,0,1,0,1,0,1,0,0,0,0,1,1,0,0,0,1,1,1,1,0,1,1,1,1,0,0,0,0,0,2,2,2,2,0,1,1,0,0,0,2,2,0,0,0,2,2,2,0,1,1,1,1,0,0,1,1,0,0,2,2,0,0,0,2,2,2,0,0,1,0,0,1,0,0,0,0,0,0,2,0,0,1,1,0,0,0,0,1,0,1,1,1,1,1,1,0,0,1,0,1,0,1,0,1,1,0,1,1,0,1,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,0,1,1,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,1,2,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,2,2,2,2,2,2,2,2,2,2,0,2,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,2,2,0,0,0,0,1,0,1,1,1,1,0,0,0,1,0,0,1,1,1,1,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,1,1,1,1,0,0,0,1,1,0,0,1,1,1,1,0,1,1,1,0,0,0,1,1,0,1,1,0,0,1,1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,1,1,0,1,1,0,0,1,0,0,1,1,1,0,2,2,2,2,1,1,1,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,2,2,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,1,0,1,1,0,0,0,0,1,1,0,1,0,0,2,2,2,2,2,2,2,2,2,2,1,0,1,1,1,0,0,0,1,1,1,0,1,0,1,0,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,0,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,0,1,0,1,0,1,0,1,1,0,0,0,1,1,1,1,0,0,1,0,0,0,0,1,1,0,1,1,1,1,0,0,1,0,1,1,1,0,1,0,1,1,1,1,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,1,0,1,0,0,0,1,1,0,1,0,1,0,0,1,0,1,0,1,0,0,0,0,1,1,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,1,0,0,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,0,0,2,2,2,2,2,0,1,0,0,0,2,2,2,0,0,0,0,0,0,1,1,0,0,1,0,1,1,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,1,0,0,0,0,1,0,1,0,1,0,1,1,0,0,0,0,1,1,0,2,2,2,0,0,1,0,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,1,1,0,1,1,0,1,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,1,0,1,1,0,0,1,1,0,1,1,0,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,2,0,1,1,0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,1,0,1,1,0,0,0,1,1,0,1,0,1,1,0,0,1,1,1,1,0,0,0,0,1,0,1,1,0,0,0,1,0,1,1,0,1,0,1,0,1,1,1,1,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,1,0,0,0,1,0,0,1,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,0,0,0,1,1,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,1,0,1,1,0,0,2,2,2,2,1,0,0,0,0,2,2,2,2,2,1,0,0,0,1,1,0,0,1,0,1,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,0,0,0,0,1,1,1,0,0,2,2,1,0,0,0,0,1,2,2,2,2,2,2,0,0,0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,2,0,1,0,1,1,1,1,0,1,0,1,0,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,1,0,1,1,0,1,0,0,0,1,1,1,1,1,0,1,0,1,1,0,1,1,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,0,1,1,0,1,0,1,1,1,0,0,1,0,0,0,1,1,0,0,1,0,1,0,1,2,0,0,0,1,0,0,0,0,0,1,2,2,0,2,0,0,1,0,0,0,1,0,1,1,1,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,1,0,1,0,0,1,1,1,1,1,1,0,0,1,0,0,1,1,1,0,1,1,0,0,1,0,1,1,1,0,0,0,1,0,0,0,0,0,1,1,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,2,1,0,0,1,0,0,2,0,1,1,1,0,1,1,1,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,1,1,1,1,1,0,1,0,1,0,0,0,0,1,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,1,1,1,1,0,1,0,1,0,0,0,1,0,0,0,1,1,1,0,1,0,0,1,1,0,1,0,1,1,0,1,0,0,0,0,0,1,0,0,2,2,2,0,0,0,0,0,0,1,1,0,0,0,2,2,2,0,0,0,0,0,2,0,0,0,0,0,0,1,0,0,0,0,1,1,0,1,1,1,1,0,0,0,0,2,2,1,1,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,0,2,2,2,2,2,2,0,1,0,0,0,1,1,1,0,1,0,0,1,1,1,1,1,0,0,0,0,1,0,1,1,0,1,1,0,0,1,1,0,0,1,1,0,1,0,1,0,0,2,2,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,0,0,2,2,2,0,1,0,0,0,2,2,1,1,0,0,1,1,0,0,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,0,0,1,0,1,0,0,0,1,1,1,0,1,1,0,1,1,1,0,0,0,1,1,0,0,1,0,1,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,0,1,0,1,1,0,1,0,1,0,1,0,1,1,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,2,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,0,2,2,2,2,2,2,2,1,1,0,0,1,0,1,1,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,1,0,0,0,0,2,2,1,1,1,1,1,0,1,0,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,1,0,1,1,1,0,1,0,0,1,1,1,0,1,0,1,1,1,0,0,1,0,1,0,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,1,1,1,0,0,0,0,1,1,0,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,1,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,0,1,1,0,0,0,0,0,1,0,0,1,1,1,0,1,0,1,1,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,0,0,0,0,0,0,0,2,2,2,0,2,2,0,0,0,0,0,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,2,2,2,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,1,0,0,0,0,1,1,1,1,0,0,1,0,1,1,1,1,0,1,0,0,0,1,1,0,1,1,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,0,2,2,2,0,0,0,0,0,0,1,2,2,2,2,0,0,0,1,1,0,0,0,1,0,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,0,1,0,0,0,1,0,0,1,1,0,0,0,0,1,0,1,1,0,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,0,1,1,0,1,0,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,2,2,2,0,0,0,0,2,2,2,2,2,0,0,0,0,2,0,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,1,0,0,0,1,1,0,0,1,0,1,0,1,0,0,1,0,0,1,1,1,0,0,0,1,1,0,1,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,1,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,2,0,0,0,0,2,2,2,2,2,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,2,2,0,2,2,2,2,2,2,2,2,0,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,0,2,2,2,2,1,1,0,0,1,1,0,1,0,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0,1,0,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,1,1,1,2,2,2,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,1,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,2,0,0,0,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,1,1,0,1,0,1,0,1,1,1,0,1,1,0,1,0,0,0,0,0,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,1,1,1,0,0,1,0,1,1,0,1,0,0,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,1,1,1,0,0,1,0,1,1,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,2,2,2,0,0,2,0,0,2,0,2,2,0,0,0,0,0,2,2,2,0,0,1,1,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,1,1,0,0,1,0,1,1,1,0,1,1,0,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,0,1,0,0,0,1,0,0,1,1,0,0,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,1,0,1,0,0,1,0,0,1,0,1,0,0,1,1,1,1,1,1,0,1,0,0,0,1,1,1,0,0,1,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,2,0,0,0,2,2,2,2,2,0,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,0,1,1,0,1,0,0,1,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,1,0,1,0,0,1,1,0,1,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,0,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,1,1,1,0,0,0,1,0,0,0,1,0,0,1,1,1,1,1,1,0,0,1,0,1,0,0,1,0,0,1,0,1,1,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,1,1,0,1,1,0,1,0,1,0,0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,0,0,0,0,1,1,0,1,1,0,0,0,1,1,1,1,0,0,0,1,1,1,0,1,0,0,0,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,0,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,2,0,0,0,0,1,1,0,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,0,1,1,0,1,1,1,1,0,1,1,0,0,1,1,0,1,0,1,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,0,2,2,2,2,0,0,0,2,2,2,2,0,0,0,2,2,0,2,2,2,2,2,0,0,2,2,2,0,0,0,0,2,2,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1,0,1,1,0,1,1,1,0,1,1,0,0,1,0,0,1,0,1,1,1,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,1,1,1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,0,1,0,0,0,1,1,0,0,0,1,0,1,1,1,1,1,1,1,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,1,0,1,1,0,1,1,0,1,1,0,1,0,0,0,0,1,1,1,1,0,0,1,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,2,2,2,0,0,0,0,2,0,0,2,2,2,2,2,0,0,2,2,2,2,0,0,2,2,2,0,0,2,0,2,2,2,2,2,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,1,0,1,1,0,0,1,0,1,0,0,2,2,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,2,2,0,0,1,1,1,1,0,1,0,1,1,1,0,1,0,1,0,1,1,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,1,0,1,1,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,1,0,1,0,1,0,0,1,1,1,1,0,0,0,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,0,1,0,1,0,0,1,1,0,0,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,0,1,1,1,0,0,1,1,0,1,1,0,0,1,0,1,0,1,0,0,0,0,0,0,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,0,0,1,1,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,0,1,0,1,0,1,0,0,0,0,1,0,1,1,1,1,0,1,1,1,0,1,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,0,0,0,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,1,0,0,0,1,0,1,0,0,1,1,1,1,1,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,0,2,2,2,0,0,0,0,0,0,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,0,1,1,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,2,2,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,0,1,0,0,0,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,0,0,0,1,0,0,1,1,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,1,1,1,1,0,0,0,1,0,1,0,1,0,0,0,1,1,0,1,0,1,0,1,1,0,0,1,0,0,1,0,1,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,1,1,1,0,0,0,0,1,1,0,1,0,0,0,1,1,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,2,0,0,0,1,0,1,0,0,0,0,1,1,1,0,1,0,1,1,0,0,0,0,0,0,2,2,2,0,0,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,0,1,1,0,1,1,1,1,1,1,1,0,1,0,1,0,1,1,1,1,0,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,1,1,0,0,0,0,1,0,1,1,1,1,1,0,1,1,1,0,1,0,0,0,1,0,1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,0,2,2,0,0,2,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,1,1,1,1,0,1,0,0,0,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,2,2,2,0,0,2,2,0,0,0,2,0,0,2,2,2,2,2,2,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,2,0,2,2,0,0,0,2,2,2,2,2,2,0,0,2,2,2,0,2,2,0,0,2,2,2,2,0,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,0,0,1,1,1,1,0,1,1,0,1,1,0,1,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0,1,1,1,0,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,0,2,0,0,2,2,0,0,0,0,0,0,0,2,2,0,2,0,0,0,2,0,2,2,2,2,2,2,2,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,0,1,0,0,0,0,1,1,0,0,1,0,0,0,1,0,1,1,0,0,1,1,2,2,2,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,2,2,0,0,0,0,0,2,2,2,2,0,0,0,1,1,1,1,0,1,0,0,0,1,0,1,0,1,0,0,1,0,1,1,2,2,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,0,0,0,2,2,2,0,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,0,0,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,1,1,0,1,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,2,2,2,2,2,2,2,0,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,1,1,1,1,0,0,0,0,1,0,0,1,1,2,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,0,0,0,2,2,2,2,2,0,0,0,0,1,0,1,1,1,0,1,1,0,0,0,0,1,0,0,0,1,1,0,2,2,2,2,2,2,2,2,0,2,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,0,1,1,0,1,0,0,1,1,0,1,1,0,1,0,0,0,1,0,0,0,1,0,1,2,2,2,2,2,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,0,0,2,0,0,0,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,1,0,1,1,0,1,0,1,1,0,1,1,0,1,0,0,1,0,1,0,0,1,0,1,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,1,0,0,0,1,0,1,1,0,2,2,2,2,2,2,2,2,0,2,2,2,2,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,0,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,2,2,2,2,2,2,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,1,1,1,1,0,1,1,0,0,1,0,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,2,2,2,2,0,0,2,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,2,2,0,0,0,0,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,0,1,0,0,1,1,1,0,2,2,2,2,2,2,2,2,0,2,2,0,0,2,2,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,0,0,2,2,2,2,2,2,2,2,1,2,2,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,1,0,1,1,1,1,1,1,0,0,0,1,1,1,1,0,1,1,0,1,1,1,1,0,2,2,2,2,0,0,2,2,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,1,0,0,1,2,2,2,0,0,0,0,0,0,1,0,0,0,1,1,0,1,1,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,1,1,0,1,0,0,1,0,1,0,0,0,1,0,0,1,0,0,2,2,2,2,2,2,2,0,2,2,2,0,0,2,2,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,1,1,1,0,1,1,0,0,1,1,0,0,1,1,0,2,2,2,2,2,2,2,2,2,1,2,2,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,0,1,0,0,1,0,0,0,1,1,0,0,0,1,1,0,1,0,0,1,1,0,1,1,1,1,0,0,1,1,0,0,1,1,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,1,1,1,2,2,2,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,0,0,0,0,0,0,0,1,1,1,1,0,1,0,1,1,1,0,1,0,1,0,0,1,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,2,2,0,0,2,2,2,2,2,2,0,2,2,2,2,2,0,0,0,0,0,1,1,0,1,0,0,1,1,0,1,1,1,0,0,0,2,2,2,2,2,2,2,2,0,1,2,2,2,0,1,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,2,2,2,2,0,2,0,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1,1,0,1,0,1,1,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,0,1,0,1,1,0,2,2,2,2,2,2,0,0,0,0,0,0,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,1,1,1,0,1,1,0,0,0,1,1,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,0,1,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,1,0,1,1,1,0,1,1,1,1,0,0,1,0,1,1,0,2,2,2,2,2,2,2,2,1,2,2,2,2,0,0,1,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,0,0,0,2,2,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,0,0,0,0,1,0,1,0,1,0,1,0,1,1,1,0,0,0,1,1,0,1,0,1,1,1,0,0,1,1,1,0,1,0,0,1,0,0,0,0,1,1,0,0,0,1,1,1,1,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,1,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,2,2,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,0,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,1,0,1,0,1,0,1,0,0,1,1,0,0,1,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,1,1,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,1,0,1,0,1,1,1,0,1,0,0,1,0,0,0,1,1,0,0,1,0,0,0,0,1,1,0,1,1,1,0,0,1,1,0,1,1,1,0,0,0,0,1,1,0,0,1,1,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,2,2,2,0,0,1,1,0,1,0,1,1,1,0,0,1,1,1,0,1,0,1,0,0,1,1,0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,0,1,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,1,0,0,1,1,0,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,0,1,1,0,1,0,1,0,1,1,1,1,0,0,0,1,1,1,1,0,1,1,1,0,1,0,1,0,1,0,0,0,1,1,0,0,0,0,1,1,0,1,1,0,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,1,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,2,2,2,2,0,0,1,0,0,0,1,1,1,0,0,0,1,0,1,0,0,1,0,1,0,0,0,1,1,1,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,0,0,0,1,0,1,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,0,2,2,2,2,2,2,2,0,0,1,1,0,0,1,1,0,1,0,2,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,1,1,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,1,1,1,1,0,0,1,1,1,0,1,1,0,0,0,1,1,1,1,1,1,0,0,1,1,0,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,0,2,2,2,0,1,0,1,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,2,0,2,2,2,2,0,0,0,1,0,0,1,1,0,0,1,1,0,0,1,0,1,0,0,0,1,0,0,0,1,1,1,1,1,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,0,2,2,2,2,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,2,2,2,0,1,1,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,0,0,0,0,2,2,2,1,1,1,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,2,2,1,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,1,0,0,0,1,1,1,0,1,0,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,1,1,0,1,1,0,1,1,0,0,2,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,1,0,2,2,0,0,0,0,1,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,2,2,0,0,0,1,1,1,0,1,1,0,0,0,1,1,0,1,1,0,1,1,1,1,1,0,0,1,0,0,1,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,0,2,2,2,2,0,0,0,0,1,0,0,2,2,0,0,0,2,0,0,0,0,2,0,0,0,2,2,2,2,2,2,0,0,2,2,2,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,1,0,1,0,0,0,0,0,0,2,2,2,1,0,1,0,0,1,1,1,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,0,2,2,2,2,2,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,0,0,0,1,0,1,1,0,0,1,1,1,0,1,0,1,0,0,0,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,2,2,2,0,0,0,0,1,0,1,0,1,0,0,1,0,0,0,0,1,0,1,1,1,1,0,1,1,0,1,0,1,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,1,1,2,2,2,0,0,1,0,1,0,0,0,2,2,0,0,0,2,2,0,2,2,2,2,2,0,2,2,2,0,0,0,2,2,2,2,2,0,1,1,0,1,1,1,1,1,0,1,1,1,1,0,0,1,0,1,1,0,1,0,0,2,2,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,0,2,2,0,2,2,2,2,2,2,2,0,0,0,1,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,1,1,0,0,1,1,0,1,0,0,1,0,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,1,1,1,1,1,0,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,2,2,2,0,0,0,0,1,1,1,0,0,1,0,0,1,0,0,1,0,1,1,1,0,0,0,0,1,1,0,1,0,0,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,0,0,1,0,0,0,0,0,1,1,0,0,0,2,2,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,0,0,0,0,0,1,1,1,1,0,1,1,1,0,1,0,0,1,1,0,0,1,0,0,2,2,1,1,0,0,1,0,1,1,0,1,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,0,0,0,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,0,1,0,1,1,0,0,0,0,0,1,0,1,1,1,1,1,2,1,0,1,0,1,1,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,0,0,1,1,1,1,0,1,1,0,1,0,1,0,0,1,0,0,0,1,0,0,1,1,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,1,0,1,0,0,1,1,1,0,1,0,0,0,0,1,1,0,0,1,1,0,0,0,2,2,2,2,0,0,0,1,1,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,2,2,2,0,2,2,0,0,0,0,2,2,2,0,2,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,1,1,1,0,0,1,0,0,0,1,1,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,0,1,0,1,1,1,0,1,1,2,2,1,1,0,0,0,0,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,1,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,1,1,0,1,1,0,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,2,0,0,0,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,1,1,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,2,2,2,2,2,1,1,2,2,2,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,0,0,2,2,0,2,2,2,0,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,1,0,1,1,0,0,0,0,1,0,1,1,1,1,0,1,0,0,1,1,1,1,0,1,1,0,0,1,0,1,2,2,1,1,0,1,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,1,1,1,1,1,0,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,0,2,0,0,2,2,2,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,0,0,0,1,0,1,0,0,1,1,0,1,1,1,1,1,1,0,1,0,0,1,2,2,2,2,2,2,2,2,2,2,2,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,2,2,2,0,2,2,2,2,2,0,2,2,0,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,0,0,1,1,1,0,0,0,0,1,1,0,1,0,1,0,1,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,2,2,2,1,1,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,1,1,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,0,0,0,0,1,0,0,1,0,1,1,1,0,1,0,0,1,0,1,0,1,0,0,1,0,1,1,1,1,0,0,1,2,2,2,1,1,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,2,0,0,0,0,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,1,0,0,1,0,0,1,1,0,1,1,0,1,1,1,0,0,0,0,1,0,2,2,2,2,2,2,2,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,0,1,0,1,1,1,1,1,0,1,0,0,1,0,1,0,1,1,1,0,2,2,0,0,1,1,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,1,0,0,0,0,2,2,0,0,0,2,2,2,0,0,0,0,1,0,1,1,0,1,0,1,1,1,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,0,0,0,0,1,1,1,0,0,0,0,0,1,0,1,1,1,0,0,0,1,0,1,0,0,1,1,1,1,1,0,0,1,0,1,0,1,0,0,0,1,1,0,0,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,2,2,0,0,0,0,1,2,1,1,0,0,2,2,2,2,2,2,2,2,2,2,1,0,0,1,0,0,1,1,0,0,0,1,1,1,1,1,1,0,1,1,0,0,1,0,1,2,2,2,2,2,2,0,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,0,0,0,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,1,1,1,0,1,0,1,0,1,0,0,1,1,0,1,1,0,1,1,1,1,1,1,0,0,1,0,1,1,0,0,1,2,2,0,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,0,1,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,0,0,0,1,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,2,2,2,2,0,2,2,0,0,0,0,1,0,1,0,0,1,1,1,0,0,1,1,1,1,0,1,1,0,1,1,1,0,0,0,0,1,0,1,1,1,0,1,1,1,0,0,0,1,1,1,0,0,2,2,2,2,0,0,0,1,1,0,0,0,0,0,0,0,2,2,2,0,0,0,1,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,1,0,0,1,1,1,0,1,0,0,0,1,1,0,1,1,1,0,0,0,1,0,0,0,0,0,2,2,2,2,0,1,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,1,2,2,2,0,0,0,0,2,0,0,0,0,2,2,0,0,0,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,1,0,0,1,1,0,1,0,0,0,1,0,1,1,0,1,1,1,1,0,1,0,1,1,0,0,0,0,1,0,0,0,1,2,2,1,1,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,0,1,1,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,1,0,1,1,1,1,1,0,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,2,2,2,0,1,1,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,1,0,0,1,0,1,1,1,0,1,1,1,1,0,1,1,0,1,0,1,1,1,0,0,1,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,2,0,2,2,2,2,2,0,0,0,1,1,1,0,0,1,0,0,0,0,1,1,1,1,0,1,0,0,1,0,1,1,0,0,1,1,1,0,1,0,0,1,0,2,2,2,2,2,2,2,2,2,2,0,2,2,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,1,1,0,1,1,0,2,2,0,0,0,0,0,0,2,2,2,2,2,0,2,0,0,2,2,2,2,2,2,0,0,2,2,2,0,1,1,1,1,0,1,0,0,0,0,1,0,1,1,0,1,0,0,0,1,1,1,1,1,0,1,0,0,1,0,0,1,1,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,1,1,1,2,2,2,2,2,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,1,0,0,0,1,0,1,0,1,0,1,0,0,0,1,1,1,1,1,0,1,1,1,0,0,0,1,1,0,1,0,0,1,1,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,2,2,0,0,0,1,0,1,0,0,0,0,1,1,0,0,1,1,0,1,1,0,0,0,1,1,1,1,0,0,1,0,1,0,1,1,0,1,0,0,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,2,2,2,2,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,2,2,2,2,2,0,0,2,2,2,2,2,0,0,1,0,1,1,0,0,1,0,1,1,0,1,1,1,1,0,0,1,0,1,1,1,1,0,1,1,0,1,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,0,0,1,2,2,2,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,1,1,1,1,1,0,0,1,1,1,1,1,0,1,0,1,1,1,0,1,0,1,1,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,2,2,1,0,1,1,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,2,2,2,2,2,0,0,2,2,2,2,0,1,1,1,0,0,1,1,1,0,1,0,1,0,1,1,1,1,1,0,0,0,1,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,1,1,0,1,0,1,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,1,2,1,1,1,0,0,1,0,1,2,2,2,2,2,2,2,2,2,2,2,0,1,0,1,0,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,1,0,1,1,1,0,0,0,1,1,1,0,0,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,1,0,1,0,0,1,1,0,1,1,0,0,0,1,0,0,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,1,0,1,0,1,1,0,0,0,0,2,2,2,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,0,0,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,2,2,2,0,1,1,0,0,1,0,1,1,0,1,0,1,0,0,0,1,1,1,0,0,1,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,0,1,1,1,1,1,1,0,0,0,1,0,2,2,1,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,1,0,0,1,0,1,1,1,0,1,1,1,1,0,1,0,0,1,0,1,0,0,1,0,0,1,1,0,0,1,0,1,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,0,1,0,1,1,0,0,1,0,0,1,1,1,1,0,1,1,0,1,0,1,1,0,1,0,1,0,1,0,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,1,0,1,1,0,1,1,0,0,2,2,2,2,0,1,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,0,2,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,0,2,2,2,2,0,0,0,2,2,2,0,0,0,1,1,1,0,0,1,1,0,1,0,0,0,1,0,1,0,1,0,0,1,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,1,1,1,0,1,0,0,2,2,0,2,2,2,2,2,2,2,2,0,1,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,1,0,0,0,1,0,1,0,1,1,0,1,0,0,0,1,2,2,0,0,1,1,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,1,0,0,0,2,2,2,1,1,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,0,1,0,0,2,2,2,2,2,2,0,2,2,2,2,2,2,2,0,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,1,0,1,0,0,1,1,0,1,0,0,0,1,1,0,0,0,0,1,1,1,0,0,0,0,0,2,2,2,2,2,2,2,2,1,0,1,1,1,0,0,0,1,0,1,0,0,1,0,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,2,2,2,0,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,1,1,0,0,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,0,1,0,1,0,0,1,0,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,0,0,0,0,1,1,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,0,0,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,1,0,0,0,0,0,1,0,1,0,1,1,0,1,0,1,1,1,0,1,0,0,1,2,2,2,0,2,2,2,2,2,2,2,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,1,1,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,1,0,1,1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,0,1,0,2,0,1,1,0,1,0,1,1,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,1,1,0,0,0,1,1,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,2,2,0,2,2,2,2,0,2,2,2,0,0,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,0,2,2,2,0,0,0,2,2,0,0,0,0,0,1,1,1,1,0,0,0,1,1,1,1,0,1,0,1,1,0,1,1,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,0,0,1,1,1,1,1,0,1,1,0,0,2,2,2,2,1,2,2,1,2,0,0,1,0,0,1,1,1,1,1,1,1,0,1,1,0,0,1,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,0,0,0,0,1,0,1,1,1,1,0,1,0,0,0,0,0,1,2,2,2,2,0,1,1,0,1,1,1,1,2,2,2,2,2,2,0,0,2,0,0,0,0,2,2,2,2,2,2,0,0,0,1,1,0,0,0,0,1,2,2,0,2,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,2,2,2,2,2,2,0,0,0,2,2,2,0,2,2,2,2,0,2,2,2,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,0,1,0,1,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,1,0,0,1,1,1,1,0,1,0,2,2,2,2,2,1,0,1,1,1,1,0,0,1,1,0,1,0,0,1,0,1,0,0,0,0,1,0,1,0,1,1,1,0,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,0,0,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,1,0,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,2,2,2,0,0,2,2,2,2,0,0,0,0,1,1,1,1,0,0,0,0,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,2,2,2,2,0,2,2,2,2,2,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,0,1,1,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,0,1,1,0,1,0,1,0,1,0,0,0,0,0,0,1,1,0,1,1,0,1,1,1,0,2,2,2,2,1,1,0,1,1,1,1,0,1,1,0,0,0,0,1,0,1,0,1,1,0,0,0,1,0,1,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,1,1,0,1,0,0,0,0,0,1,0,0,1,0,1,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,2,2,0,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,1,0,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,1,0,1,0,1,0,1,1,2,2,1,1,1,0,0,1,1,0,1,0,1,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,1,1,1,1,0,1,1,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,0,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,1,0,0,0,1,1,1,0,1,0,0,0,0,0,0,1,0,0,0,1,0,1,2,2,2,0,2,2,2,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,1,0,1,1,1,1,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,1,1,1,1,0,0,1,0,0,0,0,1,2,2,0,0,0,1,0,1,1,0,0,0,1,0,0,1,1,0,0,1,0,1,1,0,1,0,0,1,1,1,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,0,1,1,0,0,0,2,2,2,0,0,0,2,2,2,0,0,0,0,0,2,2,2,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,2,2,2,2,0,2,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,0,1,0,0,0,1,1,1,0,1,0,0,0,1,1,1,1,0,1,0,0,0,1,1,1,1,0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,1,0,0,1,1,0,1,1,1,1,0,1,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,2,1,1,0,1,0,0,1,1,0,0,1,0,1,1,1,0,0,1,1,1,1,1,0,0,2,2,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,2,0,0,1,1,1,0,0,0,0,2,2,2,2,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1,1,0,1,0,0,1,1,0,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,0,1,0,1,1,1,1,1,1,0,1,0,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,1,1,0,1,0,1,1,0,1,1,0,1,1,1,0,0,0,1,0,1,1,1,1,0,2,2,0,0,2,0,2,2,0,0,0,0,0,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,1,0,0,1,0,1,0,1,1,0,1,1,1,0,1,1,0,1,1,0,0,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,1,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,2,0,0,0,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,2,2,2,2,2,1,1,1,0,1,0,0,1,1,0,1,0,1,0,0,1,1,1,0,1,1,1,1,1,0,0,1,0,0,0,0,0,2,0,2,1,1,1,0,1,0,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,2,2,0,0,0,0,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,1,1,1,1,1,0,1,0,1,0,1,0,1,1,1,0,1,1,0,1,1,0,1,1,1,1,1,1,1,0,1,0,0,0,0,1,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,2,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,1,1,0,1,0,0,1,1,0,1,1,1,0,0,0,1,1,0,0,1,0,1,0,0,0,1,0,0,1,1,0,0,1,1,1,0,1,0,1,0,2,2,2,1,1,1,0,0,0,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,1,1,0,1,1,1,1,0,1,1,0,1,0,0,1,0,0,1,0,0,1,1,1,0,1,0,1,0,0,0,1,0,1,1,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,1,1,0,0,0,1,0,0,0,1,1,0,1,0,1,0,0,1,1,0,1,0,0,0,0,0,2,0,1,0,0,2,2,1,0,1,1,1,0,1,2,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,0,0,0,0,0,2,2,2,0,0,0,0,2,2,2,2,2,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,0,1,1,0,1,0,1,0,0,0,0,0,1,1,1,0,1,1,0,1,1,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,1,1,1,1,0,1,0,1,0,0,1,1,1,1,1,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,1,2,2,0,0,0,0,0,1,0,0,0,1,0,1,0,1,1,2,1,0,1,0,1,0,0,0,1,1,1,1,1,2,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,2,0,0,2,0,0,2,2,2,0,0,0,0,2,2,0,2,2,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,0,1,1,1,1,0,1,0,1,0,0,0,0,1,0,1,1,1,1,1,1,0,1,0,1,1,1,1,1,0,1,0,1,1,0,0,0,1,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,1,0,1,0,1,0,1,1,2,2,2,0,0,2,1,0,0,1,0,0,0,1,1,0,0,0,1,0,1,0,1,1,0,0,1,1,0,1,2,2,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,2,2,0,0,0,0,2,2,0,0,2,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,1,0,1,1,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,1,0,0,1,1,0,1,1,1,1,1,0,1,0,0,1,1,0,1,0,1,1,0,1,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,1,0,1,1,1,0,0,0,1,2,2,2,2,2,2,2,2,0,1,1,0,1,0,0,1,0,1,1,1,0,0,0,1,0,1,1,0,0,2,2,0,1,0,0,0,0,0,0,2,2,2,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,2,2,0,0,0,0,0,2,2,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,1,1,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,0,1,1,0,1,0,0,0,0,0,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,0,1,1,0,0,1,0,0,0,1,1,1,0,1,1,1,1,0,0,1,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,1,1,0,0,2,2,2,2,2,2,0,1,1,0,1,1,0,1,1,0,0,1,1,0,0,0,0,1,0,1,0,0,1,1,1,1,0,1,0,0,0,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,2,2,2,0,0,0,2,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,1,2,1,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,1,1,0,0,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,1,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,1,0,1,0,1,0,0,1,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,0,0,1,0,0,1,0,0,1,0,0,0,0,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,0,0,0,2,2,2,2,2,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,0,1,1,0,1,1,0,0,1,0,1,0,0,0,0,0,1,0,1,0,1,1,1,1,0,1,1,1,0,0,1,0,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,1,0,1,0,0,1,1,0,1,1,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,0,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,0,1,0,0,0,1,1,1,1,0,1,0,1,0,2,2,2,0,0,2,2,2,2,1,1,1,0,1,0,1,1,0,0,1,0,0,1,0,0,1,1,0,1,0,1,0,1,0,1,1,0,0,2,2,2,0,2,2,2,2,2,2,0,0,0,2,2,2,0,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,2,2,2,0,0,0,2,2,0,0,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,1,1,0,1,0,1,1,0,1,0,1,1,0,1,1,0,0,0,1,0,0,1,0,1,1,1,1,1,0,1,0,0,1,1,1,0,0,0,0,0,0,1,1,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,1,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,0,0,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,1,0,1,1,2,2,2,2,2,2,2,2,0,0,1,0,0,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,0,2,0,0,0,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,0,1,0,0,1,1,0,1,0,0,1,1,1,1,1,0,1,1,0,1,0,1,0,0,0,0,0,1,1,1,1,1,1,1,0,1,1,0,1,1,0,0,0,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,1,0,1,0,0,1,0,1,0,1,0,0,0,0,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,2,0,2,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,1,1,1,0,1,1,1,0,1,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,0,0,0,0,0,2,2,2,2,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,2,2,2,2,0,0,2,0,0,0,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,0,1,0,1,1,0,1,1,1,0,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,1,0,1,0,1,0,1,0,1,1,1,0,1,0,1,1,1,0,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,0,0,0,0,0,0,1,1,1,0,1,0,0,1,1,0,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,1,1,1,0,1,0,1,1,1,0,0,2,0,0,0,2,2,2,2,0,1,1,1,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,1,1,0,0,1,0,1,0,0,0,1,1,0,0,1,1,0,0,0,0,0,1,0,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,2,2,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,2,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,1,2,2,0,0,0,2,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,0,0,0,2,2,2,0,0,0,0,0,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,0,1,0,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,1,0,0,0,1,0,1,1,0,0,0,1,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,2,2,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,1,1,0,0,2,2,2,2,2,0,0,1,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,2,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,1,1,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,0,1,1,1,0,1,1,0,1,1,1,1,1,0,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,0,1,1,0,0,0,0,0,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,2,2,2,2,2,2,2,0,1,0,1,1,1,0,0,1,0,0,0,2,2,2,2,2,2,2,0,0,0,2,2,0,2,0,2,2,2,0,0,1,1,0,0,0,0,0,1,1,1,1,1,0,0,2,0,0,2,0,0,1,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,1,0,0,1,0,1,0,1,1,1,0,0,0,0,1,1,0,1,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,0,1,1,0,0,0,0,1,0,0,1,1,1,1,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,2,2,2,2,2,2,2,0,1,1,0,1,1,0,0,1,0,0,0,2,2,2,2,2,2,0,2,0,0,2,2,2,0,2,2,0,2,2,1,1,1,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,2,0,0,0,1,0,0,0,0,0,0,0,0,0,2,0,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,0,1,0,0,1,0,1,0,1,0,1,0,1,1,1,1,1,1,0,1,0,1,0,1,1,1,1,0,1,0,1,0,1,0,1,1,0,1,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,0,1,0,1,1,0,1,0,0,0,1,1,0,0,1,1,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,2,2,2,0,0,2,1,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,1,1,0,0,0,0,0,0,0,2,0,0,0,0,2,0,2,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,0,1,0,1,0,1,0,0,0,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,0,0,1,0,1,0,0,0,1,1,0,1,1,1,0,1,1,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,1,1,0,0,0,1,0,0,1,1,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,2,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,1,1,1,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,2,2,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,2,1,1,1,0,0,0,0,0,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,0,1,0,1,1,1,1,0,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,0,1,0,1,1,0,0,0,1,0,1,1,0,1,0,0,1,1,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,2,2,2,0,0,2,2,2,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,2,2,0,0,0,0,1,1,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,0,0,1,0,0,1,0,1,0,0,1,1,0,0,1,1,0,0,0,1,1,0,0,0,1,1,1,0,0,0,1,1,0,1,0,0,0,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,0,2,2,0,0,2,2,2,2,2,2,2,2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,2,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,1,0,1,0,1,0,1,1,1,0,0,0,1,0,1,1,0,0,0,0,1,1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,1,0,1,0,1,1,1,0,1,1,0,1,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,1,1,1,0,0,0,1,1,1,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,1,1,0,1,1,0,0,0,1,1,0,0,1,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,1,0,1,1,0,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,1,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,0,1,1,1,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,0,0,2,2,2,2,2,2,0,2,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,1,1,0,0,0,1,1,0,1,0,1,0,1,1,1,1,1,0,1,0,0,1,0,0,0,0,0,1,1,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,0,0,0,1,1,0,1,1,1,0,1,1,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,1,1,1,1,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,1,1,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,0,0,1,1,1,0,1,0,0,0,1,1,0,0,0,0,0,0,1,0,1,0,0,0,1,0,1,1,0,0,1,0,0,0,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,0,1,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,2,2,2,2,2,0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,1,1,0,1,1,1,1,0,1,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,0,0,1,1,0,0,0,1,0,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,1,1,1,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,1,0,0,0,0,1,0,1,0,1,0,1,1,1,0,1,1,1,1,0,0,1,0,0,1,0,1,0,1,1,0,0,1,1,1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,0,1,0,1,1,1,1,1,1,1,0,0,1,0,1,1,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,1,0,1,1,0,1,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,0,1,0,0,0,1,0,0,1,1,1,1,0,1,1,0,1,1,1,0,0,1,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,1,1,1,0,0,1,1,1,1,0,1,0,1,1,1,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,1,1,0,1,1,1,1,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,0,0,1,0,1,0,0,0,1,1,0,1,1,0,0,1,0,0,1,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,1,1,1,0,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,0,1,0,1,1,1,0,1,1,0,1,1,1,0,1,0,0,0,0,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,1,0,1,1,1,0,1,0,0,1,1,0,0,0,1,0,0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,1,0,0,1,0,1,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,1,1,1,0,1,1,0,1,0,0,1,0,1,0,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,1,1,0,1,0,1,0,1,0,1,0,0,1,1,0,0,0,1,1,1,0,1,1,0,1,0,0,0,1,1,1,1,0,1,0,1,1,0,0,0,0,1,1,1,0,0,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,0,0,1,0,1,1,0,0,1,0,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,0,0,1,0,1,0,1,1,0,1,1,0,0,0,0,1,1,1,0,1,1,0,1,1,0,1,0,1,0,0,0,1,0,0,1,0,1,0,0,0,1,1,0,1,0,0,0,0,1,0,1,0,0,0,1,0,1,0,1,0,0,1,1,1,1,1,0,1,0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,1,0,0,1,0,1,1,1,1,1,0,0,0,1,0,0,0,1,1,1,1,1,0,1,1,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,1,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,0,1,1,0,0,1,0,1,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,1,0,1,1,1,1,0,1,1,0,0,0,0,0,0,1,0,0,1,0,0,1,1,1,1,0,1,0,1,0,1,0,0,1,0,1,1,0,1,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,1,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,1,0,1,1,0,1,1,1,0,0,1,1,0,0,1,0,1,1,0,1,1,0,0,0,0,1,0,1,1,1,0,0,1,1,0,0,0,0,0,1,0,0,1,0,1,1,1,0,0,0,1,0,0,1,1,0,1,1,1,1,1,0,0,0,1,0,1,1,1,0,0,1,1,0,1,0,0,1,0,0,1,1,0,0,1,0,0,0,1,1,1,0,0,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,0,1,1,1,1,1,0,0,1,0,1,0,1,1,1,0,1,0,1,0,1,0,0,0,1,1,1,0,1,1,1,1,1,1,0,1,0,0,0,1,0,1,1,0,0,2,2,2,0,0,0,0,0,1,1,1,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,1,0,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,0,0,0,2,0,0,0,0,1,0,1,0,0,0,1,0,1,1,0,0,1,1,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,1,0,1,1,1,0,1,1,1,0,1,1,1,1,1,1,1,0,1,0,0,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,0,1,0,1,1,1,0,0,1,1,1,0,0,0,1,1,0,1,0,1,0,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,1,0,1,0,1,1,0,1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,0,1,1,1,0,1,0,0,0,1,0,1,0,0,0,0,1,0,1,0,1,0,1,1,1,0,1,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,0,0,0,0,1,1,0,0,0,1,0,0,0,0,1,0,1,1,1,0,0,0,0,0,1,0,1,0,0,0,0,1,1,1,1,0,1,1,1,1,0,0,1,0,1,0,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,0,0,1,0,2,2,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,1,1,0,0,1,1,1,1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,1,0,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,1,1,0,0,1,0,1,0,0,1,1,0,0,1,0,0,0,1,1,0,1,1,0,1,0,0,0,0,1,0,0,1,1,0,1,1,0,1,1,1,1,0,1,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,0,1,1,1,0,1,0,1,1,0,1,0,1,1,1,0,1,0,0,1,0,1,1,1,0,1,1,1,1,0,0,0,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,1,1,1,1,1,0,1,2,2,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,1,1,1,1,0,1,0,1,0,1,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,2,2,2,2,0,0,0,0,0,0,0,2,2,0,0,0,2,1,0,1,0,0,1,0,1,0,0,1,0,1,0,0,0,0,1,1,0,1,1,0,0,0,0,1,1,1,0,0,1,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,1,0,1,1,0,1,1,1,0,0,1,0,1,0,0,0,0,1,0,1,1,1,0,0,0,1,1,1,1,0,0,1,0,1,1,0,1,0,0,1,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,1,1,1,0,1,1,0,2,2,0,1,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,2,2,1,1,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,0,1,1,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,1,1,1,1,1,0,0,1,0,1,1,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,1,0,1,1,1,0,0,1,0,1,0,1,1,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,0,2,2,2,0,0,0,0,0,2,2,2,2,2,2,1,1,1,1,0,1,1,0,1,0,1,0,1,0,0,0,1,1,1,0,1,0,0,0,1,0,0,1,0,1,0,0,0,1,0,1,0,1,1,1,0,1,1,0,0,1,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,0,0,0,0,0,0,0,1,0,1,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,1,1,0,1,1,1,1,0,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,0,0,2,1,1,0,1,0,0,0,1,1,0,0,0,1,0,0,0,0,2,2,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,0,1,0,0,1,1,1,0,0,0,1,0,1,1,1,0,0,0,0,0,0,1,1,0,1,1,0,0,1,1,0,1,1,0,1,0,1,1,0,1,1,0,0,0,1,0,0,0,0,0,1,0,1,1,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,1,0,1,1,1,0,0,0,1,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,0,0,0,0,0,2,2,2,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,0,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,1,0,0,1,0,1,0,0,0,0,1,0,1,1,0,1,0,0,1,0,1,1,1,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,1,0,1,1,0,0,1,0,0,0,1,1,1,0,1,1,1,0,1,1,0,0,1,1,1,1,1,1,0,1,0,1,1,0,1,1,0,1,1,0,1,0,0,1,0,1,0,1,1,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,2,2,2,2,2,2,2,2,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,2,2,0,0,0,0,0,0,2,2,2,1,2,2,0,0,0,0,1,1,0,0,0,1,1,0,1,1,1,0,0,0,1,0,0,0,1,0,1,1,0,1,0,0,1,0,1,0,0,0,0,1,1,0,1,0,1,1,0,1,1,0,0,0,1,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,1,0,1,0,1,0,1,1,0,0,1,1,0,1,1,0,0,0,1,1,0,0,1,0,1,0,1,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,2,2,2,2,2,2,2,2,2,2,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,1,0,0,0,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,2,2,0,2,2,1,1,1,0,1,1,0,0,1,1,0,0,1,0,0,1,1,0,0,1,1,1,0,0,1,1,1,1,0,1,0,0,1,0,1,0,0,1,1,0,0,0,1,1,0,1,1,0,1,1,0,0,1,0,1,1,0,1,1,0,1,0,1,1,0,1,0,1,1,1,0,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,0,1,1,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,2,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,0,0,0,0,0,0,1,0,1,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,1,0,1,1,0,0,0,0,1,1,0,0,0,1,1,0,1,0,1,1,1,1,1,0,1,1,1,0,0,1,1,0,1,1,0,0,1,1,0,1,0,1,1,1,1,0,1,0,0,1,0,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,1,1,0,0,1,1,1,1,0,0,1,0,0,0,1,1,1,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,1,2,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,0,1,1,0,1,1,0,1,1,0,0,1,0,0,0,1,1,1,0,0,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,1,1,0,0,0,1,1,0,0,1,1,0,1,1,1,0,1,0,0,0,1,1,0,0,0,1,1,0,1,1,1,0,0,1,0,1,1,0,0,1,1,1,0,0,0,0,1,1,0,1,1,0,0,0,1,0,0,1,1,1,0,0,1,1,1,0,1,1,0,0,1,1,0,0,1,1,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,1,1,1,1,1,1,0,0,1,1,0,1,1,0,0,0,1,1,1,1,1,1,0,1,1,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,0,1,0,0,0,1,1,1,0,0,1,1,0,0,1,0,1,0,0,0,0,1,1,1,1,0,1,1,1,0,0,1,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,1,1,0,1,0,0,1,0,0,0,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,2,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,1,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,1,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,1,1,1,1,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,0,0,1,0,0,1,0,1,1,0,0,0,1,0,0,1,0,0,1,1,0,0,0,1,1,0,0,0,1,1,1,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,1,1,1,1,0,0,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,0,0,1,1,0,1,0,0,1,1,0,1,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,0,0,1,1,1,0,1,0,1,0,1,0,1,1,0,0,1,0,1,1,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,1,1,0,1,0,1,1,1,0,1,1,1,0,1,1,0,0,0,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,1,0,1,1,0,0,0,1,1,0,1,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,0,0,1,0,0,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,0,2,2,0,2,2,2,2,0,0,2,1,0,0,1,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,1,0,1,0,0,1,0,0,1,1,1,1,1,1,1,0,1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,1,1,1,1,0,1,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,1,1,0,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,0,1,0,1,1,0,1,0,1,1,1,0,0,0,1,1,1,0,1,1,0,1,0,0,1,0,0,1,1,1,1,0,1,0,1,1,1,0,0,1,0,1,0,1,1,1,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,1,1,2,0,0,0,0,1,2,2,2,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,2,2,2,2,0,0,0,1,1,1,1,0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,0,0,1,0,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,1,0,1,1,1,1,0,0,1,0,0,1,0,0,1,1,1,0,1,1,0,0,1,0,0,1,1,1,0,0,1,1,0,1,0,0,1,1,0,1,1,0,0,0,1,0,1,1,0,0,0,0,1,1,0,1,0,0,0,1,1,0,0,0,1,0,1,1,1,0,1,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,0,0,0,2,1,1,1,2,2,2,2,2,2,1,1,0,1,1,0,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,0,2,2,2,2,2,0,0,1,0,1,1,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,1,0,1,1,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,1,1,1,0,0,0,0,1,1,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,1,1,0,0,0,0,0,1,0,0,1,0,1,1,0,0,0,1,0,0,1,0,1,0,1,0,1,0,1,0,0,1,1,0,1,1,0,2,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,0,0,0,1,1,2,2,2,2,2,2,1,1,1,0,1,1,1,0,1,0,0,0,1,2,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,1,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,0,1,0,0,1,1,0,0,0,1,0,1,1,1,1,0,1,1,0,0,1,0,0,0,0,1,0,2,1,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,0,0,1,1,0,0,1,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,1,1,0,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,0,1,0,1,0,1,1,1,0,0,0,0,0,1,0,1,0,1,1,1,0,1,0,1,1,0,1,0,1,1,0,0,0,1,1,0,1,1,0,0,1,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,2,2,2,2,2,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,1,0,1,0,1,1,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,1,0,1,0,1,0,1,1,1,1,1,1,0,1,0,1,0,0,0,0,0,1,1,0,1,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,1,0,0,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,1,1,0,0,0,1,0,1,1,0,1,1,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,1,1,1,0,0,1,0,1,0,1,1,0,0,0,1,0,0,0,1,1,1,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,1,0,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,0,0,0,0,1,1,0,0,1,0,0,1,0,1,1,1,0,1,0,0,1,0,1,0,1,0,1,1,1,1,0,1,0,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,1,1,1,0,1,0,0,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,1,0,1,1,1,1,1,0,1,0,0,1,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,1,1,1,0,0,1,0,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,1,0,0,1,0,0,0,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,1,0,0,2,2,1,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,1,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,0,1,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,1,1,0,1,0,1,1,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1,1,0,1,0,0,0,0,1,0,1,1,0,0,0,0,1,0,1,0,0,1,0,0,0,1,0,0,0,0,1,1,0,1,0,1,1,0,0,1,1,1,1,1,0,1,0,0,1,1,1,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,1,0,0,1,1,1,1,1,0,0,0,1,0,1,0,0,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,1,0,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,0,1,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,0,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0,0,1,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,1,0,1,1,0,0,0,1,1,0,0,1,0,1,1,0,1,0,1,1,0,0,1,0,1,0,1,0,1,0,0,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,0,1,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,1,1,0,1,0,0,0,1,0,1,1,0,0,1,0,0,1,1,0,0];
}

function getTilePallet()
{
	return ["ocean_rock_a","ocean_rock_b","mud_slide","LavaTest06","LavaTest05"];
}
