

/*jslint strict: false, plusplus: false */
/*global define: false, require: false,  XMLHttpRequest: false, ActiveXObject: false,
  window: false, Packages: false, java: false, process: false */

(function () {
    //Load the text plugin, so that the XHR calls can be made.
    var buildMap = {}, fetchText, fs,
        progIds = ['Msxml2.XMLHTTP', 'Microsoft.XMLHTTP', 'Msxml2.XMLHTTP.4.0'];

    function createXhr() {
        //Would love to dump the ActiveX crap in here. Need IE 6 to die first.
        var xhr, i, progId;
        if (typeof XMLHttpRequest !== "undefined") {
            return new XMLHttpRequest();
        } else {
            for (i = 0; i < 3; i++) {
                progId = progIds[i];
                try {
                    xhr = new ActiveXObject(progId);
                } catch (e) {}

                if (xhr) {
                    progIds = [progId];  // so faster next time
                    break;
                }
            }
        }

        if (!xhr) {
            throw new Error("require.getXhr(): XMLHttpRequest not available");
        }

        return xhr;
    }

    if (typeof window !== "undefined" && window.navigator && window.document) {
        fetchText = function (url, callback) {
            var xhr = createXhr();
            xhr.open('GET', url, true);
            xhr.onreadystatechange = function (evt) {
                //Do not explicitly handle errors, those should be
                //visible via console output in the browser.
                if (xhr.readyState === 4) {
                    callback(xhr.responseText);
                }
            };
            xhr.send(null);
        };
    } else if (typeof process !== "undefined" &&
             process.versions &&
             !!process.versions.node) {
        //Using special require.nodeRequire, something added by r.js.
        fs = require.nodeRequire('fs');

        fetchText = function (url, callback) {
            callback(fs.readFileSync(url, 'utf8'));
        };
    } else if (typeof Packages !== 'undefined') {
        //Why Java, why is this so awkward?
        fetchText = function (url, callback) {
            var encoding = "utf-8",
                file = new java.io.File(url),
                lineSeparator = java.lang.System.getProperty("line.separator"),
                input = new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(file), encoding)),
                stringBuffer, line,
                content = '';
            try {
                stringBuffer = new java.lang.StringBuffer();
                line = input.readLine();

                // Byte Order Mark (BOM) - The Unicode Standard, version 3.0, page 324
                // http://www.unicode.org/faq/utf_bom.html

                // Note that when we use utf-8, the BOM should appear as "EF BB BF", but it doesn't due to this bug in the JDK:
                // http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4508058
                if (line && line.length() && line.charAt(0) === 0xfeff) {
                    // Eat the BOM, since we've already found the encoding on this file,
                    // and we plan to concatenating this buffer with others; the BOM should
                    // only appear at the top of a file.
                    line = line.substring(1);
                }

                stringBuffer.append(line);

                while ((line = input.readLine()) !== null) {
                    stringBuffer.append(lineSeparator);
                    stringBuffer.append(line);
                }
                //Make sure we return a JavaScript string and not a Java string.
                content = String(stringBuffer.toString()); //String
            } finally {
                input.close();
            }
            callback(content);
        };
    }

    define('refine',[],function () {
        return {
            load: function (name, parentRequire, load, config) {
                var url = parentRequire.toUrl(name + '.refine');
                fetchText(url, function (text) {
                    text = text.replace(/refine\s*\(/g, 'define(');

                    if (config.isBuild) {
                        buildMap[name] = text;
                    }

                    //Add in helpful debug line
                    text += "\r\n//@ sourceURL=" + url;

                    load.fromText(text);

                    parentRequire([name], function (value) {
                        load(value);
                    });
                });
            },

            write: function (pluginName, name, write) {
                if (name in buildMap) {
                    var text = buildMap[name];
                    write.asModule(pluginName + "!" + name, text);
                }
            }
        };
    });

}());

define('refine!c',['refine!a', 'exports'], function (a, exports) {
    exports.name = 'c';
    exports.a = a;
});

define('refine!b',['refine!c', 'exports'], function (c, exports) {
    exports.name = 'b';
    exports.c = c;
});

define('refine!a',['refine!b', 'exports'], function (b, exports) {
    exports.name = 'a';
    exports.b = b;
});

define('refine!e',['refine!d'], function(d) {
    function e() {
        return e.name + require('refine!d').name;
    }

    e.name = 'e';

    return e;
});
define('refine!d',['refine!e'], function(e) {
    function d() {
        return require('refine!e')();
    }

    d.name = 'd';

    return d;
});
require({
        baseUrl: requirejs.isBrowser ? './' : './circular/transpiler',
        paths: {
            'text': '../../../../text/text',
            'refine': '../../plugins/fromText/refine'
        }
    },
    ["require", "refine!a", "refine!b", "refine!d"],
    function(require, a, b, d) {
        doh.register(
            "circularTranspiler",
            [
                function circularTranspiler(t) {
                    t.is("a", a.name);
                    t.is("b", a.b.name);
                    t.is("c", a.b.c.name);
                    t.is("b", b.name);
                    t.is("c", b.c.name);
                    t.is("ed", d());
                 }
            ]
        );
        doh.run();
    }
);

define("transpiler-tests", function(){});
