/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 22:17:49 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.GotoEvent;
import uk.ac.sanger.artemis.GotoListener;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class SimpleGotoEventSource_ESTest extends SimpleGotoEventSource_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Marker) null, (Marker) null).when(strand0).makeMarker(anyInt());
      Marker marker0 = mock(Marker.class, new ViolatedAssumptionAnswer());
      doReturn(strand0).when(marker0).getStrand();
      Strand strand1 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(marker0).when(strand1).makeMarker(anyInt());
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn(strand1).when(bases0).getForwardStrand();
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      doReturn("{GvRwvCCN.").when(entryGroup0).toString();
      doReturn(bases0).when(entryGroup0).getBases();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      simpleGotoEventSource0.gotoFirstBase();
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      GotoListener gotoListener0 = mock(GotoListener.class, new ViolatedAssumptionAnswer());
      simpleGotoEventSource0.addGotoListener(gotoListener0);
      Marker marker0 = mock(Marker.class, new ViolatedAssumptionAnswer());
      simpleGotoEventSource0.gotoBase(marker0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.sendGotoEvent((GotoEvent) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn((Strand) null).when(bases0).getForwardStrand();
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      doReturn("C>v[\u0005K", "C>v[\u0005K").when(entryGroup0).toString();
      doReturn(bases0).when(entryGroup0).getBases();
      doReturn(1).when(entryGroup0).getSequenceLength();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.gotoLastBase();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      Marker marker0 = mock(Marker.class, new ViolatedAssumptionAnswer());
      GotoEvent gotoEvent0 = mock(GotoEvent.class, new ViolatedAssumptionAnswer());
      doReturn(marker0).when(gotoEvent0).getMarker();
      simpleGotoEventSource0.sendGotoEvent(gotoEvent0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      GotoEvent gotoEvent0 = mock(GotoEvent.class, new ViolatedAssumptionAnswer());
      doReturn((Marker) null).when(gotoEvent0).getMarker();
      simpleGotoEventSource0.sendGotoEvent(gotoEvent0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      simpleGotoEventSource0.addGotoListener((GotoListener) null);
      Marker marker0 = mock(Marker.class, new ViolatedAssumptionAnswer());
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.gotoBase(marker0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      EntryGroup entryGroup0 = simpleGotoEventSource0.getEntryGroup();
      assertNull(entryGroup0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      GotoListener gotoListener0 = mock(GotoListener.class, new ViolatedAssumptionAnswer());
      simpleGotoEventSource0.removeGotoListener(gotoListener0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(entryGroup0).toString();
      doReturn((Bases) null).when(entryGroup0).getBases();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.gotoBase((-1));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Marker) null, (Marker) null).when(strand0).makeMarker(anyInt());
      Marker marker0 = mock(Marker.class, new ViolatedAssumptionAnswer());
      doReturn(strand0).when(marker0).getStrand();
      Strand strand1 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(marker0).when(strand1).makeMarker(anyInt());
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn(strand1).when(bases0).getForwardStrand();
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      doReturn("{GvRwvCCN.", "feature_stck_Jview").when(entryGroup0).toString();
      doReturn(bases0).when(entryGroup0).getBases();
      doReturn((-1678)).when(entryGroup0).getSequenceLength();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      simpleGotoEventSource0.gotoLastBase();
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn((Strand) null).when(bases0).getForwardStrand();
      EntryGroup entryGroup0 = mock(EntryGroup.class, new ViolatedAssumptionAnswer());
      doReturn("p`").when(entryGroup0).toString();
      doReturn(bases0).when(entryGroup0).getBases();
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(entryGroup0);
      // Undeclared exception!
      try { 
        simpleGotoEventSource0.gotoFirstBase();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleGotoEventSource", e);
      }
  }
}
