/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import net.sf.jiapi.file.attribute.LocalVariableTableAttribute;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.InstructionList;

class LVTEntry {
    private final short idx;
    private final String descriptor;
    private final Instruction startIns;
    private Instruction endIns;
    private LocalVariableTableAttribute.LocalVariable lv;

    LVTEntry(LocalVariableTableAttribute.LocalVariable lv, InstructionList il) {
        Instruction ins;
        this.lv = lv;
        this.idx = lv.getIndex();
        this.descriptor = lv.getDescriptor();
        if (lv.getStartPc() != 0) {
            Instruction startIns = il.instructionAtOffset(lv.getStartPc());
            int startInsIdx = il.indexOf(startIns);
            this.startIns = il.get(startInsIdx - 1);
        } else {
            this.startIns = null;
        }
        this.endIns = ins = il.instructionAtOffset((short)(lv.getStartPc() + lv.getLength() - 1));
    }

    LVTEntry(int i, String descriptor, Instruction startIns, InstructionList il) {
        this.descriptor = descriptor;
        this.idx = (short)i;
        this.startIns = startIns;
        this.endIns = null;
    }

    void update() {
        short o1 = 0;
        if (this.startIns != null) {
            o1 = (short)(this.startIns.getOffset() + this.startIns.length());
        }
        short o2 = this.endIns.getOffset();
        this.lv.setStartPc(o1);
        this.lv.setLength((short)(o2 - o1));
    }

    public int getIndex() {
        return this.idx;
    }

    public String toString() {
        return "LV(" + this.idx + "):" + this.descriptor;
    }
}

