/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2024 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "InteractiveSliceViewer.h"

// disable warning generated by clang about the surrounded headers
#include <CamiTKDisableWarnings>
#include <vtkCamera.h>
#include <CamiTKReEnableWarnings>

using namespace camitk;

// -------------------- Constructor --------------------
InteractiveSliceViewer::InteractiveSliceViewer(QString name) : InteractiveViewer(name, InteractiveViewer::SLICE_VIEWER) {
    setComponentClassNames(QStringList() << "SingleImageComponent");

    if (name == "Axial Viewer") {
        // Axial Viewer
        setDescription("Default slice viewer that displays the axial slices");
        getRendererWidget()->setCameraOrientation(RendererWidget::RIGHT_DOWN);
        QString letters[4] = { QString("R"), QString("L"), QString("A"), QString("P") };
        getRendererWidget()->setOrientationDecorationsLetters(letters);
        toggleOrientationDecorations(true);
        getRendererWidget()->getActiveCamera()->ParallelProjectionOn();
    }
    else {
        if (name == "Coronal Viewer") {
            // Coronal Viewer
            setDescription("Default slice viewer that displays the coronal slices");
            getRendererWidget()->setCameraOrientation(RendererWidget::LEFT_BACK);
            QString letters[4] = { QString("R"), QString("L"), QString("S"), QString("I") };
            getRendererWidget()->setOrientationDecorationsLetters(letters);
            toggleOrientationDecorations(true);
            getRendererWidget()->getActiveCamera()->ParallelProjectionOn();
        }
        else {
            if (name == "Sagittal Viewer") {
                // Sagittal Viewer
                setDescription("Default slice viewer that displays the sagittal slices");
                getRendererWidget()->setCameraOrientation(RendererWidget::BACK_DOWN);
                QString letters[4] = { QString("A"), QString("P"), QString("S"), QString("I") };
                getRendererWidget()->setOrientationDecorationsLetters(letters);
                toggleOrientationDecorations(true);
                getRendererWidget()->getActiveCamera()->ParallelProjectionOn();
            }
            else {
                if (name == "Arbitrary Viewer") {
                    // Arbitrary Viewer
                    setDescription("Default slice viewer that displays the arbitrary orientation slices");
                    toggleOrientationDecorations(false);
                }
            }
        }
    }
}

