/* This file is part of Clementine.
   Copyright 2012, David Sansome <me@davidsansome.com>
   Copyright 2014, Krzysztof Sobiecki <sobkas@gmail.com>
   Copyright 2014, John Maguire <john.maguire@gmail.com>

   Clementine is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Clementine is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Clementine.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INTERNET_PODCASTS_ADDPODCASTBYURL_H_
#define INTERNET_PODCASTS_ADDPODCASTBYURL_H_

#include "addpodcastpage.h"

class AddPodcastPage;
class OpmlContainer;
class PodcastUrlLoader;
class PodcastUrlLoaderReply;
class Ui_AddPodcastByUrl;

class QUrl;

class AddPodcastByUrl : public AddPodcastPage {
  Q_OBJECT

 public:
  explicit AddPodcastByUrl(Application* app, QWidget* parent = nullptr);
  ~AddPodcastByUrl();

  void Show();

  void SetOpml(const OpmlContainer& opml);
  void SetUrlAndGo(const QUrl& url);

 private slots:
  void GoClicked();
  void RequestFinished(PodcastUrlLoaderReply* reply);

 private:
  Ui_AddPodcastByUrl* ui_;
  PodcastUrlLoader* loader_;
};

#endif  // INTERNET_PODCASTS_ADDPODCASTBYURL_H_
