# Функции для работы с Nullable-агрументами

## isNull

Проверяет является ли аргумент [NULL](../syntax.md#null).

```
isNull(x)
```

**Параметры**

- `x` — значение с не составным типом данных.

**Возвращаемое значение**

- `1`, если `x` — `NULL`.
- `0`, если `x` — не `NULL`.

**Пример**

Входная таблица

```
┌─x─┬────y─┐
│ 1 │ ᴺᵁᴸᴸ │
│ 2 │    3 │
└───┴──────┘
```

Запрос

```
:) SELECT x FROM t_null WHERE isNull(y)

SELECT x
FROM t_null
WHERE isNull(y)

┌─x─┐
│ 1 │
└───┘

1 rows in set. Elapsed: 0.010 sec.
```

## isNotNull

Проверяет не является ли аргумент [NULL](../syntax.md#null).

```
isNotNull(x)
```

**Параметры**

- `x` — значение с не составным типом данных.

**Возвращаемое значение**

- `0`, если `x` — `NULL`.
- `1`, если `x` — не `NULL`.

**Пример**

Входная таблица

```
┌─x─┬────y─┐
│ 1 │ ᴺᵁᴸᴸ │
│ 2 │    3 │
└───┴──────┘
```

Запрос

```
:) SELECT x FROM t_null WHERE isNotNull(y)

SELECT x
FROM t_null
WHERE isNotNull(y)

┌─x─┐
│ 2 │
└───┘

1 rows in set. Elapsed: 0.010 sec.
```

## coalesce

Последовательно слева-направо проверяет являются ли переданные аргументы `NULL` и возвращает первый не `NULL`.

```
coalesce(x,...)
```
**Параметры**

- Произвольное количество параметров не составного типа. Все параметры должны быть совместимы по типу данных.

**Возвращаемые значения**

- Первый не `NULL` аргумент.
- `NULL`, если все аргументы — `NULL`.

**Пример**

Рассмотрим адресную книгу, в которой может быть указано несколько способов связи с клиентом.

```
┌─name─────┬─mail─┬─phone─────┬──icq─┐
│ client 1 │ ᴺᵁᴸᴸ │ 123-45-67 │  123 │
│ client 2 │ ᴺᵁᴸᴸ │ ᴺᵁᴸᴸ      │ ᴺᵁᴸᴸ │
└──────────┴──────┴───────────┴──────┘
```

Поля `mail` и `phone` имеют тип String, а поле `icq` — `UInt32`, его необходимо будет преобразовать в `String`.

Получим из адресной книги первый доступный способ связаться с клиентом:

```
:) SELECT coalesce(mail, phone, CAST(icq,'Nullable(String)')) FROM aBook

SELECT coalesce(mail, phone, CAST(icq, 'Nullable(String)'))
FROM aBook

┌─name─────┬─coalesce(mail, phone, CAST(icq, 'Nullable(String)'))─┐
│ client 1 │ 123-45-67                                            │
│ client 2 │ ᴺᵁᴸᴸ                                                 │
└──────────┴──────────────────────────────────────────────────────┘

2 rows in set. Elapsed: 0.006 sec.
```

## ifNull

Возвращает альтернативное значение, если основной аргумент — `NULL`.

```
ifNull(x,alt)
```

**Параметры**

- `x` — значение для проверки на `NULL`,
- `alt` — значение, которое функция вернёт, если `x` — `NULL`.

**Возвращаемые значения**

- Значение `x`, если `x` — не `NULL`.
- Значение `alt`, если `x` — `NULL`.

**Пример**

```
SELECT ifNull('a', 'b')

┌─ifNull('a', 'b')─┐
│ a                │
└──────────────────┘
```
```
SELECT ifNull(NULL, 'b')

┌─ifNull(NULL, 'b')─┐
│ b                 │
└───────────────────┘
```

## nullIf

Возвращает `NULL`, если аргументы равны.

```
nullIf(x, y)
```

**Параметры**

`x`, `y` — значения для сравнивания. Они должны быть совместимых типов, иначе ClickHouse сгенерирует исключение.

**Возвращаемые значения**

- `NULL`, если аргументы равны.
- Значение `x`, если аргументы не равны.

**Пример**

```
SELECT nullIf(1, 1)

┌─nullIf(1, 1)─┐
│         ᴺᵁᴸᴸ │
└──────────────┘
```
```
SELECT nullIf(1, 2)

┌─nullIf(1, 2)─┐
│            1 │
└──────────────┘
```

## assumeNotNull

Приводит значение типа [Nullable](../../data_types/nullable.md) к не `Nullable`, если значение не `NULL`.

```
assumeNotNull(x)
```

**Параметры**

- `x` — исходное значение.

**Возвращаемые значения**

- Исходное значение с не `Nullable` типом, если оно — не `NULL`.
- Значение по умолчанию для не `Nullable` типа, если исходное значение — `NULL`.

**Пример**

Рассмотрим таблицу `t_null`.

```
SHOW CREATE TABLE t_null

┌─statement─────────────────────────────────────────────────────────────────┐
│ CREATE TABLE default.t_null ( x Int8,  y Nullable(Int8)) ENGINE = TinyLog │
└───────────────────────────────────────────────────────────────────────────┘
```
```
┌─x─┬────y─┐
│ 1 │ ᴺᵁᴸᴸ │
│ 2 │    3 │
└───┴──────┘
```

Применим функцию `assumeNotNull` к столбцу `y`.

```
SELECT assumeNotNull(y) FROM t_null

┌─assumeNotNull(y)─┐
│                0 │
│                3 │
└──────────────────┘
```
```
SELECT toTypeName(assumeNotNull(y)) FROM t_null

┌─toTypeName(assumeNotNull(y))─┐
│ Int8                         │
│ Int8                         │
└──────────────────────────────┘
```

## toNullable

Преобразует тип аргумента к `Nullable`.

```
toNullable(x)
```

**Параметры**

- `x` — значение произвольного не составного типа.

**Возвращаемое значение**

- Входное значение с типом не `Nullable`.

**Пример**

```
SELECT toTypeName(10)

┌─toTypeName(10)─┐
│ UInt8          │
└────────────────┘

SELECT toTypeName(toNullable(10))

┌─toTypeName(toNullable(10))─┐
│ Nullable(UInt8)            │
└────────────────────────────┘
```

[Оригинальная статья](https://clickhouse.yandex/docs/ru/query_language/functions/functions_for_nulls/) <!--hide-->
