#
# Cache.py - cache interface
#
# Copyright (c) 2006-2008 The DITrack Project, www.ditrack.org.
#
# $Id: Cache.py 2605 2008-06-23 03:07:37Z vss $
# $HeadURL: https://svn.xiolabs.com/ditrack/src/tags/0.8/DITrack/DB/Cache.py $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#

import time

# DITrack modules
import DITrack.dt.globals
import DITrack.DB.Common

CACHE_FILE = "cache"

#
# Classes
#

class Cache:
    """
    Class encapsulating cache operations.
    """

    def __del__(self):
        self.cache.close()

    def __init__(self, path):
        """
        PATH is a path to the issue database.
        """
        self.cache = DITrack.DB.Common.open_local_dt_shelve(path, CACHE_FILE)
        self.version = DITrack.dt.globals.VERSION

    def __len__(self):
        return len(self.get())

    def get(self):
        if ("data" in self.cache) and ("version" in self.cache) and \
            (self.cache["version"] == self.version):
            return self.cache["data"]

        self.set([])
        return []

    def set(self, issues):
        self.cache["data"] = issues
        self.cache["version"] = self.version
        self.cache.sync()
