# Pull Requests Tagging

If you need to tag folks on an issue or PR, you will generally want to tag the owners (not the lead) for [area](#areas) to which the change or issue is closest to. For areas which are large and can be operating system or architecture specific it's better to tag owners of [OS](#operating-systems) or [Architecture](#architectures).

## Repos

This list is for this **dotnet/runtime** repo. The **dotnet/aspnetcore** repo has [its own list](https://github.com/dotnet/aspnetcore/blob/main/docs/area-owners.md).

## Areas

Note: Editing this file doesn't update the mapping used by `@msftbot` for area-specific issue/PR notifications. That configuration is part of the [`fabricbot.json`](../.github/fabricbot.json) file, and many areas use GitHub teams for those notifications. If you're a community member interested in receiving area-specific issue/PR notifications, you won't appear in this table or be added to those GitHub teams, but you can create a PR that updates `fabricbot.json` to add yourself to those notifications. See [automation.md](infra/automation.md) for more information on the schema and tools used by FabricBot.

| Area                                           | Lead                 | Owners (area experts to tag in PRs and issues)      | Notes                                                                                                                                                                                                                                                                                     |
|------------------------------------------------|----------------------|-----------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| area-AssemblyLoader-coreclr                    | @agocke              | @agocke @elinor-fung                                |                                                                                                                                                                                                                                                                                           |
| area-AssemblyLoader-mono                       | @agocke              | @agocke @elinor-fung                                |                                                                                                                                                                                                                                                                                           |
| area-Build-mono                                | @lewing              | @akoeplinger                                        |                                                                                                                                                                                                                                                                                           |
| area-Codeflow                                  | @dotnet/dnr-codeflow | @dotnet/dnr-codeflow                                | Used for automated PRs that ingest code from other repos                                                                                                                                                                                                                                  |
| area-Codegen-AOT-mono                          | @steveisok           | @kotlarmilos                                        |                                                                                                                                                                                                                                                                                           |
| area-CodeGen-coreclr                           | @JulieLeeMSFT        | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Codegen-Interpreter-mono                  | @vitek-karas         | @BrzVlad @kotlarmilos                               |                                                                                                                                                                                                                                                                                           |
| area-Codegen-Intrinsics-mono                   | @steveisok           | @fanyang-mono                                       |                                                                                                                                                                                                                                                                                           |
| area-Codegen-JIT-mono                          | @steveisok           |                                                     |                                                                                                                                                                                                                                                                                           |
| area-Codegen-LLVM-mono                         | @steveisok           |                                                     |                                                                                                                                                                                                                                                                                           |
| area-Codegen-meta-mono                         | @steveisok           |                                                     |                                                                                                                                                                                                                                                                                           |
| area-CrossGen/NGEN-coreclr                     | @steveisok           | @dotnet/crossgen-contrib                            |                                                                                                                                                                                                                                                                                           |
| area-crossgen2-coreclr                         | @steveisok           | @dotnet/crossgen-contrib                            |                                                                                                                                                                                                                                                                                           |
| area-Debugger-mono                             | @tommcdon            | @thaystg                                            |                                                                                                                                                                                                                                                                                           |
| area-DependencyModel                           | @ericstj             | @dotnet/area-dependencymodel                        | Included:<ul><li>Microsoft.Extensions.DependencyModel</li></ul>                                                                                                                                                                                                                           |
| area-Diagnostics-coreclr                       | @tommcdon            | @tommcdon @dotnet/dotnet-diag                       |                                                                                                                                                                                                                                                                                           |
| area-Diagnostics-mono                          | @tommcdon            | @tommcdon @mdh1418 @thaystg                         |                                                                                                                                                                                                                                                                                           |
| area-EnC-mono                                  | @tommcdon            | @mikelle-rogers @thaystg                            | Hot Reload on WebAssembly, Android, iOS, etc . @lambdageek to consult                                                                                                                                                                                                                     |
| area-ExceptionHandling-coreclr                 | @mangod9             | @janvorli                                           |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Caching                        | @ericstj             | @dotnet/area-extensions-caching                     | Consultants: @mgravell, @sebastienros                                                                                                                                                                                                                                                     |
| area-Extensions-Configuration                  | @ericstj             | @dotnet/area-extensions-configuration               | Consultants: @eerhardt                                                                                                                                                                                                                                                                    |
| area-Extensions-DependencyInjection            | @ericstj             | @dotnet/area-extensions-dependencyinjection         | Consultants: @halter73, @benjaminpetit                                                                                                                                                                                                                                                    |
| area-Extensions-FileSystem                     | @jeffhandley         | @dotnet/area-extensions-filesystem                  |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Hosting                        | @ericstj             | @dotnet/area-extensions-hosting                     | Consultants: @halter73, @tratcher                                                                                                                                                                                                                                                         |
| area-Extensions-HttpClientFactory              | @karelz              | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-Extensions-Logging                        | @ericstj             | @dotnet/area-extensions-logging                     | Consultants: @brennanconroy                                                                                                                                                                                                                                                               |
| area-Extensions-Options                        | @ericstj             | @dotnet/area-extensions-options                     | Consultants: @eerhardt, @brennanconroy                                                                                                                                                                                                                                                    |
| area-Extensions-Primitives                     | @ericstj             | @dotnet/area-extensions-primitives                  |                                                                                                                                                                                                                                                                                           |
| area-GC-coreclr                                | @mangod9             | @Maoni0                                             |                                                                                                                                                                                                                                                                                           |
| area-GC-mono                                   | @mangod9             | @mangod9                                            | @BrzVlad to consult                                                                                                                                                                                                                                                                       |
| area-Host                                      | @agocke              | @jeffschwMSFT @vitek-karas  @vsadov                 | Issues with dotnet.exe including bootstrapping, framework detection, hostfxr.dll and hostpolicy.dll                                                                                                                                                                                       |
| area-HostModel                                 | @agocke              | @vitek-karas                                        |                                                                                                                                                                                                                                                                                           |
| area-ILTools-coreclr                           | @JulieLeeMSFT        | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure                            | @agocke              | @jeffschwMSFT @MichaelSimons                        |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-coreclr                    | @agocke              | @jeffschwMSFT                                       |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-installer                  | @MichaelSimons       | @NikolaMilosavljevic                                |                                                                                                                                                                                                                                                                                           |
| area-Infrastructure-libraries                  | @ericstj             | @dotnet/area-infrastructure-libraries               | Covers:<ul><li>Packaging</li><li>Build and test infra for libraries in dotnet/runtime repo</li><li>VS integration</li></ul><br/>                                                                                                                                                          |
| area-Infrastructure-mono                       | @steveisok           | @agocke                                             | Consulting with @directhex                                                                                                                                                                                                                                                                |
| area-Interop-coreclr                           | @agocke              | @AaronRobinsonMSFT @jkoritzinsky                    |                                                                                                                                                                                                                                                                                           |
| area-Interop-mono                              | @agocke              | @AaronRobinsonMSFT @jkoritzinsky                    |                                                                                                                                                                                                                                                                                           |
| area-Meta                                      | @jeffhandley         | @dotnet/area-meta                                   | Cross-cutting concerns that span many or all areas, including project-wide code/test patterns and documentation.                                                                                                                                                                          |
| area-Microsoft.CSharp                          | @jaredpar            | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-Microsoft.VisualBasic                     | @jaredpar            | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-Microsoft.Win32                           | @ericstj             | @dotnet/area-microsoft-win32                        | Included:<ul><li>System.Windows.Extensions</li></ul>                                                                                                                                                                                                                                      |
| area-NativeAOT-coreclr                         | @agocke              | @dotnet/ilc-contrib                                 |                                                                                                                                                                                                                                                                                           |
| area-PAL-coreclr                               | @mangod9             | @janvorli                                           |                                                                                                                                                                                                                                                                                           |
| area-R2RDump-coreclr                           | @steveisok           | @steveisok                                          |                                                                                                                                                                                                                                                                                           |
| area-ReadyToRun-coreclr                        | @steveisok           | @steveisok                                          |                                                                                                                                                                                                                                                                                           |
| area-Serialization                             | @HongGit             | @StephenMolloy @HongGit                             | Packages:<ul><li>System.Runtime.Serialization.Xml</li><li>System.Runtime.Serialization.Json</li><li>System.Private.DataContractSerialization</li><li>System.Xml.XmlSerializer</li></ul> Excluded:<ul><li>System.Runtime.Serialization.Formatters</li></ul>                                |
| area-Setup                                     | @MichaelSimons       | @NikolaMilosavljevic                                | Distro-specific (Linux, Mac and Windows) setup packages and msi files                                                                                                                                                                                                                     |
| area-Single-File                               | @agocke              | @vitek-karas @vsadov                                |                                                                                                                                                                                                                                                                                           |
| area-Snap                                      | @MichaelSimons       | @NikolaMilosavljevic @leecow @MichaelSimons         |                                                                                                                                                                                                                                                                                           |
| area-System.Buffers                            | @jeffhandley         | @dotnet/area-system-buffers                         |                                                                                                                                                                                                                                                                                           |
| area-System.ClientModel                        | @terrajobst          | @dotnet/fxdc                                        | Bugs and feature requests should go to https://github.com/Azure/azure-sdk-for-net/issues. We don't own the code, but FXDC reviews changes to determine overlap with other `System` concepts. The Azure SDK team will post API updates in this repo for us to review.                      |
| area-System.CodeDom                            | @ericstj             | @dotnet/area-system-codedom                         |                                                                                                                                                                                                                                                                                           |
| area-System.Collections                        | @jeffhandley         | @dotnet/area-system-collections                     | Excluded:<ul><li>System.Array -> System.Runtime</li></ul>                                                                                                                                                                                                                                 |
| area-System.ComponentModel                     | @ericstj             | @dotnet/area-system-componentmodel                  | Consultants: @dotnet/dotnet-winforms                                                                                                                                                                                                                                                      |
| area-System.ComponentModel.Composition         | @ericstj             | @dotnet/area-system-componentmodel-composition      |                                                                                                                                                                                                                                                                                           |
| area-System.ComponentModel.DataAnnotations     | @jeffhandley         | @dotnet/area-system-componentmodel-dataannotations  | Included:<ul><li>System.ComponentModel.Annotations</li></ul>                                                                                                                                                                                                                              |
| area-System.Composition                        | @ericstj             | @dotnet/area-system-composition                     |                                                                                                                                                                                                                                                                                           |
| area-System.Configuration                      | @ericstj             | @dotnet/area-system-configuration                   |                                                                                                                                                                                                                                                                                           |
| area-System.Console                            | @jeffhandley         | @dotnet/area-system-console                         |                                                                                                                                                                                                                                                                                           |
| area-System.Data                               | @sammonort          | @ajcvickers @davoudeshtehari @david-engel @roji     | <ul><li>Odbc, OleDb - @saurabh500</li></ul>                                                                                                                                                                                                                                                |
| area-System.Data.Odbc                          | @sammonort          | @ajcvickers @roji                                   |                                                                                                                                                                                                                                                                                            |
| area-System.Data.OleDB                         | @sammonort          | @ajcvickers @roji                                   |                                                                                                                                                                                                                                                                                            |
| area-System.Data.SqlClient                     | @David-Engel         | @davoudeshtehari @david-engel @jrahnama             | Archived component - limited churn/contributions (see https://devblogs.microsoft.com/dotnet/introducing-the-new-microsoftdatasqlclient/)                                                                                                                                                  |
| area-System.DateTime                           | @ericstj             | @dotnet/area-system-datetime                        | System namespace APIs related to dates and times, including DateOnly, DateTime, DateTimeKind, DateTimeOffset, DayOfWeek, TimeOnly, TimeSpan, TimeZone, and TimeZoneInfo                                                                                                                   |
| area-System.Diagnostics                        | @tommcdon            | @dotnet/area-system-diagnostics                     |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics-coreclr                | @tommcdon            | @dotnet/area-system-diagnostics-coreclr             |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics-mono                   | @tommcdon            | @thaystg                                            |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Activity               | @ericstj             | @dotnet/area-system-diagnostics-activity            |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.EventLog               | @ericstj             | @dotnet/area-system-diagnostics-eventlog            |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Metric                 | @ericstj             | @dotnet/area-system-diagnostics-metric              |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.PerformanceCounter     | @ericstj             | @dotnet/area-system-diagnostics-performancecounter  |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Process                | @jeffhandley         | @dotnet/area-system-diagnostics-process             |                                                                                                                                                                                                                                                                                           |
| area-System.Diagnostics.Tracing                | @tommcdon            | @dotnet/area-system-diagnostics-tracing             | Included:<ul><li>System.Diagnostics.DiagnosticSource</li></ul>                                                                                                                                                                                                                            |
| area-System.Diagnostics.TraceSource            | @ericstj             | @dotnet/area-system-diagnostics-tracesource         |                                                                                                                                                                                                                                                                                           |
| area-System.DirectoryServices                  | @ericstj             | @dotnet/area-system-directoryservices               | Consultants: @BRDPM @grubioe @jay98014                                                                                                                                                                                                                                                    |
| area-System.Drawing                            | @ericstj             | @dotnet/area-system-drawing                         | Excluded:<ul><li>System.Drawing.Common -> winforms</li></ul>                                                                                                                                                                                                                              |
| area-System.Dynamic.Runtime                    | @jaredpar            | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-System.Formats.Asn1                       | @jeffhandley         | @dotnet/area-system-formats-asn1                    | Consultants: @bartonjs @vcsjones                                                                                                                                                                                                                                                          |
| area-System.Formats.Cbor                       | @jeffhandley         | @dotnet/area-system-formats-cbor                    | Consultants: @bartonjs @vcsjones                                                                                                                                                                                                                                                          |
| area-System.Formats.Nrbf                       | @jeffhandley         | @dotnet/area-system-formats-nrbf                    | Consultants: @bartonjs @grabyourpitchforks                                                                                                                                                                                                                                                |
| area-System.Formats.Tar                        | @ericstj             | @dotnet/area-system-formats-tar                     |                                                                                                                                                                                                                                                                                           |
| area-System.Globalization                      | @ericstj             | @dotnet/area-system-globalization                   |                                                                                                                                                                                                                                                                                           |
| area-System.IO                                 | @jeffhandley         | @dotnet/area-system-io                              |                                                                                                                                                                                                                                                                                           |
| area-System.IO.Compression                     | @ericstj             | @dotnet/area-system-io-compression                  | Included:<ul><li>System.Formats.Tar</li><li>System.IO.Packaging</li></ul>                                                                                                                                                                                                                 |
| area-System.IO.Hashing                         | @jeffhandley         | @dotnet/area-system-io-hashing                      | APIs within the System.IO.Hashing namespace, which align more with cryptography than with I/O                                                                                                                                                                                             |
| area-System.IO.Pipelines                       | @adityamandaleeka    | @davidfowl @halter73                                |                                                                                                                                                                                                                                                                                           |
| area-System.IO.Ports                           | @jeffhandley         | @dotnet/area-system-io-ports                        |                                                                                                                                                                                                                                                                                           |
| area-System.Linq                               | @jeffhandley         | @dotnet/area-system-linq                            |                                                                                                                                                                                                                                                                                           |
| area-System.Linq.Expressions                   | @jaredpar            | @cston @333fred                                     | Archived component - limited churn/contributions (see [#27790](https://github.com/dotnet/runtime/issues/27790))                                                                                                                                                                           |
| area-System.Linq.Parallel                      | @jeffhandley         | @dotnet/area-system-linq-parallel                   | Consultants: @stephentoub @kouvel                                                                                                                                                                                                                                                         |
| area-System.Management                         | @ericstj             | @dotnet/area-system-management                      | WMI                                                                                                                                                                                                                                                                                       |
| area-System.Memory                             | @jeffhandley         | @dotnet/area-system-memory                          |                                                                                                                                                                                                                                                                                           |
| area-System.Net                                | @karelz              | @dotnet/ncl                                         | Included:<ul><li>System.Uri</li></ul>                                                                                                                                                                                                                                                     |
| area-System.Net.Http                           | @karelz              | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Quic                           | @karelz              | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Security                       | @karelz              | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Net.Sockets                        | @karelz              | @dotnet/ncl                                         |                                                                                                                                                                                                                                                                                           |
| area-System.Numerics                           | @jeffhandley         | @dotnet/area-system-numerics                        |                                                                                                                                                                                                                                                                                           |
| area-System.Numerics.Tensors                   | @jeffhandley         | @dotnet/area-system-numerics-tensors                |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection                         | @ericstj             | @dotnet/area-system-reflection                      |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection.Emit                    | @ericstj             | @dotnet/area-system-reflection-emit                 |                                                                                                                                                                                                                                                                                           |
| area-System.Reflection.Metadata                | @ericstj             | @dotnet/area-system-reflection-metadata             | Consultants: @tmat                                                                                                                                                                                                                                                                        |
| area-System.Resources                          | @ericstj             | @dotnet/area-system-resources                       |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime                            | @jeffhandley         | @dotnet/area-system-runtime                         | Included:<ul><li>System.Runtime.Serialization.Formatters</li><li>System.Runtime.InteropServices.RuntimeInfo</li><li>System.Array</li></ul>Excluded:<ul><li>Path -> System.IO</li><li>StopWatch -> System.Diagnostics</li><li>Uri -> System.Net</li><li>WebUtility -> System.Net</li></ul> |
| area-System.Runtime.Caching                    | @HongGit             | @StephenMolloy @HongGit                             |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.CompilerServices           | @ericstj             | @dotnet/area-system-runtime-compilerservices        |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.InteropServices            | @agocke              | @AaronRobinsonMSFT @jkoritzinsky                    | Excluded:<ul><li>System.Runtime.InteropServices.RuntimeInfo</li></ul>                                                                                                                                                                                                                     |
| area-System.Runtime.InteropServices.JavaScript | @lewing              | @pavelsavara                                        |                                                                                                                                                                                                                                                                                           |
| area-System.Runtime.Intrinsics                 | @jeffhandley         | @dotnet/area-system-runtime-intrinsics              | Consultants: @echesakovMSFT @kunalspathak                                                                                                                                                                                                                                                 |
| area-System.Security                           | @jeffhandley         | @dotnet/area-system-security                        | Consultants: @bartonjs @GrabYourPitchforks @SteveHarter @vcsjones @wfurt                                                                                                                                                                                                                  |
| area-System.ServiceModel                       | @HongGit             | @HongGit @mconnew                                   | Repo: https://github.com/dotnet/WCF<br>Packages:<ul><li>System.ServiceModel.Primitives</li><li>System.ServiceModel.Http</li><li>System.ServiceModel.NetTcp</li><li>System.ServiceModel.Duplex</li><li>System.ServiceModel.Security</li></ul>                                              |
| area-System.ServiceModel.Syndication           | @HongGit             | @StephenMolloy @HongGit                             |                                                                                                                                                                                                                                                                                           |
| area-System.ServiceProcess                     | @ericstj             | @dotnet/area-system-serviceprocess                  |                                                                                                                                                                                                                                                                                           |
| area-System.Speech                             | @jeffhandley         | @ericstj @jeffhandley                               |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Encoding                      | @jeffhandley         | @dotnet/area-system-text-encoding                   |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Encodings.Web                 | @jeffhandley         | @dotnet/area-system-text-encodings-web              |                                                                                                                                                                                                                                                                                           |
| area-System.Text.Json                          | @jeffhandley         | @dotnet/area-system-text-json                       |                                                                                                                                                                                                                                                                                           |
| area-System.Text.RegularExpressions            | @ericstj             | @dotnet/area-system-text-regularexpressions         | Consultants: @stephentoub                                                                                                                                                                                                                                                                 |
| area-System.Threading                          | @mangod9             | @kouvel                                             |                                                                                                                                                                                                                                                                                           |
| area-System.Threading.Channels                 | @ericstj             | @dotnet/area-system-threading-channels              | Consultants: @stephentoub                                                                                                                                                                                                                                                                 |
| area-System.Threading.RateLimiting             | @rafikiassumani-msft | @BrennanConroy @halter73                            |                                                                                                                                                                                                                                                                                           |
| area-System.Threading.Tasks                    | @ericstj             | @dotnet/area-system-threading-tasks                 | Consultants: @stephentoub                                                                                                                                                                                                                                                                 |
| area-System.Transactions                       | @sammonort           | @roji                                               |                                                                                                                                                                                                                                                                                           |
| area-System.Xml                                | @jeffhandley         | @dotnet/area-system-xml                             |                                                                                                                                                                                                                                                                                           |
| area-TieredCompilation-coreclr                 | @mangod9             | @kouvel                                             |                                                                                                                                                                                                                                                                                           |
| area-Tools-ILLink                              | @agocke              | @dotnet/illink                                      |                                                                                                                                                                                                                                                                                           |
| area-Tools-ILVerification                      | @JulieLeeMSFT        | @BruceForstall @dotnet/jit-contrib                  |                                                                                                                                                                                                                                                                                           |
| area-Tracing-coreclr                           | @tommcdon            | @dotnet/area-tracing-coreclr                        | .NET runtime issues for EventPipe and ICorProfiler                                                                                                                                                                                                                                        |
| area-Tracing-mono                              | @tommcdon            | @tommcdon @thaystg                                  |                                                                                                                                                                                                                                                                                           |
| area-TypeSystem-coreclr                        | @steveisok           | @davidwrighton @MichalStrehovsky @janvorli @mangod9 |                                                                                                                                                                                                                                                                                           |
| area-UWP                                       | @tommcdon            | @dotnet/area-uwp                                    | UWP-specific issues including Microsoft.NETCore.UniversalWindowsPlatform and Microsoft.Net.UWPCoreRuntimeSdk                                                                                                                                                                              |
| area-VM-coreclr                                | @mangod9             | @mangod9                                            |                                                                                                                                                                                                                                                                                           |
| area-VM-meta-mono                              | @steveisok           | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-VM-reflection-mono                        | @steveisok           | @lambdageek                                         | MonoVM-specific reflection and reflection-emit issues                                                                                                                                                                                                                                     |
| area-VM-threading-mono                         | @mangod9             | @lambdageek                                         |                                                                                                                                                                                                                                                                                           |
| area-Workloads                                 | @lewing              | @dotnet/net-sdk-workload-contributors               |                                                                                                                                                                                                                                                                                           |

## Operating Systems

`os-` labels not listed here do not have explicit ownership.

> [!NOTE]
> In this context, ownership is purely for the purposes of identifying which part of
> of our engineering team (or the community) is on the hook for fixing issues labeled
> with them. This isn't the same as supported. For example, we don't track `os-windows`
> here because the regular area owners are on the hook for fixing bugs so there is no
> dedicated OS lead/owner, rather ownership falls back to the `area-*` label. However,
> Windows is a supported operating system of course.

| Operating System | Lead          | Owners (area experts to tag in PRs and issues)     | Description     |
|------------------|---------------|----------------------------------------------------|-----------------|
| os-android       | @vitek-karas  | @akoeplinger                                       |                 |
| os-freebsd       |               | @wfurt @Thefrank @sec                              |                 |
| os-maccatalyst   | @vitek-karas  | @kotlarmilos                                       |                 |
| os-ios           | @vitek-karas  | @kotlarmilos                                       |                 |
| os-tizen         | @gbalykov     | @dotnet/samsung                                    |                 |
| os-tvos          | @vitek-karas  | @kotlarmilos                                       |                 |
| os-wasi          | @lewing       | @pavelsavara                                       |                 |
| os-browser       | @lewing       | @pavelsavara                                       |                 |

## Architectures

`arch-` labels not listed here do not have explicit ownership.

> [!NOTE]
> Ownership isn't the same as supported. See [operating systems](#operating-systems) for details.

| Architecture     | Lead          | Owners (area experts to tag in PRs and issues)     | Description     |
|------------------|---------------|----------------------------------------------------|-----------------|
| arch-loongarch64 | @shushanhf    | @LuckyXu-HF                                        |                 |
| arch-riscv       | @gbalykov     | @dotnet/samsung                                    |                 |
| arch-s390x       | @uweigand     | @uweigand                                          |                 |
| arch-wasm        | @lewing       | @lewing, @pavelsavara                              |                 |

## Community Triagers

While not necessarily associated with a specific area, these community members have the power to assist with routing and labeling issues and pull requests, and are generally knowledgeable about how the repo works:

* @am11
* @filipnavara
* @huoyaoyuan
* @SingleAccretion
* @teo-tsirpanis
* @tmds
* @vcsjones
* @Sergio0694
