-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/query_handler.ads,v $
--  Description     : Contents Handler for Queries
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/09/30 20:14:27 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;          use Ada.Strings.Unbounded;
with Contents_Handler;               use Contents_Handler;
with Contents_Manager;               use Contents_Manager;
with Project_File;                   use Project_File;

with GSQL_Types;                     use GSQL_Types;

with GUI_Editor;                     use GUI_Editor;

package Query_Handler  is

   type Object is new Contents_Handler.Object with private;
   type Handle is access all Object;

   procedure Initialize;
   procedure Finalize;

   Query_Prefix : constant String;

private
   type Object is new Contents_Handler.Object with record
         Constructor : Constructor_Access := null;
         Editor      : GUI_Editor.Object;
         Id          : Element_ID;
         Name        : Unbounded_String := Null_Unbounded_String;
      end record;

   Query_Prefix : constant String := "query";

   procedure Initialize(
      This : in out Object );

   procedure Finalize(
      This : in out Object );

   procedure Selected(
      This : in out Object );

   procedure Value(
      This : in Object;
      Text : out Text_Buffer;
      Last : out Positive );

   procedure Save(
      Item  : in out Object;
      Value : in Text_Buffer;
      Name  : in String := "" );

   procedure Load(
      Item  : in out Object;
      Value : out Text_Buffer;
      Last  : out Natural );

   procedure Open_Editor(
      This : in out Object );

   procedure Close_Editor(
      This : in out Object );

   procedure Execute(
      This : in out Object );

end Query_Handler;
