/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// FlowLogProperties struct for FlowLogProperties
type FlowLogProperties struct {
	// Specifies the traffic action pattern.
	Action *string `json:"action"`
	// The S3 bucket name of an existing IONOS Cloud S3 bucket.
	Bucket *string `json:"bucket"`
	// Specifies the traffic direction pattern.
	Direction *string `json:"direction"`
	// The resource name.
	Name *string `json:"name"`
}

// NewFlowLogProperties instantiates a new FlowLogProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewFlowLogProperties(action string, bucket string, direction string, name string) *FlowLogProperties {
	this := FlowLogProperties{}

	this.Action = &action
	this.Bucket = &bucket
	this.Direction = &direction
	this.Name = &name

	return &this
}

// NewFlowLogPropertiesWithDefaults instantiates a new FlowLogProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewFlowLogPropertiesWithDefaults() *FlowLogProperties {
	this := FlowLogProperties{}
	return &this
}

// GetAction returns the Action field value
// If the value is explicit nil, nil is returned
func (o *FlowLogProperties) GetAction() *string {
	if o == nil {
		return nil
	}

	return o.Action

}

// GetActionOk returns a tuple with the Action field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FlowLogProperties) GetActionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Action, true
}

// SetAction sets field value
func (o *FlowLogProperties) SetAction(v string) {

	o.Action = &v

}

// HasAction returns a boolean if a field has been set.
func (o *FlowLogProperties) HasAction() bool {
	if o != nil && o.Action != nil {
		return true
	}

	return false
}

// GetBucket returns the Bucket field value
// If the value is explicit nil, nil is returned
func (o *FlowLogProperties) GetBucket() *string {
	if o == nil {
		return nil
	}

	return o.Bucket

}

// GetBucketOk returns a tuple with the Bucket field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FlowLogProperties) GetBucketOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Bucket, true
}

// SetBucket sets field value
func (o *FlowLogProperties) SetBucket(v string) {

	o.Bucket = &v

}

// HasBucket returns a boolean if a field has been set.
func (o *FlowLogProperties) HasBucket() bool {
	if o != nil && o.Bucket != nil {
		return true
	}

	return false
}

// GetDirection returns the Direction field value
// If the value is explicit nil, nil is returned
func (o *FlowLogProperties) GetDirection() *string {
	if o == nil {
		return nil
	}

	return o.Direction

}

// GetDirectionOk returns a tuple with the Direction field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FlowLogProperties) GetDirectionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Direction, true
}

// SetDirection sets field value
func (o *FlowLogProperties) SetDirection(v string) {

	o.Direction = &v

}

// HasDirection returns a boolean if a field has been set.
func (o *FlowLogProperties) HasDirection() bool {
	if o != nil && o.Direction != nil {
		return true
	}

	return false
}

// GetName returns the Name field value
// If the value is explicit nil, nil is returned
func (o *FlowLogProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name

}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *FlowLogProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Name, true
}

// SetName sets field value
func (o *FlowLogProperties) SetName(v string) {

	o.Name = &v

}

// HasName returns a boolean if a field has been set.
func (o *FlowLogProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

func (o FlowLogProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Action != nil {
		toSerialize["action"] = o.Action
	}

	if o.Bucket != nil {
		toSerialize["bucket"] = o.Bucket
	}

	if o.Direction != nil {
		toSerialize["direction"] = o.Direction
	}

	if o.Name != nil {
		toSerialize["name"] = o.Name
	}

	return json.Marshal(toSerialize)
}

type NullableFlowLogProperties struct {
	value *FlowLogProperties
	isSet bool
}

func (v NullableFlowLogProperties) Get() *FlowLogProperties {
	return v.value
}

func (v *NullableFlowLogProperties) Set(val *FlowLogProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableFlowLogProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableFlowLogProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableFlowLogProperties(val *FlowLogProperties) *NullableFlowLogProperties {
	return &NullableFlowLogProperties{value: val, isSet: true}
}

func (v NullableFlowLogProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableFlowLogProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
