// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/maps/routes/v1/compute_routes_request.proto

package routes

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A set of values used to specify the mode of travel.
type RouteTravelMode int32

const (
	// No travel mode specified. Defaults to `DRIVE`.
	RouteTravelMode_TRAVEL_MODE_UNSPECIFIED RouteTravelMode = 0
	// Travel by passenger car.
	RouteTravelMode_DRIVE RouteTravelMode = 1
	// Travel by bicycle.
	RouteTravelMode_BICYCLE RouteTravelMode = 2
	// Travel by walking.
	RouteTravelMode_WALK RouteTravelMode = 3
	// Two-wheeled, motorized vehicle. For example, motorcycle. Note that this
	// differs from the `BICYCLE` travel mode which covers human-powered mode.
	RouteTravelMode_TWO_WHEELER RouteTravelMode = 4
)

var RouteTravelMode_name = map[int32]string{
	0: "TRAVEL_MODE_UNSPECIFIED",
	1: "DRIVE",
	2: "BICYCLE",
	3: "WALK",
	4: "TWO_WHEELER",
}

var RouteTravelMode_value = map[string]int32{
	"TRAVEL_MODE_UNSPECIFIED": 0,
	"DRIVE":                   1,
	"BICYCLE":                 2,
	"WALK":                    3,
	"TWO_WHEELER":             4,
}

func (x RouteTravelMode) String() string {
	return proto.EnumName(RouteTravelMode_name, int32(x))
}

func (RouteTravelMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_685d13ea1bb3dd8f, []int{0}
}

// A set of values that specify factors to take into consideration when
// calculating the route.
type RoutingPreference int32

const (
	// No routing preference specified. Default to `TRAFFIC_AWARE`.
	RoutingPreference_ROUTING_PREFERENCE_UNSPECIFIED RoutingPreference = 0
	// Computes routes without taking traffic conditions into consideration.
	// Suitable when traffic conditions don't matter. Using this value produces
	// the lowest latency.
	RoutingPreference_TRAFFIC_UNAWARE RoutingPreference = 1
	// Calculates routes taking traffic conditions into consideration. In contrast
	// to `TRAFFIC_AWARE_OPTIMAL`, some optimizations are applied to significantly
	// reduce latency.
	RoutingPreference_TRAFFIC_AWARE RoutingPreference = 2
	// Calculates the routes taking traffic conditions into consideration,
	// without applying most performance optimizations. Using this value produces
	// the highest latency.
	RoutingPreference_TRAFFIC_AWARE_OPTIMAL RoutingPreference = 3
)

var RoutingPreference_name = map[int32]string{
	0: "ROUTING_PREFERENCE_UNSPECIFIED",
	1: "TRAFFIC_UNAWARE",
	2: "TRAFFIC_AWARE",
	3: "TRAFFIC_AWARE_OPTIMAL",
}

var RoutingPreference_value = map[string]int32{
	"ROUTING_PREFERENCE_UNSPECIFIED": 0,
	"TRAFFIC_UNAWARE":                1,
	"TRAFFIC_AWARE":                  2,
	"TRAFFIC_AWARE_OPTIMAL":          3,
}

func (x RoutingPreference) String() string {
	return proto.EnumName(RoutingPreference_name, int32(x))
}

func (RoutingPreference) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_685d13ea1bb3dd8f, []int{1}
}

// A set of values that specify the unit of measure used in the display.
type Units int32

const (
	// Units of measure not specified. Defaults to the unit of measure inferred
	// from the request.
	Units_UNITS_UNSPECIFIED Units = 0
	// Metric units of measure.
	Units_METRIC Units = 1
	// Imperial (English) units of measure.
	Units_IMPERIAL Units = 2
)

var Units_name = map[int32]string{
	0: "UNITS_UNSPECIFIED",
	1: "METRIC",
	2: "IMPERIAL",
}

var Units_value = map[string]int32{
	"UNITS_UNSPECIFIED": 0,
	"METRIC":            1,
	"IMPERIAL":          2,
}

func (x Units) String() string {
	return proto.EnumName(Units_name, int32(x))
}

func (Units) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_685d13ea1bb3dd8f, []int{2}
}

// ComputeRoutes request message.
type ComputeRoutesRequest struct {
	// Required. Origin waypoint.
	Origin *Waypoint `protobuf:"bytes,1,opt,name=origin,proto3" json:"origin,omitempty"`
	// Required. Destination waypoint.
	Destination *Waypoint `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. A set of waypoints along the route (excluding terminal points),
	// for either stopping at or passing by.
	Intermediates []*Waypoint `protobuf:"bytes,3,rep,name=intermediates,proto3" json:"intermediates,omitempty"`
	// Optional. Specifies the mode of transportation.
	TravelMode RouteTravelMode `protobuf:"varint,4,opt,name=travel_mode,json=travelMode,proto3,enum=google.maps.routes.v1.RouteTravelMode" json:"travel_mode,omitempty"`
	// Optional. Specifies how to compute the route. The server
	// attempts to use the selected routing preference to compute the route. If
	//  the routing preference results in an error or an extra long latency, then
	// an error is returned. In the future, we might implement a fallback
	// mechanism to use a different option when the preferred option does not give
	// a valid result. You can specify this option only when the `travel_mode` is
	// `DRIVE` or `TWO_WHEELER`, otherwise the request fails.
	RoutingPreference RoutingPreference `protobuf:"varint,5,opt,name=routing_preference,json=routingPreference,proto3,enum=google.maps.routes.v1.RoutingPreference" json:"routing_preference,omitempty"`
	// Optional. Specifies your preference for the quality of the polyline.
	PolylineQuality PolylineQuality `protobuf:"varint,6,opt,name=polyline_quality,json=polylineQuality,proto3,enum=google.maps.routes.v1.PolylineQuality" json:"polyline_quality,omitempty"`
	// Optional. The departure time. If you don't set this value, then this value
	// defaults to the time that you made the request. If you set this value to a
	// time that has already occurred, then the request fails.
	DepartureTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=departure_time,json=departureTime,proto3" json:"departure_time,omitempty"`
	// Specifies whether to calculate alternate routes in addition to the route.
	ComputeAlternativeRoutes bool `protobuf:"varint,8,opt,name=compute_alternative_routes,json=computeAlternativeRoutes,proto3" json:"compute_alternative_routes,omitempty"`
	// Optional. A set of conditions to satisfy that affect the way routes are
	// calculated.
	RouteModifiers *RouteModifiers `protobuf:"bytes,9,opt,name=route_modifiers,json=routeModifiers,proto3" json:"route_modifiers,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
	// [Language Support](https://developers.google.com/maps/faq#languagesupport)
	// for the list of supported languages. When you don't provide this value, the
	// display language is inferred from the location of the route request.
	LanguageCode string `protobuf:"bytes,10,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Specifies the units of measure for the display fields. This
	// includes the `instruction` field in `NavigationInstruction`. The units of
	// measure used for the route, leg, step distance, and duration are not
	// affected by this value. If you don't provide this value, then the display
	// units are inferred from the location of the request.
	Units                Units    `protobuf:"varint,11,opt,name=units,proto3,enum=google.maps.routes.v1.Units" json:"units,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ComputeRoutesRequest) Reset()         { *m = ComputeRoutesRequest{} }
func (m *ComputeRoutesRequest) String() string { return proto.CompactTextString(m) }
func (*ComputeRoutesRequest) ProtoMessage()    {}
func (*ComputeRoutesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_685d13ea1bb3dd8f, []int{0}
}

func (m *ComputeRoutesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeRoutesRequest.Unmarshal(m, b)
}
func (m *ComputeRoutesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeRoutesRequest.Marshal(b, m, deterministic)
}
func (m *ComputeRoutesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeRoutesRequest.Merge(m, src)
}
func (m *ComputeRoutesRequest) XXX_Size() int {
	return xxx_messageInfo_ComputeRoutesRequest.Size(m)
}
func (m *ComputeRoutesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeRoutesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeRoutesRequest proto.InternalMessageInfo

func (m *ComputeRoutesRequest) GetOrigin() *Waypoint {
	if m != nil {
		return m.Origin
	}
	return nil
}

func (m *ComputeRoutesRequest) GetDestination() *Waypoint {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *ComputeRoutesRequest) GetIntermediates() []*Waypoint {
	if m != nil {
		return m.Intermediates
	}
	return nil
}

func (m *ComputeRoutesRequest) GetTravelMode() RouteTravelMode {
	if m != nil {
		return m.TravelMode
	}
	return RouteTravelMode_TRAVEL_MODE_UNSPECIFIED
}

func (m *ComputeRoutesRequest) GetRoutingPreference() RoutingPreference {
	if m != nil {
		return m.RoutingPreference
	}
	return RoutingPreference_ROUTING_PREFERENCE_UNSPECIFIED
}

func (m *ComputeRoutesRequest) GetPolylineQuality() PolylineQuality {
	if m != nil {
		return m.PolylineQuality
	}
	return PolylineQuality_POLYLINE_QUALITY_UNSPECIFIED
}

func (m *ComputeRoutesRequest) GetDepartureTime() *timestamp.Timestamp {
	if m != nil {
		return m.DepartureTime
	}
	return nil
}

func (m *ComputeRoutesRequest) GetComputeAlternativeRoutes() bool {
	if m != nil {
		return m.ComputeAlternativeRoutes
	}
	return false
}

func (m *ComputeRoutesRequest) GetRouteModifiers() *RouteModifiers {
	if m != nil {
		return m.RouteModifiers
	}
	return nil
}

func (m *ComputeRoutesRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *ComputeRoutesRequest) GetUnits() Units {
	if m != nil {
		return m.Units
	}
	return Units_UNITS_UNSPECIFIED
}

// Encapsulates a set of optional conditions to satisfy when calculating the
// routes.
type RouteModifiers struct {
	// Specifies whether to avoid toll roads. Applies only to the `DRIVE` and
	// `TWO_WHEELER` travel modes.
	AvoidTolls bool `protobuf:"varint,1,opt,name=avoid_tolls,json=avoidTolls,proto3" json:"avoid_tolls,omitempty"`
	// Specifies whether to avoid highways. Applies only to the `DRIVE` and
	// `TWO_WHEELER` travel modes.
	AvoidHighways bool `protobuf:"varint,2,opt,name=avoid_highways,json=avoidHighways,proto3" json:"avoid_highways,omitempty"`
	// Specifies whether to avoid ferries. Applies only to the `DRIVE` and
	// `TWO_WHEELER` travel modes.
	AvoidFerries bool `protobuf:"varint,3,opt,name=avoid_ferries,json=avoidFerries,proto3" json:"avoid_ferries,omitempty"`
	// Specifies whether to avoid navigating indoors. Applies only to the `WALK`
	// travel mode.
	AvoidIndoor bool `protobuf:"varint,4,opt,name=avoid_indoor,json=avoidIndoor,proto3" json:"avoid_indoor,omitempty"`
	// Optional. Specifies the vehicle information.
	VehicleInfo *VehicleInfo `protobuf:"bytes,5,opt,name=vehicle_info,json=vehicleInfo,proto3" json:"vehicle_info,omitempty"`
	// Encapsulates information about toll passes.
	// TollPass is unset means no available pass.
	// Applies only to the DRIVE and TWO_WHEELER travel modes.
	TollPasses           []TollPass `protobuf:"varint,6,rep,packed,name=toll_passes,json=tollPasses,proto3,enum=google.maps.routes.v1.TollPass" json:"toll_passes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *RouteModifiers) Reset()         { *m = RouteModifiers{} }
func (m *RouteModifiers) String() string { return proto.CompactTextString(m) }
func (*RouteModifiers) ProtoMessage()    {}
func (*RouteModifiers) Descriptor() ([]byte, []int) {
	return fileDescriptor_685d13ea1bb3dd8f, []int{1}
}

func (m *RouteModifiers) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RouteModifiers.Unmarshal(m, b)
}
func (m *RouteModifiers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RouteModifiers.Marshal(b, m, deterministic)
}
func (m *RouteModifiers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteModifiers.Merge(m, src)
}
func (m *RouteModifiers) XXX_Size() int {
	return xxx_messageInfo_RouteModifiers.Size(m)
}
func (m *RouteModifiers) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteModifiers.DiscardUnknown(m)
}

var xxx_messageInfo_RouteModifiers proto.InternalMessageInfo

func (m *RouteModifiers) GetAvoidTolls() bool {
	if m != nil {
		return m.AvoidTolls
	}
	return false
}

func (m *RouteModifiers) GetAvoidHighways() bool {
	if m != nil {
		return m.AvoidHighways
	}
	return false
}

func (m *RouteModifiers) GetAvoidFerries() bool {
	if m != nil {
		return m.AvoidFerries
	}
	return false
}

func (m *RouteModifiers) GetAvoidIndoor() bool {
	if m != nil {
		return m.AvoidIndoor
	}
	return false
}

func (m *RouteModifiers) GetVehicleInfo() *VehicleInfo {
	if m != nil {
		return m.VehicleInfo
	}
	return nil
}

func (m *RouteModifiers) GetTollPasses() []TollPass {
	if m != nil {
		return m.TollPasses
	}
	return nil
}

// Encapsulates the vehicle information, such as the license plate last
// character.
type VehicleInfo struct {
	// Specifies the license plate last character. Could be a digit or a letter.
	LicensePlateLastCharacter string `protobuf:"bytes,1,opt,name=license_plate_last_character,json=licensePlateLastCharacter,proto3" json:"license_plate_last_character,omitempty"`
	// Describes the vehicle's emission type.
	// Applies only to the DRIVE travel mode.
	EmissionType         VehicleEmissionType `protobuf:"varint,2,opt,name=emission_type,json=emissionType,proto3,enum=google.maps.routes.v1.VehicleEmissionType" json:"emission_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *VehicleInfo) Reset()         { *m = VehicleInfo{} }
func (m *VehicleInfo) String() string { return proto.CompactTextString(m) }
func (*VehicleInfo) ProtoMessage()    {}
func (*VehicleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_685d13ea1bb3dd8f, []int{2}
}

func (m *VehicleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VehicleInfo.Unmarshal(m, b)
}
func (m *VehicleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VehicleInfo.Marshal(b, m, deterministic)
}
func (m *VehicleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VehicleInfo.Merge(m, src)
}
func (m *VehicleInfo) XXX_Size() int {
	return xxx_messageInfo_VehicleInfo.Size(m)
}
func (m *VehicleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VehicleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VehicleInfo proto.InternalMessageInfo

func (m *VehicleInfo) GetLicensePlateLastCharacter() string {
	if m != nil {
		return m.LicensePlateLastCharacter
	}
	return ""
}

func (m *VehicleInfo) GetEmissionType() VehicleEmissionType {
	if m != nil {
		return m.EmissionType
	}
	return VehicleEmissionType_VEHICLE_EMISSION_TYPE_UNSPECIFIED
}

func init() {
	proto.RegisterEnum("google.maps.routes.v1.RouteTravelMode", RouteTravelMode_name, RouteTravelMode_value)
	proto.RegisterEnum("google.maps.routes.v1.RoutingPreference", RoutingPreference_name, RoutingPreference_value)
	proto.RegisterEnum("google.maps.routes.v1.Units", Units_name, Units_value)
	proto.RegisterType((*ComputeRoutesRequest)(nil), "google.maps.routes.v1.ComputeRoutesRequest")
	proto.RegisterType((*RouteModifiers)(nil), "google.maps.routes.v1.RouteModifiers")
	proto.RegisterType((*VehicleInfo)(nil), "google.maps.routes.v1.VehicleInfo")
}

func init() {
	proto.RegisterFile("google/maps/routes/v1/compute_routes_request.proto", fileDescriptor_685d13ea1bb3dd8f)
}

var fileDescriptor_685d13ea1bb3dd8f = []byte{
	// 947 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x95, 0x5d, 0x6f, 0xe2, 0x46,
	0x17, 0xc7, 0x1f, 0x93, 0x97, 0x25, 0xc7, 0x81, 0x90, 0x79, 0x1a, 0xd5, 0x49, 0x57, 0x0d, 0x4d,
	0xbb, 0x2d, 0xca, 0x05, 0x28, 0xf4, 0xa2, 0x95, 0xb6, 0x52, 0x4b, 0x88, 0x93, 0xb5, 0x0a, 0x84,
	0x9d, 0x38, 0x41, 0xad, 0x22, 0x8d, 0x66, 0x61, 0x70, 0x46, 0x32, 0x1e, 0xaf, 0x67, 0x60, 0x45,
	0xbf, 0x4c, 0xa5, 0xde, 0xb5, 0x37, 0xfd, 0x1e, 0xfd, 0x44, 0x7b, 0x59, 0x79, 0xc6, 0xce, 0x86,
	0x14, 0xa2, 0xbd, 0xf3, 0xfc, 0xf9, 0x9d, 0x97, 0x39, 0x73, 0xce, 0x01, 0x9a, 0x81, 0x10, 0x41,
	0xc8, 0x1a, 0x13, 0x1a, 0xcb, 0x46, 0x22, 0xa6, 0x8a, 0xc9, 0xc6, 0xec, 0xa4, 0x31, 0x14, 0x93,
	0x78, 0xaa, 0x18, 0x31, 0x0a, 0x49, 0xd8, 0xdb, 0x29, 0x93, 0xaa, 0x1e, 0x27, 0x42, 0x09, 0xb4,
	0x67, 0x6c, 0xea, 0xa9, 0x4d, 0xdd, 0x10, 0xf5, 0xd9, 0xc9, 0xc1, 0x57, 0xcb, 0x5d, 0xc5, 0x22,
	0x9c, 0x87, 0x3c, 0x62, 0xc6, 0xf8, 0xe0, 0x9b, 0xe5, 0x94, 0x12, 0x61, 0x48, 0x62, 0x2a, 0x25,
	0x93, 0x19, 0x78, 0xb2, 0x1c, 0x9c, 0xb1, 0x3b, 0x3e, 0x0c, 0x19, 0x61, 0x13, 0x2e, 0x25, 0x17,
	0x11, 0x51, 0xf3, 0x38, 0xf7, 0xbd, 0x22, 0x83, 0x77, 0x74, 0x1e, 0x0b, 0x1e, 0x65, 0xe9, 0x1f,
	0x1c, 0x66, 0x94, 0x3e, 0xbd, 0x99, 0x8e, 0x1b, 0x8a, 0x4f, 0x98, 0x54, 0x74, 0x12, 0x1b, 0xe0,
	0xe8, 0xfd, 0x06, 0x7c, 0xd2, 0x36, 0x05, 0xc0, 0xda, 0x09, 0x36, 0xd7, 0x47, 0xdf, 0xc1, 0xa6,
	0x48, 0x78, 0xc0, 0x23, 0xc7, 0xaa, 0x5a, 0x35, 0xbb, 0x79, 0x58, 0x5f, 0x5a, 0x89, 0xfa, 0x20,
	0x0b, 0x88, 0x33, 0x1c, 0xb5, 0xc0, 0x1e, 0x31, 0xa9, 0x78, 0x44, 0x15, 0x17, 0x91, 0x53, 0xf8,
	0x38, 0xeb, 0x87, 0x36, 0xc8, 0x85, 0x12, 0x8f, 0x14, 0x4b, 0x26, 0x6c, 0xc4, 0xa9, 0x62, 0xd2,
	0x59, 0xab, 0xae, 0x7d, 0x8c, 0x93, 0x45, 0x2b, 0x74, 0x01, 0xb6, 0x4a, 0xe8, 0x8c, 0x85, 0x64,
	0x22, 0x46, 0xcc, 0x59, 0xaf, 0x5a, 0xb5, 0x72, 0xf3, 0xeb, 0x15, 0x4e, 0xf4, 0xed, 0x7d, 0x8d,
	0x77, 0xc5, 0x88, 0x61, 0x50, 0xf7, 0xdf, 0x68, 0x00, 0x28, 0x05, 0x79, 0x14, 0x90, 0x38, 0x61,
	0x63, 0x96, 0xb0, 0x68, 0xc8, 0x9c, 0x0d, 0xed, 0xaf, 0xf6, 0x84, 0x3f, 0x1e, 0x05, 0xfd, 0x7b,
	0x1e, 0xef, 0x26, 0x8f, 0x25, 0xf4, 0x1a, 0x2a, 0x79, 0xcb, 0x90, 0xb7, 0x53, 0x1a, 0x72, 0x35,
	0x77, 0x36, 0x9f, 0x4c, 0xb3, 0x9f, 0xe1, 0xaf, 0x0d, 0x8d, 0x77, 0xe2, 0x45, 0x01, 0xb5, 0xa0,
	0x3c, 0x62, 0x31, 0x4d, 0xd4, 0x34, 0x61, 0x24, 0x7d, 0x6d, 0xe7, 0x99, 0x7e, 0x81, 0x83, 0xdc,
	0x61, 0xde, 0x0a, 0x75, 0x3f, 0x6f, 0x05, 0x5c, 0xba, 0xb7, 0x48, 0x35, 0xf4, 0x03, 0x1c, 0xe4,
	0x33, 0x41, 0x43, 0xc5, 0x92, 0xf4, 0x55, 0x66, 0xf9, 0x7c, 0x38, 0xc5, 0xaa, 0x55, 0x2b, 0x62,
	0x27, 0x23, 0x5a, 0x1f, 0x00, 0xd3, 0x3f, 0xa8, 0x07, 0x3b, 0x9a, 0x4c, 0x8b, 0xce, 0xc7, 0x9c,
	0x25, 0xd2, 0xd9, 0xd2, 0x19, 0xbc, 0x78, 0xaa, 0xf2, 0xdd, 0x1c, 0xc6, 0xe5, 0x64, 0xe1, 0x8c,
	0xbe, 0x84, 0x52, 0x48, 0xa3, 0x60, 0x4a, 0x03, 0x46, 0x86, 0xe9, 0x3b, 0x42, 0xd5, 0xaa, 0x6d,
	0xe1, 0xed, 0x5c, 0x6c, 0xa7, 0x2f, 0xd4, 0x84, 0x8d, 0x69, 0xc4, 0x95, 0x74, 0x6c, 0x5d, 0xbd,
	0xe7, 0x2b, 0x42, 0x5d, 0xa7, 0x0c, 0x36, 0xe8, 0xd1, 0x9f, 0x05, 0x28, 0x2f, 0xc6, 0x46, 0x87,
	0x60, 0xd3, 0x99, 0xe0, 0x23, 0x92, 0x8e, 0xa8, 0xd4, 0x9d, 0x5f, 0xc4, 0xa0, 0x25, 0x3f, 0x55,
	0xd0, 0x0b, 0x28, 0x1b, 0xe0, 0x8e, 0x07, 0x77, 0xef, 0xe8, 0x5c, 0xea, 0xfe, 0x2e, 0xe2, 0x92,
	0x56, 0x5f, 0x65, 0x62, 0x9a, 0xb3, 0xc1, 0xc6, 0x2c, 0x49, 0xb8, 0x6e, 0xe0, 0x94, 0xda, 0xd6,
	0xe2, 0xb9, 0xd1, 0xd0, 0x17, 0x60, 0xce, 0x84, 0x47, 0x23, 0x21, 0x12, 0xdd, 0x9f, 0x45, 0x6c,
	0x12, 0xf0, 0xb4, 0x84, 0x5c, 0xd8, 0xce, 0x77, 0x00, 0x8f, 0xc6, 0x42, 0xb7, 0x9c, 0xdd, 0x3c,
	0x5a, 0x71, 0xbb, 0x1b, 0x83, 0x7a, 0xd1, 0x58, 0x60, 0x7b, 0xf6, 0xe1, 0x80, 0x7e, 0x02, 0xfb,
	0xc1, 0xce, 0x71, 0x36, 0xab, 0x6b, 0xb5, 0xf2, 0xca, 0x69, 0x4a, 0x2f, 0xda, 0xa7, 0x52, 0x62,
	0x50, 0xd9, 0x17, 0x93, 0x47, 0xbf, 0x5b, 0x60, 0x3f, 0x70, 0x8f, 0x7e, 0x84, 0xe7, 0x21, 0x1f,
	0xb2, 0x48, 0x32, 0x12, 0x87, 0x54, 0x31, 0x12, 0x52, 0xa9, 0xc8, 0xf0, 0x8e, 0x26, 0x74, 0xa8,
	0x58, 0xa2, 0x2b, 0xb7, 0x85, 0xf7, 0x33, 0xa6, 0x9f, 0x22, 0x1d, 0x2a, 0x55, 0x3b, 0x07, 0xd0,
	0x25, 0x94, 0x16, 0xb6, 0x9a, 0xae, 0x63, 0xb9, 0x79, 0xfc, 0xf4, 0xd5, 0xdc, 0xcc, 0xc4, 0x9f,
	0xc7, 0x0c, 0x6f, 0xb3, 0x07, 0xa7, 0x63, 0x0a, 0x3b, 0x8f, 0x46, 0x18, 0x7d, 0x06, 0x9f, 0xfa,
	0xb8, 0x75, 0xe3, 0x76, 0x48, 0xf7, 0xf2, 0xcc, 0x25, 0xd7, 0xbd, 0xab, 0xbe, 0xdb, 0xf6, 0xce,
	0x3d, 0xf7, 0xac, 0xf2, 0x3f, 0xb4, 0x05, 0x1b, 0x67, 0xd8, 0xbb, 0x71, 0x2b, 0x16, 0xb2, 0xe1,
	0xd9, 0xa9, 0xd7, 0xfe, 0xa5, 0xdd, 0x71, 0x2b, 0x05, 0x54, 0x84, 0xf5, 0x41, 0xab, 0xf3, 0x73,
	0x65, 0x0d, 0xed, 0x80, 0xed, 0x0f, 0x2e, 0xc9, 0xe0, 0x95, 0xeb, 0x76, 0x5c, 0x5c, 0x59, 0x3f,
	0xfe, 0x0d, 0x76, 0xff, 0x33, 0xd5, 0xe8, 0x08, 0x3e, 0xc7, 0x97, 0xd7, 0xbe, 0xd7, 0xbb, 0x20,
	0x7d, 0xec, 0x9e, 0xbb, 0xd8, 0xed, 0xb5, 0x1f, 0xc7, 0xfa, 0x3f, 0xec, 0xf8, 0xb8, 0x75, 0x7e,
	0xee, 0xb5, 0xc9, 0x75, 0xaf, 0x35, 0x68, 0xe1, 0x34, 0xea, 0x2e, 0x94, 0x72, 0xd1, 0x48, 0x05,
	0xb4, 0x0f, 0x7b, 0x0b, 0x12, 0xb9, 0xec, 0xfb, 0x5e, 0xb7, 0xd5, 0xa9, 0xac, 0x1d, 0x7f, 0x0f,
	0x1b, 0xba, 0x79, 0xd1, 0x1e, 0xec, 0x5e, 0xf7, 0x3c, 0xff, 0xea, 0x51, 0x08, 0x80, 0xcd, 0xae,
	0xeb, 0x63, 0xaf, 0x5d, 0xb1, 0xd0, 0x36, 0x14, 0xbd, 0x6e, 0xdf, 0xc5, 0x5e, 0xab, 0x53, 0x29,
	0x9c, 0xfe, 0x6d, 0xc1, 0xfe, 0x50, 0x4c, 0x96, 0x17, 0xf6, 0x74, 0x7f, 0xd9, 0xf2, 0xef, 0xa7,
	0x2b, 0xa2, 0x6f, 0xfd, 0xfa, 0x32, 0xb3, 0x09, 0x44, 0x3a, 0x6c, 0x75, 0x91, 0x04, 0x8d, 0x80,
	0x45, 0x7a, 0x81, 0x34, 0xcc, 0x4f, 0x34, 0xe6, 0xf2, 0xd1, 0x5f, 0xd0, 0x4b, 0xf3, 0xf5, 0xde,
	0xb2, 0xfe, 0x28, 0xac, 0x5f, 0x74, 0xf1, 0xd5, 0x5f, 0x85, 0xbd, 0x0b, 0xe3, 0xa7, 0x9b, 0xc6,
	0x36, 0x91, 0xea, 0x37, 0x27, 0xff, 0xe4, 0xfa, 0x6d, 0xaa, 0xdf, 0x1a, 0xfd, 0xf6, 0xe6, 0xe4,
	0xcd, 0xa6, 0x8e, 0xf0, 0xed, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x7b, 0x8c, 0x82, 0x0a, 0xb0,
	0x07, 0x00, 0x00,
}
