/*
   Copyright 2014-now by Alain Stalder. Made in Switzerland.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       https://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package ch.artecat.grengine.sources;



/**
 * Mode for parsing directories for files.
 * 
 * @since 1.0
 * 
 * @author Alain Stalder
 * @author Made in Switzerland.
 */
public enum DirMode {
    
    /**
     * parse only just the given directory, but none of its subdirectories.
     * 
     * @since 1.0
     */
    NO_SUBDIRS,
    
    /**
     * parse the given directory, plus recursively all of its subdirectories.
     * 
     * @since 1.0
     */
    WITH_SUBDIRS_RECURSIVE

}