/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultRemoteCommand;
import com.thoughtworks.selenium.SeleniumException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;

public class HttpCommandProcessor
implements CommandProcessor {
    private String pathToServlet;
    private String browserStartCommand;
    private String browserURL;
    private String sessionId;

    public HttpCommandProcessor(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        this.pathToServlet = "http://" + serverHost + ":" + Integer.toString(serverPort) + "/selenium-server/driver/";
        this.browserStartCommand = browserStartCommand;
        this.browserURL = browserURL;
    }

    public HttpCommandProcessor(String pathToServlet, String browserStartCommand, String browserURL) {
        this.pathToServlet = pathToServlet;
        this.browserStartCommand = browserStartCommand;
        this.browserURL = browserURL;
    }

    public String doCommand(String commandName, String[] args) {
        DefaultRemoteCommand command = new DefaultRemoteCommand(commandName, args);
        String result = this.executeCommandOnServlet(command.getCommandURLString());
        if (result == null) {
            throw new NullPointerException("Selenium Bug! result must not be null");
        }
        if (!result.startsWith("OK")) {
            throw new SeleniumException(result);
        }
        return result;
    }

    public String executeCommandOnServlet(String command) {
        InputStream is = null;
        try {
            is = this.getCommandResponse(command, is);
            String string = this.stringContentsOfInputStream(is);
            return string;
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Catch body broken: IOException from " + command + " -> " + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String stringContentsOfInputStream(InputStream is) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        while ((c = r.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private InputStream getCommandResponse(String command, InputStream is) throws IOException {
        int responsecode = 301;
        while (responsecode == 301) {
            URL result = new URL(this.pathToServlet);
            String body = this.buildCommandBody(command);
            HttpURLConnection uc = (HttpURLConnection)result.openConnection();
            uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            uc.setInstanceFollowRedirects(false);
            uc.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(uc.getOutputStream());
            wr.write(body);
            wr.flush();
            wr.close();
            responsecode = uc.getResponseCode();
            if (responsecode == 301) {
                this.pathToServlet = uc.getRequestProperty("Location");
                continue;
            }
            if (responsecode != 200) {
                throw new SeleniumException(uc.getResponseMessage());
            }
            is = uc.getInputStream();
        }
        return is;
    }

    private String buildCommandBody(String command) throws MalformedURLException {
        StringBuffer sb = new StringBuffer();
        sb.append(command);
        if (this.sessionId != null) {
            sb.append("&sessionId=");
            sb.append(DefaultRemoteCommand.urlEncode(this.sessionId));
        }
        return sb.toString();
    }

    public void start() {
        String result;
        this.sessionId = result = this.getString("getNewBrowserSession", new String[]{this.browserStartCommand, this.browserURL});
    }

    public void stop() {
        this.doCommand("testComplete", null);
        this.sessionId = null;
    }

    public String getString(String commandName, String[] args) {
        String result = this.doCommand(commandName, args);
        if (result.length() >= "OK,".length()) {
            return result.substring("OK,".length());
        }
        System.err.println("WARNING: getString(" + commandName + ") saw a bad result " + result);
        return "";
    }

    public String[] getStringArray(String commandName, String[] args) {
        String result = this.getString(commandName, args);
        return HttpCommandProcessor.parseCSV(result);
    }

    public static String[] parseCSV(String input) {
        ArrayList<String> output = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case ',': {
                    output.add(sb.toString());
                    sb = new StringBuffer();
                    continue block4;
                }
                case '\\': {
                    c = input.charAt(++i);
                }
                default: {
                    sb.append(c);
                }
            }
        }
        output.add(sb.toString());
        return output.toArray(new String[0]);
    }

    public Number getNumber(String commandName, String[] args) {
        Number n;
        String result = this.getString(commandName, args);
        try {
            n = NumberFormat.getInstance().parse(result);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (n instanceof Long && (long)n.intValue() == n.longValue()) {
            return new Integer(n.intValue());
        }
        return n;
    }

    public Number[] getNumberArray(String commandName, String[] args) {
        String[] result = this.getStringArray(commandName, args);
        Number[] n = new Number[result.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                n[i] = NumberFormat.getInstance().parse(result[i]);
                continue;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return n;
    }

    public boolean getBoolean(String commandName, String[] args) {
        String result = this.getString(commandName, args);
        if ("true".equals(result)) {
            boolean b = true;
            return b;
        }
        if ("false".equals(result)) {
            boolean b = false;
            return b;
        }
        throw new RuntimeException("result was neither 'true' nor 'false': " + result);
    }

    public boolean[] getBooleanArray(String commandName, String[] args) {
        String[] result = this.getStringArray(commandName, args);
        boolean[] b = new boolean[result.length];
        for (int i = 0; i < result.length; ++i) {
            if ("true".equals(result)) {
                b[i] = true;
                continue;
            }
            if ("false".equals(result)) {
                b[i] = false;
                continue;
            }
            throw new RuntimeException("result was neither 'true' nor 'false': " + result);
        }
        return b;
    }
}

