<?xml version='1.0'?>
<!--
 * $Id: db_berkeley.xsl 3142 2007-11-15 14:09:15Z henningw $
 *
 * XSL converter script for generating module parameter documentation.
 *
 * Copyright (C) 2008 Henning Westerholt
 *
 * This file is part of Kamailio, a free SIP server.
 *
 * Kamailio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * Kamailio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
-->


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>

	<xsl:import href="common.xsl"/>
    <!-- Create the file for the tables in module subdirectory -->
	<xsl:template match="/">
		<xsl:variable name="createfile" select="concat($dir, concat('/', concat($prefix, '_db.xml')))"/>
		<xsl:document href="{$createfile}" method="xml" indent="yes" omit-xml-declaration="yes">

<xsl:comment xml:space="preserve">
WARNING:
This file was autogenerated from the XML source file
<xsl:value-of select="concat($dir, 'kamailio-', $prefix, '.xml.')"/>
It can be regenerated by running 'make dbdoc' in the db/schema
directory of the source code. You need to have xsltproc and
docbook-xsl stylesheets installed.
ALL CHANGES DONE HERE WILL BE LOST IF THE FILE IS REGENERATED&#x0A;</xsl:comment>

<xsl:text>&#x0A;</xsl:text>

			<chapter>
			<title>Module parameter for database access.</title>

			<section>
			<title><varname>db_url</varname> (String)</title>
			<para>URL to the database containing the data.</para>
			<para>
				<!-- TODO use ro or rw URL depending on the module -->
				<emphasis>Default value is <quote>mysql://openserro:openserro@localhost/openser</quote>.</emphasis>
			</para>
			<example>
				<title>Set <varname>db_url</varname> parameter</title>
				<programlisting format="linespecific">
					<xsl:value-of select="concat('&#x0A;...&#x0A;modparam(&quot;', $prefix, '&quot;, &quot;db_url&quot;, &quot;dbdriver://username:password@dbhost/dbname&quot;)&#x0A;...&#x0A;')"/>
				</programlisting>
			</example>
			</section>

			<xsl:apply-templates select="/database[1]"/>
			</chapter>
		</xsl:document>

	</xsl:template>


	<!-- create table name parameter -->
	<xsl:template match="table">
	<xsl:variable name="name">
		<xsl:call-template name="get-name"/>
	</xsl:variable>
	<section>
		<title><varname><xsl:value-of select="concat($name, '_table')"/></varname> (String)</title>
		<para><xsl:value-of select="concat('Name of the ', $name, ' table for the ', $prefix, ' module.')"/></para>
		<para>
			<emphasis>Default value is <quote><xsl:value-of select="$name"/></quote>.</emphasis>
		</para>
		<example>
			<title>Set <varname><xsl:value-of select="concat($name, '_table')"/></varname> parameter</title>
			<programlisting format="linespecific">
				<xsl:value-of select="concat('&#x0A;...&#x0A;modparam(&quot;', $prefix, '&quot;, &quot;', $name, '_table&quot;, &quot;', $name, '&quot;)&#x0A;...&#x0A;')"/>
			</programlisting>
		</example>
	</section>
	<xsl:apply-imports/>
	</xsl:template>

	<!-- Create column parameter -->
	<xsl:template match="column">
	<xsl:variable name="table.name">
		<xsl:call-template name="get-name">
		<xsl:with-param name="select" select="parent::table"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="column.name">
		<xsl:call-template name="get-name"/>
	</xsl:variable>
	<section>
		<title><varname><xsl:value-of select="concat($table.name, '_', $column.name, '_col')"/></varname> (string)</title>
		<para><xsl:value-of select="description"/></para>
		<example>
			<title>Set <varname><xsl:value-of select="concat($table.name, '_', $column.name, '_col')"/></varname> parameter</title>
			<programlisting format="linespecific">
				<xsl:value-of select="concat('&#x0A;...&#x0A;modparam(&quot;', $prefix, '&quot;, &quot;', $table.name, '_', $column.name, '_col&quot;, &quot;', $column.name, '&quot;)&#x0A;...&#x0A;')"/>
			</programlisting>
		</example>
	</section>
	</xsl:template>

</xsl:stylesheet>
