/*
 *  Copyright 1994-2014 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <arpa/inet.h>
#include "context.h"
#include "pnglite.h"
#include "erlang.h"

/*
 * Protocol v5:
 * [ image data ] (PNG)   X bytes
 *
 */

static u_long png_size;
static GByteArray *png_bin = NULL;


static unsigned
png_write_callback(void* input, size_t size, size_t numel, __attribute__ ((unused)) void *user_pointer)
{
  g_byte_array_append(png_bin, input, (size*numel));
  png_size += size*numel;

  return numel;
}


void
v5(const Context_t *ctx)
{
  uint32_t proto = 5, proto2;
  uint32_t total, total2;
  u_char *data;
  int res;
  png_t png;

  /* get picture */
  data = export_RGB_active_buffer(ctx, 1);

  /* prepare PNG binary */
  png_bin = g_byte_array_new();

  /* translate image to PNG using custom write callback */
  res = png_open_write(&png, png_write_callback, NULL);
  if (PNG_NO_ERROR == res) {
    png_size = 0;
    res = png_set_data(&png, WIDTH, HEIGHT, 8, PNG_TRUECOLOR, data);
    if (PNG_NO_ERROR != res)
      xerror("png_set_data: %s\n", png_error_string(res));
  } else
    xerror("png_open_write: %s\n", png_error_string(res));
  xfree(data);

  /* send packet size */
  total = sizeof(uint32_t)+png_size*sizeof(u_char);
  total2 = htonl(total);
  write_uint32(&total2);
  
  /* protocol version */
  proto2 = htonl(proto);
  write_uint32(&proto2);

  /* PNG */
  write_binary(png_bin->data, png_size*sizeof(uint8_t));
  g_byte_array_free(png_bin, TRUE);
}
