#!/usr/bin/python
import getpass, os, x2go, sys, socket, time
from weblive import WebLive

# Get a weblive object
weblive=WebLive("https://weblive.stgraber.org/weblive/json")

# List all the available servers
servers=weblive.list_servers()

if len(servers) == 0:
    print "Sorry, there's no server available at this time."
    sys.exit(0)

# Show a readable list of servers
for server in servers:
    attributes=servers[server]
    print "== %s ==" % server
    for attribute in attributes:
        print " * %s: %s" % (attribute,attributes[attribute])
    print ""

# If first parameter is "auto", then pick up the first server and connect
if len(sys.argv) > 1 and sys.argv[1] == "auto":
    serverid=servers.keys()[0]
    username="%s%s" % (os.environ['USER'],socket.gethostname())
    fullname="WebLive User"
    password=socket.gethostname()   # Yes, the hostname is the password ;)
    session='desktop';
else:
    serverid=raw_input("Server (ex. %s): " % servers.keys()[0])
    username=raw_input("Username: ")
    fullname=raw_input("Fullname: ")
    password=getpass.getpass("Password: ")
    session=raw_input("Session (ex. 'desktop' or valid executable): ")

# Create the user
locale=os.environ.get("LANG","None").replace("UTF-8","utf8")
connection=weblive.create_user(serverid,username,fullname,password,session,locale)

# Start X2GO
cli = x2go.X2goClient(start_pulseaudio=True)
uuid = cli.register_session(
    server=str(connection[0]),
    port=int(connection[1]),
    username=username,
    add_to_known_hosts=True,
    cmd="WEBLIVE",
    geometry="1024x600"
)
x2go.defaults.X2GO_DESKTOPSESSIONS['WEBLIVE']="/usr/local/bin/weblive-session %s" % session
cli.connect_session(uuid, password=password)
cli.clean_sessions(uuid)
cli.start_session(uuid)

while cli.session_ok(uuid):
    time.sleep(0.5)

cli.terminate_session(uuid)
