/*  Copyright (c) 2006-2013, the HtmlCleaner Project
    All rights reserved.

    Redistribution and use of this software in source and binary forms,
    with or without modification, are permitted provided that the following
    conditions are met:

    * Redistributions of source code must retain the above
      copyright notice, this list of conditions and the
      following disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the
      following disclaimer in the documentation and/or other
      materials provided with the distribution.

    * The name of HtmlCleaner may not be used to endorse or promote
      products derived from this software without specific prior
      written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGE.
*/
package org.htmlcleaner;

import java.io.IOException;

import org.junit.Test;

public class SVGTest extends AbstractHtmlCleanerTest{

	@Test
	public void preserveSVGtags() throws IOException{
		
        cleaner.getProperties().setOmitXmlDeclaration(false);
        cleaner.getProperties().setOmitDoctypeDeclaration(false);
        cleaner.getProperties().setOmitUnknownTags(true);
        cleaner.getProperties().setNamespacesAware(true);
        
		String initial = readFile("src/test/resources/test18.html");
		String expected = readFile("src/test/resources/test18_expected.html"); 
		
		assertCleaned(initial,expected);
	}
	
	@Test
	public void preserveSVGtags2() throws IOException{
		
        cleaner.getProperties().setOmitXmlDeclaration(false);
        cleaner.getProperties().setOmitDoctypeDeclaration(false);
        cleaner.getProperties().setOmitUnknownTags(true);
        cleaner.getProperties().setNamespacesAware(true);
        
		String initial = readFile("src/test/resources/test19.html");
		String expected = readFile("src/test/resources/test19_expected.html"); 
		assertCleaned(initial,expected);
	}

	
	@Test
	public void preserveSVGtags3() throws IOException{
		
        cleaner.getProperties().setOmitXmlDeclaration(false);
        cleaner.getProperties().setOmitDoctypeDeclaration(false);
        cleaner.getProperties().setNamespacesAware(true);
        
		String initial = readFile("src/test/resources/test20.html");
		String expected = readFile("src/test/resources/test20_expected.html"); 

		assertCleaned(initial,expected);
	}
	
	@Test
	public void preserveSVGtagsWithTitle() throws IOException{
		
        cleaner.getProperties().setOmitXmlDeclaration(false);
        cleaner.getProperties().setOmitDoctypeDeclaration(false);
        cleaner.getProperties().setNamespacesAware(true);
        cleaner.getProperties().setOmitUnknownTags(true);
        
		String initial = readFile("src/test/resources/test21.html");
		String expected = readFile("src/test/resources/test21_expected.html"); 

		assertCleaned(initial,expected);
	}
	
	@Test
	public void preserveSVGstylesInPlace() throws IOException{
		
        cleaner.getProperties().setOmitXmlDeclaration(false);
        cleaner.getProperties().setOmitDoctypeDeclaration(false);
        cleaner.getProperties().setNamespacesAware(true);
        cleaner.getProperties().setOmitUnknownTags(true);
        
		String initial = readFile("src/test/resources/test25.html");
		String expected = readFile("src/test/resources/test25_expected.html"); 

		assertCleaned(initial,expected);
	}
}
