/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef THERMO_H
#define THERMO_H

#include "Metview.h"

// Constant variable names/sizes
static const float K2C          = 273.15;
static const float MissingValue = 1.7e38;
static const string sTIME_STR   = "str_length";
static const string sTIME       = "time";
static const string sTEMP       = "t";
static const string sDEWPOINT   = "td";
static const string sPRESSURE   = "pres";
static const string sWIND       = "wind";
static const string sU          = "u";
static const string sV          = "v";
static const string sXWIND      = "xwind";
static const string sPWIND      = "pwind";
static const string sNLEV       = "nlev";
static const string sNLEVWIND   = "nlevwind";

// Type of input request to be processed
enum { THERMO_DATA_DROPPED, THERMO_DATA_MODULE, THERMO_DATA_MODULE_DROPPED };

class Thermo : public MvService {

public:

   // Entry point routine
   void serve(MvRequest&,MvRequest&);

   // Get input parameters
   virtual bool getInputParameters( MvRequest& );

   // Process data and build all data structures
   virtual bool processData() = 0;

   // Create output request
   virtual bool createOutputRequest( MvRequest& ) = 0;

   // Handle variable members
   void actionMode( string action ) { actionMode_ = action; }
   string actionMode()              { return actionMode_; }
   //void processType( int type )     { procType_ = type; }
   //int  processType( )              { return procType_; }
   void ncFileName( string name )   { ncFileName_ = name; }
   string ncFileName()              { return ncFileName_; }

   // Check if processing is related to visualisation
   bool isVisualise();

   // Check if input parameter is a data module
   bool isDataModule ( const char* );

   // Get the application (original) view request
   MvRequest getAppView ( MvRequest& );

   // Add information to help the Macro Converter to translate
   // the output request to a Macro code
   MvRequest buildMacroConverterRequest();

protected:

   Thermo(const char*);

   // Get application specific parameters
   virtual bool getAppParameters( MvRequest& ) = 0;

   // Check if parameters between two requests are consistent
   // It seems that the application should overlay diagrams independently how
   // they were computed.
   virtual bool consistencyCheck( MvRequest&, MvRequest& ) { return true; }

   void createProcessedOutputRequest( MvRequest& );

   // Variable members
   string actionMode_;      // e.g. "examine"/"save"/"execute"/...
   string ncFileName_;      // netcdf file name
   int procType_;           // processing type, e.g.,THERMO_DATA_MODULE,...
   MvRequest dataRequest_;  // data request
   MvRequest origReq_;      // input request
};

#endif
