/*!
{
  "name": "XML HTTP Request Level 2 XHR2",
  "property": "xhr2",
  "caniuse": "xhr2",
  "tags": ["network"],
  "builderAliases": ["network_xhr2"],
  "notes": [{
    "name": "W3C Spec",
    "href": "https://www.w3.org/TR/XMLHttpRequest2/"
  }, {
    "name": "Details on Related Github Issue",
    "href": "https://github.com/Modernizr/Modernizr/issues/385"
  }]
}
!*/
/* DOC
Tests for XHR2.
*/
define(['Modernizr'], function(Modernizr) {
  // all three of these details report consistently across all target browsers:
  //   !!(window.ProgressEvent);
  //   'XMLHttpRequest' in window && 'withCredentials' in new XMLHttpRequest
  Modernizr.addTest('xhr2', 'XMLHttpRequest' in window && 'withCredentials' in new XMLHttpRequest());
});
