/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.h2;

import com.carrotsearch.junitbenchmarks.h2.GeneratorUtils;
import com.carrotsearch.junitbenchmarks.h2.H2Consumer;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public final class MethodChartGenerator {
    private Connection connection;
    private int runId;
    private String clazzName;
    private String filePrefix;
    double min = Double.NaN;
    double max = Double.NaN;

    public MethodChartGenerator(Connection connection, String filePrefix, int runId, String clazzName) {
        this.connection = connection;
        this.runId = runId;
        this.clazzName = clazzName;
        this.filePrefix = filePrefix;
    }

    public void generate() throws Exception {
        String jsonFileName = this.filePrefix + ".json";
        String htmlFileName = this.filePrefix + ".html";
        String template = H2Consumer.getResource("MethodChartGenerator.html");
        template = GeneratorUtils.replaceToken(template, "CLASSNAME", this.clazzName);
        template = GeneratorUtils.replaceToken(template, "MethodChartGenerator.json", new File(jsonFileName).getName());
        template = GeneratorUtils.replaceToken(template, "/*MINMAX*/", GeneratorUtils.getMinMax(this.min, this.max));
        template = GeneratorUtils.replaceToken(template, "PROPERTIES", GeneratorUtils.getProperties(this.connection, this.runId));
        GeneratorUtils.save(htmlFileName, template);
        GeneratorUtils.save(jsonFileName, this.getData());
    }

    private String getData() throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        PreparedStatement s = this.connection.prepareStatement(H2Consumer.getResource("method-chart-results.sql"));
        s.setInt(1, this.runId);
        s.setString(2, this.clazzName);
        ResultSet rs = s.executeQuery();
        buf.append("\"cols\": [\n");
        ResultSetMetaData metaData = rs.getMetaData();
        for (i = 1; i <= metaData.getColumnCount(); ++i) {
            String colLabel = metaData.getColumnLabel(i);
            String type = GeneratorUtils.getMappedType(metaData.getColumnType(i));
            buf.append("{\"label\": \"");
            buf.append(colLabel);
            buf.append("\", \"type\": \"");
            buf.append(type);
            buf.append("\"}");
            if (i != metaData.getColumnCount()) {
                buf.append(",");
            }
            buf.append('\n');
        }
        buf.append("],\n");
        buf.append("\"rows\": [\n");
        while (rs.next()) {
            buf.append("{\"c\": [");
            for (i = 1; i <= metaData.getColumnCount(); ++i) {
                if (i > 1) {
                    buf.append(", ");
                }
                Object value = GeneratorUtils.formatValue(metaData.getColumnType(i), rs.getObject(i));
                buf.append("{\"v\": ");
                buf.append(value.toString());
                buf.append("}");
            }
            buf.append("]}");
            if (!rs.isLast()) {
                buf.append(",");
            }
            buf.append('\n');
        }
        buf.append("]}\n");
        rs.close();
        return buf.toString();
    }
}

