// Copyright (C) 2017 Robin Templeton. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
esid: sec-multiplicative-operators-runtime-semantics-evaluation
description: BigInt remainder arithmetic
features: [BigInt]
---*/
assert.sameValue(
  0xFEDCBA9876543210n % 0xFEDCBA9876543210n,
  0x0n,
  'The result of (0xFEDCBA9876543210n % 0xFEDCBA9876543210n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA9876543210n % 0xFEDCBA987654320Fn,
  0x1n,
  'The result of (0xFEDCBA9876543210n % 0xFEDCBA987654320Fn) is 0x1n'
);

assert.sameValue(
  0xFEDCBA9876543210n % 0xFEDCBA98n,
  0x76543210n,
  'The result of (0xFEDCBA9876543210n % 0xFEDCBA98n) is 0x76543210n'
);

assert.sameValue(
  0xFEDCBA9876543210n % 0xFEDCBA97n,
  0x77777779n,
  'The result of (0xFEDCBA9876543210n % 0xFEDCBA97n) is 0x77777779n'
);

assert.sameValue(
  0xFEDCBA9876543210n % 0x1234n,
  0x960n,
  'The result of (0xFEDCBA9876543210n % 0x1234n) is 0x960n'
);

assert.sameValue(
  0xFEDCBA9876543210n % 0x3n,
  0x0n,
  'The result of (0xFEDCBA9876543210n % 0x3n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA9876543210n % 0x2n,
  0x0n,
  'The result of (0xFEDCBA9876543210n % 0x2n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA9876543210n % 0x1n,
  0x0n,
  'The result of (0xFEDCBA9876543210n % 0x1n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA9876543210n % -0x1n,
  0x0n,
  'The result of (0xFEDCBA9876543210n % -0x1n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA9876543210n % -0x2n,
  0x0n,
  'The result of (0xFEDCBA9876543210n % -0x2n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA9876543210n % -0x3n,
  0x0n,
  'The result of (0xFEDCBA9876543210n % -0x3n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA9876543210n % -0x1234n,
  0x960n,
  'The result of (0xFEDCBA9876543210n % -0x1234n) is 0x960n'
);

assert.sameValue(
  0xFEDCBA9876543210n % -0xFEDCBA97n,
  0x77777779n,
  'The result of (0xFEDCBA9876543210n % -0xFEDCBA97n) is 0x77777779n'
);

assert.sameValue(
  0xFEDCBA9876543210n % -0xFEDCBA98n,
  0x76543210n,
  'The result of (0xFEDCBA9876543210n % -0xFEDCBA98n) is 0x76543210n'
);

assert.sameValue(
  0xFEDCBA9876543210n % -0xFEDCBA987654320Fn,
  0x1n,
  'The result of (0xFEDCBA9876543210n % -0xFEDCBA987654320Fn) is 0x1n'
);

assert.sameValue(
  0xFEDCBA9876543210n % -0xFEDCBA9876543210n,
  0x0n,
  'The result of (0xFEDCBA9876543210n % -0xFEDCBA9876543210n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % 0xFEDCBA9876543210n,
  0xFEDCBA987654320Fn,
  'The result of (0xFEDCBA987654320Fn % 0xFEDCBA9876543210n) is 0xFEDCBA987654320Fn'
);

assert.sameValue(
  0xFEDCBA987654320Fn % 0xFEDCBA987654320Fn,
  0x0n,
  'The result of (0xFEDCBA987654320Fn % 0xFEDCBA987654320Fn) is 0x0n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % 0xFEDCBA98n,
  0x7654320Fn,
  'The result of (0xFEDCBA987654320Fn % 0xFEDCBA98n) is 0x7654320Fn'
);

assert.sameValue(
  0xFEDCBA987654320Fn % 0xFEDCBA97n,
  0x77777778n,
  'The result of (0xFEDCBA987654320Fn % 0xFEDCBA97n) is 0x77777778n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % 0x1234n,
  0x95Fn,
  'The result of (0xFEDCBA987654320Fn % 0x1234n) is 0x95Fn'
);

assert.sameValue(
  0xFEDCBA987654320Fn % 0x3n,
  0x2n,
  'The result of (0xFEDCBA987654320Fn % 0x3n) is 0x2n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % 0x2n,
  0x1n,
  'The result of (0xFEDCBA987654320Fn % 0x2n) is 0x1n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % 0x1n,
  0x0n,
  'The result of (0xFEDCBA987654320Fn % 0x1n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % -0x1n,
  0x0n,
  'The result of (0xFEDCBA987654320Fn % -0x1n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % -0x2n,
  0x1n,
  'The result of (0xFEDCBA987654320Fn % -0x2n) is 0x1n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % -0x3n,
  0x2n,
  'The result of (0xFEDCBA987654320Fn % -0x3n) is 0x2n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % -0x1234n,
  0x95Fn,
  'The result of (0xFEDCBA987654320Fn % -0x1234n) is 0x95Fn'
);

assert.sameValue(
  0xFEDCBA987654320Fn % -0xFEDCBA97n,
  0x77777778n,
  'The result of (0xFEDCBA987654320Fn % -0xFEDCBA97n) is 0x77777778n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % -0xFEDCBA98n,
  0x7654320Fn,
  'The result of (0xFEDCBA987654320Fn % -0xFEDCBA98n) is 0x7654320Fn'
);

assert.sameValue(
  0xFEDCBA987654320Fn % -0xFEDCBA987654320Fn,
  0x0n,
  'The result of (0xFEDCBA987654320Fn % -0xFEDCBA987654320Fn) is 0x0n'
);

assert.sameValue(
  0xFEDCBA987654320Fn % -0xFEDCBA9876543210n,
  0xFEDCBA987654320Fn,
  'The result of (0xFEDCBA987654320Fn % -0xFEDCBA9876543210n) is 0xFEDCBA987654320Fn'
);

assert.sameValue(
  0xFEDCBA98n % 0xFEDCBA9876543210n,
  0xFEDCBA98n,
  'The result of (0xFEDCBA98n % 0xFEDCBA9876543210n) is 0xFEDCBA98n'
);

assert.sameValue(
  0xFEDCBA98n % 0xFEDCBA987654320Fn,
  0xFEDCBA98n,
  'The result of (0xFEDCBA98n % 0xFEDCBA987654320Fn) is 0xFEDCBA98n'
);

assert.sameValue(
  0xFEDCBA98n % 0xFEDCBA98n,
  0x0n,
  'The result of (0xFEDCBA98n % 0xFEDCBA98n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA98n % 0xFEDCBA97n,
  0x1n,
  'The result of (0xFEDCBA98n % 0xFEDCBA97n) is 0x1n'
);

assert.sameValue(0xFEDCBA98n % 0x1234n, 0x930n, 'The result of (0xFEDCBA98n % 0x1234n) is 0x930n');
assert.sameValue(0xFEDCBA98n % 0x3n, 0x2n, 'The result of (0xFEDCBA98n % 0x3n) is 0x2n');
assert.sameValue(0xFEDCBA98n % 0x2n, 0x0n, 'The result of (0xFEDCBA98n % 0x2n) is 0x0n');
assert.sameValue(0xFEDCBA98n % 0x1n, 0x0n, 'The result of (0xFEDCBA98n % 0x1n) is 0x0n');
assert.sameValue(0xFEDCBA98n % -0x1n, 0x0n, 'The result of (0xFEDCBA98n % -0x1n) is 0x0n');
assert.sameValue(0xFEDCBA98n % -0x2n, 0x0n, 'The result of (0xFEDCBA98n % -0x2n) is 0x0n');
assert.sameValue(0xFEDCBA98n % -0x3n, 0x2n, 'The result of (0xFEDCBA98n % -0x3n) is 0x2n');

assert.sameValue(
  0xFEDCBA98n % -0x1234n,
  0x930n,
  'The result of (0xFEDCBA98n % -0x1234n) is 0x930n'
);

assert.sameValue(
  0xFEDCBA98n % -0xFEDCBA97n,
  0x1n,
  'The result of (0xFEDCBA98n % -0xFEDCBA97n) is 0x1n'
);

assert.sameValue(
  0xFEDCBA98n % -0xFEDCBA98n,
  0x0n,
  'The result of (0xFEDCBA98n % -0xFEDCBA98n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA98n % -0xFEDCBA987654320Fn,
  0xFEDCBA98n,
  'The result of (0xFEDCBA98n % -0xFEDCBA987654320Fn) is 0xFEDCBA98n'
);

assert.sameValue(
  0xFEDCBA98n % -0xFEDCBA9876543210n,
  0xFEDCBA98n,
  'The result of (0xFEDCBA98n % -0xFEDCBA9876543210n) is 0xFEDCBA98n'
);

assert.sameValue(
  0xFEDCBA97n % 0xFEDCBA9876543210n,
  0xFEDCBA97n,
  'The result of (0xFEDCBA97n % 0xFEDCBA9876543210n) is 0xFEDCBA97n'
);

assert.sameValue(
  0xFEDCBA97n % 0xFEDCBA987654320Fn,
  0xFEDCBA97n,
  'The result of (0xFEDCBA97n % 0xFEDCBA987654320Fn) is 0xFEDCBA97n'
);

assert.sameValue(
  0xFEDCBA97n % 0xFEDCBA98n,
  0xFEDCBA97n,
  'The result of (0xFEDCBA97n % 0xFEDCBA98n) is 0xFEDCBA97n'
);

assert.sameValue(
  0xFEDCBA97n % 0xFEDCBA97n,
  0x0n,
  'The result of (0xFEDCBA97n % 0xFEDCBA97n) is 0x0n'
);

assert.sameValue(0xFEDCBA97n % 0x1234n, 0x92Fn, 'The result of (0xFEDCBA97n % 0x1234n) is 0x92Fn');
assert.sameValue(0xFEDCBA97n % 0x3n, 0x1n, 'The result of (0xFEDCBA97n % 0x3n) is 0x1n');
assert.sameValue(0xFEDCBA97n % 0x2n, 0x1n, 'The result of (0xFEDCBA97n % 0x2n) is 0x1n');
assert.sameValue(0xFEDCBA97n % 0x1n, 0x0n, 'The result of (0xFEDCBA97n % 0x1n) is 0x0n');
assert.sameValue(0xFEDCBA97n % -0x1n, 0x0n, 'The result of (0xFEDCBA97n % -0x1n) is 0x0n');
assert.sameValue(0xFEDCBA97n % -0x2n, 0x1n, 'The result of (0xFEDCBA97n % -0x2n) is 0x1n');
assert.sameValue(0xFEDCBA97n % -0x3n, 0x1n, 'The result of (0xFEDCBA97n % -0x3n) is 0x1n');

assert.sameValue(
  0xFEDCBA97n % -0x1234n,
  0x92Fn,
  'The result of (0xFEDCBA97n % -0x1234n) is 0x92Fn'
);

assert.sameValue(
  0xFEDCBA97n % -0xFEDCBA97n,
  0x0n,
  'The result of (0xFEDCBA97n % -0xFEDCBA97n) is 0x0n'
);

assert.sameValue(
  0xFEDCBA97n % -0xFEDCBA98n,
  0xFEDCBA97n,
  'The result of (0xFEDCBA97n % -0xFEDCBA98n) is 0xFEDCBA97n'
);

assert.sameValue(
  0xFEDCBA97n % -0xFEDCBA987654320Fn,
  0xFEDCBA97n,
  'The result of (0xFEDCBA97n % -0xFEDCBA987654320Fn) is 0xFEDCBA97n'
);

assert.sameValue(
  0xFEDCBA97n % -0xFEDCBA9876543210n,
  0xFEDCBA97n,
  'The result of (0xFEDCBA97n % -0xFEDCBA9876543210n) is 0xFEDCBA97n'
);

assert.sameValue(
  0x1234n % 0xFEDCBA9876543210n,
  0x1234n,
  'The result of (0x1234n % 0xFEDCBA9876543210n) is 0x1234n'
);

assert.sameValue(
  0x1234n % 0xFEDCBA987654320Fn,
  0x1234n,
  'The result of (0x1234n % 0xFEDCBA987654320Fn) is 0x1234n'
);

assert.sameValue(
  0x1234n % 0xFEDCBA98n,
  0x1234n,
  'The result of (0x1234n % 0xFEDCBA98n) is 0x1234n'
);

assert.sameValue(
  0x1234n % 0xFEDCBA97n,
  0x1234n,
  'The result of (0x1234n % 0xFEDCBA97n) is 0x1234n'
);

assert.sameValue(0x1234n % 0x1234n, 0x0n, 'The result of (0x1234n % 0x1234n) is 0x0n');
assert.sameValue(0x1234n % 0x3n, 0x1n, 'The result of (0x1234n % 0x3n) is 0x1n');
assert.sameValue(0x1234n % 0x2n, 0x0n, 'The result of (0x1234n % 0x2n) is 0x0n');
assert.sameValue(0x1234n % 0x1n, 0x0n, 'The result of (0x1234n % 0x1n) is 0x0n');
assert.sameValue(0x1234n % -0x1n, 0x0n, 'The result of (0x1234n % -0x1n) is 0x0n');
assert.sameValue(0x1234n % -0x2n, 0x0n, 'The result of (0x1234n % -0x2n) is 0x0n');
assert.sameValue(0x1234n % -0x3n, 0x1n, 'The result of (0x1234n % -0x3n) is 0x1n');
assert.sameValue(0x1234n % -0x1234n, 0x0n, 'The result of (0x1234n % -0x1234n) is 0x0n');

assert.sameValue(
  0x1234n % -0xFEDCBA97n,
  0x1234n,
  'The result of (0x1234n % -0xFEDCBA97n) is 0x1234n'
);

assert.sameValue(
  0x1234n % -0xFEDCBA98n,
  0x1234n,
  'The result of (0x1234n % -0xFEDCBA98n) is 0x1234n'
);

assert.sameValue(
  0x1234n % -0xFEDCBA987654320Fn,
  0x1234n,
  'The result of (0x1234n % -0xFEDCBA987654320Fn) is 0x1234n'
);

assert.sameValue(
  0x1234n % -0xFEDCBA9876543210n,
  0x1234n,
  'The result of (0x1234n % -0xFEDCBA9876543210n) is 0x1234n'
);

assert.sameValue(
  0x3n % 0xFEDCBA9876543210n,
  0x3n,
  'The result of (0x3n % 0xFEDCBA9876543210n) is 0x3n'
);

assert.sameValue(
  0x3n % 0xFEDCBA987654320Fn,
  0x3n,
  'The result of (0x3n % 0xFEDCBA987654320Fn) is 0x3n'
);

assert.sameValue(0x3n % 0xFEDCBA98n, 0x3n, 'The result of (0x3n % 0xFEDCBA98n) is 0x3n');
assert.sameValue(0x3n % 0xFEDCBA97n, 0x3n, 'The result of (0x3n % 0xFEDCBA97n) is 0x3n');
assert.sameValue(0x3n % 0x1234n, 0x3n, 'The result of (0x3n % 0x1234n) is 0x3n');
assert.sameValue(0x3n % 0x3n, 0x0n, 'The result of (0x3n % 0x3n) is 0x0n');
assert.sameValue(0x3n % 0x2n, 0x1n, 'The result of (0x3n % 0x2n) is 0x1n');
assert.sameValue(0x3n % 0x1n, 0x0n, 'The result of (0x3n % 0x1n) is 0x0n');
assert.sameValue(0x3n % -0x1n, 0x0n, 'The result of (0x3n % -0x1n) is 0x0n');
assert.sameValue(0x3n % -0x2n, 0x1n, 'The result of (0x3n % -0x2n) is 0x1n');
assert.sameValue(0x3n % -0x3n, 0x0n, 'The result of (0x3n % -0x3n) is 0x0n');
assert.sameValue(0x3n % -0x1234n, 0x3n, 'The result of (0x3n % -0x1234n) is 0x3n');
assert.sameValue(0x3n % -0xFEDCBA97n, 0x3n, 'The result of (0x3n % -0xFEDCBA97n) is 0x3n');
assert.sameValue(0x3n % -0xFEDCBA98n, 0x3n, 'The result of (0x3n % -0xFEDCBA98n) is 0x3n');

assert.sameValue(
  0x3n % -0xFEDCBA987654320Fn,
  0x3n,
  'The result of (0x3n % -0xFEDCBA987654320Fn) is 0x3n'
);

assert.sameValue(
  0x3n % -0xFEDCBA9876543210n,
  0x3n,
  'The result of (0x3n % -0xFEDCBA9876543210n) is 0x3n'
);

assert.sameValue(
  0x2n % 0xFEDCBA9876543210n,
  0x2n,
  'The result of (0x2n % 0xFEDCBA9876543210n) is 0x2n'
);

assert.sameValue(
  0x2n % 0xFEDCBA987654320Fn,
  0x2n,
  'The result of (0x2n % 0xFEDCBA987654320Fn) is 0x2n'
);

assert.sameValue(0x2n % 0xFEDCBA98n, 0x2n, 'The result of (0x2n % 0xFEDCBA98n) is 0x2n');
assert.sameValue(0x2n % 0xFEDCBA97n, 0x2n, 'The result of (0x2n % 0xFEDCBA97n) is 0x2n');
assert.sameValue(0x2n % 0x1234n, 0x2n, 'The result of (0x2n % 0x1234n) is 0x2n');
assert.sameValue(0x2n % 0x3n, 0x2n, 'The result of (0x2n % 0x3n) is 0x2n');
assert.sameValue(0x2n % 0x2n, 0x0n, 'The result of (0x2n % 0x2n) is 0x0n');
assert.sameValue(0x2n % 0x1n, 0x0n, 'The result of (0x2n % 0x1n) is 0x0n');
assert.sameValue(0x2n % -0x1n, 0x0n, 'The result of (0x2n % -0x1n) is 0x0n');
assert.sameValue(0x2n % -0x2n, 0x0n, 'The result of (0x2n % -0x2n) is 0x0n');
assert.sameValue(0x2n % -0x3n, 0x2n, 'The result of (0x2n % -0x3n) is 0x2n');
assert.sameValue(0x2n % -0x1234n, 0x2n, 'The result of (0x2n % -0x1234n) is 0x2n');
assert.sameValue(0x2n % -0xFEDCBA97n, 0x2n, 'The result of (0x2n % -0xFEDCBA97n) is 0x2n');
assert.sameValue(0x2n % -0xFEDCBA98n, 0x2n, 'The result of (0x2n % -0xFEDCBA98n) is 0x2n');

assert.sameValue(
  0x2n % -0xFEDCBA987654320Fn,
  0x2n,
  'The result of (0x2n % -0xFEDCBA987654320Fn) is 0x2n'
);

assert.sameValue(
  0x2n % -0xFEDCBA9876543210n,
  0x2n,
  'The result of (0x2n % -0xFEDCBA9876543210n) is 0x2n'
);

assert.sameValue(
  0x1n % 0xFEDCBA9876543210n,
  0x1n,
  'The result of (0x1n % 0xFEDCBA9876543210n) is 0x1n'
);

assert.sameValue(
  0x1n % 0xFEDCBA987654320Fn,
  0x1n,
  'The result of (0x1n % 0xFEDCBA987654320Fn) is 0x1n'
);

assert.sameValue(0x1n % 0xFEDCBA98n, 0x1n, 'The result of (0x1n % 0xFEDCBA98n) is 0x1n');
assert.sameValue(0x1n % 0xFEDCBA97n, 0x1n, 'The result of (0x1n % 0xFEDCBA97n) is 0x1n');
assert.sameValue(0x1n % 0x1234n, 0x1n, 'The result of (0x1n % 0x1234n) is 0x1n');
assert.sameValue(0x1n % 0x3n, 0x1n, 'The result of (0x1n % 0x3n) is 0x1n');
assert.sameValue(0x1n % 0x2n, 0x1n, 'The result of (0x1n % 0x2n) is 0x1n');
assert.sameValue(0x1n % 0x1n, 0x0n, 'The result of (0x1n % 0x1n) is 0x0n');
assert.sameValue(0x1n % -0x1n, 0x0n, 'The result of (0x1n % -0x1n) is 0x0n');
assert.sameValue(0x1n % -0x2n, 0x1n, 'The result of (0x1n % -0x2n) is 0x1n');
assert.sameValue(0x1n % -0x3n, 0x1n, 'The result of (0x1n % -0x3n) is 0x1n');
assert.sameValue(0x1n % -0x1234n, 0x1n, 'The result of (0x1n % -0x1234n) is 0x1n');
assert.sameValue(0x1n % -0xFEDCBA97n, 0x1n, 'The result of (0x1n % -0xFEDCBA97n) is 0x1n');
assert.sameValue(0x1n % -0xFEDCBA98n, 0x1n, 'The result of (0x1n % -0xFEDCBA98n) is 0x1n');

assert.sameValue(
  0x1n % -0xFEDCBA987654320Fn,
  0x1n,
  'The result of (0x1n % -0xFEDCBA987654320Fn) is 0x1n'
);

assert.sameValue(
  0x1n % -0xFEDCBA9876543210n,
  0x1n,
  'The result of (0x1n % -0xFEDCBA9876543210n) is 0x1n'
);

assert.sameValue(
  -0x1n % 0xFEDCBA9876543210n,
  -0x1n,
  'The result of (-0x1n % 0xFEDCBA9876543210n) is -0x1n'
);

assert.sameValue(
  -0x1n % 0xFEDCBA987654320Fn,
  -0x1n,
  'The result of (-0x1n % 0xFEDCBA987654320Fn) is -0x1n'
);

assert.sameValue(-0x1n % 0xFEDCBA98n, -0x1n, 'The result of (-0x1n % 0xFEDCBA98n) is -0x1n');
assert.sameValue(-0x1n % 0xFEDCBA97n, -0x1n, 'The result of (-0x1n % 0xFEDCBA97n) is -0x1n');
assert.sameValue(-0x1n % 0x1234n, -0x1n, 'The result of (-0x1n % 0x1234n) is -0x1n');
assert.sameValue(-0x1n % 0x3n, -0x1n, 'The result of (-0x1n % 0x3n) is -0x1n');
assert.sameValue(-0x1n % 0x2n, -0x1n, 'The result of (-0x1n % 0x2n) is -0x1n');
assert.sameValue(-0x1n % 0x1n, 0x0n, 'The result of (-0x1n % 0x1n) is 0x0n');
assert.sameValue(-0x1n % -0x1n, 0x0n, 'The result of (-0x1n % -0x1n) is 0x0n');
assert.sameValue(-0x1n % -0x2n, -0x1n, 'The result of (-0x1n % -0x2n) is -0x1n');
assert.sameValue(-0x1n % -0x3n, -0x1n, 'The result of (-0x1n % -0x3n) is -0x1n');
assert.sameValue(-0x1n % -0x1234n, -0x1n, 'The result of (-0x1n % -0x1234n) is -0x1n');
assert.sameValue(-0x1n % -0xFEDCBA97n, -0x1n, 'The result of (-0x1n % -0xFEDCBA97n) is -0x1n');
assert.sameValue(-0x1n % -0xFEDCBA98n, -0x1n, 'The result of (-0x1n % -0xFEDCBA98n) is -0x1n');

assert.sameValue(
  -0x1n % -0xFEDCBA987654320Fn,
  -0x1n,
  'The result of (-0x1n % -0xFEDCBA987654320Fn) is -0x1n'
);

assert.sameValue(
  -0x1n % -0xFEDCBA9876543210n,
  -0x1n,
  'The result of (-0x1n % -0xFEDCBA9876543210n) is -0x1n'
);

assert.sameValue(
  -0x2n % 0xFEDCBA9876543210n,
  -0x2n,
  'The result of (-0x2n % 0xFEDCBA9876543210n) is -0x2n'
);

assert.sameValue(
  -0x2n % 0xFEDCBA987654320Fn,
  -0x2n,
  'The result of (-0x2n % 0xFEDCBA987654320Fn) is -0x2n'
);

assert.sameValue(-0x2n % 0xFEDCBA98n, -0x2n, 'The result of (-0x2n % 0xFEDCBA98n) is -0x2n');
assert.sameValue(-0x2n % 0xFEDCBA97n, -0x2n, 'The result of (-0x2n % 0xFEDCBA97n) is -0x2n');
assert.sameValue(-0x2n % 0x1234n, -0x2n, 'The result of (-0x2n % 0x1234n) is -0x2n');
assert.sameValue(-0x2n % 0x3n, -0x2n, 'The result of (-0x2n % 0x3n) is -0x2n');
assert.sameValue(-0x2n % 0x2n, 0x0n, 'The result of (-0x2n % 0x2n) is 0x0n');
assert.sameValue(-0x2n % 0x1n, 0x0n, 'The result of (-0x2n % 0x1n) is 0x0n');
assert.sameValue(-0x2n % -0x1n, 0x0n, 'The result of (-0x2n % -0x1n) is 0x0n');
assert.sameValue(-0x2n % -0x2n, 0x0n, 'The result of (-0x2n % -0x2n) is 0x0n');
assert.sameValue(-0x2n % -0x3n, -0x2n, 'The result of (-0x2n % -0x3n) is -0x2n');
assert.sameValue(-0x2n % -0x1234n, -0x2n, 'The result of (-0x2n % -0x1234n) is -0x2n');
assert.sameValue(-0x2n % -0xFEDCBA97n, -0x2n, 'The result of (-0x2n % -0xFEDCBA97n) is -0x2n');
assert.sameValue(-0x2n % -0xFEDCBA98n, -0x2n, 'The result of (-0x2n % -0xFEDCBA98n) is -0x2n');

assert.sameValue(
  -0x2n % -0xFEDCBA987654320Fn,
  -0x2n,
  'The result of (-0x2n % -0xFEDCBA987654320Fn) is -0x2n'
);

assert.sameValue(
  -0x2n % -0xFEDCBA9876543210n,
  -0x2n,
  'The result of (-0x2n % -0xFEDCBA9876543210n) is -0x2n'
);

assert.sameValue(
  -0x3n % 0xFEDCBA9876543210n,
  -0x3n,
  'The result of (-0x3n % 0xFEDCBA9876543210n) is -0x3n'
);

assert.sameValue(
  -0x3n % 0xFEDCBA987654320Fn,
  -0x3n,
  'The result of (-0x3n % 0xFEDCBA987654320Fn) is -0x3n'
);

assert.sameValue(-0x3n % 0xFEDCBA98n, -0x3n, 'The result of (-0x3n % 0xFEDCBA98n) is -0x3n');
assert.sameValue(-0x3n % 0xFEDCBA97n, -0x3n, 'The result of (-0x3n % 0xFEDCBA97n) is -0x3n');
assert.sameValue(-0x3n % 0x1234n, -0x3n, 'The result of (-0x3n % 0x1234n) is -0x3n');
assert.sameValue(-0x3n % 0x3n, 0x0n, 'The result of (-0x3n % 0x3n) is 0x0n');
assert.sameValue(-0x3n % 0x2n, -0x1n, 'The result of (-0x3n % 0x2n) is -0x1n');
assert.sameValue(-0x3n % 0x1n, 0x0n, 'The result of (-0x3n % 0x1n) is 0x0n');
assert.sameValue(-0x3n % -0x1n, 0x0n, 'The result of (-0x3n % -0x1n) is 0x0n');
assert.sameValue(-0x3n % -0x2n, -0x1n, 'The result of (-0x3n % -0x2n) is -0x1n');
assert.sameValue(-0x3n % -0x3n, 0x0n, 'The result of (-0x3n % -0x3n) is 0x0n');
assert.sameValue(-0x3n % -0x1234n, -0x3n, 'The result of (-0x3n % -0x1234n) is -0x3n');
assert.sameValue(-0x3n % -0xFEDCBA97n, -0x3n, 'The result of (-0x3n % -0xFEDCBA97n) is -0x3n');
assert.sameValue(-0x3n % -0xFEDCBA98n, -0x3n, 'The result of (-0x3n % -0xFEDCBA98n) is -0x3n');

assert.sameValue(
  -0x3n % -0xFEDCBA987654320Fn,
  -0x3n,
  'The result of (-0x3n % -0xFEDCBA987654320Fn) is -0x3n'
);

assert.sameValue(
  -0x3n % -0xFEDCBA9876543210n,
  -0x3n,
  'The result of (-0x3n % -0xFEDCBA9876543210n) is -0x3n'
);

assert.sameValue(
  -0x1234n % 0xFEDCBA9876543210n,
  -0x1234n,
  'The result of (-0x1234n % 0xFEDCBA9876543210n) is -0x1234n'
);

assert.sameValue(
  -0x1234n % 0xFEDCBA987654320Fn,
  -0x1234n,
  'The result of (-0x1234n % 0xFEDCBA987654320Fn) is -0x1234n'
);

assert.sameValue(
  -0x1234n % 0xFEDCBA98n,
  -0x1234n,
  'The result of (-0x1234n % 0xFEDCBA98n) is -0x1234n'
);

assert.sameValue(
  -0x1234n % 0xFEDCBA97n,
  -0x1234n,
  'The result of (-0x1234n % 0xFEDCBA97n) is -0x1234n'
);

assert.sameValue(-0x1234n % 0x1234n, 0x0n, 'The result of (-0x1234n % 0x1234n) is 0x0n');
assert.sameValue(-0x1234n % 0x3n, -0x1n, 'The result of (-0x1234n % 0x3n) is -0x1n');
assert.sameValue(-0x1234n % 0x2n, 0x0n, 'The result of (-0x1234n % 0x2n) is 0x0n');
assert.sameValue(-0x1234n % 0x1n, 0x0n, 'The result of (-0x1234n % 0x1n) is 0x0n');
assert.sameValue(-0x1234n % -0x1n, 0x0n, 'The result of (-0x1234n % -0x1n) is 0x0n');
assert.sameValue(-0x1234n % -0x2n, 0x0n, 'The result of (-0x1234n % -0x2n) is 0x0n');
assert.sameValue(-0x1234n % -0x3n, -0x1n, 'The result of (-0x1234n % -0x3n) is -0x1n');
assert.sameValue(-0x1234n % -0x1234n, 0x0n, 'The result of (-0x1234n % -0x1234n) is 0x0n');

assert.sameValue(
  -0x1234n % -0xFEDCBA97n,
  -0x1234n,
  'The result of (-0x1234n % -0xFEDCBA97n) is -0x1234n'
);

assert.sameValue(
  -0x1234n % -0xFEDCBA98n,
  -0x1234n,
  'The result of (-0x1234n % -0xFEDCBA98n) is -0x1234n'
);

assert.sameValue(
  -0x1234n % -0xFEDCBA987654320Fn,
  -0x1234n,
  'The result of (-0x1234n % -0xFEDCBA987654320Fn) is -0x1234n'
);

assert.sameValue(
  -0x1234n % -0xFEDCBA9876543210n,
  -0x1234n,
  'The result of (-0x1234n % -0xFEDCBA9876543210n) is -0x1234n'
);

assert.sameValue(
  -0xFEDCBA97n % 0xFEDCBA9876543210n,
  -0xFEDCBA97n,
  'The result of (-0xFEDCBA97n % 0xFEDCBA9876543210n) is -0xFEDCBA97n'
);

assert.sameValue(
  -0xFEDCBA97n % 0xFEDCBA987654320Fn,
  -0xFEDCBA97n,
  'The result of (-0xFEDCBA97n % 0xFEDCBA987654320Fn) is -0xFEDCBA97n'
);

assert.sameValue(
  -0xFEDCBA97n % 0xFEDCBA98n,
  -0xFEDCBA97n,
  'The result of (-0xFEDCBA97n % 0xFEDCBA98n) is -0xFEDCBA97n'
);

assert.sameValue(
  -0xFEDCBA97n % 0xFEDCBA97n,
  0x0n,
  'The result of (-0xFEDCBA97n % 0xFEDCBA97n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA97n % 0x1234n,
  -0x92Fn,
  'The result of (-0xFEDCBA97n % 0x1234n) is -0x92Fn'
);

assert.sameValue(-0xFEDCBA97n % 0x3n, -0x1n, 'The result of (-0xFEDCBA97n % 0x3n) is -0x1n');
assert.sameValue(-0xFEDCBA97n % 0x2n, -0x1n, 'The result of (-0xFEDCBA97n % 0x2n) is -0x1n');
assert.sameValue(-0xFEDCBA97n % 0x1n, 0x0n, 'The result of (-0xFEDCBA97n % 0x1n) is 0x0n');
assert.sameValue(-0xFEDCBA97n % -0x1n, 0x0n, 'The result of (-0xFEDCBA97n % -0x1n) is 0x0n');
assert.sameValue(-0xFEDCBA97n % -0x2n, -0x1n, 'The result of (-0xFEDCBA97n % -0x2n) is -0x1n');
assert.sameValue(-0xFEDCBA97n % -0x3n, -0x1n, 'The result of (-0xFEDCBA97n % -0x3n) is -0x1n');

assert.sameValue(
  -0xFEDCBA97n % -0x1234n,
  -0x92Fn,
  'The result of (-0xFEDCBA97n % -0x1234n) is -0x92Fn'
);

assert.sameValue(
  -0xFEDCBA97n % -0xFEDCBA97n,
  0x0n,
  'The result of (-0xFEDCBA97n % -0xFEDCBA97n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA97n % -0xFEDCBA98n,
  -0xFEDCBA97n,
  'The result of (-0xFEDCBA97n % -0xFEDCBA98n) is -0xFEDCBA97n'
);

assert.sameValue(
  -0xFEDCBA97n % -0xFEDCBA987654320Fn,
  -0xFEDCBA97n,
  'The result of (-0xFEDCBA97n % -0xFEDCBA987654320Fn) is -0xFEDCBA97n'
);

assert.sameValue(
  -0xFEDCBA97n % -0xFEDCBA9876543210n,
  -0xFEDCBA97n,
  'The result of (-0xFEDCBA97n % -0xFEDCBA9876543210n) is -0xFEDCBA97n'
);

assert.sameValue(
  -0xFEDCBA98n % 0xFEDCBA9876543210n,
  -0xFEDCBA98n,
  'The result of (-0xFEDCBA98n % 0xFEDCBA9876543210n) is -0xFEDCBA98n'
);

assert.sameValue(
  -0xFEDCBA98n % 0xFEDCBA987654320Fn,
  -0xFEDCBA98n,
  'The result of (-0xFEDCBA98n % 0xFEDCBA987654320Fn) is -0xFEDCBA98n'
);

assert.sameValue(
  -0xFEDCBA98n % 0xFEDCBA98n,
  0x0n,
  'The result of (-0xFEDCBA98n % 0xFEDCBA98n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA98n % 0xFEDCBA97n,
  -0x1n,
  'The result of (-0xFEDCBA98n % 0xFEDCBA97n) is -0x1n'
);

assert.sameValue(
  -0xFEDCBA98n % 0x1234n,
  -0x930n,
  'The result of (-0xFEDCBA98n % 0x1234n) is -0x930n'
);

assert.sameValue(-0xFEDCBA98n % 0x3n, -0x2n, 'The result of (-0xFEDCBA98n % 0x3n) is -0x2n');
assert.sameValue(-0xFEDCBA98n % 0x2n, 0x0n, 'The result of (-0xFEDCBA98n % 0x2n) is 0x0n');
assert.sameValue(-0xFEDCBA98n % 0x1n, 0x0n, 'The result of (-0xFEDCBA98n % 0x1n) is 0x0n');
assert.sameValue(-0xFEDCBA98n % -0x1n, 0x0n, 'The result of (-0xFEDCBA98n % -0x1n) is 0x0n');
assert.sameValue(-0xFEDCBA98n % -0x2n, 0x0n, 'The result of (-0xFEDCBA98n % -0x2n) is 0x0n');
assert.sameValue(-0xFEDCBA98n % -0x3n, -0x2n, 'The result of (-0xFEDCBA98n % -0x3n) is -0x2n');

assert.sameValue(
  -0xFEDCBA98n % -0x1234n,
  -0x930n,
  'The result of (-0xFEDCBA98n % -0x1234n) is -0x930n'
);

assert.sameValue(
  -0xFEDCBA98n % -0xFEDCBA97n,
  -0x1n,
  'The result of (-0xFEDCBA98n % -0xFEDCBA97n) is -0x1n'
);

assert.sameValue(
  -0xFEDCBA98n % -0xFEDCBA98n,
  0x0n,
  'The result of (-0xFEDCBA98n % -0xFEDCBA98n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA98n % -0xFEDCBA987654320Fn,
  -0xFEDCBA98n,
  'The result of (-0xFEDCBA98n % -0xFEDCBA987654320Fn) is -0xFEDCBA98n'
);

assert.sameValue(
  -0xFEDCBA98n % -0xFEDCBA9876543210n,
  -0xFEDCBA98n,
  'The result of (-0xFEDCBA98n % -0xFEDCBA9876543210n) is -0xFEDCBA98n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % 0xFEDCBA9876543210n,
  -0xFEDCBA987654320Fn,
  'The result of (-0xFEDCBA987654320Fn % 0xFEDCBA9876543210n) is -0xFEDCBA987654320Fn'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % 0xFEDCBA987654320Fn,
  0x0n,
  'The result of (-0xFEDCBA987654320Fn % 0xFEDCBA987654320Fn) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % 0xFEDCBA98n,
  -0x7654320Fn,
  'The result of (-0xFEDCBA987654320Fn % 0xFEDCBA98n) is -0x7654320Fn'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % 0xFEDCBA97n,
  -0x77777778n,
  'The result of (-0xFEDCBA987654320Fn % 0xFEDCBA97n) is -0x77777778n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % 0x1234n,
  -0x95Fn,
  'The result of (-0xFEDCBA987654320Fn % 0x1234n) is -0x95Fn'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % 0x3n,
  -0x2n,
  'The result of (-0xFEDCBA987654320Fn % 0x3n) is -0x2n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % 0x2n,
  -0x1n,
  'The result of (-0xFEDCBA987654320Fn % 0x2n) is -0x1n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % 0x1n,
  0x0n,
  'The result of (-0xFEDCBA987654320Fn % 0x1n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % -0x1n,
  0x0n,
  'The result of (-0xFEDCBA987654320Fn % -0x1n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % -0x2n,
  -0x1n,
  'The result of (-0xFEDCBA987654320Fn % -0x2n) is -0x1n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % -0x3n,
  -0x2n,
  'The result of (-0xFEDCBA987654320Fn % -0x3n) is -0x2n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % -0x1234n,
  -0x95Fn,
  'The result of (-0xFEDCBA987654320Fn % -0x1234n) is -0x95Fn'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % -0xFEDCBA97n,
  -0x77777778n,
  'The result of (-0xFEDCBA987654320Fn % -0xFEDCBA97n) is -0x77777778n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % -0xFEDCBA98n,
  -0x7654320Fn,
  'The result of (-0xFEDCBA987654320Fn % -0xFEDCBA98n) is -0x7654320Fn'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % -0xFEDCBA987654320Fn,
  0x0n,
  'The result of (-0xFEDCBA987654320Fn % -0xFEDCBA987654320Fn) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA987654320Fn % -0xFEDCBA9876543210n,
  -0xFEDCBA987654320Fn,
  'The result of (-0xFEDCBA987654320Fn % -0xFEDCBA9876543210n) is -0xFEDCBA987654320Fn'
);

assert.sameValue(
  -0xFEDCBA9876543210n % 0xFEDCBA9876543210n,
  0x0n,
  'The result of (-0xFEDCBA9876543210n % 0xFEDCBA9876543210n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % 0xFEDCBA987654320Fn,
  -0x1n,
  'The result of (-0xFEDCBA9876543210n % 0xFEDCBA987654320Fn) is -0x1n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % 0xFEDCBA98n,
  -0x76543210n,
  'The result of (-0xFEDCBA9876543210n % 0xFEDCBA98n) is -0x76543210n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % 0xFEDCBA97n,
  -0x77777779n,
  'The result of (-0xFEDCBA9876543210n % 0xFEDCBA97n) is -0x77777779n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % 0x1234n,
  -0x960n,
  'The result of (-0xFEDCBA9876543210n % 0x1234n) is -0x960n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % 0x3n,
  0x0n,
  'The result of (-0xFEDCBA9876543210n % 0x3n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % 0x2n,
  0x0n,
  'The result of (-0xFEDCBA9876543210n % 0x2n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % 0x1n,
  0x0n,
  'The result of (-0xFEDCBA9876543210n % 0x1n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % -0x1n,
  0x0n,
  'The result of (-0xFEDCBA9876543210n % -0x1n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % -0x2n,
  0x0n,
  'The result of (-0xFEDCBA9876543210n % -0x2n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % -0x3n,
  0x0n,
  'The result of (-0xFEDCBA9876543210n % -0x3n) is 0x0n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % -0x1234n,
  -0x960n,
  'The result of (-0xFEDCBA9876543210n % -0x1234n) is -0x960n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % -0xFEDCBA97n,
  -0x77777779n,
  'The result of (-0xFEDCBA9876543210n % -0xFEDCBA97n) is -0x77777779n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % -0xFEDCBA98n,
  -0x76543210n,
  'The result of (-0xFEDCBA9876543210n % -0xFEDCBA98n) is -0x76543210n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % -0xFEDCBA987654320Fn,
  -0x1n,
  'The result of (-0xFEDCBA9876543210n % -0xFEDCBA987654320Fn) is -0x1n'
);

assert.sameValue(
  -0xFEDCBA9876543210n % -0xFEDCBA9876543210n,
  0x0n,
  'The result of (-0xFEDCBA9876543210n % -0xFEDCBA9876543210n) is 0x0n'
);

reportCompare(0, 0);
