---
id: fast-foundation.button
title: Button class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Button](./fast-foundation.button.md)

## Button class

A Button Custom HTML Element. Based largely on the [&lt;button&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button)<!-- -->.


start - Content which can be provided before the button content


end - Content which can be provided after the button content


- The default slot for button content


control - The button element


content - The element wrapping button content

<b>Signature:</b>

```typescript
export declare class Button extends FormAssociatedButton 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [autofocus](./fast-foundation.button.autofocus.md) |  | boolean | Determines if the element should receive document focus on page load. |
|  [control](./fast-foundation.button.control.md) |  | HTMLButtonElement |  |
|  [defaultSlottedContent](./fast-foundation.button.defaultslottedcontent.md) |  | HTMLElement\[\] | Default slotted content |
|  [formaction](./fast-foundation.button.formaction.md) |  | string | See [&lt;button&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button) for more details. |
|  [formenctype](./fast-foundation.button.formenctype.md) |  | string | See [&lt;button&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button) for more details. |
|  [formId](./fast-foundation.button.formid.md) |  | string | The id of a form to associate the element to. |
|  [formmethod](./fast-foundation.button.formmethod.md) |  | string | See [&lt;button&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button) for more details. |
|  [formnovalidate](./fast-foundation.button.formnovalidate.md) |  | boolean | See [&lt;button&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button) for more details. |
|  [formtarget](./fast-foundation.button.formtarget.md) |  | "\_self" \| "\_blank" \| "\_parent" \| "\_top" | See [&lt;button&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button) for more details. |
|  [type](./fast-foundation.button.type.md) |  | "submit" \| "reset" \| "button" | The button type. |
