###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpcoin_detect.nasl 7675 2010-03-11 17:20:36Z mar $
#
# phpCOIN Version Detection
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800735);
  script_version("$Revision: 7732 $: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("phpCOIN Version Detection");
  desc = "
  Overview: This script detects the installed version of phpCOIN and sets the
  result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the Version of phpCOIN in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Intevation GmbH");
  script_family("Service detection");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

foreach dir (make_list("/phpcoin", "/phpCoin165", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir , "/license.php"), port:phpPort);
  rcvRes = http_send_recv(port:phpPort, data:sndReq);
  if(rcvRes =~ "php[Cc][Oo][Ii][Nn] [Ll]icense")
  {
    phpVer = eregmatch(pattern:"Version:.*v([0-9.]+)", string:rcvRes);
    if(phpVer[1] != NULL)
    {
      set_kb_item(name:"www/" + phpPort + "/phpCOIN", value:phpVer[1]);
      security_note(data:"phpCOIN version " + phpVer[1] + 
                   " running at location " + dir + " was detected on the host");
    }
  }
}
