###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-065.nasl 5694 2009-11-11 09:20:09Z nov $
#
# Microsoft Windows Kernel-Mode Drivers Multiple Vulnerabilities (969947)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900886);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1127", "CVE-2009-2513", "CVE-2009-2514");
  script_bugtraq_id(36939, 36941, 36029);
  script_name("Microsoft Windows Kernel-Mode Drivers Multiple Vulnerabilities (969947)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-065.

  Vulnerability Insight:
  - An error in the Win32k kernel-mode driver 'Win32k.sys' when parsing
    font code can be exploited to execute arbitrary code if a user
    views content rendered in a specially crafted Embedded OpenType (EOT)
    font, when a user visits a malicious web site.
  - Some vulnerabilities in the Win32k kernel-mode driver can be exploited by
    malicious, local users to gain escalated privileges.
  - An error in the Win32k kernel-mode driver 'Win32k.sys' when handling input
    passed through the kernel component of GDI (Graphics Device Interface) can
    be exploited to execute arbitrary code in kernel mode.

  Impact:
  Successful exploitation could allow attackers to remote attackers to compromise
  a vulnerable system or by local attackers to gain elevated privileges.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K  Service Pack 4 and prior.
  Microsoft Windows XP  Service Pack 3 and prior.
  Microsoft Windows 2K3 Service Pack 2 and prior.

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms09-065.mspx

  References:
  http://secunia.com/advisories/37318/
  http://support.microsoft.com/kb/969947
  http://www.vupen.com/english/advisories/2009/3191
  http://www.microsoft.com/technet/security/bulletin/ms09-065.mspx

  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Win32k.sys file");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# MS09-065 Hotfix Check
if(hotfix_missing(name:"969947") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Win32k.sys");
sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Win32k.sys version < 5.0.2195.7322
  if(version_is_less(version:sysVer, test_version:"5.0.2195.7322")){
    security_hole(0);
  }
}

# Windows XP
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Win32k.sys < 5.1.2600.3614
    if(version_is_less(version:sysVer, test_version:"5.1.2600.3614")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Win32k.sys < 5.1.2600.5863
    if(version_is_less(version:sysVer, test_version:"5.1.2600.5863")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Win32k.sys version < 5.2.3790.4571
     if(version_is_less(version:sysVer, test_version:"5.2.3790.4571")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
