//=======================================================================
// infotab.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "infotab.h"
#include "pkg.h"
#include <fstream>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/textview.h>
#include <gtkmm/label.h>
#include <gtkmm/textbuffer.h>
#include <gtkmm/separator.h>

using namespace Gpaco;


InfoTab::InfoTab(Pkg const& pkg)
:
	Gtk::VBox()
{
	Gtk::TextView* pTextView(Gtk::manage(new Gtk::TextView()));
	pTextView->set_editable(false);
	pTextView->set_cursor_visible(false);
	pTextView->set_left_margin(10);
	pTextView->set_right_margin(10);

	Gtk::ScrolledWindow* pScrolledWindow(Gtk::manage(new Gtk::ScrolledWindow()));
	pScrolledWindow->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
	pScrolledWindow->add(*pTextView);

	Gtk::Label* pLabel(Gtk::manage(new Gtk::Label("", 0.02, 0.5)));

	pack_start(*pScrolledWindow);
	pack_start(*(Gtk::manage(new Gtk::HSeparator())), Gtk::PACK_SHRINK);
	pack_start(*pLabel, Gtk::PACK_SHRINK);
	
	Glib::RefPtr<Gtk::TextBuffer> pTextBuffer(pTextView->get_buffer());

	Glib::RefPtr<Gtk::TextTag> pTagWrap(pTextBuffer->create_tag());
	pTagWrap->property_wrap_mode() = Gtk::WRAP_WORD;
	
	Glib::RefPtr<Gtk::TextTag> pTagTitle(pTextBuffer->create_tag());
	pTagTitle->property_weight() = Pango::WEIGHT_BOLD;
	pTagTitle->property_family() = "courier";
	pTagTitle->property_size_points() = 12.0;

	bool ok = false;

	if (pkg.icon()) {
		pTextBuffer->insert(pTextBuffer->end(), "\n");
		pTextBuffer->insert_pixbuf(pTextBuffer->end(), pkg.icon());
		pTextBuffer->insert(pTextBuffer->end(), "\n");
		ok = true;
	}
	pTextBuffer->insert(pTextBuffer->end(), "\n");

	std::string buf;
	std::ifstream f(pkg.log().c_str());
	g_return_if_fail(f);

	while (std::getline(f, buf) && buf[0] == '#') {
		if (buf.find("#:") != 0)
			continue;
		buf.erase(0, 2);

		if (!buf.find("Description"))
			pTextBuffer->insert_with_tag(pTextBuffer->end(), buf + "\n", pTagTitle);
		else if (!buf.find("Name:") || !buf.find("Author:")
			|| !buf.find("Version:") || !buf.find("Summary:")
			|| !buf.find("URL:") || !buf.find("License:")) {
			g_assert(buf.size() >= 10);
			pTextBuffer->insert_with_tag(pTextBuffer->end(), buf.substr(0, 10), pTagTitle);
			pTextBuffer->insert_with_tag(pTextBuffer->end(), buf.substr(10), pTagWrap);
		}
		else
			pTextBuffer->insert_with_tag(pTextBuffer->end(), buf, pTagWrap);
	
		pTextBuffer->insert(pTextBuffer->end(), "\n");
		ok = true;
	}

	f.seekg(0);

	while (std::getline(f, buf) && buf[0] == '#') {
		if (!buf.find("#c:")) {
			pTextBuffer->insert_with_tag(pTextBuffer->end(), "\nconfigure options\n", pTagTitle);
			pTextBuffer->insert_with_tag(pTextBuffer->end(), buf.substr(3) + "\n", pTagWrap);
			ok = true;
			break;
		}
	}

	if (!ok) {
		pLabel->set_text("No information available");
		pTextView->set_sensitive(false);
	}

	show_all();
}

