Please follow the steps below if you have found an **issue with Passenger**, or would like to request a feature.

Post to [Stack Overflow](https://stackoverflow.com/questions/tagged/passenger) instead if you are not sure, or if you have a question about your configuration.

---

## Issue report

Fill in as much as possible so that we can understand, find and fix the problem.

**Are you sure this is a bug in Passenger?**
Please read our troubleshooting and debugging guides first:
https://www.phusionpassenger.com/library/admin/troubleshooting/
https://www.phusionpassenger.com/library/admin/

**Please try with the newest version of Passenger to avoid issues that have already been fixed**

**Question 1: What is the problem?**
- What is the expected behavior?
- What is the actual behavior?
- How can we reproduce it? Please try to provide a sample application (or Virtual Machine) demonstrating the issue. Otherwise, if we can't reproduce it, we might have to ask you a number of followup questions or run certain commands to try and figure out the problem.

Be as detailed as possible in your descriptions, include any logs and stack traces (don't just cut/paste the error, provide some logging before that too).

(if you are requesting a feature instead of reporting an issue, describe here what you have in mind and how it would help you)

Your answer:

**Question 2: Passenger version and integration mode**:
- For example: open source 5.0.26 standalone; enterprise 5.0.21/nginx

Your answer:

**Question 3: OS or Linux distro, platform (including version)**:
- For example: Debian 8, x86_64 or OS X 10.10 Yosemite, x86_64

Your answer:

**Question 4: Passenger installation method**:

Your answer:
[ ] RubyGems + Gemfile
[ ] RubyGems, no Gemfile
[ ] Phusion APT repo
[ ] Phusion YUM repo
[ ] OS X Homebrew
[ ] source tarball
[ ] Other, please specify:

**Question 5: Your app's programming language (including any version managers) and framework (including versions)**:
- For example: Ruby 2.3.0, RVM, Rails 5.0.0; Node.js 4.0.0 with Express 4.13.4

Your answer:

**Question 6: Are you using a PaaS and/or containerization? If so which one?**
- For example: Heroku, Amazon Container Services, Docker 1.9 with an image based on passenger-docker

Your answer:

**Question 7: Anything else about your setup that we should know?**

Your answer:

---

We strive for quality and appreciate you taking the time to submit a report! Please note that if you want guaranteed response times and priority issue support we encourage you to join our [enterprise customer](https://www.phusionpassenger.com/features#premium-features) base. They also provide us with the means to continue our high level of open source support!
