
/*
 * Funzioni di interfaccia ncurses
 */

#include "ncgui.h"

#include <string.h>
#include <stdlib.h>

void wnd_clear ( WINDOW* wnd, const char* title ) {
	wclear ( wnd );
	wnd_border ( wnd );
	wattron ( wnd, A_BOLD );
	mvwaddstr ( wnd, 0,2, title );
	wattroff ( wnd, A_BOLD );
}

void wnd_border ( WINDOW* wnd ) {
	wborder ( wnd, 0, 0, 0, 0, 0, 0, 0, 0 );
}

void wnd_prompt ( WINDOW* wnd, int y, int x, char* buf, int buflen ) {
	/*
	if ( strlen(regexps) )
		strncpy ( *buf, regexps, strlen(regexps) );
	else
	*/
		memset ( buf, 0, buflen );
	
	mvwaddstr ( wnd, y, x, buf );
	mvwgetnstr ( wnd, y, x, buf, buflen ); 
}

