[:octicons-file-code-24:][_b64]{: .source-link }

# B64

## Overview

B64 allows for the embedding of local PNG, JPEG, and GIF image references with base64 encoding.  It simply needs a base
path to resolve relative links in the Markdown source. The base path is the assumed location of the Markdown source at
time of conversion. Using the base path, B64 will search and find the actual `img` tag references (both absolute and
relative) and base64 encode and embed them in the HTML output.

If you would like to distribute a Markdown output without having to also distribute the images separately, B64 can help.
In a normal website, this would probably not be desired.

!!! example "B64 Example"

    === "HTML"
        ```html
        <p><img alt="picture" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHgAAAB4CAMAAAAOusbgAAAAqFBMVEU5eZdll66Yucjd7h7d7h7d7h5ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll65ll66YuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYuciYucgXVONTAAABDklEQVRoge3XR3ICQRBE0b/Ce2+FAAnkLeb+N9MRNBvFR0H2vuJFT3dX5VAqV6q1eqPZane6vf5gOBpPprP5YnnD72t1u95s7+53+4fHp+eX17f3j8+v78PxdC5Qi+SWkNwykltBcqtIbg3JrSO5DSS3ieS2kNw2kttBcrtIbg/J7SO5AyR3iOSOkNwxkjtBcqdI7gzJnSO5CyR3WaD0T1xrv3Hjxo0bN27cuHHjxo0bN27c63Sx9ov1nbHOF+teYd1nrHeE9X6x+gZWv8Lqk1j9GWsuYM0jrDmINX+x5j5W3sDKOVj5CivXYeVJrByLlZ+xcnuB0n/5vxA3bty4cePGjRs3bty4cePGvUj3B2JzyvcNRmTGAAAAAElFTkSuQmCC" />
        ```

    === "Markdown"
        ```
        ![picture](../_assets/bg.png)
        ```

The B64 extension can be included in Python Markdown by using the following:

```py3
import markdown
md = markdown.Markdown(extensions=['pymdownx.b64'])
```

## Options

Option      | Type   | Default     | Description
----------- | ------ | ----------- |------------
`base_path` | string | `#!py3 '.'` | A string indicating a base path to be used to resolve relative links.
