# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.desktopvirtualization import DesktopVirtualizationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDesktopVirtualizationMgmtScalingPlansOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DesktopVirtualizationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.scaling_plans.get(
            resource_group_name=resource_group.name,
            scaling_plan_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create(self, resource_group):
        response = self.client.scaling_plans.create(
            resource_group_name=resource_group.name,
            scaling_plan_name="str",
            scaling_plan={
                "location": "str",
                "timeZone": "str",
                "description": "str",
                "etag": "str",
                "exclusionTag": "str",
                "friendlyName": "str",
                "hostPoolReferences": [{"hostPoolArmPath": "str", "scalingPlanEnabled": bool}],
                "hostPoolType": "Pooled",
                "id": "str",
                "identity": {"principalId": "str", "tenantId": "str", "type": "SystemAssigned"},
                "kind": "str",
                "managedBy": "str",
                "name": "str",
                "objectId": "str",
                "plan": {"name": "str", "product": "str", "publisher": "str", "promotionCode": "str", "version": "str"},
                "schedules": [
                    {
                        "daysOfWeek": ["str"],
                        "name": "str",
                        "offPeakLoadBalancingAlgorithm": "str",
                        "offPeakStartTime": {"hour": 0, "minute": 0},
                        "peakLoadBalancingAlgorithm": "str",
                        "peakStartTime": {"hour": 0, "minute": 0},
                        "rampDownCapacityThresholdPct": 0,
                        "rampDownForceLogoffUsers": bool,
                        "rampDownLoadBalancingAlgorithm": "str",
                        "rampDownMinimumHostsPct": 0,
                        "rampDownNotificationMessage": "str",
                        "rampDownStartTime": {"hour": 0, "minute": 0},
                        "rampDownStopHostsWhen": "str",
                        "rampDownWaitTimeMinutes": 0,
                        "rampUpCapacityThresholdPct": 0,
                        "rampUpLoadBalancingAlgorithm": "str",
                        "rampUpMinimumHostsPct": 0,
                        "rampUpStartTime": {"hour": 0, "minute": 0},
                    }
                ],
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.scaling_plans.delete(
            resource_group_name=resource_group.name,
            scaling_plan_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.scaling_plans.update(
            resource_group_name=resource_group.name,
            scaling_plan_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.scaling_plans.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription(self, resource_group):
        response = self.client.scaling_plans.list_by_subscription(
            api_version="2024-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_host_pool(self, resource_group):
        response = self.client.scaling_plans.list_by_host_pool(
            resource_group_name=resource_group.name,
            host_pool_name="str",
            api_version="2024-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
