% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlink2.R
\name{unlink2}
\alias{unlink2}
\title{Safe file deletion}
\usage{
unlink2(x, recursive = TRUE, force = TRUE, ...)
}
\arguments{
\item{x, recursive, force, ...}{Further arguments to pass to \code{\link{unlink}}.}
}
\value{
Either all \code{x} are successfully deleted or an error is raised.
\code{NULL} is invisibly returned.
}
\description{
Delete files or directories with an error message if it does not succeed.
}
\details{
This is primarily necessary to avoid incomprehensible errors when 
a directory containing a stale environment or installation is not successfully deleted.
We set \code{recursive=TRUE} by default for convenience;
we also set \code{force=TRUE} by default to avoid difficulties due to rogue permissions.
}
\examples{
out <- tempfile()
unlink2(out) # no error from deleting non-existent file.

write(file=out, "whee")
unlink2(out)

}
\seealso{
\code{\link{dir.create2}}, for a similarly safe directory creation function.
}
