% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveHDF5MultiAssayExperiment.R
\name{HDF5MultiAssayExperiment}
\alias{HDF5MultiAssayExperiment}
\alias{saveHDF5MultiAssayExperiment}
\alias{loadHDF5MultiAssayExperiment}
\title{Save a MultiAssayExperiment class object to HDF5 and Rds files}
\usage{
saveHDF5MultiAssayExperiment(
  x,
  dir = "h5_mae",
  prefix = NULL,
  replace = FALSE,
  chunkdim = NULL,
  level = NULL,
  as.sparse = NA,
  verbose = NA
)

loadHDF5MultiAssayExperiment(dir = "h5_mae", prefix = NULL)
}
\arguments{
\item{x}{A \code{\link{MultiAssayExperiment}} object or derivative}

\item{dir}{The path (as a single string) to the directory where to save the
HDF5-based \code{\link{MultiAssayExperiment}} object or to load it from.

When saving, the directory will be created if it doesn't already exist.
If the directory already exists and no prefix is specified and
\code{replace} is set to \code{TRUE}, then it's replaced with an
empty directory.}

\item{prefix}{An optional prefix to add to the names of the files created
inside \code{dir}. This allows saving more than one object in the same
directory. When the prefix is \code{NULL}, the name of the \code{x} input
\code{MultiAssayExperiment} is used. To avoid the default setting
use an empty character string i.e., \code{""}. An underscore (\verb{_}) is
appended to the prefix when provided; therefore, typical inputs should be
words, e.g., "test".}

\item{replace}{
    When no prefix is specified, should a pre-existing directory be replaced
    with a new empty one? The content of the pre-existing directory will
    be lost!
  }

\item{chunkdim, level}{
    The dimensions of the chunks and the compression level to use for
    writing the assay data to disk.

    Passed to the internal calls to \code{writeHDF5Array}.
    See \code{?\link[HDF5Array]{writeHDF5Array}} for more information.
  }

\item{as.sparse}{
    Whether the assay data should be flagged as sparse or not. If set to
    \code{NA} (the default), then the specific \code{as.sparse} value to
    use for each assay is determined by calling \code{is_sparse()} on them.

    Passed to the internal calls to \code{writeHDF5Array}.
    See \code{?\link[HDF5Array]{writeHDF5Array}} for more information and an
    IMPORTANT NOTE.
  }

\item{verbose}{Set to \code{TRUE} to make the function display progress.

In the case of \code{saveHDF5MultiAssayExperiment()}, \code{verbose}
is set to \code{NA} by default, in which case verbosity is controlled
by \code{DelayedArray.verbose.block.processing} option. Setting
\code{verbose} to \code{TRUE} or \code{FALSE} overrides the option.}
}
\value{
\itemize{
\item \code{saveHDF5MultiAssayExperiment}: saves an \code{Rds} and \code{h5} file to a
directory from the input \code{MultiAssayExperiment}
\item \code{loadHDF5MultiAssayExperiment}: a \code{MultiAssayExperiment} object loaded
from a folder as saved by \code{saveHDF5MultiAssayExperiment}
}
}
\description{
This function takes a \code{MultiAssayExperiment} object and uses the \code{assays}
functionality to obtain data matrices out of the experiments. These are
then saved into the \code{.h5} file format. This function relies heavily on
the \code{HDF5Array} package whose installation is required before use.
\code{saveHDF5MultiAssayExpeirment} preserves the classes contained in the
\code{\link{ExperimentList}} with the exception of \code{matrix} which is
converted to \code{HDF5Matrix}. Internal \code{SummarizedExperiment} assays are
converted to HDF5-backed assays as in
\code{HDF5Array::saveHDF5SummarizedExperiment}. \code{SummarizedExperiment}
objects with multiple \code{i}-th assays will have the first assay take
precedence and others assays will be dropped with a warning.
If the first assay in a \code{SummarizedExperiment} contains an array,
the array is preserved in the process of saving and loading the
HDF5-backed \code{MultiAssayExperiment}.
}
\examples{

data("miniACC")

testDir <- file.path(tempdir(), "test_mae")

saveHDF5MultiAssayExperiment(
    miniACC, dir = testDir, verbose = TRUE, replace = TRUE
)

## inspect the files in the dir
list.files(testDir)

loadHDF5MultiAssayExperiment(
    dir = testDir
)

## remove example files
unlink(testDir, recursive = TRUE)

}
