% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/104-getDrugKEGG.R
\name{getMolFromKEGG}
\alias{getMolFromKEGG}
\title{Retrieve Drug Molecules in MOL Format from the KEGG Database}
\usage{
getMolFromKEGG(id, parallel = 5)
}
\arguments{
\item{id}{A character vector, as the KEGG drug ID.}

\item{parallel}{An integer, the parallel parameter, indicates how many
process the user would like to use for retrieving
the data (using RCurl), default is \code{5}.
For regular cases, we recommend a number less than \code{20}.}
}
\value{
A length of \code{id} character vector,
each element containing the corresponding drug molecule.
}
\description{
Retrieve Drug Molecules in MOL Format from the KEGG Database
}
\details{
This function retrieves drug molecules in MOL format from the KEGG database.
}
\examples{
id = 'D00496'  # Penicillamine
\donttest{
getMolFromKEGG(id)}
}
\seealso{
See \code{\link{getSmiFromKEGG}} for retrieving drug molecules
in SMILES format from the KEGG database.
}
