% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePerCellDF.R
\name{makePerCellDF}
\alias{makePerCellDF}
\title{Create a per-cell data.frame}
\usage{
makePerCellDF(
  x,
  features = NULL,
  assay.type = "logcounts",
  use.coldata = TRUE,
  use.dimred = TRUE,
  use.altexps = TRUE,
  prefix.altexps = FALSE,
  check.names = FALSE,
  swap.rownames = NULL,
  exprs_values = NULL,
  use_dimred = NULL,
  use_altexps = NULL,
  prefix_altexps = NULL,
  check_names = NULL
)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object.
This is expected to have non-\code{NULL} row names.}

\item{features}{Character vector specifying the features for which to extract expression profiles across cells.
May also include features in alternative Experiments if permitted by \code{use.altexps}.}

\item{assay.type}{String or integer scalar indicating the assay to use to obtain expression values.
Must refer to a matrix-like object with integer or numeric values.}

\item{use.coldata}{Logical scalar indicating whether column metadata of \code{x} should be included.
Alternatively, a character or integer vector specifying the column metadata fields to use.}

\item{use.dimred}{Logical scalar indicating whether data should be extracted for dimensionality reduction results in \code{x}.
Alternatively, a character or integer vector specifying the dimensionality reduction results to use.}

\item{use.altexps}{Logical scalar indicating whether (meta)data should be extracted for alternative experiments in \code{x}.
Alternatively, a character or integer vector specifying the alternative experiments to use.}

\item{prefix.altexps}{Logical scalar indicating whether \code{\link{altExp}}-derived fields should be prefixed with the name of the alternative Experiment.}

\item{check.names}{Logical scalar indicating whether column names of the output should be made syntactically valid and unique.}

\item{swap.rownames}{String specifying the \code{\link{rowData}} column containing the \code{features}.
If \code{NULL}, \code{rownames(x)} is used.}

\item{exprs_values, use_dimred, use_altexps, prefix_altexps, check_names}{Soft-deprecated equivalents of the arguments described above.}
}
\value{
A data.frame containing one field per aspect of data in \code{x} - see Details.
Each row corresponds to a cell (i.e., column) of \code{x}.
}
\description{
Create a per-cell data.frame (i.e., where each row represents a cell) from a \linkS4class{SingleCellExperiment},
most typically for creating custom \pkg{ggplot2} plots.
}
\details{
This function enables us to conveniently create a per-feature data.frame from a \linkS4class{SingleCellExperiment}.
Each row of the returned data.frame corresponds to a column in \code{x},
while each column of the data.frame corresponds to one aspect of the (meta)data in \code{x}.

Columns are provided in the following order:
\enumerate{
\item Columns named according to the entries of \code{features} represent the expression values across cells for the specified feature in the \code{assay.type} assay.
\item Columns named according to the columns of \code{colData(x)} represent column metadata variables.
This consists of all variables if \code{use.coldata=TRUE}, no variables if \code{use.coldata=FALSE},
and only the specified variables if \code{use.coldata} is set to an integer or character vector.
\item Columns named in the format of \code{<DIM>.<NUM>} represent the \code{<NUM>}th dimension of the dimensionality reduction result \code{<DIM>}.
This is generated for all dimensionality reduction results if \code{use.dimred=TRUE}, none if \code{use.dimred=FALSE},
and only the specified results if \code{use.dimred}is set to an integer or character vector.
\item Columns named according to the row names of successive alternative Experiments,
representing the assay data in these objects.
These columns are only included if they are specified in \code{features} and if \code{use.altexps} is set.
Column names are prefixed with the name of the alternative Experiment if \code{prefix.altexps=TRUE}.
}

By default, nothing is done to resolve syntactically invalid or duplicated column names.
\code{check_names=TRUE}, this is resolved by passing the column names through \code{\link{make.names}}.
Of course, as a result, some columns may not have the same names as the original fields in \code{x}.
}
\examples{
sce <- mockSCE()
sce <- logNormCounts(sce)
reducedDim(sce, "PCA") <- matrix(rnorm(ncol(sce)*10), ncol=10) # made-up PCA.

df <- makePerCellDF(sce, features="Gene_0001")
head(df)

}
\seealso{
\code{\link{makePerFeatureDF}}, for the feature-level equivalent.
}
\author{
Aaron Lun
}
