% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproducible-output.R
\name{local_reproducible_output}
\alias{local_reproducible_output}
\title{Control common output options}
\usage{
local_reproducible_output(
  width = 80,
  color = FALSE,
  unicode = FALSE,
  hyperlinks = FALSE,
  rstudio = FALSE,
  frame = parent.frame()
)
}
\arguments{
\item{width}{Value of the \code{"width"} option.}

\item{color}{Determines whether or not cli/crayon colour should be used.}

\item{unicode}{Should we use unicode characaters where possible?}

\item{hyperlinks}{Should we use ANSI hyperlinks?}

\item{rstudio}{Should we pretend that we're running inside of RStudio?}

\item{frame}{Scope of the changes; when this calling frame terminates the
changes will be undone. For expert use only.}
}
\description{
Often when using \code{evaluate()} you are running R code with a specific output
context in mind. But there are many options and env vars that packages
will take from the current environment, meaning that output depends on
the current state in undesirable ways.

This function allows you to describe the characteristics of the desired
output and takes care of setting the options and environment variables
for you.
}
