% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_comparisons.R
\name{pool_comparisons}
\alias{pool_comparisons}
\title{Pool contrasts and comparisons from \code{hypothesis_test()}}
\usage{
pool_comparisons(x, ...)
}
\arguments{
\item{x}{A list of \code{ggcomparisons} objects, as returned by \code{\link[=hypothesis_test]{hypothesis_test()}}.}

\item{...}{Currently not used.}
}
\value{
A data frame with pooled comparisons or contrasts of predictions.
}
\description{
This function "pools" (i.e. combines) multiple \code{ggcomparisons} objects, returned
by \code{\link[=hypothesis_test]{hypothesis_test()}}, in a similar fashion as \code{\link[mice:pool]{mice::pool()}}.
}
\details{
Averaging of parameters follows Rubin's rules (\emph{Rubin, 1987, p. 76}).
}
\examples{
\dontshow{if (require("mice")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("nhanes2", package = "mice")
imp <- mice::mice(nhanes2, printFlag = FALSE)
comparisons <- lapply(1:5, function(i) {
  m <- lm(bmi ~ age + hyp + chl, data = mice::complete(imp, action = i))
  hypothesis_test(m, "age")
})
pool_comparisons(comparisons)
\dontshow{\}) # examplesIf}
}
\references{
Rubin, D.B. (1987). Multiple Imputation for Nonresponse in Surveys. New York:
John Wiley and Sons.
}
