% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_bin.R
\name{compute_bin}
\alias{compute_bin}
\title{Bin data along a continuous variable}
\usage{
compute_bin(x, x_var, w_var = NULL, width = NULL, center = NULL,
  boundary = NULL, closed = c("right", "left"), pad = FALSE,
  binwidth)
}
\arguments{
\item{x}{Dataset-like object to bin. Built-in methods for data frames,
grouped data frames and ggvis visualisations.}

\item{x_var, w_var}{Names of x and weight variables. The x variable must be
continuous.}

\item{width}{The width of the bins. The default is \code{NULL}, which yields
30 bins that cover the range of the data. You should always override this
value, exploring multiple widths to find the best to illustrate the stories
in your data.}

\item{center}{The center of one of the bins.  Note that if center is above or
below the range of the data, things will be shifted by an appropriate
number of \code{width}s. To center on integers, for example, use
\code{width=1} and \code{center=0}, even if \code{0} is outside the range
of the data.  At most one of \code{center} and \code{boundary} may be
specified.}

\item{boundary}{A boundary between two bins. As with \code{center}, things
are shifted when \code{boundary} is outside the range of the data. For
example, to center on integers, use \code{width = 1} and \code{boundary =
0.5}, even if \code{1} is outside the range of the data.  At most one of
\code{center} and \code{boundary} may be specified.}

\item{closed}{One of \code{"right"} or \code{"left"} indicating whether right
or left edges of bins are included in the bin.}

\item{pad}{If \code{TRUE}, adds empty bins at either end of x. This ensures
frequency polygons touch 0. Defaults to \code{FALSE}.}

\item{binwidth}{Deprecated; use \code{width} instead.}
}
\value{
A data frame with columns:
 \item{count_}{the number of points}
 \item{x_}{mid-point of bin}
 \item{xmin_}{left boundary of bin}
 \item{xmax_}{right boundary of bin}
 \item{width_}{width of bin}
}
\description{
Bin data along a continuous variable
}
\examples{
mtcars \%>\% compute_bin(~mpg)
mtcars \%>\% compute_bin(~mpg, width = 10)
mtcars \%>\% group_by(cyl) \%>\% compute_bin(~mpg, width = 10)

# It doesn't matter whether you transform inside or outside of a vis
mtcars \%>\% compute_bin(~mpg) \%>\% ggvis(~x_, ~count_) \%>\% layer_paths()
mtcars \%>\% ggvis(~ x_, ~ count_) \%>\% compute_bin(~mpg) \%>\% layer_paths()

# Missing values get own bin
mtcars2 <- mtcars
mtcars2$mpg[sample(32, 5)] <- NA
mtcars2 \%>\% compute_bin(~mpg, width = 10)

# But are currently silently dropped in histograms
mtcars2 \%>\% ggvis() \%>\% layer_histograms(~mpg)
}
\seealso{
\code{\link{compute_count}} For counting cases at specific locations
  of a continuous variable. This is useful when the variable is continuous
  but the data is granular.
}
