% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-method.R
\name{req_method}
\alias{req_method}
\title{Set HTTP method in request}
\usage{
req_method(req, method)
}
\arguments{
\item{req}{A \link{request}.}

\item{method}{Custom HTTP method}
}
\value{
A modified HTTP \link{request}.
}
\description{
Use this function to use a custom HTTP method like \code{HEAD},
\code{DELETE}, \code{PATCH}, \code{UPDATE}, or \code{OPTIONS}. The default method is
\code{GET} for requests without a body, and \code{POST} for requests with a body.
}
\examples{
request(example_url()) |> req_method("PATCH")
request(example_url()) |> req_method("PUT")
request(example_url()) |> req_method("HEAD")
}
