test_that(".factor_to_numeric", {
  f <- c(0, 0, 1, 1, 1, 0)
  x1 <- factor(f, levels = c(0, 1), labels = c("a", "b"))
  x2 <- factor(f, levels = c(1, 0), labels = c("b", "a"))
  x3 <- factor(f, levels = c(1, 0), labels = c("a", "b"))
  x4 <- factor(f, levels = c(0, 1), labels = c("b", "a"))
  out1 <- insight:::.factor_to_numeric(x1, lowest = 0)
  out2 <- insight:::.factor_to_numeric(x2, lowest = 0)
  out3 <- insight:::.factor_to_numeric(x3, lowest = 0)
  out4 <- insight:::.factor_to_numeric(x4, lowest = 0)
  expect_identical(out1, c(0, 0, 1, 1, 1, 0))
  expect_identical(out2, c(1, 1, 0, 0, 0, 1))
  expect_identical(out1, out4)
  expect_identical(out2, out3)

  x1 <- factor(f, levels = c(0, 1))
  x2 <- factor(f, levels = c(1, 0))
  out1 <- insight:::.factor_to_numeric(x1, lowest = 0)
  out2 <- insight:::.factor_to_numeric(x2, lowest = 0)
  expect_identical(out1, c(0, 0, 1, 1, 1, 0))
  expect_identical(out2, c(1, 1, 0, 0, 0, 1))

  f <- c(1, 1, 2, 2, 2, 1)
  x1 <- factor(f, levels = c(1, 2))
  x2 <- factor(f, levels = c(2, 1))
  out1 <- insight:::.factor_to_numeric(x1, lowest = 0)
  out2 <- insight:::.factor_to_numeric(x2, lowest = 0)
  expect_identical(out1, c(0, 0, 1, 1, 1, 0))
  expect_identical(out2, c(1, 1, 0, 0, 0, 1))
  out1 <- insight:::.factor_to_numeric(x1)
  out2 <- insight:::.factor_to_numeric(x2)
  expect_identical(out1, c(1, 1, 2, 2, 2, 1))
  expect_identical(out2, c(2, 2, 1, 1, 1, 2))
})
